/***************************************************************************
                            KStdGuiItem.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

public class  KStdGuiItem implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KStdGuiItem(Class dummy){}

	public static native KGuiItem guiItem( int ui_enum);
	public static native String stdItem( int ui_enum);
	public static native KGuiItem ok();
	public static native KGuiItem cancel();
	public static native KGuiItem yes();
	public static native KGuiItem no();
	public static native KGuiItem discard();
	public static native KGuiItem save();
	public static native KGuiItem help();
	public static native KGuiItem dontSave();
	public static native KGuiItem saveAs();
	public static native KGuiItem apply();
	public static native KGuiItem clear();
	public static native KGuiItem defaults();
	public static native KGuiItem close();

/** 
 Return a GUI item for a 'back' action, like Konqueror's back button.
 This GUI item can optionally honour the user's setting for BiDi, so the
 icon for right-to-left languages (Hebrew and Arab) has the arrow
 pointing in the opposite direction.
 By default the arrow points in the Western 'back' direction (i.e.
 to the left). This is because usually you only want the Bidi aware
 GUI item if you also want the 'forward' item. Those two are available
 in the separate {@link #backAndForward} method.
     
*/
	public static native KGuiItem back( int useBidi);
	public static native KGuiItem back();

/** 
 Return a GUI item for a 'forward' action, like Konqueror's forward
 button. This GUI item can optionally honour the user's setting for BiDi,
 so the icon for right-to-left languages (Hebrew and Arab) has the arrow
 pointing in the opposite direction.
 By default the arrow points in the Western 'forward' direction (i.e.
 to the right). This is because usually you only want the Bidi aware
 GUI item if you also want the 'back' item. Those two are available
 in the separate {@link #backAndForward} method.
     
*/
	public static native KGuiItem forward( int useBidi);
	public static native KGuiItem forward();

/** 
 Return both a back and a forward item. This function always returns
 items that are aware of the Right-to-Left setting for Arab and Hebrew
 locales. If you have a reason for wanting the 'Western' back/forward
 buttons, please use the {@link #back} and {@link #forward} items instead.
     
*/
//	public static native QPair<KGuiItem,KGuiItem> backAndForward();
	public static final int UseRTL = 0;
	public static final int IgnoreRTL = 0;
	public static final int Ok = 1;
	public static final int Cancel = 0;
	public static final int Yes = 1;
	public static final int No = 2;
	public static final int Discard = 3;
	public static final int Save = 4;
	public static final int DontSave = 5;
	public static final int SaveAs = 6;
	public static final int Apply = 7;
	public static final int Clear = 8;
	public static final int Help = 9;
	public static final int Defaults = 10;
	public static final int Close = 11;
	public static final int Back = 12;
	public static final int Forward = 13;
}
