/***************************************************************************
                            DockMainWindow.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DOCKMAINWINDOW_H
#define DOCKMAINWINDOW_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KDockMainWindow.h>
#include <kdeobjc/PartBase.h>

/**

 A KPart-aware main window with ability for docking widgets, whose user interface is described in XML.

 Inherit your main dock-window from this class
 and don't forget to call @ref -setXMLFile in the inherited constructor.

 It implements all internal interfaces in the case of a @ref KDockMainWindow as host:
 the builder and servant interface (for menu merging).
 
 @short 
 A KPart-aware main window with ability for docking widgets, whose user interface is described in XML.
*/

@class Part;

@interface DockMainWindow : KDockMainWindow

/** 
 Constructor, same signature as @ref KDockMainWindow.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name f: (int)f;
- init;

/** 
 Destructor.
   
*/
- (void) dealloc;
- createShellGUI: (BOOL)create;
- createShellGUI;

/** 
 Create the GUI (by merging the host's and the active part's)

 Called on startup and whenever the active part changes
 For this you need to connect this slot to the
 @ref -[KPartManager activePartChanged] signal

*/
- createGUI: (Part*)part;

/** 
 Called when the active part wants to change the statusbar message
 Reimplement if your dock-mainwindow has a complex statusbar
 (with several items)
   
*/
- slotSetStatusBarText: (NSString *)arg1;
@end

@interface DockMainWindow (PartBaseImplementation) <PartBaseInterface>
@end

/** Override these methods in subclasses of DockMainWindow to customise event handling behaviour */
@protocol DockMainWindowEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) e;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Reimplemented to call the -queryClose and -queryExit handlers.

 We recommend that you reimplement the handlers rather than @ref -closeEvent.
 If you do it anyway, ensure to call the base implementation to keep
 @ref -queryExit running.
     
*/
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) e;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
