/***************************************************************************
                            NoteArray.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef NOTEARRAY_H
#define NOTEARRAY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Holds a resizeable array of note on/off and patch change events. It can
 increase it size, but it doesn't decreases (until destruction :-) )

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Stores an array of note on/off events.
*/

@interface  NoteArray : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Constructor. Initializes internal variables.
   
*/
- init;

/** 
 Destructor.
   
*/
- (void) dealloc;

/** 
 Adds (or modifies) an event in the given position . 

 Note that this has nothing to do with what is being played, this just
 modifies an internal array.
   
*/
- at: (unsigned long)pos ms: (unsigned long)ms chn: (int)chn cmd: (int)cmd note: (int)note;

/** 
 A convenience function, which differs from the above in the parameters
 it accepts.
   
*/
//- at: (unsigned long)pos s: (noteCmd*)s;

/** 
 Returns the note event at a given position.
   
*/
//- (noteCmd*) at: (int)pos;

/** 
 Adds a note/patch event at a given millisecond.

 Note: This method always appends at the end of the list.
   
*/
- add: (unsigned long)ms chn: (int)chn cmd: (int)cmd note: (int)note;

/** 
 Initializes the iterator.

*/
- iteratorBegin;

/** 
 Get the command currently pointed to by the iterator.
   
*/
//- (noteCmd*) get;

/** 
 Advances the iterator to the next position.
   
*/
- next;

/** 
 Calls @ref  #--next until the next event is over ms milliseconds
 and puts in @p pgm[16] the instruments used at this moment.
   
*/
- moveIteratorTo: (unsigned long)ms pgm: (int*)pgm;
//- moveIteratorTo: (unsigned long)ms ;
@end

#endif
