#ifndef BUGCACHE_H
#define BUGCACHE_H

class KSimpleConfig;

#include "package.h"
#include "bug.h"
#include "bugdetails.h"

class BugCache
{
    public:
        BugCache();
        ~BugCache();

        void savePackageList( const Package::List &pkgs );
        Package::List loadPackageList();
        void invalidatePackageList();

        void saveBugList( const Package &pkg, const Bug::List & );
        Bug::List loadBugList( const Package &pkg, bool disconnected );
        void invalidateBugList( const Package &pkg );

        void saveBugDetails( const Bug &bug, const BugDetails & );
        BugDetails loadBugDetails( const Bug &bug );
        void invalidateBugDetails( const Bug &bug );

    private:
        void writePerson( KSimpleConfig *file, const QString &key,
                          const Person &p );
        struct Person readPerson (KSimpleConfig *file, const QString &key );

        KSimpleConfig *m_cachePackages;
        KSimpleConfig *m_cacheBugs;
};

#endif
