/***************************************************************************
                       kbbmainwindow.h  -  description
                             -------------------
    begin                : zo mrt 18 17:12:24 CET 2001
    copyright            : (C) 2001 by Martijn Klingens
    email                : mklingens@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBBMAINWINDOW_H
#define KBBMAINWINDOW_H


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>
#include <qmap.h>

#include "package.h"
#include "bug.h"
#include "bugdetails.h"

class KAction;
class KToggleAction;
class QLabel;
class QListViewItem;
class QProgressBar;
class PreferencesDialog;

namespace KBugBusterMainWindow
{
    class CentralWidget;
}

/**
 * @author Martijn Klingens
 */
class KBBMainWindow : public KMainWindow
{
    Q_OBJECT

public:
    /**
     * construtor of KBugBusterApp, calls all init functions to create the application.
     */
    KBBMainWindow( const QCString& initialPackage = "", const QCString& initialBug = "",
                   QWidget* parent = 0, const char* name = 0 );
    ~KBBMainWindow();

public slots:
    /**
     * Event handlers for our KActions
     */
    void slotViewShowToolBar();
    void slotViewShowStatusBar();
    void slotStatusMsg( const QString &text );
    void slotDisconnectedAction();
    void slotSubmit();
    void slotListChanges();
    void slotSetPercent( unsigned long percent );

    /**
     * Other event handlers
     */

    void searchPackage();
    void searchBugNumber();
    void searchDescription();

    void preferences();

protected:
    virtual bool queryClose();

private:
    void initActions();

    /**
     * Our main widget
     */
    KBugBusterMainWindow::CentralWidget *m_mainWidget;

    /**
     * Used KActions
     */
    KAction*       fileQuit;
    KToggleAction* viewShowToolBar;
    KToggleAction* viewShowStatusBar;
    KToggleAction *m_disconnectedAction;

    /**
     * Status bar label. We need this, because the default Qt version doesn't
     * support rich text in the messages
     */
    QLabel *m_statusLabel;
    QProgressBar *m_progressBar;

    PreferencesDialog *mPreferencesDialog;
};

#endif // KMAKE_H

/* vim: set et ts=4 softtabstop=4 sw=4: */

