/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import javax.swing.colorchooser.SyntheticImageGenerator;

abstract class SyntheticImage
implements ImageProducer {
    private SyntheticImageGenerator root;
    protected int width = 10;
    protected int height = 100;
    static final ColorModel cm = ColorModel.getRGBdefault();
    public static final int pixMask = 255;
    private Thread runner;
    protected volatile boolean aborted = false;

    protected SyntheticImage() {
    }

    protected SyntheticImage(int n2, int n3) {
        this.width = n2;
        this.height = n3;
    }

    protected void computeRow(int n2, int[] nArray) {
        int n3 = 255 - 255 * n2 / (this.height - 1);
        n3 = 0xFF000000 | n3 << 16 | n3 << 8 | n3;
        int n4 = nArray.length;
        while (--n4 >= 0) {
            nArray[n4] = n3;
        }
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                return;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
        this.root = new SyntheticImageGenerator(imageConsumer, this.root, this);
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                return true;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
        return false;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        Object var2_2 = null;
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                syntheticImageGenerator.useful = false;
                if (var2_2 != null) {
                    var2_2.next = syntheticImageGenerator.next;
                } else {
                    this.root = syntheticImageGenerator.next;
                }
                return;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
    }

    public synchronized void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.useful && !syntheticImageGenerator.isAlive()) {
                syntheticImageGenerator.start();
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
    }

    protected boolean isStatic() {
        return true;
    }

    public void nextFrame(int n2) {
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }
}

