Name: docbook-dtd412-xml
Version: 1.0
Release: 1
Group: Applications/Text

Summary: XML document type definition for DocBook 4.1.2

License: Distributable
URL: http://www.oasis-open.org/docbook/

Provides: docbook-dtd-xml
Requires: sgml-common >= 0.5
Requires(post,postun): sgml-common >= 0.5 fileutils

BuildRoot: %{_tmppath}/%{name}-%{version}

BuildArch: noarch
Source0: http://www.oasis-open.org/docbook/xml/4.1.2/docbkx412.zip
Source1: %{name}-%{version}.Makefile
Patch0: %{name}-%{version}.catalog.patch
Patch1: %{name}-%{version}.dbcentx.patch
BuildRequires: unzip


%description
The DocBook Document Type Definition (DTD) describes the syntax of
technical documentation texts (articles, books and manual pages).
This syntax is XML-compliant and is developed by the OASIS consortium.
This is the version 4.1.2 of this DTD.


%prep
%setup -c -T
unzip %{SOURCE0}
if [ `id -u` -eq 0 ]; then
  chown -R root.root .
  chmod -R a+rX,g-w,o-w .
fi
cp %{SOURCE1} Makefile
#%patch0
#%patch1


%build


%install
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR
make install DESTDIR=$DESTDIR/usr/share/sgml/docbook/xml-dtd-4.1.2
ln -s catalog $DESTDIR/usr/share/sgml/docbook/xml-dtd-4.1.2/docbook.cat


%clean
DESTDIR=$RPM_BUILD_ROOT
rm -rf $DESTDIR


%files
%defattr (-,root,root)
%doc ChangeLog
%doc *.txt
/usr/share/sgml/docbook/xml-dtd-4.1.2


%post
# Update the centralized catalog corresponding to this version of the DTD
/usr/bin/install-catalog --add /etc/sgml/xml-docbook-4.1.2.cat /usr/share/sgml/sgml-iso-entities-8879.1986/catalog > /dev/null
/usr/bin/install-catalog --add /etc/sgml/xml-docbook-4.1.2.cat /usr/share/sgml/docbook/xml-dtd-4.1.2/catalog > /dev/null

# The following lines are for the case in which the style sheets
# were installed after another DTD but before this DTD
STYLESHEETS=$(echo /usr/share/sgml/docbook/dsssl-stylesheets-*)
STYLESHEETS=${STYLESHEETS##*/dsssl-stylesheets-}
if [ "$STYLESHEETS" != "*" ]; then
    /usr/bin/install-catalog --add /etc/sgml/xml-docbook-4.1.2.cat /usr/share/sgml/openjade-1.3/catalog > /dev/null
    /usr/bin/install-catalog --add /etc/sgml/xml-docbook-4.1.2.cat /usr/share/sgml/docbook/dsssl-stylesheets-$STYLESHEETS/catalog > /dev/null
fi

# Update the link to the current version of the DTD
ln -s -f /etc/sgml/xml-docbook-4.1.2.cat /etc/sgml/xml-docbook.cat


%postun
# Update the centralized catalog corresponding to this version of the DTD
/usr/bin/install-catalog --remove /etc/sgml/xml-docbook-4.1.2.cat /usr/share/sgml/sgml-iso-entities-8879.1986/catalog > /dev/null
/usr/bin/install-catalog --remove /etc/sgml/xml-docbook-4.1.2.cat /usr/share/sgml/docbook/xml-dtd-4.1.2/catalog > /dev/null

# The following lines are for the case in which the style sheets
# were not uninstalled because there is still another DTD
STYLESHEETS=$(echo /usr/share/sgml/docbook/dsssl-stylesheets-*)
STYLESHEETS=${STYLESHEETS##*/dsssl-stylesheets-}
if [ "$STYLESHEETS" != "*" ]; then
    /usr/bin/install-catalog --remove /etc/sgml/xml-docbook-4.1.2.cat /usr/share/sgml/openjade-1.3/catalog > /dev/null
    /usr/bin/install-catalog --remove /etc/sgml/xml-docbook-4.1.2.cat /usr/share/sgml/docbook/dsssl-stylesheets-$STYLESHEETS/catalog > /dev/null
fi

# Update the link to the current version of the DTD
if [ ! -e /etc/sgml/xml-docbook-4.1.2.cat ]; then
    rm -f /etc/sgml/xml-docbook.cat
    #OTHERCAT=`ls /etc/sgml/xml-docbook-?.?.cat 2> /dev/null | head --lines 1`
    OTHERCAT=`ls /etc/sgml/xml-docbook-?.*.cat 2> /dev/null | head --lines 1`
    if [ -n "$OTHERCAT" ]; then ln -s $OTHERCAT /etc/sgml/xml-docbook.cat; fi
fi

%changelog
* Tue Jun 12 2001 Tim Waugh <twaugh@redhat.com> 1.0-1
- Build for Red Hat Linux.

* Sat Jun 09 2001 Chris Runge <crunge@pobox.com>
- Provides: docbook-dtd-xml (not docbook-dtd-sgml)
- undo catalog patch and dbcentx patch (this resulted in an effectively
  broken DTD when the document was processed with XSL stylesheets); added a
  symbolic link to retain docbook.cat -> catalog; added ent
- added ChangeLog to doc

* Fri Jun 08 2001 Chris Runge <crunge@pobox.com>
- created a 4.1.2 version
- update required a change to OTHERCAT in postun
- update required a change to the Makefile patch (no dbgenent.ent any more,
  apparently)

* Wed Jan 24 2001 Tim Waugh <twaugh@redhat.com>
- Scripts require fileutils.
- Make scripts quieter.

* Mon Jan 15 2001 Tim Waugh <twaugh@redhat.com>
- Don't play so many macro games.
- Don't use 'rpm' in post scripts.
- Be sure to own xml-dtd-4.1 directory.

* Sun Jan 14 2001 Tim Waugh <twaugh@redhat.com>
- Change requirement on /usr/bin/install-catalog to sgml-common.

* Tue Jan 09 2001 Tim Waugh <twaugh@redhat.com>
- Change group.
- Use %%{_tmppath}.
- Correct typo.
- rm before install
- openjade not jade.
- Build requires unzip.
- Require install-catalog for post and postun.
- Change Copyright: to License:.
- Remove Packager: line.

* Tue Jan 09 2001 Tim Waugh <twaugh@redhat.com>
- Based on Eric Bischoff's new-trials packages.
