.ig
Copyright (C) 1989-1995, 2001 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.TH @G@TBL @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
@g@tbl \- format tables for troff
.SH SYNOPSIS
.B @g@tbl
[
.B \-Cv
]
[
.IR files \|.\|.\|.
]
.SH DESCRIPTION
This manual page describes the GNU version of
.BR tbl ,
which is part of the groff document formatting system.
.B tbl
compiles descriptions of tables embedded within
.B troff
input files into commands that are understood by
.BR troff .
Normally, it should be invoked using the
.B \-t
option of
.B groff.
It is highly compatible with Unix
.BR tbl .
The output generated by GNU
.B tbl
cannot be processed with Unix
.BR troff ;
it must be processed with GNU
.BR troff .
If no files are given on the command line, the standard input
will be read.
A filename of
.B \-
will cause the standard input to be read.
.SH OPTIONS
.TP
.B \-C
Recognize
.B .TS
and
.B .TE
even when followed by a character other than space or newline.
.TP
.B \-v
Print the version number.
.SH USAGE
Only the differences between GNU
.B tbl
and Unix
.B tbl
are described here.
.LP
Normally
.B tbl
attempts to prevent undesirable breaks in the table by using diversions.
This can sometimes interact badly with macro packages' own use of diversions,
when footnotes, for example, are used.
The
.B nokeep
option tells
.B tbl
not to try and prevent breaks in this way.
.LP
The
.B decimalpoint
option specifies the character to be recognized as the decimal
point character in place of the default period.
It takes an argument in parentheses, which must be a single
character, as for the
.B tab
option.
.LP
The
.B f
format modifier can be followed by an arbitrary length
font name in parentheses.
.LP
There is a
.B d
format modifier which means that a vertically spanning entry
should be aligned at the bottom of its range.
.LP
There is no limit on the number of columns in a table, nor any limit
on the number of text blocks.
All the lines of a table are considered in deciding column
widths, not just the first 200.
Table continuation
.RB ( .T& )
lines are not restricted to the first 200 lines.
.LP
Numeric and alphabetic items may appear in the same column.
.LP
Numeric and alphabetic items may span horizontally.
.LP
.B tbl
uses register, string, macro and diversion names beginning with
.BR 3 .
When using
.B tbl
you should avoid using any names beginning with a
.BR 3 .
.SH BUGS
You should use
.BR .TS\ H / .TH
in conjunction with a supporting macro package for
.I all
multi-page boxed tables.
If there is no header that you wish to appear at the top of each page
of the table, place the
.B .TH
line immediately after the format section.
Do not enclose a multi-page table within keep/release macros,
or divert it in any other way.
.LP
A text block within a table must be able to fit on one page.
.LP
The
.B bp
request cannot be used to force a page-break in a multi-page table.
Instead, define
.B BP
as follows
.IP
.B .de BP
.br
.B .ie '\e\en(.z'' .bp \e\e$1
.br
.B .el \e!.BP \e\e$1
.br
.B ..
.br
.LP
and use
.B BP
instead of
.BR bp .
.LP
Using \ea directly in a table to get leaders will not work.
This is correct behaviour: \ea is a
.B uninterpreted
leader.
To get leaders use a real leader, either by using a control A or like
this:
.IP
.nf
.ft B
\&.ds a \ea
\&.TS
tab(;);
lw(1i) l.
A\e*a;B
\&.TE
.ft
.fi
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@)
.
.\" Local Variables:
.\" mode: nroff
.\" End:
