/*****************************************************
 Header file for ICQ protocol structres and constants
 (c) 1999 Jeremy Wise
 GnomeICU
******************************************************/

#ifndef __GNOMEICU_H__
#define __GNOMEICU_H__

#include "common.h"

#include <gtk/gtktreestore.h>

typedef struct
{
	GladeXML *xml;
	GtkWidget *notebook;
	GtkWidget *head_online;
	GtkWidget *head_offline;
	GtkWidget *head_notinlist;
	GtkWidget *not_contents;
	GtkWidget *window;
	GtkTreeStore *contacts_store;
	GtkTreeStore *visible_store;
	GtkWidget *contacts_tree;
	GtkWidget *all_tree;
} _MainData;

extern _MainData *MainData;

extern GSList *Contacts;

extern DWORD our_ip;
extern DWORD our_port;
extern DWORD Current_Status;
extern gchar *passwd;
//extern gchar *server;
//extern DWORD remote_port;
extern gchar *Away_Message;
extern gboolean Done_Login;

extern _programs *programs;

extern gboolean search_in_progress;

extern gboolean is_new_user;
extern gboolean connection_alive;

//extern gint WindowWidth, WindowHeight; GCONF_PREFS
//extern gint WindowX, WindowY; GCONF_PREFS

extern gchar *configfilename;

extern gint tcp_gdk_input;

extern USER_INFO_PTR our_info;

extern GtkWidget *app;

extern gboolean enable_online_events;

extern gboolean webpresence;

extern int preset_status;

extern _toggles *toggles;

/* for server side contacts list */
extern guint16 status_uid;       /* for change status on server list */
extern gboolean sane_cl;         /* is the contact list sane? or checked? */
extern gboolean srvlist_exist;   /* server side list exist for this user? */
extern guint32 list_time_stamp;  /* time stamp of the list */
extern guint16 record_cnt;       /* record count */

extern GSList *Groups;

enum {
	ICON_COLUMN,
	NICKNAME_COLUMN,
	GID_COLUMN,
	UID_COLUMN,
	STATUS_COLUMN,
	CONTACT_COLUMN,
	N_COLUMNS
};

void create_tcp_line( void );
void ready_set( gboolean flash );
void init( void );
void about( GtkWidget *widget, gpointer data );
void go_url_home (void);
void go_url_updates (void);
void icq_quit( GtkWidget *widget, gpointer data );
void show_help (void);

#endif /* __GNOMEICU_H__ */
