/***************************************************************************
                            KPanelExtension.h -  description
                             -------------------
    begin                : Thu Mar 21 01:01:29 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Thu Mar 21 01:01:29 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPANELEXTENSION_H
#define KPANELEXTENSION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QFrame.h>

/**

 Implements a panel extension.

 Panel extensions

 Note: For security and stability reasons the panel won't load
 untrusted third party extensions directly into its namespace but via an
 external wrapper process.

 The panel locates available extensions by searching for extension desktop
 files in (ALL_KDEDIRS)/share/apps/kicker/extensions. Every panel extension should
 install a desktop file there to be recognised by the panel.

 Besides standard keys like "Name", "Comment" and "Icon" there are
 two panel extension specific keys:

 Used by the panel to locate the extension DSO (Dynamic Shared Object)
 Example: X-KDE-Library=libexampleextension

 Similar to @ref KApplication and @ref KUniqueApplication there are
 two types of panel extensions. Use unique extensions when it makes no
 sence to run more than one instance of an extension in the panel. A
 good example for unique extensions is the taskbar extension.  Use normal
 extensions when you need instance specific configuration. An example
 is a subpanel extension where you might want to run more than one instances.
 X-KDE-UniqueExtension is a boolean key which defaults
 to "false".  Example: X-KDE-UniqueExtension=true

 Back to panel extension DSOs, the following conventions are used for KDE:
 Name:    lib<extensionname>extension.la
 LDFLAGS: -module -no-undefined

 To implement a panel extension it is not enough to write a class
 inheriting from KPanelExtension but you also have to provide a
 factory function in your DSO.  A sample factory function could look
 like this:

 <pre>

 extern "C"
 {
     KPanelExtension* init(QWidget *parent, const QString& configFile)
     {
         -[KGlobal locale]->insertCatalogue("exampleextension");
         return new ExampleExtension(configFile, -[KPanelExtension Normal],
                       -[KPanelExtension About]| -[KPanelExtension Help]| -[KPanelExtension Preferences],
                       parent, "exampleextension");
     }
 }

 </pre>

 Note: Don't change the factory function signature or the panel will
 fail to load your extension.

 @author Matthias Elter <elter@kde.org>

 @short KDE Panel Extension class.
*/

@class KConfig;

@interface KPanelExtension : QFrame 

/** 
 Constructs a KPanelExtension just like any other widget.

*/
- initWithText: (NSString *)configFile t: (int)t actions: (int)actions parent: (QWidget *)parent name: (NSString *)name;
- initWithText: (NSString *)configFile ;

/** 
 Destructor.

*/
- (void) dealloc;

/** 
 Returns the prefered size for a given Position.

 Every extension should reimplement this function.

 Depending on the panel position the extensions can choose a prefered size for that
 location in the Window Manager Dock. Please note that the size can not be larger than the
 maxsize given by the handler.

*/
- (QSize*) sizeHint: (int)arg1 maxsize: (QSize *)maxsize;

/** 
 Always use this @ref KConfig object to save/load your extensions configuration.

 For unique extensions this config object will write to a config file called
 <extensionname>rc in the users local KDE directory.

 For normal extensions this config object will write to a instance specific config file
 called <extensionname><instanceid>rc in the users local KDE directory.

*/
- (KConfig*) config;

/** 

*/
- (int) type;

/** 

*/
- (int) actions;

/** 
 Generic action dispatcher. Called  when the user selects an item
 from the extensions RMB menu.

 Reimplement this function to handle actions.

 For About, Help, Preferences and ReportBug use the convenience handlers
 ref -about, -help, -preferences, -reportBug

*/
- action: (int)a;

/** 
 Reimplement this function to set a prefered dock position for your extension.
 The extension manager will try to place new instances of this extension according
 to this setting.

*/
- (int) preferedPosition;

/** 

*/
- setPosition: (int)p;

/** 

*/
- setAlignment: (int)a;

/** 
 Is called when the user selects "About" from the extensions RMB menu.
 Reimplement this function to launch a about dialog.

 Note that this is called only when your extension supports the About action.
 See @ref Action.

*/
- about;

/** 
 Is called when the user selects "Help" from the extensions RMB menu.
 Reimplement this function to launch a manual or help page.

 Note that this is called only when your extension supports the Help action.
 See @ref Action.

*/
- help;

/** 
 Is called when the user selects "Preferences" from the extensions RMB menu.
 Reimplement this function to launch a preferences dialog or kcontrol module.

 Note that this is called only when your extension supports the preferences action.
 See @ref Action.

*/
- preferences;

/** 
 Is called when the user selects "Report bug" from the applet's RMB menu.
 Reimplement this function to launch a bug reporting dialog.

 Note that this is called only when your applet supports the ReportBug
 action.
 See @ref Action.

*/
- reportBug;

/** 

*/
- (int) position;

/** 

*/
- (int) alignment;

/** 

*/
- (int) orientation;

/** 
 This extension has changed its position.
 Reimplement this change handler in order to adjust the look of your
 applet.

*/
- positionChange: (int)arg1;

/** 
 This extension has changed its alignment.
 Reimplement this change handler in order to adjust the look of your
 applet.

*/
- alignmentChange: (int)arg1;
- virtual_hook: (int)identifier data: (void*)data;
+ (int) Normal;
+ (int) Stretch;
+ (int) About;
+ (int) Help;
+ (int) Preferences;
+ (int) ReportBug;
+ (int) Left;
+ (int) Right;
+ (int) Top;
+ (int) Bottom;
+ (int) LeftTop;
+ (int) Center;
+ (int) RightBottom;
@end

/** Override these methods in subclasses of KPanelExtension to customise event handling behaviour */
@protocol KPanelExtensionEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
