//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#ifndef PMBICUBICPATCHEDIT_H
#define PMBICUBICPATCHEDIT_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "pmgraphicalobjectedit.h"

class PMBicubicPatch;
class PMVectorEdit;
class PMIntEdit;
class PMFloatEdit;
class QComboBox;

/**
 * Dialog edit class for @ref PMBicubicPatch
 */
class PMBicubicPatchEdit : public PMGraphicalObjectEdit
{
   Q_OBJECT
   typedef PMGraphicalObjectEdit Base;
public:
   /** Creates a PMBicubicPatchEdit with parent and name */
   PMBicubicPatchEdit( QWidget* parent, const char* name = 0 );

   /** */
   virtual void displayObject( PMObject* o );

   /** */
   virtual bool isDataValid( );
public slots:
   void slotTypeSelected( int i );
   
protected:
   /** */
   virtual void createTopWidgets( );
   /** */
   virtual void saveContents( );

private:
   QComboBox* m_pType;
   PMIntEdit* m_pUSteps;
   PMIntEdit* m_pVSteps;
   PMFloatEdit* m_pFlatness;
   PMVectorEdit* m_pControlPoint[16];
   
   PMBicubicPatch* m_pDisplayedObject;
};


#endif
