/***************************************************************************
                          session.cpp  -  description
                             -------------------
    begin                : Die Jun 18 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "session.h"
#include "recordfile.h"

#include <qpixmap.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kaction.h>
#include <kdebug.h>

Session::Session( QString nprefix, KListView *parent, QObject *parObj )
	: QObject(parObj, 0)
	, KListViewItem(parent,nprefix)
{
kdDebug()<<"Session::Session( string "<<nprefix.local8Bit()<<", KListView *"<<parent<<", QObject *"<<parObj<<" )"<<endl; // (DEBUG)
	init( nprefix );
}

void Session::init( QString npre ){
	KIconLoader iconload;

	folder_closed = new QPixmap( iconload.loadIcon( "folder", KIcon::Small ) );
	folder_open = new QPixmap( iconload.loadIcon( "folder_open", KIcon::Small ) );
	pix = folder_closed;
	prefix( npre );
	i_takecount = 0;

	i_menu = new KActionMenu( i18n("Session"), this, "sessionmenu" );
	a_open = new KToggleAction( i18n("Fold/Unfold"), "next", KShortcut(), this, "opentree" );
	connect( a_open, SIGNAL(toggled(bool)), this, SLOT(setOpen(bool)) );
	i_menu->insert( a_open );
	a_newFile = new KAction( i18n("New File"), "filenew", KShortcut(), this, SLOT(newFile()), this, "");
	i_menu->insert( a_newFile );
	a_closeSession = new KAction( i18n("Close Session"), "fileclose", KShortcut(), this, SLOT(deleteLater()), this, "closesession" );
	i_menu->insert( a_closeSession );
}

Session::~Session(){
	//kdDebug()<<"Session::~Session()"<<endl; // (DEBUG)
    delete folder_open;
    delete folder_closed;
}

void Session::newFile(){
	//kdDebug()<<"Session::newFile()"<<endl; // (DEBUG)
QString filename = prefix() + "-";
int c = nexttake();
	filename += c/10 + 48;
	filename += c%10 + 48;
	filename += ".raw";
	//kdDebug()<<"Session::newFile()::filename '"<<filename.local8Bit()<<"'"<<endl; // (DEBUG)
	RecordFile *tmp = new RecordFile( this, filename, this );
	connect( tmp, SIGNAL(sNewRecFile(RecordFile*)), this, SLOT(newRecFile(RecordFile*)) );
	connect( tmp, SIGNAL(sNewPlayFile(RecordFile*)), this, SLOT(newPlayFile(RecordFile*)) );
}

const QPixmap* Session::pixmap( int i ) const {
	//kdDebug()<<"Session::pixmap( int "<<i<<" )"<<endl; // (DEBUG)
	if(i)
		return 0;
	return pix;
}

void Session::setOpen( bool open ){
	//kdDebug()<<"Session::setOpen( bool "<<open<<" )"<<endl; // (DEBUG)
	pix = (open)?folder_open:folder_closed;
	KListViewItem::setOpen( open );
}

#include "session.moc"

// vim:sw=4:ts=4

