/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui.player;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JavawsFactory;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Resources;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.cache.CacheImageLoader;
import com.sun.javaws.cache.CacheImageLoaderCallback;
import com.sun.javaws.cache.DiskCache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.net.HttpRequest;
import com.sun.javaws.net.HttpResponse;
import com.sun.javaws.ui.console.Console;
import com.sun.javaws.ui.general.GeneralUtilities;
import com.sun.javaws.ui.general.LinkButton;
import com.sun.javaws.ui.player.BookmarkEntry;
import com.sun.javaws.ui.player.BookmarkEntryEditor;
import com.sun.javaws.ui.player.CacheEntryManager;
import com.sun.javaws.ui.player.EntryManager;
import com.sun.javaws.ui.player.HTMLEntryManager;
import com.sun.javaws.ui.player.JNLEntry;
import com.sun.javaws.ui.player.RemoteURL;
import com.sun.javaws.ui.prefs.PrefsPanel;
import com.sun.javaws.util.GeneralUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Player
implements CacheImageLoaderCallback {
    private static final Object LOADING_OBJECT = new Object();
    private static final String ENTRY_CLIENT_PROPERTY = "EntryClientProperty";
    private static final String ENTRY_CLASS_CLIENT_PROPERTY = "EntryClassClientProperty";
    private static int DEFAULT_VIEWMENU_ITEM_COUNT = 4;
    private static int ADDENTRY_VIEWMENU_ITEM_INDEX = 0;
    private static int MAX_MENUITEM_LENGTH = 25;
    private Image _defaultImage;
    private boolean _loadedDefaultImage;
    private HashMap _imageMap;
    private EntryHandler _entryListener;
    private boolean _isOffline;
    private EntryManager _cachedManager;
    private EntryManager _currentManager;
    private PrefsPanel _prefsPanel;
    private InstallRunnable _installer;
    private ArrayList _bookmarkEntryList;
    private JComponent _viewPanel;
    private JComponent _iconPanel;
    private JComponent _buttonPanel;
    private JComponent _bottomPanel;
    private JComponent _urlPanel;
    private JLabel _applicationsLabel;
    private JLabel _viewNameLabel;
    private JLabel _urlLabel;
    private IconList _iconList;
    private JButton _detailButton;
    private JButton _miniButton;
    private JButton _launchButton;
    private boolean _moreDroppedDown;
    private JPanel _infoPanel;
    private JPanel _statusPanel;
    private RemoteURL _remote;
    private JPanel _systemIndicatorPanel;
    private JLabel _statusLabel;
    private JLabel _applicationTitle;
    private JLabel _madeByLabel;
    private JLabel _madeByInfoLabel;
    private JLabel _homePageLabel;
    private JButton _homePageButton;
    private JLabel _descriptionLabel;
    private JTextArea _descriptionTextArea;
    private IndicatorsPanel _appIndicatorPanel;
    private Icon _updateAvailable;
    private Icon _updateUnavailable;
    private Icon _online;
    private Icon _offline;
    private Icon _inCache;
    private Icon _notInCache;
    private Icon _signed;
    private Icon _unsigned;
    private Icon _netNo;
    private Icon _netYes;
    private Icon _moreIcon;
    private Icon _lessIcon;
    private Font _appTitleFont;
    private Font _defaultFont;
    private JMenuItem _installMI;
    private JMenuItem _launchMI;
    private JMenuItem _removeMI;
    private boolean _removeMIAdded;
    private JMenu _appMenu;
    private JMenu _viewMenu;
    private JMenuItem _addEntryMI;
    private JMenuItem _editEntryMI;
    private JFrame _frame;
    private JViewport _iconViewport;
    private Vector _managerList;
    private int _selectedManager = 0;
    private static final int IMAGE_WIDTH = 32;
    private static final int IMAGE_HEIGHT = 32;
    private static Player _player;
    static /* synthetic */ Class class$com$sun$javaws$ui$player$Player;

    public Player() {
        Serializable serializable;
        Object object;
        Object object2;
        _player = this;
        this._bookmarkEntryList = ConfigProperties.getInstance().getBookmarks();
        this._frame = new JFrame(Resources.getString("player.title"));
        new Console().show(Resources.getString("player.title"));
        this.getDefaultImage();
        this._imageMap = new HashMap();
        this._entryListener = new EntryHandler();
        try {
            this._cachedManager = new CacheEntryManager();
            this._cachedManager.refresh();
        }
        catch (Exception exception) {
            object2 = new Object[]{Resources.getString("player.corruptedcache.msg")};
            object = new Object[]{Resources.getString("player.corruptedcache.exit"), Resources.getString("player.corruptedcache.clearandexit")};
            serializable = GeneralUtil.getActiveTopLevelFrame();
            int n = GeneralUtilities.showOptionDialog(serializable, object2, Resources.getString("player.corruptedcache.title"), 0, 3, object, object[1]);
            if (n == 1) {
                DiskCache diskCache = InstallCache.getDiskCache();
                diskCache.uninstallCache();
            }
            System.exit(0);
        }
        this.createComponents();
        this.layoutComponents();
        int n = ConfigProperties.getPlayerManager();
        if (n < 0 || n > 1) {
            n = 1;
        }
        if (n == 1 && this._cachedManager.size() == 0) {
            n = 0;
        }
        this.setSelectedManagerIndex(n);
        this._frame.pack();
        object2 = this._frame.getBounds();
        object2.width += 32;
        if (object2.width < 400) {
            object2.width = 400;
        }
        object = Toolkit.getDefaultToolkit().getScreenSize();
        object2.x = (object.width - object2.width) / 2;
        object2.y = (object.height - object2.height) / 2;
        serializable = ConfigProperties.getPlayerBounds();
        if (serializable != null) {
            object2 = serializable;
        }
        this._frame.setBounds((Rectangle)object2);
        SplashScreen.hide();
        this._frame.show();
        JAuthenticator jAuthenticator = JAuthenticator.getInstance(this._frame);
        Authenticator.setDefault(jAuthenticator);
    }

    private void addBookmarkEntry() {
        URL uRL = ((HTMLEntryManager)this._currentManager).getURL();
        String string = this.getURLTitle(uRL);
        if (string == null) {
            string = uRL.toString();
        }
        String string2 = string;
        boolean bl = true;
        while (bl) {
            string = GeneralUtilities.showInputDialog(this._frame, Resources.getString("player.addHtmlEntryMsg"), Resources.getString("player.addHtmlEntry"), string);
            if (string == null) {
                return;
            }
            if (string.trim().equals("")) {
                Player.showInvalidInputDialog(this._frame, Resources.getString("player.addHtmlEntryMissingName"), Resources.getString("player.addHtmlEntry"));
                string = string2;
                continue;
            }
            bl = false;
        }
        boolean bl2 = this.addBookmarkEntryToTable(string, uRL.toString());
        if (bl2) {
            return;
        }
        this.addViewMenuBookmarkEntry(string);
    }

    private void createComponents() {
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Player.this.exit();
            }
        });
        this._viewPanel = this.createGroupPanel();
        this._iconPanel = this.createIconPanel();
        this._buttonPanel = this.createButtonPanel();
        this._bottomPanel = this.createBottomPanel();
        this._urlPanel = this.createUrlPanel();
        this.setCompactMode();
        this._applicationsLabel.setLabelFor(this._iconList);
        this._urlLabel.setLabelFor(this._remote);
        this.createMenuBar();
    }

    private void createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = jMenuBar.add(new JMenu(Resources.getString("player.fileMenu")));
        jMenu.setMnemonic(Resources.getVKCode("player.fileMnemonic"));
        JMenuItem jMenuItem = jMenu.add(Resources.getString("player.preferencesMenuItem"));
        jMenuItem.setMnemonic(Resources.getVKCode("player.preferencesMnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigProperties configProperties = ConfigProperties.getInstance();
                configProperties.refreshIfNecessary();
                if (Player.this._prefsPanel == null) {
                    Player.this._prefsPanel = new PrefsPanel((Frame)Player.this._frame, false);
                    Player.this._prefsPanel.addWindowListener(new WindowAdapter(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void windowClosed(WindowEvent windowEvent) {
                            Player.access$302(3.access$500(this.this$1), null);
                            3.access$500(this.this$1).getCurrentManager().refresh();
                            Player.access$600(3.access$500(this.this$1));
                        }
                    });
                    Timer timer = new Timer(20, new ActionListener(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void actionPerformed(ActionEvent actionEvent) {
                            Player.access$300(3.access$500(this.this$1)).show();
                            Player.access$300(3.access$500(this.this$1)).repaint();
                        }
                    });
                    timer.setRepeats(false);
                    timer.start();
                } else {
                    GeneralUtilities.placeWindow(Player.this._prefsPanel);
                }
                Player.this._prefsPanel.toFront();
            }

            static /* synthetic */ Player access$500(3 var0) {
                return var0.Player.this;
            }
        });
        jMenuItem.setEnabled(true);
        jMenu.addSeparator();
        jMenuItem = jMenu.add(Resources.getString("player.exitMenuItem"));
        jMenuItem.setMnemonic(Resources.getVKCode("player.exitMnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.exit();
            }
        });
        jMenu = jMenuBar.add(new JMenu(Resources.getString("player.applicationMenu")));
        jMenu.setMnemonic(Resources.getVKCode("player.applicationMnemonic"));
        this._appMenu = jMenu;
        this._appMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EntryManager entryManager = Player.this.getCurrentManager();
                if (entryManager != null) {
                    Player.this.updateInstallMI(entryManager.getSelectedEntry());
                }
            }
        });
        this._launchMI = jMenu.add(Resources.getString("player.launchMenuItem", ""));
        this._launchMI.setMnemonic(Resources.getVKCode("player.launchMnemonic"));
        jMenu.addSeparator();
        LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
        if (localInstallHandler != null && localInstallHandler.isLocalInstallSupported()) {
            this._installMI = jMenu.add(Resources.getString("player.installMenuItem"));
            this._installMI.setMnemonic(Resources.getVKCode("player.installMnemonic"));
            this._installMI.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Player.this.installOrUninstall();
                }
            });
        }
        this._removeMI = jMenu.add("");
        this._removeMIAdded = true;
        this._launchMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.launch();
            }
        });
        this._removeMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.remove();
            }
        });
        jMenu = jMenuBar.add(new JMenu(Resources.getString("player.viewMenu")));
        jMenu.setMnemonic(Resources.getVKCode("player.viewMnemonic"));
        this._viewMenu = jMenu;
        this._addEntryMI = jMenu.add(Resources.getString("player.addEntryMenuItem"));
        this._addEntryMI.setMnemonic(Resources.getVKCode("player.addEntryMnemonic"));
        this._addEntryMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.addBookmarkEntry();
            }
        });
        this._editEntryMI = jMenu.add(Resources.getString("player.editEntryMenuItem"));
        this._editEntryMI.setMnemonic(Resources.getVKCode("player.editEntryMnemonic"));
        this._editEntryMI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.editBookmarkEntry();
            }
        });
        jMenu.addSeparator();
        ManagerListEntry managerListEntry = (ManagerListEntry)this._managerList.get(1);
        this.addViewMenuItem(managerListEntry);
        this.loadViewMenuBookmarkEntries();
        jMenu = jMenuBar.add(new JMenu(Resources.getString("player.helpMenu")));
        jMenu.setMnemonic(Resources.getVKCode("player.helpMnemonic"));
        jMenuItem = jMenu.add(Resources.getString("player.aboutMenuItem"));
        jMenuItem.setMnemonic(Resources.getVKCode("player.aboutMnemonic"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = Globals.getBuildID();
                GeneralUtilities.showAboutDialog(Player.this._frame, Resources.getString("player.aboutMessageTitle"));
            }
        });
        this._frame.setJMenuBar(jMenuBar);
    }

    private void editBookmarkEntry() {
        BookmarkEntryEditor bookmarkEntryEditor = new BookmarkEntryEditor(this._frame);
        while (this._viewMenu.getItemCount() > DEFAULT_VIEWMENU_ITEM_COUNT) {
            this._viewMenu.remove(DEFAULT_VIEWMENU_ITEM_COUNT);
        }
        this.loadViewMenuBookmarkEntries();
    }

    private void entriesChanged() {
        this.updateUI(true);
    }

    private void exit() {
        this.getCurrentManager().save();
        Rectangle rectangle = this._frame.getBounds();
        ConfigProperties.getInstance().setRemoteURLs(this._remote.getRemoteURLs());
        ConfigProperties.getInstance().setBookmarks(this._bookmarkEntryList);
        ConfigProperties.setPlayerBounds(rectangle);
        ConfigProperties.setPlayerManager(this._selectedManager);
        ConfigProperties.setPlayerMode(this._moreDroppedDown ? 1 : 0);
        ConfigProperties.getInstance().store();
        System.exit(0);
    }

    private void installCompleted() {
        this.updateUI(false);
    }

    private void installOrUninstall() {
        if (this._installer == null) {
            this._installer = new InstallRunnable();
        }
        this._installer.installOrUninstall(this.getCurrentManager().getSelectedEntry());
        this.updateUI(false);
    }

    private void launch() {
        JNLEntry jNLEntry = this.getCurrentManager().getSelectedEntry();
        if (jNLEntry != null) {
            jNLEntry.launch();
            this._appIndicatorPanel.launched();
        }
    }

    private void layoutComponents() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this._frame.getContentPane().add(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this._urlPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this._viewPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this._iconPanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this._buttonPanel, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)this._bottomPanel, gridBagConstraints);
    }

    private void loadViewMenuBookmarkEntries() {
        int n = 0;
        while (n < this._bookmarkEntryList.size()) {
            BookmarkEntry bookmarkEntry = (BookmarkEntry)this._bookmarkEntryList.get(n);
            this.addViewMenuBookmarkEntry(bookmarkEntry.getName());
            ++n;
        }
    }

    private void remove() {
        if (this.getCurrentManager() == this._cachedManager) {
            JNLEntry jNLEntry = this.getCurrentManager().getSelectedEntry();
        }
        this.getCurrentManager().remove(this.getCurrentManager().getSelectedIndex());
    }

    public void resetCacheEntryManager() {
        int n = this._managerList.size();
        int n2 = 0;
        while (n2 < n) {
            ManagerListEntry managerListEntry = (ManagerListEntry)this._managerList.get(n2);
            EntryManager entryManager = managerListEntry.getManager();
            if (entryManager instanceof CacheEntryManager) {
                entryManager.refresh();
                break;
            }
            ++n2;
        }
    }

    public void resetHTMLEntryManager() {
        int n = this._managerList.size();
        int n2 = 0;
        while (n2 < n) {
            ManagerListEntry managerListEntry = (ManagerListEntry)this._managerList.get(n2);
            EntryManager entryManager = managerListEntry.getManager();
            if (entryManager instanceof HTMLEntryManager) {
                managerListEntry.setManager(null);
                if (entryManager == this.getCurrentManager()) {
                    this.updateEntryManager();
                }
            }
            ++n2;
        }
    }

    private void selectionChanged() {
        this.updateUI(false);
    }

    private void setCompactMode() {
        if (this._moreDroppedDown) {
            this._detailButton.setText(Resources.getString("player.lessDetailButton"));
            this._detailButton.setIcon(this._lessIcon);
            this._detailButton.setMnemonic(Resources.getVKCode("player.lessDetailMnemonic"));
            this._infoPanel.setVisible(true);
        } else {
            this._detailButton.setText(Resources.getString("player.moreDetailButton"));
            this._detailButton.setIcon(this._moreIcon);
            this._detailButton.setMnemonic(Resources.getVKCode("player.moreDetailMnemonic"));
            this._infoPanel.setVisible(false);
        }
    }

    private void updateEntryManager() {
        ManagerListEntry managerListEntry = null;
        if (this._selectedManager < this._managerList.size()) {
            managerListEntry = (ManagerListEntry)this._managerList.elementAt(this._selectedManager);
        }
        if (managerListEntry != null) {
            EntryManager entryManager = managerListEntry.getManager();
            if (entryManager == null) {
                String string = managerListEntry.getManagerClassName();
                try {
                    entryManager = (EntryManager)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Debug.ignoredException(classNotFoundException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Debug.ignoredException(illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    Debug.ignoredException(instantiationException);
                }
                managerListEntry.setManager(entryManager);
                entryManager.refresh();
            }
            if (entryManager != this.getCurrentManager()) {
                this.setCurrentManager(entryManager);
            }
            if (this._currentManager instanceof HTMLEntryManager) {
                this._remote.setSelectedItem(((HTMLEntryManager)this._currentManager).getURL().toString());
            } else {
                this._remote.setSelectedItem("");
            }
        }
    }

    private void updateStatusLabel() {
        EntryManager entryManager = this.getCurrentManager();
        if (this._installer != null && this._installer.isInstalling()) {
            LocalApplicationProperties localApplicationProperties;
            JNLEntry jNLEntry;
            String string = null;
            if (entryManager != null && (jNLEntry = entryManager.getSelectedEntry()) != null && (localApplicationProperties = jNLEntry.getLocalApplicationProperties()) != null) {
                string = localApplicationProperties.isLocallyInstalled() ? Resources.getString("player.uninstallingLabel") : Resources.getString("player.installingLabel");
            }
            if (this._installer.isInstalling()) {
                this._statusLabel.setText(string);
            }
        } else if (entryManager != null) {
            if (entryManager.getState() == 0) {
                this._statusLabel.setText(Resources.getString("player.loadedLabel"));
            } else {
                this._statusLabel.setText(Resources.getString("player.loadingLabel"));
            }
        }
    }

    void setSelectedManagerIndex(int n) {
        if (n < this._managerList.size()) {
            this._selectedManager = n;
            ManagerListEntry managerListEntry = (ManagerListEntry)this._managerList.elementAt(this._selectedManager);
            this._viewNameLabel.setText(managerListEntry.getManagerName());
            this.updateEntryManager();
        }
    }

    private void updateUI(boolean bl) {
        int n;
        EntryManager entryManager = this.getCurrentManager();
        if (entryManager == null) {
            return;
        }
        if (entryManager instanceof HTMLEntryManager) {
            this._viewMenu.getItem(ADDENTRY_VIEWMENU_ITEM_INDEX).setEnabled(true);
        } else {
            this._viewMenu.getItem(ADDENTRY_VIEWMENU_ITEM_INDEX).setEnabled(false);
        }
        JNLEntry jNLEntry = entryManager.getSelectedEntry();
        JButton jButton = null;
        if (jNLEntry == null) {
            this._applicationTitle.setText(" ");
            this._madeByInfoLabel.setText(null);
            this._homePageButton.setText(null);
            this._descriptionTextArea.setText("");
            this._removeMI.setEnabled(false);
            this._launchMI.setEnabled(false);
            this._launchMI.setText(Resources.getString("player.launchMenuItem", ""));
            this._homePageButton.setEnabled(false);
            this._launchButton.setEnabled(false);
            this._launchButton.setText(Resources.getString("player.launchButton"));
            this._launchButton.setDefaultCapable(false);
            Component component = SwingUtilities.findFocusOwner(this._iconPanel);
            if (this._installMI != null) {
                this._installMI.setEnabled(false);
            }
        } else {
            this._applicationTitle.setText(this.getMenuItemString(jNLEntry.getTitle()));
            int n2 = this._appTitleFont.canDisplayUpTo(this.getMenuItemString(jNLEntry.getTitle()));
            boolean bl2 = n2 < 0 || n2 >= this.getMenuItemString(jNLEntry.getTitle()).length();
            this._applicationTitle.setFont(bl2 ? this._appTitleFont : this._defaultFont);
            this._madeByInfoLabel.setText(jNLEntry.getVendor());
            this._homePageButton.setText(jNLEntry.getHome());
            this._descriptionTextArea.setText(jNLEntry.getDescription());
            this._removeMI.setEnabled(entryManager.canRemove());
            n = !this._isOffline || jNLEntry.canRunOffline() && jNLEntry.isCached() && LaunchDownload.isInCache(jNLEntry.getLaunchDescriptor()) ? 1 : 0;
            this._launchMI.setEnabled(n != 0);
            this._launchButton.setText(Resources.getString("player.launchButton"));
            this._launchButton.setEnabled(n != 0);
            this._launchButton.setDefaultCapable(n != 0);
            if (n != 0) {
                this._launchMI.setText(Resources.getString("player.launchMenuItem", this.getMenuItemString(jNLEntry.getTitle())));
                jButton = this._launchButton;
            } else {
                Component component = SwingUtilities.findFocusOwner(this._iconPanel);
            }
            this._homePageButton.setEnabled(!this._isOffline && jNLEntry.getHome() != null);
            this.updateInstallMI(jNLEntry);
        }
        this.updateStatusLabel();
        if (bl) {
            int n3 = Math.max(0, entryManager.getSelectedIndex());
            Vector<IconCell> vector = new Vector<IconCell>();
            n = entryManager.size();
            int n4 = 0;
            while (n4 < n) {
                String string = entryManager.get(n4).getTitle();
                Image image = this.getImage(n4);
                ImageIcon imageIcon = null;
                if (image != null) {
                    imageIcon = new ImageIcon(image, string);
                }
                vector.addElement(new IconCell(string, new ScaledImageIcon(imageIcon, 32, 32)));
                ++n4;
            }
            this._iconList.setList(vector, n3);
        } else {
            this._iconList.setSelectedIndex(entryManager.getSelectedIndex());
        }
        this._appIndicatorPanel.setIcons(jNLEntry);
        this._frame.getRootPane().setDefaultButton(jButton);
    }

    EntryManager getCurrentManager() {
        return this._currentManager;
    }

    private void setCurrentManager(EntryManager entryManager) {
        if (this._currentManager != entryManager) {
            if (this._currentManager != null) {
                this._currentManager.removeChangeListener(this._entryListener);
                this._currentManager.removePropertyChangeListener(this._entryListener);
                this._currentManager.save();
            }
            this._currentManager = entryManager;
            if (entryManager != null) {
                if (entryManager.size() > 0) {
                    entryManager.setSelectedIndex(0);
                }
                if (this._entryListener == null) {
                    this._entryListener = new EntryHandler();
                }
                entryManager.addChangeListener(this._entryListener);
                entryManager.addPropertyChangeListener(this._entryListener);
                this.updateStatusLabel();
                if (entryManager.canRemove()) {
                    this._removeMI.setText(entryManager.getRemoveString());
                    this._removeMI.setMnemonic(Resources.getVKCode("player.removeMnemonic"));
                    if (!this._removeMIAdded) {
                        this._appMenu.insert(this._removeMI, this._installMI != null ? 3 : 2);
                        this._removeMIAdded = true;
                    }
                } else if (this._removeMIAdded) {
                    this._appMenu.remove(this._removeMI);
                    this._removeMIAdded = false;
                }
            }
            this.updateUI(true);
        }
    }

    private void updateInstallMI(JNLEntry jNLEntry) {
        if (jNLEntry != null && this._installMI != null) {
            LocalApplicationProperties localApplicationProperties = jNLEntry.getLocalApplicationProperties();
            boolean bl = false;
            if (localApplicationProperties != null) {
                localApplicationProperties.refreshIfNecessary();
                if (localApplicationProperties.isLocallyInstalled()) {
                    this._installMI.setText(Resources.getString("player.uninstallMenuItem"));
                    this._installMI.setMnemonic(Resources.getVKCode("player.uninstallMnemonic"));
                } else {
                    this._installMI.setText(Resources.getString("player.installMenuItem"));
                    this._installMI.setMnemonic(Resources.getVKCode("player.installMnemonic"));
                }
                if (this._installer == null || !this._installer.isInstalling()) {
                    try {
                        String string = localApplicationProperties.getIndirectLauchFilePath(true);
                        bl = true;
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                }
            }
            this._installMI.setEnabled(bl);
        }
    }

    public static Player getPlayer() {
        return _player;
    }

    static /* synthetic */ void access$3500(Player player) {
        player.installCompleted();
    }

    private void addViewMenuItem(ManagerListEntry managerListEntry) {
        if (this._viewMenu != null) {
            JMenuItem jMenuItem = managerListEntry.getMenuItem();
            this._viewMenu.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    int n = Player.this._managerList.size();
                    int n2 = 0;
                    while (n2 < n) {
                        ManagerListEntry managerListEntry = (ManagerListEntry)Player.this._managerList.get(n2);
                        if (jMenuItem.equals(managerListEntry.getMenuItem())) {
                            Player.this.setSelectedManagerIndex(n2);
                        }
                        ++n2;
                    }
                }
            });
        }
    }

    private Image getDefaultImage() {
        if (!this._loadedDefaultImage) {
            this._defaultImage = this.doLoadImage("resources/JavaIcon-32.png");
            this._loadedDefaultImage = true;
        }
        return this._defaultImage;
    }

    private Image getImage(int n) {
        JNLEntry jNLEntry = this.getCurrentManager().get(n);
        IconDesc iconDesc = jNLEntry.getImageLocation();
        if (iconDesc != null) {
            Object v = this._imageMap.get(iconDesc);
            if (v == null && !this._isOffline) {
                this._imageMap.put(iconDesc, LOADING_OBJECT);
                CacheImageLoader.getInstance().loadImage(iconDesc, this);
                if (Globals.TracePlayerImageLoading) {
                    Debug.println("starting loading of image from " + iconDesc);
                }
            } else if (v instanceof Image) {
                return (Image)v;
            }
        }
        return this.getDefaultImage();
    }

    int getBookmarkIndex(String string) {
        int n = 0;
        while (n < this._bookmarkEntryList.size()) {
            BookmarkEntry bookmarkEntry = (BookmarkEntry)this._bookmarkEntryList.get(n);
            if (bookmarkEntry.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void addViewMenuBookmarkEntry(String string) {
        JMenuItem jMenuItem = this._viewMenu.add(this.getMenuItemString(string));
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!(Player.this._currentManager instanceof HTMLEntryManager)) {
                    Player.this.setSelectedManagerIndex(0);
                }
                String string = actionEvent.getActionCommand();
                int n = Player.this.getBookmarkIndex(string);
                BookmarkEntry bookmarkEntry = (BookmarkEntry)Player.this._bookmarkEntryList.get(n);
                String string2 = bookmarkEntry.getUrl();
                String[] stringArray = Player.this._remote.getRemoteURLs();
                if (stringArray[0].equals(string2)) {
                    return;
                }
                int n2 = ConfigProperties.getMaxUrlsLength();
                String[] stringArray2 = new String[n2];
                int n3 = 0;
                while (n3 < n2 - 1) {
                    if (stringArray[n3] == null) break;
                    if (stringArray[n3].equals(string2)) {
                        stringArray2[0] = string2;
                    } else {
                        stringArray[n3] = stringArray2[n3 + 1];
                    }
                    ++n3;
                }
                stringArray2[0] = string2;
                ConfigProperties.getInstance().setRemoteURLs(stringArray2);
                Player.getPlayer().resetHTMLEntryManager();
                Player.this._remote.setSelectedItem(string2);
            }
        });
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new Player();
            }
        });
    }

    ArrayList getBookmarkEntryList() {
        return this._bookmarkEntryList;
    }

    private JComponent createBottomPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this._infoPanel = new JPanel(new BorderLayout());
        this._applicationTitle = new PlayerLabel(" ");
        this._defaultFont = this._applicationTitle.getFont();
        this._appTitleFont = new Font(this._defaultFont.getFontName(), this._defaultFont.getStyle(), 125 * this._defaultFont.getSize() / 100);
        this._appIndicatorPanel = new IndicatorsPanel();
        this._appIndicatorPanel.setBorder(BorderFactory.createEtchedBorder());
        this._madeByLabel = new PlayerLabel(Resources.getString("player.madeByLabel"));
        this._madeByInfoLabel = new PlayerLabel();
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this._madeByInfoLabel, "West");
        this._homePageLabel = new PlayerLabel(Resources.getString("player.homePageLabel"));
        this._homePageLabel.setDisplayedMnemonic(Resources.getVKCode("player.homePageLabelMnemonic"));
        this._homePageLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        this._homePageButton = new LinkButton();
        this._homePageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JNLEntry jNLEntry = Player.this.getCurrentManager().getSelectedEntry();
                if (jNLEntry != null) {
                    jNLEntry.showHome();
                }
            }
        });
        this._homePageButton.setToolTipText(Resources.getString("player.homeTooltipText"));
        this._homePageLabel.setLabelFor(this._homePageButton);
        this._descriptionLabel = new PlayerLabel(Resources.getString("player.descriptionLabel"));
        this._descriptionLabel.setVerticalAlignment(1);
        this._descriptionTextArea = new JTextArea(2, 80){

            public boolean isFocusTraversable() {
                return false;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = this.getPreferredSize().height;
                return dimension;
            }

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 10;
                Dimension dimension2 = Player.this._descriptionLabel.getPreferredSize();
                int n = dimension2.height * 2;
                if (dimension.height > n) {
                    dimension.height = n;
                }
                return dimension;
            }
        };
        this._descriptionTextArea.setEditable(false);
        this._descriptionTextArea.setOpaque(false);
        this._descriptionTextArea.setLineWrap(true);
        this._descriptionTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this._applicationTitle, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this._madeByLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this._homePageLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this._homePageButton, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel2.add((Component)this._descriptionLabel, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this._descriptionTextArea, gridBagConstraints);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)this._appIndicatorPanel, gridBagConstraints);
        this._infoPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8), BorderFactory.createEtchedBorder()));
        this._infoPanel.add(jPanel2);
        this._statusPanel = new JPanel(new BorderLayout());
        this._statusLabel = new PlayerLabel();
        this._statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        this._statusPanel.add((Component)this._statusLabel, "East");
        this._statusPanel.add((Component)this._systemIndicatorPanel, "West");
        this._statusPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8), BorderFactory.createEtchedBorder()));
        jPanel.add((Component)this._infoPanel, "North");
        jPanel.add((Component)this._statusPanel, "South");
        jPanel.setVisible(true);
        return jPanel;
    }

    private JComponent createButtonPanel() {
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 8, 2, 8));
        this._moreIcon = new ImageIcon(this.doLoadImage("resources/more.gif"));
        this._lessIcon = new ImageIcon(this.doLoadImage("resources/less.gif"));
        ImageIcon imageIcon = new ImageIcon(this.doLoadImage("resources/launch.gif"));
        this._detailButton = new JButton(Resources.getString("player.lessDetailButton"), this._lessIcon);
        this._detailButton.setMnemonic(Resources.getVKCode("player.lessDetailMnemonic"));
        this._detailButton.setHorizontalTextPosition(10);
        this._detailButton.setEnabled(true);
        this._miniButton = new JButton(Resources.getString("player.miniButton"));
        this._miniButton.setMnemonic(Resources.getVKCode("player.miniButtonMnemonic"));
        this._miniButton.setHorizontalTextPosition(10);
        this._miniButton.setEnabled(true);
        this._detailButton.setText(Resources.getString("player.moreDetailButton"));
        Dimension dimension = this._detailButton.getPreferredSize();
        this._detailButton.setText(Resources.getString("player.lessDetailButton"));
        Dimension dimension2 = this._detailButton.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        Dimension dimension4 = this._miniButton.getPreferredSize();
        dimension3 = new Dimension(Math.max(dimension4.width, dimension3.width), Math.max(dimension4.height, dimension3.height));
        this._detailButton.setPreferredSize(dimension3);
        this._miniButton.setPreferredSize(dimension3);
        int n = ConfigProperties.getPlayerMode();
        this._moreDroppedDown = true;
        if (n >= 0 && (n & 1) == 0) {
            this._moreDroppedDown = false;
        }
        this._detailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = Player.this._frame.getBounds();
                int n = Player.this._iconList.getVisibleRowCount();
                Dimension dimension = Player.this._frame.getPreferredSize();
                if (Player.this._moreDroppedDown) {
                    Player.this._moreDroppedDown = false;
                    Player.this.setCompactMode();
                    Dimension dimension2 = Player.this._frame.getPreferredSize();
                    Dimension dimension3 = Player.this._frame.getMinimumSize();
                    int n2 = dimension.height - dimension2.height;
                    rectangle.height = rectangle.height - n2 > dimension3.height ? (rectangle.height -= n2) : dimension3.height;
                    Player.this._frame.setBounds(rectangle);
                } else {
                    Player.this._moreDroppedDown = true;
                    Player.this.setCompactMode();
                    Dimension dimension4 = Player.this._frame.getPreferredSize();
                    int n3 = dimension4.height - dimension.height;
                    if (rectangle.height < dimension4.height) {
                        rectangle.height = rectangle.height + n3 < dimension4.height ? (rectangle.height += n3) : dimension4.height;
                        Player.this._frame.setBounds(rectangle);
                    }
                }
            }
        });
        this._miniButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Rectangle rectangle = Player.this._frame.getBounds();
                int n = Player.this._iconList.getVisibleRowCount();
                Dimension dimension = Player.this._frame.getPreferredSize();
                Player.this._detailButton.setEnabled(true);
                if (Player.this._moreDroppedDown) {
                    Player.this._infoPanel.setVisible(false);
                    Dimension dimension2 = Player.this._frame.getPreferredSize();
                    Dimension dimension3 = Player.this._frame.getMinimumSize();
                    int n2 = dimension.height - dimension2.height;
                    rectangle.height = rectangle.height - n2 > dimension3.height ? (rectangle.height -= n2) : dimension3.height;
                    Player.this._frame.setBounds(rectangle);
                    Player.this._moreDroppedDown = false;
                    if (n <= 1) {
                        Player.this._miniButton.setEnabled(true);
                    }
                } else {
                    Player.this._iconList.setVisibleRowCount(1);
                    Dimension dimension4 = Player.this._frame.getPreferredSize();
                    rectangle.height = dimension4.height;
                    Player.this._frame.setBounds(rectangle);
                }
            }
        });
        this._launchButton = new JButton(Resources.getString("player.launchButton"), imageIcon){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = this.getParent().getWidth();
                if (dimension.width > n) {
                    dimension.width = n;
                }
                return dimension;
            }
        };
        this._launchButton.setHorizontalTextPosition(10);
        this._launchButton.setToolTipText(Resources.getString("player.launchTooltipText"));
        this._launchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Player.this.launch();
            }
        });
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this._detailButton, "West");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add((Component)this._launchButton, "East");
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.setBorder(new EmptyBorder(2, 8, 2, 8));
        return jPanel;
    }

    private JComponent createGroupPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this._applicationsLabel = new PlayerLabel(Resources.getString("player.applicationsLabel"));
        this._applicationsLabel.setDisplayedMnemonic(Resources.getVKCode("player.applicationsLabelMnemonic"));
        this._viewNameLabel = new PlayerLabel("");
        this._managerList = new Vector();
        this.addManager(Resources.getString("player.remoteApplications"), null, "com.sun.javaws.ui.player.HTMLEntryManager", Resources.getString("player.remoteMenuItem"), Resources.getVKCode("player.remoteMenuMnemonic"));
        this.addManager(Resources.getString("player.cachedApplications"), this._cachedManager, null, Resources.getString("player.localMenuItem"), Resources.getVKCode("player.localMenuMnemonic"));
        this._systemIndicatorPanel = new JPanel(){

            public boolean isFocusTraversable() {
                return false;
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getPreferredSize() {
                return new Dimension(40, 20);
            }

            public void paint(Graphics graphics) {
                Icon icon;
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (Player.this._isOffline) {
                    icon = Player.this._offline;
                    this.setToolTipText(Resources.getString("player.notOnlineToolTipText"));
                } else {
                    icon = Player.this._online;
                    this.setToolTipText(Resources.getString("player.onlineToolTipText"));
                }
                if (icon != null) {
                    icon.paintIcon(this, graphics, 4, 2);
                }
            }
        };
        this._systemIndicatorPanel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Player.this._isOffline = !Player.this._isOffline;
                Player.this._systemIndicatorPanel.repaint();
                Player.this.updateUI(false);
            }
        });
        jPanel.add((Component)this._applicationsLabel, "West");
        this._viewNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        jPanel.add((Component)this._viewNameLabel, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 12, 2, 12));
        return jPanel;
    }

    private JComponent createIconPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        this._iconList = new IconList();
        this._iconList.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Player.this._iconList.setFocus(true);
                int n = Player.this.getCurrentManager().getSelectedIndex();
                if (n >= 0) {
                    Player.this._iconList.setIconBorder(n, true);
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                Player.this._iconList.setFocus(false);
                int n = Player.this.getCurrentManager().getSelectedIndex();
                if (n >= 0) {
                    Player.this._iconList.setIconBorder(n, false);
                }
            }
        });
        this._iconList.setVisibleRowCount(3);
        JScrollPane jScrollPane = new JScrollPane(this._iconList, 20, 31){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getPreferredSize() {
                Insets insets = this.getInsets();
                Dimension dimension = super.getPreferredSize();
                dimension.height = insets.top + insets.bottom + 12 + Player.this._iconList.getVisibleRowCount() * Player.this._iconList.getFixedCellHeight();
                return dimension;
            }
        };
        jScrollPane.setViewportBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this._iconViewport = jScrollPane.getViewport();
        jScrollPane.setBackground(this._iconList.getBackground());
        jPanel.add(jScrollPane);
        this._frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n;
                int n2;
                int n3;
                int n4 = Player.this._iconList.getVisibleRowCount();
                int n5 = Player.this._iconList.getFixedCellHeight();
                int n6 = Player.this._frame.getHeight();
                if (n6 > (n3 = (int)Player.this._frame.getPreferredSize().getHeight())) {
                    n2 = (n6 - n3) / n5;
                    if (n2 > 0) {
                        Player.this._iconList.setVisibleRowCount(n4 + n2);
                        Player.this._iconList.invalidate();
                        Player.this._frame.validate();
                    }
                } else if (n6 < n3) {
                    n2 = (n3 - n6 + n5 - 1) / n5;
                    Player.this._iconList.setVisibleRowCount(Math.max(1, n4 - n2));
                    Player.this._iconList.invalidate();
                    Player.this._frame.validate();
                }
                n2 = Player.this._iconList.getVisibleColumns();
                int n7 = n = Player.this._frame.getWidth() > 300 ? 2 : 1;
                if (n2 != n) {
                    Player.this._iconList.setVisibleColumns(n);
                }
                Player.this._iconList.invalidate();
                Player.this._frame.validate();
            }
        });
        return jPanel;
    }

    private JComponent createUrlPanel() {
        this._urlLabel = new PlayerLabel(Resources.getString("player.locationLabel"));
        this._urlLabel.setDisplayedMnemonic(Resources.getVKCode("player.locationLabelMnemonic"));
        this._remote = new RemoteURL();
        JPanel jPanel = new JPanel(new BorderLayout());
        this._remote.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel.add((Component)this._urlLabel, "West");
        jPanel.add((Component)this._remote, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        return jPanel;
    }

    private void finishedLoadingImage(IconDesc iconDesc, Image image) {
        this._imageMap.put(iconDesc, image);
        this.getCurrentManager().setSelectedIndex(0);
        this.updateUI(true);
    }

    private Image doLoadImage(String string) {
        MediaTracker mediaTracker = new MediaTracker(this._frame);
        Image image = Toolkit.getDefaultToolkit().getImage((class$com$sun$javaws$ui$player$Player == null ? (class$com$sun$javaws$ui$player$Player = Player.class$("com.sun.javaws.ui.player.Player")) : class$com$sun$javaws$ui$player$Player).getResource(string));
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0, 0L);
        }
        catch (InterruptedException interruptedException) {
            Debug.ignoredException(interruptedException);
            image = null;
        }
        if (image != null) {
            if (mediaTracker.statusID(0, false) != 8) {
                image = null;
            } else {
                mediaTracker.removeImage(image, 0);
            }
        }
        return image;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String getMenuItemString(String string) {
        if (string.length() > MAX_MENUITEM_LENGTH) {
            string = string.substring(0, MAX_MENUITEM_LENGTH);
            string = string + "...";
        }
        return string;
    }

    private boolean addBookmarkEntryToTable(String string, String string2) {
        BookmarkEntry bookmarkEntry = new BookmarkEntry(string, string2);
        int n = this.getBookmarkIndex(string);
        if (n != -1) {
            int n2;
            if (Globals.TracePlayer) {
                Debug.println("bookmark entry already exist");
            }
            if ((n2 = GeneralUtilities.showOptionDialog(this._frame, Resources.getString("player.addHtmlEntryExist"), Resources.getString("player.addHtmlEntry"), 0, 3)) == 0) {
                if (Globals.TracePlayer) {
                    Debug.println("overwriting entry:");
                    Debug.println("name: " + string + " url: " + string2);
                }
                this._bookmarkEntryList.set(n, bookmarkEntry);
            } else if (n2 == 1) {
                // empty if block
            }
            return true;
        }
        this._bookmarkEntryList.add(bookmarkEntry);
        return false;
    }

    private String getURLTitle(URL uRL) {
        BufferedInputStream bufferedInputStream = null;
        String string = null;
        try {
            HttpRequest httpRequest = JavawsFactory.getHttpRequestImpl();
            HttpResponse httpResponse = httpRequest.doGetRequest(uRL);
            bufferedInputStream = httpResponse.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.toUpperCase().indexOf("<TITLE>");
                int n2 = string2.toUpperCase().indexOf("</TITLE>");
                if (n == -1 || n2 == -1) continue;
                string = string2.substring(n + 7, n2);
                break;
            }
        }
        catch (IOException iOException) {
            Debug.ignoredException(iOException);
        }
        return string;
    }

    static /* synthetic */ JButton access$3000(Player player) {
        return player._launchButton;
    }

    public void finalImageAvailable(IconDesc iconDesc, Image image, File file) {
    }

    public void imageAvailable(IconDesc iconDesc, Image image, File file) {
        this.finishedLoadingImage(iconDesc, image);
    }

    static void showInvalidInputDialog(Component component, String string, String string2) {
        GeneralUtilities.showOptionDialog(component, string, string2, -1, 2);
    }

    private void addManager(String string, EntryManager entryManager, String string2, String string3, int n) {
        JMenuItem jMenuItem = new JMenuItem(string3);
        jMenuItem.setMnemonic(n);
        ManagerListEntry managerListEntry = new ManagerListEntry(string, entryManager, string2, jMenuItem);
        this._managerList.add(managerListEntry);
        if (this._viewMenu != null) {
            this.addViewMenuItem(managerListEntry);
        }
    }

    private class ArrowIcon
    implements Icon {
        static final int SIZE = 10;
        int _direction;

        public int getIconHeight() {
            return 10;
        }

        public int getIconWidth() {
            return 10;
        }

        public ArrowIcon(int n) {
            this._direction = n;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.translate(n, n2);
            if (component.isEnabled()) {
                graphics.setColor(UIManager.getColor("textText"));
            } else {
                graphics.setColor(UIManager.getColor("textInactiveText"));
            }
            switch (this._direction) {
                case 3: {
                    graphics.drawLine(2, 0, 2, 9);
                    graphics.drawLine(3, 1, 3, 8);
                    graphics.drawLine(4, 2, 4, 7);
                    graphics.drawLine(5, 3, 5, 6);
                    graphics.drawLine(6, 4, 6, 5);
                    break;
                }
                case 7: {
                    graphics.drawLine(7, 0, 7, 9);
                    graphics.drawLine(6, 1, 6, 8);
                    graphics.drawLine(5, 2, 5, 7);
                    graphics.drawLine(4, 3, 4, 6);
                    graphics.drawLine(3, 4, 3, 5);
                    break;
                }
                case 1: {
                    graphics.drawLine(0, 7, 9, 7);
                    graphics.drawLine(1, 6, 8, 6);
                    graphics.drawLine(2, 5, 7, 5);
                    graphics.drawLine(3, 4, 6, 4);
                    graphics.drawLine(4, 3, 5, 3);
                    break;
                }
                default: {
                    graphics.drawLine(0, 2, 9, 2);
                    graphics.drawLine(1, 3, 8, 3);
                    graphics.drawLine(2, 4, 7, 4);
                    graphics.drawLine(3, 5, 6, 5);
                    graphics.drawLine(4, 6, 5, 6);
                }
            }
            graphics.translate(-n, -n2);
        }
    }

    private class EntryHandler
    implements ChangeListener,
    PropertyChangeListener {
        private EntryHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() != Player.this.getCurrentManager()) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if ("selectedIndex".equals(string)) {
                Player.this.selectionChanged();
            } else if ("state".equals(string)) {
                Player.this.updateStatusLabel();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Player.this.entriesChanged();
        }
    }

    private class IconCell {
        Icon _icon;
        String _name;

        public IconCell() {
        }

        public String getName() {
            return this._name;
        }

        public void setName(String string) {
            this._name = string;
        }

        public Icon getIcon() {
            return this._icon;
        }

        public void setIcon(Icon icon) {
            this._icon = icon;
        }

        public IconCell(String string, Icon icon) {
            this._name = string;
            this._icon = icon;
        }
    }

    private class IconGridLayout
    extends GridLayout {
        public int _cellHeight;

        public void setCellHeight(int n) {
            this._cellHeight = n;
        }

        public IconGridLayout(int n, int n2, int n3) {
            super(n, n2);
            this._cellHeight = n3;
        }

        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            int n2 = this.getRows();
            int n3 = this.getColumns();
            int n4 = this.getHgap();
            int n5 = this.getVgap();
            if (n == 0) {
                return;
            }
            if (n2 > 0) {
                n3 = (n + n2 - 1) / n2;
            } else {
                n2 = (n + n3 - 1) / n3;
            }
            int n6 = container.getWidth() - (insets.left + insets.right);
            int n7 = container.getHeight() - (insets.top + insets.bottom);
            n6 = (n6 - (n3 - 1) * n4) / n3;
            n7 = this._cellHeight;
            int n8 = 0;
            int n9 = insets.left;
            while (n8 < n3) {
                int n10 = 0;
                int n11 = insets.top;
                while (n10 < n2) {
                    int n12 = n10 * n3 + n8;
                    if (n12 < n) {
                        container.getComponent(n12).setBounds(n9, n11, n6, n7);
                    }
                    ++n10;
                    n11 += n7 + n5;
                }
                ++n8;
                n9 += n6 + n4;
            }
        }
    }

    private class IconList
    extends JList
    implements KeyListener {
        int _rows = 1;
        int _columns = 1;
        int _entries = 0;
        int _dummyEntries = 0;
        int _cellHeight;
        int _visibleRows;
        int _visibleColumns;
        int _visibleEntries;
        int _selectedIndex;
        boolean _hasFocus = false;
        Vector _cells = null;
        Border _normalBorder;
        Border _selectedBorder;
        Color _normalBackground;
        Color _selectedBackground;
        Color _normalForeground;
        Color _selectedForeground;
        private static final int _heightBorder = 4;
        private static final int _heightPadding = 1;
        private static final int _widthBorder = 6;
        private static final int _widthPadding = 1;

        public int getFixedCellHeight() {
            return this._cellHeight;
        }

        public int getVisibleColumns() {
            return this._visibleColumns;
        }

        public int getVisibleRowCount() {
            return this._visibleRows;
        }

        public boolean isFocusTraversable() {
            return true;
        }

        public void setFixedCellHeight(int n) {
            this._cellHeight = n;
        }

        public void setSelectedIndex(int n) {
            if (n != this._selectedIndex) {
                Serializable serializable;
                Component component;
                if (this._selectedIndex >= 0 && this._selectedIndex < this._entries && (component = this.getComponent(this._selectedIndex)) != null && component instanceof JLabel) {
                    serializable = (JLabel)component;
                    ((JComponent)serializable).setBorder(this._normalBorder);
                    ((JComponent)serializable).setBackground(this._normalBackground);
                }
                if (n >= 0 && n < this._entries) {
                    component = this.getComponent(n);
                    if (component != null && component instanceof JLabel) {
                        serializable = component.getBounds();
                        if (Player.this._iconViewport != null) {
                            ((Rectangle)serializable).width = 1;
                            ((Rectangle)serializable).x = 0;
                            ((Rectangle)serializable).y = (int)((double)((Rectangle)serializable).y - Player.this._iconViewport.getViewRect().getY());
                            Player.this._iconViewport.scrollRectToVisible((Rectangle)serializable);
                        }
                        JLabel jLabel = (JLabel)component;
                        if (this._hasFocus) {
                            jLabel.setBorder(this._selectedBorder);
                        } else {
                            jLabel.setBorder(this._normalBorder);
                        }
                        jLabel.setBackground(this._selectedBackground);
                    }
                    this._selectedIndex = n;
                } else {
                    this._selectedIndex = -1;
                }
            }
        }

        public void setVisibleColumns(int n) {
            this._visibleColumns = n;
            this.setList(this._cells, this._selectedIndex);
        }

        public void setVisibleRowCount(int n) {
            if (this._entries > 0) {
                int n2 = this._visibleColumns * n;
                int n3 = this._visibleEntries;
                int n4 = Math.max(0, n2 - this._entries);
                while (this._dummyEntries < n4) {
                    JPanel jPanel = new JPanel();
                    jPanel.setBackground(this._normalBackground);
                    this.add(jPanel);
                    ++this._dummyEntries;
                }
                while (this._dummyEntries > n4) {
                    int n5 = this._entries + --this._dummyEntries;
                    this.remove(n5);
                }
                this._visibleEntries = n2;
            }
            this._visibleRows = n;
            this.invalidate();
        }

        public void setIconBorder(int n, boolean bl) {
            if (this.getComponent(n) instanceof JLabel) {
                JLabel jLabel = (JLabel)this.getComponent(n);
                if (bl && jLabel != null) {
                    jLabel.setBorder(this._selectedBorder);
                } else {
                    jLabel.setBorder(this._normalBorder);
                }
            }
        }

        public void setFocus(boolean bl) {
            this._hasFocus = bl;
        }

        public IconList() {
            this.setFixedCellHeight(41);
            this._visibleRows = 3;
            this._visibleColumns = 2;
            this._visibleEntries = 0;
            this.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ IconList this$1;
                {
                    this.this$1 = iconList;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    int n = mouseEvent.getClickCount();
                    if (n == 2 && Player.access$3000(IconList.access$2900(this.this$1)) != null && Player.access$3000(IconList.access$2900(this.this$1)).isEnabled()) {
                        Player.access$3000(IconList.access$2900(this.this$1)).doClick();
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    Component component;
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = 0;
                    if (this.this$1._entries > 0 && (component = this.this$1.getComponent(0)) != null) {
                        int n6 = component.getWidth();
                        int n7 = component.getHeight();
                        if (n6 != 0) {
                            n4 = n / n6;
                        }
                        if (n7 != 0) {
                            n3 = n2 / n7;
                        }
                    }
                    if ((n5 = n3 * this.this$1._columns + n4) >= 0) {
                        this.this$1.requestFocus();
                        IconList.access$2900(this.this$1).getCurrentManager().setSelectedIndex(n5);
                    }
                    this.this$1.setSelectedIndex(n5);
                }
            });
            this.addKeyListener(this);
            this._normalBorder = BorderFactory.createEmptyBorder(4, 6, 4, 6);
            this._selectedBorder = BorderFactory.createCompoundBorder(UIManager.getBorder("List.focusCellHighlightBorder"), BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this._normalBackground = UIManager.getColor("window");
            this._normalForeground = UIManager.getColor("textColor");
            this.setBackground(this._normalBackground);
            this._selectedBackground = UIManager.getColor("textHighlight");
            this._selectedForeground = UIManager.getColor("textHighlightText");
        }

        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.height = this._cellHeight;
            return dimension;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            int n = this._visibleRows - this._dummyEntries / this._columns;
            dimension.height = Math.max(n, this._rows) * this._cellHeight;
            return dimension;
        }

        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return this.getFixedCellHeight();
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = Player.this.getCurrentManager().getSelectedIndex();
            int n2 = 0;
            int n3 = 0;
            if (n >= 0) {
                n2 = n / this._columns;
                n3 = n % this._columns;
            }
            switch (keyEvent.getKeyCode()) {
                case 39: {
                    if (n >= this._entries) break;
                    ++n;
                    break;
                }
                case 37: {
                    if (n <= 0) break;
                    --n;
                    break;
                }
                case 38: {
                    if (n >= this._columns) {
                        n -= this._columns;
                        break;
                    }
                    if (n <= 0) break;
                    --n;
                    break;
                }
                case 40: {
                    if (n + this._columns < this._entries) {
                        n += this._columns;
                        break;
                    }
                    if (n >= this._entries) break;
                    ++n;
                    break;
                }
            }
            if (n != this._selectedIndex && n >= 0 && n < this._entries) {
                Player.this.getCurrentManager().setSelectedIndex(n);
                this.setSelectedIndex(n);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void setList(Vector vector, int n) {
            Object object;
            this._cells = vector;
            this._selectedIndex = n;
            this.removeAll();
            this._entries = this._cells.size();
            this._dummyEntries = 0;
            if (this._entries > 0) {
                this._columns = this._visibleColumns;
                this._rows = (this._entries + (this._columns - 1)) / this._columns;
            } else {
                this._columns = 1;
                this._rows = 1;
            }
            this.setLayout(new IconGridLayout(0, this._columns, this.getFixedCellHeight()));
            int n2 = 0;
            while (n2 < this._entries) {
                object = (IconCell)this._cells.get(n2);
                JLabel jLabel = new JLabel(this, ((IconCell)object).getName(), ((IconCell)object).getIcon(), 2){
                    private final /* synthetic */ IconList this$1;

                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        if (dimension.width > 100) {
                            dimension.width = 100;
                        }
                        return dimension;
                    }
                    {
                        this.this$1 = iconList;
                    }
                };
                jLabel.setOpaque(true);
                jLabel.setVerticalTextPosition(0);
                jLabel.setBorder(this._normalBorder);
                if (n2 == n) {
                    jLabel.setBackground(this._selectedBackground);
                    jLabel.setForeground(this._selectedForeground);
                } else {
                    jLabel.setBackground(this._normalBackground);
                    jLabel.setForeground(this._normalForeground);
                }
                jLabel.setHorizontalTextPosition(11);
                jLabel.setHorizontalAlignment(10);
                this.add(jLabel);
                jLabel.addKeyListener(this);
                ++n2;
            }
            this._visibleEntries = this._visibleRows * this._visibleColumns;
            n2 = this._entries;
            while (n2 < this._visibleEntries) {
                object = new JPanel();
                ((JComponent)object).setBackground(this._normalBackground);
                this.add((Component)object);
                ++this._dummyEntries;
                ++n2;
            }
            this.invalidate();
            Player.this._frame.validate();
        }

        static /* synthetic */ Player access$2900(IconList iconList) {
            return iconList.Player.this;
        }
    }

    private class IndicatorsPanel
    extends JComponent
    implements Accessible {
        private Icon[] _icons = new Icon[4];
        private String[] _toolTips;
        private String[] _unknownToolTips;
        private String[] _yesToolTips;
        private String[] _noToolTips;
        private LazyUpdateCheck _lazyUpdateCheck = null;
        private int _TOTALTOOLTIPWIDTH = 80;

        public void launched() {
            new IndicatorUpdateThread().start();
            if (this._icons[0] != null) {
                this.setIcon(0, null);
            }
            if (this._icons[2] != Player.this._inCache) {
                this.setIcon(2, null);
            }
            this.repaint();
        }

        public boolean isFocusTraversable() {
            return false;
        }

        private void setIcons(JNLEntry jNLEntry) {
            LaunchDesc launchDesc = null;
            boolean bl = false;
            URL uRL = null;
            LocalApplicationProperties localApplicationProperties = null;
            if (jNLEntry == null) {
                int n = 0;
                while (n < 4) {
                    this.setIcon(n++, null);
                }
            } else {
                DiskCacheEntry diskCacheEntry;
                JARDesc jARDesc;
                Icon icon;
                launchDesc = jNLEntry.getLaunchDescriptor();
                if (launchDesc != null) {
                    bl = LaunchDownload.isInCache(launchDesc);
                    uRL = launchDesc.getCanonicalHome();
                    if (uRL != null) {
                        localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(uRL, launchDesc);
                    }
                }
                boolean bl2 = false;
                if (launchDesc != null && !Player.this._isOffline && !launchDesc.isHttps()) {
                    if (this._lazyUpdateCheck == null) {
                        this._lazyUpdateCheck = new LazyUpdateCheck();
                    }
                    this._lazyUpdateCheck.doUpdateCheck(launchDesc);
                }
                if (bl2) {
                    icon = Player.this._updateAvailable;
                    this._toolTips[0] = this._yesToolTips[0];
                } else {
                    icon = null;
                }
                this.setIcon(0, icon);
                if (jNLEntry.canRunOffline()) {
                    icon = Player.this._netNo;
                    this._toolTips[1] = this._noToolTips[1];
                } else {
                    icon = Player.this._netYes;
                    this._toolTips[1] = this._yesToolTips[1];
                }
                this.setIcon(1, icon);
                if (bl) {
                    icon = Player.this._inCache;
                    this._toolTips[2] = this._yesToolTips[2];
                } else {
                    icon = Player.this._notInCache;
                    this._toolTips[2] = this._noToolTips[2];
                }
                this.setIcon(2, icon);
                icon = null;
                if (bl && (jARDesc = launchDesc.getResources().getMainJar(true)) != null && (diskCacheEntry = DownloadProtocol.getCachedVersion(jARDesc.getLocation(), jARDesc.getVersion(), 1)) != null) {
                    if (diskCacheEntry.getCertificateChain() != null) {
                        icon = Player.this._signed;
                        this._toolTips[3] = this._yesToolTips[3];
                    } else {
                        icon = Player.this._unsigned;
                        this._toolTips[3] = this._noToolTips[3];
                    }
                }
                this.setIcon(3, icon);
            }
            this.invalidate();
            this.repaint();
        }

        public IndicatorsPanel() {
            Player.this._updateAvailable = this.loadIcon("resources/updateAvailable.gif");
            Player.this._updateUnavailable = this.loadIcon("resources/updateUnavailable.gif");
            Player.this._online = this.loadIcon("resources/online.gif");
            Player.this._offline = this.loadIcon("resources/offline.gif");
            Player.this._inCache = this.loadIcon("resources/inCache.gif");
            Player.this._notInCache = this.loadIcon("resources/notInCache.gif");
            Player.this._signed = this.loadIcon("resources/signed.gif");
            Player.this._unsigned = this.loadIcon("resources/unsigned.gif");
            Player.this._netYes = this.loadIcon("resources/netYes.gif");
            Player.this._netNo = this.loadIcon("resources/netNo.gif");
            this._toolTips = new String[4];
            this._unknownToolTips = new String[4];
            this._unknownToolTips[0] = Resources.getString("player.updateIndicatorToolTipText");
            this._unknownToolTips[1] = Resources.getString("player.netNeededIndicatorToolTipText");
            this._unknownToolTips[2] = Resources.getString("player.cacheIndicatorToolTipText");
            this._unknownToolTips[3] = Resources.getString("player.securityIndicatorToolTipText");
            this._yesToolTips = new String[4];
            this._yesToolTips[0] = Resources.getString("player.updateAvailableToolTipText");
            this._yesToolTips[1] = Resources.getString("player.netNeededToolTipText");
            this._yesToolTips[2] = Resources.getString("player.inCacheToolTipText");
            this._yesToolTips[3] = Resources.getString("player.signedToolTipText");
            this._noToolTips = new String[4];
            this._noToolTips[0] = Resources.getString("player.updateNotAvailablerToolTipText");
            this._noToolTips[1] = Resources.getString("player.netNotNeededToolTipText");
            this._noToolTips[2] = Resources.getString("player.notInCacheToolTipText");
            this._noToolTips[3] = Resources.getString("player.notSignedToolTipText");
            this.setToolTipText("");
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(10, 10);
            int n = 0;
            while (n < 4) {
                if (this._icons[n] != null) {
                    int n2 = this._icons[n].getIconHeight();
                    int n3 = this._icons[n].getIconWidth();
                    dimension.height = Math.max(dimension.height, n2);
                    dimension.width = Math.max(dimension.width, n3);
                }
                ++n;
            }
            if (Player.this._updateAvailable != null) {
                dimension.height = Math.max(dimension.height, Player.this._updateAvailable.getIconHeight());
            }
            dimension.width = 4 * (dimension.width + 2);
            dimension.height += 4;
            dimension.width += 2;
            return dimension;
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            int n = dimension.width / 4;
            int n2 = dimension.height;
            int n3 = 0;
            if (dimension.width > this._TOTALTOOLTIPWIDTH) {
                n = 20;
                n3 = dimension.width - this._TOTALTOOLTIPWIDTH;
            }
            graphics.setColor(UIManager.getColor("textText"));
            int n4 = 0;
            while (n4 < 4) {
                if (this._icons[n4] != null) {
                    int n5;
                    int n6 = n3 + 2 + n4 * n;
                    int n7 = 0;
                    int n8 = this._icons[n4].getIconWidth();
                    if (n8 < n) {
                        n6 += (n - n8) / 2;
                    }
                    if ((n5 = this._icons[n4].getIconHeight()) < n2) {
                        n7 += (n2 - n5) / 2;
                    }
                    this._icons[n4].paintIcon(this, graphics, n6, n7);
                }
                ++n4;
            }
        }

        public void setIcon(int n, Icon icon) {
            if (n >= 0 && n < 4) {
                this._icons[n] = icon;
                if (icon == null) {
                    this._toolTips[n] = this._unknownToolTips[n];
                }
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            int n3 = this.getWidth();
            boolean bl = false;
            if (n3 > this._TOTALTOOLTIPWIDTH) {
                n2 -= n3 - this._TOTALTOOLTIPWIDTH;
                n3 = this._TOTALTOOLTIPWIDTH;
            }
            if (n3 / 4 != 0 && n2 >= 0 && (n = n2 / (n3 / 4)) >= 0 && n < 4) {
                return this._toolTips[n];
            }
            return null;
        }

        public Icon loadIcon(String string) {
            return new ImageIcon(Toolkit.getDefaultToolkit().getImage((class$com$sun$javaws$ui$player$Player == null ? (class$com$sun$javaws$ui$player$Player = Player.class$("com.sun.javaws.ui.player.Player")) : class$com$sun$javaws$ui$player$Player).getResource(string)));
        }

        private class IndicatorUpdateThread
        extends Thread {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    IndicatorUpdateThread indicatorUpdateThread = this;
                    synchronized (indicatorUpdateThread) {
                        this.wait(30000L);
                    }
                }
                catch (Exception exception) {
                    Debug.ignoredException(exception);
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ IndicatorUpdateThread this$2;

                    public void run() {
                        Player.access$3500(IndicatorsPanel.access$4600(IndicatorUpdateThread.access$4500(this.this$2)));
                    }
                    {
                        this.this$2 = indicatorUpdateThread;
                    }
                });
            }

            private IndicatorUpdateThread() {
            }

            static /* synthetic */ IndicatorsPanel access$4500(IndicatorUpdateThread indicatorUpdateThread) {
                return indicatorUpdateThread.IndicatorsPanel.this;
            }
        }

        class LazyUpdateCheck
        extends Thread {
            private LaunchDesc _next_ld = null;
            private boolean _started = false;
            private Object _signalObject = new Object();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    Object object;
                    try {
                        String string;
                        Icon icon;
                        LaunchDesc launchDesc;
                        object = this;
                        synchronized (object) {
                            launchDesc = this._next_ld;
                        }
                        boolean bl = LaunchDownload.isUpdateAvailable(launchDesc);
                        if (bl) {
                            icon = Player.this._updateAvailable;
                            string = IndicatorsPanel.this._yesToolTips[0];
                        } else {
                            icon = null;
                            string = IndicatorsPanel.this._noToolTips[0];
                        }
                        IndicatorsPanel.this.setIcon(0, icon);
                        ((IndicatorsPanel)IndicatorsPanel.this)._toolTips[0] = string;
                        IndicatorsPanel.this.invalidate();
                        IndicatorsPanel.this.repaint();
                    }
                    catch (JNLPException jNLPException) {
                        Debug.ignoredException(jNLPException);
                    }
                    try {
                        object = this._signalObject;
                        synchronized (object) {
                            this._signalObject.wait();
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        Debug.ignoredException(interruptedException);
                        continue;
                    }
                    break;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doUpdateCheck(LaunchDesc launchDesc) {
                boolean bl = false;
                LazyUpdateCheck lazyUpdateCheck = this;
                synchronized (lazyUpdateCheck) {
                    this._next_ld = launchDesc;
                    if (!this._started) {
                        bl = true;
                        this._started = true;
                    }
                }
                if (bl) {
                    this.start();
                } else {
                    Object object = this._signalObject;
                    synchronized (object) {
                        this._signalObject.notify();
                    }
                }
            }
        }
    }

    private class InstallRunnable
    implements Runnable {
        private ArrayList _entries = new ArrayList();
        private boolean _running;

        private void installCompleted() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ InstallRunnable this$1;

                public void run() {
                    Player.access$3500(InstallRunnable.access$3400(this.this$1));
                }
                {
                    this.this$1 = installRunnable;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            boolean bl = false;
            LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
            while (!bl) {
                object = null;
                LaunchDesc launchDesc = null;
                InstallRunnable installRunnable = this;
                synchronized (installRunnable) {
                    if (this._entries.size() == 0) {
                        bl = true;
                    } else {
                        launchDesc = (LaunchDesc)this._entries.remove(0);
                        object = (LocalApplicationProperties)this._entries.remove(0);
                    }
                }
                if (bl) continue;
                object.refreshIfNecessary();
                if (object.isLocallyInstalled()) {
                    localInstallHandler.uninstall(launchDesc, (LocalApplicationProperties)object);
                    object.setAskedForInstall(false);
                } else {
                    localInstallHandler.install(Player.this._frame, launchDesc, (LocalApplicationProperties)object);
                    object.setAskedForInstall(true);
                }
                try {
                    object.store();
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
                this.installCompleted();
            }
            object = this;
            synchronized (object) {
                if (this._entries.size() == 0) {
                    this._running = false;
                }
            }
            this.installCompleted();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isInstalling() {
            boolean bl = false;
            InstallRunnable installRunnable = this;
            synchronized (installRunnable) {
                bl = this._running;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void installOrUninstall(JNLEntry jNLEntry) {
            LocalInstallHandler localInstallHandler;
            LocalApplicationProperties localApplicationProperties;
            LaunchDesc launchDesc;
            if (jNLEntry != null && (launchDesc = jNLEntry.getLaunchDescriptor()) != null && (localApplicationProperties = jNLEntry.getLocalApplicationProperties()) != null && (localInstallHandler = LocalInstallHandler.getInstance()) != null) {
                boolean bl = false;
                InstallRunnable installRunnable = this;
                synchronized (installRunnable) {
                    this._entries.add(launchDesc);
                    this._entries.add(localApplicationProperties);
                    if (!this._running) {
                        this._running = true;
                        bl = true;
                    }
                }
                if (bl) {
                    new Thread(this).start();
                }
            }
        }

        static /* synthetic */ Player access$3400(InstallRunnable installRunnable) {
            return installRunnable.Player.this;
        }
    }

    private class ManagerListEntry {
        String _managerName;
        EntryManager _manager;
        String _managerClassName;
        JMenuItem _menuItem;

        public EntryManager getManager() {
            return this._manager;
        }

        public void setManager(EntryManager entryManager) {
            this._manager = entryManager;
        }

        public String getManagerClassName() {
            return this._managerClassName;
        }

        public String getManagerName() {
            return this._managerName;
        }

        public JMenuItem getMenuItem() {
            return this._menuItem;
        }

        public ManagerListEntry(String string, EntryManager entryManager, String string2, JMenuItem jMenuItem) {
            this._managerName = string;
            this._manager = entryManager;
            this._managerClassName = string2;
            this._menuItem = jMenuItem;
        }
    }

    private class PlayerLabel
    extends JLabel {
        public PlayerLabel() {
            this.setForeground(UIManager.getColor("textText"));
        }

        public PlayerLabel(String string) {
            super(string);
            this.setForeground(UIManager.getColor("textText"));
        }
    }

    private class ScaledImageIcon
    implements Icon {
        ImageIcon _imageIcon;
        int _width;
        int _height;

        public int getIconHeight() {
            return this._height;
        }

        public int getIconWidth() {
            return this._width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.drawImage(this._imageIcon.getImage(), n, n2, this._width, this._height, component);
        }

        public ScaledImageIcon(ImageIcon imageIcon, int n, int n2) {
            this._imageIcon = imageIcon;
            this._width = n;
            this._height = n2;
        }
    }
}

