/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.print.Paper;

public class PageFormat
implements Cloneable {
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int REVERSE_LANDSCAPE = 2;
    private Paper mPaper = new Paper();
    private int mOrientation = 1;

    public double getHeight() {
        int n2 = this.getOrientation();
        double d2 = n2 == 1 ? this.mPaper.getHeight() : this.mPaper.getWidth();
        return d2;
    }

    public double getImageableHeight() {
        double d2 = this.getOrientation() == 1 ? this.mPaper.getImageableHeight() : this.mPaper.getImageableWidth();
        return d2;
    }

    public double getImageableWidth() {
        double d2 = this.getOrientation() == 1 ? this.mPaper.getImageableWidth() : this.mPaper.getImageableHeight();
        return d2;
    }

    public double getImageableX() {
        double d2;
        switch (this.getOrientation()) {
            case 0: {
                d2 = this.mPaper.getHeight() - (this.mPaper.getImageableY() + this.mPaper.getImageableHeight());
                break;
            }
            case 1: {
                d2 = this.mPaper.getImageableX();
                break;
            }
            case 2: {
                d2 = this.mPaper.getImageableY();
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return d2;
    }

    public double getImageableY() {
        double d2;
        switch (this.getOrientation()) {
            case 0: {
                d2 = this.mPaper.getImageableX();
                break;
            }
            case 1: {
                d2 = this.mPaper.getImageableY();
                break;
            }
            case 2: {
                d2 = this.mPaper.getWidth() - (this.mPaper.getImageableX() + this.mPaper.getImageableWidth());
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return d2;
    }

    public double getWidth() {
        int n2 = this.getOrientation();
        double d2 = n2 == 1 ? this.mPaper.getWidth() : this.mPaper.getHeight();
        return d2;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public double[] getMatrix() {
        double[] dArray = new double[6];
        switch (this.mOrientation) {
            case 0: {
                dArray[0] = 0.0;
                dArray[1] = -1.0;
                dArray[2] = 1.0;
                dArray[3] = 0.0;
                dArray[4] = 0.0;
                dArray[5] = this.mPaper.getHeight();
                break;
            }
            case 1: {
                dArray[0] = 1.0;
                dArray[1] = 0.0;
                dArray[2] = 0.0;
                dArray[3] = 1.0;
                dArray[4] = 0.0;
                dArray[5] = 0.0;
                break;
            }
            case 2: {
                dArray[0] = 0.0;
                dArray[1] = 1.0;
                dArray[2] = -1.0;
                dArray[3] = 0.0;
                dArray[4] = this.mPaper.getWidth();
                dArray[5] = 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return dArray;
    }

    public void setOrientation(int n2) throws IllegalArgumentException {
        if (0 > n2 || n2 > 2) {
            throw new IllegalArgumentException();
        }
        this.mOrientation = n2;
    }

    public Paper getPaper() {
        return (Paper)this.mPaper.clone();
    }

    public void setPaper(Paper paper) {
        this.mPaper = (Paper)paper.clone();
    }

    public Object clone() {
        PageFormat pageFormat;
        try {
            pageFormat = (PageFormat)super.clone();
            pageFormat.mPaper = (Paper)this.mPaper.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            pageFormat = null;
        }
        return pageFormat;
    }
}

