/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LookAndFeel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorChooserComponentFactory;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorChooserUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.CenterLayout;

public class BasicColorChooserUI
extends ColorChooserUI {
    JColorChooser chooser;
    JTabbedPane tabbedPane;
    JPanel singlePanel;
    JPanel previewPanelHolder;
    JComponent previewPanel;
    MouseListener previewMouseListener;
    boolean isMultiPanel = false;
    private static TransferHandler defaultTransferHandler = new ColorTransferHandler();
    protected AbstractColorChooserPanel[] defaultChoosers;
    protected ChangeListener previewListener;
    protected PropertyChangeListener propertyChangeListener;

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.chooser, "ColorChooser.background", "ColorChooser.foreground", "ColorChooser.font");
        TransferHandler transferHandler = this.chooser.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.chooser.setTransferHandler(defaultTransferHandler);
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.chooser.addPropertyChangeListener(this.propertyChangeListener);
        this.previewListener = new PreviewListener();
        this.chooser.getSelectionModel().addChangeListener(this.previewListener);
    }

    protected void installPreviewPanel() {
        if (this.previewPanel != null) {
            this.previewPanelHolder.remove(this.previewPanel);
            this.previewPanel.removeMouseListener(this.previewMouseListener);
        }
        this.previewPanel = this.chooser.getPreviewPanel();
        if (this.previewPanel != null && this.previewPanelHolder != null && this.chooser != null && this.previewPanel.getSize().getHeight() + this.previewPanel.getSize().getWidth() == 0.0) {
            this.chooser.remove(this.previewPanelHolder);
            return;
        }
        if (this.previewPanel == null || this.previewPanel instanceof UIResource) {
            this.previewPanel = ColorChooserComponentFactory.getPreviewPanel();
            this.chooser.setPreviewPanel(this.previewPanel);
        }
        this.previewPanel.setForeground(this.chooser.getColor());
        this.previewPanelHolder.add(this.previewPanel);
        this.previewPanel.addMouseListener(this.previewMouseListener);
    }

    protected void uninstallDefaultChoosers() {
        for (int i2 = 0; i2 < this.defaultChoosers.length; ++i2) {
            this.chooser.removeChooserPanel(this.defaultChoosers[i2]);
        }
    }

    protected void uninstallDefaults() {
        if (this.chooser.getTransferHandler() instanceof UIResource) {
            this.chooser.setTransferHandler(null);
        }
    }

    protected void uninstallListeners() {
        this.chooser.removePropertyChangeListener(this.propertyChangeListener);
        this.chooser.getSelectionModel().removeChangeListener(this.previewListener);
        this.previewPanel.removeMouseListener(this.previewMouseListener);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    public void installUI(JComponent jComponent) {
        this.chooser = (JColorChooser)jComponent;
        super.installUI(jComponent);
        this.installDefaults();
        this.installListeners();
        this.tabbedPane = new JTabbedPane();
        this.singlePanel = new JPanel(new CenterLayout());
        this.chooser.setLayout(new BorderLayout());
        this.defaultChoosers = this.createDefaultChoosers();
        this.chooser.setChooserPanels(this.defaultChoosers);
        this.previewPanelHolder = new JPanel(new CenterLayout());
        String string = UIManager.getString((Object)"ColorChooser.previewText", this.chooser.getLocale());
        this.previewPanelHolder.setBorder(new TitledBorder(string));
        this.chooser.add((Component)this.previewPanelHolder, "South");
        this.previewMouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (BasicColorChooserUI.this.chooser.getDragEnabled()) {
                    TransferHandler transferHandler = BasicColorChooserUI.this.chooser.getTransferHandler();
                    transferHandler.exportAsDrag(BasicColorChooserUI.this.chooser, mouseEvent, 1);
                }
            }
        };
        this.installPreviewPanel();
        this.chooser.applyComponentOrientation(jComponent.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.chooser.remove(this.tabbedPane);
        this.chooser.remove(this.singlePanel);
        this.chooser.remove(this.previewPanelHolder);
        this.uninstallListeners();
        this.uninstallDefaultChoosers();
        this.uninstallDefaults();
        this.previewPanelHolder.remove(this.previewPanel);
        if (this.previewPanel instanceof UIResource) {
            this.chooser.setPreviewPanel(null);
        }
        this.previewPanelHolder = null;
        this.previewPanel = null;
        this.defaultChoosers = null;
        this.chooser = null;
        this.tabbedPane = null;
    }

    protected AbstractColorChooserPanel[] createDefaultChoosers() {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = ColorChooserComponentFactory.getDefaultChooserPanels();
        return abstractColorChooserPanelArray;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicColorChooserUI();
    }

    static class ColorTransferHandler
    extends TransferHandler
    implements UIResource {
        ColorTransferHandler() {
            super("color");
        }
    }

    class PreviewListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            ColorSelectionModel colorSelectionModel = (ColorSelectionModel)changeEvent.getSource();
            if (BasicColorChooserUI.this.previewPanel != null) {
                BasicColorChooserUI.this.previewPanel.setForeground(colorSelectionModel.getSelectedColor());
                BasicColorChooserUI.this.previewPanel.repaint();
            }
        }

        PreviewListener() {
        }
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2;
            if (propertyChangeEvent.getPropertyName().equals("chooserPanels")) {
                Container container;
                Container container2;
                int n2;
                object2 = (AbstractColorChooserPanel[])propertyChangeEvent.getOldValue();
                object = (AbstractColorChooserPanel[])propertyChangeEvent.getNewValue();
                for (n2 = 0; n2 < ((AbstractColorChooserPanel[])object2).length; ++n2) {
                    container2 = object2[n2].getParent();
                    if (container2 == null) continue;
                    container = container2.getParent();
                    if (container != null) {
                        container.remove(container2);
                    }
                    object2[n2].uninstallChooserPanel(BasicColorChooserUI.this.chooser);
                }
                n2 = ((AbstractColorChooserPanel[])object).length;
                if (n2 == 0) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    return;
                }
                if (n2 == 1) {
                    BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.tabbedPane);
                    container2 = new JPanel(new CenterLayout());
                    container2.add((Component)object[0]);
                    BasicColorChooserUI.this.singlePanel.add((Component)container2, "Center");
                    BasicColorChooserUI.this.chooser.add(BasicColorChooserUI.this.singlePanel);
                } else {
                    if (((AbstractColorChooserPanel[])object2).length < 2) {
                        BasicColorChooserUI.this.chooser.remove(BasicColorChooserUI.this.singlePanel);
                        BasicColorChooserUI.this.chooser.add((Component)BasicColorChooserUI.this.tabbedPane, "Center");
                    }
                    for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                        container = new JPanel(new CenterLayout());
                        String string = ((AbstractColorChooserPanel)object[i2]).getDisplayName();
                        int n3 = ((AbstractColorChooserPanel)object[i2]).getMnemonic();
                        container.add((Component)object[i2]);
                        BasicColorChooserUI.this.tabbedPane.addTab(string, container);
                        if (n3 <= 0) continue;
                        BasicColorChooserUI.this.tabbedPane.setMnemonicAt(i2, n3);
                        BasicColorChooserUI.this.tabbedPane.setDisplayedMnemonicIndexAt(i2, ((AbstractColorChooserPanel)object[i2]).getDisplayedMnemonicIndex());
                    }
                }
                BasicColorChooserUI.this.chooser.applyComponentOrientation(BasicColorChooserUI.this.chooser.getComponentOrientation());
                for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                    ((AbstractColorChooserPanel)object[i3]).installChooserPanel(BasicColorChooserUI.this.chooser);
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("previewPanel") && propertyChangeEvent.getNewValue() != BasicColorChooserUI.this.previewPanel) {
                BasicColorChooserUI.this.installPreviewPanel();
            }
            if (propertyChangeEvent.getPropertyName().equals("componentOrientation")) {
                object2 = (ComponentOrientation)propertyChangeEvent.getNewValue();
                object = (JColorChooser)propertyChangeEvent.getSource();
                if (object2 != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    ((Container)object).applyComponentOrientation((ComponentOrientation)object2);
                    ((JColorChooser)object).updateUI();
                }
            }
        }
    }
}

