/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import sun.plugin.security.CertificateStore;
import sun.plugin.util.Trace;
import sun.plugin.util.UserProfile;

public final class RootCACertificateStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _cacerts = null;

    static {
        _filename = UserProfile.getRootCertificateFile();
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("rootcertstore.cert.loading", new Object[]{_filename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (RootCACertificateStore.this._cacerts == null) {
                        RootCACertificateStore.this._cacerts = KeyStore.getInstance("JKS");
                        RootCACertificateStore.this._cacerts.load(null, null);
                    }
                    if ((file = new File(_filename)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        RootCACertificateStore.this._cacerts.load(bufferedInputStream, null);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    } else {
                        Trace.msgSecurityPrintln("rootcertstore.cert.noload", new Object[]{_filename});
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("rootcertstore.cert.loaded", new Object[]{_filename});
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("rootcertstore.cert.saving", new Object[]{_filename});
    }

    public KeyStore getKeyStore() {
        Trace.msgSecurityPrintln("rootcertstore.cert.getkeystore");
        return this._cacerts;
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.adding");
        throw new KeyStoreException("Cannot add root CA certificate");
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.removing");
        throw new KeyStoreException("Cannot remove root CA certificate");
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.instore");
        return this._cacerts.getCertificateAlias(certificate) != null;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.canverify");
        StringBuffer stringBuffer = new StringBuffer();
        Trace.msgSecurityPrintln("rootcertstore.cert.tobeverified", new Object[]{certificate});
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate2 = this._cacerts.getCertificate(string);
            Trace.msgSecurityPrintln("rootcertstore.cert.tobecompared", new Object[]{certificate2});
            try {
                certificate.verify(certificate2.getPublicKey());
                Trace.msgSecurityPrintln("rootcertstore.cert.verify.ok");
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        Trace.msgSecurityPrintln("rootcertstore.cert.verify.fail");
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.iterator");
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._cacerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._cacerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }
}

