/*
  Copyright (c) 2000 Caldera Systems

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __cardpageimpl_h__
#define __cardpageimpl_h__

#include "videocardpage.h"
#include "kxpage.h"
#include "kxdata.h"

class VideoCardPage : public VideoCardPageBase, public KXPage
{
    Q_OBJECT
    Q_PROPERTY( QString quickHelp READ quickHelp )
public:
    VideoCardPage( QWidget *parent, const char *name = 0 );
    virtual ~VideoCardPage();

    // reimplemented from KXPage
    virtual void load();
    virtual void save();

    QString quickHelp() const;

signals:
    void enableForward( bool enable );
    void changed();

private slots:
    void vendorSelected( QListViewItem *item );
    void videoCardSelected( QListViewItem *item );

private:
    KXVideoCardData m_current;
};

#endif
