/*
    KTip, the KDE Tip Of the Day

	Copyright (c) 2000, Matthias Hoelzer-Kluepfel
	Copyright (c) 2002 Tobias Koenig <tokoe82@yahoo.de>

    This program is free software; you can redistribute it and/or
    modify it under the terms of version 2 of the GNU General Public
    License as published by the Free Software Foundation

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <dcopclient.h>

#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <ktip.h>
#include <kuniqueapplication.h>
#include <kwin.h>
#include <stdlib.h>

static const char *description = I18N_NOOP("Kandalf's tips");

int main(int argc, char *argv[])
{
	KAboutData aboutData("ktip", I18N_NOOP("KTip"),
				"0.3", description, KAboutData::License_GPL,
				"(c) 1998-2002, KDE Developers");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KUniqueApplication::addCmdLineOptions();

	if (!KUniqueApplication::start())
		exit(-1);

	KUniqueApplication app;
	
	KTipDialog *tipDialog = new KTipDialog(new KTipDatabase(locate("data", QString("kdewizard/tips"))));
	Q_CHECK_PTR(tipDialog);
	KWin::setState(tipDialog->winId(), NET::StaysOnTop);
	tipDialog->setCaption(i18n("Kandalf's Useful Tips"));
	app.dcopClient()->send("ksplash", "ksplash", "close()", QByteArray()); // Close splash screen
	tipDialog->show();

	QObject::connect(qApp, SIGNAL(lastWindowClosed()), qApp, SLOT(quit()));

	app.setMainWidget(tipDialog);
	
	return app.exec();
}
