#ifndef __EXTENSION_H__
#define __EXTENSION_H__

#include <X11/Xlib.h>
#define explicit int_explicit        // avoid compiler name clash in XKBlib.h
#include <X11/XKBlib.h> 
#undef explicit

class XKBExtension
{
public:

  XKBExtension(Display *display=0);
    ~XKBExtension();

  int init();    
  int setLayout(const QString& rule, const QString& model, const QString& layout, const char* variant, const QString &encoding, unsigned int group);
  int setXkbOptions(const QString& options, bool resetOldOptions);
  int setGroup(int group);
  int getGroup();
  bool getCompiledLayout(const QString &fileName);
  bool setCompiledLayout(const QString &fileName);

private:

  Display *m_dpy;
  Atom qt_input_encoding;
  int m_xkb_opcode;
};

#endif
