package org.kde.koala;
import org.kde.qt.*;


/** {@link KIconCanvas} emits these signals */
public interface KIconCanvasSignals {
	void pressed( QIconViewItem arg1, QPoint arg2 );
	void verticalSliderPressed();
	void startLoading( int arg1 );
	void horizontalSliderPressed();

/** 
 This signal is emitted whenever the user executes an iconview item.
 That means depending on the KDE wide Single Click/Double Click
 setting the user clicked or double clicked on that item.

 Note that you may not delete any {@link QIconViewItem} objects in slots
 connected to this signal.
   
*/
	void executed( QIconViewItem item, QPoint pos );
	void rightButtonClicked( QIconViewItem item, QPoint pos );
	void rightButtonPressed( QIconViewItem item, QPoint pos );
	void onViewport();
	void onItem( QIconViewItem item );
	void returnPressed( QIconViewItem item );
	void contentsMoving( int x, int y );
	void progress( int arg1 );
//	void dropped( QDropEvent e, QIconDragItemValueList lst );
	void currentChanged( QIconViewItem item );
	void itemRenamed( QIconViewItem item );

/** 
 Emitted when the current icon has changed.
     
*/
	void nameChanged( String arg1 );
	void destroyed( QObject obj );
	void contextMenuRequested( QIconViewItem item, QPoint pos );
	void verticalSliderReleased();
	void selectionChanged( QIconViewItem item );
	void moved();
	void finished();

/** 
 This signal gets emitted whenever the user double clicks into the
 iconview.

 Note that you may not delete any {@link QIconViewItem} objects in slots
 connected to this signal.

 This signal is more or less here for the sake of completeness.
 You should normally not need to use this. In most cases its better
 to use {@link KIconCanvas#executed} instead.
   
*/
	void doubleClicked( QIconViewItem item, QPoint pos );
	void horizontalSliderReleased();
	void mouseButtonClicked( int button, QIconViewItem item, QPoint pos );
	void mouseButtonPressed( int button, QIconViewItem item, QPoint pos );
	void clicked( QIconViewItem arg1, QPoint arg2 );
}

