/***************************************************************************
                            MidiOut.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 External MIDI port output class . This class is used to send midi
 events to external midi devices.

 MidiOut is inherited by other MIDI devices classes
 (like {@link SynthOut} or {@link FMOut}) to support a common API.

 In general, you don't want to use MidiOut directly, but within a
 {@link DeviceManager} object, which is the preferred way to generate music.

 If you want to add support for other devices (I don't think
 there are any) you just have to create a class that inherits from MidiOut
 and create one object of your new class in
 {@link DeviceManager#initManager}.

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to external MIDI devices.
*/
public class  MidiOut implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected MidiOut(Class dummy){}

	private native void newMidiOut( int d);

/** 
 Constructor. After constructing a MidiOut device, you must open it
 (using {@link #openDev} ). Additionally you may want to initialize it
 (with {@link #initDev} ),
   
*/
	public MidiOut( int d) {
		newMidiOut( d);
	}
	private native void newMidiOut();
	public MidiOut() {
		newMidiOut();
	}

/** 
 Destructor. It doesn't matter if you close the device ({@link #closeDev} )
 before you destruct the object because in other case, it will be closed
 here.
   
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Opens the device. This is generally called from {@link DeviceManager} , so you
 shouldn't call this yourself (except if you created the MidiOut object
 yourself.

*/
	public native void openDev( int sqfd);

/** 
 Closes the device. It basically tells the device (the file descriptor)
 is going to be closed.

*/
	public native void closeDev();

/** 
 Initializes the device sending generic standard midi events and controllers,
 such as changing the patches of each channel to an Acoustic Piano (000),
 setting the volume to a normal value, etc.
   
*/
	public native void initDev();

/** 

 which are defined in midispec.h

*/
	public native int deviceType();

/** 
 Returns the name and type of this MIDI device.

*/
	public native String deviceName();

/** 
 Sets a {@link MidiMapper} object to be used to modify the midi events before
 sending them.

*/
	public native void setMidiMapper( MidiMapper map);

/** 
 See {@link DeviceManager#noteOn}
   
*/
	public native void noteOn( String chn, String note, String vel);

/** 
 See {@link DeviceManager#noteOff}
   
*/
	public native void noteOff( String chn, String note, String vel);

/** 
 See {@link DeviceManager#keyPressure}
   
*/
	public native void keyPressure( String chn, String note, String vel);

/** 
 See {@link DeviceManager#chnPatchChange}
   
*/
	public native void chnPatchChange( String chn, String patch);

/** 
 See {@link DeviceManager#chnPressure}
   
*/
	public native void chnPressure( String chn, String vel);

/** 
 See {@link DeviceManager#chnPitchBender}
   
*/
	public native void chnPitchBender( String chn, String lsb, String msb);

/** 
 See {@link DeviceManager#chnController}
   
*/
	public native void chnController( String chn, String ctl, String v);

/** 
 See {@link DeviceManager#sysex}
   
*/
	public native void sysex( String data, long size);

/** 
 Send a All Notes Off event to every channel
   
*/
	public native void allNotesOff();

/** 
 Mutes all notes being played on a given channel.
   
*/
	public native void channelSilence( String chn);

/** 
 Mute or "unmute" a given channel .

*/
	public native void channelMute( String chn, int a);

/** 
 Change all channel volume events multiplying it by this percentage correction
 Instead of forcing a channel to a fixed volume, this method allows to
 music to fade out even when it was being played softly.

*/
	public native void setVolumePercentage( int volper);

/** 
 Returns true if everything's ok and false if there has been any problem
   
*/
	public native int ok();

/** 
 Returns the path to the file where the current used {@link MidiMapper} object
 reads the configuration from, or an empty string if there's no MidiMapper.
   
*/
	public native String midiMapFilename();

/** 
 Sends the buffer to the device and returns when it's played, so you can
 synchronize
 XXX: sync should be virtual after next bic release
   
*/
	public native void sync( int i);
	public native void sync();

/** 

 This is the /dev/sequencer file handler.
 Remember _not_to_close_ it on MidiOut, but just on DeviceManager
   
*/
	protected native void seqbuf_dump();
	protected native void seqbuf_clean();
}
