/***************************************************************************
                          Kwin4  -  Four in a Row for KDE
                             -------------------
    begin                : March 2000 
    copyright            : (C) 1995-2001 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWIN4VIEW_H
#define KWIN4VIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>
#include <qcanvas.h>
//#include <kprinter.h>
//

#include <kgameio.h>
#include "kspritecache.h"


class Kwin4Doc;
class ScoreWidget;
class StatusWidget;

/** The Kwin4View class provides the view widget for the Kwin4App instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As Kwin4View is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the Kwin4App class to manipulate and display
 * the document structure provided by the Kwin4Doc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class Kwin4View : public QCanvasView
{
  Q_OBJECT
  public:
    /** Constructor for the main view */
    Kwin4View(QString grafixdir,QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~Kwin4View();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a Kwin4App instance as a parent
     * widget to get to the window document pointer by calling the Kwin4App::getDocument() method.
     *
     * @see Kwin4App#getDocument
     */
    Kwin4Doc *getDocument() const;

  //  ------ NEW  ------------
  QPixmap *loadPixmap(QString name);
  void initView(bool deleteall=true);
  void drawBoard(bool remove=false);
  void drawIntro(bool remove=false);
  void hideIntro();
  void drawStar(int x,int y,int no);
  void setArrow(int x,int color);
  void setPiece(int x,int y,int color,int no,bool animation=true);
  void setHint(int x,int y,bool enabled);
  ScoreWidget *scoreWidget() {return mScoreWidget;}
  StatusWidget *statusWidget() {return mStatusWidget;}
  void setSprite(int no,int x, int col, bool enable);
  /**
  * hide all error text sprites
  **/
  void clearError();
  /**
  * Called by the doc/app to signal the end of the game
  */
  void EndGame();

  public slots:
  /**
   * This slot is called when a mouse event is received. It then prduces a
   * valid move for the game.
   **/
    void slotMouseInput(KGameIO *input,QDataStream &stream,QMouseEvent *e,bool *eatevent);

  /**
   * This slot is called when a key event is received. It then prduces a
   * valid move for the game.
   **/
    void slotKeyInput(KGameIO *input,QDataStream &stream,QKeyEvent *e,bool *eatevent);

    /** 
    * received after the movment of an intro sprite is finished
    **/
    void introMoveDone(QCanvasItem *item,int mode);
 	
  protected:
  void resizeEvent(QResizeEvent *e);
  bool wrongPlayer(KPlayer *player,KGameIO::IOMode io);


	
private:
  QCanvas *mCanvas;    // our drawing canvas
  KSpriteCache *mCache; // The sprite cache
  QString mGrafix;      // grafix dir
  ScoreWidget *mScoreWidget; // score widget
  StatusWidget *mStatusWidget; // score widget

  int mLastArrow;       // last drawn arrow
  int mLastX;           // last piece
  int mLastY;
  int mSpreadX;         // spread x,y board pieces
  int mSpreadY;
  int mBoardX;          // board offset
  int mBoardY;
};

#endif // KWIN4VIEW_H
