/*
* pop.h -- Declaration of class KPop3Drop.
* Generated by newclass on Tue Apr 21 18:12:41 EST 1998.
*/
#ifndef SSK_POPDROP_H
#define SSK_POPDROP_H

#include<qstring.h>
#include "polldrop.h"

class DwPopClient;
class QWidget;
class KDropDialog;

/**
* Polling monitor for POP3 maildrops.
* @author Sirtaj Singh Kang (taj@kde.org)
* @version $Id: pop.h,v 1.4 2002/03/29 05:20:32 tibirna Exp $
*/
class KPop3Drop : public KPollableDrop
{
private:
	QString _server;
	int	_port;

	QString _user;
	QString _password;
	bool	_savePassword;

	bool _valid;

	bool _apopAuth;

	DwPopClient *_pop;

public:
	static const char *HostConfigKey;
	static const char *PortConfigKey;
	static const char *ApopConfigKey;
	static const char *UserConfigKey;
	static const char *PassConfigKey;
	static const char *SavePassConfigKey;
	static const int  DefaultPort;

public:
	/**
	* KPop3Drop Constructor
	*/
	KPop3Drop();

	/** 
	  * Set the POP3 server that will be checked for new mail.
	 */
	void setPopServer(const QString & server, int port = DefaultPort, bool apop = false);

	/** Set the account information for the POP server. */
	void setUser(const QString & user, const QString & password, bool
		savepwd = false );

	QString server() const { return _server; }
	int port() const { return _port; }

	QString user() const { return _user; }
	QString password() const { return _password; }

	virtual void recheck();

	virtual bool valid();

	virtual bool apopAuth();

	/**
	* KPop3Drop Destructor
	*/
	virtual ~KPop3Drop();


	virtual KMailDrop* clone () const ;
	virtual bool readConfigGroup ( const KConfigBase& cfg );
	virtual bool writeConfigGroup ( KConfigBase& cfg ) const;
	virtual QString type() const { return QString::fromUtf8("pop3"); }

	virtual void addConfigPage( KDropCfgDialog * );

private:
	KPop3Drop& operator = ( const KPop3Drop& );
	static void encrypt( QString& str );
	static void decrypt( QString& str );
};

#endif // SSK_POPDROP_H
