 /*  Copyright (C) 2001-2003 Edscott Wilson Garcia under GNU GPL
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "misc.h"

extern void *smb_object;
extern GtkTreeView *smb_treeview;
static char password[_POSIX_PATH_MAX];
static GtkWidget * user, *passwd, *dialog;
static int passwd_caso;
char *challenges[]={
	  "Error opening local file",
	  "ERRDOS",
	  "ERRSRV",
	  "ERRbadpw", /* before samba 2.2.3 */
	  "NT_STATUS_WRONG_PASSWORD", 
	  "NT_STATUS_ACCESS_DENIED",
	  "NT_STATUS_ILL_FORMED_PASSWORD",
	  "NT_STATUS_PASSWORD_RESTRICTION",
	  "NT_STATUS_NO_SUCH_USER",
	  "NT_STATUS_LOGON_FAILURE",
	  "NT_STATUS_ACCOUNT_RESTRICTION",
	  "NT_STATUS_INVALID_LOGON_HOURS",
	  "NT_STATUS_INVALID_WORKSTATION",
	  "NT_STATUS_PASSWORD_EXPIRED",
	  "NT_STATUS_NETWORK_ACCESS_DENIED",
	  "NT_STATUS_ACCOUNT_DISABLED",
	  NULL
};
char *smb_errors[]={
	  "Error opening local file",
	  "ERRDOS",
	  "ERRSRV",
	  "NT_STATUS_ACCESS_DENIED",
	  "NT_STATUS_DIRECTORY_NOT_EMPTY",
	  "NT_STATUS_OBJECT_NAME_NOT_FOUND",
	  "NT_STATUS_NO_SUCH_FILE",
	  "NT_STATUS_OBJECT_NAME_INVALID",
	  NULL
};

typedef struct dostext_t {
	unsigned char readable;
	unsigned char unreadable;
} dostext_t;

/* starts at 0xc0 */
static dostext_t dostext[]={
 {0xc0, 0xb7}, /*  */
 {0xc1, 0xb5}, /*  */
 {0xc2, 0xb6}, /*  */
 {0xc3, 0xc7}, /*  */
 {0xc4, 0x8e}, /*  */
 {0xc5, 0x8f}, /*  */
 {0xc6, 0x92}, /*  */
 {0xc7, 0x80}, /*  */
 {0xc8, 0xd4}, /*  */
 {0xc9, 0x90}, /*  */
 {0xca, 0xd2}, /*  */
 {0xcb, 0xd3}, /*  */
 {0xcc, 0xde}, /*  */
 {0xcd, 0xd6}, /*  */
 {0xce, 0xd7}, /*  */
 {0xcf, 0xd8}, /*  */
 {0xd0, 0xd1}, /*  */
 {0xd1, 0xa5}, /*  */
 {0xd2, 0xe3}, /*  */
 {0xd3, 0xe0}, /*  */
 {0xd4, 0xe2}, /*  */
 {0xd5, 0xe5}, /*  */
 {0xd6, 0x99}, /*  */
 {0xd7, 0x9e}, /*  */
 {0xd8, 0x9d}, /*  */
 {0xd9, 0xeb}, /*  */
 {0xda, 0xe9}, /*  */
 {0xdb, 0xea}, /*  */
 {0xdc, 0x9a}, /*  */
 {0xdd, 0xed}, /*  */
 {0xde, 0xe8}, /*  */
 {0xdf, 0xe1}, /*  */
 {0xe0, 0x85}, /*  */
 {0xe1, 0xa0}, /*  */
 {0xe2, 0x83}, /*  */
 {0xe3, 0xc6}, /*  */
 {0xe4, 0x84}, /*  */
 {0xe5, 0x86}, /*  */
 {0xe6, 0x91}, /*  */
 {0xe7, 0x87}, /*  */
 {0xe8, 0x8a}, /*  */
 {0xe9, 0x82}, /*  */
 {0xea, 0x88}, /*  */
 {0xeb, 0x89}, /*  */
 {0xec, 0x8d}, /*  */
 {0xed, 0xa1}, /*  */
 {0xee, 0x8c}, /*  */
 {0xef, 0x8b}, /*  */
 {0xf0, 0xd0}, /*  */
 {0xf1, 0xa4}, /*  */
 {0xf2, 0x95}, /*  */
 {0xf3, 0xa2}, /*  */
 {0xf4, 0x93}, /*  */
 {0xf5, 0xe4}, /*  */
 {0xf6, 0x94}, /*  */
 {0xf7, 0xf6}, /*  */
 {0xf8, 0x9b}, /*  */
 {0xf9, 0x97}, /*  */
 {0xfa, 0xa3}, /*  */
 {0xfb, 0x96}, /*  */
 {0xfc, 0x81}, /*  */
 {0xfd, 0xec}, /*  */
 {0xfe, 0xe7}, /*  */
 {0,0}
};

void 
free_data(gpointer data,gpointer user_data){
	g_free((char *)(data));
	data=NULL;
}

static void dos_txt (char *the_char,gboolean readable){
  unsigned char *c;
  dostext_t *t;
  for (c=(unsigned char *) the_char; c[0]!=0; c++)  {
	  t=dostext;
	  while (t->readable){
		  if (readable){
			if (c[0] == t->unreadable) {c[0] = t->readable; break;}
		  } else {
			if (c[0] == t->readable) {c[0] = t->unreadable; break;}
		  }
		  t++;	  
	  }
  }
}

void ascii_readable (char *the_char) {
        /*print_diagnostics("DBG: ascii_readable=");print_diagnostics(the_char);*/
	dos_txt(the_char,TRUE);
        /*print_diagnostics("-->");print_diagnostics(the_char);print_diagnostics("\n");*/
}
void ascii_unreadable (char *the_char) {
        /*print_diagnostics("DBG: ascii_unreadable=");print_diagnostics(the_char);*/
	dos_txt(the_char,FALSE);
        /*print_diagnostics("-->");print_diagnostics(the_char);print_diagnostics("\n");*/
}

static void
destroy_dialog (GtkWidget * widget, gpointer data)
{
  gtk_widget_destroy ((GtkWidget *) data);
  gtk_main_quit ();
}

static void
cancel_dialog (GtkWidget * widget, gpointer data)
{
  password[0]=0;
  gtk_widget_destroy ((GtkWidget *) data);
  gtk_main_quit ();
}

static void
ok_dialog (GtkWidget * widget, gpointer data)
{
  char *s, *t;
  int caso;

  caso = (int) ((long) data);

  s = (char *)gtk_entry_get_text (GTK_ENTRY (user));
  t = (char *)gtk_entry_get_text (GTK_ENTRY (passwd));
  if (!strlen(s)) s="Guest";


  if (strlen (t) > 0) snprintf (password, _POSIX_PATH_MAX-1,"%s%%%s", s, t);
  else snprintf (password, _POSIX_PATH_MAX-1, "%s%%", s);

  gtk_widget_destroy (dialog);
  gtk_main_quit ();
}

static void
entry_activate (GtkWidget * entry, GdkEventKey * event, gpointer data)
{
  {
    if (entry == user)  gtk_widget_grab_focus (passwd);
    if (entry == passwd) ok_dialog (NULL, NULL);
  }
  return;

}
#define EXPAND      TRUE
#define FILL        TRUE
#define NOEXPAND    FALSE
#define NOFILL      FALSE

char *
passwd_dialog (GtkWidget *parent,int caso)
{
  GtkWidget *button, *hbox, *label;

  passwd_caso = caso;

  /*SMBabortdrop=TRUE;*/
  dialog = gtk_dialog_new ();
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
  gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);

  gtk_widget_realize (dialog);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  if (caso == 1)
    label = gtk_label_new (_("Please provide information for server "));
  else
    label = gtk_label_new (_("Please provide browsing preferences "));
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  gtk_widget_show (hbox);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Username : "));
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  user = gtk_entry_new ();
  if (password)
  {
    char *c;
    c=g_strdup(password);
    if (c){ 
     strtok (c, "\%");
     if (strstr (c, "Guest") == NULL) gtk_entry_set_text ((GtkEntry *) user, c);
     g_free(c);c=NULL;
    }
  }
  gtk_box_pack_start (GTK_BOX (hbox), user, EXPAND, NOFILL, 0);
  g_signal_connect (G_OBJECT (user), "activate", 
		  GTK_SIGNAL_FUNC (entry_activate), NULL);
  gtk_widget_show (user);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show (hbox);

  label = gtk_label_new (_("Password  : "));
  gtk_box_pack_start (GTK_BOX (hbox), label, NOEXPAND, NOFILL, 0);
  gtk_widget_show (label);

  passwd = gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), passwd, EXPAND, NOFILL, 0);
  gtk_entry_set_visibility ((GtkEntry *) passwd, FALSE);
  g_signal_connect (G_OBJECT (passwd), "activate", GTK_SIGNAL_FUNC (entry_activate), NULL);
  gtk_widget_show (passwd);


  button = gtk_button_new_with_label (_("Ok"));
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), button, EXPAND, NOFILL, 0);
  gtk_widget_show (button);
  g_signal_connect (G_OBJECT (button), "clicked", GTK_SIGNAL_FUNC (ok_dialog), (gpointer) ((long) caso));
  button = gtk_button_new_with_label ("Cancel");
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), 
		  button, EXPAND, NOFILL, 0);
  gtk_widget_show (button);
  g_signal_connect (G_OBJECT (button), "clicked", 
		  GTK_SIGNAL_FUNC (cancel_dialog), (gpointer) dialog);
  g_signal_connect (G_OBJECT (dialog), "destroy", 
		  GTK_SIGNAL_FUNC (destroy_dialog), (gpointer) dialog);  
  gtk_widget_show (dialog);
  gtk_widget_grab_focus (user);
  if (parent) gtk_window_set_transient_for (
		    GTK_WINDOW (dialog), 
		    GTK_WINDOW (parent));
  gtk_main();
  return password;
}

/* this does not work well with parallel smbclient
 *      (not enough time alloted to process gtk events)
 *      */

int smb_wait(gboolean animate){
  tree_details_t *tree_details = get_tree_details(smb_treeview);
	
  while (smb_object){
     if (animate){
        GtkWidget *progress;
        progress = lookup_widget(tree_details->window, "progressbar1");
	gtk_progress_bar_pulse((GtkProgressBar *) progress);
     } 
     while (gtk_events_pending()) gtk_main_iteration();
     usleep(5000);
  }
  return TRUE;
}

