
if (UMFPACK_INCLUDES AND UMFPACK_LIBRARIES)
  set(UMFPACK_FIND_QUIETLY TRUE)
endif (UMFPACK_INCLUDES AND UMFPACK_LIBRARIES)

find_package(BLAS)

if(BLAS_FOUND)

  find_path(UMFPACK_INCLUDES
    NAMES
    umfpack.h
    PATHS
    $ENV{UMFPACKDIR}
    ${INCLUDE_INSTALL_DIR}
    PATH_SUFFIXES
    suitesparse
  )

  find_library(UMFPACK_LIBRARIES umfpack PATHS $ENV{UMFPACKDIR} ${LIB_INSTALL_DIR})

  if(UMFPACK_LIBRARIES)

    get_filename_component(UMFPACK_LIBDIR ${UMFPACK_LIBRARIES} PATH)

    find_library(AMD_LIBRARY amd PATHS ${UMFPACK_LIBDIR} $ENV{UMFPACKDIR} ${LIB_INSTALL_DIR})
    if (AMD_LIBRARY)
      set(UMFPACK_LIBRARIES ${UMFPACK_LIBRARIES} ${AMD_LIBRARY})
    #else (AMD_LIBRARY)
    #  set(UMFPACK_LIBRARIES FALSE)
    endif (AMD_LIBRARY)

  endif(UMFPACK_LIBRARIES)

  if(UMFPACK_LIBRARIES)

    find_library(COLAMD_LIBRARY colamd PATHS ${UMFPACK_LIBDIR} $ENV{UMFPACKDIR} ${LIB_INSTALL_DIR})
    if (COLAMD_LIBRARY)
      set(UMFPACK_LIBRARIES ${UMFPACK_LIBRARIES} ${COLAMD_LIBRARY})
    #else (COLAMD_LIBRARY)
    #  set(UMFPACK_LIBRARIES FALSE)
    endif (COLAMD_LIBRARY)

  endif(UMFPACK_LIBRARIES)

  if(UMFPACK_LIBRARIES)
    set(UMFPACK_LIBRARIES ${UMFPACK_LIBRARIES} ${BLAS_LIBRARIES})
  endif(UMFPACK_LIBRARIES)

endif(BLAS_FOUND)


include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(UMFPACK DEFAULT_MSG
                                  UMFPACK_INCLUDES UMFPACK_LIBRARIES)

mark_as_advanced(UMFPACK_INCLUDES UMFPACK_LIBRARIES AMD_LIBRARY COLAMD_LIBRARY)
