'\"
'\" Copyright (c) 2004 Joe English
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: ttk_radiobutton.n,v 1.11.2.1 2008/05/11 00:31:03 patthoyts Exp $
'\" 
.so man.macros
.TH ttk::radiobutton n 8.5 Tk "Tk Themed Widget"
.BS
.SH NAME
ttk::radiobutton \- Mutually exclusive option widget
.SH SYNOPSIS
\fBttk::radiobutton\fR \fIpathName \fR?\fIoptions\fR?
.BE
.SH DESCRIPTION
\fBttk::radiobutton\fR widgets are used in groups to show or change
a set of mutually-exclusive options.
Radiobuttons are linked to a Tcl variable,
and have an associated value; when a radiobutton is clicked,
it sets the variable to its associated value.
.SO ttk_widget
\-class	\-compound	\-cursor
\-image	\-state	\-style
\-takefocus	\-text	\-textvariable
\-underline	\-width
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-command command Command
A Tcl script to evaluate whenever the widget is invoked.
.OP \-value Value Value
The value to store in the associated \fI\-variable\fR 
when the widget is selected. 
.OP \-variable variable Variable
The name of a global variable whose value is linked to the widget.
Default value is \fB::selectedButton\fR.
.SH "WIDGET COMMAND"
In addition to the standard 
\fBcget\fR, \fBconfigure\fR, \fBidentify\fR, \fBinstate\fR, and \fBstate\fR 
commands, radiobuttons support the following additional
widget commands:
.TP
\fIpathname\fB invoke\fR
Sets the \fB\-variable\fR to the \fB\-value\fR, selects the widget,
and evaluates the associated \fB\-command\fR.  
Returns the result of the \fB\-command\fR, or the empty
string if no \fB\-command\fR is specified.
.\" Missing: select, deselect.  Useful?
.\" Missing: flash.  This is definitely not useful.
.SH "WIDGET STATES"
The widget does not respond to user input if the \fBdisabled\fR state is set.
The widget sets the \fBselected\fR state whenever 
the linked \fB\-variable\fR is set to the widget's \fB\-value\fR,
and clears it otherwise.
The widget sets the \fBalternate\fR state whenever the 
linked \fB\-variable\fR is unset.  
(The \fBalternate\fR state may be used to indicate a
.QW tri-state
or
.QW indeterminate
selection.)
.SH "SEE ALSO"
ttk::widget(n), ttk::checkbutton(n), radiobutton(n)
.SH "KEYWORDS"
widget, button, option
