/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 *               2004 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef	__XFPRINT_HEAD_PAGE_H__
#define	__XFPRINT_HEAD_PAGE_H__

#include <gtk/gtk.h>
#include <xfprintsettings.h>

#ifdef	__cplusplus
extern "C"
{
#endif                          /* !__cplusplus */

#define HEAD_PAGE(obj)							\
	G_TYPE_CHECK_INSTANCE_CAST(obj, head_page_get_type(), HeadPage)
#define HEAD_PAGE_CLASS(klass)						\
	G_TYPE_CHECK_CLASS_CAST(klass, Head_page_get_type(), HeadPage)
#define HEAD_IS_PAGE(obj)						\
	G_TYPE_CHECK_INSTANCE_TYPE(obj, head_page_get_type())

  typedef struct _HeadPage HeadPage;
  typedef struct _HeadPageClass HeadPageClass;

  struct _HeadPage
  {
    GtkTable table;

    GtkWidget *headers;
    GtkWidget *header;
    GtkWidget *underlay;
    GtkWidget *ctitle;
    GtkWidget *ltitle;
    GtkWidget *rtitle;
    GtkWidget *cfooter;
    GtkWidget *lfooter;
    GtkWidget *rfooter;
  };

  struct _HeadPageClass
  {
    GtkTableClass parent_class;
  };

  extern GtkType head_page_get_type (void);
  extern GtkWidget *head_page_new (void);
  extern void head_page_set_settings (HeadPage *, const XfprintSettingsHeadings *);
  extern void head_page_get_settings (HeadPage *, XfprintSettingsHeadings *);

#ifdef	__cplusplus
}
#endif                          /* !__cplusplus */

#endif                          /* !__XFPRINT_HEAD_PAGE_H__ */
