/*
  Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/
*/

async function testSteps()
{
  const principalInfos = [
    "http://localhost",
    "http://www.mozilla.org",
    "http://example.com",
  ];

  const data = {
    key: "foo",
    value: "bar"
  };

  function getLocalStorage(principal) {
    return Services.domStorageManager.createStorage(null, principal, "");
  }

  info("Getting storages");

  let storages = [];
  for (let i = 0; i < principalInfos.length; i++) {
    let storage = getLocalStorage(getPrincipal(principalInfos[i]));
    storages.push(storage);
  }

  info("Adding data");

  for (let i = 0; i < storages.length; i++) {
    storages[i].setItem(data.key + i, data.value + i);
  }
}
