// Copyright 2020 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef SRC_WRITER_TEXT_GENERATOR_H_
#define SRC_WRITER_TEXT_GENERATOR_H_

#include <sstream>
#include <string>

namespace tint {
namespace writer {

/// Helper methods for generators which are creating text output
class TextGenerator {
 public:
  /// Constructor
  TextGenerator();
  ~TextGenerator();

  /// Increment the emitter indent level
  void increment_indent() { indent_ += 2; }
  /// Decrement the emiter indent level
  void decrement_indent() {
    if (indent_ < 2) {
      indent_ = 0;
      return;
    }
    indent_ -= 2;
  }

  /// Writes the current indent to the output stream
  void make_indent();

  /// @returns the result data
  std::string result() const { return out_.str(); }

  /// @returns the error
  std::string error() const { return error_; }

 protected:
  /// The text output stream
  std::ostringstream out_;
  /// Error generated by the generator
  std::string error_;

 private:
  size_t indent_ = 0;
};

}  // namespace writer
}  // namespace tint

#endif  // SRC_WRITER_TEXT_GENERATOR_H_
