#
# doinst_rules()
# Adds doinst.sh code for removing additional control files, installing
# info files, and handling the config file "rules" file.
#
# Parameters:    $1      The package tree.
#                $2      The control directory in the package tree.
#

doinst_rules() {
   # handle any info files that are in the package tree
   cd $1
   noIf=y

   for dn in usr \
             usr/local \
             opt \
             usr/X11R6 \
             usr/openwin
   do
      # find unique info files in the directory
      for infof in `find $1/$dn/info -type f -print 2>/dev/null | \
                    grep -v -e '.*-[0-9]\+\.gz'`
      do
         if [ "$noIf" = "y" ]
         then
            ( cd $1/install
              echo "# Install the info files for this package" >> doinst.sh
              echo "if [ -x usr/bin/install-info ]" >> doinst.sh
              echo "then" >> doinst.sh )
            noIf=n
         fi

         echo "   usr/bin/install-info --info-dir=/$dn/info /$dn/info/`basename $infof` 2>/dev/null" >> $1/install/doinst.sh
      done
   done

   # close the installer block
   if [ "$noIf" = "n" ]
   then
      ( cd $1/install
        echo "fi" >> doinst.sh
        echo >> doinst.sh )
   fi

   # handle any config files in the config file processing dir
   if [ -d $1/install/conf ]
   then
      ( cd $1/install
        echo "# Process the incoming configuration files" >> doinst.sh )

      cat $CWD/rules | read_rules "conf" | (
         while read Caction Cfile
         do
            if [ "$Cfile" = "" ]
            then
               ### This is the default installation method
               realF=`trim_slash $Caction`

               ( cd $1/install
                 echo >> doinst.sh
                 cat << EOF >> doinst.sh
if [ ! -f $realF ]
then
   mv install/conf/$realF $realF
else
   if [ "\`md5sum install/conf/$realF | cut -d ' ' -f 1 2>/dev/null\`" = "\`md5sum $realF | cut -d ' ' -f 1 2>/dev/null\`" ]
   then
      mv install/conf/$realF $realF
   else
      mv install/conf/$realF $realF.new
   fi
fi
EOF
               )
            elif [ "$Caction" = "ONE" ]
            then
               ### Handle the ONE installation mode
               realF=`trim_slash $Cfile`

               ( cd $1/install
                 echo >> doinst.sh
                 cat << EOF >> doinst.sh
if [ ! -f $realF ]
then
   mv install/conf/$realF $realF
else
   if [ "\`md5sum install/conf/$realF | cut -d ' ' -f 1 2>/dev/null\`" = "\`md5sum $realF | cut -d ' ' -f 1 2>/dev/null\`" ]
   then
      mv install/conf/$realF $realF
   else
      rm install/conf/$realF
   fi
fi
EOF
               )
            else
               ### We need to handle the other modes
               realF=`trim_slash $Cfile`

               if [ "$Caction" = "NEW" ]
               then
                  destF="$realF.new"
               elif [ "$Caction" = "EXAMPLE" ]
               then
                  destF="$realF.example"
               elif [ "$Caction" = "OW" ]
               then
                  destF=$realF
               fi

               ( cd $1/install
                 echo >> doinst.sh
                 echo "mv install/conf/$realF $destF" >> doinst.sh )
            fi
         done )

      ( cd $1/install
        echo >> doinst.sh
        echo "# Make sure the incoming conf directory is gone" >> doinst.sh
        echo "rm -rf install/conf" >> doinst.sh )
   fi
}
