.\" dpkg manual page - dpkg-scanpackages(1)
.\"
.\" Copyright © 1996 Michael Shields <shields@crosslink.net>
.\" Copyright © 2006 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2007, 2009, 2011-2014 Guillem Jover <guillem@debian.org>
.\" Copyright © 2009 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-scanpackages 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-scanpackages \- create Packages index files
.
.SH SYNOPSIS
.B dpkg\-scanpackages
.RI [ option "...] " binary-path
.RI [ override-file
.RI [ path-prefix ]]
.B >
.I Packages
.
.SH DESCRIPTION
.B dpkg\-scanpackages
sorts through a tree of Debian binary packages and creates a Packages
file, used by
.BR apt (8),
.BR dselect (1),
etc, to tell the user what packages are available for installation. These
Packages files are the same as those found on Debian archive sites
and CD-ROMs. You might use
.B dpkg\-scanpackages
yourself if making a directory of local packages to install on a cluster
of machines.
.PP
.B Note:
If you want to access the generated Packages file with
.B apt
you will probably need to compress the file with
.BR xz (1)
(generating a Packages.xz file),
.BR bzip2 (1)
(generating a Packages.bz2 file) or
.BR gzip (1)
(generating a Packages.gz file). apt ignores uncompressed Packages
files except on local access (i.e.
.B file://
sources).
.PP
.I binary-path
is the name of the tree of the binary packages to process (for example,
.BR contrib/binary\-i386 ).
It is best to make this relative to the root of the Debian archive,
because every Filename field in the new Packages file will start with
this string.
.PP
.I override-file
is the name of a file to read which contains information about how the
package fits into the distribution (the file can be compressed
since dpkg 1.15.5); see
.BR deb\-override (5).
.PP
.I path-prefix
is an optional string to be prepended to the Filename fields.
.PP
If more than one version of a package is found only the newest one
is included in the output. If they have the same version and only
differ in architecture only the first one found is used.
.
.SH OPTIONS
.TP
.BR \-t ", " \-\-type " \fItype\fP"
Scan for *.\fItype\fP packages, instead of *.deb.
.TP
.BR \-e ", " \-\-extra\-override " \fIfile\fP"
Scan \fIfile\fP to find supplementary overrides (the file can be
compressed since dpkg 1.15.5).
See
.BR deb\-extra\-override (5)
for more information on its format.
.TP
.BR \-a ", " \-\-arch " \fIarch\fP"
Use a pattern consisting of \fI*_all.deb\fP and \fI*_arch.deb\fP instead of
scanning for all debs.
.TP
.BR \-h ", " \-\-hash " \fIhash-list\fP"
Only generate file hashes for the comma-specified list specified
(since dpkg 1.17.14).
The default is to generate all currently supported hashes.
Supported values: \fBmd5\fP, \fBsha1\fP, \fBsha256\fP.
.TP
.BR \-m ", " \-\-multiversion
Include all found packages in the output.
.TP
.BR \-M ", " \-\-medium " \fIid-string\fP"
Add an \fBX\-Medium\fP field containing the value \fIid-string\fP
(since dpkg 1.15.5).
This field is required if you want to generate \fBPackages.cd\fP files
for use by the multicd access method of dselect.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.
.SH DIAGNOSTICS
.B dpkg\-scanpackages
outputs the usual self-explanatory errors. It also warns about packages
that are in the wrong subdirectory, are duplicated, have a Filename
field in their control file, are missing from the override file, or have
maintainer substitutions which do not take effect.
.
.SH SEE ALSO
.ad l
.BR dpkg (1),
.BR dselect (1),
.BR deb\-override (5),
.BR deb\-extra\-override (5),
.BR dpkg\-scansources (1).
