/* do not edit automatically generated by mc from MemUtils.  */
/* MemUtils.mod provides some basic memory utilities.

Copyright (C) 2001-2020 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#define _MemUtils_H
#define _MemUtils_C

#   include "GSYSTEM.h"


/*
   MemCopy - copys a region of memory to the required destination.
*/

void MemUtils_MemCopy (void * from, unsigned int length, void * to);

/*
   MemZero - sets a region of memory: a..a+length to zero.
*/

void MemUtils_MemZero (void * a, unsigned int length);


/*
   MemCopy - copys a region of memory to the required destination.
*/

void MemUtils_MemCopy (void * from, unsigned int length, void * to)
{
  unsigned int * pwb;
  unsigned int * pwa;
  unsigned char * pbb;
  unsigned char * pba;

  while (length >= sizeof (unsigned int ))
    {
      pwa = from;
      pwb = to;
      (*pwb) = (*pwa);
      from += sizeof (unsigned int );
      to += sizeof (unsigned int );
      length -= sizeof (unsigned int );
    }
  while (length > 0)
    {
      pba = from;
      pbb = to;
      (*pbb) = (*pba);
      from += sizeof (unsigned char );
      to += sizeof (unsigned char );
      length -= sizeof (unsigned char );
    }
}


/*
   MemZero - sets a region of memory: a..a+length to zero.
*/

void MemUtils_MemZero (void * a, unsigned int length)
{
  unsigned int * pwa;
  unsigned char * pba;

  pwa = a;
  while (length >= sizeof (unsigned int ))
    {
      (*pwa) = (unsigned int ) (0);
      pwa += sizeof (unsigned int );
      length -= sizeof (unsigned int );
    }
  pba = (void *) (pwa);
  while (length >= sizeof (unsigned char ))
    {
      (*pba) = (unsigned char ) (0);
      pba += sizeof (unsigned char );
      length -= sizeof (unsigned char );
    }
}

void _M2_MemUtils_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}

void _M2_MemUtils_finish (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[])
{
}
