; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --scrub-attributes
; RUN: opt -S -passes='attributor' -aa-pipeline='basic-aa' -attributor-disable=false -attributor-max-iterations-verify -attributor-max-iterations=3 < %s | FileCheck %s --check-prefixes=CHECK,ATTRIBUTOR
; RUN: opt -S -passes='cgscc(inline),attributor' -aa-pipeline='basic-aa' -attributor-disable=false -attributor-max-iterations-verify -attributor-max-iterations=3 < %s | FileCheck %s --check-prefixes=CHECK,INLINE_ATTRIBUTOR

%S = type { %S* }

; Inlining should nuke the invoke (and any inlined calls) here even with
; argument promotion running along with it.
define void @zot() personality i32 (...)* @wibble {
; ATTRIBUTOR-LABEL: define {{[^@]+}}@zot() #0 personality i32 (...)* @wibble
; ATTRIBUTOR-NEXT:  bb:
; ATTRIBUTOR-NEXT:    call void @hoge()
; ATTRIBUTOR-NEXT:    unreachable
; ATTRIBUTOR:       bb1:
; ATTRIBUTOR-NEXT:    unreachable
; ATTRIBUTOR:       bb2:
; ATTRIBUTOR-NEXT:    unreachable
;
; INLINE_ATTRIBUTOR-LABEL: define {{[^@]+}}@zot() #0 personality i32 (...)* @wibble
; INLINE_ATTRIBUTOR-NEXT:  bb:
; INLINE_ATTRIBUTOR-NEXT:    unreachable
; INLINE_ATTRIBUTOR:       hoge.exit:
; INLINE_ATTRIBUTOR-NEXT:    unreachable
; INLINE_ATTRIBUTOR:       bb1:
; INLINE_ATTRIBUTOR-NEXT:    unreachable
; INLINE_ATTRIBUTOR:       bb2:
; INLINE_ATTRIBUTOR-NEXT:    unreachable
;
bb:
  invoke void @hoge()
  to label %bb1 unwind label %bb2

bb1:
  unreachable

bb2:
  %tmp = landingpad { i8*, i32 }
  cleanup
  unreachable
}

define internal void @hoge() {
; ATTRIBUTOR-LABEL: define {{[^@]+}}@hoge()
; ATTRIBUTOR-NEXT:  bb:
; ATTRIBUTOR-NEXT:    unreachable
;
bb:
  %tmp = call fastcc i8* @spam(i1 (i8*)* @eggs)
  %tmp1 = call fastcc i8* @spam(i1 (i8*)* @barney)
  unreachable
}

define internal fastcc i8* @spam(i1 (i8*)* %arg) {
bb:
  unreachable
}

define internal i1 @eggs(i8* %arg) {
bb:
  %tmp = call zeroext i1 @barney(i8* %arg)
  unreachable
}

define internal i1 @barney(i8* %arg) {
bb:
  ret i1 undef
}

define i32 @test_inf_promote_caller(i32 %arg) {
; CHECK-LABEL: define {{[^@]+}}@test_inf_promote_caller
; CHECK-SAME: (i32 [[ARG:%.*]])
; CHECK-NEXT:  bb:
; CHECK-NEXT:    unreachable
;
bb:
  %tmp = alloca %S
  %tmp1 = alloca %S
  %tmp2 = call i32 @test_inf_promote_callee(%S* %tmp, %S* %tmp1)

  ret i32 0
}

define internal i32 @test_inf_promote_callee(%S* %arg, %S* %arg1) {
bb:
  %tmp = getelementptr %S, %S* %arg1, i32 0, i32 0
  %tmp2 = load %S*, %S** %tmp
  %tmp3 = getelementptr %S, %S* %arg, i32 0, i32 0
  %tmp4 = load %S*, %S** %tmp3
  %tmp5 = call i32 @test_inf_promote_callee(%S* %tmp4, %S* %tmp2)

  ret i32 0
}

declare i32 @wibble(...)
