// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: riscv-registered-target
// RUN: %clang_cc1 -triple riscv32 -target-feature +v -target-feature +xsfvcp -disable-O0-optnone -emit-llvm %s -o - | opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV32 %s
// RUN: %clang_cc1 -triple riscv64 -target-feature +v -target-feature +xsfvcp -disable-O0-optnone -emit-llvm %s -o - | opt -S -passes=mem2reg | FileCheck --check-prefix=CHECK-RV64 %s

#include <sifive_vector.h>

#define p27_26 (0b11)
#define p24_20 (0b11111)
#define p11_7  (0b11111)
#define simm5  (10)

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8mf8.i32.i8.i32(i32 3, i32 31, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8mf8.i64.i8.i64(i64 3, i64 31, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u8mf8(uint8_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u8mf8(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8mf4.i32.i8.i32(i32 3, i32 31, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8mf4.i64.i8.i64(i64 3, i64 31, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u8mf4(uint8_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u8mf4(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8mf2.i32.i8.i32(i32 3, i32 31, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8mf2.i64.i8.i64(i64 3, i64 31, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u8mf2(uint8_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u8mf2(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8m1.i32.i8.i32(i32 3, i32 31, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8m1.i64.i8.i64(i64 3, i64 31, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u8m1(uint8_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u8m1(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8m2.i32.i8.i32(i32 3, i32 31, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8m2.i64.i8.i64(i64 3, i64 31, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u8m2(uint8_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u8m2(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8m4.i32.i8.i32(i32 3, i32 31, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8m4.i64.i8.i64(i64 3, i64 31, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u8m4(uint8_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u8m4(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8m8.i32.i8.i32(i32 3, i32 31, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e8m8.i64.i8.i64(i64 3, i64 31, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u8m8(uint8_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u8m8(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16mf4.i32.i16.i32(i32 3, i32 31, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16mf4.i64.i16.i64(i64 3, i64 31, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u16mf4(uint16_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u16mf4(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16mf2.i32.i16.i32(i32 3, i32 31, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16mf2.i64.i16.i64(i64 3, i64 31, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u16mf2(uint16_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u16mf2(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16m1.i32.i16.i32(i32 3, i32 31, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16m1.i64.i16.i64(i64 3, i64 31, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u16m1(uint16_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u16m1(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16m2.i32.i16.i32(i32 3, i32 31, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16m2.i64.i16.i64(i64 3, i64 31, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u16m2(uint16_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u16m2(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16m4.i32.i16.i32(i32 3, i32 31, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16m4.i64.i16.i64(i64 3, i64 31, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u16m4(uint16_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u16m4(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16m8.i32.i16.i32(i32 3, i32 31, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e16m8.i64.i16.i64(i64 3, i64 31, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u16m8(uint16_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u16m8(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32mf2.i32.i32.i32(i32 3, i32 31, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32mf2.i64.i32.i64(i64 3, i64 31, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u32mf2(uint32_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u32mf2(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32m1.i32.i32.i32(i32 3, i32 31, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32m1.i64.i32.i64(i64 3, i64 31, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u32m1(uint32_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u32m1(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32m2.i32.i32.i32(i32 3, i32 31, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32m2.i64.i32.i64(i64 3, i64 31, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u32m2(uint32_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u32m2(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32m4.i32.i32.i32(i32 3, i32 31, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32m4.i64.i32.i64(i64 3, i64 31, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u32m4(uint32_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u32m4(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_x_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32m8.i32.i32.i32(i32 3, i32 31, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_x_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.x.se.e32m8.i64.i32.i64(i64 3, i64 31, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_x_se_u32m8(uint32_t rs1, size_t vl) {
  __riscv_sf_vc_x_se_u32m8(p27_26, p24_20, p11_7, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.x.se.nxv1i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.x.se.nxv1i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_x_se_u8mf8(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u8mf8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.x.se.nxv2i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.x.se.nxv2i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_x_se_u8mf4(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u8mf4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.x.se.nxv4i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.x.se.nxv4i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_x_se_u8mf2(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u8mf2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.x.se.nxv8i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.x.se.nxv8i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_x_se_u8m1(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u8m1(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.x.se.nxv16i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.x.se.nxv16i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_x_se_u8m2(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u8m2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.x.se.nxv32i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.x.se.nxv32i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_x_se_u8m4(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u8m4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.x.se.nxv64i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.x.se.nxv64i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_x_se_u8m8(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u8m8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.x.se.nxv1i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.x.se.nxv1i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_x_se_u16mf4(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u16mf4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.x.se.nxv2i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.x.se.nxv2i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_x_se_u16mf2(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u16mf2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.x.se.nxv4i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.x.se.nxv4i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_x_se_u16m1(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u16m1(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.x.se.nxv8i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.x.se.nxv8i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_x_se_u16m2(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u16m2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.x.se.nxv16i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.x.se.nxv16i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_x_se_u16m4(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u16m4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.x.se.nxv32i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.x.se.nxv32i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_x_se_u16m8(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u16m8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.x.se.nxv1i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.x.se.nxv1i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_x_se_u32mf2(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u32mf2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.x.se.nxv2i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.x.se.nxv2i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_x_se_u32m1(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u32m1(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.x.se.nxv4i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.x.se.nxv4i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_x_se_u32m2(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u32m2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.x.se.nxv8i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.x.se.nxv8i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_x_se_u32m4(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u32m4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.x.se.nxv16i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.x.se.nxv16i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_x_se_u32m8(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_se_u32m8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.x.nxv1i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.x.nxv1i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_x_u8mf8(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u8mf8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.x.nxv2i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.x.nxv2i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_x_u8mf4(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u8mf4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.x.nxv4i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.x.nxv4i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_x_u8mf2(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u8mf2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.x.nxv8i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.x.nxv8i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_x_u8m1(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u8m1(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.x.nxv16i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.x.nxv16i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_x_u8m2(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u8m2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.x.nxv32i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.x.nxv32i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_x_u8m4(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u8m4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.x.nxv64i8.i32.i8.i32(i32 3, i32 31, i8 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.x.nxv64i8.i64.i8.i64(i64 3, i64 31, i8 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_x_u8m8(uint8_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u8m8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.x.nxv1i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.x.nxv1i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_x_u16mf4(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u16mf4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.x.nxv2i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.x.nxv2i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_x_u16mf2(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u16mf2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.x.nxv4i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.x.nxv4i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_x_u16m1(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u16m1(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.x.nxv8i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.x.nxv8i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_x_u16m2(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u16m2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.x.nxv16i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.x.nxv16i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_x_u16m4(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u16m4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.x.nxv32i16.i32.i16.i32(i32 3, i32 31, i16 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.x.nxv32i16.i64.i16.i64(i64 3, i64 31, i16 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_x_u16m8(uint16_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u16m8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.x.nxv1i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.x.nxv1i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_x_u32mf2(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u32mf2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.x.nxv2i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.x.nxv2i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_x_u32m1(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u32m1(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.x.nxv4i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.x.nxv4i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_x_u32m2(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u32m2(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.x.nxv8i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.x.nxv8i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_x_u32m4(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u32m4(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_x_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.x.nxv16i32.i32.i32.i32(i32 3, i32 31, i32 [[RS1:%.*]], i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_x_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.x.nxv16i32.i64.i32.i64(i64 3, i64 31, i32 [[RS1:%.*]], i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_x_u32m8(uint32_t rs1, size_t vl) {
  return __riscv_sf_vc_v_x_u32m8(p27_26, p24_20, rs1, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8mf8.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8mf8.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u8mf8(size_t vl) {
  __riscv_sf_vc_i_se_u8mf8(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8mf4.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8mf4.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u8mf4(size_t vl) {
  __riscv_sf_vc_i_se_u8mf4(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8mf2.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8mf2.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u8mf2(size_t vl) {
  __riscv_sf_vc_i_se_u8mf2(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8m1.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8m1.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u8m1(size_t vl) {
  __riscv_sf_vc_i_se_u8m1(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8m2.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8m2.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u8m2(size_t vl) {
  __riscv_sf_vc_i_se_u8m2(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8m4.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8m4.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u8m4(size_t vl) {
  __riscv_sf_vc_i_se_u8m4(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8m8.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e8m8.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u8m8(size_t vl) {
  __riscv_sf_vc_i_se_u8m8(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16mf4.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16mf4.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u16mf4(size_t vl) {
  __riscv_sf_vc_i_se_u16mf4(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16mf2.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16mf2.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u16mf2(size_t vl) {
  __riscv_sf_vc_i_se_u16mf2(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16m1.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16m1.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u16m1(size_t vl) {
  __riscv_sf_vc_i_se_u16m1(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16m2.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16m2.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u16m2(size_t vl) {
  __riscv_sf_vc_i_se_u16m2(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16m4.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16m4.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u16m4(size_t vl) {
  __riscv_sf_vc_i_se_u16m4(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16m8.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e16m8.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u16m8(size_t vl) {
  __riscv_sf_vc_i_se_u16m8(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32mf2.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32mf2.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u32mf2(size_t vl) {
  __riscv_sf_vc_i_se_u32mf2(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32m1.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32m1.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u32m1(size_t vl) {
  __riscv_sf_vc_i_se_u32m1(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32m2.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32m2.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u32m2(size_t vl) {
  __riscv_sf_vc_i_se_u32m2(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32m4.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32m4.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u32m4(size_t vl) {
  __riscv_sf_vc_i_se_u32m4(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32m8.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e32m8.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u32m8(size_t vl) {
  __riscv_sf_vc_i_se_u32m8(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e64m1.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e64m1.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u64m1(size_t vl) {
  __riscv_sf_vc_i_se_u64m1(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e64m2.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e64m2.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u64m2(size_t vl) {
  __riscv_sf_vc_i_se_u64m2(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e64m4.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e64m4.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u64m4(size_t vl) {
  __riscv_sf_vc_i_se_u64m4(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_i_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    call void @llvm.riscv.sf.vc.i.se.e64m8.i32.i32.i32(i32 3, i32 31, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret void
//
// CHECK-RV64-LABEL: @test_sf_vc_i_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    call void @llvm.riscv.sf.vc.i.se.e64m8.i64.i64.i64(i64 3, i64 31, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret void
//
void test_sf_vc_i_se_u64m8(size_t vl) {
  __riscv_sf_vc_i_se_u64m8(p27_26, p24_20, p11_7, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.i.se.nxv1i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.i.se.nxv1i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_i_se_u8mf8(size_t vl) {
  return __riscv_sf_vc_v_i_se_u8mf8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.i.se.nxv2i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.i.se.nxv2i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_i_se_u8mf4(size_t vl) {
  return __riscv_sf_vc_v_i_se_u8mf4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.i.se.nxv4i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.i.se.nxv4i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_i_se_u8mf2(size_t vl) {
  return __riscv_sf_vc_v_i_se_u8mf2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.i.se.nxv8i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.i.se.nxv8i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_i_se_u8m1(size_t vl) {
  return __riscv_sf_vc_v_i_se_u8m1(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.i.se.nxv16i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.i.se.nxv16i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_i_se_u8m2(size_t vl) {
  return __riscv_sf_vc_v_i_se_u8m2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.i.se.nxv32i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.i.se.nxv32i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_i_se_u8m4(size_t vl) {
  return __riscv_sf_vc_v_i_se_u8m4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.i.se.nxv64i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.i.se.nxv64i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_i_se_u8m8(size_t vl) {
  return __riscv_sf_vc_v_i_se_u8m8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.i.se.nxv1i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.i.se.nxv1i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_i_se_u16mf4(size_t vl) {
  return __riscv_sf_vc_v_i_se_u16mf4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.i.se.nxv2i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.i.se.nxv2i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_i_se_u16mf2(size_t vl) {
  return __riscv_sf_vc_v_i_se_u16mf2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.i.se.nxv4i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.i.se.nxv4i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_i_se_u16m1(size_t vl) {
  return __riscv_sf_vc_v_i_se_u16m1(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.i.se.nxv8i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.i.se.nxv8i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_i_se_u16m2(size_t vl) {
  return __riscv_sf_vc_v_i_se_u16m2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.i.se.nxv16i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.i.se.nxv16i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_i_se_u16m4(size_t vl) {
  return __riscv_sf_vc_v_i_se_u16m4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.i.se.nxv32i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.i.se.nxv32i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_i_se_u16m8(size_t vl) {
  return __riscv_sf_vc_v_i_se_u16m8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.i.se.nxv1i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.i.se.nxv1i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_i_se_u32mf2(size_t vl) {
  return __riscv_sf_vc_v_i_se_u32mf2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.i.se.nxv2i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.i.se.nxv2i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_i_se_u32m1(size_t vl) {
  return __riscv_sf_vc_v_i_se_u32m1(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.i.se.nxv4i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.i.se.nxv4i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_i_se_u32m2(size_t vl) {
  return __riscv_sf_vc_v_i_se_u32m2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.i.se.nxv8i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.i.se.nxv8i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_i_se_u32m4(size_t vl) {
  return __riscv_sf_vc_v_i_se_u32m4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.i.se.nxv16i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.i.se.nxv16i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_i_se_u32m8(size_t vl) {
  return __riscv_sf_vc_v_i_se_u32m8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.i.se.nxv1i64.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.i.se.nxv1i64.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_i_se_u64m1(size_t vl) {
  return __riscv_sf_vc_v_i_se_u64m1(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.i.se.nxv2i64.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.i.se.nxv2i64.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_i_se_u64m2(size_t vl) {
  return __riscv_sf_vc_v_i_se_u64m2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.i.se.nxv4i64.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.i.se.nxv4i64.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_i_se_u64m4(size_t vl) {
  return __riscv_sf_vc_v_i_se_u64m4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_se_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.i.se.nxv8i64.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_se_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.i.se.nxv8i64.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_i_se_u64m8(size_t vl) {
  return __riscv_sf_vc_v_i_se_u64m8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u8mf8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.i.nxv1i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u8mf8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i8> @llvm.riscv.sf.vc.v.i.nxv1i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i8> [[TMP0]]
//
vuint8mf8_t test_sf_vc_v_i_u8mf8(size_t vl) {
  return __riscv_sf_vc_v_i_u8mf8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u8mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.i.nxv2i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u8mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i8> @llvm.riscv.sf.vc.v.i.nxv2i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i8> [[TMP0]]
//
vuint8mf4_t test_sf_vc_v_i_u8mf4(size_t vl) {
  return __riscv_sf_vc_v_i_u8mf4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u8mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.i.nxv4i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u8mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i8> @llvm.riscv.sf.vc.v.i.nxv4i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i8> [[TMP0]]
//
vuint8mf2_t test_sf_vc_v_i_u8mf2(size_t vl) {
  return __riscv_sf_vc_v_i_u8mf2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u8m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.i.nxv8i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u8m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i8> @llvm.riscv.sf.vc.v.i.nxv8i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i8> [[TMP0]]
//
vuint8m1_t test_sf_vc_v_i_u8m1(size_t vl) {
  return __riscv_sf_vc_v_i_u8m1(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u8m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.i.nxv16i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u8m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i8> @llvm.riscv.sf.vc.v.i.nxv16i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i8> [[TMP0]]
//
vuint8m2_t test_sf_vc_v_i_u8m2(size_t vl) {
  return __riscv_sf_vc_v_i_u8m2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u8m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.i.nxv32i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u8m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i8> @llvm.riscv.sf.vc.v.i.nxv32i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i8> [[TMP0]]
//
vuint8m4_t test_sf_vc_v_i_u8m4(size_t vl) {
  return __riscv_sf_vc_v_i_u8m4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u8m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.i.nxv64i8.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u8m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 64 x i8> @llvm.riscv.sf.vc.v.i.nxv64i8.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 64 x i8> [[TMP0]]
//
vuint8m8_t test_sf_vc_v_i_u8m8(size_t vl) {
  return __riscv_sf_vc_v_i_u8m8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u16mf4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.i.nxv1i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u16mf4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.i.nxv1i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i16> [[TMP0]]
//
vuint16mf4_t test_sf_vc_v_i_u16mf4(size_t vl) {
  return __riscv_sf_vc_v_i_u16mf4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u16mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.i.nxv2i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u16mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.i.nxv2i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i16> [[TMP0]]
//
vuint16mf2_t test_sf_vc_v_i_u16mf2(size_t vl) {
  return __riscv_sf_vc_v_i_u16mf2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u16m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.i.nxv4i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u16m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.i.nxv4i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i16> [[TMP0]]
//
vuint16m1_t test_sf_vc_v_i_u16m1(size_t vl) {
  return __riscv_sf_vc_v_i_u16m1(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u16m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.i.nxv8i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u16m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.i.nxv8i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i16> [[TMP0]]
//
vuint16m2_t test_sf_vc_v_i_u16m2(size_t vl) {
  return __riscv_sf_vc_v_i_u16m2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u16m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.i.nxv16i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u16m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.i.nxv16i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i16> [[TMP0]]
//
vuint16m4_t test_sf_vc_v_i_u16m4(size_t vl) {
  return __riscv_sf_vc_v_i_u16m4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u16m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.i.nxv32i16.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u16m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.i.nxv32i16.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 32 x i16> [[TMP0]]
//
vuint16m8_t test_sf_vc_v_i_u16m8(size_t vl) {
  return __riscv_sf_vc_v_i_u16m8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u32mf2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.i.nxv1i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u32mf2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.i.nxv1i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i32> [[TMP0]]
//
vuint32mf2_t test_sf_vc_v_i_u32mf2(size_t vl) {
  return __riscv_sf_vc_v_i_u32mf2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u32m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.i.nxv2i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u32m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.i.nxv2i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i32> [[TMP0]]
//
vuint32m1_t test_sf_vc_v_i_u32m1(size_t vl) {
  return __riscv_sf_vc_v_i_u32m1(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u32m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.i.nxv4i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u32m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.i.nxv4i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i32> [[TMP0]]
//
vuint32m2_t test_sf_vc_v_i_u32m2(size_t vl) {
  return __riscv_sf_vc_v_i_u32m2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u32m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.i.nxv8i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u32m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.i.nxv8i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i32> [[TMP0]]
//
vuint32m4_t test_sf_vc_v_i_u32m4(size_t vl) {
  return __riscv_sf_vc_v_i_u32m4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u32m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.i.nxv16i32.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u32m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.i.nxv16i32.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 16 x i32> [[TMP0]]
//
vuint32m8_t test_sf_vc_v_i_u32m8(size_t vl) {
  return __riscv_sf_vc_v_i_u32m8(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u64m1(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.i.nxv1i64.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u64m1(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.i.nxv1i64.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 1 x i64> [[TMP0]]
//
vuint64m1_t test_sf_vc_v_i_u64m1(size_t vl) {
  return __riscv_sf_vc_v_i_u64m1(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u64m2(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.i.nxv2i64.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u64m2(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.i.nxv2i64.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 2 x i64> [[TMP0]]
//
vuint64m2_t test_sf_vc_v_i_u64m2(size_t vl) {
  return __riscv_sf_vc_v_i_u64m2(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u64m4(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.i.nxv4i64.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u64m4(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.i.nxv4i64.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 4 x i64> [[TMP0]]
//
vuint64m4_t test_sf_vc_v_i_u64m4(size_t vl) {
  return __riscv_sf_vc_v_i_u64m4(p27_26, p24_20, simm5, vl);
}

// CHECK-RV32-LABEL: @test_sf_vc_v_i_u64m8(
// CHECK-RV32-NEXT:  entry:
// CHECK-RV32-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.i.nxv8i64.i32.i32.i32(i32 3, i32 31, i32 10, i32 [[VL:%.*]])
// CHECK-RV32-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
// CHECK-RV64-LABEL: @test_sf_vc_v_i_u64m8(
// CHECK-RV64-NEXT:  entry:
// CHECK-RV64-NEXT:    [[TMP0:%.*]] = call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.i.nxv8i64.i64.i64.i64(i64 3, i64 31, i64 10, i64 [[VL:%.*]])
// CHECK-RV64-NEXT:    ret <vscale x 8 x i64> [[TMP0]]
//
vuint64m8_t test_sf_vc_v_i_u64m8(size_t vl) {
  return __riscv_sf_vc_v_i_u64m8(p27_26, p24_20, simm5, vl);
}
