; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -instcombine -S < %s | FileCheck %s

; CHECK-LABEL: good1
; CHECK: %[[INS:.*]] = insertelement <4 x float> undef, float %arg, i32 0
; CHECK-NEXT: %[[BCAST:.*]] = shufflevector <4 x float> %[[INS]], <4 x float> undef, <4 x i32> zeroinitializer
; CHECK-NEXT: ret <4 x float> %[[BCAST]]
define <4 x float> @good1(float %arg) {
  %tmp = insertelement <4 x float> undef, float %arg, i32 0
  %tmp4 = insertelement <4 x float> %tmp, float %arg, i32 1
  %tmp5 = insertelement <4 x float> %tmp4, float %arg, i32 2
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  ret <4 x float> %tmp6
}

; CHECK-LABEL: good2
; CHECK: %[[INS:.*]] = insertelement <4 x float> undef, float %arg, i32 0
; CHECK-NEXT: %[[BCAST:.*]] = shufflevector <4 x float> %[[INS]], <4 x float> undef, <4 x i32> zeroinitializer
; CHECK-NEXT: ret <4 x float> %[[BCAST]]
define <4 x float> @good2(float %arg) {
  %tmp = insertelement <4 x float> undef, float %arg, i32 1
  %tmp4 = insertelement <4 x float> %tmp, float %arg, i32 2
  %tmp5 = insertelement <4 x float> %tmp4, float %arg, i32 0
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  ret <4 x float> %tmp6
}

; CHECK-LABEL: good3
; CHECK: %[[INS:.*]] = insertelement <4 x float> undef, float %arg, i32 0
; CHECK-NEXT: %[[BCAST:.*]] = shufflevector <4 x float> %[[INS]], <4 x float> undef, <4 x i32> zeroinitializer
; CHECK-NEXT: ret <4 x float> %[[BCAST]]
define <4 x float> @good3(float %arg) {
  %tmp = insertelement <4 x float> zeroinitializer, float %arg, i32 0
  %tmp4 = insertelement <4 x float> %tmp, float %arg, i32 1
  %tmp5 = insertelement <4 x float> %tmp4, float %arg, i32 2
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  ret <4 x float> %tmp6
}

; CHECK-LABEL: good4
; CHECK: %[[INS:.*]] = insertelement <4 x float> undef, float %arg, i32 0
; CHECK-NEXT: %[[ADD:.*]] = fadd <4 x float> %[[INS]], %[[INS]]
; CHECK-NEXT: %[[BCAST:.*]] = shufflevector <4 x float> %[[ADD]], <4 x float> undef, <4 x i32> zeroinitializer
; CHECK-NEXT: ret <4 x float> %[[BCAST]]
define <4 x float> @good4(float %arg) {
  %tmp = insertelement <4 x float> zeroinitializer, float %arg, i32 0
  %tmp4 = insertelement <4 x float> %tmp, float %arg, i32 1
  %tmp5 = insertelement <4 x float> %tmp4, float %arg, i32 2
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  %tmp7 = fadd <4 x float> %tmp6, %tmp6
  ret <4 x float> %tmp7
}

; CHECK-LABEL: bad1
; CHECK-NOT: shufflevector
define <4 x float> @bad1(float %arg) {
  %tmp = insertelement <4 x float> undef, float %arg, i32 1
  %tmp4 = insertelement <4 x float> %tmp, float %arg, i32 1
  %tmp5 = insertelement <4 x float> %tmp4, float %arg, i32 2
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  ret <4 x float> %tmp6
}

; CHECK-LABEL: bad2
; CHECK-NOT: shufflevector
define <4 x float> @bad2(float %arg) {
  %tmp = insertelement <4 x float> undef, float %arg, i32 0
  %tmp5 = insertelement <4 x float> %tmp, float %arg, i32 2
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  ret <4 x float> %tmp6
}

; CHECK-LABEL: bad3
; CHECK-NOT: shufflevector
define <4 x float> @bad3(float %arg, float %arg2) {
  %tmp = insertelement <4 x float> undef, float %arg, i32 0
  %tmp4 = insertelement <4 x float> %tmp, float %arg2, i32 1
  %tmp5 = insertelement <4 x float> %tmp4, float %arg, i32 2
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  ret <4 x float> %tmp6
}

; CHECK-LABEL: bad4
; CHECK-NOT: shufflevector
define <1 x float> @bad4(float %arg) {
  %tmp = insertelement <1 x float> undef, float %arg, i32 0
  ret <1 x float> %tmp
}

; CHECK-LABEL: bad5
; CHECK-NOT: shufflevector
define <4 x float> @bad5(float %arg) {
  %tmp = insertelement <4 x float> undef, float %arg, i32 0
  %tmp4 = insertelement <4 x float> %tmp, float %arg, i32 1
  %tmp5 = insertelement <4 x float> %tmp4, float %arg, i32 2
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  %tmp7 = fadd <4 x float> %tmp6, %tmp4
  ret <4 x float> %tmp7
}

; CHECK-LABEL: bad6
; CHECK-NOT: shufflevector
define <4 x float> @bad6(float %arg, i32 %k) {
  %tmp = insertelement <4 x float> undef, float %arg, i32 0
  %tmp4 = insertelement <4 x float> %tmp, float %arg, i32 1
  %tmp5 = insertelement <4 x float> %tmp4, float %arg, i32 %k
  %tmp6 = insertelement <4 x float> %tmp5, float %arg, i32 3
  ret <4 x float> %tmp6
}
