// generated by go run gen.go; DO NOT EDIT

package publicsuffix

const version = "publicsuffix.org's public_suffix_list.dat, git revision bade64c (2016-03-01)"

const (
	nodesBitsChildren   = 9
	nodesBitsICANN      = 1
	nodesBitsTextOffset = 15
	nodesBitsTextLength = 6

	childrenBitsWildcard = 1
	childrenBitsNodeType = 2
	childrenBitsHi       = 14
	childrenBitsLo       = 14
)

const (
	nodeTypeNormal     = 0
	nodeTypeException  = 1
	nodeTypeParentOnly = 2
)

// numTLD is the number of top level domains.
const numTLD = 1545

// Text is the combined text of all labels.
const text = "bievatmallorcadaquesanfranciscotlandupontarioceanographiquebifuk" +
	"agawalmartateshinanomachintaijinuyamanouchikuhokuryugasakitashio" +
	"barabihorologyusuharabikedagestangebilbaogakievenesangoddabillus" +
	"trationikkoebenhavnikolaeverbankashiwarabiomutashinainvestmentsa" +
	"njotateyamabirdartcenterprisesakikonaircraftraeumtgeradealstahau" +
	"gesundurbanamexeterbirkenesoddtangenovaravennaharimalvikashiwaza" +
	"kiyokawarabirthplacebjarkoyusuisservicesannanikonantanangerbjerk" +
	"reimmobilieninohelplfinancialipetskasukabedzin-the-bandaioiraseb" +
	"astopologyeongnamegawakembuchikumagayagawakkanaibetsubamericanfa" +
	"milydscloudappspotenzachpomorskienebakkeshibechambagriculturenne" +
	"budapest-a-la-masioninomiyakonojoshkar-olayangroupaleostrowiecar" +
	"toonartdecoffeedbackasumigaurawa-mazowszextraspace-to-rentalstom" +
	"akomaibarabjugnirasakis-a-candidateblockbusternidurhamburgliwice" +
	"bloombergbauernrtatsunostrowwlkpmglobalashovhachinoheguris-a-cat" +
	"ererbluedatingloboehringerikebmoattachmentsannohelsinkitahiroshi" +
	"marshallstatebankasuyakutiabmsanokaszubyuudmurtiabmwegroweibolza" +
	"nore-og-uvdalivornobnpparibaselburglogoweirbomloansantabarbarabo" +
	"ndvrdnsantacruzsantafedexhibitionishiazais-a-celticsfanishigotpa" +
	"ntheonishiharabonnishiizunazukis-a-chefarsundwgloppenzaogashimad" +
	"achicagobododgemologicallyngenglandyndns-homednsanukis-a-conserv" +
	"ativefsncfailomzansimagicasadelamonedavvesiidazaifudaigodoesntex" +
	"istanbullensakerbookingmbhartiffanynysafetysfjordyndns-ip6bootsa" +
	"otomeldalorenskogminakamichigangwonishikatakazakis-a-cpadoval-da" +
	"ostavalleyuzawaboschaefflerdalotenkawabostikatowicebostonakijins" +
	"ekikogentingmodenakasatsunairtrafficaseihichisobetsuitairabotani" +
	"calgardenishikatsuragithubusercontentattoolsztynsettlersapodhale" +
	"vangerbotanicgardenishikawazukanazawabotanyuzhno-sakhalinskatsus" +
	"hikabeeldengeluidyndns-mailotteboutiquebecngmxboxenapponazure-mo" +
	"bilebozentsujiiebradescorporationishimerabrandywinevalleybrasilj" +
	"an-mayenishinomiyashironobresciabrindisibenikebristolgalsacebrit" +
	"ishcolumbialowiezagannakadomari-elasticbeanstalkatsuyamasfjorden" +
	"ishinoomotegotsukisosakitagatakamatsukawabroadcastlebtimnetzgora" +
	"broadwaybroke-itaxihuanishinoshimatta-varjjatgorybrokerrypropert" +
	"iesapporobronnoysundyndns-office-on-the-webcambridgestonewspaper" +
	"brothermesaverdefensejnybrumunddalottokigawabrunelblagdenesnaase" +
	"ralingenkainanaejrietisalatinabenogatachikawakayamagadancebetsuk" +
	"ubabia-goracleaningatlantagajobojis-a-cubicle-slavellinowtvallea" +
	"ostavernishiokoppegardyndns-picsaratovalled-aostavropolicebrusse" +
	"lsardegnamsskoganeis-a-democratjeldsundyndns-remotegildeskalmyki" +
	"abruxellesardiniabryanskjakdnepropetrovskiervaapsteiermarkaufeni" +
	"shitosashimizunaminamiashigarabryneustarhubalestrandabergamoarek" +
	"ehimejibestadishakotankarmoyokozembroideryomitanobninskarpaczela" +
	"dz-1buskerudinewhampshirechtrainingretakamoriokamchatkameokameya" +
	"mashinatsukigatakanabeatsarlouvrepairbusantiquest-a-la-maisondre" +
	"-landebusinessebykleclercasertaishinomakikuchikuseikarugapartmen" +
	"tsarpsborgrimstadyndns-serverbaniabuzenishiwakis-a-designerbuzzg" +
	"orzeleccollegersundyndns-weberlincolnissandnessjoenissayokoshiba" +
	"hikariwanumataketomisatokuyamatteledatabaseballooningripebwfashi" +
	"onissedalovegaskimitsubatamicabbottjmaxxxfinitybzhitomirkutskjer" +
	"voyagecloudfunctionsaudacntkmaxxn--11b4c3dcolognewmexicoldwarmia" +
	"miastaplesauheradcolonialwilliamsburguideventsavannahgacoloradop" +
	"lateaudiocolumbusheycommunitysnesaves-the-whalessandria-trani-ba" +
	"rletta-andriatranibarlettaandriacomobaracomparemarkerryhotelsavo" +
	"naplesaxocompute-1computerhistoryofscience-fictioncomsecuritysva" +
	"rdoharuhrcondoshichinohedmarkhangelskypescaravantaaconferencecon" +
	"structionconsuladollsbschokoladenconsultanthropologyconsultingvo" +
	"llutskddielddanuorrikuzentakatajirissagaeroclubmedecincinnationw" +
	"idealerimo-i-ranadexchangeiseiyoichiropracticbcn-north-1contactm" +
	"palmspringsakercontemporaryarteducationalchikugojomedicaltanisse" +
	"ttaiwanairguardcontractorskenconventureshinodesashibetsuikimobet" +
	"suliguriacookingchannelveruminamibosogndaluxembourguitarscholars" +
	"hipschooluxurycoolkuszgradcoopocznorthwesternmutualuzerncopenhag" +
	"encyclopedicdn77-sslattumetlifeinsurancecorsicagliaridagawarszaw" +
	"ashingtondclkfhskhabarovskhakassiacorvettemasekharkivguccipriani" +
	"igataitogitsuldalvivano-frankivskharkovalledaostakkofuelcosenzam" +
	"amibuilderschulexuslivinghistorycostumedio-campidano-mediocampid" +
	"anomediocouncilcouponschwarzgwangjuifminamidaitomangotembaixadac" +
	"ourseschweizippodlasiellakasamatsudovre-eikercq-acranbrookuwanal" +
	"yticsciencecentersciencehistorycreditcardcreditunioncremonashoro" +
	"kanaiecrewiiheyaizuwakamatsubushikusakadogawacricketrzyncrimeacr" +
	"otonewportlligatewaycrowncrscientistor-elvdalcruisescjohnsoncuis" +
	"inellajollamericanexpressexyzjcbnlculturalcentertainmentoyokawac" +
	"uneocupcakecxn--1ck2e1balsanagochihayaakasakawaharaumakeupowiath" +
	"letajimabariakepnordkappgjesdalillyonabaruconnectarnobrzegjovika" +
	"ruizawaugustowadaegubs3-ap-southeast-2cymruovatoyonakagyokutoshi" +
	"macyouthdfcbankhersonfilateliafilminamiechizenfinalfinancefinear" +
	"tsettsurfastlyfinlandfinnoyfirebaseappamperedchefauskedsmokorset" +
	"agayaseljordfirenzefirestonextdirectoryfirmdalegoldpointelligenc" +
	"efishingolfbsbxn--1ctwolominamatamayukis-a-geekhmelnitskiyamashi" +
	"kefitjarqhachiojiyahikobeautydalfitnessettlementoyookarasjohkami" +
	"noyamatsuris-a-greenfjalerflickragerotikaluganskhmelnytskyivalle" +
	"e-aosteroyflightsevastopolezajskhvalleeaosteigenflirumansionseve" +
	"nassisicilyfloguchikuzenfloraflorencefloridafloristanohatakaharu" +
	"ssiafloromskoguovdageaidnulminamifuranoflowersewildlifestyleflsm" +
	"idthruhereggio-emilia-romagnakanotoddenflynnhubalsfjordiskstatio" +
	"naustdalimanowarudaukraanghke164fndfolldalfoodnetworkangerfor-be" +
	"tter-thandafor-ourfor-somedizinhistorischesfranziskanerimamatera" +
	"mochizukirafor-theaterforexrothachirogatakanezawaforgotdnshangri" +
	"langevagrarboretumbriaforli-cesena-forlicesenaforlikes-piedmontb" +
	"lancomeeresharis-a-gurulsandoyforsaleikangerforsandasuolodingenf" +
	"ortmissoulan-udell-ogliastrakhanawawilliamhillfortworthadanotoga" +
	"waforuminamiiselectoyosatotalfosnesharpanamafotoyotaris-a-hard-w" +
	"orkerfoxn--1lqs03nfreiburgushikamifuranotaireshawaiijimarylandfr" +
	"eightcmwinbaltimore-og-romsdalimitedunetflixilimoliserniaurskog-" +
	"holandroverhalla-speziaetnagahamaroygardendoftheinternetcimdbala" +
	"tinordre-landds3-ap-northeast-2freseniusdecorativeartshellaspezi" +
	"afribourgxn--1lqs71dfriuli-v-giuliafriuli-ve-giuliafriuli-vegiul" +
	"iafriuli-venezia-giuliafriuli-veneziagiuliafriuli-vgiuliafriuliv" +
	"-giuliafriulive-giuliafriulivegiuliafriulivenezia-giuliafriulive" +
	"neziagiuliafriulivgiuliafrlfroganshimokawafrognfrolandfrom-akreh" +
	"amnfrom-alfrom-arfrom-azlgzpanasonicheltenham-radio-operaunitele" +
	"markautokeinofrom-canonoichikawamisatodayfrom-collectionfrom-cto" +
	"yotomiyazakis-a-hunterfrom-dchelyabinskodjeffersonisshinguernsey" +
	"from-dellogliastraderfrom-flandershimokitayamafrom-gaulardalfrom" +
	"-higashiagatsumagoirmitakeharafrom-iafrom-idfrom-ilfrom-incheonf" +
	"rom-kshimonitayanagivestbytomaritimekeepingfrom-kyknetoyotsukaid" +
	"ownloadfrom-lanbibaidarfrom-manxn--1qqw23afrom-mdfrom-meetoyoura" +
	"from-microsoftbanklabudhabikinokawabarthadselfipirangafrom-mnfro" +
	"m-modalenfrom-mshimonosekikawafrom-mtnfrom-nchernigovernmentjome" +
	"morialucaniafrom-ndfrom-nexusgardenfrom-nhktoystre-slidrettozawa" +
	"from-njcparaglidingfrom-nminamiizukamitondabayashiogamagoriziafr" +
	"om-nvanylvenicefrom-nyfrom-ohkurafrom-oketogurafrom-orfrom-pader" +
	"bornfrom-pratohmaoris-a-knightozsdefrom-ris-a-landscaperugiafrom" +
	"-schoenbrunnfrom-sdnipropetrovskmpspbambleborkarumaifarmsteadivt" +
	"asvuodnakaiwamizawaustevollavangenativeamericanantiques3-eu-cent" +
	"ral-1from-tnfrom-txn--2m4a15efrom-utazuerichardlikescandyndns-at" +
	"-homedepotaruis-a-lawyerfrom-vadsochildrensgardenfrom-vtranbyfro" +
	"m-wafrom-wielunnerfrom-wvaolbia-tempio-olbiatempioolbialystokkem" +
	"erovodkagoshimaintenancefrom-wyfrosinonefrostalowa-wolawafroyaha" +
	"badajozorahkkeravjudygarlandfstcgrouparisor-fronfujiiderafujikaw" +
	"aguchikonefujiminohtawaramotoineppugliafujinomiyadafujiokayamarb" +
	"urgfujisatoshonairportland-4-salernogiessengerdalaskanittedallas" +
	"alleaseeklogesquarezzoologyfujisawafujishiroishidakabiratoridelm" +
	"enhorstalbanshimosuwalkis-a-liberalfujitsurugashimarinefujixerox" +
	"n--30rr7yfujiyoshidafukayabeardubaiduckdnsdojoburgfukuchiyamadaf" +
	"ukudominichernihivanovosibirskydivingrondarfukuis-a-libertarianf" +
	"ukumitsubishigakirkeneshimotsukefukuokazakirovogradoyfukuroishik" +
	"arikaturindalfukusakiryuohaebaruminamimakis-a-linux-useranishiar" +
	"itabashikaoizumizakitaurayasudafukuyamagatakahashimamakisarazure" +
	"websiteshikagamiishibukawafunabashiriuchinadafunagatakahatakaish" +
	"imoichinosekigaharafunahashikamiamakusatsumasendaisennangonoheji" +
	"s-a-llamarylhursteinkjerusalembetsukuis-a-musicianfundaciofuoisk" +
	"ujukuriyamarcheaparliamentrani-andria-barletta-trani-andriafuoss" +
	"koczowindmillfurnitureggiocalabriafurubiraquarelleasingleshimots" +
	"umafurudonostiafurukawairtelecityeatshinichinanfusodegaurafussai" +
	"kishiwadafutabayamaguchinomigawafutboldlygoingnowhere-for-morego" +
	"ntrailroadfuttsurugiminamiminowafvgfyis-a-nascarfanfylkesbiblack" +
	"fridayfyresdalhannovareserveftparocherkasyzrankoshigayaltaikis-a" +
	"-painteractivegarsheis-a-patsfanhanyuzenhapmirhappoulvikokonoeha" +
	"reidsbergenharstadharvestcelebrationhasamarahasaminami-alpssells" +
	"-for-unzenhashbanghasudahasvikolobrzegyptianpachigasakidsmynaspe" +
	"rschlesischesurancehatogayahoooshikamaishimofusartshinkamigotoyo" +
	"hashimotomobellunordreisa-geekomaganehatoyamazakitahatakaokamiki" +
	"tayamatotakadahatsukaichiharahattfjelldalhayashimamotobuildingha" +
	"zuminobusells-itraniandriabarlettatraniandriahbofagehembygdsforb" +
	"undhemneshinshinotsurgeonshalloffamelhustkamisunagawahemsedalher" +
	"okussldheroyhgtvarggatranoyhigashichichibungotakadatsunanjoetsuw" +
	"anouchikujogaszkoladbrokesennumamurogawalterhigashihiroshimanehi" +
	"gashiizumozakitakamiizumisanofiatransportrapaniimimatakatoris-a-" +
	"personaltrainerhigashikagawahigashikagurasoedahigashikawakitaaik" +
	"itakatakarazukamikoaniikappulawyhigashikurumeguroroskoleirvikoma" +
	"kiyosatokamachippubetsubetsugaruhigashimatsushimarugame-hostingh" +
	"igashimatsuyamakitaakitadaitoigawahigashimurayamalatvuopmidoris-" +
	"a-photographerokuapparshinshirohigashinarusellsyourhomegoodshint" +
	"okushimahigashinehigashiomihachimanchesterhigashiosakasayamamoto" +
	"rcycleshintomikasaharahigashishirakawamatakasagooglecodespotrave" +
	"lchannelhigashisumiyoshikawaminamiaikitakyushuaiahigashitsunowru" +
	"zhgorodoyhigashiurausukitamidsundhigashiyamatokoriyamanakakogawa" +
	"higashiyodogawahigashiyoshinogaris-a-playerhiraizumisatohnoshooh" +
	"irakatashinagawahiranais-a-republicancerresearchaeologicaliforni" +
	"ahirarahiratsukagawahirayaitakasakitamotosumitakaginankokubunjis" +
	"-a-rockstarachowicehisayamanashiibaghdadultravelersinsurancehist" +
	"orichouseshinyoshitomiokaniepcehitachiomiyaginowaniihamatamakawa" +
	"jimaritimodellinghitachiotagopartis-a-socialistmeindianapolis-a-" +
	"bloggerhitoyoshimifunehitradinghjartdalhjelmelandholeckobierzyce" +
	"holidayhomeipartnershiojirishirifujiedahomelinuxn--32vp30hagebos" +
	"tadhomesensembokukitanakagusukumoduminamiogunicomcastresistanceh" +
	"omeunixn--3bst00minamisanrikubetsupplyhondahonefosshioyameloyali" +
	"stockholmestrandhoneywellhongorgehonjyoitakashimarumorimachidaho" +
	"rnindalhorseminehortendofinternetrdhoteleshirahamatonbetsurgeryh" +
	"otmailhoyangerhoylandetroitskomatsushimashikiyosemitehumanitiesh" +
	"irakoenighurdalhurumajis-a-soxfanhyllestadhyogoris-a-studentalhy" +
	"ugawarahyundaiwafunejgorajlchitachinakagawatchandclockazimierz-d" +
	"olnyjlljmpartshishikuis-an-actorjnjelenia-gorajoyokaichibahcavuo" +
	"tnagaraholtalenjpmorganichitosetogakushimotoganewjerseyjpnchloej" +
	"prshisognejuniperjurkristiansandcatshisuifuettertdasnetzwindowsh" +
	"itaramakristiansundkrodsheradkrokstadelvaldaostarostwodzislawinn" +
	"ershizukuishimogosenkryminamitanekumatorinokumejimasudakumenanyo" +
	"kkaichirurgiens-dentisteshizuokanoyakagekunisakis-an-entertainer" +
	"kunitachiarailwaykunitomigusukumamotoyamassa-carrara-massacarrar" +
	"amassabunkyonanaoshimageandsoundandvisionkunneppupartykunstsamml" +
	"ungkunstunddesignkuokgroupasadenamsosnowiechocolatelevisionrwhal" +
	"ingrongausdaluccapebretonamiasakuchinotsuchiurakawassamukawatari" +
	"cohdavvenjargamvikazokureitrentino-stirolkurgankurobelaudiblebes" +
	"byglandkurogimilitarykuroisoftwarendalenugkuromatsunais-bykurota" +
	"kikawasakis-certifiedekakegawakurskomonokushirogawakustanais-fou" +
	"ndationkusupersportrentino-sud-tirolkutchanelkutnokuzbassnillfjo" +
	"rdkuzumakis-gonekvafjordkvalsundkvamlidlugolekagaminord-aurdalvd" +
	"alipayufuchukotkafjordkvanangenkvinesdalkvinnheradkviteseidskogk" +
	"vitsoykwpspjelkavikomorotsukamishihoronobeokaminokawanishiaizuba" +
	"ngekyotobetsupplieshoujis-into-animeiwamaseratis-a-therapistoiak" +
	"yowariasahikawamishimatsumotofukemissileksvikongsbergmisugitokon" +
	"amegatakayamatsunomitourismolanciamitoyoakemiuramiyazumiyotamano" +
	"mjondalenmlbarclaycards3-us-west-1monmouthaibarakitagawamonsterm" +
	"onticellolmontrealestatefarmequipmentrentino-sudtirolmonza-brian" +
	"zaporizhzhekinannestadmonza-e-della-brianzaporizhzhiamonzabrianz" +
	"apposlombardiamondshowtimemerckongsvingermonzaebrianzaramonzaede" +
	"llabrianzamoparachutingmordoviajessheiminamiuonumatsumaebashimod" +
	"atemoriyamatsusakahoginozawaonsenmoriyoshiokamitsuemormoneymoroy" +
	"amatsushigemortgagemoscowiostrolekaneyamaxunjargamoseushistorymo" +
	"sjoenmoskeneshriramsterdambulanceomossienarashinomosvikoninjamis" +
	"onmoviemovistargardmtpccwitdkonskowolancashirehabmermtranakayama" +
	"tsuuramuenstermugithubcloudusercontentrentino-sued-tirolmuikamog" +
	"awamukochikushinonsenergymulhouservebbsigdalmultichoicemunakatan" +
	"emuncieszynmuosattemupassagensimbirskonsulatrobeermurmanskonyvel" +
	"oftrentino-s-tirollagrigentomologyeonggiehtavuoatnagaivuotnagaok" +
	"akyotambabydgoszczecinemailmurotorcraftrentino-suedtirolmusashim" +
	"urayamatsuzakis-leetrentino-a-adigemusashinoharamuseetrentinoa-a" +
	"digemuseumverenigingmutsuzawamutuellelmyokohamamatsudamypetsimpl" +
	"e-urlmyphotoshibahccavuotnagareyamaizurubtsovskiptveterinairebun" +
	"goonomichinomiyakemytis-a-bookkeeperminamiyamashirokawanabelgoro" +
	"deophiladelphiaareadmyblogsitephilatelyphilipsyphoenixn--3e0b707" +
	"ephotographysiopiagetmyipassenger-associationpictetrentinoaadige" +
	"pictureslupskooris-an-actresshiraois-a-techietis-a-teacherkassym" +
	"antechnologypiemontepilotsmolenskopervikommunalforbundpinkoryola" +
	"sitepioneerpippupiszpittsburghofedjejuegoshikiminokamoenairlineb" +
	"raskaunbieidsvollpiwatepizzapkosaigawaplanetariuminanoplantation" +
	"plantsnoasaitamatsukuris-lostre-toteneis-an-accountantshiranukan" +
	"makiwakunigamihamadaplatformincommbankomvuxn--3ds443gplaystation" +
	"plazaplchofunatorientexpressasayamaplombardyndns-at-workinggroup" +
	"aviancapetownplumbingotvbarclays3-us-west-2plusterpmnpodzonepohl" +
	"pokerpokrovskosakaerodromegallupinbarcelonagasakijobservercellie" +
	"rneues3-us-gov-west-1politiendapolkowicepoltavalle-aostathellewi" +
	"smillerpomorzeszowithgoogleapisa-hockeynutrentinoalto-adigeporde" +
	"nonepornporsangerporsangugeporsgrunnanpoznanpraxis-a-bruinsfansn" +
	"zprdpreservationpresidioprgmrprimelbourneprincipeprivneprochowic" +
	"eproductionsokanraprofermobilyprogressivenneslaskerrylogisticsok" +
	"ndalprojectrentinoaltoadigepromombetsupportrentinos-tirolpropert" +
	"yprotectionprudentialpruszkowithyoutubeneventochiokinoshimalselv" +
	"endrellprzeworskogptzpvtrentinostirolpwchonanbugattipschmidtre-g" +
	"auldalucernepzqldqponqslgbtrentinosud-tirolqvchoseiroumuenchenst" +
	"orfjordstpetersburgstreamurskinderoystudiostudyndns-freemasonryo" +
	"kamikawanehonbetsurutaharastuff-4-salestuttgartrentinosuedtirols" +
	"urnadalsurreysusakis-slickomforbananarepublicargodaddynathomebui" +
	"ltarumizusawaustinnaturalhistorymuseumcentereviewskrakowebhopage" +
	"frontappagespeedmobilizerobihirosakikamijimagroks-thisamitsukeis" +
	"enbahnasushiobaraeroportalabamagasakishimabarackmaze-burggfarmer" +
	"seinewyorkshireggio-calabriabruzzoologicalvinklein-addrammenuern" +
	"bergdyniabogadocscbg12000susonosuzakanumazurysuzukanzakiwiensuzu" +
	"kis-uberleetrentino-aadigesvalbardudinkakamigaharasveiosvelvikos" +
	"himizumakiyosumykolaivaroysvizzeraswedenswidnicapitalonewholland" +
	"swiebodzindianmarketingswiftcoverisignswinoujscienceandhistorysw" +
	"isshikis-very-badaddjamalborkdalsxn--3oq18vl8pn36atuscanytushuis" +
	"sier-justicetuvalle-daostavangervestnesopotrentinosudtirolvestre" +
	"-slidreamhostersor-odalvestre-totennishiawakuravestvagoyvevelsta" +
	"dvibo-valentiavibovalentiavideovillaskoyabearalvahkihokumakogeni" +
	"waizumiotsukumiyamazonawsabaerobaticketsor-varangervinnicarbonia" +
	"-iglesias-carboniaiglesiascarboniavinnytsiavipsinaappfizervirgin" +
	"iavirtualvirtuelvisakatakinouevistaprintuitrentottoris-very-evil" +
	"lageviterboltrevisohughesolognevivoldavladikavkazanvladimirvladi" +
	"vostokaizukarasuyamazoevlogvolkenkunderseaportroandinosaurepbody" +
	"ndns-blogdnsolundbeckoseis-an-anarchistoricalsocietyvolkswagents" +
	"orfoldvologdanskostromahachijorpelandvolvolgogradvolyngdalvorone" +
	"zhytomyrvossevangenvotevotingvotoursorreisahayakawakamiichikaise" +
	"is-saveducatorahimeshimakanegasakinkobayashikshacknetnedalvrnwor" +
	"se-thangglidingwowiwatsukiyonowritesthisblogspotrogstadwroclawlo" +
	"clawekosugewtchoshibuyachiyodawtferrarawuozuwwworldwzmiuwajimaxn" +
	"--4gq48lf9jeonnamerikawauexn--4it168dxn--4it797kotouraxn--4pvxso" +
	"rtlandxn--54b7fta0cchromediaxn--55qw42gxn--55qx5dxn--5js045dxn--" +
	"5rtp49chryslerxn--5rtq34kouhokutamakis-an-artistjohnxn--5su34j93" +
	"6bgsgxn--5tzm5gxn--6btw5axn--6frz82gxn--6orx2rxn--6qq986b3xlxn--" +
	"7t0a264chungbukazunoxn--80adxhksoruminnesotaketakatsukis-into-ca" +
	"rshiraokannamiharuxn--80ao21axn--80aqecdr1axn--80asehdbarefootba" +
	"llangenoamishirasatobishimalopolskanlandivttasvuotnakamagayachts" +
	"akuraibigawaustraliaisondriodejaneirochesterhcloudcontrolledigit" +
	"alaziobirakunedre-eikereportarantomsk-uralsk12xn--80aswgxn--80au" +
	"dnedalnxn--8ltr62kounosunndalxn--8pvr4uxn--8y0a063axn--90a3acade" +
	"mydroboatsaritsynologyeongbukouyamashikokuchuoxn--90aishobaraomo" +
	"riguchiharagusaarlandxn--90azhair-surveillancexn--9dbhblg6diethn" +
	"ologyxn--9dbq2axn--9et52uxn--9krt00axn--andy-iraxn--aroport-byan" +
	"agawaxn--asky-iraxn--aurskog-hland-jnbargainstitutelefonicafeder" +
	"ationaval-d-aosta-valleyonagoyaustrheimatunduhrennesoyekaterinbu" +
	"rgjemnes3-eu-west-1xn--avery-yuasakegawaxn--b-5gaxn--b4w605ferdx" +
	"n--bck1b9a5dre4chungnamdalseidfjordyroyrvikingrossetouchijiwadel" +
	"tajimicrolightingroundhandlingroznyxn--bdddj-mrabdxn--bearalvhki" +
	"-y4axn--berlevg-jxaxn--bhcavuotna-s4axn--bhccavuotna-k7axn--bidr" +
	"-5nachikatsuuraxn--bievt-0qa2xn--bjarky-fyanaizuxn--bjddar-ptamb" +
	"oversaillesooxn--blt-elaborxn--bmlo-graingerxn--bod-2naroyxn--br" +
	"nny-wuaccident-investigationjukudoyamaceratabuseat-band-campania" +
	"mallamadridvagsoyericssonlineat-urlxn--brnnysund-m8accident-prev" +
	"entionxn--brum-voagatromsakakinokiaxn--btsfjord-9zaxn--c1avgxn--" +
	"c2br7gxn--c3s14minternationalfirearmshowaxn--cck2b3barreauctiona" +
	"vigationavuotnakhodkanagawauthordalandroidiscountyumenaturalscie" +
	"ncesnaturelles3-external-1xn--cg4bkis-very-goodhandsonxn--ciqpnx" +
	"n--clchc0ea0b2g2a9gcdn77-securecipesaro-urbino-pesarourbinopesar" +
	"omaniwakuratelekommunikationxn--comunicaes-v6a2oxn--correios-e-t" +
	"elecomunicaes-ghc29axn--czr694barrel-of-knowledgeometre-experts-" +
	"comptablesakyotanabellevuelosangelesjaguarchitecturealtychyattor" +
	"neyagawalbrzycharternopilawalesundiyonaguniversityoriikasaokamio" +
	"kamiminersalangenayoroceanographicsalondonetskashibatakasugaibmd" +
	"npalacemergencyberlevagangaviikanonjiinetatamotorsaltdalindasiau" +
	"tomotivecodyn-o-saurlandes3-external-2xn--czrs0tromsojavald-aost" +
	"arnbergxn--czru2dxn--czrw28barrell-of-knowledgeorgeorgiautoscana" +
	"daejeonbukariyakumoldebinagisoccertificationaturbruksgymnaturhis" +
	"torisches3-fips-us-gov-west-1xn--d1acj3bashkiriaveroykenvironmen" +
	"talconservationatuurwetenschappenaumburgjerdrumckinseyokosukarel" +
	"iancebinosegawasmatartanddesignieznorddalavagiske12xn--d1alfarom" +
	"eoxn--d1atrusteexn--d5qv7z876churchaseljeepilepsydneyxn--davvenj" +
	"rga-y4axn--djrs72d6uyxn--djty4kouzushimasoyxn--dnna-grajewolters" +
	"kluwerxn--drbak-wuaxn--dyry-iraxn--eckvdtc9dxn--efvn9southcaroli" +
	"nazawaxn--efvy88hakatanotteroyxn--ehqz56nxn--elqq16hakodatevaksd" +
	"alxn--estv75gxn--eveni-0qa01gaxn--f6qx53axn--fct429kozagawaxn--f" +
	"hbeiarnxn--finny-yuaxn--fiq228c5hsouthwestfalenxn--fiq64basilica" +
	"taniavocatanzaroweddingjerstadotsuruokamakurazakisofukushimarnar" +
	"dalillesandefjordiscoveryggeelvinckarlsoyokotebizenakaniikawatan" +
	"agurasnesoddenmarkets3-ap-southeast-1kappleangaviikadenaamesjevu" +
	"emielnoboribetsucks3-ap-northeast-1xn--fiqs8sowaxn--fiqz9spreadb" +
	"ettingxn--fjord-lraxn--fjq720axn--fl-ziaxn--flor-jraxn--flw351ex" +
	"n--fpcrj9c3dxn--frde-grandrapidspydebergxn--frna-woaraisaijosoyr" +
	"ovigorlicexn--frya-hraxn--fzc2c9e2chuvashiaxn--fzys8d69uvgmailxn" +
	"--g2xx48circlegallocuscountryestateofdelawarecreationxn--gckr3f0" +
	"ferrarittogokasells-for-lesscrapper-sitexn--gecrj9circuscultured" +
	"umbrellahppiacenzakopanerairforcechirealtorlandxn--ggaviika-8ya4" +
	"7hakonexn--gildeskl-g0axn--givuotna-8yandexn--3pxu8kotohiradomai" +
	"nsureisenxn--gjvik-wuaxn--gk3at1exn--gls-elacaixaxn--gmq050is-ve" +
	"ry-nicexn--gmqw5axn--h-2fairwindsrlxn--h1aeghakubankmshinjournal" +
	"ismailillehammerfest-mon-blogueurovisionxn--h2brj9citadeliverybn" +
	"ikahokutogliattiresaskatchewanggouvicenzaxn--hbmer-xqaxn--hcesuo" +
	"lo-7ya35basketballfinanz-2xn--hery-iraxn--hgebostad-g3axn--hmmrf" +
	"easta-s4acctrverranzanxn--hnefoss-q1axn--hobl-iraxn--holtlen-hxa" +
	"xn--hpmir-xqaxn--hxt814exn--hyanger-q1axn--hylandet-54axn--i1b6b" +
	"1a6a2exn--imr513nxn--indery-fyaotsurgutsiracusaitokyotangovtrysi" +
	"lkoshunantokashikizunokunimilanoxn--io0a7is-very-sweetrentino-al" +
	"to-adigexn--j1aeferreroticampobassociatescrappingujolsterxn--j1a" +
	"mhakuis-a-nurseoullensvanguardxn--j6w193gxn--jlq61u9w7batochigif" +
	"tsalvadordalibabaikaliszczytnordlandrangedalindesnesalzburgladel" +
	"oittenrightathomeftpaccessamegawavoues3-sa-east-1xn--jlster-byar" +
	"oslavlaanderenxn--jrpeland-54axn--jvr189misakis-into-cartoonshir" +
	"atakahagivingxn--k7yn95exn--karmy-yuaxn--kbrq7oxn--kcrx77d1x4axn" +
	"--kfjord-iuaxn--klbu-woaxn--klt787dxn--kltp7dxn--kltx9axn--klty5" +
	"xn--42c2d9axn--koluokta-7ya57hakusandiegoodyearthagakhanamigawax" +
	"n--kprw13dxn--kpry57dxn--kpu716fetsundxn--kput3is-with-thebandoo" +
	"mdnsaliascolipicenord-odalxn--krager-gyasakaiminatoyakokamisatoh" +
	"obby-sitexasdaburyatiaarpharmaciensirdalxn--kranghke-b0axn--krds" +
	"herad-m8axn--krehamn-dxaxn--krjohka-hwab49jetztrentino-altoadige" +
	"xn--ksnes-uuaxn--kvfjord-nxaxn--kvitsy-fyasugisleofmandalxn--kvn" +
	"angen-k0axn--l-1faitheguardianquanconagawakuyabukicks-assediciti" +
	"cateringebudejjuedischesapeakebayernurembergriwataraidyndns-work" +
	"shoppdalowiczest-le-patrondheimperiaxn--l1accentureklamborghinii" +
	"zaxn--laheadju-7yasuokaratexn--langevg-jxaxn--lcvr32dxn--ldingen" +
	"-q1axn--leagaviika-52batsfjordrivelandrobaknoluoktainaikawachina" +
	"ganoharamcoalaheadjudaicaaarborteaches-yogasawaracingroks-theatr" +
	"eemersongdalenviknakanojohanamakinoharaxastronomydstvedestrandgc" +
	"ahcesuolocalhistoryazannefrankfurtargets-itargi234xn--lesund-hua" +
	"xn--lgbbat1ad8jevnakerxn--lgrd-poacoachampionshiphopenair-traffi" +
	"c-controlleyxn--lhppi-xqaxn--linds-pramericanartulansolutionsola" +
	"rssonxn--lns-qlanxessrtrentinosued-tirolxn--loabt-0qaxn--lrdal-s" +
	"raxn--lrenskog-54axn--lt-liacivilaviationxn--lten-granexn--lury-" +
	"iraxn--mely-iraxn--merker-kuaxn--mgb2ddesrvdonskosherbrookegawax" +
	"n--mgb9awbfgulenxn--mgba3a3ejtunesomaxn--mgba3a4f16axn--mgba3a4f" +
	"ranamizuholdingsmileirfjordxn--mgba7c0bbn0axn--mgbaakc7dvfidelit" +
	"yxn--mgbaam7a8haldenxn--mgbab2bdxn--mgbai9a5eva00bauhausposts-an" +
	"d-telecommunicationsnasadoes-itveronagasukemrxn--mgbai9azgqp6jew" +
	"elryxn--mgbayh7gpaduaxn--mgbb9fbpobanazawaxn--mgbbh1a71exn--mgbc" +
	"0a9azcgxn--mgbca7dzdoxn--mgberp4a5d4a87gxn--mgberp4a5d4arxn--mgb" +
	"i4ecexposedxn--mgbpl2fhvalerxn--mgbqly7c0a67fbcivilisationxn--mg" +
	"bqly7cvafredrikstadtvstoragexn--mgbt3dhdxn--mgbtf8flekkefjordxn-" +
	"-mgbtx2bbcarrierxn--mgbx4cd0abbvieeexn--mix082fidonnakamuratakah" +
	"amannortonsbergunmarriottoyonezawaxn--mix891fieldxn--mjndalen-64" +
	"axn--mk0axindustriesteamfamberkeleyxn--mk1bu44civilizationxn--mk" +
	"ru45issmarterthanyouxn--mlatvuopmi-s4axn--mli-tlapyatigorskozaki" +
	"s-an-engineeringxn--mlselv-iuaxn--moreke-juaxn--mori-qsakuhokkai" +
	"dontexisteingeekpnxn--mosjen-eyatominamiawajikiwchiryukyuragifue" +
	"fukihaborokunohealthcareersarufutsunomiyawakasaikaitakoelniyodog" +
	"awaxn--mot-tlaquilancasterxn--mre-og-romsdal-qqbbtatarstanflatan" +
	"gerxn--msy-ula0halsaintlouis-a-anarchistoireggioemiliaromagnakat" +
	"ombetsumidatlantichernivtsiciliaxn--mtta-vrjjat-k7afamilycompany" +
	"civilwarmanagementjxjaworznoxn--muost-0qaxn--mxtq1misasaguris-in" +
	"to-gamessinashikitchenxn--ngbc5azdxn--ngbe9e0axn--ngbrxn--45brj9" +
	"choyodobashichikashukujitawaraxn--nit225kppspiegelxn--nmesjevuem" +
	"ie-tcbajddarchaeologyxn--nnx388axn--nodessakuragawaxn--nqv7fs00e" +
	"maxn--nry-yla5gxn--ntso0iqx3axn--ntsq17gxn--nttery-byaeservegame" +
	"-serverdalxn--nvuotna-hwaxn--nyqy26axn--o1achattanooganorilsklep" +
	"pharmacyslingxn--o3cw4hammarfeastafricamagichernovtsykkylvenetoe" +
	"iheijis-a-doctorayxn--od0algxn--od0aq3bbvacationswatch-and-clock" +
	"erxn--ogbpf8flesbergxn--oppegrd-ixaxn--ostery-fyatsukaratsuginam" +
	"ikatagamihoboleslawieclaimsassaris-a-financialadvisor-aurdaluroy" +
	"xn--osyro-wuaxn--p1acfdxn--p1aixn--pbt977clickchristiansburgrpal" +
	"ermomasvuotnakatsugawaxn--pgbs0dhlxn--porsgu-sta26figuerestauran" +
	"toyonoxn--pssu33lxn--pssy2uxn--q9jyb4clinicatholicasinorfolkebib" +
	"lefrakkestadyndns-wikindlegnicamerakershus-east-1xn--qcka1pmcdon" +
	"aldstordalxn--qqqt11misawaxn--qxamusementurystykarasjoksnesomnar" +
	"itakurashikis-not-certifiedogawarabikomaezakirunoshiroomuraxn--r" +
	"ady-iraxn--rdal-poaxn--rde-ularvikrasnodarxn--rdy-0nabarixn--ren" +
	"nesy-v1axn--rhkkervju-01aflakstadaokagakibichuoxn--rholt-mragowo" +
	"odsidexn--rhqv96gxn--rht27zxn--rht3dxn--rht61exn--risa-5narusawa" +
	"xn--risr-iraxn--rland-uuaxn--rlingen-mxaxn--rmskog-byatsushiroxn" +
	"--rny31hamurakamigoriginshinjukumanoxn--rovu88bentleyukuhashimoj" +
	"iitatebayashijonawatextileitungsenfshostrodawaraxn--rros-granvin" +
	"dafjordxn--rskog-uuaxn--rst-0narutokorozawaxn--rsta-francaisehar" +
	"axn--ryken-vuaxn--ryrvik-byawaraxn--s-1fareastcoastaldefencexn--" +
	"s9brj9cliniquenoharaxn--sandnessjen-ogbizhevskrasnoyarskommunexn" +
	"--sandy-yuaxn--seral-lraxn--ses554gxn--sgne-gratangenxn--skierv-" +
	"utazaskvolloabathsbclintonoshoesatxn--0trq7p7nnxn--skjervy-v1axn" +
	"--skjk-soaxn--sknit-yqaxn--sknland-fxaxn--slat-5narviikananporov" +
	"noxn--slt-elabourxn--smla-hraxn--smna-gratis-a-bulls-fanxn--snas" +
	"e-nraxn--sndre-land-0cbremangerxn--snes-poaxn--snsa-roaxn--sr-au" +
	"rdal-l8axn--sr-fron-q1axn--sr-odal-q1axn--sr-varanger-ggbeppubol" +
	"ognagatorockartuzyurihonjournalistjordalshalsenhsamnangerxn--srf" +
	"old-byawatahamaxn--srreisa-q1axn--srum-grazxn--stfold-9xaxn--stj" +
	"rdal-s1axn--stjrdalshalsen-sqberndunloppacificartierxn--stre-tot" +
	"en-zcbstorenburgxn--t60b56axn--tckweatherchannelxn--tiq49xqyjewi" +
	"shartgalleryxn--tjme-hraxn--tn0agrinetbankzxn--tnsberg-q1axn--to" +
	"r131oxn--trany-yuaxn--trgstad-r1axn--trna-woaxn--troms-zuaxn--ty" +
	"svr-vraxn--uc0atversicherungxn--uc0ay4axn--uist22hangoutsystemsc" +
	"loudcontrolapparmaxn--uisz3gxn--unjrga-rtaobaokinawashirosatobam" +
	"agazinemurorangeologyxn--unup4yxn--uuwu58axn--vads-jraxn--vard-j" +
	"raxn--vegrshei-c0axn--vermgensberater-ctbeskidynaliascoli-piceno" +
	"rd-frontierxn--vermgensberatung-pwbestbuyshousesamsclubindalinka" +
	"shiharaxn--vestvgy-ixa6oxn--vg-yiabcgxn--vgan-qoaxn--vgsy-qoa0jf" +
	"komitamamuraxn--vgu402clothingruexn--vhquvestfoldxn--vler-qoaxn-" +
	"-vre-eiker-k8axn--vrggt-xqadxn--vry-yla5gxn--vuq861betainaboxfor" +
	"deatnuorogersvpalanaklodzkodairaxn--w4r85el8fhu5dnraxn--w4rs40lx" +
	"n--wcvs22dxn--wgbh1cloudfrontdoorxn--wgbl6axn--xhq521bielawallon" +
	"ieruchomoscienceandindustrynikiiyamanobeauxartsandcraftsamsungla" +
	"ssassinationalheritagematsubarakawagoepostfoldnavyatkakudamatsue" +
	"psonyoursidegreevje-og-hornnesandvikcoromantovalle-d-aostatoilin" +
	"zainfinitinfoggiaxn--xkc2al3hye2axn--xkc2dl3a5ee0hannanmokuizumo" +
	"dernxn--y9a3aquariumisconfusedxn--yer-znarvikredstonexn--yfro4i6" +
	"7oxn--ygarden-p1axn--ygbi2ammxn--45q11christmasakikugawatchesase" +
	"boknowsitallukowhoswhokksundynv6xn--ystre-slidre-ujbiellaakesvue" +
	"mieleccexn--zbx025dxn--zf0ao64axn--zf0avxn--4gbriminingxn--zfr16" +
	"4bieszczadygeyachimataipeigersundunsagamiharaxperiaxz"

// nodes is the list of nodes. Each node is represented as a uint32, which
// encodes the node's children, wildcard bit and node type (as an index into
// the children array), ICANN bit and text.
//
// In the //-comment after each node's data, the nodes indexes of the children
// are formatted as (n0x1234-n0x1256), with * denoting the wildcard bit. The
// nodeType is printed as + for normal, ! for exception, and o for parent-only
// nodes that have children but don't match a domain label in their own right.
// An I denotes an ICANN domain.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 9 bits] children index
//	[ 1 bits] ICANN bit
//	[15 bits] text index
//	[ 6 bits] text length
var nodes = [...]uint32{
	0x00355603, // n0x0000 c0x0000 (---------------)  + I aaa
	0x0034d544, // n0x0001 c0x0000 (---------------)  + I aarp
	0x0026b886, // n0x0002 c0x0000 (---------------)  + I abarth
	0x00230743, // n0x0003 c0x0000 (---------------)  + I abb
	0x00230746, // n0x0004 c0x0000 (---------------)  + I abbott
	0x00365706, // n0x0005 c0x0000 (---------------)  + I abbvie
	0x00399843, // n0x0006 c0x0000 (---------------)  + I abc
	0x0031f144, // n0x0007 c0x0000 (---------------)  + I able
	0x002ee207, // n0x0008 c0x0000 (---------------)  + I abogado
	0x0026b4c8, // n0x0009 c0x0000 (---------------)  + I abudhabi
	0x01a01542, // n0x000a c0x0006 (n0x0609-n0x060f)  + I ac
	0x0030aec7, // n0x000b c0x0000 (---------------)  + I academy
	0x00352a89, // n0x000c c0x0000 (---------------)  + I accenture
	0x002d9b0a, // n0x000d c0x0000 (---------------)  + I accountant
	0x002d9b0b, // n0x000e c0x0000 (---------------)  + I accountants
	0x00232d83, // n0x000f c0x0000 (---------------)  + I aco
	0x0028a206, // n0x0010 c0x0000 (---------------)  + I active
	0x0023b505, // n0x0011 c0x0000 (---------------)  + I actor
	0x01e00342, // n0x0012 c0x0007 (n0x060f-n0x0610)  + I ad
	0x00212f84, // n0x0013 c0x0000 (---------------)  + I adac
	0x0026ba03, // n0x0014 c0x0000 (---------------)  + I ads
	0x002a1985, // n0x0015 c0x0000 (---------------)  + I adult
	0x022035c2, // n0x0016 c0x0008 (n0x0610-n0x0618)  + I ae
	0x0024a403, // n0x0017 c0x0000 (---------------)  + I aeg
	0x026389c4, // n0x0018 c0x0009 (n0x0618-n0x066f)  + I aero
	0x0025e585, // n0x0019 c0x0000 (---------------)  + I aetna
	0x02a04a42, // n0x001a c0x000a (n0x066f-n0x0674)  + I af
	0x0036ec8e, // n0x001b c0x0000 (---------------)  + I afamilycompany
	0x00252703, // n0x001c c0x0000 (---------------)  + I afl
	0x00375846, // n0x001d c0x0000 (---------------)  + I africa
	0x0037584b, // n0x001e c0x0000 (---------------)  + I africamagic
	0x02e01002, // n0x001f c0x000b (n0x0674-n0x0679)  + I ag
	0x0034ac47, // n0x0020 c0x0000 (---------------)  + I agakhan
	0x0023df86, // n0x0021 c0x0000 (---------------)  + I agency
	0x032016c2, // n0x0022 c0x000c (n0x0679-n0x067d)  + I ai
	0x00214d03, // n0x0023 c0x0000 (---------------)  + I aig
	0x00214d04, // n0x0024 c0x0000 (---------------)  + I aigo
	0x0022b886, // n0x0025 c0x0000 (---------------)  + I airbus
	0x00338648, // n0x0026 c0x0000 (---------------)  + I airforce
	0x00286586, // n0x0027 c0x0000 (---------------)  + I airtel
	0x00227644, // n0x0028 c0x0000 (---------------)  + I akdn
	0x036001c2, // n0x0029 c0x000d (n0x067d-n0x0684)  + I al
	0x00328e49, // n0x002a c0x0000 (---------------)  + I alfaromeo
	0x00345287, // n0x002b c0x0000 (---------------)  + I alibaba
	0x002bc006, // n0x002c c0x0000 (---------------)  + I alipay
	0x0033e3c9, // n0x002d c0x0000 (---------------)  + I allfinanz
	0x0020f148, // n0x002e c0x0000 (---------------)  + I allstate
	0x00213584, // n0x002f c0x0000 (---------------)  + I ally
	0x0021dd86, // n0x0030 c0x0000 (---------------)  + I alsace
	0x0020be86, // n0x0031 c0x0000 (---------------)  + I alstom
	0x03a01882, // n0x0032 c0x000e (n0x0684-n0x0685)  + I am
	0x0024728f, // n0x0033 c0x0000 (---------------)  + I americanexpress
	0x00208d8e, // n0x0034 c0x0000 (---------------)  + I americanfamily
	0x002052c4, // n0x0035 c0x0000 (---------------)  + I amex
	0x00367585, // n0x0036 c0x0000 (---------------)  + I amfam
	0x00230645, // n0x0037 c0x0000 (---------------)  + I amica
	0x002c8449, // n0x0038 c0x0000 (---------------)  + I amsterdam
	0x00243f09, // n0x0039 c0x0000 (---------------)  + I analytics
	0x0031a8c7, // n0x003a c0x0000 (---------------)  + I android
	0x00350706, // n0x003b c0x0000 (---------------)  + I anquan
	0x00256b43, // n0x003c c0x0000 (---------------)  + I anz
	0x03e029c2, // n0x003d c0x000f (n0x0685-n0x068b)  + I ao
	0x00275643, // n0x003e c0x0000 (---------------)  + I aol
	0x0022ce0a, // n0x003f c0x0000 (---------------)  + I apartments
	0x002092c3, // n0x0040 c0x0000 (---------------)  + I app
	0x00331985, // n0x0041 c0x0000 (---------------)  + I apple
	0x002003c2, // n0x0042 c0x0000 (---------------)  + I aq
	0x00285a49, // n0x0043 c0x0000 (---------------)  + I aquarelle
	0x04200a42, // n0x0044 c0x0010 (n0x068b-n0x0694)  + I ar
	0x00202044, // n0x0045 c0x0000 (---------------)  + I arab
	0x00355146, // n0x0046 c0x0000 (---------------)  + I aramco
	0x002fb805, // n0x0047 c0x0000 (---------------)  + I archi
	0x00348744, // n0x0048 c0x0000 (---------------)  + I army
	0x04a29dc4, // n0x0049 c0x0012 (n0x0695-n0x069b)  + I arpa
	0x0023a6c4, // n0x004a c0x0000 (---------------)  + I arte
	0x04e01d42, // n0x004b c0x0013 (n0x069b-n0x069c)  + I as
	0x0034d284, // n0x004c c0x0000 (---------------)  + I asda
	0x00322ec4, // n0x004d c0x0000 (---------------)  + I asia
	0x003437ca, // n0x004e c0x0000 (---------------)  + I associates
	0x05200102, // n0x004f c0x0014 (n0x069c-n0x06a3)  + I at
	0x00248f47, // n0x0050 c0x0000 (---------------)  + I athleta
	0x0031fec8, // n0x0051 c0x0000 (---------------)  + I attorney
	0x05a04f82, // n0x0052 c0x0016 (n0x06a4-n0x06b6)  + I au
	0x00319e07, // n0x0053 c0x0000 (---------------)  + I auction
	0x00233104, // n0x0054 c0x0000 (---------------)  + I audi
	0x002b7d87, // n0x0055 c0x0000 (---------------)  + I audible
	0x00233105, // n0x0056 c0x0000 (---------------)  + I audio
	0x0035fd47, // n0x0057 c0x0000 (---------------)  + I auspost
	0x0031a686, // n0x0058 c0x0000 (---------------)  + I author
	0x00265104, // n0x0059 c0x0000 (---------------)  + I auto
	0x00324dc5, // n0x005a c0x0000 (---------------)  + I autos
	0x002dc007, // n0x005b c0x0000 (---------------)  + I avianca
	0x06a01082, // n0x005c c0x001a (n0x06c4-n0x06c5)  + I aw
	0x002f6583, // n0x005d c0x0000 (---------------)  + I aws
	0x00220402, // n0x005e c0x0000 (---------------)  + I ax
	0x00356983, // n0x005f c0x0000 (---------------)  + I axa
	0x06e05f42, // n0x0060 c0x001b (n0x06c5-n0x06d1)  + I az
	0x0021be05, // n0x0061 c0x0000 (---------------)  + I azure
	0x07202002, // n0x0062 c0x001c (n0x06d1-n0x06dc)  + I ba
	0x002ce1c4, // n0x0063 c0x0000 (---------------)  + I baby
	0x0027c805, // n0x0064 c0x0000 (---------------)  + I baidu
	0x00205207, // n0x0065 c0x0000 (---------------)  + I banamex
	0x002e97ce, // n0x0066 c0x0000 (---------------)  + I bananarepublic
	0x00207cc4, // n0x0067 c0x0000 (---------------)  + I band
	0x00203704, // n0x0068 c0x0000 (---------------)  + I bank
	0x00202003, // n0x0069 c0x0000 (---------------)  + I bar
	0x002dd889, // n0x006a c0x0000 (---------------)  + I barcelona
	0x002c12cb, // n0x006b c0x0000 (---------------)  + I barclaycard
	0x002dc608, // n0x006c c0x0000 (---------------)  + I barclays
	0x00306d88, // n0x006d c0x0000 (---------------)  + I barefoot
	0x0030e948, // n0x006e c0x0000 (---------------)  + I bargains
	0x0022f9c8, // n0x006f c0x0000 (---------------)  + I baseball
	0x0033e20a, // n0x0070 c0x0000 (---------------)  + I basketball
	0x0035fc47, // n0x0071 c0x0000 (---------------)  + I bauhaus
	0x00351786, // n0x0072 c0x0000 (---------------)  + I bayern
	0x07630782, // n0x0073 c0x001d (n0x06dc-n0x06e6)  + I bb
	0x003651c3, // n0x0074 c0x0000 (---------------)  + I bbc
	0x0036cbc3, // n0x0075 c0x0000 (---------------)  + I bbt
	0x00376984, // n0x0076 c0x0000 (---------------)  + I bbva
	0x00399883, // n0x0077 c0x0000 (---------------)  + I bcg
	0x00239b43, // n0x0078 c0x0000 (---------------)  + I bcn
	0x017129c2, // n0x0079 c0x0005 (---------------)* o I bd
	0x07a03302, // n0x007a c0x001e (n0x06e6-n0x06e8)  + I be
	0x0022b505, // n0x007b c0x0000 (---------------)  + I beats
	0x0024f5c6, // n0x007c c0x0000 (---------------)  + I beauty
	0x002ccb84, // n0x007d c0x0000 (---------------)  + I beer
	0x00383b87, // n0x007e c0x0000 (---------------)  + I bentley
	0x0022e6c6, // n0x007f c0x0000 (---------------)  + I berlin
	0x002291c4, // n0x0080 c0x0000 (---------------)  + I best
	0x00398887, // n0x0081 c0x0000 (---------------)  + I bestbuy
	0x00208c03, // n0x0082 c0x0000 (---------------)  + I bet
	0x07f5d242, // n0x0083 c0x001f (n0x06e8-n0x06e9)  + I bf
	0x082ee482, // n0x0084 c0x0020 (n0x06e9-n0x070e)  + I bg
	0x08615602, // n0x0085 c0x0021 (n0x070e-n0x0713)  + I bh
	0x00215606, // n0x0086 c0x0000 (---------------)  + I bharti
	0x08a00002, // n0x0087 c0x0022 (n0x0713-n0x0718)  + I bi
	0x0037bf45, // n0x0088 c0x0000 (---------------)  + I bible
	0x00313f03, // n0x0089 c0x0000 (---------------)  + I bid
	0x00202544, // n0x008a c0x0000 (---------------)  + I bike
	0x002dc444, // n0x008b c0x0000 (---------------)  + I bing
	0x002dc445, // n0x008c c0x0000 (---------------)  + I bingo
	0x00203a03, // n0x008d c0x0000 (---------------)  + I bio
	0x08f30b83, // n0x008e c0x0023 (n0x0718-n0x0720)  + I biz
	0x09206502, // n0x008f c0x0024 (n0x0720-n0x0724)  + I bj
	0x00288ec5, // n0x0090 c0x0000 (---------------)  + I black
	0x00288ecb, // n0x0091 c0x0000 (---------------)  + I blackfriday
	0x00258fc6, // n0x0092 c0x0000 (---------------)  + I blanco
	0x0020c8cb, // n0x0093 c0x0000 (---------------)  + I blockbuster
	0x002a4004, // n0x0094 c0x0000 (---------------)  + I blog
	0x0020d009, // n0x0095 c0x0000 (---------------)  + I bloomberg
	0x0020e104, // n0x0096 c0x0000 (---------------)  + I blue
	0x0960e742, // n0x0097 c0x0025 (n0x0724-n0x0729)  + I bm
	0x0020f6c3, // n0x0098 c0x0000 (---------------)  + I bms
	0x0020fc43, // n0x0099 c0x0000 (---------------)  + I bmw
	0x016104c2, // n0x009a c0x0005 (---------------)* o I bn
	0x002477c3, // n0x009b c0x0000 (---------------)  + I bnl
	0x002104ca, // n0x009c c0x0000 (---------------)  + I bnpparibas
	0x09a0e402, // n0x009d c0x0026 (n0x0729-n0x0732)  + I bo
	0x0030b145, // n0x009e c0x0000 (---------------)  + I boats
	0x0020e40a, // n0x009f c0x0000 (---------------)  + I boehringer
	0x00290b84, // n0x00a0 c0x0000 (---------------)  + I bofa
	0x00210ac3, // n0x00a1 c0x0000 (---------------)  + I bom
	0x00210f84, // n0x00a2 c0x0000 (---------------)  + I bond
	0x00215403, // n0x00a3 c0x0000 (---------------)  + I boo
	0x00215404, // n0x00a4 c0x0000 (---------------)  + I book
	0x00215407, // n0x00a5 c0x0000 (---------------)  + I booking
	0x00215e85, // n0x00a6 c0x0000 (---------------)  + I boots
	0x002173c5, // n0x00a7 c0x0000 (---------------)  + I bosch
	0x00217986, // n0x00a8 c0x0000 (---------------)  + I bostik
	0x00217cc6, // n0x00a9 c0x0000 (---------------)  + I boston
	0x00218e83, // n0x00aa c0x0000 (---------------)  + I bot
	0x0021b7c8, // n0x00ab c0x0000 (---------------)  + I boutique
	0x0021bb83, // n0x00ac c0x0000 (---------------)  + I box
	0x09e1c402, // n0x00ad c0x0027 (n0x0732-n0x0778)  + I br
	0x0021c408, // n0x00ae c0x0000 (---------------)  + I bradesco
	0x00221b8b, // n0x00af c0x0000 (---------------)  + I bridgestone
	0x00220008, // n0x00b0 c0x0000 (---------------)  + I broadway
	0x00220c46, // n0x00b1 c0x0000 (---------------)  + I broker
	0x00222007, // n0x00b2 c0x0000 (---------------)  + I brother
	0x00225e88, // n0x00b3 c0x0000 (---------------)  + I brussels
	0x0a637542, // n0x00b4 c0x0029 (n0x0779-n0x077e)  + I bs
	0x0aa1fd02, // n0x00b5 c0x002a (n0x077e-n0x0783)  + I bt
	0x0020a008, // n0x00b6 c0x0000 (---------------)  + I budapest
	0x002e5b47, // n0x00b7 c0x0000 (---------------)  + I bugatti
	0x002410c5, // n0x00b8 c0x0000 (---------------)  + I build
	0x002410c8, // n0x00b9 c0x0000 (---------------)  + I builders
	0x0022c188, // n0x00ba c0x0000 (---------------)  + I business
	0x003004c3, // n0x00bb c0x0000 (---------------)  + I buy
	0x0022dec4, // n0x00bc c0x0000 (---------------)  + I buzz
	0x00365782, // n0x00bd c0x0000 (---------------)  + I bv
	0x0ae2fe42, // n0x00be c0x002b (n0x0783-n0x0785)  + I bw
	0x0b20f982, // n0x00bf c0x002c (n0x0785-n0x0789)  + I by
	0x0ba30bc2, // n0x00c0 c0x002e (n0x078a-n0x0790)  + I bz
	0x00230bc3, // n0x00c1 c0x0000 (---------------)  + I bzh
	0x0be00302, // n0x00c2 c0x002f (n0x0790-n0x07a1)  + I ca
	0x00230703, // n0x00c3 c0x0000 (---------------)  + I cab
	0x0030ee44, // n0x00c4 c0x0000 (---------------)  + I cafe
	0x00213543, // n0x00c5 c0x0000 (---------------)  + I cal
	0x00213544, // n0x00c6 c0x0000 (---------------)  + I call
	0x002ed9cb, // n0x00c7 c0x0000 (---------------)  + I calvinklein
	0x0037c746, // n0x00c8 c0x0000 (---------------)  + I camera
	0x00241ac4, // n0x00c9 c0x0000 (---------------)  + I camp
	0x0029f88e, // n0x00ca c0x0000 (---------------)  + I cancerresearch
	0x00265485, // n0x00cb c0x0000 (---------------)  + I canon
	0x002dc148, // n0x00cc c0x0000 (---------------)  + I capetown
	0x002f0b87, // n0x00cd c0x0000 (---------------)  + I capital
	0x002f0b8a, // n0x00ce c0x0000 (---------------)  + I capitalone
	0x0020af43, // n0x00cf c0x0000 (---------------)  + I car
	0x00236a47, // n0x00d0 c0x0000 (---------------)  + I caravan
	0x002c1485, // n0x00d1 c0x0000 (---------------)  + I cards
	0x0036b504, // n0x00d2 c0x0000 (---------------)  + I care
	0x0036b506, // n0x00d3 c0x0000 (---------------)  + I career
	0x0036b507, // n0x00d4 c0x0000 (---------------)  + I careers
	0x00305f84, // n0x00d5 c0x0000 (---------------)  + I cars
	0x00390b47, // n0x00d6 c0x0000 (---------------)  + I cartier
	0x00214604, // n0x00d7 c0x0000 (---------------)  + I casa
	0x002188c4, // n0x00d8 c0x0000 (---------------)  + I case
	0x002188c6, // n0x00d9 c0x0000 (---------------)  + I caseih
	0x002c99c4, // n0x00da c0x0000 (---------------)  + I cash
	0x0037bc46, // n0x00db c0x0000 (---------------)  + I casino
	0x0020df43, // n0x00dc c0x0000 (---------------)  + I cat
	0x00351008, // n0x00dd c0x0000 (---------------)  + I catering
	0x0037ba88, // n0x00de c0x0000 (---------------)  + I catholic
	0x0024b283, // n0x00df c0x0000 (---------------)  + I cba
	0x00247783, // n0x00e0 c0x0000 (---------------)  + I cbn
	0x0038c544, // n0x00e1 c0x0000 (---------------)  + I cbre
	0x00391103, // n0x00e2 c0x0000 (---------------)  + I cbs
	0x0c22e182, // n0x00e3 c0x0030 (n0x07a1-n0x07a5)  + I cc
	0x0c63e2c2, // n0x00e4 c0x0031 (n0x07a5-n0x07a6)  + I cd
	0x00206483, // n0x00e5 c0x0000 (---------------)  + I ceb
	0x00204486, // n0x00e6 c0x0000 (---------------)  + I center
	0x002c87c3, // n0x00e7 c0x0000 (---------------)  + I ceo
	0x002e61c4, // n0x00e8 c0x0000 (---------------)  + I cern
	0x0ca14202, // n0x00e9 c0x0032 (n0x07a6-n0x07a7)  + I cf
	0x00214203, // n0x00ea c0x0000 (---------------)  + I cfa
	0x00379503, // n0x00eb c0x0000 (---------------)  + I cfd
	0x0021a302, // n0x00ec c0x0000 (---------------)  + I cg
	0x0ce01582, // n0x00ed c0x0033 (n0x07a7-n0x07a8)  + I ch
	0x002ba9c6, // n0x00ee c0x0000 (---------------)  + I chanel
	0x0023c407, // n0x00ef c0x0000 (---------------)  + I channel
	0x00329845, // n0x00f0 c0x0000 (---------------)  + I chase
	0x0022ac44, // n0x00f1 c0x0000 (---------------)  + I chat
	0x00284305, // n0x00f2 c0x0000 (---------------)  + I cheap
	0x00201587, // n0x00f3 c0x0000 (---------------)  + I chintai
	0x002aee85, // n0x00f4 c0x0000 (---------------)  + I chloe
	0x003a3989, // n0x00f5 c0x0000 (---------------)  + I christmas
	0x003024c6, // n0x00f6 c0x0000 (---------------)  + I chrome
	0x00303188, // n0x00f7 c0x0000 (---------------)  + I chrysler
	0x00329746, // n0x00f8 c0x0000 (---------------)  + I church
	0x0d200682, // n0x00f9 c0x0034 (n0x07a8-n0x07b7)  + I ci
	0x0023fe08, // n0x00fa c0x0000 (---------------)  + I cipriani
	0x00336206, // n0x00fb c0x0000 (---------------)  + I circle
	0x00200685, // n0x00fc c0x0000 (---------------)  + I cisco
	0x0033cc87, // n0x00fd c0x0000 (---------------)  + I citadel
	0x00350f04, // n0x00fe c0x0000 (---------------)  + I citi
	0x00350f05, // n0x00ff c0x0000 (---------------)  + I citic
	0x00286744, // n0x0100 c0x0000 (---------------)  + I city
	0x00286748, // n0x0101 c0x0000 (---------------)  + I cityeats
	0x0d60b482, // n0x0102 c0x0035 (n0x07b7-n0x07b8)* o I ck
	0x0da09182, // n0x0103 c0x0036 (n0x07b8-n0x07bd)  + I cl
	0x00378546, // n0x0104 c0x0000 (---------------)  + I claims
	0x002242c8, // n0x0105 c0x0000 (---------------)  + I cleaning
	0x00379a45, // n0x0106 c0x0000 (---------------)  + I click
	0x0037b946, // n0x0107 c0x0000 (---------------)  + I clinic
	0x00387188, // n0x0108 c0x0000 (---------------)  + I clinique
	0x0039a588, // n0x0109 c0x0000 (---------------)  + I clothing
	0x00209185, // n0x010a c0x0000 (---------------)  + I cloud
	0x00238ac4, // n0x010b c0x0000 (---------------)  + I club
	0x00238ac7, // n0x010c c0x0000 (---------------)  + I clubmed
	0x0de5d142, // n0x010d c0x0037 (n0x07bd-n0x07c1)  + I cm
	0x0e21ba42, // n0x010e c0x0038 (n0x07c1-n0x07ee)  + I cn
	0x0fa00742, // n0x010f c0x003e (n0x07f3-n0x0800)  + I co
	0x00358885, // n0x0110 c0x0000 (---------------)  + I coach
	0x0029bd05, // n0x0111 c0x0000 (---------------)  + I codes
	0x0020b246, // n0x0112 c0x0000 (---------------)  + I coffee
	0x0022e1c7, // n0x0113 c0x0000 (---------------)  + I college
	0x00231a87, // n0x0114 c0x0000 (---------------)  + I cologne
	0x10233503, // n0x0115 c0x0040 (n0x0801-n0x08d7)  + I com
	0x002a6b87, // n0x0116 c0x0000 (---------------)  + I comcast
	0x002da788, // n0x0117 c0x0000 (---------------)  + I commbank
	0x00233509, // n0x0118 c0x0000 (---------------)  + I community
	0x0036ee47, // n0x0119 c0x0000 (---------------)  + I company
	0x00234a07, // n0x011a c0x0000 (---------------)  + I compare
	0x00235488, // n0x011b c0x0000 (---------------)  + I computer
	0x00235c86, // n0x011c c0x0000 (---------------)  + I comsec
	0x00236246, // n0x011d c0x0000 (---------------)  + I condos
	0x00236f4c, // n0x011e c0x0000 (---------------)  + I construction
	0x00237d0a, // n0x011f c0x0000 (---------------)  + I consulting
	0x00239e07, // n0x0120 c0x0000 (---------------)  + I contact
	0x0023b3cb, // n0x0121 c0x0000 (---------------)  + I contractors
	0x0023c247, // n0x0122 c0x0000 (---------------)  + I cooking
	0x0023c24e, // n0x0123 c0x0000 (---------------)  + I cookingchannel
	0x0023d384, // n0x0124 c0x0000 (---------------)  + I cool
	0x0023d684, // n0x0125 c0x0000 (---------------)  + I coop
	0x0023ea07, // n0x0126 c0x0000 (---------------)  + I corsica
	0x00336587, // n0x0127 c0x0000 (---------------)  + I country
	0x002423c6, // n0x0128 c0x0000 (---------------)  + I coupon
	0x002423c7, // n0x0129 c0x0000 (---------------)  + I coupons
	0x00242fc7, // n0x012a c0x0000 (---------------)  + I courses
	0x126049c2, // n0x012b c0x0049 (n0x08fe-n0x0905)  + I cr
	0x002447c6, // n0x012c c0x0000 (---------------)  + I credit
	0x002447ca, // n0x012d c0x0000 (---------------)  + I creditcard
	0x00244a4b, // n0x012e c0x0000 (---------------)  + I creditunion
	0x00245b47, // n0x012f c0x0000 (---------------)  + I cricket
	0x00246505, // n0x0130 c0x0000 (---------------)  + I crown
	0x00246643, // n0x0131 c0x0000 (---------------)  + I crs
	0x00246b46, // n0x0132 c0x0000 (---------------)  + I cruise
	0x00246b47, // n0x0133 c0x0000 (---------------)  + I cruises
	0x002440c3, // n0x0134 c0x0000 (---------------)  + I csc
	0x12a09d82, // n0x0135 c0x004a (n0x0905-n0x090b)  + I cu
	0x00246f0a, // n0x0136 c0x0000 (---------------)  + I cuisinella
	0x12f53bc2, // n0x0137 c0x004b (n0x090b-n0x090c)  + I cv
	0x132c95c2, // n0x0138 c0x004c (n0x090c-n0x0910)  + I cw
	0x136482c2, // n0x0139 c0x004d (n0x0910-n0x0912)  + I cx
	0x13a3e082, // n0x013a c0x004e (n0x0912-n0x091f)  o I cy
	0x0024a985, // n0x013b c0x0000 (---------------)  + I cymru
	0x0024b084, // n0x013c c0x0000 (---------------)  + I cyou
	0x14229ec2, // n0x013d c0x0050 (n0x0920-n0x0922)  + I cz
	0x0034d305, // n0x013e c0x0000 (---------------)  + I dabur
	0x002a1943, // n0x013f c0x0000 (---------------)  + I dad
	0x00223d45, // n0x0140 c0x0000 (---------------)  + I dance
	0x0020c7c4, // n0x0141 c0x0000 (---------------)  + I date
	0x0020e206, // n0x0142 c0x0000 (---------------)  + I dating
	0x00292c46, // n0x0143 c0x0000 (---------------)  + I datsun
	0x00265983, // n0x0144 c0x0000 (---------------)  + I day
	0x0023f244, // n0x0145 c0x0000 (---------------)  + I dclk
	0x0025f303, // n0x0146 c0x0000 (---------------)  + I dds
	0x14604d82, // n0x0147 c0x0051 (n0x0922-n0x092a)  + I de
	0x00204d84, // n0x0148 c0x0000 (---------------)  + I deal
	0x00239046, // n0x0149 c0x0000 (---------------)  + I dealer
	0x00204d85, // n0x014a c0x0000 (---------------)  + I deals
	0x003a0286, // n0x014b c0x0000 (---------------)  + I degree
	0x0033cd88, // n0x014c c0x0000 (---------------)  + I delivery
	0x0025a384, // n0x014d c0x0000 (---------------)  + I dell
	0x00345f48, // n0x014e c0x0000 (---------------)  + I deloitte
	0x00311f45, // n0x014f c0x0000 (---------------)  + I delta
	0x002265c8, // n0x0150 c0x0000 (---------------)  + I democrat
	0x002abe06, // n0x0151 c0x0000 (---------------)  + I dental
	0x002b2407, // n0x0152 c0x0000 (---------------)  + I dentist
	0x0022dcc4, // n0x0153 c0x0000 (---------------)  + I desi
	0x0022dcc6, // n0x0154 c0x0000 (---------------)  + I design
	0x002329c3, // n0x0155 c0x0000 (---------------)  + I dev
	0x0037a7c3, // n0x0156 c0x0000 (---------------)  + I dhl
	0x002c42c8, // n0x0157 c0x0000 (---------------)  + I diamonds
	0x0030ce84, // n0x0158 c0x0000 (---------------)  + I diet
	0x00308ec7, // n0x0159 c0x0000 (---------------)  + I digital
	0x0024d786, // n0x015a c0x0000 (---------------)  + I direct
	0x0024d789, // n0x015b c0x0000 (---------------)  + I directory
	0x0031aa48, // n0x015c c0x0000 (---------------)  + I discount
	0x00330408, // n0x015d c0x0000 (---------------)  + I discover
	0x00229304, // n0x015e c0x0000 (---------------)  + I dish
	0x00320843, // n0x015f c0x0000 (---------------)  + I diy
	0x00266a02, // n0x0160 c0x0000 (---------------)  + I dj
	0x14a494c2, // n0x0161 c0x0052 (n0x092a-n0x092b)  + I dk
	0x14e0fa82, // n0x0162 c0x0053 (n0x092b-n0x0930)  + I dm
	0x00321fc3, // n0x0163 c0x0000 (---------------)  + I dnp
	0x15213282, // n0x0164 c0x0054 (n0x0930-n0x093a)  + I do
	0x002ee344, // n0x0165 c0x0000 (---------------)  + I docs
	0x00213285, // n0x0166 c0x0000 (---------------)  + I dodge
	0x002459c3, // n0x0167 c0x0000 (---------------)  + I dog
	0x00236044, // n0x0168 c0x0000 (---------------)  + I doha
	0x00339ec7, // n0x0169 c0x0000 (---------------)  + I domains
	0x0032f743, // n0x016a c0x0000 (---------------)  + I dot
	0x00269fc8, // n0x016b c0x0000 (---------------)  + I download
	0x00354745, // n0x016c c0x0000 (---------------)  + I drive
	0x00356c44, // n0x016d c0x0000 (---------------)  + I dstv
	0x00364483, // n0x016e c0x0000 (---------------)  + I dtv
	0x0027c785, // n0x016f c0x0000 (---------------)  + I dubai
	0x0027c8c4, // n0x0170 c0x0000 (---------------)  + I duck
	0x00390846, // n0x0171 c0x0000 (---------------)  + I dunlop
	0x003a6804, // n0x0172 c0x0000 (---------------)  + I duns
	0x002008c6, // n0x0173 c0x0000 (---------------)  + I dupont
	0x00205146, // n0x0174 c0x0000 (---------------)  + I durban
	0x00317284, // n0x0175 c0x0000 (---------------)  + I dvag
	0x00212b03, // n0x0176 c0x0000 (---------------)  + I dwg
	0x15607a82, // n0x0177 c0x0055 (n0x093a-n0x0942)  + I dz
	0x0034ab05, // n0x0178 c0x0000 (---------------)  + I earth
	0x0022b543, // n0x0179 c0x0000 (---------------)  + I eat
	0x15a09b02, // n0x017a c0x0056 (n0x0942-n0x094e)  + I ec
	0x002b94c5, // n0x017b c0x0000 (---------------)  + I edeka
	0x0023a783, // n0x017c c0x0000 (---------------)  + I edu
	0x0023a789, // n0x017d c0x0000 (---------------)  + I education
	0x15e0b342, // n0x017e c0x0057 (n0x094e-n0x0958)  + I ee
	0x16608442, // n0x017f c0x0059 (n0x0959-n0x0962)  + I eg
	0x002ce585, // n0x0180 c0x0000 (---------------)  + I email
	0x002c4646, // n0x0181 c0x0000 (---------------)  + I emerck
	0x00356047, // n0x0182 c0x0000 (---------------)  + I emerson
	0x002cb4c6, // n0x0183 c0x0000 (---------------)  + I energy
	0x00369148, // n0x0184 c0x0000 (---------------)  + I engineer
	0x0036914b, // n0x0185 c0x0000 (---------------)  + I engineering
	0x002044cb, // n0x0186 c0x0000 (---------------)  + I enterprises
	0x0039f945, // n0x0187 c0x0000 (---------------)  + I epost
	0x0039ffc5, // n0x0188 c0x0000 (---------------)  + I epson
	0x002c2709, // n0x0189 c0x0000 (---------------)  + I equipment
	0x01603682, // n0x018a c0x0005 (---------------)* o I er
	0x00317448, // n0x018b c0x0000 (---------------)  + I ericsson
	0x0020cb04, // n0x018c c0x0000 (---------------)  + I erni
	0x16e00482, // n0x018d c0x005b (n0x0963-n0x0968)  + I es
	0x0027a303, // n0x018e c0x0000 (---------------)  + I esq
	0x002c2486, // n0x018f c0x0000 (---------------)  + I estate
	0x0028d2c8, // n0x0190 c0x0000 (---------------)  + I esurance
	0x176053c2, // n0x0191 c0x005d (n0x0969-n0x0971)  + I et
	0x002234c8, // n0x0192 c0x0000 (---------------)  + I etisalat
	0x00204b82, // n0x0193 c0x0000 (---------------)  + I eu
	0x0033c78a, // n0x0194 c0x0000 (---------------)  + I eurovision
	0x00228883, // n0x0195 c0x0000 (---------------)  + I eus
	0x00232a06, // n0x0196 c0x0000 (---------------)  + I events
	0x00203608, // n0x0197 c0x0000 (---------------)  + I everbank
	0x00239488, // n0x0198 c0x0000 (---------------)  + I exchange
	0x0031ee06, // n0x0199 c0x0000 (---------------)  + I expert
	0x00363107, // n0x019a c0x0000 (---------------)  + I exposed
	0x00247487, // n0x019b c0x0000 (---------------)  + I express
	0x0020ba0a, // n0x019c c0x0000 (---------------)  + I extraspace
	0x00290c04, // n0x019d c0x0000 (---------------)  + I fage
	0x00214244, // n0x019e c0x0000 (---------------)  + I fail
	0x0033b609, // n0x019f c0x0000 (---------------)  + I fairwinds
	0x00350405, // n0x01a0 c0x0000 (---------------)  + I faith
	0x00208f86, // n0x01a1 c0x0000 (---------------)  + I family
	0x00211d03, // n0x01a2 c0x0000 (---------------)  + I fan
	0x002e0ec4, // n0x01a3 c0x0000 (---------------)  + I fans
	0x00271d04, // n0x01a4 c0x0000 (---------------)  + I farm
	0x002ece87, // n0x01a5 c0x0000 (---------------)  + I farmers
	0x0022fec7, // n0x01a6 c0x0000 (---------------)  + I fashion
	0x0024c204, // n0x01a7 c0x0000 (---------------)  + I fast
	0x00211505, // n0x01a8 c0x0000 (---------------)  + I fedex
	0x0020b308, // n0x01a9 c0x0000 (---------------)  + I feedback
	0x00337007, // n0x01aa c0x0000 (---------------)  + I ferrari
	0x00343407, // n0x01ab c0x0000 (---------------)  + I ferrero
	0x17a07502, // n0x01ac c0x005e (n0x0971-n0x0974)  + I fi
	0x00294744, // n0x01ad c0x0000 (---------------)  + I fiat
	0x0035ee48, // n0x01ae c0x0000 (---------------)  + I fidelity
	0x00365b84, // n0x01af c0x0000 (---------------)  + I fido
	0x0024b784, // n0x01b0 c0x0000 (---------------)  + I film
	0x0024bb85, // n0x01b1 c0x0000 (---------------)  + I final
	0x0024bcc7, // n0x01b2 c0x0000 (---------------)  + I finance
	0x00207509, // n0x01b3 c0x0000 (---------------)  + I financial
	0x0024c6c4, // n0x01b4 c0x0000 (---------------)  + I fire
	0x0024d4c9, // n0x01b5 c0x0000 (---------------)  + I firestone
	0x0024d9c8, // n0x01b6 c0x0000 (---------------)  + I firmdale
	0x0024e044, // n0x01b7 c0x0000 (---------------)  + I fish
	0x0024e047, // n0x01b8 c0x0000 (---------------)  + I fishing
	0x0024f083, // n0x01b9 c0x0000 (---------------)  + I fit
	0x0024f807, // n0x01ba c0x0000 (---------------)  + I fitness
	0x01615b02, // n0x01bb c0x0005 (---------------)* o I fj
	0x01799fc2, // n0x01bc c0x0005 (---------------)* o I fk
	0x00250686, // n0x01bd c0x0000 (---------------)  + I flickr
	0x00251287, // n0x01be c0x0000 (---------------)  + I flights
	0x00251c04, // n0x01bf c0x0000 (---------------)  + I flir
	0x00252b07, // n0x01c0 c0x0000 (---------------)  + I florist
	0x002539c7, // n0x01c1 c0x0000 (---------------)  + I flowers
	0x00253f08, // n0x01c2 c0x0000 (---------------)  + I flsmidth
	0x002549c3, // n0x01c3 c0x0000 (---------------)  + I fly
	0x00242902, // n0x01c4 c0x0000 (---------------)  + I fm
	0x002558c2, // n0x01c5 c0x0000 (---------------)  + I fo
	0x00255a83, // n0x01c6 c0x0000 (---------------)  + I foo
	0x00255a8b, // n0x01c7 c0x0000 (---------------)  + I foodnetwork
	0x00306e88, // n0x01c8 c0x0000 (---------------)  + I football
	0x0039bf44, // n0x01c9 c0x0000 (---------------)  + I ford
	0x00257585, // n0x01ca c0x0000 (---------------)  + I forex
	0x00259787, // n0x01cb c0x0000 (---------------)  + I forsale
	0x0025b085, // n0x01cc c0x0000 (---------------)  + I forum
	0x002b9f4a, // n0x01cd c0x0000 (---------------)  + I foundation
	0x0025c143, // n0x01ce c0x0000 (---------------)  + I fox
	0x17e00582, // n0x01cf c0x005f (n0x0974-n0x098c)  + I fr
	0x002e7d04, // n0x01d0 c0x0000 (---------------)  + I free
	0x0025f7c9, // n0x01d1 c0x0000 (---------------)  + I fresenius
	0x00263603, // n0x01d2 c0x0000 (---------------)  + I frl
	0x002636c7, // n0x01d3 c0x0000 (---------------)  + I frogans
	0x0039d609, // n0x01d4 c0x0000 (---------------)  + I frontdoor
	0x003980c8, // n0x01d5 c0x0000 (---------------)  + I frontier
	0x00204a83, // n0x01d6 c0x0000 (---------------)  + I ftr
	0x0027b8c7, // n0x01d7 c0x0000 (---------------)  + I fujitsu
	0x0027bdc9, // n0x01d8 c0x0000 (---------------)  + I fujixerox
	0x002312c3, // n0x01d9 c0x0000 (---------------)  + I fun
	0x00283c84, // n0x01da c0x0000 (---------------)  + I fund
	0x00285349, // n0x01db c0x0000 (---------------)  + I furniture
	0x00287806, // n0x01dc c0x0000 (---------------)  + I futbol
	0x002888c3, // n0x01dd c0x0000 (---------------)  + I fyi
	0x00201042, // n0x01de c0x0000 (---------------)  + I ga
	0x0021dd43, // n0x01df c0x0000 (---------------)  + I gal
	0x00392147, // n0x01e0 c0x0000 (---------------)  + I gallery
	0x00336385, // n0x01e1 c0x0000 (---------------)  + I gallo
	0x002dd686, // n0x01e2 c0x0000 (---------------)  + I gallup
	0x00297cc4, // n0x01e3 c0x0000 (---------------)  + I game
	0x003700c5, // n0x01e4 c0x0000 (---------------)  + I games
	0x0022cdc3, // n0x01e5 c0x0000 (---------------)  + I gap
	0x002190c6, // n0x01e6 c0x0000 (---------------)  + I garden
	0x0020d202, // n0x01e7 c0x0000 (---------------)  + I gb
	0x00387944, // n0x01e8 c0x0000 (---------------)  + I gbiz
	0x00222d42, // n0x01e9 c0x0000 (---------------)  + I gd
	0x002fb203, // n0x01ea c0x0000 (---------------)  + I gdn
	0x182026c2, // n0x01eb c0x0060 (n0x098c-n0x0993)  + I ge
	0x002534c3, // n0x01ec c0x0000 (---------------)  + I gea
	0x00218144, // n0x01ed c0x0000 (---------------)  + I gent
	0x00218147, // n0x01ee c0x0000 (---------------)  + I genting
	0x00324b46, // n0x01ef c0x0000 (---------------)  + I george
	0x00269a82, // n0x01f0 c0x0000 (---------------)  + I gf
	0x18654282, // n0x01f1 c0x0061 (n0x0993-n0x0996)  + I gg
	0x00330644, // n0x01f2 c0x0000 (---------------)  + I ggee
	0x18a41602, // n0x01f3 c0x0062 (n0x0996-n0x099b)  + I gh
	0x18e134c2, // n0x01f4 c0x0063 (n0x099b-n0x09a1)  + I gi
	0x00344f44, // n0x01f5 c0x0000 (---------------)  + I gift
	0x00344f45, // n0x01f6 c0x0000 (---------------)  + I gifts
	0x00269485, // n0x01f7 c0x0000 (---------------)  + I gives
	0x003481c6, // n0x01f8 c0x0000 (---------------)  + I giving
	0x1920ce42, // n0x01f9 c0x0064 (n0x09a1-n0x09a6)  + I gl
	0x00345e85, // n0x01fa c0x0000 (---------------)  + I glade
	0x0039ef45, // n0x01fb c0x0000 (---------------)  + I glass
	0x00285d83, // n0x01fc c0x0000 (---------------)  + I gle
	0x0020d846, // n0x01fd c0x0000 (---------------)  + I global
	0x0020e345, // n0x01fe c0x0000 (---------------)  + I globo
	0x00215582, // n0x01ff c0x0000 (---------------)  + I gm
	0x00335e45, // n0x0200 c0x0000 (---------------)  + I gmail
	0x00215584, // n0x0201 c0x0000 (---------------)  + I gmbh
	0x002182c3, // n0x0202 c0x0000 (---------------)  + I gmo
	0x0021bac3, // n0x0203 c0x0000 (---------------)  + I gmx
	0x19608342, // n0x0204 c0x0065 (n0x09a6-n0x09ac)  + I gn
	0x002e9bc7, // n0x0205 c0x0000 (---------------)  + I godaddy
	0x0024dbc4, // n0x0206 c0x0000 (---------------)  + I gold
	0x0024dbc9, // n0x0207 c0x0000 (---------------)  + I goldpoint
	0x0024e1c4, // n0x0208 c0x0000 (---------------)  + I golf
	0x00299dc3, // n0x0209 c0x0000 (---------------)  + I goo
	0x0031bac9, // n0x020a c0x0000 (---------------)  + I goodhands
	0x0034a9c8, // n0x020b c0x0000 (---------------)  + I goodyear
	0x0029bb84, // n0x020c c0x0000 (---------------)  + I goog
	0x0029bb86, // n0x020d c0x0000 (---------------)  + I google
	0x002a36c3, // n0x020e c0x0000 (---------------)  + I gop
	0x00211ec3, // n0x020f c0x0000 (---------------)  + I got
	0x002dc504, // n0x0210 c0x0000 (---------------)  + I gotv
	0x0026cc83, // n0x0211 c0x0000 (---------------)  + I gov
	0x19adad02, // n0x0212 c0x0066 (n0x09ac-n0x09b2)  + I gp
	0x003010c2, // n0x0213 c0x0000 (---------------)  + I gq
	0x19e00c82, // n0x0214 c0x0067 (n0x09b2-n0x09b8)  + I gr
	0x00315908, // n0x0215 c0x0000 (---------------)  + I grainger
	0x003216c8, // n0x0216 c0x0000 (---------------)  + I graphics
	0x0038b986, // n0x0217 c0x0000 (---------------)  + I gratis
	0x002503c5, // n0x0218 c0x0000 (---------------)  + I green
	0x0022fd05, // n0x0219 c0x0000 (---------------)  + I gripe
	0x0020ab45, // n0x021a c0x0000 (---------------)  + I group
	0x0023a242, // n0x021b c0x0000 (---------------)  + I gs
	0x1a23f142, // n0x021c c0x0068 (n0x09b8-n0x09bf)  + I gt
	0x0160dd42, // n0x021d c0x0005 (---------------)* o I gu
	0x00350588, // n0x021e c0x0000 (---------------)  + I guardian
	0x0023fd45, // n0x021f c0x0000 (---------------)  + I gucci
	0x002e05c4, // n0x0220 c0x0000 (---------------)  + I guge
	0x00232905, // n0x0221 c0x0000 (---------------)  + I guide
	0x0023cc87, // n0x0222 c0x0000 (---------------)  + I guitars
	0x002594c4, // n0x0223 c0x0000 (---------------)  + I guru
	0x002167c2, // n0x0224 c0x0000 (---------------)  + I gw
	0x1a602302, // n0x0225 c0x0069 (n0x09bf-n0x09c5)  + I gy
	0x0030c744, // n0x0226 c0x0000 (---------------)  + I hair
	0x0020ccc7, // n0x0227 c0x0000 (---------------)  + I hamburg
	0x00394c47, // n0x0228 c0x0000 (---------------)  + I hangout
	0x0035fd04, // n0x0229 c0x0000 (---------------)  + I haus
	0x00290b43, // n0x022a c0x0000 (---------------)  + I hbo
	0x0024b1c4, // n0x022b c0x0000 (---------------)  + I hdfc
	0x0024b1c8, // n0x022c c0x0000 (---------------)  + I hdfcbank
	0x0036b386, // n0x022d c0x0000 (---------------)  + I health
	0x0036b38a, // n0x022e c0x0000 (---------------)  + I healthcare
	0x002073c4, // n0x022f c0x0000 (---------------)  + I help
	0x0020ebc8, // n0x0230 c0x0000 (---------------)  + I helsinki
	0x00254184, // n0x0231 c0x0000 (---------------)  + I here
	0x00222106, // n0x0232 c0x0000 (---------------)  + I hermes
	0x00292304, // n0x0233 c0x0000 (---------------)  + I hgtv
	0x00358b86, // n0x0234 c0x0000 (---------------)  + I hiphop
	0x002ebcc9, // n0x0235 c0x0000 (---------------)  + I hisamitsu
	0x002a27c7, // n0x0236 c0x0000 (---------------)  + I hitachi
	0x0027d3c3, // n0x0237 c0x0000 (---------------)  + I hiv
	0x1aa0a882, // n0x0238 c0x006a (n0x09c5-n0x09dd)  + I hk
	0x0026da43, // n0x0239 c0x0000 (---------------)  + I hkt
	0x0020e942, // n0x023a c0x0000 (---------------)  + I hm
	0x1ae1ab42, // n0x023b c0x006b (n0x09dd-n0x09e3)  + I hn
	0x002df846, // n0x023c c0x0000 (---------------)  + I hockey
	0x0035e208, // n0x023d c0x0000 (---------------)  + I holdings
	0x002a5007, // n0x023e c0x0000 (---------------)  + I holiday
	0x00274049, // n0x023f c0x0000 (---------------)  + I homedepot
	0x00299cc9, // n0x0240 c0x0000 (---------------)  + I homegoods
	0x002a60c5, // n0x0241 c0x0000 (---------------)  + I homes
	0x002a60c9, // n0x0242 c0x0000 (---------------)  + I homesense
	0x002a7985, // n0x0243 c0x0000 (---------------)  + I honda
	0x002a8409, // n0x0244 c0x0000 (---------------)  + I honeywell
	0x002a91c5, // n0x0245 c0x0000 (---------------)  + I horse
	0x00297e04, // n0x0246 c0x0000 (---------------)  + I host
	0x00297e07, // n0x0247 c0x0000 (---------------)  + I hosting
	0x00234dc3, // n0x0248 c0x0000 (---------------)  + I hot
	0x002a98c7, // n0x0249 c0x0000 (---------------)  + I hoteles
	0x002a9fc7, // n0x024a c0x0000 (---------------)  + I hotmail
	0x002a2105, // n0x024b c0x0000 (---------------)  + I house
	0x002a1343, // n0x024c c0x0000 (---------------)  + I how
	0x1b20e4c2, // n0x024d c0x006c (n0x09e3-n0x09e8)  + I hr
	0x00389404, // n0x024e c0x0000 (---------------)  + I hsbc
	0x1b62a682, // n0x024f c0x006d (n0x09e8-n0x09f9)  + I ht
	0x0025d0c3, // n0x0250 c0x0000 (---------------)  + I htc
	0x1ba195c2, // n0x0251 c0x006e (n0x09f9-n0x0a19)  + I hu
	0x002f94c6, // n0x0252 c0x0000 (---------------)  + I hughes
	0x0031fe45, // n0x0253 c0x0000 (---------------)  + I hyatt
	0x002ac1c7, // n0x0254 c0x0000 (---------------)  + I hyundai
	0x00321f03, // n0x0255 c0x0000 (---------------)  + I ibm
	0x00239ac4, // n0x0256 c0x0000 (---------------)  + I icbc
	0x00206903, // n0x0257 c0x0000 (---------------)  + I ice
	0x00209d43, // n0x0258 c0x0000 (---------------)  + I icu
	0x1be0c782, // n0x0259 c0x006f (n0x0a19-n0x0a24)  + I id
	0x1c600042, // n0x025a c0x0071 (n0x0a25-n0x0a27)  + I ie
	0x00365804, // n0x025b c0x0000 (---------------)  + I ieee
	0x002428c3, // n0x025c c0x0000 (---------------)  + I ifm
	0x00322905, // n0x025d c0x0000 (---------------)  + I iinet
	0x00322745, // n0x025e c0x0000 (---------------)  + I ikano
	0x1ca02902, // n0x025f c0x0072 (n0x0a27-n0x0a2f)  + I il
	0x1d205c42, // n0x0260 c0x0074 (n0x0a30-n0x0a37)  + I im
	0x00256dc6, // n0x0261 c0x0000 (---------------)  + I imamat
	0x0025ee44, // n0x0262 c0x0000 (---------------)  + I imdb
	0x00207084, // n0x0263 c0x0000 (---------------)  + I immo
	0x0020708a, // n0x0264 c0x0000 (---------------)  + I immobilien
	0x1da013c2, // n0x0265 c0x0076 (n0x0a39-n0x0a46)  + I in
	0x0036728a, // n0x0266 c0x0000 (---------------)  + I industries
	0x003a1088, // n0x0267 c0x0000 (---------------)  + I infiniti
	0x1dfa1244, // n0x0268 c0x0077 (n0x0a46-n0x0a50)  + I info
	0x0020e2c3, // n0x0269 c0x0000 (---------------)  + I ing
	0x0020ecc3, // n0x026a c0x0000 (---------------)  + I ink
	0x0030ea89, // n0x026b c0x0000 (---------------)  + I institute
	0x0023e7c9, // n0x026c c0x0000 (---------------)  + I insurance
	0x00339fc6, // n0x026d c0x0000 (---------------)  + I insure
	0x1e201603, // n0x026e c0x0078 (n0x0a50-n0x0a51)  + I int
	0x0024dd45, // n0x026f c0x0000 (---------------)  + I intel
	0x0031940d, // n0x0270 c0x0000 (---------------)  + I international
	0x002f8946, // n0x0271 c0x0000 (---------------)  + I intuit
	0x00203d0b, // n0x0272 c0x0000 (---------------)  + I investments
	0x1e600ac2, // n0x0273 c0x0079 (n0x0a51-n0x0a57)  + I io
	0x0026bb88, // n0x0274 c0x0000 (---------------)  + I ipiranga
	0x1ea00dc2, // n0x0275 c0x007a (n0x0a57-n0x0a5d)  + I iq
	0x1ee04302, // n0x0276 c0x007b (n0x0a5d-n0x0a66)  + I ir
	0x002a5605, // n0x0277 c0x0000 (---------------)  + I irish
	0x1f2006c2, // n0x0278 c0x007c (n0x0a66-n0x0a6e)  + I is
	0x0025b307, // n0x0279 c0x0000 (---------------)  + I iselect
	0x0033c007, // n0x027a c0x0000 (---------------)  + I ismaili
	0x00215003, // n0x027b c0x0000 (---------------)  + I ist
	0x00215008, // n0x027c c0x0000 (---------------)  + I istanbul
	0x1f601e42, // n0x027d c0x007d (n0x0a6e-n0x0bdf)  + I it
	0x002804c4, // n0x027e c0x0000 (---------------)  + I itau
	0x00360743, // n0x027f c0x0000 (---------------)  + I itv
	0x00323145, // n0x0280 c0x0000 (---------------)  + I iveco
	0x0036ab83, // n0x0281 c0x0000 (---------------)  + I iwc
	0x0031f906, // n0x0282 c0x0000 (---------------)  + I jaguar
	0x00323d44, // n0x0283 c0x0000 (---------------)  + I java
	0x00247743, // n0x0284 c0x0000 (---------------)  + I jcb
	0x0026e183, // n0x0285 c0x0000 (---------------)  + I jcp
	0x1fa06f02, // n0x0286 c0x007e (n0x0bdf-n0x0be2)  + I je
	0x003299c4, // n0x0287 c0x0000 (---------------)  + I jeep
	0x0034ea85, // n0x0288 c0x0000 (---------------)  + I jetzt
	0x00360f47, // n0x0289 c0x0000 (---------------)  + I jewelry
	0x00278d43, // n0x028a c0x0000 (---------------)  + I jio
	0x002ac643, // n0x028b c0x0000 (---------------)  + I jlc
	0x002ad103, // n0x028c c0x0000 (---------------)  + I jll
	0x016308c2, // n0x028d c0x0005 (---------------)* o I jm
	0x002ad1c3, // n0x028e c0x0000 (---------------)  + I jmp
	0x002ad803, // n0x028f c0x0000 (---------------)  + I jnj
	0x1fe04042, // n0x0290 c0x007f (n0x0be2-n0x0bea)  + I jo
	0x002ddc44, // n0x0291 c0x0000 (---------------)  + I jobs
	0x0027cb06, // n0x0292 c0x0000 (---------------)  + I joburg
	0x00204043, // n0x0293 c0x0000 (---------------)  + I jot
	0x002adb83, // n0x0294 c0x0000 (---------------)  + I joy
	0x202ae3c2, // n0x0295 c0x0080 (n0x0bea-n0x0c59)  + I jp
	0x002ae3c8, // n0x0296 c0x0000 (---------------)  + I jpmorgan
	0x002aefc4, // n0x0297 c0x0000 (---------------)  + I jprs
	0x002d7906, // n0x0298 c0x0000 (---------------)  + I juegos
	0x002af287, // n0x0299 c0x0000 (---------------)  + I juniper
	0x00227e46, // n0x029a c0x0000 (---------------)  + I kaufen
	0x00238144, // n0x029b c0x0000 (---------------)  + I kddi
	0x2de025c2, // n0x029c c0x00b7 (n0x12ed-n0x12ee)* o I ke
	0x00234c8b, // n0x029d c0x0000 (---------------)  + I kerryhotels
	0x002e2c0e, // n0x029e c0x0000 (---------------)  + I kerrylogistics
	0x00220d0f, // n0x029f c0x0000 (---------------)  + I kerryproperties
	0x0023f303, // n0x02a0 c0x0000 (---------------)  + I kfh
	0x2e6b5502, // n0x02a1 c0x00b9 (n0x12ef-n0x12f5)  + I kg
	0x0161acc2, // n0x02a2 c0x0005 (---------------)* o I kh
	0x2ea01e02, // n0x02a3 c0x00ba (n0x12f5-n0x12fc)  + I ki
	0x00226f83, // n0x02a4 c0x0000 (---------------)  + I kia
	0x002303c3, // n0x02a5 c0x0000 (---------------)  + I kim
	0x002e7706, // n0x02a6 c0x0000 (---------------)  + I kinder
	0x0037c506, // n0x02a7 c0x0000 (---------------)  + I kindle
	0x003703c7, // n0x02a8 c0x0000 (---------------)  + I kitchen
	0x002eed84, // n0x02a9 c0x0000 (---------------)  + I kiwi
	0x2ee316c2, // n0x02aa c0x00bb (n0x12fc-n0x130d)  + I km
	0x2f269c82, // n0x02ab c0x00bc (n0x130d-n0x1311)  + I kn
	0x0036bd45, // n0x02ac c0x0000 (---------------)  + I koeln
	0x002aa707, // n0x02ad c0x0000 (---------------)  + I komatsu
	0x0035cbc6, // n0x02ae c0x0000 (---------------)  + I kosher
	0x2f60d782, // n0x02af c0x00bd (n0x1311-n0x1317)  + I kp
	0x0020d784, // n0x02b0 c0x0000 (---------------)  + I kpmg
	0x0036a3c3, // n0x02b1 c0x0000 (---------------)  + I kpn
	0x2fa06fc2, // n0x02b2 c0x00be (n0x1317-n0x1335)  + I kr
	0x0034df03, // n0x02b3 c0x0000 (---------------)  + I krd
	0x003a2b04, // n0x02b4 c0x0000 (---------------)  + I kred
	0x002b5449, // n0x02b5 c0x0000 (---------------)  + I kuokgroup
	0x016bd182, // n0x02b6 c0x0005 (---------------)* o I kw
	0x2fe36902, // n0x02b7 c0x00bf (n0x1335-n0x133a)  + I ky
	0x00269c06, // n0x02b8 c0x0000 (---------------)  + I kyknet
	0x002be0c5, // n0x02b9 c0x0000 (---------------)  + I kyoto
	0x30392a42, // n0x02ba c0x00c0 (n0x133a-n0x1340)  + I kz
	0x30600802, // n0x02bb c0x00c1 (n0x1340-n0x1349)  + I la
	0x0033aa87, // n0x02bc c0x0000 (---------------)  + I lacaixa
	0x00293449, // n0x02bd c0x0000 (---------------)  + I ladbrokes
	0x00352d0b, // n0x02be c0x0000 (---------------)  + I lamborghini
	0x00247245, // n0x02bf c0x0000 (---------------)  + I lamer
	0x0036c449, // n0x02c0 c0x0000 (---------------)  + I lancaster
	0x002c0706, // n0x02c1 c0x0000 (---------------)  + I lancia
	0x00259007, // n0x02c2 c0x0000 (---------------)  + I lancome
	0x00200804, // n0x02c3 c0x0000 (---------------)  + I land
	0x0025e089, // n0x02c4 c0x0000 (---------------)  + I landrover
	0x0035a387, // n0x02c5 c0x0000 (---------------)  + I lanxess
	0x00279f47, // n0x02c6 c0x0000 (---------------)  + I lasalle
	0x00223603, // n0x02c7 c0x0000 (---------------)  + I lat
	0x0025ef86, // n0x02c8 c0x0000 (---------------)  + I latino
	0x002cca47, // n0x02c9 c0x0000 (---------------)  + I latrobe
	0x00274483, // n0x02ca c0x0000 (---------------)  + I law
	0x00274486, // n0x02cb c0x0000 (---------------)  + I lawyer
	0x30a02942, // n0x02cc c0x00c2 (n0x1349-n0x134e)  + I lb
	0x30e3aa02, // n0x02cd c0x00c3 (n0x134e-n0x1354)  + I lc
	0x00226843, // n0x02ce c0x0000 (---------------)  + I lds
	0x0027a085, // n0x02cf c0x0000 (---------------)  + I lease
	0x0022c487, // n0x02d0 c0x0000 (---------------)  + I leclerc
	0x0037c006, // n0x02d1 c0x0000 (---------------)  + I lefrak
	0x00336305, // n0x02d2 c0x0000 (---------------)  + I legal
	0x0024db44, // n0x02d3 c0x0000 (---------------)  + I lego
	0x00241385, // n0x02d4 c0x0000 (---------------)  + I lexus
	0x002e65c4, // n0x02d5 c0x0000 (---------------)  + I lgbt
	0x31207202, // n0x02d6 c0x00c4 (n0x1354-n0x1355)  + I li
	0x00308447, // n0x02d7 c0x0000 (---------------)  + I liaison
	0x002bb904, // n0x02d8 c0x0000 (---------------)  + I lidl
	0x0023e6c4, // n0x02d9 c0x0000 (---------------)  + I life
	0x0023e6cd, // n0x02da c0x0000 (---------------)  + I lifeinsurance
	0x00253cc9, // n0x02db c0x0000 (---------------)  + I lifestyle
	0x00312248, // n0x02dc c0x0000 (---------------)  + I lighting
	0x00258c44, // n0x02dd c0x0000 (---------------)  + I like
	0x00249785, // n0x02de c0x0000 (---------------)  + I lilly
	0x0025d747, // n0x02df c0x0000 (---------------)  + I limited
	0x0025db44, // n0x02e0 c0x0000 (---------------)  + I limo
	0x0022e787, // n0x02e1 c0x0000 (---------------)  + I lincoln
	0x00345ac5, // n0x02e2 c0x0000 (---------------)  + I linde
	0x00398ec4, // n0x02e3 c0x0000 (---------------)  + I link
	0x002d3a85, // n0x02e4 c0x0000 (---------------)  + I lipsy
	0x002622c4, // n0x02e5 c0x0000 (---------------)  + I live
	0x002414c6, // n0x02e6 c0x0000 (---------------)  + I living
	0x0025da45, // n0x02e7 c0x0000 (---------------)  + I lixil
	0x3160d742, // n0x02e8 c0x00c5 (n0x1355-n0x1364)  + I lk
	0x00210b84, // n0x02e9 c0x0000 (---------------)  + I loan
	0x00210b85, // n0x02ea c0x0000 (---------------)  + I loans
	0x00376f06, // n0x02eb c0x0000 (---------------)  + I locker
	0x00336445, // n0x02ec c0x0000 (---------------)  + I locus
	0x002ccfc4, // n0x02ed c0x0000 (---------------)  + I loft
	0x002c21c3, // n0x02ee c0x0000 (---------------)  + I lol
	0x00321906, // n0x02ef c0x0000 (---------------)  + I london
	0x0021b685, // n0x02f0 c0x0000 (---------------)  + I lotte
	0x00222845, // n0x02f1 c0x0000 (---------------)  + I lotto
	0x00230204, // n0x02f2 c0x0000 (---------------)  + I love
	0x00207443, // n0x02f3 c0x0000 (---------------)  + I lpl
	0x0020744c, // n0x02f4 c0x0000 (---------------)  + I lplfinancial
	0x31a88142, // n0x02f5 c0x00c6 (n0x1364-n0x1369)  + I lr
	0x31e04e42, // n0x02f6 c0x00c7 (n0x1369-n0x136b)  + I ls
	0x32209e02, // n0x02f7 c0x00c8 (n0x136b-n0x136d)  + I lt
	0x00322cc3, // n0x02f8 c0x0000 (---------------)  + I ltd
	0x00322cc4, // n0x02f9 c0x0000 (---------------)  + I ltda
	0x32602f42, // n0x02fa c0x00c9 (n0x136d-n0x136e)  + I lu
	0x002fb348, // n0x02fb c0x0000 (---------------)  + I lundbeck
	0x002dd745, // n0x02fc c0x0000 (---------------)  + I lupin
	0x0023ca44, // n0x02fd c0x0000 (---------------)  + I luxe
	0x0023d206, // n0x02fe c0x0000 (---------------)  + I luxury
	0x32a05d02, // n0x02ff c0x00ca (n0x136e-n0x1377)  + I lv
	0x32e09082, // n0x0300 c0x00cb (n0x1377-n0x1380)  + I ly
	0x33200182, // n0x0301 c0x00cc (n0x1380-n0x1386)  + I ma
	0x00375105, // n0x0302 c0x0000 (---------------)  + I macys
	0x00317146, // n0x0303 c0x0000 (---------------)  + I madrid
	0x00271c44, // n0x0304 c0x0000 (---------------)  + I maif
	0x0022bdc6, // n0x0305 c0x0000 (---------------)  + I maison
	0x00248d06, // n0x0306 c0x0000 (---------------)  + I makeup
	0x002018c3, // n0x0307 c0x0000 (---------------)  + I man
	0x0036f20a, // n0x0308 c0x0000 (---------------)  + I management
	0x00242c05, // n0x0309 c0x0000 (---------------)  + I mango
	0x002f1386, // n0x030a c0x0000 (---------------)  + I market
	0x002f1389, // n0x030b c0x0000 (---------------)  + I marketing
	0x00331387, // n0x030c c0x0000 (---------------)  + I markets
	0x00366448, // n0x030d c0x0000 (---------------)  + I marriott
	0x0020f009, // n0x030e c0x0000 (---------------)  + I marshalls
	0x002be9c8, // n0x030f c0x0000 (---------------)  + I maserati
	0x0022f706, // n0x0310 c0x0000 (---------------)  + I mattel
	0x00209c03, // n0x0311 c0x0000 (---------------)  + I mba
	0x3362ac02, // n0x0312 c0x00cd (n0x1386-n0x1388)  + I mc
	0x0037cec3, // n0x0313 c0x0000 (---------------)  + I mcd
	0x0037cec9, // n0x0314 c0x0000 (---------------)  + I mcdonalds
	0x00327b88, // n0x0315 c0x0000 (---------------)  + I mckinsey
	0x33a4da82, // n0x0316 c0x00ce (n0x1388-n0x1389)  + I md
	0x33e03e82, // n0x0317 c0x00cf (n0x1389-n0x1396)  + I me
	0x00213ac3, // n0x0318 c0x0000 (---------------)  + I med
	0x003025c5, // n0x0319 c0x0000 (---------------)  + I media
	0x0026ad84, // n0x031a c0x0000 (---------------)  + I meet
	0x002e1809, // n0x031b c0x0000 (---------------)  + I melbourne
	0x002c4604, // n0x031c c0x0000 (---------------)  + I meme
	0x0026cf88, // n0x031d c0x0000 (---------------)  + I memorial
	0x00203e83, // n0x031e c0x0000 (---------------)  + I men
	0x002ede44, // n0x031f c0x0000 (---------------)  + I menu
	0x0022adc3, // n0x0320 c0x0000 (---------------)  + I meo
	0x0023e607, // n0x0321 c0x0000 (---------------)  + I metlife
	0x3420d802, // n0x0322 c0x00d0 (n0x1396-n0x139f)  + I mg
	0x0025aa42, // n0x0323 c0x0000 (---------------)  + I mh
	0x00231f45, // n0x0324 c0x0000 (---------------)  + I miami
	0x0026b149, // n0x0325 c0x0000 (---------------)  + I microsoft
	0x00209003, // n0x0326 c0x0000 (---------------)  + I mil
	0x0027d144, // n0x0327 c0x0000 (---------------)  + I mini
	0x003193c4, // n0x0328 c0x0000 (---------------)  + I mint
	0x00229ac3, // n0x0329 c0x0000 (---------------)  + I mit
	0x0027e0ca, // n0x032a c0x0000 (---------------)  + I mitsubishi
	0x34767142, // n0x032b c0x00d1 (n0x139f-n0x13a7)  + I mk
	0x34a10b42, // n0x032c c0x00d2 (n0x13a7-n0x13ae)  + I ml
	0x002c1243, // n0x032d c0x0000 (---------------)  + I mlb
	0x00369503, // n0x032e c0x0000 (---------------)  + I mls
	0x016070c2, // n0x032f c0x0005 (---------------)* o I mm
	0x00375603, // n0x0330 c0x0000 (---------------)  + I mma
	0x34e1fdc2, // n0x0331 c0x00d3 (n0x13ae-n0x13b2)  + I mn
	0x0021fdc4, // n0x0332 c0x0000 (---------------)  + I mnet
	0x35207102, // n0x0333 c0x00d4 (n0x13b2-n0x13b7)  + I mo
	0x35607104, // n0x0334 c0x00d5 (n0x13b7-n0x13b8)  + I mobi
	0x002e2606, // n0x0335 c0x0000 (---------------)  + I mobily
	0x0026c084, // n0x0336 c0x0000 (---------------)  + I moda
	0x002d7d03, // n0x0337 c0x0000 (---------------)  + I moe
	0x00282043, // n0x0338 c0x0000 (---------------)  + I moi
	0x002e3783, // n0x0339 c0x0000 (---------------)  + I mom
	0x00244dc6, // n0x033a c0x0000 (---------------)  + I monash
	0x002c6d85, // n0x033b c0x0000 (---------------)  + I money
	0x002c1e07, // n0x033c c0x0000 (---------------)  + I monster
	0x00258ec9, // n0x033d c0x0000 (---------------)  + I montblanc
	0x002c5285, // n0x033e c0x0000 (---------------)  + I mopar
	0x002c6cc6, // n0x033f c0x0000 (---------------)  + I mormon
	0x002c72c8, // n0x0340 c0x0000 (---------------)  + I mortgage
	0x002c74c6, // n0x0341 c0x0000 (---------------)  + I moscow
	0x00278644, // n0x0342 c0x0000 (---------------)  + I moto
	0x0029af0b, // n0x0343 c0x0000 (---------------)  + I motorcycles
	0x002c9083, // n0x0344 c0x0000 (---------------)  + I mov
	0x002c9085, // n0x0345 c0x0000 (---------------)  + I movie
	0x002c91c8, // n0x0346 c0x0000 (---------------)  + I movistar
	0x0022a482, // n0x0347 c0x0000 (---------------)  + I mp
	0x0033ad82, // n0x0348 c0x0000 (---------------)  + I mq
	0x35a4aa02, // n0x0349 c0x00d6 (n0x13b8-n0x13ba)  + I mr
	0x35e0f702, // n0x034a c0x00d7 (n0x13ba-n0x13bf)  + I ms
	0x0025d643, // n0x034b c0x0000 (---------------)  + I msd
	0x36204c02, // n0x034c c0x00d8 (n0x13bf-n0x13c3)  + I mt
	0x0026c8c3, // n0x034d c0x0000 (---------------)  + I mtn
	0x002c94c4, // n0x034e c0x0000 (---------------)  + I mtpc
	0x002c9d03, // n0x034f c0x0000 (---------------)  + I mtr
	0x36a03ac2, // n0x0350 c0x00da (n0x13c4-n0x13cb)  + I mu
	0x002cbb0b, // n0x0351 c0x0000 (---------------)  + I multichoice
	0x36ed0106, // n0x0352 c0x00db (n0x13cb-n0x15ef)  + I museum
	0x0023db46, // n0x0353 c0x0000 (---------------)  + I mutual
	0x002d0748, // n0x0354 c0x0000 (---------------)  + I mutuelle
	0x372b7382, // n0x0355 c0x00dc (n0x15ef-n0x15fd)  + I mv
	0x3760fc82, // n0x0356 c0x00dd (n0x15fd-n0x1608)  + I mw
	0x37a1bb02, // n0x0357 c0x00de (n0x1608-n0x160e)  + I mx
	0x37e26f02, // n0x0358 c0x00df (n0x160e-n0x1616)  + I my
	0x38214382, // n0x0359 c0x00e0 (n0x1616-n0x1617)* o I mz
	0x0021438b, // n0x035a c0x0000 (---------------)  + I mzansimagic
	0x38601402, // n0x035b c0x00e1 (n0x1617-n0x1628)  + I na
	0x00223703, // n0x035c c0x0000 (---------------)  + I nab
	0x002393c5, // n0x035d c0x0000 (---------------)  + I nadex
	0x0030f646, // n0x035e c0x0000 (---------------)  + I nagoya
	0x38a05284, // n0x035f c0x00e2 (n0x1628-n0x162a)  + I name
	0x0028cec7, // n0x0360 c0x0000 (---------------)  + I naspers
	0x00238e4a, // n0x0361 c0x0000 (---------------)  + I nationwide
	0x002ea486, // n0x0362 c0x0000 (---------------)  + I natura
	0x0039fb84, // n0x0363 c0x0000 (---------------)  + I navy
	0x0025d243, // n0x0364 c0x0000 (---------------)  + I nba
	0x39600642, // n0x0365 c0x00e5 (n0x162c-n0x162d)  + I nc
	0x00202c02, // n0x0366 c0x0000 (---------------)  + I ne
	0x00249b43, // n0x0367 c0x0000 (---------------)  + I nec
	0x39a1fe03, // n0x0368 c0x00e6 (n0x162d-n0x1663)  + I net
	0x003928c7, // n0x0369 c0x0000 (---------------)  + I netbank
	0x0025d947, // n0x036a c0x0000 (---------------)  + I netflix
	0x00255b87, // n0x036b c0x0000 (---------------)  + I network
	0x00228847, // n0x036c c0x0000 (---------------)  + I neustar
	0x00221dc3, // n0x036d c0x0000 (---------------)  + I new
	0x002f0d8a, // n0x036e c0x0000 (---------------)  + I newholland
	0x00221dc4, // n0x036f c0x0000 (---------------)  + I news
	0x0024d684, // n0x0370 c0x0000 (---------------)  + I next
	0x0024d68a, // n0x0371 c0x0000 (---------------)  + I nextdirect
	0x0026d605, // n0x0372 c0x0000 (---------------)  + I nexus
	0x3ae00542, // n0x0373 c0x00eb (n0x166b-n0x1675)  + I nf
	0x00251bc3, // n0x0374 c0x0000 (---------------)  + I nfl
	0x3b202802, // n0x0375 c0x00ec (n0x1675-n0x167f)  + I ng
	0x00202d03, // n0x0376 c0x0000 (---------------)  + I ngo
	0x0026da03, // n0x0377 c0x0000 (---------------)  + I nhk
	0x3ba03182, // n0x0378 c0x00ee (n0x1680-n0x168e)  o I ni
	0x002a6b04, // n0x0379 c0x0000 (---------------)  + I nico
	0x0021da84, // n0x037a c0x0000 (---------------)  + I nike
	0x00206b05, // n0x037b c0x0000 (---------------)  + I nikon
	0x002c8e05, // n0x037c c0x0000 (---------------)  + I ninja
	0x0022e906, // n0x037d c0x0000 (---------------)  + I nissan
	0x0022ec86, // n0x037e c0x0000 (---------------)  + I nissay
	0x3be47802, // n0x037f c0x00ef (n0x168e-n0x1691)  + I nl
	0x3c200c02, // n0x0380 c0x00f0 (n0x1691-n0x1967)  + I no
	0x00318785, // n0x0381 c0x0000 (---------------)  + I nokia
	0x0023d852, // n0x0382 c0x0000 (---------------)  + I northwesternmutual
	0x00366106, // n0x0383 c0x0000 (---------------)  + I norton
	0x00224d83, // n0x0384 c0x0000 (---------------)  + I now
	0x0029cec6, // n0x0385 c0x0000 (---------------)  + I nowruz
	0x00224d85, // n0x0386 c0x0000 (---------------)  + I nowtv
	0x01610502, // n0x0387 c0x0005 (---------------)* o I np
	0x4460d382, // n0x0388 c0x0111 (n0x198f-n0x1996)  + I nr
	0x002e23c3, // n0x0389 c0x0000 (---------------)  + I nra
	0x002b5e83, // n0x038a c0x0000 (---------------)  + I nrw
	0x00373b03, // n0x038b c0x0000 (---------------)  + I ntt
	0x44a017c2, // n0x038c c0x0112 (n0x1996-n0x1999)  + I nu
	0x0036ef83, // n0x038d c0x0000 (---------------)  + I nyc
	0x44e094c2, // n0x038e c0x0113 (n0x1999-n0x19a9)  + I nz
	0x00207143, // n0x038f c0x0000 (---------------)  + I obi
	0x002ddc88, // n0x0390 c0x0000 (---------------)  + I observer
	0x0020b283, // n0x0391 c0x0000 (---------------)  + I off
	0x00221686, // n0x0392 c0x0000 (---------------)  + I office
	0x00395b47, // n0x0393 c0x0000 (---------------)  + I okinawa
	0x0020a9c6, // n0x0394 c0x0000 (---------------)  + I olayan
	0x0020a9cb, // n0x0395 c0x0000 (---------------)  + I olayangroup
	0x0039fac7, // n0x0396 c0x0000 (---------------)  + I oldnavy
	0x00389204, // n0x0397 c0x0000 (---------------)  + I ollo
	0x456014c2, // n0x0398 c0x0115 (n0x19aa-n0x19b3)  + I om
	0x002dd5c5, // n0x0399 c0x0000 (---------------)  + I omega
	0x00214843, // n0x039a c0x0000 (---------------)  + I one
	0x002082c3, // n0x039b c0x0000 (---------------)  + I ong
	0x003175c3, // n0x039c c0x0000 (---------------)  + I onl
	0x003175c6, // n0x039d c0x0000 (---------------)  + I online
	0x003a008a, // n0x039e c0x0000 (---------------)  + I onyourside
	0x0028d703, // n0x039f c0x0000 (---------------)  + I ooo
	0x0023de44, // n0x03a0 c0x0000 (---------------)  + I open
	0x00224206, // n0x03a1 c0x0000 (---------------)  + I oracle
	0x00396286, // n0x03a2 c0x0000 (---------------)  + I orange
	0x45a2d1c3, // n0x03a3 c0x0116 (n0x19b3-n0x19f0)  + I org
	0x002ae487, // n0x03a4 c0x0000 (---------------)  + I organic
	0x002db3cd, // n0x03a5 c0x0000 (---------------)  + I orientexpress
	0x00383487, // n0x03a6 c0x0000 (---------------)  + I origins
	0x0029ac45, // n0x03a7 c0x0000 (---------------)  + I osaka
	0x00269e06, // n0x03a8 c0x0000 (---------------)  + I otsuka
	0x0021b6c3, // n0x03a9 c0x0000 (---------------)  + I ott
	0x0020da83, // n0x03aa c0x0000 (---------------)  + I ovh
	0x4720ac42, // n0x03ab c0x011c (n0x1a2d-n0x1a38)  + I pa
	0x002eaf04, // n0x03ac c0x0000 (---------------)  + I page
	0x0024c94c, // n0x03ad c0x0000 (---------------)  + I pamperedchef
	0x002646c9, // n0x03ae c0x0000 (---------------)  + I panasonic
	0x00338507, // n0x03af c0x0000 (---------------)  + I panerai
	0x00277905, // n0x03b0 c0x0000 (---------------)  + I paris
	0x002994c4, // n0x03b1 c0x0000 (---------------)  + I pars
	0x002a5308, // n0x03b2 c0x0000 (---------------)  + I partners
	0x002ad245, // n0x03b3 c0x0000 (---------------)  + I parts
	0x002b4c45, // n0x03b4 c0x0000 (---------------)  + I party
	0x002cc549, // n0x03b5 c0x0000 (---------------)  + I passagens
	0x002bc0c3, // n0x03b6 c0x0000 (---------------)  + I pay
	0x002bc0c4, // n0x03b7 c0x0000 (---------------)  + I payu
	0x002c9544, // n0x03b8 c0x0000 (---------------)  + I pccw
	0x47607782, // n0x03b9 c0x011d (n0x1a38-n0x1a40)  + I pe
	0x00207783, // n0x03ba c0x0000 (---------------)  + I pet
	0x47af7d02, // n0x03bb c0x011e (n0x1a40-n0x1a43)  + I pf
	0x002f7d06, // n0x03bc c0x0000 (---------------)  + I pfizer
	0x016495c2, // n0x03bd c0x0005 (---------------)* o I pg
	0x47e00d42, // n0x03be c0x011f (n0x1a43-n0x1a4b)  + I ph
	0x00375008, // n0x03bf c0x0000 (---------------)  + I pharmacy
	0x002d39c7, // n0x03c0 c0x0000 (---------------)  + I philips
	0x00299085, // n0x03c1 c0x0000 (---------------)  + I photo
	0x002d404b, // n0x03c2 c0x0000 (---------------)  + I photography
	0x002d11c6, // n0x03c3 c0x0000 (---------------)  + I photos
	0x002d4246, // n0x03c4 c0x0000 (---------------)  + I physio
	0x002d43c6, // n0x03c5 c0x0000 (---------------)  + I piaget
	0x00225704, // n0x03c6 c0x0000 (---------------)  + I pics
	0x002d4b46, // n0x03c7 c0x0000 (---------------)  + I pictet
	0x002d5008, // n0x03c8 c0x0000 (---------------)  + I pictures
	0x00241b83, // n0x03c9 c0x0000 (---------------)  + I pid
	0x002699c3, // n0x03ca c0x0000 (---------------)  + I pin
	0x002699c4, // n0x03cb c0x0000 (---------------)  + I ping
	0x002d6d84, // n0x03cc c0x0000 (---------------)  + I pink
	0x002d7107, // n0x03cd c0x0000 (---------------)  + I pioneer
	0x002d85c5, // n0x03ce c0x0000 (---------------)  + I pizza
	0x482d8702, // n0x03cf c0x0120 (n0x1a4b-n0x1a59)  + I pk
	0x486063c2, // n0x03d0 c0x0121 (n0x1a59-n0x1afe)  + I pl
	0x002063c5, // n0x03d1 c0x0000 (---------------)  + I place
	0x0029e944, // n0x03d2 c0x0000 (---------------)  + I play
	0x002dad4b, // n0x03d3 c0x0000 (---------------)  + I playstation
	0x002dc348, // n0x03d4 c0x0000 (---------------)  + I plumbing
	0x002dcac4, // n0x03d5 c0x0000 (---------------)  + I plus
	0x0020d7c2, // n0x03d6 c0x0000 (---------------)  + I pm
	0x48e493c2, // n0x03d7 c0x0123 (n0x1b2d-n0x1b32)  + I pn
	0x002aee03, // n0x03d8 c0x0000 (---------------)  + I pnc
	0x002dcf04, // n0x03d9 c0x0000 (---------------)  + I pohl
	0x002dd005, // n0x03da c0x0000 (---------------)  + I poker
	0x002de547, // n0x03db c0x0000 (---------------)  + I politie
	0x002e0104, // n0x03dc c0x0000 (---------------)  + I porn
	0x0035fe04, // n0x03dd c0x0000 (---------------)  + I post
	0x49204602, // n0x03de c0x0124 (n0x1b32-n0x1b3f)  + I pr
	0x003598c9, // n0x03df c0x0000 (---------------)  + I pramerica
	0x002e0b05, // n0x03e0 c0x0000 (---------------)  + I praxi
	0x00247505, // n0x03e1 c0x0000 (---------------)  + I press
	0x002e1745, // n0x03e2 c0x0000 (---------------)  + I prime
	0x49620e43, // n0x03e3 c0x0125 (n0x1b3f-n0x1b4a)  + I pro
	0x002e2044, // n0x03e4 c0x0000 (---------------)  + I prod
	0x002e204b, // n0x03e5 c0x0000 (---------------)  + I productions
	0x002e2484, // n0x03e6 c0x0000 (---------------)  + I prof
	0x002e278b, // n0x03e7 c0x0000 (---------------)  + I progressive
	0x002e36c5, // n0x03e8 c0x0000 (---------------)  + I promo
	0x00220e4a, // n0x03e9 c0x0000 (---------------)  + I properties
	0x002e3e48, // n0x03ea c0x0000 (---------------)  + I property
	0x002e404a, // n0x03eb c0x0000 (---------------)  + I protection
	0x002e42c3, // n0x03ec c0x0000 (---------------)  + I pru
	0x002e42ca, // n0x03ed c0x0000 (---------------)  + I prudential
	0x49a09342, // n0x03ee c0x0126 (n0x1b4a-n0x1b51)  + I ps
	0x49e8c9c2, // n0x03ef c0x0127 (n0x1b51-n0x1b5a)  + I pt
	0x00297403, // n0x03f0 c0x0000 (---------------)  + I pub
	0x4a2e5942, // n0x03f1 c0x0128 (n0x1b5a-n0x1b60)  + I pw
	0x002e5943, // n0x03f2 c0x0000 (---------------)  + I pwc
	0x4a734802, // n0x03f3 c0x0129 (n0x1b60-n0x1b67)  + I py
	0x4ab14682, // n0x03f4 c0x012a (n0x1b67-n0x1b70)  + I qa
	0x002e6444, // n0x03f5 c0x0000 (---------------)  + I qpon
	0x0021b906, // n0x03f6 c0x0000 (---------------)  + I quebec
	0x0022bb05, // n0x03f7 c0x0000 (---------------)  + I quest
	0x002e6ac3, // n0x03f8 c0x0000 (---------------)  + I qvc
	0x00355bc6, // n0x03f9 c0x0000 (---------------)  + I racing
	0x00351c84, // n0x03fa c0x0000 (---------------)  + I raid
	0x4ae07002, // n0x03fb c0x012b (n0x1b70-n0x1b74)  + I re
	0x002d3404, // n0x03fc c0x0000 (---------------)  + I read
	0x002c238a, // n0x03fd c0x0000 (---------------)  + I realestate
	0x00338907, // n0x03fe c0x0000 (---------------)  + I realtor
	0x0031fc86, // n0x03ff c0x0000 (---------------)  + I realty
	0x0031c747, // n0x0400 c0x0000 (---------------)  + I recipes
	0x00244803, // n0x0401 c0x0000 (---------------)  + I red
	0x003a2b48, // n0x0402 c0x0000 (---------------)  + I redstone
	0x00337f4b, // n0x0403 c0x0000 (---------------)  + I redumbrella
	0x002c9b05, // n0x0404 c0x0000 (---------------)  + I rehab
	0x0033a0c5, // n0x0405 c0x0000 (---------------)  + I reise
	0x0033a0c6, // n0x0406 c0x0000 (---------------)  + I reisen
	0x002b75c4, // n0x0407 c0x0000 (---------------)  + I reit
	0x00327f48, // n0x0408 c0x0000 (---------------)  + I reliance
	0x00209ec3, // n0x0409 c0x0000 (---------------)  + I ren
	0x0020bd84, // n0x040a c0x0000 (---------------)  + I rent
	0x0020bd87, // n0x040b c0x0000 (---------------)  + I rentals
	0x0022b7c6, // n0x040c c0x0000 (---------------)  + I repair
	0x00309586, // n0x040d c0x0000 (---------------)  + I report
	0x0029f6ca, // n0x040e c0x0000 (---------------)  + I republican
	0x0024d544, // n0x040f c0x0000 (---------------)  + I rest
	0x0037adca, // n0x0410 c0x0000 (---------------)  + I restaurant
	0x002eaac6, // n0x0411 c0x0000 (---------------)  + I review
	0x002eaac7, // n0x0412 c0x0000 (---------------)  + I reviews
	0x00257607, // n0x0413 c0x0000 (---------------)  + I rexroth
	0x00273a04, // n0x0414 c0x0000 (---------------)  + I rich
	0x00273a09, // n0x0415 c0x0000 (---------------)  + I richardli
	0x002b6f85, // n0x0416 c0x0000 (---------------)  + I ricoh
	0x0034618b, // n0x0417 c0x0000 (---------------)  + I rightathome
	0x00257f83, // n0x0418 c0x0000 (---------------)  + I ril
	0x00200a83, // n0x0419 c0x0000 (---------------)  + I rio
	0x0022fd43, // n0x041a c0x0000 (---------------)  + I rip
	0x002684c4, // n0x041b c0x0000 (---------------)  + I rmit
	0x4b202202, // n0x041c c0x012c (n0x1b74-n0x1b80)  + I ro
	0x00289806, // n0x041d c0x0000 (---------------)  + I rocher
	0x002a10c5, // n0x041e c0x0000 (---------------)  + I rocks
	0x002d2f85, // n0x041f c0x0000 (---------------)  + I rodeo
	0x0039c1c6, // n0x0420 c0x0000 (---------------)  + I rogers
	0x0037ed04, // n0x0421 c0x0000 (---------------)  + I room
	0x4b609702, // n0x0422 c0x012d (n0x1b80-n0x1b87)  + I rs
	0x0039c2c4, // n0x0423 c0x0000 (---------------)  + I rsvp
	0x4ba11302, // n0x0424 c0x012e (n0x1b87-n0x1c0a)  + I ru
	0x00236144, // n0x0425 c0x0000 (---------------)  + I ruhr
	0x00222b43, // n0x0426 c0x0000 (---------------)  + I run
	0x4beb5ec2, // n0x0427 c0x012f (n0x1c0a-n0x1c13)  + I rw
	0x003274c3, // n0x0428 c0x0000 (---------------)  + I rwe
	0x0036acc6, // n0x0429 c0x0000 (---------------)  + I ryukyu
	0x4c2004c2, // n0x042a c0x0130 (n0x1c13-n0x1c1b)  + I sa
	0x0030c348, // n0x042b c0x0000 (---------------)  + I saarland
	0x00215944, // n0x042c c0x0000 (---------------)  + I safe
	0x00215946, // n0x042d c0x0000 (---------------)  + I safety
	0x00307fc6, // n0x042e c0x0000 (---------------)  + I sakura
	0x00259844, // n0x042f c0x0000 (---------------)  + I sale
	0x00321885, // n0x0430 c0x0000 (---------------)  + I salon
	0x00398bc8, // n0x0431 c0x0000 (---------------)  + I samsclub
	0x0039edc7, // n0x0432 c0x0000 (---------------)  + I samsung
	0x003a0747, // n0x0433 c0x0000 (---------------)  + I sandvik
	0x003a074f, // n0x0434 c0x0000 (---------------)  + I sandvikcoromant
	0x00294646, // n0x0435 c0x0000 (---------------)  + I sanofi
	0x00219dc3, // n0x0436 c0x0000 (---------------)  + I sap
	0x00219dc4, // n0x0437 c0x0000 (---------------)  + I sapo
	0x0022b604, // n0x0438 c0x0000 (---------------)  + I sarl
	0x00228143, // n0x0439 c0x0000 (---------------)  + I sas
	0x00222244, // n0x043a c0x0000 (---------------)  + I save
	0x00235144, // n0x043b c0x0000 (---------------)  + I saxo
	0x4c62d142, // n0x043c c0x0131 (n0x1c1b-n0x1c20)  + I sb
	0x00288e03, // n0x043d c0x0000 (---------------)  + I sbi
	0x00237503, // n0x043e c0x0000 (---------------)  + I sbs
	0x4ca00702, // n0x043f c0x0132 (n0x1c20-n0x1c25)  + I sc
	0x00236a03, // n0x0440 c0x0000 (---------------)  + I sca
	0x002ee403, // n0x0441 c0x0000 (---------------)  + I scb
	0x0021744a, // n0x0442 c0x0000 (---------------)  + I schaeffler
	0x002e5d47, // n0x0443 c0x0000 (---------------)  + I schmidt
	0x0023ce0c, // n0x0444 c0x0000 (---------------)  + I scholarships
	0x0023d0c6, // n0x0445 c0x0000 (---------------)  + I school
	0x00241286, // n0x0446 c0x0000 (---------------)  + I schule
	0x00242547, // n0x0447 c0x0000 (---------------)  + I schwarz
	0x002358c7, // n0x0448 c0x0000 (---------------)  + I science
	0x00246cc9, // n0x0449 c0x0000 (---------------)  + I scjohnson
	0x0021c544, // n0x044a c0x0000 (---------------)  + I scor
	0x00200704, // n0x044b c0x0000 (---------------)  + I scot
	0x4ce496c2, // n0x044c c0x0133 (n0x1c25-n0x1c2d)  + I sd
	0x4d2046c2, // n0x044d c0x0134 (n0x1c2d-n0x1c56)  + I se
	0x00316b84, // n0x044e c0x0000 (---------------)  + I seat
	0x0031c646, // n0x044f c0x0000 (---------------)  + I secure
	0x00235d48, // n0x0450 c0x0000 (---------------)  + I security
	0x0027a144, // n0x0451 c0x0000 (---------------)  + I seek
	0x0025b346, // n0x0452 c0x0000 (---------------)  + I select
	0x002cb485, // n0x0453 c0x0000 (---------------)  + I sener
	0x00206808, // n0x0454 c0x0000 (---------------)  + I services
	0x002046c3, // n0x0455 c0x0000 (---------------)  + I ses
	0x00251f05, // n0x0456 c0x0000 (---------------)  + I seven
	0x00253b43, // n0x0457 c0x0000 (---------------)  + I sew
	0x00247603, // n0x0458 c0x0000 (---------------)  + I sex
	0x00247604, // n0x0459 c0x0000 (---------------)  + I sexy
	0x00256a83, // n0x045a c0x0000 (---------------)  + I sfr
	0x4d66d702, // n0x045b c0x0135 (n0x1c56-n0x1c5d)  + I sg
	0x4da01342, // n0x045c c0x0136 (n0x1c5d-n0x1c64)  + I sh
	0x00257e49, // n0x045d c0x0000 (---------------)  + I shangrila
	0x0025b885, // n0x045e c0x0000 (---------------)  + I sharp
	0x0025cb44, // n0x045f c0x0000 (---------------)  + I shaw
	0x0025fd45, // n0x0460 c0x0000 (---------------)  + I shell
	0x00211884, // n0x0461 c0x0000 (---------------)  + I shia
	0x002fea47, // n0x0462 c0x0000 (---------------)  + I shiksha
	0x003896c5, // n0x0463 c0x0000 (---------------)  + I shoes
	0x002be486, // n0x0464 c0x0000 (---------------)  + I shouji
	0x002c4484, // n0x0465 c0x0000 (---------------)  + I show
	0x002c4488, // n0x0466 c0x0000 (---------------)  + I showtime
	0x002c8307, // n0x0467 c0x0000 (---------------)  + I shriram
	0x4de0a402, // n0x0468 c0x0137 (n0x1c64-n0x1c65)  + I si
	0x00341f84, // n0x0469 c0x0000 (---------------)  + I silk
	0x002f7b84, // n0x046a c0x0000 (---------------)  + I sina
	0x00285cc7, // n0x046b c0x0000 (---------------)  + I singles
	0x002810c4, // n0x046c c0x0000 (---------------)  + I site
	0x0022eb82, // n0x046d c0x0000 (---------------)  + I sj
	0x4e207842, // n0x046e c0x0138 (n0x1c65-n0x1c66)  + I sk
	0x00209743, // n0x046f c0x0000 (---------------)  + I ski
	0x002e76c4, // n0x0470 c0x0000 (---------------)  + I skin
	0x002368c3, // n0x0471 c0x0000 (---------------)  + I sky
	0x002368c5, // n0x0472 c0x0000 (---------------)  + I skype
	0x4e624b82, // n0x0473 c0x0139 (n0x1c66-n0x1c6b)  + I sl
	0x00375205, // n0x0474 c0x0000 (---------------)  + I sling
	0x0024cdc2, // n0x0475 c0x0000 (---------------)  + I sm
	0x00368185, // n0x0476 c0x0000 (---------------)  + I smart
	0x0035e3c5, // n0x0477 c0x0000 (---------------)  + I smile
	0x4ea14182, // n0x0478 c0x013a (n0x1c6b-n0x1c73)  + I sn
	0x00214184, // n0x0479 c0x0000 (---------------)  + I sncf
	0x4ee05682, // n0x047a c0x013b (n0x1c73-n0x1c76)  + I so
	0x00325706, // n0x047b c0x0000 (---------------)  + I soccer
	0x002a3986, // n0x047c c0x0000 (---------------)  + I social
	0x0026b288, // n0x047d c0x0000 (---------------)  + I softbank
	0x002b8688, // n0x047e c0x0000 (---------------)  + I software
	0x002f9444, // n0x047f c0x0000 (---------------)  + I sohu
	0x00359f05, // n0x0480 c0x0000 (---------------)  + I solar
	0x00359d09, // n0x0481 c0x0000 (---------------)  + I solutions
	0x00356144, // n0x0482 c0x0000 (---------------)  + I song
	0x003a0044, // n0x0483 c0x0000 (---------------)  + I sony
	0x002bd0c3, // n0x0484 c0x0000 (---------------)  + I soy
	0x0020bb45, // n0x0485 c0x0000 (---------------)  + I space
	0x00371ac7, // n0x0486 c0x0000 (---------------)  + I spiegel
	0x00209384, // n0x0487 c0x0000 (---------------)  + I spot
	0x00332e4d, // n0x0488 c0x0000 (---------------)  + I spreadbetting
	0x0033b802, // n0x0489 c0x0000 (---------------)  + I sr
	0x0033b803, // n0x048a c0x0000 (---------------)  + I srl
	0x0035a503, // n0x048b c0x0000 (---------------)  + I srt
	0x4f202742, // n0x048c c0x013c (n0x1c76-n0x1c82)  + I st
	0x00380745, // n0x048d c0x0000 (---------------)  + I stada
	0x002320c7, // n0x048e c0x0000 (---------------)  + I staples
	0x00228904, // n0x048f c0x0000 (---------------)  + I star
	0x00228907, // n0x0490 c0x0000 (---------------)  + I starhub
	0x0020f209, // n0x0491 c0x0000 (---------------)  + I statebank
	0x002c24c9, // n0x0492 c0x0000 (---------------)  + I statefarm
	0x003a0dc7, // n0x0493 c0x0000 (---------------)  + I statoil
	0x00277743, // n0x0494 c0x0000 (---------------)  + I stc
	0x00277748, // n0x0495 c0x0000 (---------------)  + I stcgroup
	0x002a8009, // n0x0496 c0x0000 (---------------)  + I stockholm
	0x00364547, // n0x0497 c0x0000 (---------------)  + I storage
	0x00391185, // n0x0498 c0x0000 (---------------)  + I store
	0x002e74c6, // n0x0499 c0x0000 (---------------)  + I stream
	0x002e7906, // n0x049a c0x0000 (---------------)  + I studio
	0x002e7a85, // n0x049b c0x0000 (---------------)  + I study
	0x00253dc5, // n0x049c c0x0000 (---------------)  + I style
	0x4f6023c2, // n0x049d c0x013d (n0x1c82-n0x1ca2)  + I su
	0x00332385, // n0x049e c0x0000 (---------------)  + I sucks
	0x002ba24a, // n0x049f c0x0000 (---------------)  + I supersport
	0x002be2c8, // n0x04a0 c0x0000 (---------------)  + I supplies
	0x002a7806, // n0x04a1 c0x0000 (---------------)  + I supply
	0x002e3907, // n0x04a2 c0x0000 (---------------)  + I support
	0x0024c144, // n0x04a3 c0x0000 (---------------)  + I surf
	0x002a9e07, // n0x04a4 c0x0000 (---------------)  + I surgery
	0x002eef06, // n0x04a5 c0x0000 (---------------)  + I suzuki
	0x4fa35f42, // n0x04a6 c0x013e (n0x1ca2-n0x1ca7)  + I sv
	0x00376c06, // n0x04a7 c0x0000 (---------------)  + I swatch
	0x002f15ca, // n0x04a8 c0x0000 (---------------)  + I swiftcover
	0x002f1f85, // n0x04a9 c0x0000 (---------------)  + I swiss
	0x4fef2802, // n0x04aa c0x013f (n0x1ca7-n0x1ca8)  + I sx
	0x50289a02, // n0x04ab c0x0140 (n0x1ca8-n0x1cae)  + I sy
	0x00329bc6, // n0x04ac c0x0000 (---------------)  + I sydney
	0x002d5f48, // n0x04ad c0x0000 (---------------)  + I symantec
	0x00394e07, // n0x04ae c0x0000 (---------------)  + I systems
	0x5060b982, // n0x04af c0x0141 (n0x1cae-n0x1cb1)  + I sz
	0x00210d43, // n0x04b0 c0x0000 (---------------)  + I tab
	0x003a6506, // n0x04b1 c0x0000 (---------------)  + I taipei
	0x0021eb04, // n0x04b2 c0x0000 (---------------)  + I talk
	0x00395a06, // n0x04b3 c0x0000 (---------------)  + I taobao
	0x00357846, // n0x04b4 c0x0000 (---------------)  + I target
	0x00322a0a, // n0x04b5 c0x0000 (---------------)  + I tatamotors
	0x0036cc45, // n0x04b6 c0x0000 (---------------)  + I tatar
	0x00219906, // n0x04b7 c0x0000 (---------------)  + I tattoo
	0x002203c3, // n0x04b8 c0x0000 (---------------)  + I tax
	0x002203c4, // n0x04b9 c0x0000 (---------------)  + I taxi
	0x00204442, // n0x04ba c0x0000 (---------------)  + I tc
	0x0025edc3, // n0x04bb c0x0000 (---------------)  + I tci
	0x50a0b182, // n0x04bc c0x0142 (n0x1cb1-n0x1cb2)  + I td
	0x002c9683, // n0x04bd c0x0000 (---------------)  + I tdk
	0x00367504, // n0x04be c0x0000 (---------------)  + I team
	0x002d59c4, // n0x04bf c0x0000 (---------------)  + I tech
	0x002d608a, // n0x04c0 c0x0000 (---------------)  + I technology
	0x0022f7c3, // n0x04c1 c0x0000 (---------------)  + I tel
	0x00286648, // n0x04c2 c0x0000 (---------------)  + I telecity
	0x0030ec4a, // n0x04c3 c0x0000 (---------------)  + I telefonica
	0x0023fa07, // n0x04c4 c0x0000 (---------------)  + I temasek
	0x002f4806, // n0x04c5 c0x0000 (---------------)  + I tennis
	0x0032ce44, // n0x04c6 c0x0000 (---------------)  + I teva
	0x0025d9c2, // n0x04c7 c0x0000 (---------------)  + I tf
	0x00204c42, // n0x04c8 c0x0000 (---------------)  + I tg
	0x50e06342, // n0x04c9 c0x0143 (n0x1cb2-n0x1cb9)  + I th
	0x0024b183, // n0x04ca c0x0000 (---------------)  + I thd
	0x002573c7, // n0x04cb c0x0000 (---------------)  + I theater
	0x00355e87, // n0x04cc c0x0000 (---------------)  + I theatre
	0x003504cb, // n0x04cd c0x0000 (---------------)  + I theguardian
	0x0034d4c4, // n0x04ce c0x0000 (---------------)  + I tiaa
	0x002f6847, // n0x04cf c0x0000 (---------------)  + I tickets
	0x002de646, // n0x04d0 c0x0000 (---------------)  + I tienda
	0x00215707, // n0x04d1 c0x0000 (---------------)  + I tiffany
	0x002e5c84, // n0x04d2 c0x0000 (---------------)  + I tips
	0x0033d385, // n0x04d3 c0x0000 (---------------)  + I tires
	0x002b7905, // n0x04d4 c0x0000 (---------------)  + I tirol
	0x51226782, // n0x04d5 c0x0144 (n0x1cb9-n0x1cc8)  + I tj
	0x00230886, // n0x04d6 c0x0000 (---------------)  + I tjmaxx
	0x0036f443, // n0x04d7 c0x0000 (---------------)  + I tjx
	0x0022ad02, // n0x04d8 c0x0000 (---------------)  + I tk
	0x00231686, // n0x04d9 c0x0000 (---------------)  + I tkmaxx
	0x516007c2, // n0x04da c0x0145 (n0x1cc8-n0x1cc9)  + I tl
	0x51a00142, // n0x04db c0x0146 (n0x1cc9-n0x1cd1)  + I tm
	0x00200145, // n0x04dc c0x0000 (---------------)  + I tmall
	0x51e4f882, // n0x04dd c0x0147 (n0x1cd1-n0x1ce5)  + I tn
	0x52208082, // n0x04de c0x0148 (n0x1ce5-n0x1ceb)  + I to
	0x00265905, // n0x04df c0x0000 (---------------)  + I today
	0x00341c05, // n0x04e0 c0x0000 (---------------)  + I tokyo
	0x002199c5, // n0x04e1 c0x0000 (---------------)  + I tools
	0x00208083, // n0x04e2 c0x0000 (---------------)  + I top
	0x00376345, // n0x04e3 c0x0000 (---------------)  + I toray
	0x002d1287, // n0x04e4 c0x0000 (---------------)  + I toshiba
	0x0025b605, // n0x04e5 c0x0000 (---------------)  + I total
	0x002fd7c5, // n0x04e6 c0x0000 (---------------)  + I tours
	0x002dc244, // n0x04e7 c0x0000 (---------------)  + I town
	0x0025bb86, // n0x04e8 c0x0000 (---------------)  + I toyota
	0x0026dac4, // n0x04e9 c0x0000 (---------------)  + I toys
	0x52603002, // n0x04ea c0x0149 (n0x1ceb-n0x1d00)  + I tr
	0x002673c5, // n0x04eb c0x0000 (---------------)  + I trade
	0x002a4607, // n0x04ec c0x0000 (---------------)  + I trading
	0x0022a6c8, // n0x04ed c0x0000 (---------------)  + I training
	0x0029bec6, // n0x04ee c0x0000 (---------------)  + I travel
	0x0029becd, // n0x04ef c0x0000 (---------------)  + I travelchannel
	0x002a1a89, // n0x04f0 c0x0000 (---------------)  + I travelers
	0x002a1a92, // n0x04f1 c0x0000 (---------------)  + I travelersinsurance
	0x00329245, // n0x04f2 c0x0000 (---------------)  + I trust
	0x0033f2c3, // n0x04f3 c0x0000 (---------------)  + I trv
	0x5320e842, // n0x04f4 c0x014c (n0x1d02-n0x1d13)  + I tt
	0x002e48c4, // n0x04f5 c0x0000 (---------------)  + I tube
	0x002f89c3, // n0x04f6 c0x0000 (---------------)  + I tui
	0x0035d745, // n0x04f7 c0x0000 (---------------)  + I tunes
	0x002f2e45, // n0x04f8 c0x0000 (---------------)  + I tushu
	0x53624e42, // n0x04f9 c0x014d (n0x1d13-n0x1d17)  + I tv
	0x003644c3, // n0x04fa c0x0000 (---------------)  + I tvs
	0x53a4e502, // n0x04fb c0x014e (n0x1d17-n0x1d25)  + I tw
	0x53e1fe82, // n0x04fc c0x014f (n0x1d25-n0x1d31)  + I tz
	0x54220502, // n0x04fd c0x0150 (n0x1d31-n0x1d80)  + I ua
	0x0033bbc5, // n0x04fe c0x0000 (---------------)  + I ubank
	0x0024a4c3, // n0x04ff c0x0000 (---------------)  + I ubs
	0x00249a48, // n0x0500 c0x0000 (---------------)  + I uconnect
	0x54601cc2, // n0x0501 c0x0151 (n0x1d80-n0x1d89)  + I ug
	0x54a00f82, // n0x0502 c0x0152 (n0x1d89-n0x1d94)  + I uk
	0x002a6ac6, // n0x0503 c0x0000 (---------------)  + I unicom
	0x00320a0a, // n0x0504 c0x0000 (---------------)  + I university
	0x0020d503, // n0x0505 c0x0000 (---------------)  + I uno
	0x00259d43, // n0x0506 c0x0000 (---------------)  + I uol
	0x002d5243, // n0x0507 c0x0000 (---------------)  + I ups
	0x55602382, // n0x0508 c0x0155 (n0x1d96-n0x1dd5)  + I us
	0x63a01802, // n0x0509 c0x018e (n0x1e78-n0x1e7e)  + I uy
	0x64211342, // n0x050a c0x0190 (n0x1e7f-n0x1e83)  + I uz
	0x002000c2, // n0x050b c0x0000 (---------------)  + I va
	0x00376a09, // n0x050c c0x0000 (---------------)  + I vacations
	0x002bc5c4, // n0x050d c0x0000 (---------------)  + I vana
	0x00344588, // n0x050e c0x0000 (---------------)  + I vanguard
	0x646e6b02, // n0x050f c0x0191 (n0x1e83-n0x1e89)  + I vc
	0x64a02b82, // n0x0510 c0x0192 (n0x1e89-n0x1e9a)  + I ve
	0x00230285, // n0x0511 c0x0000 (---------------)  + I vegas
	0x0023b808, // n0x0512 c0x0000 (---------------)  + I ventures
	0x002f1788, // n0x0513 c0x0000 (---------------)  + I verisign
	0x0039440c, // n0x0514 c0x0000 (---------------)  + I versicherung
	0x0023f943, // n0x0515 c0x0000 (---------------)  + I vet
	0x0023fd02, // n0x0516 c0x0000 (---------------)  + I vg
	0x64e05d42, // n0x0517 c0x0193 (n0x1e9a-n0x1e9f)  + I vi
	0x002c5706, // n0x0518 c0x0000 (---------------)  + I viajes
	0x002f5685, // n0x0519 c0x0000 (---------------)  + I video
	0x0031a003, // n0x051a c0x0000 (---------------)  + I vig
	0x00311a06, // n0x051b c0x0000 (---------------)  + I viking
	0x002f57c6, // n0x051c c0x0000 (---------------)  + I villas
	0x00241543, // n0x051d c0x0000 (---------------)  + I vin
	0x002f7ac3, // n0x051e c0x0000 (---------------)  + I vip
	0x002f7e86, // n0x051f c0x0000 (---------------)  + I virgin
	0x002f8404, // n0x0520 c0x0000 (---------------)  + I visa
	0x002b48c6, // n0x0521 c0x0000 (---------------)  + I vision
	0x002c9245, // n0x0522 c0x0000 (---------------)  + I vista
	0x002f878a, // n0x0523 c0x0000 (---------------)  + I vistaprint
	0x00240444, // n0x0524 c0x0000 (---------------)  + I viva
	0x002f97c4, // n0x0525 c0x0000 (---------------)  + I vivo
	0x0034710a, // n0x0526 c0x0000 (---------------)  + I vlaanderen
	0x65203442, // n0x0527 c0x0194 (n0x1e9f-n0x1eac)  + I vn
	0x002760c5, // n0x0528 c0x0000 (---------------)  + I vodka
	0x002fbd0a, // n0x0529 c0x0000 (---------------)  + I volkswagen
	0x002fc945, // n0x052a c0x0000 (---------------)  + I volvo
	0x002fd4c4, // n0x052b c0x0000 (---------------)  + I vote
	0x002fd5c6, // n0x052c c0x0000 (---------------)  + I voting
	0x002fd744, // n0x052d c0x0000 (---------------)  + I voto
	0x00231006, // n0x052e c0x0000 (---------------)  + I voyage
	0x65672082, // n0x052f c0x0195 (n0x1eac-n0x1eb0)  + I vu
	0x0031f5c6, // n0x0530 c0x0000 (---------------)  + I vuelos
	0x00320685, // n0x0531 c0x0000 (---------------)  + I wales
	0x002010c7, // n0x0532 c0x0000 (---------------)  + I walmart
	0x00293986, // n0x0533 c0x0000 (---------------)  + I walter
	0x00242744, // n0x0534 c0x0000 (---------------)  + I wang
	0x0033d6c7, // n0x0535 c0x0000 (---------------)  + I wanggou
	0x0036f146, // n0x0536 c0x0000 (---------------)  + I warman
	0x002aca45, // n0x0537 c0x0000 (---------------)  + I watch
	0x003a3d87, // n0x0538 c0x0000 (---------------)  + I watches
	0x00391887, // n0x0539 c0x0000 (---------------)  + I weather
	0x0039188e, // n0x053a c0x0000 (---------------)  + I weatherchannel
	0x00221a06, // n0x053b c0x0000 (---------------)  + I webcam
	0x0022e645, // n0x053c c0x0000 (---------------)  + I weber
	0x00281007, // n0x053d c0x0000 (---------------)  + I website
	0x002f08c3, // n0x053e c0x0000 (---------------)  + I wed
	0x0032f407, // n0x053f c0x0000 (---------------)  + I wedding
	0x0020fe05, // n0x0540 c0x0000 (---------------)  + I weibo
	0x002109c4, // n0x0541 c0x0000 (---------------)  + I weir
	0x0022fe82, // n0x0542 c0x0000 (---------------)  + I wf
	0x003a43c7, // n0x0543 c0x0000 (---------------)  + I whoswho
	0x002eee04, // n0x0544 c0x0000 (---------------)  + I wien
	0x0037c484, // n0x0545 c0x0000 (---------------)  + I wiki
	0x0025a8cb, // n0x0546 c0x0000 (---------------)  + I williamhill
	0x0021cbc3, // n0x0547 c0x0000 (---------------)  + I win
	0x002afe07, // n0x0548 c0x0000 (---------------)  + I windows
	0x0021cbc4, // n0x0549 c0x0000 (---------------)  + I wine
	0x002b0f07, // n0x054a c0x0000 (---------------)  + I winners
	0x00231c43, // n0x054b c0x0000 (---------------)  + I wme
	0x0032ae4d, // n0x054c c0x0000 (---------------)  + I wolterskluwer
	0x00380f88, // n0x054d c0x0000 (---------------)  + I woodside
	0x00255c44, // n0x054e c0x0000 (---------------)  + I work
	0x00351f05, // n0x054f c0x0000 (---------------)  + I works
	0x00300b85, // n0x0550 c0x0000 (---------------)  + I world
	0x002ff3c3, // n0x0551 c0x0000 (---------------)  + I wow
	0x65a0b942, // n0x0552 c0x0196 (n0x1eb0-n0x1eb7)  + I ws
	0x003002c3, // n0x0553 c0x0000 (---------------)  + I wtc
	0x00300783, // n0x0554 c0x0000 (---------------)  + I wtf
	0x0021bb44, // n0x0555 c0x0000 (---------------)  + I xbox
	0x0027bec5, // n0x0556 c0x0000 (---------------)  + I xerox
	0x00230a07, // n0x0557 c0x0000 (---------------)  + I xfinity
	0x00220446, // n0x0558 c0x0000 (---------------)  + I xihuan
	0x00367243, // n0x0559 c0x0000 (---------------)  + I xin
	0x002317cb, // n0x055a c0x0000 (---------------)  + I xn--11b4c3d
	0x0024830b, // n0x055b c0x0000 (---------------)  + I xn--1ck2e1b
	0x0026a7cb, // n0x055c c0x0000 (---------------)  + I xn--1qqw23a
	0x0027bfca, // n0x055d c0x0000 (---------------)  + I xn--30rr7y
	0x002a718b, // n0x055e c0x0000 (---------------)  + I xn--3bst00m
	0x002daa8b, // n0x055f c0x0000 (---------------)  + I xn--3ds443g
	0x002d3d4c, // n0x0560 c0x0000 (---------------)  + I xn--3e0b707e
	0x002f2851, // n0x0561 c0x0000 (---------------)  + I xn--3oq18vl8pn36a
	0x00339a8a, // n0x0562 c0x0000 (---------------)  + I xn--3pxu8k
	0x0034a00b, // n0x0563 c0x0000 (---------------)  + I xn--42c2d9a
	0x00370d8b, // n0x0564 c0x0000 (---------------)  + I xn--45brj9c
	0x003a374a, // n0x0565 c0x0000 (---------------)  + I xn--45q11c
	0x003a5a0a, // n0x0566 c0x0000 (---------------)  + I xn--4gbrim
	0x00300f8d, // n0x0567 c0x0000 (---------------)  + I xn--4gq48lf9j
	0x0030218e, // n0x0568 c0x0000 (---------------)  + I xn--54b7fta0cc
	0x0030270b, // n0x0569 c0x0000 (---------------)  + I xn--55qw42g
	0x003029ca, // n0x056a c0x0000 (---------------)  + I xn--55qx5d
	0x00303d11, // n0x056b c0x0000 (---------------)  + I xn--5su34j936bgsg
	0x0030414a, // n0x056c c0x0000 (---------------)  + I xn--5tzm5g
	0x0030464b, // n0x056d c0x0000 (---------------)  + I xn--6frz82g
	0x00304b8e, // n0x056e c0x0000 (---------------)  + I xn--6qq986b3xl
	0x0030550c, // n0x056f c0x0000 (---------------)  + I xn--80adxhks
	0x0030648b, // n0x0570 c0x0000 (---------------)  + I xn--80ao21a
	0x0030674e, // n0x0571 c0x0000 (---------------)  + I xn--80aqecdr1a
	0x00306acc, // n0x0572 c0x0000 (---------------)  + I xn--80asehdb
	0x00309b8a, // n0x0573 c0x0000 (---------------)  + I xn--80aswg
	0x0030a9cc, // n0x0574 c0x0000 (---------------)  + I xn--8y0a063a
	0x65f0acca, // n0x0575 c0x0197 (n0x1eb7-n0x1ebd)  + I xn--90a3ac
	0x0030bb89, // n0x0576 c0x0000 (---------------)  + I xn--90ais
	0x0030d14a, // n0x0577 c0x0000 (---------------)  + I xn--9dbq2a
	0x0030d3ca, // n0x0578 c0x0000 (---------------)  + I xn--9et52u
	0x0030d64b, // n0x0579 c0x0000 (---------------)  + I xn--9krt00a
	0x00310c4e, // n0x057a c0x0000 (---------------)  + I xn--b4w605ferd
	0x00310fd1, // n0x057b c0x0000 (---------------)  + I xn--bck1b9a5dre4c
	0x00318cc9, // n0x057c c0x0000 (---------------)  + I xn--c1avg
	0x00318f0a, // n0x057d c0x0000 (---------------)  + I xn--c2br7g
	0x00319a4b, // n0x057e c0x0000 (---------------)  + I xn--cck2b3b
	0x0031b68a, // n0x057f c0x0000 (---------------)  + I xn--cg4bki
	0x0031bfd6, // n0x0580 c0x0000 (---------------)  + I xn--clchc0ea0b2g2a9gcd
	0x0031e50b, // n0x0581 c0x0000 (---------------)  + I xn--czr694b
	0x0032398a, // n0x0582 c0x0000 (---------------)  + I xn--czrs0t
	0x003241ca, // n0x0583 c0x0000 (---------------)  + I xn--czru2d
	0x0032674b, // n0x0584 c0x0000 (---------------)  + I xn--d1acj3b
	0x00328cc9, // n0x0585 c0x0000 (---------------)  + I xn--d1alf
	0x0032b7cd, // n0x0586 c0x0000 (---------------)  + I xn--eckvdtc9d
	0x0032c18b, // n0x0587 c0x0000 (---------------)  + I xn--efvy88h
	0x0032d08b, // n0x0588 c0x0000 (---------------)  + I xn--estv75g
	0x0032da4b, // n0x0589 c0x0000 (---------------)  + I xn--fct429k
	0x0032dec9, // n0x058a c0x0000 (---------------)  + I xn--fhbei
	0x0032e50e, // n0x058b c0x0000 (---------------)  + I xn--fiq228c5hs
	0x0032ebca, // n0x058c c0x0000 (---------------)  + I xn--fiq64b
	0x003328ca, // n0x058d c0x0000 (---------------)  + I xn--fiqs8s
	0x00332c0a, // n0x058e c0x0000 (---------------)  + I xn--fiqz9s
	0x003334cb, // n0x058f c0x0000 (---------------)  + I xn--fjq720a
	0x00333d0b, // n0x0590 c0x0000 (---------------)  + I xn--flw351e
	0x00333fcd, // n0x0591 c0x0000 (---------------)  + I xn--fpcrj9c3d
	0x0033558d, // n0x0592 c0x0000 (---------------)  + I xn--fzc2c9e2c
	0x00335ad0, // n0x0593 c0x0000 (---------------)  + I xn--fzys8d69uvgm
	0x00335f8b, // n0x0594 c0x0000 (---------------)  + I xn--g2xx48c
	0x00336d4c, // n0x0595 c0x0000 (---------------)  + I xn--gckr3f0f
	0x00337a0b, // n0x0596 c0x0000 (---------------)  + I xn--gecrj9c
	0x0033a58b, // n0x0597 c0x0000 (---------------)  + I xn--gk3at1e
	0x0033ca0b, // n0x0598 c0x0000 (---------------)  + I xn--h2brj9c
	0x0034034b, // n0x0599 c0x0000 (---------------)  + I xn--hxt814e
	0x00340dcf, // n0x059a c0x0000 (---------------)  + I xn--i1b6b1a6a2e
	0x0034118b, // n0x059b c0x0000 (---------------)  + I xn--imr513n
	0x0034280a, // n0x059c c0x0000 (---------------)  + I xn--io0a7i
	0x00343209, // n0x059d c0x0000 (---------------)  + I xn--j1aef
	0x00343e49, // n0x059e c0x0000 (---------------)  + I xn--j1amh
	0x0034478b, // n0x059f c0x0000 (---------------)  + I xn--j6w193g
	0x00344a4e, // n0x05a0 c0x0000 (---------------)  + I xn--jlq61u9w7b
	0x0034778b, // n0x05a1 c0x0000 (---------------)  + I xn--jvr189m
	0x00348bcf, // n0x05a2 c0x0000 (---------------)  + I xn--kcrx77d1x4a
	0x0034afcb, // n0x05a3 c0x0000 (---------------)  + I xn--kprw13d
	0x0034b28b, // n0x05a4 c0x0000 (---------------)  + I xn--kpry57d
	0x0034b54b, // n0x05a5 c0x0000 (---------------)  + I xn--kpu716f
	0x0034b98a, // n0x05a6 c0x0000 (---------------)  + I xn--kput3i
	0x00352909, // n0x05a7 c0x0000 (---------------)  + I xn--l1acc
	0x0035800f, // n0x05a8 c0x0000 (---------------)  + I xn--lgbbat1ad8j
	0x0035c74c, // n0x05a9 c0x0000 (---------------)  + I xn--mgb2ddes
	0x0035cfcc, // n0x05aa c0x0000 (---------------)  + I xn--mgb9awbf
	0x0035d40e, // n0x05ab c0x0000 (---------------)  + I xn--mgba3a3ejt
	0x0035d94f, // n0x05ac c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0035dd0e, // n0x05ad c0x0000 (---------------)  + I xn--mgba3a4fra
	0x0035e6d0, // n0x05ae c0x0000 (---------------)  + I xn--mgba7c0bbn0a
	0x0035eacf, // n0x05af c0x0000 (---------------)  + I xn--mgbaakc7dvf
	0x0035f04e, // n0x05b0 c0x0000 (---------------)  + I xn--mgbaam7a8h
	0x0035f50c, // n0x05b1 c0x0000 (---------------)  + I xn--mgbab2bd
	0x0035f812, // n0x05b2 c0x0000 (---------------)  + I xn--mgbai9a5eva00b
	0x00360b51, // n0x05b3 c0x0000 (---------------)  + I xn--mgbai9azgqp6j
	0x0036110e, // n0x05b4 c0x0000 (---------------)  + I xn--mgbayh7gpa
	0x0036154e, // n0x05b5 c0x0000 (---------------)  + I xn--mgbb9fbpob
	0x00361a8e, // n0x05b6 c0x0000 (---------------)  + I xn--mgbbh1a71e
	0x00361e0f, // n0x05b7 c0x0000 (---------------)  + I xn--mgbc0a9azcg
	0x003621ce, // n0x05b8 c0x0000 (---------------)  + I xn--mgbca7dzdo
	0x00362553, // n0x05b9 c0x0000 (---------------)  + I xn--mgberp4a5d4a87g
	0x00362a11, // n0x05ba c0x0000 (---------------)  + I xn--mgberp4a5d4ar
	0x00362e4e, // n0x05bb c0x0000 (---------------)  + I xn--mgbi4ecexp
	0x003632cc, // n0x05bc c0x0000 (---------------)  + I xn--mgbpl2fh
	0x00363713, // n0x05bd c0x0000 (---------------)  + I xn--mgbqly7c0a67fbc
	0x00363e90, // n0x05be c0x0000 (---------------)  + I xn--mgbqly7cvafr
	0x0036470c, // n0x05bf c0x0000 (---------------)  + I xn--mgbt3dhd
	0x00364a0c, // n0x05c0 c0x0000 (---------------)  + I xn--mgbtf8fl
	0x00364f4b, // n0x05c1 c0x0000 (---------------)  + I xn--mgbtx2b
	0x0036540e, // n0x05c2 c0x0000 (---------------)  + I xn--mgbx4cd0ab
	0x0036590b, // n0x05c3 c0x0000 (---------------)  + I xn--mix082f
	0x0036688b, // n0x05c4 c0x0000 (---------------)  + I xn--mix891f
	0x003678cc, // n0x05c5 c0x0000 (---------------)  + I xn--mk1bu44c
	0x0036fa4a, // n0x05c6 c0x0000 (---------------)  + I xn--mxtq1m
	0x0037058c, // n0x05c7 c0x0000 (---------------)  + I xn--ngbc5azd
	0x0037088c, // n0x05c8 c0x0000 (---------------)  + I xn--ngbe9e0a
	0x00370b89, // n0x05c9 c0x0000 (---------------)  + I xn--ngbrx
	0x0037254b, // n0x05ca c0x0000 (---------------)  + I xn--nnx388a
	0x00372808, // n0x05cb c0x0000 (---------------)  + I xn--node
	0x00372cc9, // n0x05cc c0x0000 (---------------)  + I xn--nqv7f
	0x00372ccf, // n0x05cd c0x0000 (---------------)  + I xn--nqv7fs00ema
	0x0037464b, // n0x05ce c0x0000 (---------------)  + I xn--nyqy26a
	0x0037534a, // n0x05cf c0x0000 (---------------)  + I xn--o3cw4h
	0x0037708c, // n0x05d0 c0x0000 (---------------)  + I xn--ogbpf8fl
	0x00379349, // n0x05d1 c0x0000 (---------------)  + I xn--p1acf
	0x003795c8, // n0x05d2 c0x0000 (---------------)  + I xn--p1ai
	0x003797cb, // n0x05d3 c0x0000 (---------------)  + I xn--pbt977c
	0x0037a58b, // n0x05d4 c0x0000 (---------------)  + I xn--pgbs0dh
	0x0037b44a, // n0x05d5 c0x0000 (---------------)  + I xn--pssy2u
	0x0037b6cb, // n0x05d6 c0x0000 (---------------)  + I xn--q9jyb4c
	0x0037cc4c, // n0x05d7 c0x0000 (---------------)  + I xn--qcka1pmc
	0x0037d688, // n0x05d8 c0x0000 (---------------)  + I xn--qxam
	0x0038118b, // n0x05d9 c0x0000 (---------------)  + I xn--rhqv96g
	0x0038390b, // n0x05da c0x0000 (---------------)  + I xn--rovu88b
	0x00386f0b, // n0x05db c0x0000 (---------------)  + I xn--s9brj9c
	0x0038860b, // n0x05dc c0x0000 (---------------)  + I xn--ses554g
	0x0039140b, // n0x05dd c0x0000 (---------------)  + I xn--t60b56a
	0x003916c9, // n0x05de c0x0000 (---------------)  + I xn--tckwe
	0x00391c0d, // n0x05df c0x0000 (---------------)  + I xn--tiq49xqyj
	0x0039654a, // n0x05e0 c0x0000 (---------------)  + I xn--unup4y
	0x00397497, // n0x05e1 c0x0000 (---------------)  + I xn--vermgensberater-ctb
	0x003982d8, // n0x05e2 c0x0000 (---------------)  + I xn--vermgensberatung-pwb
	0x0039a849, // n0x05e3 c0x0000 (---------------)  + I xn--vhquv
	0x0039ba4b, // n0x05e4 c0x0000 (---------------)  + I xn--vuq861b
	0x0039c814, // n0x05e5 c0x0000 (---------------)  + I xn--w4r85el8fhu5dnra
	0x0039cd0b, // n0x05e6 c0x0000 (---------------)  + I xn--w4rs40l
	0x0039d28a, // n0x05e7 c0x0000 (---------------)  + I xn--wgbh1c
	0x0039d84a, // n0x05e8 c0x0000 (---------------)  + I xn--wgbl6a
	0x0039dacb, // n0x05e9 c0x0000 (---------------)  + I xn--xhq521b
	0x003a1450, // n0x05ea c0x0000 (---------------)  + I xn--xkc2al3hye2a
	0x003a1851, // n0x05eb c0x0000 (---------------)  + I xn--xkc2dl3a5ee0h
	0x003a210a, // n0x05ec c0x0000 (---------------)  + I xn--y9a3aq
	0x003a2d4d, // n0x05ed c0x0000 (---------------)  + I xn--yfro4i67o
	0x003a344d, // n0x05ee c0x0000 (---------------)  + I xn--ygbi2ammx
	0x003a5dcb, // n0x05ef c0x0000 (---------------)  + I xn--zfr164b
	0x003a6b46, // n0x05f0 c0x0000 (---------------)  + I xperia
	0x00230983, // n0x05f1 c0x0000 (---------------)  + I xxx
	0x00247683, // n0x05f2 c0x0000 (---------------)  + I xyz
	0x00307e86, // n0x05f3 c0x0000 (---------------)  + I yachts
	0x0028d645, // n0x05f4 c0x0000 (---------------)  + I yahoo
	0x002c7947, // n0x05f5 c0x0000 (---------------)  + I yamaxun
	0x00339946, // n0x05f6 c0x0000 (---------------)  + I yandex
	0x01608242, // n0x05f7 c0x0005 (---------------)* o I ye
	0x003710c9, // n0x05f8 c0x0000 (---------------)  + I yodobashi
	0x003559c4, // n0x05f9 c0x0000 (---------------)  + I yoga
	0x002d09c8, // n0x05fa c0x0000 (---------------)  + I yokohama
	0x0024b0c3, // n0x05fb c0x0000 (---------------)  + I you
	0x002e4807, // n0x05fc c0x0000 (---------------)  + I youtube
	0x00244002, // n0x05fd c0x0000 (---------------)  + I yt
	0x002ac203, // n0x05fe c0x0000 (---------------)  + I yun
	0x66205f82, // n0x05ff c0x0198 (n0x1ebd-n0x1ece)  o I za
	0x002c3fc6, // n0x0600 c0x0000 (---------------)  + I zappos
	0x002c4d04, // n0x0601 c0x0000 (---------------)  + I zara
	0x002eb584, // n0x0602 c0x0000 (---------------)  + I zero
	0x002432c3, // n0x0603 c0x0000 (---------------)  + I zip
	0x002432c5, // n0x0604 c0x0000 (---------------)  + I zippo
	0x01700d02, // n0x0605 c0x0005 (---------------)* o I zm
	0x002dce04, // n0x0606 c0x0000 (---------------)  + I zone
	0x00273947, // n0x0607 c0x0000 (---------------)  + I zuerich
	0x016afdc2, // n0x0608 c0x0005 (---------------)* o I zw
	0x00233503, // n0x0609 c0x0000 (---------------)  + I com
	0x0023a783, // n0x060a c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x060b c0x0000 (---------------)  + I gov
	0x00209003, // n0x060c c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x060d c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x060e c0x0000 (---------------)  + I org
	0x00201483, // n0x060f c0x0000 (---------------)  + I nom
	0x00201542, // n0x0610 c0x0000 (---------------)  + I ac
	0x000ffa08, // n0x0611 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x0612 c0x0000 (---------------)  + I co
	0x0026cc83, // n0x0613 c0x0000 (---------------)  + I gov
	0x00209003, // n0x0614 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x0615 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0616 c0x0000 (---------------)  + I org
	0x00217443, // n0x0617 c0x0000 (---------------)  + I sch
	0x00316196, // n0x0618 c0x0000 (---------------)  + I accident-investigation
	0x00317cd3, // n0x0619 c0x0000 (---------------)  + I accident-prevention
	0x002f66c9, // n0x061a c0x0000 (---------------)  + I aerobatic
	0x002389c8, // n0x061b c0x0000 (---------------)  + I aeroclub
	0x002dd449, // n0x061c c0x0000 (---------------)  + I aerodrome
	0x002fbe86, // n0x061d c0x0000 (---------------)  + I agents
	0x0030c790, // n0x061e c0x0000 (---------------)  + I air-surveillance
	0x00358d93, // n0x061f c0x0000 (---------------)  + I air-traffic-control
	0x00204908, // n0x0620 c0x0000 (---------------)  + I aircraft
	0x002d7e07, // n0x0621 c0x0000 (---------------)  + I airline
	0x002793c7, // n0x0622 c0x0000 (---------------)  + I airport
	0x0021868a, // n0x0623 c0x0000 (---------------)  + I airtraffic
	0x002c8609, // n0x0624 c0x0000 (---------------)  + I ambulance
	0x0037d809, // n0x0625 c0x0000 (---------------)  + I amusement
	0x002d488b, // n0x0626 c0x0000 (---------------)  + I association
	0x0031a686, // n0x0627 c0x0000 (---------------)  + I author
	0x0022faca, // n0x0628 c0x0000 (---------------)  + I ballooning
	0x00220c46, // n0x0629 c0x0000 (---------------)  + I broker
	0x003555c3, // n0x062a c0x0000 (---------------)  + I caa
	0x002e9b05, // n0x062b c0x0000 (---------------)  + I cargo
	0x00351008, // n0x062c c0x0000 (---------------)  + I catering
	0x003257cd, // n0x062d c0x0000 (---------------)  + I certification
	0x0035894c, // n0x062e c0x0000 (---------------)  + I championship
	0x00320347, // n0x062f c0x0000 (---------------)  + I charter
	0x0035b70d, // n0x0630 c0x0000 (---------------)  + I civilaviation
	0x00238ac4, // n0x0631 c0x0000 (---------------)  + I club
	0x00236cca, // n0x0632 c0x0000 (---------------)  + I conference
	0x0023784a, // n0x0633 c0x0000 (---------------)  + I consultant
	0x00237d0a, // n0x0634 c0x0000 (---------------)  + I consulting
	0x00308c87, // n0x0635 c0x0000 (---------------)  + I control
	0x00242207, // n0x0636 c0x0000 (---------------)  + I council
	0x00245184, // n0x0637 c0x0000 (---------------)  + I crew
	0x0022dcc6, // n0x0638 c0x0000 (---------------)  + I design
	0x00356f44, // n0x0639 c0x0000 (---------------)  + I dgca
	0x002fe188, // n0x063a c0x0000 (---------------)  + I educator
	0x00322189, // n0x063b c0x0000 (---------------)  + I emergency
	0x00369146, // n0x063c c0x0000 (---------------)  + I engine
	0x00369148, // n0x063d c0x0000 (---------------)  + I engineer
	0x00247acd, // n0x063e c0x0000 (---------------)  + I entertainment
	0x002c2709, // n0x063f c0x0000 (---------------)  + I equipment
	0x00239488, // n0x0640 c0x0000 (---------------)  + I exchange
	0x00247487, // n0x0641 c0x0000 (---------------)  + I express
	0x0030eeca, // n0x0642 c0x0000 (---------------)  + I federation
	0x00251286, // n0x0643 c0x0000 (---------------)  + I flight
	0x0025cf87, // n0x0644 c0x0000 (---------------)  + I freight
	0x00240d04, // n0x0645 c0x0000 (---------------)  + I fuel
	0x0026e307, // n0x0646 c0x0000 (---------------)  + I gliding
	0x0026cc8a, // n0x0647 c0x0000 (---------------)  + I government
	0x0031240e, // n0x0648 c0x0000 (---------------)  + I groundhandling
	0x0020ab45, // n0x0649 c0x0000 (---------------)  + I group
	0x002ff10b, // n0x064a c0x0000 (---------------)  + I hanggliding
	0x002e9e49, // n0x064b c0x0000 (---------------)  + I homebuilt
	0x0023e7c9, // n0x064c c0x0000 (---------------)  + I insurance
	0x0033be47, // n0x064d c0x0000 (---------------)  + I journal
	0x0038e60a, // n0x064e c0x0000 (---------------)  + I journalist
	0x00285c07, // n0x064f c0x0000 (---------------)  + I leasing
	0x002e2d49, // n0x0650 c0x0000 (---------------)  + I logistics
	0x00395fc8, // n0x0651 c0x0000 (---------------)  + I magazine
	0x0027634b, // n0x0652 c0x0000 (---------------)  + I maintenance
	0x003025c5, // n0x0653 c0x0000 (---------------)  + I media
	0x0031210a, // n0x0654 c0x0000 (---------------)  + I microlight
	0x002a3209, // n0x0655 c0x0000 (---------------)  + I modelling
	0x00319f8a, // n0x0656 c0x0000 (---------------)  + I navigation
	0x002c530b, // n0x0657 c0x0000 (---------------)  + I parachuting
	0x0026e20b, // n0x0658 c0x0000 (---------------)  + I paragliding
	0x002d4615, // n0x0659 c0x0000 (---------------)  + I passenger-association
	0x002d6505, // n0x065a c0x0000 (---------------)  + I pilot
	0x00247505, // n0x065b c0x0000 (---------------)  + I press
	0x002e204a, // n0x065c c0x0000 (---------------)  + I production
	0x00336aca, // n0x065d c0x0000 (---------------)  + I recreation
	0x002fae47, // n0x065e c0x0000 (---------------)  + I repbody
	0x0021d683, // n0x065f c0x0000 (---------------)  + I res
	0x0029fa08, // n0x0660 c0x0000 (---------------)  + I research
	0x002ce74a, // n0x0661 c0x0000 (---------------)  + I rotorcraft
	0x00215946, // n0x0662 c0x0000 (---------------)  + I safety
	0x002466c9, // n0x0663 c0x0000 (---------------)  + I scientist
	0x00206808, // n0x0664 c0x0000 (---------------)  + I services
	0x002c4484, // n0x0665 c0x0000 (---------------)  + I show
	0x0027d709, // n0x0666 c0x0000 (---------------)  + I skydiving
	0x002b8688, // n0x0667 c0x0000 (---------------)  + I software
	0x002abd47, // n0x0668 c0x0000 (---------------)  + I student
	0x002673c6, // n0x0669 c0x0000 (---------------)  + I trader
	0x002a4607, // n0x066a c0x0000 (---------------)  + I trading
	0x00295207, // n0x066b c0x0000 (---------------)  + I trainer
	0x00244bc5, // n0x066c c0x0000 (---------------)  + I union
	0x002dbd0c, // n0x066d c0x0000 (---------------)  + I workinggroup
	0x00351f05, // n0x066e c0x0000 (---------------)  + I works
	0x00233503, // n0x066f c0x0000 (---------------)  + I com
	0x0023a783, // n0x0670 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0671 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x0672 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0673 c0x0000 (---------------)  + I org
	0x00200742, // n0x0674 c0x0000 (---------------)  + I co
	0x00233503, // n0x0675 c0x0000 (---------------)  + I com
	0x0021fe03, // n0x0676 c0x0000 (---------------)  + I net
	0x00201483, // n0x0677 c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x0678 c0x0000 (---------------)  + I org
	0x00233503, // n0x0679 c0x0000 (---------------)  + I com
	0x0021fe03, // n0x067a c0x0000 (---------------)  + I net
	0x0020b283, // n0x067b c0x0000 (---------------)  + I off
	0x0022d1c3, // n0x067c c0x0000 (---------------)  + I org
	0x000ffa08, // n0x067d c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x067e c0x0000 (---------------)  + I com
	0x0023a783, // n0x067f c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0680 c0x0000 (---------------)  + I gov
	0x00209003, // n0x0681 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x0682 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0683 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x0684 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x0685 c0x0000 (---------------)  + I co
	0x00202602, // n0x0686 c0x0000 (---------------)  + I ed
	0x00237f42, // n0x0687 c0x0000 (---------------)  + I gv
	0x00201e42, // n0x0688 c0x0000 (---------------)  + I it
	0x00200c42, // n0x0689 c0x0000 (---------------)  + I og
	0x002718c2, // n0x068a c0x0000 (---------------)  + I pb
	0x04633503, // n0x068b c0x0011 (n0x0694-n0x0695)  + I com
	0x0023a783, // n0x068c c0x0000 (---------------)  + I edu
	0x00213183, // n0x068d c0x0000 (---------------)  + I gob
	0x0026cc83, // n0x068e c0x0000 (---------------)  + I gov
	0x00201603, // n0x068f c0x0000 (---------------)  + I int
	0x00209003, // n0x0690 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x0691 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0692 c0x0000 (---------------)  + I org
	0x00209e43, // n0x0693 c0x0000 (---------------)  + I tur
	0x000ffa08, // n0x0694 c0x0000 (---------------)  +   blogspot
	0x00255704, // n0x0695 c0x0000 (---------------)  + I e164
	0x002edc07, // n0x0696 c0x0000 (---------------)  + I in-addr
	0x00215dc3, // n0x0697 c0x0000 (---------------)  + I ip6
	0x00238804, // n0x0698 c0x0000 (---------------)  + I iris
	0x0020dd83, // n0x0699 c0x0000 (---------------)  + I uri
	0x00285383, // n0x069a c0x0000 (---------------)  + I urn
	0x0026cc83, // n0x069b c0x0000 (---------------)  + I gov
	0x00201542, // n0x069c c0x0000 (---------------)  + I ac
	0x00130b83, // n0x069d c0x0000 (---------------)  +   biz
	0x05600742, // n0x069e c0x0015 (n0x06a3-n0x06a4)  + I co
	0x00237f42, // n0x069f c0x0000 (---------------)  + I gv
	0x001a1244, // n0x06a0 c0x0000 (---------------)  +   info
	0x00200282, // n0x06a1 c0x0000 (---------------)  + I or
	0x000e1c44, // n0x06a2 c0x0000 (---------------)  +   priv
	0x000ffa08, // n0x06a3 c0x0000 (---------------)  +   blogspot
	0x00239a03, // n0x06a4 c0x0000 (---------------)  + I act
	0x002afc83, // n0x06a5 c0x0000 (---------------)  + I asn
	0x05e33503, // n0x06a6 c0x0017 (n0x06b6-n0x06b7)  + I com
	0x00236cc4, // n0x06a7 c0x0000 (---------------)  + I conf
	0x0623a783, // n0x06a8 c0x0018 (n0x06b7-n0x06bf)  + I edu
	0x0666cc83, // n0x06a9 c0x0019 (n0x06bf-n0x06c4)  + I gov
	0x0020c782, // n0x06aa c0x0000 (---------------)  + I id
	0x003a1244, // n0x06ab c0x0000 (---------------)  + I info
	0x0021fe03, // n0x06ac c0x0000 (---------------)  + I net
	0x002f09c3, // n0x06ad c0x0000 (---------------)  + I nsw
	0x002009c2, // n0x06ae c0x0000 (---------------)  + I nt
	0x0022d1c3, // n0x06af c0x0000 (---------------)  + I org
	0x0021c142, // n0x06b0 c0x0000 (---------------)  + I oz
	0x002e6383, // n0x06b1 c0x0000 (---------------)  + I qld
	0x002004c2, // n0x06b2 c0x0000 (---------------)  + I sa
	0x00201e83, // n0x06b3 c0x0000 (---------------)  + I tas
	0x002068c3, // n0x06b4 c0x0000 (---------------)  + I vic
	0x002010c2, // n0x06b5 c0x0000 (---------------)  + I wa
	0x000ffa08, // n0x06b6 c0x0000 (---------------)  +   blogspot
	0x00239a03, // n0x06b7 c0x0000 (---------------)  + I act
	0x002f09c3, // n0x06b8 c0x0000 (---------------)  + I nsw
	0x002009c2, // n0x06b9 c0x0000 (---------------)  + I nt
	0x002e6383, // n0x06ba c0x0000 (---------------)  + I qld
	0x002004c2, // n0x06bb c0x0000 (---------------)  + I sa
	0x00201e83, // n0x06bc c0x0000 (---------------)  + I tas
	0x002068c3, // n0x06bd c0x0000 (---------------)  + I vic
	0x002010c2, // n0x06be c0x0000 (---------------)  + I wa
	0x002e6383, // n0x06bf c0x0000 (---------------)  + I qld
	0x002004c2, // n0x06c0 c0x0000 (---------------)  + I sa
	0x00201e83, // n0x06c1 c0x0000 (---------------)  + I tas
	0x002068c3, // n0x06c2 c0x0000 (---------------)  + I vic
	0x002010c2, // n0x06c3 c0x0000 (---------------)  + I wa
	0x00233503, // n0x06c4 c0x0000 (---------------)  + I com
	0x00330b83, // n0x06c5 c0x0000 (---------------)  + I biz
	0x00233503, // n0x06c6 c0x0000 (---------------)  + I com
	0x0023a783, // n0x06c7 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x06c8 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x06c9 c0x0000 (---------------)  + I info
	0x00201603, // n0x06ca c0x0000 (---------------)  + I int
	0x00209003, // n0x06cb c0x0000 (---------------)  + I mil
	0x00205284, // n0x06cc c0x0000 (---------------)  + I name
	0x0021fe03, // n0x06cd c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x06ce c0x0000 (---------------)  + I org
	0x00209302, // n0x06cf c0x0000 (---------------)  + I pp
	0x00220e43, // n0x06d0 c0x0000 (---------------)  + I pro
	0x000ffa08, // n0x06d1 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x06d2 c0x0000 (---------------)  + I co
	0x00233503, // n0x06d3 c0x0000 (---------------)  + I com
	0x0023a783, // n0x06d4 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x06d5 c0x0000 (---------------)  + I gov
	0x00209003, // n0x06d6 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x06d7 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x06d8 c0x0000 (---------------)  + I org
	0x00209702, // n0x06d9 c0x0000 (---------------)  + I rs
	0x002d8144, // n0x06da c0x0000 (---------------)  + I unbi
	0x003a6844, // n0x06db c0x0000 (---------------)  + I unsa
	0x00330b83, // n0x06dc c0x0000 (---------------)  + I biz
	0x00200742, // n0x06dd c0x0000 (---------------)  + I co
	0x00233503, // n0x06de c0x0000 (---------------)  + I com
	0x0023a783, // n0x06df c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x06e0 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x06e1 c0x0000 (---------------)  + I info
	0x0021fe03, // n0x06e2 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x06e3 c0x0000 (---------------)  + I org
	0x00391185, // n0x06e4 c0x0000 (---------------)  + I store
	0x00224e42, // n0x06e5 c0x0000 (---------------)  + I tv
	0x00201542, // n0x06e6 c0x0000 (---------------)  + I ac
	0x000ffa08, // n0x06e7 c0x0000 (---------------)  +   blogspot
	0x0026cc83, // n0x06e8 c0x0000 (---------------)  + I gov
	0x0025c3c1, // n0x06e9 c0x0000 (---------------)  + I 0
	0x0022a0c1, // n0x06ea c0x0000 (---------------)  + I 1
	0x002484c1, // n0x06eb c0x0000 (---------------)  + I 2
	0x00231a01, // n0x06ec c0x0000 (---------------)  + I 3
	0x00231981, // n0x06ed c0x0000 (---------------)  + I 4
	0x002736c1, // n0x06ee c0x0000 (---------------)  + I 5
	0x00215e41, // n0x06ef c0x0000 (---------------)  + I 6
	0x0023e381, // n0x06f0 c0x0000 (---------------)  + I 7
	0x002f2a41, // n0x06f1 c0x0000 (---------------)  + I 8
	0x00301241, // n0x06f2 c0x0000 (---------------)  + I 9
	0x00200101, // n0x06f3 c0x0000 (---------------)  + I a
	0x00200001, // n0x06f4 c0x0000 (---------------)  + I b
	0x000ffa08, // n0x06f5 c0x0000 (---------------)  +   blogspot
	0x00200301, // n0x06f6 c0x0000 (---------------)  + I c
	0x00200381, // n0x06f7 c0x0000 (---------------)  + I d
	0x00200081, // n0x06f8 c0x0000 (---------------)  + I e
	0x00200581, // n0x06f9 c0x0000 (---------------)  + I f
	0x00200c81, // n0x06fa c0x0000 (---------------)  + I g
	0x00200d81, // n0x06fb c0x0000 (---------------)  + I h
	0x00200041, // n0x06fc c0x0000 (---------------)  + I i
	0x00201741, // n0x06fd c0x0000 (---------------)  + I j
	0x00200fc1, // n0x06fe c0x0000 (---------------)  + I k
	0x00200201, // n0x06ff c0x0000 (---------------)  + I l
	0x00200181, // n0x0700 c0x0000 (---------------)  + I m
	0x00200541, // n0x0701 c0x0000 (---------------)  + I n
	0x00200281, // n0x0702 c0x0000 (---------------)  + I o
	0x00200941, // n0x0703 c0x0000 (---------------)  + I p
	0x00200401, // n0x0704 c0x0000 (---------------)  + I q
	0x002002c1, // n0x0705 c0x0000 (---------------)  + I r
	0x002004c1, // n0x0706 c0x0000 (---------------)  + I s
	0x00200141, // n0x0707 c0x0000 (---------------)  + I t
	0x00200441, // n0x0708 c0x0000 (---------------)  + I u
	0x002000c1, // n0x0709 c0x0000 (---------------)  + I v
	0x002010c1, // n0x070a c0x0000 (---------------)  + I w
	0x00205381, // n0x070b c0x0000 (---------------)  + I x
	0x00201841, // n0x070c c0x0000 (---------------)  + I y
	0x00205f81, // n0x070d c0x0000 (---------------)  + I z
	0x00233503, // n0x070e c0x0000 (---------------)  + I com
	0x0023a783, // n0x070f c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0710 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x0711 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0712 c0x0000 (---------------)  + I org
	0x00200742, // n0x0713 c0x0000 (---------------)  + I co
	0x00233503, // n0x0714 c0x0000 (---------------)  + I com
	0x0023a783, // n0x0715 c0x0000 (---------------)  + I edu
	0x00200282, // n0x0716 c0x0000 (---------------)  + I or
	0x0022d1c3, // n0x0717 c0x0000 (---------------)  + I org
	0x00009107, // n0x0718 c0x0000 (---------------)  +   dscloud
	0x00013886, // n0x0719 c0x0000 (---------------)  +   dyndns
	0x00055e8a, // n0x071a c0x0000 (---------------)  +   for-better
	0x00087d88, // n0x071b c0x0000 (---------------)  +   for-more
	0x00056488, // n0x071c c0x0000 (---------------)  +   for-some
	0x000572c7, // n0x071d c0x0000 (---------------)  +   for-the
	0x0006ba86, // n0x071e c0x0000 (---------------)  +   selfip
	0x000eadc6, // n0x071f c0x0000 (---------------)  +   webhop
	0x002d4884, // n0x0720 c0x0000 (---------------)  + I asso
	0x00319cc7, // n0x0721 c0x0000 (---------------)  + I barreau
	0x000ffa08, // n0x0722 c0x0000 (---------------)  +   blogspot
	0x0033d7c4, // n0x0723 c0x0000 (---------------)  + I gouv
	0x00233503, // n0x0724 c0x0000 (---------------)  + I com
	0x0023a783, // n0x0725 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0726 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x0727 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0728 c0x0000 (---------------)  + I org
	0x00233503, // n0x0729 c0x0000 (---------------)  + I com
	0x0023a783, // n0x072a c0x0000 (---------------)  + I edu
	0x00213183, // n0x072b c0x0000 (---------------)  + I gob
	0x0026cc83, // n0x072c c0x0000 (---------------)  + I gov
	0x00201603, // n0x072d c0x0000 (---------------)  + I int
	0x00209003, // n0x072e c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x072f c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0730 c0x0000 (---------------)  + I org
	0x00224e42, // n0x0731 c0x0000 (---------------)  + I tv
	0x002c3503, // n0x0732 c0x0000 (---------------)  + I adm
	0x002f4fc3, // n0x0733 c0x0000 (---------------)  + I adv
	0x00209c83, // n0x0734 c0x0000 (---------------)  + I agr
	0x00201882, // n0x0735 c0x0000 (---------------)  + I am
	0x0024f183, // n0x0736 c0x0000 (---------------)  + I arq
	0x002011c3, // n0x0737 c0x0000 (---------------)  + I art
	0x00217b03, // n0x0738 c0x0000 (---------------)  + I ato
	0x00200001, // n0x0739 c0x0000 (---------------)  + I b
	0x00203a03, // n0x073a c0x0000 (---------------)  + I bio
	0x002a4004, // n0x073b c0x0000 (---------------)  + I blog
	0x00321f43, // n0x073c c0x0000 (---------------)  + I bmd
	0x0025ee03, // n0x073d c0x0000 (---------------)  + I cim
	0x0021ba43, // n0x073e c0x0000 (---------------)  + I cng
	0x00231603, // n0x073f c0x0000 (---------------)  + I cnt
	0x0a233503, // n0x0740 c0x0028 (n0x0778-n0x0779)  + I com
	0x0023d684, // n0x0741 c0x0000 (---------------)  + I coop
	0x0021ba03, // n0x0742 c0x0000 (---------------)  + I ecn
	0x0020b203, // n0x0743 c0x0000 (---------------)  + I eco
	0x0023a783, // n0x0744 c0x0000 (---------------)  + I edu
	0x0023a4c3, // n0x0745 c0x0000 (---------------)  + I emp
	0x00213703, // n0x0746 c0x0000 (---------------)  + I eng
	0x0029bdc3, // n0x0747 c0x0000 (---------------)  + I esp
	0x0025ed83, // n0x0748 c0x0000 (---------------)  + I etc
	0x002234c3, // n0x0749 c0x0000 (---------------)  + I eti
	0x00212983, // n0x074a c0x0000 (---------------)  + I far
	0x002522c4, // n0x074b c0x0000 (---------------)  + I flog
	0x00242902, // n0x074c c0x0000 (---------------)  + I fm
	0x00255803, // n0x074d c0x0000 (---------------)  + I fnd
	0x0025bb03, // n0x074e c0x0000 (---------------)  + I fot
	0x00277703, // n0x074f c0x0000 (---------------)  + I fst
	0x002ee4c3, // n0x0750 c0x0000 (---------------)  + I g12
	0x002ece03, // n0x0751 c0x0000 (---------------)  + I ggf
	0x0026cc83, // n0x0752 c0x0000 (---------------)  + I gov
	0x002cc783, // n0x0753 c0x0000 (---------------)  + I imb
	0x0021d883, // n0x0754 c0x0000 (---------------)  + I ind
	0x003a1083, // n0x0755 c0x0000 (---------------)  + I inf
	0x00215b43, // n0x0756 c0x0000 (---------------)  + I jor
	0x002f3143, // n0x0757 c0x0000 (---------------)  + I jus
	0x0022e283, // n0x0758 c0x0000 (---------------)  + I leg
	0x002d08c3, // n0x0759 c0x0000 (---------------)  + I lel
	0x0021f803, // n0x075a c0x0000 (---------------)  + I mat
	0x00213ac3, // n0x075b c0x0000 (---------------)  + I med
	0x00209003, // n0x075c c0x0000 (---------------)  + I mil
	0x0022a482, // n0x075d c0x0000 (---------------)  + I mp
	0x00283a83, // n0x075e c0x0000 (---------------)  + I mus
	0x0021fe03, // n0x075f c0x0000 (---------------)  + I net
	0x01601483, // n0x0760 c0x0005 (---------------)* o I nom
	0x002547c3, // n0x0761 c0x0000 (---------------)  + I not
	0x0023b443, // n0x0762 c0x0000 (---------------)  + I ntr
	0x00213243, // n0x0763 c0x0000 (---------------)  + I odo
	0x0022d1c3, // n0x0764 c0x0000 (---------------)  + I org
	0x00249583, // n0x0765 c0x0000 (---------------)  + I ppg
	0x00220e43, // n0x0766 c0x0000 (---------------)  + I pro
	0x0023d083, // n0x0767 c0x0000 (---------------)  + I psc
	0x002f7b43, // n0x0768 c0x0000 (---------------)  + I psi
	0x002e6543, // n0x0769 c0x0000 (---------------)  + I qsl
	0x00264b85, // n0x076a c0x0000 (---------------)  + I radio
	0x0022a5c3, // n0x076b c0x0000 (---------------)  + I rec
	0x002e6583, // n0x076c c0x0000 (---------------)  + I slg
	0x0035ca03, // n0x076d c0x0000 (---------------)  + I srv
	0x002203c4, // n0x076e c0x0000 (---------------)  + I taxi
	0x00336843, // n0x076f c0x0000 (---------------)  + I teo
	0x00239f83, // n0x0770 c0x0000 (---------------)  + I tmp
	0x002a9803, // n0x0771 c0x0000 (---------------)  + I trd
	0x00209e43, // n0x0772 c0x0000 (---------------)  + I tur
	0x00224e42, // n0x0773 c0x0000 (---------------)  + I tv
	0x0023f943, // n0x0774 c0x0000 (---------------)  + I vet
	0x002fa5c4, // n0x0775 c0x0000 (---------------)  + I vlog
	0x0037c484, // n0x0776 c0x0000 (---------------)  + I wiki
	0x002645c3, // n0x0777 c0x0000 (---------------)  + I zlg
	0x000ffa08, // n0x0778 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x0779 c0x0000 (---------------)  + I com
	0x0023a783, // n0x077a c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x077b c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x077c c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x077d c0x0000 (---------------)  + I org
	0x00233503, // n0x077e c0x0000 (---------------)  + I com
	0x0023a783, // n0x077f c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0780 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x0781 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0782 c0x0000 (---------------)  + I org
	0x00200742, // n0x0783 c0x0000 (---------------)  + I co
	0x0022d1c3, // n0x0784 c0x0000 (---------------)  + I org
	0x0b633503, // n0x0785 c0x002d (n0x0789-n0x078a)  + I com
	0x0026cc83, // n0x0786 c0x0000 (---------------)  + I gov
	0x00209003, // n0x0787 c0x0000 (---------------)  + I mil
	0x0020b282, // n0x0788 c0x0000 (---------------)  + I of
	0x000ffa08, // n0x0789 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x078a c0x0000 (---------------)  + I com
	0x0023a783, // n0x078b c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x078c c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x078d c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x078e c0x0000 (---------------)  + I org
	0x00005f82, // n0x078f c0x0000 (---------------)  +   za
	0x002020c2, // n0x0790 c0x0000 (---------------)  + I ab
	0x00221a82, // n0x0791 c0x0000 (---------------)  + I bc
	0x000ffa08, // n0x0792 c0x0000 (---------------)  +   blogspot
	0x00000742, // n0x0793 c0x0000 (---------------)  +   co
	0x0023c3c2, // n0x0794 c0x0000 (---------------)  + I gc
	0x00208602, // n0x0795 c0x0000 (---------------)  + I mb
	0x00215102, // n0x0796 c0x0000 (---------------)  + I nb
	0x00200542, // n0x0797 c0x0000 (---------------)  + I nf
	0x00247802, // n0x0798 c0x0000 (---------------)  + I nl
	0x00210c42, // n0x0799 c0x0000 (---------------)  + I ns
	0x002009c2, // n0x079a c0x0000 (---------------)  + I nt
	0x002017c2, // n0x079b c0x0000 (---------------)  + I nu
	0x00200982, // n0x079c c0x0000 (---------------)  + I on
	0x00207782, // n0x079d c0x0000 (---------------)  + I pe
	0x0037cd42, // n0x079e c0x0000 (---------------)  + I qc
	0x00207842, // n0x079f c0x0000 (---------------)  + I sk
	0x00226f42, // n0x07a0 c0x0000 (---------------)  + I yk
	0x00146449, // n0x07a1 c0x0000 (---------------)  +   ftpaccess
	0x00173f0b, // n0x07a2 c0x0000 (---------------)  +   game-server
	0x000d1148, // n0x07a3 c0x0000 (---------------)  +   myphotos
	0x00143a09, // n0x07a4 c0x0000 (---------------)  +   scrapping
	0x0026cc83, // n0x07a5 c0x0000 (---------------)  + I gov
	0x000ffa08, // n0x07a6 c0x0000 (---------------)  +   blogspot
	0x000ffa08, // n0x07a7 c0x0000 (---------------)  +   blogspot
	0x00201542, // n0x07a8 c0x0000 (---------------)  + I ac
	0x002d4884, // n0x07a9 c0x0000 (---------------)  + I asso
	0x00200742, // n0x07aa c0x0000 (---------------)  + I co
	0x00233503, // n0x07ab c0x0000 (---------------)  + I com
	0x00202602, // n0x07ac c0x0000 (---------------)  + I ed
	0x0023a783, // n0x07ad c0x0000 (---------------)  + I edu
	0x00202d42, // n0x07ae c0x0000 (---------------)  + I go
	0x0033d7c4, // n0x07af c0x0000 (---------------)  + I gouv
	0x00201603, // n0x07b0 c0x0000 (---------------)  + I int
	0x0024da82, // n0x07b1 c0x0000 (---------------)  + I md
	0x0021fe03, // n0x07b2 c0x0000 (---------------)  + I net
	0x00200282, // n0x07b3 c0x0000 (---------------)  + I or
	0x0022d1c3, // n0x07b4 c0x0000 (---------------)  + I org
	0x00247506, // n0x07b5 c0x0000 (---------------)  + I presse
	0x0030dc0f, // n0x07b6 c0x0000 (---------------)  + I xn--aroport-bya
	0x00700b03, // n0x07b7 c0x0001 (---------------)  ! I www
	0x000ffa08, // n0x07b8 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x07b9 c0x0000 (---------------)  + I co
	0x00213183, // n0x07ba c0x0000 (---------------)  + I gob
	0x0026cc83, // n0x07bb c0x0000 (---------------)  + I gov
	0x00209003, // n0x07bc c0x0000 (---------------)  + I mil
	0x00200742, // n0x07bd c0x0000 (---------------)  + I co
	0x00233503, // n0x07be c0x0000 (---------------)  + I com
	0x0026cc83, // n0x07bf c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x07c0 c0x0000 (---------------)  + I net
	0x00201542, // n0x07c1 c0x0000 (---------------)  + I ac
	0x00204f02, // n0x07c2 c0x0000 (---------------)  + I ah
	0x0e6f6409, // n0x07c3 c0x0039 (n0x07ee-n0x07ef)  o I amazonaws
	0x00206502, // n0x07c4 c0x0000 (---------------)  + I bj
	0x0ee33503, // n0x07c5 c0x003b (n0x07f0-n0x07f1)  + I com
	0x00243b42, // n0x07c6 c0x0000 (---------------)  + I cq
	0x0023a783, // n0x07c7 c0x0000 (---------------)  + I edu
	0x00215b02, // n0x07c8 c0x0000 (---------------)  + I fj
	0x00222d42, // n0x07c9 c0x0000 (---------------)  + I gd
	0x0026cc83, // n0x07ca c0x0000 (---------------)  + I gov
	0x0023a242, // n0x07cb c0x0000 (---------------)  + I gs
	0x00260202, // n0x07cc c0x0000 (---------------)  + I gx
	0x00264642, // n0x07cd c0x0000 (---------------)  + I gz
	0x00202442, // n0x07ce c0x0000 (---------------)  + I ha
	0x0028c342, // n0x07cf c0x0000 (---------------)  + I hb
	0x002073c2, // n0x07d0 c0x0000 (---------------)  + I he
	0x00200d82, // n0x07d1 c0x0000 (---------------)  + I hi
	0x0020a882, // n0x07d2 c0x0000 (---------------)  + I hk
	0x00248fc2, // n0x07d3 c0x0000 (---------------)  + I hl
	0x0021ab42, // n0x07d4 c0x0000 (---------------)  + I hn
	0x002ac642, // n0x07d5 c0x0000 (---------------)  + I jl
	0x00251742, // n0x07d6 c0x0000 (---------------)  + I js
	0x00313402, // n0x07d7 c0x0000 (---------------)  + I jx
	0x0022e8c2, // n0x07d8 c0x0000 (---------------)  + I ln
	0x00209003, // n0x07d9 c0x0000 (---------------)  + I mil
	0x00207102, // n0x07da c0x0000 (---------------)  + I mo
	0x0021fe03, // n0x07db c0x0000 (---------------)  + I net
	0x0023db02, // n0x07dc c0x0000 (---------------)  + I nm
	0x0026a782, // n0x07dd c0x0000 (---------------)  + I nx
	0x0022d1c3, // n0x07de c0x0000 (---------------)  + I org
	0x0024f202, // n0x07df c0x0000 (---------------)  + I qh
	0x00200702, // n0x07e0 c0x0000 (---------------)  + I sc
	0x002496c2, // n0x07e1 c0x0000 (---------------)  + I sd
	0x00201342, // n0x07e2 c0x0000 (---------------)  + I sh
	0x00214182, // n0x07e3 c0x0000 (---------------)  + I sn
	0x002f2802, // n0x07e4 c0x0000 (---------------)  + I sx
	0x00226782, // n0x07e5 c0x0000 (---------------)  + I tj
	0x0024e502, // n0x07e6 c0x0000 (---------------)  + I tw
	0x0036f4c2, // n0x07e7 c0x0000 (---------------)  + I xj
	0x003029ca, // n0x07e8 c0x0000 (---------------)  + I xn--55qx5d
	0x0034280a, // n0x07e9 c0x0000 (---------------)  + I xn--io0a7i
	0x0037648a, // n0x07ea c0x0000 (---------------)  + I xn--od0alg
	0x003a6cc2, // n0x07eb c0x0000 (---------------)  + I xz
	0x00213642, // n0x07ec c0x0000 (---------------)  + I yn
	0x00247702, // n0x07ed c0x0000 (---------------)  + I zj
	0x0e835247, // n0x07ee c0x003a (n0x07ef-n0x07f0)  +   compute
	0x00039b8a, // n0x07ef c0x0000 (---------------)  +   cn-north-1
	0x0f2f6409, // n0x07f0 c0x003c (n0x07f1-n0x07f2)  o I amazonaws
	0x0f639b8a, // n0x07f1 c0x003d (n0x07f2-n0x07f3)  o I cn-north-1
	0x0004a542, // n0x07f2 c0x0000 (---------------)  +   s3
	0x0024bf84, // n0x07f3 c0x0000 (---------------)  + I arts
	0x0fe33503, // n0x07f4 c0x003f (n0x0800-n0x0801)  + I com
	0x0023a783, // n0x07f5 c0x0000 (---------------)  + I edu
	0x0024d9c4, // n0x07f6 c0x0000 (---------------)  + I firm
	0x0026cc83, // n0x07f7 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x07f8 c0x0000 (---------------)  + I info
	0x00201603, // n0x07f9 c0x0000 (---------------)  + I int
	0x00209003, // n0x07fa c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x07fb c0x0000 (---------------)  + I net
	0x00201483, // n0x07fc c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x07fd c0x0000 (---------------)  + I org
	0x0022a5c3, // n0x07fe c0x0000 (---------------)  + I rec
	0x00221a03, // n0x07ff c0x0000 (---------------)  + I web
	0x000ffa08, // n0x0800 c0x0000 (---------------)  +   blogspot
	0x00131905, // n0x0801 c0x0000 (---------------)  +   1kapp
	0x0010a942, // n0x0802 c0x0000 (---------------)  +   4u
	0x00175846, // n0x0803 c0x0000 (---------------)  +   africa
	0x106f6409, // n0x0804 c0x0041 (n0x08d7-n0x08eb)  o I amazonaws
	0x000092c7, // n0x0805 c0x0000 (---------------)  +   appspot
	0x00000a42, // n0x0806 c0x0000 (---------------)  +   ar
	0x0019bcca, // n0x0807 c0x0000 (---------------)  +   betainabox
	0x000fb147, // n0x0808 c0x0000 (---------------)  +   blogdns
	0x000ffa08, // n0x0809 c0x0000 (---------------)  +   blogspot
	0x0001c402, // n0x080a c0x0000 (---------------)  +   br
	0x001387c7, // n0x080b c0x0000 (---------------)  +   cechire
	0x00194fcf, // n0x080c c0x0000 (---------------)  +   cloudcontrolapp
	0x00108b4f, // n0x080d c0x0000 (---------------)  +   cloudcontrolled
	0x0001ba42, // n0x080e c0x0000 (---------------)  +   cn
	0x00000742, // n0x080f c0x0000 (---------------)  +   co
	0x0009bd08, // n0x0810 c0x0000 (---------------)  +   codespot
	0x00004d82, // n0x0811 c0x0000 (---------------)  +   de
	0x0014c048, // n0x0812 c0x0000 (---------------)  +   dnsalias
	0x0007c9c7, // n0x0813 c0x0000 (---------------)  +   dnsdojo
	0x00014e0b, // n0x0814 c0x0000 (---------------)  +   doesntexist
	0x0016a009, // n0x0815 c0x0000 (---------------)  +   dontexist
	0x0014bf47, // n0x0816 c0x0000 (---------------)  +   doomdns
	0x000f410c, // n0x0817 c0x0000 (---------------)  +   dreamhosters
	0x0008cdc7, // n0x0818 c0x0000 (---------------)  +   dsmynas
	0x0012328a, // n0x0819 c0x0000 (---------------)  +   dyn-o-saur
	0x00197b48, // n0x081a c0x0000 (---------------)  +   dynalias
	0x00073dce, // n0x081b c0x0000 (---------------)  +   dyndns-at-home
	0x000dba8e, // n0x081c c0x0000 (---------------)  +   dyndns-at-work
	0x000faf8b, // n0x081d c0x0000 (---------------)  +   dyndns-blog
	0x000e7b4b, // n0x081e c0x0000 (---------------)  +   dyndns-free
	0x0001388b, // n0x081f c0x0000 (---------------)  +   dyndns-home
	0x00015c09, // n0x0820 c0x0000 (---------------)  +   dyndns-ip
	0x0001b40b, // n0x0821 c0x0000 (---------------)  +   dyndns-mail
	0x000214cd, // n0x0822 c0x0000 (---------------)  +   dyndns-office
	0x0002554b, // n0x0823 c0x0000 (---------------)  +   dyndns-pics
	0x0002698d, // n0x0824 c0x0000 (---------------)  +   dyndns-remote
	0x0002d40d, // n0x0825 c0x0000 (---------------)  +   dyndns-server
	0x0002e48a, // n0x0826 c0x0000 (---------------)  +   dyndns-web
	0x0017c2cb, // n0x0827 c0x0000 (---------------)  +   dyndns-wiki
	0x00151d4b, // n0x0828 c0x0000 (---------------)  +   dyndns-work
	0x0001e810, // n0x0829 c0x0000 (---------------)  +   elasticbeanstalk
	0x0002bb8f, // n0x082a c0x0000 (---------------)  +   est-a-la-maison
	0x0000a14f, // n0x082b c0x0000 (---------------)  +   est-a-la-masion
	0x0015234d, // n0x082c c0x0000 (---------------)  +   est-le-patron
	0x0013c450, // n0x082d c0x0000 (---------------)  +   est-mon-blogueur
	0x00004b82, // n0x082e c0x0000 (---------------)  +   eu
	0x00008f88, // n0x082f c0x0000 (---------------)  +   familyds
	0x11a4e285, // n0x0830 c0x0046 (n0x08f9-n0x08fa)  o I fbsbx
	0x0004c6cb, // n0x0831 c0x0000 (---------------)  +   firebaseapp
	0x000549c8, // n0x0832 c0x0000 (---------------)  +   flynnhub
	0x00063d87, // n0x0833 c0x0000 (---------------)  +   from-ak
	0x000640c7, // n0x0834 c0x0000 (---------------)  +   from-al
	0x00064287, // n0x0835 c0x0000 (---------------)  +   from-ar
	0x00065347, // n0x0836 c0x0000 (---------------)  +   from-ca
	0x00065e07, // n0x0837 c0x0000 (---------------)  +   from-ct
	0x00066587, // n0x0838 c0x0000 (---------------)  +   from-dc
	0x00067007, // n0x0839 c0x0000 (---------------)  +   from-de
	0x00067547, // n0x083a c0x0000 (---------------)  +   from-fl
	0x00067b87, // n0x083b c0x0000 (---------------)  +   from-ga
	0x00067f07, // n0x083c c0x0000 (---------------)  +   from-hi
	0x00068787, // n0x083d c0x0000 (---------------)  +   from-ia
	0x00068947, // n0x083e c0x0000 (---------------)  +   from-id
	0x00068b07, // n0x083f c0x0000 (---------------)  +   from-il
	0x00068cc7, // n0x0840 c0x0000 (---------------)  +   from-in
	0x00068fc7, // n0x0841 c0x0000 (---------------)  +   from-ks
	0x00069ac7, // n0x0842 c0x0000 (---------------)  +   from-ky
	0x0006a5c7, // n0x0843 c0x0000 (---------------)  +   from-ma
	0x0006aa87, // n0x0844 c0x0000 (---------------)  +   from-md
	0x0006b007, // n0x0845 c0x0000 (---------------)  +   from-mi
	0x0006bd87, // n0x0846 c0x0000 (---------------)  +   from-mn
	0x0006bf47, // n0x0847 c0x0000 (---------------)  +   from-mo
	0x0006c247, // n0x0848 c0x0000 (---------------)  +   from-ms
	0x0006c787, // n0x0849 c0x0000 (---------------)  +   from-mt
	0x0006c987, // n0x084a c0x0000 (---------------)  +   from-nc
	0x0006d307, // n0x084b c0x0000 (---------------)  +   from-nd
	0x0006d4c7, // n0x084c c0x0000 (---------------)  +   from-ne
	0x0006d8c7, // n0x084d c0x0000 (---------------)  +   from-nh
	0x0006e007, // n0x084e c0x0000 (---------------)  +   from-nj
	0x0006e4c7, // n0x084f c0x0000 (---------------)  +   from-nm
	0x0006ef87, // n0x0850 c0x0000 (---------------)  +   from-nv
	0x0006f587, // n0x0851 c0x0000 (---------------)  +   from-oh
	0x0006f847, // n0x0852 c0x0000 (---------------)  +   from-ok
	0x0006fbc7, // n0x0853 c0x0000 (---------------)  +   from-or
	0x0006fd87, // n0x0854 c0x0000 (---------------)  +   from-pa
	0x00070107, // n0x0855 c0x0000 (---------------)  +   from-pr
	0x000708c7, // n0x0856 c0x0000 (---------------)  +   from-ri
	0x00070f07, // n0x0857 c0x0000 (---------------)  +   from-sc
	0x00071307, // n0x0858 c0x0000 (---------------)  +   from-sd
	0x00073147, // n0x0859 c0x0000 (---------------)  +   from-tn
	0x00073307, // n0x085a c0x0000 (---------------)  +   from-tx
	0x00073747, // n0x085b c0x0000 (---------------)  +   from-ut
	0x00074607, // n0x085c c0x0000 (---------------)  +   from-va
	0x00074c47, // n0x085d c0x0000 (---------------)  +   from-vt
	0x00074f47, // n0x085e c0x0000 (---------------)  +   from-wa
	0x00075107, // n0x085f c0x0000 (---------------)  +   from-wi
	0x00075487, // n0x0860 c0x0000 (---------------)  +   from-wv
	0x00076607, // n0x0861 c0x0000 (---------------)  +   from-wy
	0x0000d202, // n0x0862 c0x0000 (---------------)  +   gb
	0x000d4487, // n0x0863 c0x0000 (---------------)  +   getmyip
	0x11cca40b, // n0x0864 c0x0047 (n0x08fa-n0x08fd)  +   githubcloud
	0x014ca416, // n0x0865 c0x0005 (---------------)* o   githubcloudusercontent
	0x00019511, // n0x0866 c0x0000 (---------------)  +   githubusercontent
	0x000df54a, // n0x0867 c0x0000 (---------------)  +   googleapis
	0x0009bb8a, // n0x0868 c0x0000 (---------------)  +   googlecode
	0x00057d06, // n0x0869 c0x0000 (---------------)  +   gotdns
	0x00011ecb, // n0x086a c0x0000 (---------------)  +   gotpantheon
	0x00000c82, // n0x086b c0x0000 (---------------)  +   gr
	0x000992c9, // n0x086c c0x0000 (---------------)  +   herokuapp
	0x00091f49, // n0x086d c0x0000 (---------------)  +   herokussl
	0x0000a882, // n0x086e c0x0000 (---------------)  +   hk
	0x0014cfca, // n0x086f c0x0000 (---------------)  +   hobby-site
	0x000a59c9, // n0x0870 c0x0000 (---------------)  +   homelinux
	0x000a6fc8, // n0x0871 c0x0000 (---------------)  +   homeunix
	0x000195c2, // n0x0872 c0x0000 (---------------)  +   hu
	0x00116f89, // n0x0873 c0x0000 (---------------)  +   iamallama
	0x0016d68e, // n0x0874 c0x0000 (---------------)  +   is-a-anarchist
	0x000a3ecc, // n0x0875 c0x0000 (---------------)  +   is-a-blogger
	0x000d254f, // n0x0876 c0x0000 (---------------)  +   is-a-bookkeeper
	0x0018ba8e, // n0x0877 c0x0000 (---------------)  +   is-a-bulls-fan
	0x0000de0c, // n0x0878 c0x0000 (---------------)  +   is-a-caterer
	0x00012789, // n0x0879 c0x0000 (---------------)  +   is-a-chef
	0x00013d11, // n0x087a c0x0000 (---------------)  +   is-a-conservative
	0x00016c08, // n0x087b c0x0000 (---------------)  +   is-a-cpa
	0x00024852, // n0x087c c0x0000 (---------------)  +   is-a-cubicle-slave
	0x0002648d, // n0x087d c0x0000 (---------------)  +   is-a-democrat
	0x0002db8d, // n0x087e c0x0000 (---------------)  +   is-a-designer
	0x0017614b, // n0x087f c0x0000 (---------------)  +   is-a-doctor
	0x00178815, // n0x0880 c0x0000 (---------------)  +   is-a-financialadvisor
	0x0004e989, // n0x0881 c0x0000 (---------------)  +   is-a-geek
	0x0005028a, // n0x0882 c0x0000 (---------------)  +   is-a-green
	0x00059389, // n0x0883 c0x0000 (---------------)  +   is-a-guru
	0x0005bd50, // n0x0884 c0x0000 (---------------)  +   is-a-hard-worker
	0x000662cb, // n0x0885 c0x0000 (---------------)  +   is-a-hunter
	0x00070a4f, // n0x0886 c0x0000 (---------------)  +   is-a-landscaper
	0x0007434b, // n0x0887 c0x0000 (---------------)  +   is-a-lawyer
	0x0007b5cc, // n0x0888 c0x0000 (---------------)  +   is-a-liberal
	0x0007dbd0, // n0x0889 c0x0000 (---------------)  +   is-a-libertarian
	0x00082fca, // n0x088a c0x0000 (---------------)  +   is-a-llama
	0x0008394d, // n0x088b c0x0000 (---------------)  +   is-a-musician
	0x0008894e, // n0x088c c0x0000 (---------------)  +   is-a-nascarfan
	0x0014414a, // n0x088d c0x0000 (---------------)  +   is-a-nurse
	0x00089f0c, // n0x088e c0x0000 (---------------)  +   is-a-painter
	0x00094ed4, // n0x088f c0x0000 (---------------)  +   is-a-personaltrainer
	0x00098f51, // n0x0890 c0x0000 (---------------)  +   is-a-photographer
	0x0009e80b, // n0x0891 c0x0000 (---------------)  +   is-a-player
	0x0009f58f, // n0x0892 c0x0000 (---------------)  +   is-a-republican
	0x000a0f8d, // n0x0893 c0x0000 (---------------)  +   is-a-rockstar
	0x000a384e, // n0x0894 c0x0000 (---------------)  +   is-a-socialist
	0x000abc0c, // n0x0895 c0x0000 (---------------)  +   is-a-student
	0x000d5b8c, // n0x0896 c0x0000 (---------------)  +   is-a-teacher
	0x000d588b, // n0x0897 c0x0000 (---------------)  +   is-a-techie
	0x000beb8e, // n0x0898 c0x0000 (---------------)  +   is-a-therapist
	0x000d9990, // n0x0899 c0x0000 (---------------)  +   is-an-accountant
	0x000ad54b, // n0x089a c0x0000 (---------------)  +   is-an-actor
	0x000d540d, // n0x089b c0x0000 (---------------)  +   is-an-actress
	0x000fb60f, // n0x089c c0x0000 (---------------)  +   is-an-anarchist
	0x0010390c, // n0x089d c0x0000 (---------------)  +   is-an-artist
	0x00168fce, // n0x089e c0x0000 (---------------)  +   is-an-engineer
	0x000b2bd1, // n0x089f c0x0000 (---------------)  +   is-an-entertainer
	0x000b924c, // n0x08a0 c0x0000 (---------------)  +   is-certified
	0x000bb247, // n0x08a1 c0x0000 (---------------)  +   is-gone
	0x000be5cd, // n0x08a2 c0x0000 (---------------)  +   is-into-anime
	0x00105d8c, // n0x08a3 c0x0000 (---------------)  +   is-into-cars
	0x00147b50, // n0x08a4 c0x0000 (---------------)  +   is-into-cartoons
	0x0016fecd, // n0x08a5 c0x0000 (---------------)  +   is-into-games
	0x000cf347, // n0x08a6 c0x0000 (---------------)  +   is-leet
	0x0017e2d0, // n0x08a7 c0x0000 (---------------)  +   is-not-certified
	0x000e9488, // n0x08a8 c0x0000 (---------------)  +   is-slick
	0x000ef04b, // n0x08a9 c0x0000 (---------------)  +   is-uberleet
	0x0014bbcf, // n0x08aa c0x0000 (---------------)  +   is-with-theband
	0x0008e588, // n0x08ab c0x0000 (---------------)  +   isa-geek
	0x000df74d, // n0x08ac c0x0000 (---------------)  +   isa-hockeynut
	0x00168110, // n0x08ad c0x0000 (---------------)  +   issmarterthanyou
	0x000aedc3, // n0x08ae c0x0000 (---------------)  +   jpn
	0x00006fc2, // n0x08af c0x0000 (---------------)  +   kr
	0x00058c49, // n0x08b0 c0x0000 (---------------)  +   likes-pie
	0x00073bca, // n0x08b1 c0x0000 (---------------)  +   likescandy
	0x00005303, // n0x08b2 c0x0000 (---------------)  +   mex
	0x0010b007, // n0x08b3 c0x0000 (---------------)  +   mydrobo
	0x001176c8, // n0x08b4 c0x0000 (---------------)  +   neat-url
	0x00184847, // n0x08b5 c0x0000 (---------------)  +   nfshost
	0x00000c02, // n0x08b6 c0x0000 (---------------)  +   no
	0x00064d0a, // n0x08b7 c0x0000 (---------------)  +   operaunite
	0x00194d4f, // n0x08b8 c0x0000 (---------------)  +   outsystemscloud
	0x000eaf0c, // n0x08b9 c0x0000 (---------------)  +   pagefrontapp
	0x000eb1d2, // n0x08ba c0x0000 (---------------)  +   pagespeedmobilizer
	0x122e1605, // n0x08bb c0x0048 (n0x08fd-n0x08fe)  o I prgmr
	0x00114683, // n0x08bc c0x0000 (---------------)  +   qa2
	0x0017cd42, // n0x08bd c0x0000 (---------------)  +   qc
	0x000ecb08, // n0x08be c0x0000 (---------------)  +   rackmaze
	0x00108ac7, // n0x08bf c0x0000 (---------------)  +   rhcloud
	0x00002202, // n0x08c0 c0x0000 (---------------)  +   ro
	0x00011302, // n0x08c1 c0x0000 (---------------)  +   ru
	0x000004c2, // n0x08c2 c0x0000 (---------------)  +   sa
	0x00033810, // n0x08c3 c0x0000 (---------------)  +   saves-the-whales
	0x000046c2, // n0x08c4 c0x0000 (---------------)  +   se
	0x0006ba86, // n0x08c5 c0x0000 (---------------)  +   selfip
	0x0013738e, // n0x08c6 c0x0000 (---------------)  +   sells-for-less
	0x0008becb, // n0x08c7 c0x0000 (---------------)  +   sells-for-u
	0x000cb7c8, // n0x08c8 c0x0000 (---------------)  +   servebbs
	0x000d0eca, // n0x08c9 c0x0000 (---------------)  +   simple-url
	0x000f7b87, // n0x08ca c0x0000 (---------------)  +   sinaapp
	0x0000bb4d, // n0x08cb c0x0000 (---------------)  +   space-to-rent
	0x001557cc, // n0x08cc c0x0000 (---------------)  +   teaches-yoga
	0x00000f82, // n0x08cd c0x0000 (---------------)  +   uk
	0x00002382, // n0x08ce c0x0000 (---------------)  +   us
	0x00001802, // n0x08cf c0x0000 (---------------)  +   uy
	0x000f7aca, // n0x08d0 c0x0000 (---------------)  +   vipsinaapp
	0x000df44a, // n0x08d1 c0x0000 (---------------)  +   withgoogle
	0x000e470b, // n0x08d2 c0x0000 (---------------)  +   withyoutube
	0x000ff78e, // n0x08d3 c0x0000 (---------------)  +   writesthisblog
	0x0001bc0d, // n0x08d4 c0x0000 (---------------)  +   xenapponazure
	0x000d6f08, // n0x08d5 c0x0000 (---------------)  +   yolasite
	0x00005f82, // n0x08d6 c0x0000 (---------------)  +   za
	0x10a5f44e, // n0x08d7 c0x0042 (n0x08eb-n0x08ec)  o I ap-northeast-2
	0x10c35247, // n0x08d8 c0x0043 (n0x08ec-n0x08f6)  +   compute
	0x11035249, // n0x08d9 c0x0044 (n0x08f6-n0x08f8)  +   compute-1
	0x00010743, // n0x08da c0x0000 (---------------)  +   elb
	0x11672e4c, // n0x08db c0x0045 (n0x08f8-n0x08f9)  o I eu-central-1
	0x0004a542, // n0x08dc c0x0000 (---------------)  +   s3
	0x00132491, // n0x08dd c0x0000 (---------------)  +   s3-ap-northeast-1
	0x0005f391, // n0x08de c0x0000 (---------------)  +   s3-ap-northeast-2
	0x00131511, // n0x08df c0x0000 (---------------)  +   s3-ap-southeast-1
	0x0004a551, // n0x08e0 c0x0000 (---------------)  +   s3-ap-southeast-2
	0x00072d8f, // n0x08e1 c0x0000 (---------------)  +   s3-eu-central-1
	0x001101cc, // n0x08e2 c0x0000 (---------------)  +   s3-eu-west-1
	0x0011b34d, // n0x08e3 c0x0000 (---------------)  +   s3-external-1
	0x0012364d, // n0x08e4 c0x0000 (---------------)  +   s3-external-2
	0x00126215, // n0x08e5 c0x0000 (---------------)  +   s3-fips-us-gov-west-1
	0x0014694c, // n0x08e6 c0x0000 (---------------)  +   s3-sa-east-1
	0x000de150, // n0x08e7 c0x0000 (---------------)  +   s3-us-gov-west-1
	0x000c158c, // n0x08e8 c0x0000 (---------------)  +   s3-us-west-1
	0x000dc7cc, // n0x08e9 c0x0000 (---------------)  +   s3-us-west-2
	0x0017ca09, // n0x08ea c0x0000 (---------------)  +   us-east-1
	0x0004a542, // n0x08eb c0x0000 (---------------)  +   s3
	0x0013254e, // n0x08ec c0x0000 (---------------)  +   ap-northeast-1
	0x0005f44e, // n0x08ed c0x0000 (---------------)  +   ap-northeast-2
	0x001315ce, // n0x08ee c0x0000 (---------------)  +   ap-southeast-1
	0x0004a60e, // n0x08ef c0x0000 (---------------)  +   ap-southeast-2
	0x00072e4c, // n0x08f0 c0x0000 (---------------)  +   eu-central-1
	0x00110289, // n0x08f1 c0x0000 (---------------)  +   eu-west-1
	0x00146a09, // n0x08f2 c0x0000 (---------------)  +   sa-east-1
	0x000de20d, // n0x08f3 c0x0000 (---------------)  +   us-gov-west-1
	0x000c1649, // n0x08f4 c0x0000 (---------------)  +   us-west-1
	0x000dc889, // n0x08f5 c0x0000 (---------------)  +   us-west-2
	0x0002a043, // n0x08f6 c0x0000 (---------------)  +   z-1
	0x0013e5c3, // n0x08f7 c0x0000 (---------------)  +   z-2
	0x0004a542, // n0x08f8 c0x0000 (---------------)  +   s3
	0x000092c4, // n0x08f9 c0x0000 (---------------)  +   apps
	0x014bedc3, // n0x08fa c0x0005 (---------------)* o   api
	0x0140ba03, // n0x08fb c0x0005 (---------------)* o   ext
	0x000e2dc4, // n0x08fc c0x0000 (---------------)  +   gist
	0x0001bc03, // n0x08fd c0x0000 (---------------)  +   xen
	0x00201542, // n0x08fe c0x0000 (---------------)  + I ac
	0x00200742, // n0x08ff c0x0000 (---------------)  + I co
	0x00202602, // n0x0900 c0x0000 (---------------)  + I ed
	0x00207502, // n0x0901 c0x0000 (---------------)  + I fi
	0x00202d42, // n0x0902 c0x0000 (---------------)  + I go
	0x00200282, // n0x0903 c0x0000 (---------------)  + I or
	0x002004c2, // n0x0904 c0x0000 (---------------)  + I sa
	0x00233503, // n0x0905 c0x0000 (---------------)  + I com
	0x0023a783, // n0x0906 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0907 c0x0000 (---------------)  + I gov
	0x003a1083, // n0x0908 c0x0000 (---------------)  + I inf
	0x0021fe03, // n0x0909 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x090a c0x0000 (---------------)  + I org
	0x000ffa08, // n0x090b c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x090c c0x0000 (---------------)  + I com
	0x0023a783, // n0x090d c0x0000 (---------------)  + I edu
	0x0021fe03, // n0x090e c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x090f c0x0000 (---------------)  + I org
	0x00048f43, // n0x0910 c0x0000 (---------------)  +   ath
	0x0026cc83, // n0x0911 c0x0000 (---------------)  + I gov
	0x00201542, // n0x0912 c0x0000 (---------------)  + I ac
	0x00330b83, // n0x0913 c0x0000 (---------------)  + I biz
	0x13e33503, // n0x0914 c0x004f (n0x091f-n0x0920)  + I com
	0x0027a1c7, // n0x0915 c0x0000 (---------------)  + I ekloges
	0x0026cc83, // n0x0916 c0x0000 (---------------)  + I gov
	0x00322cc3, // n0x0917 c0x0000 (---------------)  + I ltd
	0x00205284, // n0x0918 c0x0000 (---------------)  + I name
	0x0021fe03, // n0x0919 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x091a c0x0000 (---------------)  + I org
	0x0028440a, // n0x091b c0x0000 (---------------)  + I parliament
	0x00247505, // n0x091c c0x0000 (---------------)  + I press
	0x00220e43, // n0x091d c0x0000 (---------------)  + I pro
	0x00200142, // n0x091e c0x0000 (---------------)  + I tm
	0x000ffa08, // n0x091f c0x0000 (---------------)  +   blogspot
	0x000ffa08, // n0x0920 c0x0000 (---------------)  +   blogspot
	0x00000742, // n0x0921 c0x0000 (---------------)  +   co
	0x000ffa08, // n0x0922 c0x0000 (---------------)  +   blogspot
	0x00033503, // n0x0923 c0x0000 (---------------)  +   com
	0x000afa4f, // n0x0924 c0x0000 (---------------)  +   fuettertdasnetz
	0x0016a18a, // n0x0925 c0x0000 (---------------)  +   isteingeek
	0x000a3b07, // n0x0926 c0x0000 (---------------)  +   istmein
	0x0001fc8a, // n0x0927 c0x0000 (---------------)  +   lebtimnetz
	0x0018460a, // n0x0928 c0x0000 (---------------)  +   leitungsen
	0x00004acd, // n0x0929 c0x0000 (---------------)  +   traeumtgerade
	0x000ffa08, // n0x092a c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x092b c0x0000 (---------------)  + I com
	0x0023a783, // n0x092c c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x092d c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x092e c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x092f c0x0000 (---------------)  + I org
	0x002011c3, // n0x0930 c0x0000 (---------------)  + I art
	0x00233503, // n0x0931 c0x0000 (---------------)  + I com
	0x0023a783, // n0x0932 c0x0000 (---------------)  + I edu
	0x00213183, // n0x0933 c0x0000 (---------------)  + I gob
	0x0026cc83, // n0x0934 c0x0000 (---------------)  + I gov
	0x00209003, // n0x0935 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x0936 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0937 c0x0000 (---------------)  + I org
	0x00292103, // n0x0938 c0x0000 (---------------)  + I sld
	0x00221a03, // n0x0939 c0x0000 (---------------)  + I web
	0x002011c3, // n0x093a c0x0000 (---------------)  + I art
	0x002d4884, // n0x093b c0x0000 (---------------)  + I asso
	0x00233503, // n0x093c c0x0000 (---------------)  + I com
	0x0023a783, // n0x093d c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x093e c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x093f c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0940 c0x0000 (---------------)  + I org
	0x00208103, // n0x0941 c0x0000 (---------------)  + I pol
	0x00233503, // n0x0942 c0x0000 (---------------)  + I com
	0x0023a783, // n0x0943 c0x0000 (---------------)  + I edu
	0x00207503, // n0x0944 c0x0000 (---------------)  + I fin
	0x00213183, // n0x0945 c0x0000 (---------------)  + I gob
	0x0026cc83, // n0x0946 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x0947 c0x0000 (---------------)  + I info
	0x00309ac3, // n0x0948 c0x0000 (---------------)  + I k12
	0x00213ac3, // n0x0949 c0x0000 (---------------)  + I med
	0x00209003, // n0x094a c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x094b c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x094c c0x0000 (---------------)  + I org
	0x00220e43, // n0x094d c0x0000 (---------------)  + I pro
	0x003a6543, // n0x094e c0x0000 (---------------)  + I aip
	0x16233503, // n0x094f c0x0058 (n0x0958-n0x0959)  + I com
	0x0023a783, // n0x0950 c0x0000 (---------------)  + I edu
	0x002b9443, // n0x0951 c0x0000 (---------------)  + I fie
	0x0026cc83, // n0x0952 c0x0000 (---------------)  + I gov
	0x0027b703, // n0x0953 c0x0000 (---------------)  + I lib
	0x00213ac3, // n0x0954 c0x0000 (---------------)  + I med
	0x0022d1c3, // n0x0955 c0x0000 (---------------)  + I org
	0x00204603, // n0x0956 c0x0000 (---------------)  + I pri
	0x00320cc4, // n0x0957 c0x0000 (---------------)  + I riik
	0x000ffa08, // n0x0958 c0x0000 (---------------)  +   blogspot
	0x16a33503, // n0x0959 c0x005a (n0x0962-n0x0963)  + I com
	0x0023a783, // n0x095a c0x0000 (---------------)  + I edu
	0x002a7083, // n0x095b c0x0000 (---------------)  + I eun
	0x0026cc83, // n0x095c c0x0000 (---------------)  + I gov
	0x00209003, // n0x095d c0x0000 (---------------)  + I mil
	0x00205284, // n0x095e c0x0000 (---------------)  + I name
	0x0021fe03, // n0x095f c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0960 c0x0000 (---------------)  + I org
	0x0021d703, // n0x0961 c0x0000 (---------------)  + I sci
	0x000ffa08, // n0x0962 c0x0000 (---------------)  +   blogspot
	0x17233503, // n0x0963 c0x005c (n0x0968-n0x0969)  + I com
	0x0023a783, // n0x0964 c0x0000 (---------------)  + I edu
	0x00213183, // n0x0965 c0x0000 (---------------)  + I gob
	0x00201483, // n0x0966 c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x0967 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x0968 c0x0000 (---------------)  +   blogspot
	0x00330b83, // n0x0969 c0x0000 (---------------)  + I biz
	0x00233503, // n0x096a c0x0000 (---------------)  + I com
	0x0023a783, // n0x096b c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x096c c0x0000 (---------------)  + I gov
	0x003a1244, // n0x096d c0x0000 (---------------)  + I info
	0x00205284, // n0x096e c0x0000 (---------------)  + I name
	0x0021fe03, // n0x096f c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0970 c0x0000 (---------------)  + I org
	0x0031a845, // n0x0971 c0x0000 (---------------)  + I aland
	0x000ffa08, // n0x0972 c0x0000 (---------------)  +   blogspot
	0x0003be03, // n0x0973 c0x0000 (---------------)  +   iki
	0x002ec408, // n0x0974 c0x0000 (---------------)  + I aeroport
	0x00350d87, // n0x0975 c0x0000 (---------------)  + I assedic
	0x002d4884, // n0x0976 c0x0000 (---------------)  + I asso
	0x0032f106, // n0x0977 c0x0000 (---------------)  + I avocat
	0x00346806, // n0x0978 c0x0000 (---------------)  + I avoues
	0x000ffa08, // n0x0979 c0x0000 (---------------)  +   blogspot
	0x0023fdc3, // n0x097a c0x0000 (---------------)  + I cci
	0x00209b49, // n0x097b c0x0000 (---------------)  + I chambagri
	0x002b2115, // n0x097c c0x0000 (---------------)  + I chirurgiens-dentistes
	0x00233503, // n0x097d c0x0000 (---------------)  + I com
	0x0031ee12, // n0x097e c0x0000 (---------------)  + I experts-comptables
	0x0031ebcf, // n0x097f c0x0000 (---------------)  + I geometre-expert
	0x0033d7c4, // n0x0980 c0x0000 (---------------)  + I gouv
	0x0022a885, // n0x0981 c0x0000 (---------------)  + I greta
	0x002f2f10, // n0x0982 c0x0000 (---------------)  + I huissier-justice
	0x00238bc7, // n0x0983 c0x0000 (---------------)  + I medecin
	0x00201483, // n0x0984 c0x0000 (---------------)  + I nom
	0x0025c988, // n0x0985 c0x0000 (---------------)  + I notaires
	0x0034d60a, // n0x0986 c0x0000 (---------------)  + I pharmacien
	0x00246184, // n0x0987 c0x0000 (---------------)  + I port
	0x002e1043, // n0x0988 c0x0000 (---------------)  + I prd
	0x00247506, // n0x0989 c0x0000 (---------------)  + I presse
	0x00200142, // n0x098a c0x0000 (---------------)  + I tm
	0x002d1c8b, // n0x098b c0x0000 (---------------)  + I veterinaire
	0x00233503, // n0x098c c0x0000 (---------------)  + I com
	0x0023a783, // n0x098d c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x098e c0x0000 (---------------)  + I gov
	0x00209003, // n0x098f c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x0990 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0991 c0x0000 (---------------)  + I org
	0x002e5543, // n0x0992 c0x0000 (---------------)  + I pvt
	0x00200742, // n0x0993 c0x0000 (---------------)  + I co
	0x0021fe03, // n0x0994 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0995 c0x0000 (---------------)  + I org
	0x00233503, // n0x0996 c0x0000 (---------------)  + I com
	0x0023a783, // n0x0997 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0998 c0x0000 (---------------)  + I gov
	0x00209003, // n0x0999 c0x0000 (---------------)  + I mil
	0x0022d1c3, // n0x099a c0x0000 (---------------)  + I org
	0x00233503, // n0x099b c0x0000 (---------------)  + I com
	0x0023a783, // n0x099c c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x099d c0x0000 (---------------)  + I gov
	0x00322cc3, // n0x099e c0x0000 (---------------)  + I ltd
	0x00218303, // n0x099f c0x0000 (---------------)  + I mod
	0x0022d1c3, // n0x09a0 c0x0000 (---------------)  + I org
	0x00200742, // n0x09a1 c0x0000 (---------------)  + I co
	0x00233503, // n0x09a2 c0x0000 (---------------)  + I com
	0x0023a783, // n0x09a3 c0x0000 (---------------)  + I edu
	0x0021fe03, // n0x09a4 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09a5 c0x0000 (---------------)  + I org
	0x00201542, // n0x09a6 c0x0000 (---------------)  + I ac
	0x00233503, // n0x09a7 c0x0000 (---------------)  + I com
	0x0023a783, // n0x09a8 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x09a9 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x09aa c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09ab c0x0000 (---------------)  + I org
	0x002d4884, // n0x09ac c0x0000 (---------------)  + I asso
	0x00233503, // n0x09ad c0x0000 (---------------)  + I com
	0x0023a783, // n0x09ae c0x0000 (---------------)  + I edu
	0x00207104, // n0x09af c0x0000 (---------------)  + I mobi
	0x0021fe03, // n0x09b0 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09b1 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x09b2 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x09b3 c0x0000 (---------------)  + I com
	0x0023a783, // n0x09b4 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x09b5 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x09b6 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09b7 c0x0000 (---------------)  + I org
	0x00233503, // n0x09b8 c0x0000 (---------------)  + I com
	0x0023a783, // n0x09b9 c0x0000 (---------------)  + I edu
	0x00213183, // n0x09ba c0x0000 (---------------)  + I gob
	0x0021d883, // n0x09bb c0x0000 (---------------)  + I ind
	0x00209003, // n0x09bc c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x09bd c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09be c0x0000 (---------------)  + I org
	0x00200742, // n0x09bf c0x0000 (---------------)  + I co
	0x00233503, // n0x09c0 c0x0000 (---------------)  + I com
	0x0023a783, // n0x09c1 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x09c2 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x09c3 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09c4 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x09c5 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x09c6 c0x0000 (---------------)  + I com
	0x0023a783, // n0x09c7 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x09c8 c0x0000 (---------------)  + I gov
	0x00317243, // n0x09c9 c0x0000 (---------------)  + I idv
	0x0002e7c3, // n0x09ca c0x0000 (---------------)  +   inc
	0x00122cc3, // n0x09cb c0x0000 (---------------)  +   ltd
	0x0021fe03, // n0x09cc c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09cd c0x0000 (---------------)  + I org
	0x003029ca, // n0x09ce c0x0000 (---------------)  + I xn--55qx5d
	0x0031bd89, // n0x09cf c0x0000 (---------------)  + I xn--ciqpn
	0x0033ac4b, // n0x09d0 c0x0000 (---------------)  + I xn--gmq050i
	0x0033b1ca, // n0x09d1 c0x0000 (---------------)  + I xn--gmqw5a
	0x0034280a, // n0x09d2 c0x0000 (---------------)  + I xn--io0a7i
	0x00353a8b, // n0x09d3 c0x0000 (---------------)  + I xn--lcvr32d
	0x0036704a, // n0x09d4 c0x0000 (---------------)  + I xn--mk0axi
	0x0036fa4a, // n0x09d5 c0x0000 (---------------)  + I xn--mxtq1m
	0x0037648a, // n0x09d6 c0x0000 (---------------)  + I xn--od0alg
	0x0037670b, // n0x09d7 c0x0000 (---------------)  + I xn--od0aq3b
	0x00392609, // n0x09d8 c0x0000 (---------------)  + I xn--tn0ag
	0x003941ca, // n0x09d9 c0x0000 (---------------)  + I xn--uc0atv
	0x0039470b, // n0x09da c0x0000 (---------------)  + I xn--uc0ay4a
	0x0039cfcb, // n0x09db c0x0000 (---------------)  + I xn--wcvs22d
	0x003a57ca, // n0x09dc c0x0000 (---------------)  + I xn--zf0avx
	0x00233503, // n0x09dd c0x0000 (---------------)  + I com
	0x0023a783, // n0x09de c0x0000 (---------------)  + I edu
	0x00213183, // n0x09df c0x0000 (---------------)  + I gob
	0x00209003, // n0x09e0 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x09e1 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09e2 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x09e3 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x09e4 c0x0000 (---------------)  + I com
	0x00263d84, // n0x09e5 c0x0000 (---------------)  + I from
	0x00212582, // n0x09e6 c0x0000 (---------------)  + I iz
	0x00205284, // n0x09e7 c0x0000 (---------------)  + I name
	0x002a1985, // n0x09e8 c0x0000 (---------------)  + I adult
	0x002011c3, // n0x09e9 c0x0000 (---------------)  + I art
	0x002d4884, // n0x09ea c0x0000 (---------------)  + I asso
	0x00233503, // n0x09eb c0x0000 (---------------)  + I com
	0x0023d684, // n0x09ec c0x0000 (---------------)  + I coop
	0x0023a783, // n0x09ed c0x0000 (---------------)  + I edu
	0x0024d9c4, // n0x09ee c0x0000 (---------------)  + I firm
	0x0033d7c4, // n0x09ef c0x0000 (---------------)  + I gouv
	0x003a1244, // n0x09f0 c0x0000 (---------------)  + I info
	0x00213ac3, // n0x09f1 c0x0000 (---------------)  + I med
	0x0021fe03, // n0x09f2 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x09f3 c0x0000 (---------------)  + I org
	0x00295005, // n0x09f4 c0x0000 (---------------)  + I perso
	0x00208103, // n0x09f5 c0x0000 (---------------)  + I pol
	0x00220e43, // n0x09f6 c0x0000 (---------------)  + I pro
	0x00285b43, // n0x09f7 c0x0000 (---------------)  + I rel
	0x00352004, // n0x09f8 c0x0000 (---------------)  + I shop
	0x002ee544, // n0x09f9 c0x0000 (---------------)  + I 2000
	0x00258185, // n0x09fa c0x0000 (---------------)  + I agrar
	0x000ffa08, // n0x09fb c0x0000 (---------------)  +   blogspot
	0x002f9244, // n0x09fc c0x0000 (---------------)  + I bolt
	0x0037bc46, // n0x09fd c0x0000 (---------------)  + I casino
	0x00286744, // n0x09fe c0x0000 (---------------)  + I city
	0x00200742, // n0x09ff c0x0000 (---------------)  + I co
	0x00343507, // n0x0a00 c0x0000 (---------------)  + I erotica
	0x00250887, // n0x0a01 c0x0000 (---------------)  + I erotika
	0x0024b784, // n0x0a02 c0x0000 (---------------)  + I film
	0x0025b085, // n0x0a03 c0x0000 (---------------)  + I forum
	0x003700c5, // n0x0a04 c0x0000 (---------------)  + I games
	0x00234dc5, // n0x0a05 c0x0000 (---------------)  + I hotel
	0x003a1244, // n0x0a06 c0x0000 (---------------)  + I info
	0x00224408, // n0x0a07 c0x0000 (---------------)  + I ingatlan
	0x00293246, // n0x0a08 c0x0000 (---------------)  + I jogasz
	0x002cce48, // n0x0a09 c0x0000 (---------------)  + I konyvelo
	0x002435c5, // n0x0a0a c0x0000 (---------------)  + I lakas
	0x003025c5, // n0x0a0b c0x0000 (---------------)  + I media
	0x00221dc4, // n0x0a0c c0x0000 (---------------)  + I news
	0x0022d1c3, // n0x0a0d c0x0000 (---------------)  + I org
	0x002e1c44, // n0x0a0e c0x0000 (---------------)  + I priv
	0x00352c46, // n0x0a0f c0x0000 (---------------)  + I reklam
	0x00247603, // n0x0a10 c0x0000 (---------------)  + I sex
	0x00352004, // n0x0a11 c0x0000 (---------------)  + I shop
	0x00294905, // n0x0a12 c0x0000 (---------------)  + I sport
	0x0023c004, // n0x0a13 c0x0000 (---------------)  + I suli
	0x0020b984, // n0x0a14 c0x0000 (---------------)  + I szex
	0x00200142, // n0x0a15 c0x0000 (---------------)  + I tm
	0x00270746, // n0x0a16 c0x0000 (---------------)  + I tozsde
	0x00389006, // n0x0a17 c0x0000 (---------------)  + I utazas
	0x002f5685, // n0x0a18 c0x0000 (---------------)  + I video
	0x00201542, // n0x0a19 c0x0000 (---------------)  + I ac
	0x00330b83, // n0x0a1a c0x0000 (---------------)  + I biz
	0x1c200742, // n0x0a1b c0x0070 (n0x0a24-n0x0a25)  + I co
	0x0023bb04, // n0x0a1c c0x0000 (---------------)  + I desa
	0x00202d42, // n0x0a1d c0x0000 (---------------)  + I go
	0x00209003, // n0x0a1e c0x0000 (---------------)  + I mil
	0x00226f02, // n0x0a1f c0x0000 (---------------)  + I my
	0x0021fe03, // n0x0a20 c0x0000 (---------------)  + I net
	0x00200282, // n0x0a21 c0x0000 (---------------)  + I or
	0x00217443, // n0x0a22 c0x0000 (---------------)  + I sch
	0x00221a03, // n0x0a23 c0x0000 (---------------)  + I web
	0x000ffa08, // n0x0a24 c0x0000 (---------------)  +   blogspot
	0x000ffa08, // n0x0a25 c0x0000 (---------------)  +   blogspot
	0x0026cc83, // n0x0a26 c0x0000 (---------------)  + I gov
	0x00201542, // n0x0a27 c0x0000 (---------------)  + I ac
	0x1ce00742, // n0x0a28 c0x0073 (n0x0a2f-n0x0a30)  + I co
	0x0026cc83, // n0x0a29 c0x0000 (---------------)  + I gov
	0x00268a83, // n0x0a2a c0x0000 (---------------)  + I idf
	0x00309ac3, // n0x0a2b c0x0000 (---------------)  + I k12
	0x002335c4, // n0x0a2c c0x0000 (---------------)  + I muni
	0x0021fe03, // n0x0a2d c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0a2e c0x0000 (---------------)  + I org
	0x000ffa08, // n0x0a2f c0x0000 (---------------)  +   blogspot
	0x00201542, // n0x0a30 c0x0000 (---------------)  + I ac
	0x1d600742, // n0x0a31 c0x0075 (n0x0a37-n0x0a39)  + I co
	0x00233503, // n0x0a32 c0x0000 (---------------)  + I com
	0x0021fe03, // n0x0a33 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0a34 c0x0000 (---------------)  + I org
	0x0020e842, // n0x0a35 c0x0000 (---------------)  + I tt
	0x00224e42, // n0x0a36 c0x0000 (---------------)  + I tv
	0x00322cc3, // n0x0a37 c0x0000 (---------------)  + I ltd
	0x002db143, // n0x0a38 c0x0000 (---------------)  + I plc
	0x00201542, // n0x0a39 c0x0000 (---------------)  + I ac
	0x000ffa08, // n0x0a3a c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x0a3b c0x0000 (---------------)  + I co
	0x0023a783, // n0x0a3c c0x0000 (---------------)  + I edu
	0x0024d9c4, // n0x0a3d c0x0000 (---------------)  + I firm
	0x00205843, // n0x0a3e c0x0000 (---------------)  + I gen
	0x0026cc83, // n0x0a3f c0x0000 (---------------)  + I gov
	0x0021d883, // n0x0a40 c0x0000 (---------------)  + I ind
	0x00209003, // n0x0a41 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x0a42 c0x0000 (---------------)  + I net
	0x00218f83, // n0x0a43 c0x0000 (---------------)  + I nic
	0x0022d1c3, // n0x0a44 c0x0000 (---------------)  + I org
	0x0021d683, // n0x0a45 c0x0000 (---------------)  + I res
	0x0011e793, // n0x0a46 c0x0000 (---------------)  +   barrel-of-knowledge
	0x001246d4, // n0x0a47 c0x0000 (---------------)  +   barrell-of-knowledge
	0x00013886, // n0x0a48 c0x0000 (---------------)  +   dyndns
	0x000562c7, // n0x0a49 c0x0000 (---------------)  +   for-our
	0x00155d09, // n0x0a4a c0x0000 (---------------)  +   groks-the
	0x000ebb0a, // n0x0a4b c0x0000 (---------------)  +   groks-this
	0x00087c4d, // n0x0a4c c0x0000 (---------------)  +   here-for-more
	0x001a408a, // n0x0a4d c0x0000 (---------------)  +   knowsitall
	0x0006ba86, // n0x0a4e c0x0000 (---------------)  +   selfip
	0x000eadc6, // n0x0a4f c0x0000 (---------------)  +   webhop
	0x00204b82, // n0x0a50 c0x0000 (---------------)  + I eu
	0x00233503, // n0x0a51 c0x0000 (---------------)  + I com
	0x00019506, // n0x0a52 c0x0000 (---------------)  +   github
	0x00155cc5, // n0x0a53 c0x0000 (---------------)  +   ngrok
	0x0000cb83, // n0x0a54 c0x0000 (---------------)  +   nid
	0x00011f88, // n0x0a55 c0x0000 (---------------)  +   pantheon
	0x000af708, // n0x0a56 c0x0000 (---------------)  +   sandcats
	0x00233503, // n0x0a57 c0x0000 (---------------)  + I com
	0x0023a783, // n0x0a58 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0a59 c0x0000 (---------------)  + I gov
	0x00209003, // n0x0a5a c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x0a5b c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0a5c c0x0000 (---------------)  + I org
	0x00201542, // n0x0a5d c0x0000 (---------------)  + I ac
	0x00200742, // n0x0a5e c0x0000 (---------------)  + I co
	0x0026cc83, // n0x0a5f c0x0000 (---------------)  + I gov
	0x0020c782, // n0x0a60 c0x0000 (---------------)  + I id
	0x0021fe03, // n0x0a61 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0a62 c0x0000 (---------------)  + I org
	0x00217443, // n0x0a63 c0x0000 (---------------)  + I sch
	0x0035d94f, // n0x0a64 c0x0000 (---------------)  + I xn--mgba3a4f16a
	0x0035dd0e, // n0x0a65 c0x0000 (---------------)  + I xn--mgba3a4fra
	0x000ffa08, // n0x0a66 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x0a67 c0x0000 (---------------)  + I com
	0x00048107, // n0x0a68 c0x0000 (---------------)  +   cupcake
	0x0023a783, // n0x0a69 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0a6a c0x0000 (---------------)  + I gov
	0x00201603, // n0x0a6b c0x0000 (---------------)  + I int
	0x0021fe03, // n0x0a6c c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0a6d c0x0000 (---------------)  + I org
	0x0021ca03, // n0x0a6e c0x0000 (---------------)  + I abr
	0x002ed6c7, // n0x0a6f c0x0000 (---------------)  + I abruzzo
	0x00201002, // n0x0a70 c0x0000 (---------------)  + I ag
	0x002cd4c9, // n0x0a71 c0x0000 (---------------)  + I agrigento
	0x002001c2, // n0x0a72 c0x0000 (---------------)  + I al
	0x00233b0b, // n0x0a73 c0x0000 (---------------)  + I alessandria
	0x002dfc4a, // n0x0a74 c0x0000 (---------------)  + I alto-adige
	0x002e3489, // n0x0a75 c0x0000 (---------------)  + I altoadige
	0x00200502, // n0x0a76 c0x0000 (---------------)  + I an
	0x00350806, // n0x0a77 c0x0000 (---------------)  + I ancona
	0x002847d5, // n0x0a78 c0x0000 (---------------)  + I andria-barletta-trani
	0x00233c55, // n0x0a79 c0x0000 (---------------)  + I andria-trani-barletta
	0x00290513, // n0x0a7a c0x0000 (---------------)  + I andriabarlettatrani
	0x002341d3, // n0x0a7b c0x0000 (---------------)  + I andriatranibarletta
	0x002029c2, // n0x0a7c c0x0000 (---------------)  + I ao
	0x00216fc5, // n0x0a7d c0x0000 (---------------)  + I aosta
	0x0030f30c, // n0x0a7e c0x0000 (---------------)  + I aosta-valley
	0x00216fcb, // n0x0a7f c0x0000 (---------------)  + I aostavalley
	0x00251085, // n0x0a80 c0x0000 (---------------)  + I aoste
	0x00200d02, // n0x0a81 c0x0000 (---------------)  + I ap
	0x002003c2, // n0x0a82 c0x0000 (---------------)  + I aq
	0x0036c346, // n0x0a83 c0x0000 (---------------)  + I aquila
	0x00200a42, // n0x0a84 c0x0000 (---------------)  + I ar
	0x0027a406, // n0x0a85 c0x0000 (---------------)  + I arezzo
	0x00397ccd, // n0x0a86 c0x0000 (---------------)  + I ascoli-piceno
	0x0034c1cc, // n0x0a87 c0x0000 (---------------)  + I ascolipiceno
	0x0021e884, // n0x0a88 c0x0000 (---------------)  + I asti
	0x00200102, // n0x0a89 c0x0000 (---------------)  + I at
	0x00203402, // n0x0a8a c0x0000 (---------------)  + I av
	0x00224c08, // n0x0a8b c0x0000 (---------------)  + I avellino
	0x00202002, // n0x0a8c c0x0000 (---------------)  + I ba
	0x00248586, // n0x0a8d c0x0000 (---------------)  + I balsan
	0x00249204, // n0x0a8e c0x0000 (---------------)  + I bari
	0x00284995, // n0x0a8f c0x0000 (---------------)  + I barletta-trani-andria
	0x00290693, // n0x0a90 c0x0000 (---------------)  + I barlettatraniandria
	0x00207fc3, // n0x0a91 c0x0000 (---------------)  + I bas
	0x0032ee0a, // n0x0a92 c0x0000 (---------------)  + I basilicata
	0x0028e2c7, // n0x0a93 c0x0000 (---------------)  + I belluno
	0x002e4949, // n0x0a94 c0x0000 (---------------)  + I benevento
	0x00228d47, // n0x0a95 c0x0000 (---------------)  + I bergamo
	0x002ee482, // n0x0a96 c0x0000 (---------------)  + I bg
	0x00200002, // n0x0a97 c0x0000 (---------------)  + I bi
	0x003a4cc6, // n0x0a98 c0x0000 (---------------)  + I biella
	0x0020c8c2, // n0x0a99 c0x0000 (---------------)  + I bl
	0x000ffa08, // n0x0a9a c0x0000 (---------------)  +   blogspot
	0x002104c2, // n0x0a9b c0x0000 (---------------)  + I bn
	0x0020e402, // n0x0a9c c0x0000 (---------------)  + I bo
	0x0038df47, // n0x0a9d c0x0000 (---------------)  + I bologna
	0x0020fec7, // n0x0a9e c0x0000 (---------------)  + I bolzano
	0x0021c105, // n0x0a9f c0x0000 (---------------)  + I bozen
	0x0021c402, // n0x0aa0 c0x0000 (---------------)  + I br
	0x0021d647, // n0x0aa1 c0x0000 (---------------)  + I brescia
	0x0021d808, // n0x0aa2 c0x0000 (---------------)  + I brindisi
	0x00237542, // n0x0aa3 c0x0000 (---------------)  + I bs
	0x0021fd02, // n0x0aa4 c0x0000 (---------------)  + I bt
	0x00230bc2, // n0x0aa5 c0x0000 (---------------)  + I bz
	0x00200302, // n0x0aa6 c0x0000 (---------------)  + I ca
	0x0023eb48, // n0x0aa7 c0x0000 (---------------)  + I cagliari
	0x00213543, // n0x0aa8 c0x0000 (---------------)  + I cal
	0x00285688, // n0x0aa9 c0x0000 (---------------)  + I calabria
	0x0023ad8d, // n0x0aaa c0x0000 (---------------)  + I caltanissetta
	0x00221ac3, // n0x0aab c0x0000 (---------------)  + I cam
	0x00316e08, // n0x0aac c0x0000 (---------------)  + I campania
	0x00241acf, // n0x0aad c0x0000 (---------------)  + I campidano-medio
	0x00241e8e, // n0x0aae c0x0000 (---------------)  + I campidanomedio
	0x0034364a, // n0x0aaf c0x0000 (---------------)  + I campobasso
	0x002f6e11, // n0x0ab0 c0x0000 (---------------)  + I carbonia-iglesias
	0x002f7290, // n0x0ab1 c0x0000 (---------------)  + I carboniaiglesias
	0x002b3b4d, // n0x0ab2 c0x0000 (---------------)  + I carrara-massa
	0x002b3e8c, // n0x0ab3 c0x0000 (---------------)  + I carraramassa
	0x0022c607, // n0x0ab4 c0x0000 (---------------)  + I caserta
	0x0032ef87, // n0x0ab5 c0x0000 (---------------)  + I catania
	0x0032f1c9, // n0x0ab6 c0x0000 (---------------)  + I catanzaro
	0x0021e982, // n0x0ab7 c0x0000 (---------------)  + I cb
	0x00200b42, // n0x0ab8 c0x0000 (---------------)  + I ce
	0x0025870c, // n0x0ab9 c0x0000 (---------------)  + I cesena-forli
	0x00258a0b, // n0x0aba c0x0000 (---------------)  + I cesenaforli
	0x00201582, // n0x0abb c0x0000 (---------------)  + I ch
	0x002d5a46, // n0x0abc c0x0000 (---------------)  + I chieti
	0x00200682, // n0x0abd c0x0000 (---------------)  + I ci
	0x00209182, // n0x0abe c0x0000 (---------------)  + I cl
	0x0021ba42, // n0x0abf c0x0000 (---------------)  + I cn
	0x00200742, // n0x0ac0 c0x0000 (---------------)  + I co
	0x00234804, // n0x0ac1 c0x0000 (---------------)  + I como
	0x00240e07, // n0x0ac2 c0x0000 (---------------)  + I cosenza
	0x002049c2, // n0x0ac3 c0x0000 (---------------)  + I cr
	0x00244d07, // n0x0ac4 c0x0000 (---------------)  + I cremona
	0x00245f87, // n0x0ac5 c0x0000 (---------------)  + I crotone
	0x00211c82, // n0x0ac6 c0x0000 (---------------)  + I cs
	0x00231382, // n0x0ac7 c0x0000 (---------------)  + I ct
	0x00247fc5, // n0x0ac8 c0x0000 (---------------)  + I cuneo
	0x00229ec2, // n0x0ac9 c0x0000 (---------------)  + I cz
	0x0025a38e, // n0x0aca c0x0000 (---------------)  + I dell-ogliastra
	0x0026714d, // n0x0acb c0x0000 (---------------)  + I dellogliastra
	0x0023a783, // n0x0acc c0x0000 (---------------)  + I edu
	0x002543ce, // n0x0acd c0x0000 (---------------)  + I emilia-romagna
	0x0036dc0d, // n0x0ace c0x0000 (---------------)  + I emiliaromagna
	0x00360a83, // n0x0acf c0x0000 (---------------)  + I emr
	0x00202bc2, // n0x0ad0 c0x0000 (---------------)  + I en
	0x00205a84, // n0x0ad1 c0x0000 (---------------)  + I enna
	0x0024b242, // n0x0ad2 c0x0000 (---------------)  + I fc
	0x0020b302, // n0x0ad3 c0x0000 (---------------)  + I fe
	0x002e2545, // n0x0ad4 c0x0000 (---------------)  + I fermo
	0x00300807, // n0x0ad5 c0x0000 (---------------)  + I ferrara
	0x0035d282, // n0x0ad6 c0x0000 (---------------)  + I fg
	0x00207502, // n0x0ad7 c0x0000 (---------------)  + I fi
	0x0024d307, // n0x0ad8 c0x0000 (---------------)  + I firenze
	0x00252748, // n0x0ad9 c0x0000 (---------------)  + I florence
	0x00242902, // n0x0ada c0x0000 (---------------)  + I fm
	0x003a12c6, // n0x0adb c0x0000 (---------------)  + I foggia
	0x0025858c, // n0x0adc c0x0000 (---------------)  + I forli-cesena
	0x002588cb, // n0x0add c0x0000 (---------------)  + I forlicesena
	0x00200582, // n0x0ade c0x0000 (---------------)  + I fr
	0x0026050f, // n0x0adf c0x0000 (---------------)  + I friuli-v-giulia
	0x002608d0, // n0x0ae0 c0x0000 (---------------)  + I friuli-ve-giulia
	0x00260ccf, // n0x0ae1 c0x0000 (---------------)  + I friuli-vegiulia
	0x00261095, // n0x0ae2 c0x0000 (---------------)  + I friuli-venezia-giulia
	0x002615d4, // n0x0ae3 c0x0000 (---------------)  + I friuli-veneziagiulia
	0x00261ace, // n0x0ae4 c0x0000 (---------------)  + I friuli-vgiulia
	0x00261e4e, // n0x0ae5 c0x0000 (---------------)  + I friuliv-giulia
	0x002621cf, // n0x0ae6 c0x0000 (---------------)  + I friulive-giulia
	0x0026258e, // n0x0ae7 c0x0000 (---------------)  + I friulivegiulia
	0x00262914, // n0x0ae8 c0x0000 (---------------)  + I friulivenezia-giulia
	0x00262e13, // n0x0ae9 c0x0000 (---------------)  + I friuliveneziagiulia
	0x002632cd, // n0x0aea c0x0000 (---------------)  + I friulivgiulia
	0x002767c9, // n0x0aeb c0x0000 (---------------)  + I frosinone
	0x00288803, // n0x0aec c0x0000 (---------------)  + I fvg
	0x002026c2, // n0x0aed c0x0000 (---------------)  + I ge
	0x00307105, // n0x0aee c0x0000 (---------------)  + I genoa
	0x00205846, // n0x0aef c0x0000 (---------------)  + I genova
	0x00202d42, // n0x0af0 c0x0000 (---------------)  + I go
	0x0026edc7, // n0x0af1 c0x0000 (---------------)  + I gorizia
	0x0026cc83, // n0x0af2 c0x0000 (---------------)  + I gov
	0x00200c82, // n0x0af3 c0x0000 (---------------)  + I gr
	0x00311b48, // n0x0af4 c0x0000 (---------------)  + I grosseto
	0x002f7051, // n0x0af5 c0x0000 (---------------)  + I iglesias-carbonia
	0x002f7490, // n0x0af6 c0x0000 (---------------)  + I iglesiascarbonia
	0x00205c42, // n0x0af7 c0x0000 (---------------)  + I im
	0x00352747, // n0x0af8 c0x0000 (---------------)  + I imperia
	0x002006c2, // n0x0af9 c0x0000 (---------------)  + I is
	0x0025dc87, // n0x0afa c0x0000 (---------------)  + I isernia
	0x00206fc2, // n0x0afb c0x0000 (---------------)  + I kr
	0x0025e389, // n0x0afc c0x0000 (---------------)  + I la-spezia
	0x0036c307, // n0x0afd c0x0000 (---------------)  + I laquila
	0x0025fe48, // n0x0afe c0x0000 (---------------)  + I laspezia
	0x00223606, // n0x0aff c0x0000 (---------------)  + I latina
	0x002db043, // n0x0b00 c0x0000 (---------------)  + I laz
	0x00309045, // n0x0b01 c0x0000 (---------------)  + I lazio
	0x0023aa02, // n0x0b02 c0x0000 (---------------)  + I lc
	0x0020acc2, // n0x0b03 c0x0000 (---------------)  + I le
	0x003a50c5, // n0x0b04 c0x0000 (---------------)  + I lecce
	0x0022e105, // n0x0b05 c0x0000 (---------------)  + I lecco
	0x00207202, // n0x0b06 c0x0000 (---------------)  + I li
	0x0023c083, // n0x0b07 c0x0000 (---------------)  + I lig
	0x0023c087, // n0x0b08 c0x0000 (---------------)  + I liguria
	0x00210307, // n0x0b09 c0x0000 (---------------)  + I livorno
	0x00200242, // n0x0b0a c0x0000 (---------------)  + I lo
	0x00259dc4, // n0x0b0b c0x0000 (---------------)  + I lodi
	0x00214303, // n0x0b0c c0x0000 (---------------)  + I lom
	0x002c4149, // n0x0b0d c0x0000 (---------------)  + I lombardia
	0x002db908, // n0x0b0e c0x0000 (---------------)  + I lombardy
	0x00209e02, // n0x0b0f c0x0000 (---------------)  + I lt
	0x00202f42, // n0x0b10 c0x0000 (---------------)  + I lu
	0x0026d147, // n0x0b11 c0x0000 (---------------)  + I lucania
	0x002b6305, // n0x0b12 c0x0000 (---------------)  + I lucca
	0x00316908, // n0x0b13 c0x0000 (---------------)  + I macerata
	0x003a0a07, // n0x0b14 c0x0000 (---------------)  + I mantova
	0x00201183, // n0x0b15 c0x0000 (---------------)  + I mar
	0x00284246, // n0x0b16 c0x0000 (---------------)  + I marche
	0x002b39cd, // n0x0b17 c0x0000 (---------------)  + I massa-carrara
	0x002b3d4c, // n0x0b18 c0x0000 (---------------)  + I massacarrara
	0x00256e86, // n0x0b19 c0x0000 (---------------)  + I matera
	0x00208602, // n0x0b1a c0x0000 (---------------)  + I mb
	0x0022ac02, // n0x0b1b c0x0000 (---------------)  + I mc
	0x00203e82, // n0x0b1c c0x0000 (---------------)  + I me
	0x0024194f, // n0x0b1d c0x0000 (---------------)  + I medio-campidano
	0x00241d4e, // n0x0b1e c0x0000 (---------------)  + I mediocampidano
	0x00370147, // n0x0b1f c0x0000 (---------------)  + I messina
	0x00209002, // n0x0b20 c0x0000 (---------------)  + I mi
	0x00342685, // n0x0b21 c0x0000 (---------------)  + I milan
	0x00342686, // n0x0b22 c0x0000 (---------------)  + I milano
	0x0021fdc2, // n0x0b23 c0x0000 (---------------)  + I mn
	0x00207102, // n0x0b24 c0x0000 (---------------)  + I mo
	0x00218306, // n0x0b25 c0x0000 (---------------)  + I modena
	0x002133c3, // n0x0b26 c0x0000 (---------------)  + I mol
	0x0025dbc6, // n0x0b27 c0x0000 (---------------)  + I molise
	0x002c2d45, // n0x0b28 c0x0000 (---------------)  + I monza
	0x002c2d4d, // n0x0b29 c0x0000 (---------------)  + I monza-brianza
	0x002c3595, // n0x0b2a c0x0000 (---------------)  + I monza-e-della-brianza
	0x002c3d4c, // n0x0b2b c0x0000 (---------------)  + I monzabrianza
	0x002c4a4d, // n0x0b2c c0x0000 (---------------)  + I monzaebrianza
	0x002c4e12, // n0x0b2d c0x0000 (---------------)  + I monzaedellabrianza
	0x0020f702, // n0x0b2e c0x0000 (---------------)  + I ms
	0x00204c02, // n0x0b2f c0x0000 (---------------)  + I mt
	0x00201402, // n0x0b30 c0x0000 (---------------)  + I na
	0x00235006, // n0x0b31 c0x0000 (---------------)  + I naples
	0x002a3d86, // n0x0b32 c0x0000 (---------------)  + I napoli
	0x00200c02, // n0x0b33 c0x0000 (---------------)  + I no
	0x002058c6, // n0x0b34 c0x0000 (---------------)  + I novara
	0x002017c2, // n0x0b35 c0x0000 (---------------)  + I nu
	0x0039c105, // n0x0b36 c0x0000 (---------------)  + I nuoro
	0x00200c42, // n0x0b37 c0x0000 (---------------)  + I og
	0x0025a4c9, // n0x0b38 c0x0000 (---------------)  + I ogliastra
	0x0027568c, // n0x0b39 c0x0000 (---------------)  + I olbia-tempio
	0x002759cb, // n0x0b3a c0x0000 (---------------)  + I olbiatempio
	0x00200282, // n0x0b3b c0x0000 (---------------)  + I or
	0x00252b88, // n0x0b3c c0x0000 (---------------)  + I oristano
	0x00200782, // n0x0b3d c0x0000 (---------------)  + I ot
	0x0020ac42, // n0x0b3e c0x0000 (---------------)  + I pa
	0x00216d86, // n0x0b3f c0x0000 (---------------)  + I padova
	0x00361405, // n0x0b40 c0x0000 (---------------)  + I padua
	0x00379f47, // n0x0b41 c0x0000 (---------------)  + I palermo
	0x00395345, // n0x0b42 c0x0000 (---------------)  + I parma
	0x002dbfc5, // n0x0b43 c0x0000 (---------------)  + I pavia
	0x00248182, // n0x0b44 c0x0000 (---------------)  + I pc
	0x00352102, // n0x0b45 c0x0000 (---------------)  + I pd
	0x00207782, // n0x0b46 c0x0000 (---------------)  + I pe
	0x00270d47, // n0x0b47 c0x0000 (---------------)  + I perugia
	0x0031c84d, // n0x0b48 c0x0000 (---------------)  + I pesaro-urbino
	0x0031cbcc, // n0x0b49 c0x0000 (---------------)  + I pesarourbino
	0x00236987, // n0x0b4a c0x0000 (---------------)  + I pescara
	0x002495c2, // n0x0b4b c0x0000 (---------------)  + I pg
	0x00225702, // n0x0b4c c0x0000 (---------------)  + I pi
	0x00338288, // n0x0b4d c0x0000 (---------------)  + I piacenza
	0x00258dc8, // n0x0b4e c0x0000 (---------------)  + I piedmont
	0x002d6308, // n0x0b4f c0x0000 (---------------)  + I piemonte
	0x002df704, // n0x0b50 c0x0000 (---------------)  + I pisa
	0x002bee07, // n0x0b51 c0x0000 (---------------)  + I pistoia
	0x002dcc83, // n0x0b52 c0x0000 (---------------)  + I pmn
	0x002493c2, // n0x0b53 c0x0000 (---------------)  + I pn
	0x00200942, // n0x0b54 c0x0000 (---------------)  + I po
	0x002dfec9, // n0x0b55 c0x0000 (---------------)  + I pordenone
	0x002093c7, // n0x0b56 c0x0000 (---------------)  + I potenza
	0x00204602, // n0x0b57 c0x0000 (---------------)  + I pr
	0x00270245, // n0x0b58 c0x0000 (---------------)  + I prato
	0x0028c9c2, // n0x0b59 c0x0000 (---------------)  + I pt
	0x00235302, // n0x0b5a c0x0000 (---------------)  + I pu
	0x00278843, // n0x0b5b c0x0000 (---------------)  + I pug
	0x00278846, // n0x0b5c c0x0000 (---------------)  + I puglia
	0x002e5542, // n0x0b5d c0x0000 (---------------)  + I pv
	0x002e6302, // n0x0b5e c0x0000 (---------------)  + I pz
	0x002005c2, // n0x0b5f c0x0000 (---------------)  + I ra
	0x0030c246, // n0x0b60 c0x0000 (---------------)  + I ragusa
	0x002059c7, // n0x0b61 c0x0000 (---------------)  + I ravenna
	0x002002c2, // n0x0b62 c0x0000 (---------------)  + I rc
	0x00207002, // n0x0b63 c0x0000 (---------------)  + I re
	0x002ed34f, // n0x0b64 c0x0000 (---------------)  + I reggio-calabria
	0x0025420d, // n0x0b65 c0x0000 (---------------)  + I reggio-emilia
	0x0028550e, // n0x0b66 c0x0000 (---------------)  + I reggiocalabria
	0x0036da8c, // n0x0b67 c0x0000 (---------------)  + I reggioemilia
	0x0020ce02, // n0x0b68 c0x0000 (---------------)  + I rg
	0x00200a82, // n0x0b69 c0x0000 (---------------)  + I ri
	0x00223445, // n0x0b6a c0x0000 (---------------)  + I rieti
	0x003a5bc6, // n0x0b6b c0x0000 (---------------)  + I rimini
	0x00222182, // n0x0b6c c0x0000 (---------------)  + I rm
	0x0020cb42, // n0x0b6d c0x0000 (---------------)  + I rn
	0x00202202, // n0x0b6e c0x0000 (---------------)  + I ro
	0x00254584, // n0x0b6f c0x0000 (---------------)  + I roma
	0x002dd584, // n0x0b70 c0x0000 (---------------)  + I rome
	0x00334fc6, // n0x0b71 c0x0000 (---------------)  + I rovigo
	0x002004c2, // n0x0b72 c0x0000 (---------------)  + I sa
	0x00279747, // n0x0b73 c0x0000 (---------------)  + I salerno
	0x002257c3, // n0x0b74 c0x0000 (---------------)  + I sar
	0x00226048, // n0x0b75 c0x0000 (---------------)  + I sardegna
	0x00227248, // n0x0b76 c0x0000 (---------------)  + I sardinia
	0x00378687, // n0x0b77 c0x0000 (---------------)  + I sassari
	0x00234f06, // n0x0b78 c0x0000 (---------------)  + I savona
	0x0020a402, // n0x0b79 c0x0000 (---------------)  + I si
	0x0023eac3, // n0x0b7a c0x0000 (---------------)  + I sic
	0x0036e647, // n0x0b7b c0x0000 (---------------)  + I sicilia
	0x00252146, // n0x0b7c c0x0000 (---------------)  + I sicily
	0x002c8945, // n0x0b7d c0x0000 (---------------)  + I siena
	0x003419c8, // n0x0b7e c0x0000 (---------------)  + I siracusa
	0x00205682, // n0x0b7f c0x0000 (---------------)  + I so
	0x00308547, // n0x0b80 c0x0000 (---------------)  + I sondrio
	0x00209382, // n0x0b81 c0x0000 (---------------)  + I sp
	0x0033b802, // n0x0b82 c0x0000 (---------------)  + I sr
	0x002067c2, // n0x0b83 c0x0000 (---------------)  + I ss
	0x002cebc9, // n0x0b84 c0x0000 (---------------)  + I suedtirol
	0x00235f42, // n0x0b85 c0x0000 (---------------)  + I sv
	0x00200a02, // n0x0b86 c0x0000 (---------------)  + I ta
	0x00234603, // n0x0b87 c0x0000 (---------------)  + I taa
	0x003096c7, // n0x0b88 c0x0000 (---------------)  + I taranto
	0x002012c2, // n0x0b89 c0x0000 (---------------)  + I te
	0x0027580c, // n0x0b8a c0x0000 (---------------)  + I tempio-olbia
	0x00275b0b, // n0x0b8b c0x0000 (---------------)  + I tempioolbia
	0x00256f06, // n0x0b8c c0x0000 (---------------)  + I teramo
	0x0020cac5, // n0x0b8d c0x0000 (---------------)  + I terni
	0x0024f882, // n0x0b8e c0x0000 (---------------)  + I tn
	0x00208082, // n0x0b8f c0x0000 (---------------)  + I to
	0x002b1946, // n0x0b90 c0x0000 (---------------)  + I torino
	0x002280c3, // n0x0b91 c0x0000 (---------------)  + I tos
	0x00324e47, // n0x0b92 c0x0000 (---------------)  + I toscana
	0x00211f42, // n0x0b93 c0x0000 (---------------)  + I tp
	0x00203002, // n0x0b94 c0x0000 (---------------)  + I tr
	0x00284655, // n0x0b95 c0x0000 (---------------)  + I trani-andria-barletta
	0x00233e15, // n0x0b96 c0x0000 (---------------)  + I trani-barletta-andria
	0x002903d3, // n0x0b97 c0x0000 (---------------)  + I traniandriabarletta
	0x00234353, // n0x0b98 c0x0000 (---------------)  + I tranibarlettaandria
	0x00294a07, // n0x0b99 c0x0000 (---------------)  + I trapani
	0x002b7688, // n0x0b9a c0x0000 (---------------)  + I trentino
	0x002cf4d0, // n0x0b9b c0x0000 (---------------)  + I trentino-a-adige
	0x002ef2cf, // n0x0b9c c0x0000 (---------------)  + I trentino-aadige
	0x00342d53, // n0x0b9d c0x0000 (---------------)  + I trentino-alto-adige
	0x0034eb92, // n0x0b9e c0x0000 (---------------)  + I trentino-altoadige
	0x002cd090, // n0x0b9f c0x0000 (---------------)  + I trentino-s-tirol
	0x002b768f, // n0x0ba0 c0x0000 (---------------)  + I trentino-stirol
	0x002ba492, // n0x0ba1 c0x0000 (---------------)  + I trentino-sud-tirol
	0x002c2911, // n0x0ba2 c0x0000 (---------------)  + I trentino-sudtirol
	0x002ca953, // n0x0ba3 c0x0000 (---------------)  + I trentino-sued-tirol
	0x002ce992, // n0x0ba4 c0x0000 (---------------)  + I trentino-suedtirol
	0x002cfd4f, // n0x0ba5 c0x0000 (---------------)  + I trentinoa-adige
	0x002d4c8e, // n0x0ba6 c0x0000 (---------------)  + I trentinoaadige
	0x002dfa52, // n0x0ba7 c0x0000 (---------------)  + I trentinoalto-adige
	0x002e3291, // n0x0ba8 c0x0000 (---------------)  + I trentinoaltoadige
	0x002e3a8f, // n0x0ba9 c0x0000 (---------------)  + I trentinos-tirol
	0x002e55ce, // n0x0baa c0x0000 (---------------)  + I trentinostirol
	0x002e6691, // n0x0bab c0x0000 (---------------)  + I trentinosud-tirol
	0x002f3a90, // n0x0bac c0x0000 (---------------)  + I trentinosudtirol
	0x0035a592, // n0x0bad c0x0000 (---------------)  + I trentinosued-tirol
	0x002e8b91, // n0x0bae c0x0000 (---------------)  + I trentinosuedtirol
	0x002f8a86, // n0x0baf c0x0000 (---------------)  + I trento
	0x002f9307, // n0x0bb0 c0x0000 (---------------)  + I treviso
	0x003673c7, // n0x0bb1 c0x0000 (---------------)  + I trieste
	0x00203f42, // n0x0bb2 c0x0000 (---------------)  + I ts
	0x0027f145, // n0x0bb3 c0x0000 (---------------)  + I turin
	0x002f2c87, // n0x0bb4 c0x0000 (---------------)  + I tuscany
	0x00224e42, // n0x0bb5 c0x0000 (---------------)  + I tv
	0x00209242, // n0x0bb6 c0x0000 (---------------)  + I ud
	0x0022a285, // n0x0bb7 c0x0000 (---------------)  + I udine
	0x0021e183, // n0x0bb8 c0x0000 (---------------)  + I umb
	0x00258406, // n0x0bb9 c0x0000 (---------------)  + I umbria
	0x0031ca0d, // n0x0bba c0x0000 (---------------)  + I urbino-pesaro
	0x0031cd4c, // n0x0bbb c0x0000 (---------------)  + I urbinopesaro
	0x002000c2, // n0x0bbc c0x0000 (---------------)  + I va
	0x0030f18b, // n0x0bbd c0x0000 (---------------)  + I val-d-aosta
	0x00216e8a, // n0x0bbe c0x0000 (---------------)  + I val-daosta
	0x00323dca, // n0x0bbf c0x0000 (---------------)  + I vald-aosta
	0x002b09c9, // n0x0bc0 c0x0000 (---------------)  + I valdaosta
	0x002deb4b, // n0x0bc1 c0x0000 (---------------)  + I valle-aosta
	0x003a0b4d, // n0x0bc2 c0x0000 (---------------)  + I valle-d-aosta
	0x002f338c, // n0x0bc3 c0x0000 (---------------)  + I valle-daosta
	0x00224e8a, // n0x0bc4 c0x0000 (---------------)  + I valleaosta
	0x0022594c, // n0x0bc5 c0x0000 (---------------)  + I valled-aosta
	0x0024098b, // n0x0bc6 c0x0000 (---------------)  + I valledaosta
	0x00250ecc, // n0x0bc7 c0x0000 (---------------)  + I vallee-aoste
	0x0025184b, // n0x0bc8 c0x0000 (---------------)  + I valleeaoste
	0x00275603, // n0x0bc9 c0x0000 (---------------)  + I vao
	0x002894c6, // n0x0bca c0x0000 (---------------)  + I varese
	0x002dc5c2, // n0x0bcb c0x0000 (---------------)  + I vb
	0x002e6b02, // n0x0bcc c0x0000 (---------------)  + I vc
	0x00210243, // n0x0bcd c0x0000 (---------------)  + I vda
	0x00202b82, // n0x0bce c0x0000 (---------------)  + I ve
	0x00202b83, // n0x0bcf c0x0000 (---------------)  + I ven
	0x00375e46, // n0x0bd0 c0x0000 (---------------)  + I veneto
	0x00261247, // n0x0bd1 c0x0000 (---------------)  + I venezia
	0x0026f246, // n0x0bd2 c0x0000 (---------------)  + I venice
	0x0022d688, // n0x0bd3 c0x0000 (---------------)  + I verbania
	0x002dddc8, // n0x0bd4 c0x0000 (---------------)  + I vercelli
	0x003607c6, // n0x0bd5 c0x0000 (---------------)  + I verona
	0x00205d42, // n0x0bd6 c0x0000 (---------------)  + I vi
	0x002f504d, // n0x0bd7 c0x0000 (---------------)  + I vibo-valentia
	0x002f538c, // n0x0bd8 c0x0000 (---------------)  + I vibovalentia
	0x0033d887, // n0x0bd9 c0x0000 (---------------)  + I vicenza
	0x002f9107, // n0x0bda c0x0000 (---------------)  + I viterbo
	0x00211082, // n0x0bdb c0x0000 (---------------)  + I vr
	0x00227982, // n0x0bdc c0x0000 (---------------)  + I vs
	0x00271f82, // n0x0bdd c0x0000 (---------------)  + I vt
	0x00214982, // n0x0bde c0x0000 (---------------)  + I vv
	0x00200742, // n0x0bdf c0x0000 (---------------)  + I co
	0x0021fe03, // n0x0be0 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0be1 c0x0000 (---------------)  + I org
	0x00233503, // n0x0be2 c0x0000 (---------------)  + I com
	0x0023a783, // n0x0be3 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x0be4 c0x0000 (---------------)  + I gov
	0x00209003, // n0x0be5 c0x0000 (---------------)  + I mil
	0x00205284, // n0x0be6 c0x0000 (---------------)  + I name
	0x0021fe03, // n0x0be7 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x0be8 c0x0000 (---------------)  + I org
	0x00217443, // n0x0be9 c0x0000 (---------------)  + I sch
	0x00201542, // n0x0bea c0x0000 (---------------)  + I ac
	0x00200342, // n0x0beb c0x0000 (---------------)  + I ad
	0x2068f505, // n0x0bec c0x0081 (n0x0c59-n0x0c8d)  + I aichi
	0x20a01dc5, // n0x0bed c0x0082 (n0x0c8d-n0x0ca9)  + I akita
	0x20f0bf06, // n0x0bee c0x0083 (n0x0ca9-n0x0cbf)  + I aomori
	0x000ffa08, // n0x0bef c0x0000 (---------------)  +   blogspot
	0x212add45, // n0x0bf0 c0x0084 (n0x0cbf-n0x0cf9)  + I chiba
	0x00200742, // n0x0bf1 c0x0000 (---------------)  + I co
	0x00202602, // n0x0bf2 c0x0000 (---------------)  + I ed
	0x21629005, // n0x0bf3 c0x0085 (n0x0cf9-n0x0d0f)  + I ehime
	0x21a7dac5, // n0x0bf4 c0x0086 (n0x0d0f-n0x0d1e)  + I fukui
	0x21e7e807, // n0x0bf5 c0x0087 (n0x0d1e-n0x0d5d)  + I fukuoka
	0x2232fcc9, // n0x0bf6 c0x0088 (n0x0d5d-n0x0d90)  + I fukushima
	0x2276aec4, // n0x0bf7 c0x0089 (n0x0d90-n0x0db6)  + I gifu
	0x00202d42, // n0x0bf8 c0x0000 (---------------)  + I go
	0x00200c82, // n0x0bf9 c0x0000 (---------------)  + I gr
	0x22b66385, // n0x0bfa c0x008a (n0x0db6-n0x0dda)  + I gunma
	0x22e0ee49, // n0x0bfb c0x008b (n0x0dda-n0x0df3)  + I hiroshima
	0x23369e88, // n0x0bfc c0x008c (n0x0df3-n0x0e81)  + I hokkaido
	0x236aba85, // n0x0bfd c0x008d (n0x0e81-n0x0eaf)  + I hyogo
	0x23ac1ac7, // n0x0bfe c0x008e (n0x0eaf-n0x0ee2)  + I ibaraki
	0x23e1a4c8, // n0x0bff c0x008f (n0x0ee2-n0x0ef5)  + I ishikawa
	0x242d8485, // n0x0c00 c0x0090 (n0x0ef5-n0x0f17)  + I iwate
	0x24600fc6, // n0x0c01 c0x0091 (n0x0f17-n0x0f26)  + I kagawa
	0x24a76189, // n0x0c02 c0x0092 (n0x0f26-n0x0f3a)  + I kagoshima
	0x24f1a4c8, // n0x0c03 c0x0093 (n0x0f3a-n0x0f58)  + I kanagawa
	0x252b9088, // n0x0c04 c0x0094 (n0x0f58-n0x0f59)* o I kawasaki
	0x2569c90a, // n0x0c05 c0x0095 (n0x0f59-n0x0f5a)* o I kitakyushu
	0x25a4f544, // n0x0c06 c0x0096 (n0x0f5a-n0x0f5b)* o I kobe
	0x25ecb145, // n0x0c07 c0x0097 (n0x0f5b-n0x0f7a)  + I kochi
	0x262b3748, // n0x0c08 c0x0098 (n0x0f7a-n0x0f94)  + I kumamoto
	0x266be0c5, // n0x0c09 c0x0099 (n0x0f94-n0x0fb3)  + I kyoto
	0x00219082, // n0x0c0a c0x0000 (---------------)  + I lg
	0x26a4b943, // n0x0c0b c0x009a (n0x0fb3-n0x0fd1)  + I mie
	0x26ea29c6, // n0x0c0c c0x009b (n0x0fd1-n0x0ff2)  + I miyagi
	0x27266108, // n0x0c0d c0x009c (n0x0ff2-n0x100d)  + I miyazaki
	0x27754f86, // n0x0c0e c0x009d (n0x100d-n0x1058)  + I nagano
	0x27adda48, // n0x0c0f c0x009e (n0x1058-n0x106e)  + I nagasaki
	0x27f0f646, // n0x0c10 c0x009f (n0x106e-n0x106f)* o I nagoya
	0x282c8a04, // n0x0c11 c0x00a0 (n0x106f-n0x1095)  + I nara
	0x00202c02, // n0x0c12 c0x0000 (---------------)  + I ne
	0x2863ff87, // n0x0c13 c0x00a1 (n0x1095-n0x10b7)  + I niigata
	0x28aa8984, // n0x0c14 c0x00a2 (n0x10b7-n0x10ca)  + I oita
	0x28e78dc7, // n0x0c15 c0x00a3 (n0x10ca-n0x10e4)  + I okayama
	0x29395b47, // n0x0c16 c0x00a4 (n0x10e4-n0x110e)  + I okinawa
	0x00200282, // n0x0c17 c0x0000 (---------------)  + I or
	0x2969ac45, // n0x0c18 c0x00a5 (n0x110e-n0x1140)  + I osaka
	0x29a38904, // n0x0c19 c0x00a6 (n0x1140-n0x115a)  + I saga
	0x29ed9247, // n0x0c1a c0x00a7 (n0x115a-n0x119f)  + I saitama
	0x2a221087, // n0x0c1b c0x00a8 (n0x119f-n0x11a0)* o I sapporo
	0x2a682b06, // n0x0c1c c0x00a9 (n0x11a0-n0x11a1)* o I sendai
	0x2aa285c5, // n0x0c1d c0x00aa (n0x11a1-n0x11b8)  + I shiga
	0x2ae93dc7, // n0x0c1e c0x00ab (n0x11b8-n0x11cf)  + I shimane
	0x2b2b2608, // n0x0c1f c0x00ac (n0x11cf-n0x11f3)  + I shizuoka
	0x2b744e07, // n0x0c20 c0x00ad (n0x11f3-n0x1212)  + I tochigi
	0x2ba99fc9, // n0x0c21 c0x00ae (n0x1212-n0x1223)  + I tokushima
	0x2bf41c05, // n0x0c22 c0x00af (n0x1223-n0x125c)  + I tokyo
	0x2c2f8b87, // n0x0c23 c0x00b0 (n0x125c-n0x1269)  + I tottori
	0x2c68e9c6, // n0x0c24 c0x00b1 (n0x1269-n0x1281)  + I toyama
	0x2ca23ac8, // n0x0c25 c0x00b2 (n0x1281-n0x129e)  + I wakayama
	0x0038988d, // n0x0c26 c0x0000 (---------------)  + I xn--0trq7p7nn
	0x0024e389, // n0x0c27 c0x0000 (---------------)  + I xn--1ctwo
	0x0025c1cb, // n0x0c28 c0x0000 (---------------)  + I xn--1lqs03n
	0x0026024b, // n0x0c29 c0x0000 (---------------)  + I xn--1lqs71d
	0x0027348b, // n0x0c2a c0x0000 (---------------)  + I xn--2m4a15e
	0x002a5bcb, // n0x0c2b c0x0000 (---------------)  + I xn--32vp30h
	0x0030168b, // n0x0c2c c0x0000 (---------------)  + I xn--4it168d
	0x0030194b, // n0x0c2d c0x0000 (---------------)  + I xn--4it797k
	0x00301d89, // n0x0c2e c0x0000 (---------------)  + I xn--4pvxs
	0x00302c4b, // n0x0c2f c0x0000 (---------------)  + I xn--5js045d
	0x00302f0b, // n0x0c30 c0x0000 (---------------)  + I xn--5rtp49c
	0x0030338b, // n0x0c31 c0x0000 (---------------)  + I xn--5rtq34k
	0x003043ca, // n0x0c32 c0x0000 (---------------)  + I xn--6btw5a
	0x0030490a, // n0x0c33 c0x0000 (---------------)  + I xn--6orx2r
	0x00304f0c, // n0x0c34 c0x0000 (---------------)  + I xn--7t0a264c
	0x0030a1cb, // n0x0c35 c0x0000 (---------------)  + I xn--8ltr62k
	0x0030a74a, // n0x0c36 c0x0000 (---------------)  + I xn--8pvr4u
	0x0031918a, // n0x0c37 c0x0000 (---------------)  + I xn--c3s14m
	0x0032940e, // n0x0c38 c0x0000 (---------------)  + I xn--d5qv7z876c
	0x0032a1ce, // n0x0c39 c0x0000 (---------------)  + I xn--djrs72d6uy
	0x0032a54a, // n0x0c3a c0x0000 (---------------)  + I xn--djty4k
	0x0032bb0a, // n0x0c3b c0x0000 (---------------)  + I xn--efvn9s
	0x0032c78b, // n0x0c3c c0x0000 (---------------)  + I xn--ehqz56n
	0x0032ca4b, // n0x0c3d c0x0000 (---------------)  + I xn--elqq16h
	0x0032d78b, // n0x0c3e c0x0000 (---------------)  + I xn--f6qx53a
	0x0034834b, // n0x0c3f c0x0000 (---------------)  + I xn--k7yn95e
	0x0034894a, // n0x0c40 c0x0000 (---------------)  + I xn--kbrq7o
	0x0034960b, // n0x0c41 c0x0000 (---------------)  + I xn--klt787d
	0x003498ca, // n0x0c42 c0x0000 (---------------)  + I xn--kltp7d
	0x00349b4a, // n0x0c43 c0x0000 (---------------)  + I xn--kltx9a
	0x00349dca, // n0x0c44 c0x0000 (---------------)  + I xn--klty5x
	0x00367e8b, // n0x0c45 c0x0000 (---------------)  + I xn--mkru45i
	0x0037178b, // n0x0c46 c0x0000 (---------------)  + I xn--nit225k
	0x003733ce, // n0x0c47 c0x0000 (---------------)  + I xn--ntso0iqx3a
	0x0037374b, // n0x0c48 c0x0000 (---------------)  + I xn--ntsq17g
	0x0037b18b, // n0x0c49 c0x0000 (---------------)  + I xn--pssu33l
	0x0037d28b, // n0x0c4a c0x0000 (---------------)  + I xn--qqqt11m
	0x0038144a, // n0x0c4b c0x0000 (---------------)  + I xn--rht27z
	0x003816c9, // n0x0c4c c0x0000 (---------------)  + I xn--rht3d
	0x0038190a, // n0x0c4d c0x0000 (---------------)  + I xn--rht61e
	0x00382f8a, // n0x0c4e c0x0000 (---------------)  + I xn--rny31h
	0x00392e8b, // n0x0c4f c0x0000 (---------------)  + I xn--tor131o
	0x003949cb, // n0x0c50 c0x0000 (---------------)  + I xn--uist22h
	0x0039548a, // n0x0c51 c0x0000 (---------------)  + I xn--uisz3g
	0x003967cb, // n0x0c52 c0x0000 (---------------)  + I xn--uuwu58a
	0x0039a30b, // n0x0c53 c0x0000 (---------------)  + I xn--vgu402c
	0x003a520b, // n0x0c54 c0x0000 (---------------)  + I xn--zbx025d
	0x2ce808c8, // n0x0c55 c0x00b3 (n0x129e-n0x12c0)  + I yamagata
	0x2d2873c9, // n0x0c56 c0x00b4 (n0x12c0-n0x12d0)  + I yamaguchi
	0x2d6a15c9, // n0x0c57 c0x00b5 (n0x12d0-n0x12ec)  + I yamanashi
	0x2dad09c8, // n0x0c58 c0x00b6 (n0x12ec-n0x12ed)* o I yokohama
	0x00334d45, // n0x0c59 c0x0000 (---------------)  + I aisai
	0x00201883, // n0x0c5a c0x0000 (---------------)  + I ama
	0x00203fc4, // n0x0c5b c0x0000 (---------------)  + I anjo
	0x00360985, // n0x0c5c c0x0000 (---------------)  + I asuke
	0x0036ac06, // n0x0c5d c0x0000 (---------------)  + I chiryu
	0x002ac6c5, // n0x0c5e c0x0000 (---------------)  + I chita
	0x00286bc4, // n0x0c5f c0x0000 (---------------)  + I fuso
	0x0026ecc8, // n0x0c60 c0x0000 (---------------)  + I gamagori
	0x00256185, // n0x0c61 c0x0000 (---------------)  + I handa
	0x0028ff84, // n0x0c62 c0x0000 (---------------)  + I hazu
	0x002c3247, // n0x0c63 c0x0000 (---------------)  + I hekinan
	0x0029d24a, // n0x0c64 c0x0000 (---------------)  + I higashiura
	0x002d218a, // n0x0c65 c0x0000 (---------------)  + I ichinomiya
	0x0032bfc7, // n0x0c66 c0x0000 (---------------)  + I inazawa
	0x00201787, // n0x0c67 c0x0000 (---------------)  + I inuyama
	0x002f2007, // n0x0c68 c0x0000 (---------------)  + I isshiki
	0x0031d107, // n0x0c69 c0x0000 (---------------)  + I iwakura
	0x002a25c5, // n0x0c6a c0x0000 (---------------)  + I kanie
	0x00325246, // n0x0c6b c0x0000 (---------------)  + I kariya
	0x00321d87, // n0x0c6c c0x0000 (---------------)  + I kasugai
	0x002571c4, // n0x0c6d c0x0000 (---------------)  + I kira
	0x002f0206, // n0x0c6e c0x0000 (---------------)  + I kiyosu
	0x00296f06, // n0x0c6f c0x0000 (---------------)  + I komaki
	0x00206b85, // n0x0c70 c0x0000 (---------------)  + I konan
	0x00229444, // n0x0c71 c0x0000 (---------------)  + I kota
	0x002da306, // n0x0c72 c0x0000 (---------------)  + I mihama
	0x0029c447, // n0x0c73 c0x0000 (---------------)  + I miyoshi
	0x002251c6, // n0x0c74 c0x0000 (---------------)  + I nishio
	0x00266c47, // n0x0c75 c0x0000 (---------------)  + I nisshin
	0x0027cb43, // n0x0c76 c0x0000 (---------------)  + I obu
	0x00252346, // n0x0c77 c0x0000 (---------------)  + I oguchi
	0x00236085, // n0x0c78 c0x0000 (---------------)  + I oharu
	0x0027e907, // n0x0c79 c0x0000 (---------------)  + I okazaki
	0x002bf04a, // n0x0c7a c0x0000 (---------------)  + I owariasahi
	0x002ae744, // n0x0c7b c0x0000 (---------------)  + I seto
	0x00219288, // n0x0c7c c0x0000 (---------------)  + I shikatsu
	0x00299589, // n0x0c7d c0x0000 (---------------)  + I shinshiro
	0x002aff87, // n0x0c7e c0x0000 (---------------)  + I shitara
	0x002e8506, // n0x0c7f c0x0000 (---------------)  + I tahara
	0x00365ec8, // n0x0c80 c0x0000 (---------------)  + I takahama
	0x00307489, // n0x0c81 c0x0000 (---------------)  + I tobishima
	0x00375f44, // n0x0c82 c0x0000 (---------------)  + I toei
	0x00337204, // n0x0c83 c0x0000 (---------------)  + I togo
	0x002fa0c5, // n0x0c84 c0x0000 (---------------)  + I tokai
	0x002bfec8, // n0x0c85 c0x0000 (---------------)  + I tokoname
	0x002c0907, // n0x0c86 c0x0000 (---------------)  + I toyoake
	0x0028df09, // n0x0c87 c0x0000 (---------------)  + I toyohashi
	0x00247dc8, // n0x0c88 c0x0000 (---------------)  + I toyokawa
	0x00366606, // n0x0c89 c0x0000 (---------------)  + I toyone
	0x0025bb86, // n0x0c8a c0x0000 (---------------)  + I toyota
	0x00297a48, // n0x0c8b c0x0000 (---------------)  + I tsushima
	0x0036a786, // n0x0c8c c0x0000 (---------------)  + I yatomi
	0x00201dc5, // n0x0c8d c0x0000 (---------------)  + I akita
	0x00282bc6, // n0x0c8e c0x0000 (---------------)  + I daisen
	0x002790c8, // n0x0c8f c0x0000 (---------------)  + I fujisato
	0x0023ab86, // n0x0c90 c0x0000 (---------------)  + I gojome
	0x0025778b, // n0x0c91 c0x0000 (---------------)  + I hachirogata
	0x0028ab86, // n0x0c92 c0x0000 (---------------)  + I happou
	0x002997cd, // n0x0c93 c0x0000 (---------------)  + I higashinaruse
	0x0038e545, // n0x0c94 c0x0000 (---------------)  + I honjo
	0x002a8846, // n0x0c95 c0x0000 (---------------)  + I honjyo
	0x0021a585, // n0x0c96 c0x0000 (---------------)  + I ikawa
	0x00296349, // n0x0c97 c0x0000 (---------------)  + I kamikoani
	0x00320ec7, // n0x0c98 c0x0000 (---------------)  + I kamioka
	0x00378048, // n0x0c99 c0x0000 (---------------)  + I katagami
	0x00305386, // n0x0c9a c0x0000 (---------------)  + I kazuno
	0x002983c9, // n0x0c9b c0x0000 (---------------)  + I kitaakita
	0x002dd306, // n0x0c9c c0x0000 (---------------)  + I kosaka
	0x002befc5, // n0x0c9d c0x0000 (---------------)  + I kyowa
	0x0022f486, // n0x0c9e c0x0000 (---------------)  + I misato
	0x002b16c6, // n0x0c9f c0x0000 (---------------)  + I mitane
	0x002c6849, // n0x0ca0 c0x0000 (---------------)  + I moriyoshi
	0x0033cfc6, // n0x0ca1 c0x0000 (---------------)  + I nikaho
	0x0037ebc7, // n0x0ca2 c0x0000 (---------------)  + I noshiro
	0x002c5f85, // n0x0ca3 c0x0000 (---------------)  + I odate
	0x00202a03, // n0x0ca4 c0x0000 (---------------)  + I oga
	0x00223845, // n0x0ca5 c0x0000 (---------------)  + I ogata
	0x002a6287, // n0x0ca6 c0x0000 (---------------)  + I semboku
	0x00330a06, // n0x0ca7 c0x0000 (---------------)  + I yokote
	0x0038e449, // n0x0ca8 c0x0000 (---------------)  + I yurihonjo
	0x0030bf06, // n0x0ca9 c0x0000 (---------------)  + I aomori
	0x00282e06, // n0x0caa c0x0000 (---------------)  + I gonohe
	0x0020db09, // n0x0cab c0x0000 (---------------)  + I hachinohe
	0x002825c9, // n0x0cac c0x0000 (---------------)  + I hashikami
	0x0029f407, // n0x0cad c0x0000 (---------------)  + I hiranai
	0x002eb708, // n0x0cae c0x0000 (---------------)  + I hirosaki
	0x002692c9, // n0x0caf c0x0000 (---------------)  + I itayanagi
	0x0027edc8, // n0x0cb0 c0x0000 (---------------)  + I kuroishi
	0x0037d506, // n0x0cb1 c0x0000 (---------------)  + I misawa
	0x002d0505, // n0x0cb2 c0x0000 (---------------)  + I mutsu
	0x0021e54a, // n0x0cb3 c0x0000 (---------------)  + I nakadomari
	0x00282e86, // n0x0cb4 c0x0000 (---------------)  + I noheji
	0x00207e46, // n0x0cb5 c0x0000 (---------------)  + I oirase
	0x002a2b85, // n0x0cb6 c0x0000 (---------------)  + I owani
	0x0036b208, // n0x0cb7 c0x0000 (---------------)  + I rokunohe
	0x0020ea87, // n0x0cb8 c0x0000 (---------------)  + I sannohe
	0x0023638a, // n0x0cb9 c0x0000 (---------------)  + I shichinohe
	0x0024e0c6, // n0x0cba c0x0000 (---------------)  + I shingo
	0x00240bc5, // n0x0cbb c0x0000 (---------------)  + I takko
	0x0024a2c6, // n0x0cbc c0x0000 (---------------)  + I towada
	0x00297647, // n0x0cbd c0x0000 (---------------)  + I tsugaru
	0x002e83c7, // n0x0cbe c0x0000 (---------------)  + I tsuruta
	0x0037e845, // n0x0cbf c0x0000 (---------------)  + I abiko
	0x002bf185, // n0x0cc0 c0x0000 (---------------)  + I asahi
	0x002e59c6, // n0x0cc1 c0x0000 (---------------)  + I chonan
	0x002e6b46, // n0x0cc2 c0x0000 (---------------)  + I chosei
	0x00300346, // n0x0cc3 c0x0000 (---------------)  + I choshi
	0x0030ba84, // n0x0cc4 c0x0000 (---------------)  + I chuo
	0x00281689, // n0x0cc5 c0x0000 (---------------)  + I funabashi
	0x00288286, // n0x0cc6 c0x0000 (---------------)  + I futtsu
	0x0034ad4a, // n0x0cc7 c0x0000 (---------------)  + I hanamigawa
	0x0028f548, // n0x0cc8 c0x0000 (---------------)  + I ichihara
	0x00265608, // n0x0cc9 c0x0000 (---------------)  + I ichikawa
	0x002d218a, // n0x0cca c0x0000 (---------------)  + I ichinomiya
	0x003a0f85, // n0x0ccb c0x0000 (---------------)  + I inzai
	0x0029c385, // n0x0ccc c0x0000 (---------------)  + I isumi
	0x00307d08, // n0x0ccd c0x0000 (---------------)  + I kamagaya
	0x002caec8, // n0x0cce c0x0000 (---------------)  + I kamogawa
	0x002037c7, // n0x0ccf c0x0000 (---------------)  + I kashiwa
	0x00294d86, // n0x0cd0 c0x0000 (---------------)  + I katori
	0x003141c8, // n0x0cd1 c0x0000 (---------------)  + I katsuura
	0x002303c7, // n0x0cd2 c0x0000 (---------------)  + I kimitsu
	0x00280d88, // n0x0cd3 c0x0000 (---------------)  + I kisarazu
	0x00368e86, // n0x0cd4 c0x0000 (---------------)  + I kozaki
	0x00283fc8, // n0x0cd5 c0x0000 (---------------)  + I kujukuri
	0x002b4246, // n0x0cd6 c0x0000 (---------------)  + I kyonan
	0x00243747, // n0x0cd7 c0x0000 (---------------)  + I matsudo
	0x00298e06, // n0x0cd8 c0x0000 (---------------)  + I midori
	0x002da306, // n0x0cd9 c0x0000 (---------------)  + I mihama
	0x0023c6ca, // n0x0cda c0x0000 (---------------)  + I minamiboso
	0x00234886, // n0x0cdb c0x0000 (---------------)  + I mobara
	0x002d0509, // n0x0cdc c0x0000 (---------------)  + I mutsuzawa
	0x002ae046, // n0x0cdd c0x0000 (---------------)  + I nagara
	0x002d164a, // n0x0cde c0x0000 (---------------)  + I nagareyama
	0x002c8a09, // n0x0cdf c0x0000 (---------------)  + I narashino
	0x0037df46, // n0x0ce0 c0x0000 (---------------)  + I narita
	0x0037f944, // n0x0ce1 c0x0000 (---------------)  + I noda
	0x003071cd, // n0x0ce2 c0x0000 (---------------)  + I oamishirasato
	0x00287647, // n0x0ce3 c0x0000 (---------------)  + I omigawa
	0x00316686, // n0x0ce4 c0x0000 (---------------)  + I onjuku
	0x002b8f45, // n0x0ce5 c0x0000 (---------------)  + I otaki
	0x002dd385, // n0x0ce6 c0x0000 (---------------)  + I sakae
	0x00307fc6, // n0x0ce7 c0x0000 (---------------)  + I sakura
	0x0028d9c9, // n0x0ce8 c0x0000 (---------------)  + I shimofusa
	0x002aaf87, // n0x0ce9 c0x0000 (---------------)  + I shirako
	0x0027a9c6, // n0x0cea c0x0000 (---------------)  + I shiroi
	0x002af8c6, // n0x0ceb c0x0000 (---------------)  + I shisui
	0x00286c49, // n0x0cec c0x0000 (---------------)  + I sodegaura
	0x0021f484, // n0x0ced c0x0000 (---------------)  + I sosa
	0x0036bcc4, // n0x0cee c0x0000 (---------------)  + I tako
	0x002040c8, // n0x0cef c0x0000 (---------------)  + I tateyama
	0x002aea86, // n0x0cf0 c0x0000 (---------------)  + I togane
	0x0029ed88, // n0x0cf1 c0x0000 (---------------)  + I tohnosho
	0x0022f408, // n0x0cf2 c0x0000 (---------------)  + I tomisato
	0x00280587, // n0x0cf3 c0x0000 (---------------)  + I urayasu
	0x003a6349, // n0x0cf4 c0x0000 (---------------)  + I yachimata
	0x00300547, // n0x0cf5 c0x0000 (---------------)  + I yachiyo
	0x002adc0a, // n0x0cf6 c0x0000 (---------------)  + I yokaichiba
	0x0022edcf, // n0x0cf7 c0x0000 (---------------)  + I yokoshibahikari
	0x00269dca, // n0x0cf8 c0x0000 (---------------)  + I yotsukaido
	0x00223245, // n0x0cf9 c0x0000 (---------------)  + I ainan
	0x00279305, // n0x0cfa c0x0000 (---------------)  + I honai
	0x00216985, // n0x0cfb c0x0000 (---------------)  + I ikata
	0x00249147, // n0x0cfc c0x0000 (---------------)  + I imabari
	0x00206043, // n0x0cfd c0x0000 (---------------)  + I iyo
	0x002eb908, // n0x0cfe c0x0000 (---------------)  + I kamijima
	0x002f5c86, // n0x0cff c0x0000 (---------------)  + I kihoku
	0x002f5d89, // n0x0d00 c0x0000 (---------------)  + I kumakogen
	0x003a3b06, // n0x0d01 c0x0000 (---------------)  + I masaki
	0x002c02c7, // n0x0d02 c0x0000 (---------------)  + I matsuno
	0x00298189, // n0x0d03 c0x0000 (---------------)  + I matsuyama
	0x00377f48, // n0x0d04 c0x0000 (---------------)  + I namikata
	0x002a2c47, // n0x0d05 c0x0000 (---------------)  + I niihama
	0x00300a43, // n0x0d06 c0x0000 (---------------)  + I ozu
	0x00334dc5, // n0x0d07 c0x0000 (---------------)  + I saijo
	0x002396c5, // n0x0d08 c0x0000 (---------------)  + I seiyo
	0x0030b8cb, // n0x0d09 c0x0000 (---------------)  + I shikokuchuo
	0x002be184, // n0x0d0a c0x0000 (---------------)  + I tobe
	0x0020b004, // n0x0d0b c0x0000 (---------------)  + I toon
	0x00278086, // n0x0d0c c0x0000 (---------------)  + I uchiko
	0x00300dc7, // n0x0d0d c0x0000 (---------------)  + I uwajima
	0x0038f14a, // n0x0d0e c0x0000 (---------------)  + I yawatahama
	0x0024b9c7, // n0x0d0f c0x0000 (---------------)  + I echizen
	0x00375fc7, // n0x0d10 c0x0000 (---------------)  + I eiheiji
	0x0027dac5, // n0x0d11 c0x0000 (---------------)  + I fukui
	0x00202585, // n0x0d12 c0x0000 (---------------)  + I ikeda
	0x0021ebc9, // n0x0d13 c0x0000 (---------------)  + I katsuyama
	0x002da306, // n0x0d14 c0x0000 (---------------)  + I mihama
	0x0024b84d, // n0x0d15 c0x0000 (---------------)  + I minamiechizen
	0x00395f05, // n0x0d16 c0x0000 (---------------)  + I obama
	0x00299783, // n0x0d17 c0x0000 (---------------)  + I ohi
	0x0020a703, // n0x0d18 c0x0000 (---------------)  + I ono
	0x002f6605, // n0x0d19 c0x0000 (---------------)  + I sabae
	0x0034ca05, // n0x0d1a c0x0000 (---------------)  + I sakai
	0x00365ec8, // n0x0d1b c0x0000 (---------------)  + I takahama
	0x0027b9c7, // n0x0d1c c0x0000 (---------------)  + I tsuruga
	0x0036ba46, // n0x0d1d c0x0000 (---------------)  + I wakasa
	0x0029d906, // n0x0d1e c0x0000 (---------------)  + I ashiya
	0x0022d885, // n0x0d1f c0x0000 (---------------)  + I buzen
	0x0023aa47, // n0x0d20 c0x0000 (---------------)  + I chikugo
	0x00201a07, // n0x0d21 c0x0000 (---------------)  + I chikuho
	0x00293107, // n0x0d22 c0x0000 (---------------)  + I chikujo
	0x002cb1ca, // n0x0d23 c0x0000 (---------------)  + I chikushino
	0x00252408, // n0x0d24 c0x0000 (---------------)  + I chikuzen
	0x0030ba84, // n0x0d25 c0x0000 (---------------)  + I chuo
	0x00214b07, // n0x0d26 c0x0000 (---------------)  + I dazaifu
	0x0027cc87, // n0x0d27 c0x0000 (---------------)  + I fukuchi
	0x0032c406, // n0x0d28 c0x0000 (---------------)  + I hakata
	0x00268047, // n0x0d29 c0x0000 (---------------)  + I higashi
	0x002d2bc8, // n0x0d2a c0x0000 (---------------)  + I hirokawa
	0x002a14c8, // n0x0d2b c0x0000 (---------------)  + I hisayama
	0x0026e786, // n0x0d2c c0x0000 (---------------)  + I iizuka
	0x0022b108, // n0x0d2d c0x0000 (---------------)  + I inatsuki
	0x002c6404, // n0x0d2e c0x0000 (---------------)  + I kaho
	0x00321d86, // n0x0d2f c0x0000 (---------------)  + I kasuga
	0x0020f406, // n0x0d30 c0x0000 (---------------)  + I kasuya
	0x00206106, // n0x0d31 c0x0000 (---------------)  + I kawara
	0x002ebf06, // n0x0d32 c0x0000 (---------------)  + I keisen
	0x00226304, // n0x0d33 c0x0000 (---------------)  + I koga
	0x0031d1c6, // n0x0d34 c0x0000 (---------------)  + I kurate
	0x002b81c6, // n0x0d35 c0x0000 (---------------)  + I kurogi
	0x002969c6, // n0x0d36 c0x0000 (---------------)  + I kurume
	0x00228406, // n0x0d37 c0x0000 (---------------)  + I minami
	0x0020a5c6, // n0x0d38 c0x0000 (---------------)  + I miyako
	0x002d2a06, // n0x0d39 c0x0000 (---------------)  + I miyama
	0x0036b948, // n0x0d3a c0x0000 (---------------)  + I miyawaka
	0x002f0088, // n0x0d3b c0x0000 (---------------)  + I mizumaki
	0x002cbdc8, // n0x0d3c c0x0000 (---------------)  + I munakata
	0x002ac8c8, // n0x0d3d c0x0000 (---------------)  + I nakagawa
	0x00307c86, // n0x0d3e c0x0000 (---------------)  + I nakama
	0x00211805, // n0x0d3f c0x0000 (---------------)  + I nishi
	0x00223806, // n0x0d40 c0x0000 (---------------)  + I nogata
	0x002abb05, // n0x0d41 c0x0000 (---------------)  + I ogori
	0x00380887, // n0x0d42 c0x0000 (---------------)  + I okagaki
	0x002060c5, // n0x0d43 c0x0000 (---------------)  + I okawa
	0x00215483, // n0x0d44 c0x0000 (---------------)  + I oki
	0x00203a85, // n0x0d45 c0x0000 (---------------)  + I omuta
	0x002b6104, // n0x0d46 c0x0000 (---------------)  + I onga
	0x0020a705, // n0x0d47 c0x0000 (---------------)  + I onojo
	0x00216003, // n0x0d48 c0x0000 (---------------)  + I oto
	0x002d87c7, // n0x0d49 c0x0000 (---------------)  + I saigawa
	0x0036fd08, // n0x0d4a c0x0000 (---------------)  + I sasaguri
	0x00266d06, // n0x0d4b c0x0000 (---------------)  + I shingu
	0x002a224d, // n0x0d4c c0x0000 (---------------)  + I shinyoshitomi
	0x002792c6, // n0x0d4d c0x0000 (---------------)  + I shonai
	0x00295a45, // n0x0d4e c0x0000 (---------------)  + I soeda
	0x002c6c03, // n0x0d4f c0x0000 (---------------)  + I sue
	0x002b3109, // n0x0d50 c0x0000 (---------------)  + I tachiarai
	0x002c1c86, // n0x0d51 c0x0000 (---------------)  + I tagawa
	0x00238646, // n0x0d52 c0x0000 (---------------)  + I takata
	0x0034cf44, // n0x0d53 c0x0000 (---------------)  + I toho
	0x00269d47, // n0x0d54 c0x0000 (---------------)  + I toyotsu
	0x0023bd46, // n0x0d55 c0x0000 (---------------)  + I tsuiki
	0x0036b045, // n0x0d56 c0x0000 (---------------)  + I ukiha
	0x0020b583, // n0x0d57 c0x0000 (---------------)  + I umi
	0x002066c4, // n0x0d58 c0x0000 (---------------)  + I usui
	0x0027ce46, // n0x0d59 c0x0000 (---------------)  + I yamada
	0x002a7d84, // n0x0d5a c0x0000 (---------------)  + I yame
	0x0030df48, // n0x0d5b c0x0000 (---------------)  + I yanagawa
	0x00383d09, // n0x0d5c c0x0000 (---------------)  + I yukuhashi
	0x002bde89, // n0x0d5d c0x0000 (---------------)  + I aizubange
	0x0029eb8a, // n0x0d5e c0x0000 (---------------)  + I aizumisato
	0x002453cd, // n0x0d5f c0x0000 (---------------)  + I aizuwakamatsu
	0x00248a07, // n0x0d60 c0x0000 (---------------)  + I asakawa
	0x00207cc6, // n0x0d61 c0x0000 (---------------)  + I bandai
	0x0020c7c4, // n0x0d62 c0x0000 (---------------)  + I date
	0x0032fcc9, // n0x0d63 c0x0000 (---------------)  + I fukushima
	0x002860c8, // n0x0d64 c0x0000 (---------------)  + I furudono
	0x00287246, // n0x0d65 c0x0000 (---------------)  + I futaba
	0x0025a746, // n0x0d66 c0x0000 (---------------)  + I hanawa
	0x00268047, // n0x0d67 c0x0000 (---------------)  + I higashi
	0x00347f46, // n0x0d68 c0x0000 (---------------)  + I hirata
	0x0021d4c6, // n0x0d69 c0x0000 (---------------)  + I hirono
	0x00384006, // n0x0d6a c0x0000 (---------------)  + I iitate
	0x00395bca, // n0x0d6b c0x0000 (---------------)  + I inawashiro
	0x0021a4c8, // n0x0d6c c0x0000 (---------------)  + I ishikawa
	0x0022da85, // n0x0d6d c0x0000 (---------------)  + I iwaki
	0x002802c9, // n0x0d6e c0x0000 (---------------)  + I izumizaki
	0x0028128a, // n0x0d6f c0x0000 (---------------)  + I kagamiishi
	0x002c7848, // n0x0d70 c0x0000 (---------------)  + I kaneyama
	0x0029b888, // n0x0d71 c0x0000 (---------------)  + I kawamata
	0x00295fc8, // n0x0d72 c0x0000 (---------------)  + I kitakata
	0x00201e0c, // n0x0d73 c0x0000 (---------------)  + I kitashiobara
	0x002d5305, // n0x0d74 c0x0000 (---------------)  + I koori
	0x0029db88, // n0x0d75 c0x0000 (---------------)  + I koriyama
	0x00342586, // n0x0d76 c0x0000 (---------------)  + I kunimi
	0x00306306, // n0x0d77 c0x0000 (---------------)  + I miharu
	0x002bf3c7, // n0x0d78 c0x0000 (---------------)  + I mishima
	0x0024b8c5, // n0x0d79 c0x0000 (---------------)  + I namie
	0x00282d45, // n0x0d7a c0x0000 (---------------)  + I nango
	0x002bdd49, // n0x0d7b c0x0000 (---------------)  + I nishiaizu
	0x00211d87, // n0x0d7c c0x0000 (---------------)  + I nishigo
	0x002f5d45, // n0x0d7d c0x0000 (---------------)  + I okuma
	0x0021f187, // n0x0d7e c0x0000 (---------------)  + I omotego
	0x0020a703, // n0x0d7f c0x0000 (---------------)  + I ono
	0x002c0e45, // n0x0d80 c0x0000 (---------------)  + I otama
	0x00346648, // n0x0d81 c0x0000 (---------------)  + I samegawa
	0x002b1287, // n0x0d82 c0x0000 (---------------)  + I shimogo
	0x0029b749, // n0x0d83 c0x0000 (---------------)  + I shirakawa
	0x00319905, // n0x0d84 c0x0000 (---------------)  + I showa
	0x0035d844, // n0x0d85 c0x0000 (---------------)  + I soma
	0x002a0308, // n0x0d86 c0x0000 (---------------)  + I sukagawa
	0x0022c747, // n0x0d87 c0x0000 (---------------)  + I taishin
	0x002a2e08, // n0x0d88 c0x0000 (---------------)  + I tamakawa
	0x00330f48, // n0x0d89 c0x0000 (---------------)  + I tanagura
	0x002d9885, // n0x0d8a c0x0000 (---------------)  + I tenei
	0x00350b06, // n0x0d8b c0x0000 (---------------)  + I yabuki
	0x0028f086, // n0x0d8c c0x0000 (---------------)  + I yamato
	0x00250089, // n0x0d8d c0x0000 (---------------)  + I yamatsuri
	0x00314a47, // n0x0d8e c0x0000 (---------------)  + I yanaizu
	0x002abfc6, // n0x0d8f c0x0000 (---------------)  + I yugawa
	0x0028ca87, // n0x0d90 c0x0000 (---------------)  + I anpachi
	0x002183c3, // n0x0d91 c0x0000 (---------------)  + I ena
	0x0036aec4, // n0x0d92 c0x0000 (---------------)  + I gifu
	0x002a0c45, // n0x0d93 c0x0000 (---------------)  + I ginan
	0x00214d84, // n0x0d94 c0x0000 (---------------)  + I godo
	0x00343c04, // n0x0d95 c0x0000 (---------------)  + I gujo
	0x00280b47, // n0x0d96 c0x0000 (---------------)  + I hashima
	0x00218a07, // n0x0d97 c0x0000 (---------------)  + I hichiso
	0x0027ab84, // n0x0d98 c0x0000 (---------------)  + I hida
	0x0029b590, // n0x0d99 c0x0000 (---------------)  + I higashishirakawa
	0x00308147, // n0x0d9a c0x0000 (---------------)  + I ibigawa
	0x00202585, // n0x0d9b c0x0000 (---------------)  + I ikeda
	0x002ef98c, // n0x0d9c c0x0000 (---------------)  + I kakamigahara
	0x00279cc4, // n0x0d9d c0x0000 (---------------)  + I kani
	0x0029b388, // n0x0d9e c0x0000 (---------------)  + I kasahara
	0x00243649, // n0x0d9f c0x0000 (---------------)  + I kasamatsu
	0x00301506, // n0x0da0 c0x0000 (---------------)  + I kawaue
	0x0021f588, // n0x0da1 c0x0000 (---------------)  + I kitagata
	0x0024ff84, // n0x0da2 c0x0000 (---------------)  + I mino
	0x002d7b88, // n0x0da3 c0x0000 (---------------)  + I minokamo
	0x00268506, // n0x0da4 c0x0000 (---------------)  + I mitake
	0x00228288, // n0x0da5 c0x0000 (---------------)  + I mizunami
	0x002a0946, // n0x0da6 c0x0000 (---------------)  + I motosu
	0x0037a2cb, // n0x0da7 c0x0000 (---------------)  + I nakatsugawa
	0x00202a05, // n0x0da8 c0x0000 (---------------)  + I ogaki
	0x002c6388, // n0x0da9 c0x0000 (---------------)  + I sakahogi
	0x00217fc4, // n0x0daa c0x0000 (---------------)  + I seki
	0x0028224a, // n0x0dab c0x0000 (---------------)  + I sekigahara
	0x0029b749, // n0x0dac c0x0000 (---------------)  + I shirakawa
	0x00312006, // n0x0dad c0x0000 (---------------)  + I tajimi
	0x002c0148, // n0x0dae c0x0000 (---------------)  + I takayama
	0x00274245, // n0x0daf c0x0000 (---------------)  + I tarui
	0x00222904, // n0x0db0 c0x0000 (---------------)  + I toki
	0x0029b286, // n0x0db1 c0x0000 (---------------)  + I tomika
	0x00292fc8, // n0x0db2 c0x0000 (---------------)  + I wanouchi
	0x002808c8, // n0x0db3 c0x0000 (---------------)  + I yamagata
	0x00341746, // n0x0db4 c0x0000 (---------------)  + I yaotsu
	0x00321484, // n0x0db5 c0x0000 (---------------)  + I yoro
	0x0021e4c6, // n0x0db6 c0x0000 (---------------)  + I annaka
	0x003005c7, // n0x0db7 c0x0000 (---------------)  + I chiyoda
	0x00278cc7, // n0x0db8 c0x0000 (---------------)  + I fujioka
	0x0026804f, // n0x0db9 c0x0000 (---------------)  + I higashiagatsuma
	0x00204687, // n0x0dba c0x0000 (---------------)  + I isesaki
	0x0037e007, // n0x0dbb c0x0000 (---------------)  + I itakura
	0x003061c5, // n0x0dbc c0x0000 (---------------)  + I kanna
	0x002e2345, // n0x0dbd c0x0000 (---------------)  + I kanra
	0x0029f0c9, // n0x0dbe c0x0000 (---------------)  + I katashina
	0x0026b7c6, // n0x0dbf c0x0000 (---------------)  + I kawaba
	0x0027f4c5, // n0x0dc0 c0x0000 (---------------)  + I kiryu
	0x002828c7, // n0x0dc1 c0x0000 (---------------)  + I kusatsu
	0x002c5d48, // n0x0dc2 c0x0000 (---------------)  + I maebashi
	0x002be885, // n0x0dc3 c0x0000 (---------------)  + I meiwa
	0x00298e06, // n0x0dc4 c0x0000 (---------------)  + I midori
	0x00216448, // n0x0dc5 c0x0000 (---------------)  + I minakami
	0x00354f8a, // n0x0dc6 c0x0000 (---------------)  + I naganohara
	0x00356448, // n0x0dc7 c0x0000 (---------------)  + I nakanojo
	0x003a1d07, // n0x0dc8 c0x0000 (---------------)  + I nanmoku
	0x0022f206, // n0x0dc9 c0x0000 (---------------)  + I numata
	0x00280286, // n0x0dca c0x0000 (---------------)  + I oizumi
	0x0021c683, // n0x0dcb c0x0000 (---------------)  + I ora
	0x00204083, // n0x0dcc c0x0000 (---------------)  + I ota
	0x00281449, // n0x0dcd c0x0000 (---------------)  + I shibukawa
	0x00269149, // n0x0dce c0x0000 (---------------)  + I shimonita
	0x00299ec6, // n0x0dcf c0x0000 (---------------)  + I shinto
	0x00319905, // n0x0dd0 c0x0000 (---------------)  + I showa
	0x002a06c8, // n0x0dd1 c0x0000 (---------------)  + I takasaki
	0x002c0148, // n0x0dd2 c0x0000 (---------------)  + I takayama
	0x0039a108, // n0x0dd3 c0x0000 (---------------)  + I tamamura
	0x0038408b, // n0x0dd4 c0x0000 (---------------)  + I tatebayashi
	0x002a2487, // n0x0dd5 c0x0000 (---------------)  + I tomioka
	0x002ff549, // n0x0dd6 c0x0000 (---------------)  + I tsukiyono
	0x002682c8, // n0x0dd7 c0x0000 (---------------)  + I tsumagoi
	0x00387304, // n0x0dd8 c0x0000 (---------------)  + I ueno
	0x002c6948, // n0x0dd9 c0x0000 (---------------)  + I yoshioka
	0x0028bb49, // n0x0dda c0x0000 (---------------)  + I asaminami
	0x002ac2c5, // n0x0ddb c0x0000 (---------------)  + I daiwa
	0x00249047, // n0x0ddc c0x0000 (---------------)  + I etajima
	0x002bc1c5, // n0x0ddd c0x0000 (---------------)  + I fuchu
	0x002807c8, // n0x0dde c0x0000 (---------------)  + I fukuyama
	0x0028f38b, // n0x0ddf c0x0000 (---------------)  + I hatsukaichi
	0x00293b10, // n0x0de0 c0x0000 (---------------)  + I higashihiroshima
	0x002a8645, // n0x0de1 c0x0000 (---------------)  + I hongo
	0x00217f0c, // n0x0de2 c0x0000 (---------------)  + I jinsekikogen
	0x0036bc05, // n0x0de3 c0x0000 (---------------)  + I kaita
	0x0027db43, // n0x0de4 c0x0000 (---------------)  + I kui
	0x00383786, // n0x0de5 c0x0000 (---------------)  + I kumano
	0x002b7544, // n0x0de6 c0x0000 (---------------)  + I kure
	0x003a69c6, // n0x0de7 c0x0000 (---------------)  + I mihara
	0x0029c447, // n0x0de8 c0x0000 (---------------)  + I miyoshi
	0x002164c4, // n0x0de9 c0x0000 (---------------)  + I naka
	0x002d2088, // n0x0dea c0x0000 (---------------)  + I onomichi
	0x002eb7cd, // n0x0deb c0x0000 (---------------)  + I osakikamijima
	0x00305a45, // n0x0dec c0x0000 (---------------)  + I otake
	0x002458c4, // n0x0ded c0x0000 (---------------)  + I saka
	0x00222f84, // n0x0dee c0x0000 (---------------)  + I sera
	0x0027fd49, // n0x0def c0x0000 (---------------)  + I seranishi
	0x00286908, // n0x0df0 c0x0000 (---------------)  + I shinichi
	0x0030bd87, // n0x0df1 c0x0000 (---------------)  + I shobara
	0x00268588, // n0x0df2 c0x0000 (---------------)  + I takehara
	0x00281748, // n0x0df3 c0x0000 (---------------)  + I abashiri
	0x0027acc5, // n0x0df4 c0x0000 (---------------)  + I abira
	0x00208b87, // n0x0df5 c0x0000 (---------------)  + I aibetsu
	0x0027ac47, // n0x0df6 c0x0000 (---------------)  + I akabira
	0x00209907, // n0x0df7 c0x0000 (---------------)  + I akkeshi
	0x002bf189, // n0x0df8 c0x0000 (---------------)  + I asahikawa
	0x0023bbc9, // n0x0df9 c0x0000 (---------------)  + I ashibetsu
	0x00244e86, // n0x0dfa c0x0000 (---------------)  + I ashoro
	0x002b4086, // n0x0dfb c0x0000 (---------------)  + I assabu
	0x00268286, // n0x0dfc c0x0000 (---------------)  + I atsuma
	0x0026a3c5, // n0x0dfd c0x0000 (---------------)  + I bibai
	0x002d81c4, // n0x0dfe c0x0000 (---------------)  + I biei
	0x00200ec6, // n0x0dff c0x0000 (---------------)  + I bifuka
	0x00202106, // n0x0e00 c0x0000 (---------------)  + I bihoro
	0x0027ad08, // n0x0e01 c0x0000 (---------------)  + I biratori
	0x0029730b, // n0x0e02 c0x0000 (---------------)  + I chippubetsu
	0x002ae607, // n0x0e03 c0x0000 (---------------)  + I chitose
	0x0020c7c4, // n0x0e04 c0x0000 (---------------)  + I date
	0x00223e46, // n0x0e05 c0x0000 (---------------)  + I ebetsu
	0x00283707, // n0x0e06 c0x0000 (---------------)  + I embetsu
	0x002f5f45, // n0x0e07 c0x0000 (---------------)  + I eniwa
	0x00239145, // n0x0e08 c0x0000 (---------------)  + I erimo
	0x00200484, // n0x0e09 c0x0000 (---------------)  + I esan
	0x0023bb46, // n0x0e0a c0x0000 (---------------)  + I esashi
	0x00200f48, // n0x0e0b c0x0000 (---------------)  + I fukagawa
	0x0032fcc9, // n0x0e0c c0x0000 (---------------)  + I fukushima
	0x00253846, // n0x0e0d c0x0000 (---------------)  + I furano
	0x00285888, // n0x0e0e c0x0000 (---------------)  + I furubira
	0x0036b106, // n0x0e0f c0x0000 (---------------)  + I haboro
	0x0032ccc8, // n0x0e10 c0x0000 (---------------)  + I hakodate
	0x002a9b8c, // n0x0e11 c0x0000 (---------------)  + I hamatonbetsu
	0x0027ab86, // n0x0e12 c0x0000 (---------------)  + I hidaka
	0x0029570d, // n0x0e13 c0x0000 (---------------)  + I higashikagura
	0x00295b8b, // n0x0e14 c0x0000 (---------------)  + I higashikawa
	0x0037ec85, // n0x0e15 c0x0000 (---------------)  + I hiroo
	0x00201b47, // n0x0e16 c0x0000 (---------------)  + I hokuryu
	0x0033d0c6, // n0x0e17 c0x0000 (---------------)  + I hokuto
	0x002e8288, // n0x0e18 c0x0000 (---------------)  + I honbetsu
	0x00244f09, // n0x0e19 c0x0000 (---------------)  + I horokanai
	0x002bd888, // n0x0e1a c0x0000 (---------------)  + I horonobe
	0x00202585, // n0x0e1b c0x0000 (---------------)  + I ikeda
	0x002fe547, // n0x0e1c c0x0000 (---------------)  + I imakane
	0x0027eec8, // n0x0e1d c0x0000 (---------------)  + I ishikari
	0x00272289, // n0x0e1e c0x0000 (---------------)  + I iwamizawa
	0x0023b0c6, // n0x0e1f c0x0000 (---------------)  + I iwanai
	0x0025c78a, // n0x0e20 c0x0000 (---------------)  + I kamifurano
	0x002e8008, // n0x0e21 c0x0000 (---------------)  + I kamikawa
	0x002bd6cb, // n0x0e22 c0x0000 (---------------)  + I kamishihoro
	0x00291a4c, // n0x0e23 c0x0000 (---------------)  + I kamisunagawa
	0x002d7c88, // n0x0e24 c0x0000 (---------------)  + I kamoenai
	0x0027c586, // n0x0e25 c0x0000 (---------------)  + I kayabe
	0x00208588, // n0x0e26 c0x0000 (---------------)  + I kembuchi
	0x002047c7, // n0x0e27 c0x0000 (---------------)  + I kikonai
	0x0023be49, // n0x0e28 c0x0000 (---------------)  + I kimobetsu
	0x0020ed4d, // n0x0e29 c0x0000 (---------------)  + I kitahiroshima
	0x0029d586, // n0x0e2a c0x0000 (---------------)  + I kitami
	0x00297008, // n0x0e2b c0x0000 (---------------)  + I kiyosato
	0x002eff49, // n0x0e2c c0x0000 (---------------)  + I koshimizu
	0x002b4a48, // n0x0e2d c0x0000 (---------------)  + I kunneppu
	0x002840c8, // n0x0e2e c0x0000 (---------------)  + I kuriyama
	0x002b8a8c, // n0x0e2f c0x0000 (---------------)  + I kuromatsunai
	0x002b9a07, // n0x0e30 c0x0000 (---------------)  + I kushiro
	0x002ba907, // n0x0e31 c0x0000 (---------------)  + I kutchan
	0x002befc5, // n0x0e32 c0x0000 (---------------)  + I kyowa
	0x0024eec7, // n0x0e33 c0x0000 (---------------)  + I mashike
	0x002c5c08, // n0x0e34 c0x0000 (---------------)  + I matsumae
	0x0029b306, // n0x0e35 c0x0000 (---------------)  + I mikasa
	0x002536cc, // n0x0e36 c0x0000 (---------------)  + I minamifurano
	0x002e3788, // n0x0e37 c0x0000 (---------------)  + I mombetsu
	0x002c7c48, // n0x0e38 c0x0000 (---------------)  + I moseushi
	0x002b6d86, // n0x0e39 c0x0000 (---------------)  + I mukawa
	0x003961c7, // n0x0e3a c0x0000 (---------------)  + I muroran
	0x00245084, // n0x0e3b c0x0000 (---------------)  + I naie
	0x002ac8c8, // n0x0e3c c0x0000 (---------------)  + I nakagawa
	0x0021840c, // n0x0e3d c0x0000 (---------------)  + I nakasatsunai
	0x0036decc, // n0x0e3e c0x0000 (---------------)  + I nakatombetsu
	0x002232c5, // n0x0e3f c0x0000 (---------------)  + I nanae
	0x0038ae07, // n0x0e40 c0x0000 (---------------)  + I nanporo
	0x00321406, // n0x0e41 c0x0000 (---------------)  + I nayoro
	0x00396146, // n0x0e42 c0x0000 (---------------)  + I nemuro
	0x00296508, // n0x0e43 c0x0000 (---------------)  + I niikappu
	0x0039e6c4, // n0x0e44 c0x0000 (---------------)  + I niki
	0x002251cb, // n0x0e45 c0x0000 (---------------)  + I nishiokoppe
	0x0033214b, // n0x0e46 c0x0000 (---------------)  + I noboribetsu
	0x0022f206, // n0x0e47 c0x0000 (---------------)  + I numata
	0x002eb647, // n0x0e48 c0x0000 (---------------)  + I obihiro
	0x00309145, // n0x0e49 c0x0000 (---------------)  + I obira
	0x0026f985, // n0x0e4a c0x0000 (---------------)  + I oketo
	0x00225306, // n0x0e4b c0x0000 (---------------)  + I okoppe
	0x00274205, // n0x0e4c c0x0000 (---------------)  + I otaru
	0x002be145, // n0x0e4d c0x0000 (---------------)  + I otobe
	0x002bf687, // n0x0e4e c0x0000 (---------------)  + I otofuke
	0x00278689, // n0x0e4f c0x0000 (---------------)  + I otoineppu
	0x002e6d04, // n0x0e50 c0x0000 (---------------)  + I oumu
	0x00277145, // n0x0e51 c0x0000 (---------------)  + I ozora
	0x002d72c5, // n0x0e52 c0x0000 (---------------)  + I pippu
	0x00289ac8, // n0x0e53 c0x0000 (---------------)  + I rankoshi
	0x002d1ec5, // n0x0e54 c0x0000 (---------------)  + I rebun
	0x002a7649, // n0x0e55 c0x0000 (---------------)  + I rikubetsu
	0x002a5647, // n0x0e56 c0x0000 (---------------)  + I rishiri
	0x002a564b, // n0x0e57 c0x0000 (---------------)  + I rishirifuji
	0x0031cf46, // n0x0e58 c0x0000 (---------------)  + I saroma
	0x0036b689, // n0x0e59 c0x0000 (---------------)  + I sarufutsu
	0x00229388, // n0x0e5a c0x0000 (---------------)  + I shakotan
	0x00259285, // n0x0e5b c0x0000 (---------------)  + I shari
	0x00209a08, // n0x0e5c c0x0000 (---------------)  + I shibecha
	0x0023bc08, // n0x0e5d c0x0000 (---------------)  + I shibetsu
	0x0021afc7, // n0x0e5e c0x0000 (---------------)  + I shikabe
	0x00280147, // n0x0e5f c0x0000 (---------------)  + I shikaoi
	0x00280bc9, // n0x0e60 c0x0000 (---------------)  + I shimamaki
	0x002281c7, // n0x0e61 c0x0000 (---------------)  + I shimizu
	0x00263849, // n0x0e62 c0x0000 (---------------)  + I shimokawa
	0x0029120c, // n0x0e63 c0x0000 (---------------)  + I shinshinotsu
	0x00299ec8, // n0x0e64 c0x0000 (---------------)  + I shintoku
	0x002d9d89, // n0x0e65 c0x0000 (---------------)  + I shiranuka
	0x002d5707, // n0x0e66 c0x0000 (---------------)  + I shiraoi
	0x00281809, // n0x0e67 c0x0000 (---------------)  + I shiriuchi
	0x00218b47, // n0x0e68 c0x0000 (---------------)  + I sobetsu
	0x00291b48, // n0x0e69 c0x0000 (---------------)  + I sunagawa
	0x00289e05, // n0x0e6a c0x0000 (---------------)  + I taiki
	0x00321d06, // n0x0e6b c0x0000 (---------------)  + I takasu
	0x002b8f88, // n0x0e6c c0x0000 (---------------)  + I takikawa
	0x002f8588, // n0x0e6d c0x0000 (---------------)  + I takinoue
	0x00281149, // n0x0e6e c0x0000 (---------------)  + I teshikaga
	0x002be187, // n0x0e6f c0x0000 (---------------)  + I tobetsu
	0x00270305, // n0x0e70 c0x0000 (---------------)  + I tohma
	0x0020bf49, // n0x0e71 c0x0000 (---------------)  + I tomakomai
	0x00269686, // n0x0e72 c0x0000 (---------------)  + I tomari
	0x0028e9c4, // n0x0e73 c0x0000 (---------------)  + I toya
	0x0034cc46, // n0x0e74 c0x0000 (---------------)  + I toyako
	0x00265f88, // n0x0e75 c0x0000 (---------------)  + I toyotomi
	0x0026ae47, // n0x0e76 c0x0000 (---------------)  + I toyoura
	0x00297508, // n0x0e77 c0x0000 (---------------)  + I tsubetsu
	0x0022b1c9, // n0x0e78 c0x0000 (---------------)  + I tsukigata
	0x002b6b07, // n0x0e79 c0x0000 (---------------)  + I urakawa
	0x0029d406, // n0x0e7a c0x0000 (---------------)  + I urausu
	0x00201c04, // n0x0e7b c0x0000 (---------------)  + I uryu
	0x00203b09, // n0x0e7c c0x0000 (---------------)  + I utashinai
	0x00208a08, // n0x0e7d c0x0000 (---------------)  + I wakkanai
	0x002b6c47, // n0x0e7e c0x0000 (---------------)  + I wassamu
	0x00325346, // n0x0e7f c0x0000 (---------------)  + I yakumo
	0x00239786, // n0x0e80 c0x0000 (---------------)  + I yoichi
	0x00207dc4, // n0x0e81 c0x0000 (---------------)  + I aioi
	0x002a8a46, // n0x0e82 c0x0000 (---------------)  + I akashi
	0x0020a683, // n0x0e83 c0x0000 (---------------)  + I ako
	0x002ec709, // n0x0e84 c0x0000 (---------------)  + I amagasaki
	0x002029c6, // n0x0e85 c0x0000 (---------------)  + I aogaki
	0x0029bac5, // n0x0e86 c0x0000 (---------------)  + I asago
	0x0029d906, // n0x0e87 c0x0000 (---------------)  + I ashiya
	0x002a2f45, // n0x0e88 c0x0000 (---------------)  + I awaji
	0x0027f348, // n0x0e89 c0x0000 (---------------)  + I fukusaki
	0x002d79c7, // n0x0e8a c0x0000 (---------------)  + I goshiki
	0x00205b86, // n0x0e8b c0x0000 (---------------)  + I harima
	0x00229046, // n0x0e8c c0x0000 (---------------)  + I himeji
	0x00265608, // n0x0e8d c0x0000 (---------------)  + I ichikawa
	0x0029f247, // n0x0e8e c0x0000 (---------------)  + I inagawa
	0x0029d5c5, // n0x0e8f c0x0000 (---------------)  + I itami
	0x0029de08, // n0x0e90 c0x0000 (---------------)  + I kakogawa
	0x00383348, // n0x0e91 c0x0000 (---------------)  + I kamigori
	0x002e8008, // n0x0e92 c0x0000 (---------------)  + I kamikawa
	0x0036bac5, // n0x0e93 c0x0000 (---------------)  + I kasai
	0x00321d86, // n0x0e94 c0x0000 (---------------)  + I kasuga
	0x002bdc49, // n0x0e95 c0x0000 (---------------)  + I kawanishi
	0x0028ef04, // n0x0e96 c0x0000 (---------------)  + I miki
	0x0036a88b, // n0x0e97 c0x0000 (---------------)  + I minamiawaji
	0x0021d1cb, // n0x0e98 c0x0000 (---------------)  + I nishinomiya
	0x0022d989, // n0x0e99 c0x0000 (---------------)  + I nishiwaki
	0x0020a703, // n0x0e9a c0x0000 (---------------)  + I ono
	0x00259bc5, // n0x0e9b c0x0000 (---------------)  + I sanda
	0x002069c6, // n0x0e9c c0x0000 (---------------)  + I sannan
	0x002db6c8, // n0x0e9d c0x0000 (---------------)  + I sasayama
	0x0022ed44, // n0x0e9e c0x0000 (---------------)  + I sayo
	0x00266d06, // n0x0e9f c0x0000 (---------------)  + I shingu
	0x002cb309, // n0x0ea0 c0x0000 (---------------)  + I shinonsen
	0x002af085, // n0x0ea1 c0x0000 (---------------)  + I shiso
	0x002bf5c6, // n0x0ea2 c0x0000 (---------------)  + I sumoto
	0x0022c746, // n0x0ea3 c0x0000 (---------------)  + I taishi
	0x00216a44, // n0x0ea4 c0x0000 (---------------)  + I taka
	0x0029614a, // n0x0ea5 c0x0000 (---------------)  + I takarazuka
	0x0029ba08, // n0x0ea6 c0x0000 (---------------)  + I takasago
	0x002f8586, // n0x0ea7 c0x0000 (---------------)  + I takino
	0x002ce105, // n0x0ea8 c0x0000 (---------------)  + I tamba
	0x0020d407, // n0x0ea9 c0x0000 (---------------)  + I tatsuno
	0x0024fbc7, // n0x0eaa c0x0000 (---------------)  + I toyooka
	0x00350b04, // n0x0eab c0x0000 (---------------)  + I yabu
	0x0021d407, // n0x0eac c0x0000 (---------------)  + I yashiro
	0x00206084, // n0x0ead c0x0000 (---------------)  + I yoka
	0x00206086, // n0x0eae c0x0000 (---------------)  + I yokawa
	0x00208fc3, // n0x0eaf c0x0000 (---------------)  + I ami
	0x002bf185, // n0x0eb0 c0x0000 (---------------)  + I asahi
	0x0034be85, // n0x0eb1 c0x0000 (---------------)  + I bando
	0x0022cac8, // n0x0eb2 c0x0000 (---------------)  + I chikusei
	0x00214cc5, // n0x0eb3 c0x0000 (---------------)  + I daigo
	0x0027a8c9, // n0x0eb4 c0x0000 (---------------)  + I fujishiro
	0x002a27c7, // n0x0eb5 c0x0000 (---------------)  + I hitachi
	0x002ac70b, // n0x0eb6 c0x0000 (---------------)  + I hitachinaka
	0x002a27cc, // n0x0eb7 c0x0000 (---------------)  + I hitachiomiya
	0x002a344a, // n0x0eb8 c0x0000 (---------------)  + I hitachiota
	0x002c1ac7, // n0x0eb9 c0x0000 (---------------)  + I ibaraki
	0x002013c3, // n0x0eba c0x0000 (---------------)  + I ina
	0x00370248, // n0x0ebb c0x0000 (---------------)  + I inashiki
	0x0036bc85, // n0x0ebc c0x0000 (---------------)  + I itako
	0x002be905, // n0x0ebd c0x0000 (---------------)  + I iwama
	0x00334e84, // n0x0ebe c0x0000 (---------------)  + I joso
	0x00291a46, // n0x0ebf c0x0000 (---------------)  + I kamisu
	0x00243646, // n0x0ec0 c0x0000 (---------------)  + I kasama
	0x002a8a87, // n0x0ec1 c0x0000 (---------------)  + I kashima
	0x0020b4cb, // n0x0ec2 c0x0000 (---------------)  + I kasumigaura
	0x00226304, // n0x0ec3 c0x0000 (---------------)  + I koga
	0x003781c4, // n0x0ec4 c0x0000 (---------------)  + I miho
	0x0026e904, // n0x0ec5 c0x0000 (---------------)  + I mito
	0x002c60c6, // n0x0ec6 c0x0000 (---------------)  + I moriya
	0x002164c4, // n0x0ec7 c0x0000 (---------------)  + I naka
	0x002bffc8, // n0x0ec8 c0x0000 (---------------)  + I namegata
	0x00334c85, // n0x0ec9 c0x0000 (---------------)  + I oarai
	0x00245a05, // n0x0eca c0x0000 (---------------)  + I ogawa
	0x0039a047, // n0x0ecb c0x0000 (---------------)  + I omitama
	0x00201c49, // n0x0ecc c0x0000 (---------------)  + I ryugasaki
	0x0034ca05, // n0x0ecd c0x0000 (---------------)  + I sakai
	0x00372a4a, // n0x0ece c0x0000 (---------------)  + I sakuragawa
	0x002c5e89, // n0x0ecf c0x0000 (---------------)  + I shimodate
	0x00285e4a, // n0x0ed0 c0x0000 (---------------)  + I shimotsuma
	0x00395d09, // n0x0ed1 c0x0000 (---------------)  + I shirosato
	0x00332b04, // n0x0ed2 c0x0000 (---------------)  + I sowa
	0x002af985, // n0x0ed3 c0x0000 (---------------)  + I suifu
	0x00348048, // n0x0ed4 c0x0000 (---------------)  + I takahagi
	0x002d930b, // n0x0ed5 c0x0000 (---------------)  + I tamatsukuri
	0x002fa0c5, // n0x0ed6 c0x0000 (---------------)  + I tokai
	0x0028e1c6, // n0x0ed7 c0x0000 (---------------)  + I tomobe
	0x00221d44, // n0x0ed8 c0x0000 (---------------)  + I tone
	0x0027ae06, // n0x0ed9 c0x0000 (---------------)  + I toride
	0x002b6989, // n0x0eda c0x0000 (---------------)  + I tsuchiura
	0x00223f07, // n0x0edb c0x0000 (---------------)  + I tsukuba
	0x0030c0c8, // n0x0edc c0x0000 (---------------)  + I uchihara
	0x00245746, // n0x0edd c0x0000 (---------------)  + I ushiku
	0x00300547, // n0x0ede c0x0000 (---------------)  + I yachiyo
	0x002808c8, // n0x0edf c0x0000 (---------------)  + I yamagata
	0x00386686, // n0x0ee0 c0x0000 (---------------)  + I yawara
	0x0024e8c4, // n0x0ee1 c0x0000 (---------------)  + I yuki
	0x0035e047, // n0x0ee2 c0x0000 (---------------)  + I anamizu
	0x00344045, // n0x0ee3 c0x0000 (---------------)  + I hakui
	0x0034a747, // n0x0ee4 c0x0000 (---------------)  + I hakusan
	0x00200fc4, // n0x0ee5 c0x0000 (---------------)  + I kaga
	0x0033d046, // n0x0ee6 c0x0000 (---------------)  + I kahoku
	0x0021a748, // n0x0ee7 c0x0000 (---------------)  + I kanazawa
	0x00295d48, // n0x0ee8 c0x0000 (---------------)  + I kawakita
	0x002aa707, // n0x0ee9 c0x0000 (---------------)  + I komatsu
	0x002546c8, // n0x0eea c0x0000 (---------------)  + I nakanoto
	0x002b4305, // n0x0eeb c0x0000 (---------------)  + I nanao
	0x0020a544, // n0x0eec c0x0000 (---------------)  + I nomi
	0x00265508, // n0x0eed c0x0000 (---------------)  + I nonoichi
	0x002547c4, // n0x0eee c0x0000 (---------------)  + I noto
	0x00216905, // n0x0eef c0x0000 (---------------)  + I shika
	0x002eeb44, // n0x0ef0 c0x0000 (---------------)  + I suzu
	0x002304c7, // n0x0ef1 c0x0000 (---------------)  + I tsubata
	0x00288347, // n0x0ef2 c0x0000 (---------------)  + I tsurugi
	0x00281948, // n0x0ef3 c0x0000 (---------------)  + I uchinada
	0x002a2f86, // n0x0ef4 c0x0000 (---------------)  + I wajima
	0x00214c45, // n0x0ef5 c0x0000 (---------------)  + I fudai
	0x0027a6c8, // n0x0ef6 c0x0000 (---------------)  + I fujisawa
	0x00356648, // n0x0ef7 c0x0000 (---------------)  + I hanamaki
	0x0029eac9, // n0x0ef8 c0x0000 (---------------)  + I hiraizumi
	0x0021d4c6, // n0x0ef9 c0x0000 (---------------)  + I hirono
	0x00236408, // n0x0efa c0x0000 (---------------)  + I ichinohe
	0x002820ca, // n0x0efb c0x0000 (---------------)  + I ichinoseki
	0x002f5fc8, // n0x0efc c0x0000 (---------------)  + I iwaizumi
	0x002d8485, // n0x0efd c0x0000 (---------------)  + I iwate
	0x00224706, // n0x0efe c0x0000 (---------------)  + I joboji
	0x0028d888, // n0x0eff c0x0000 (---------------)  + I kamaishi
	0x002fe60a, // n0x0f00 c0x0000 (---------------)  + I kanegasaki
	0x00271b47, // n0x0f01 c0x0000 (---------------)  + I karumai
	0x002864c5, // n0x0f02 c0x0000 (---------------)  + I kawai
	0x00294308, // n0x0f03 c0x0000 (---------------)  + I kitakami
	0x00371504, // n0x0f04 c0x0000 (---------------)  + I kuji
	0x0036b286, // n0x0f05 c0x0000 (---------------)  + I kunohe
	0x002bb088, // n0x0f06 c0x0000 (---------------)  + I kuzumaki
	0x0020a5c6, // n0x0f07 c0x0000 (---------------)  + I miyako
	0x002ea148, // n0x0f08 c0x0000 (---------------)  + I mizusawa
	0x0022aa47, // n0x0f09 c0x0000 (---------------)  + I morioka
	0x002072c6, // n0x0f0a c0x0000 (---------------)  + I ninohe
	0x0037f944, // n0x0f0b c0x0000 (---------------)  + I noda
	0x002db247, // n0x0f0c c0x0000 (---------------)  + I ofunato
	0x00342084, // n0x0f0d c0x0000 (---------------)  + I oshu
	0x002b6947, // n0x0f0e c0x0000 (---------------)  + I otsuchi
	0x0023848d, // n0x0f0f c0x0000 (---------------)  + I rikuzentakata
	0x00203845, // n0x0f10 c0x0000 (---------------)  + I shiwa
	0x002b108b, // n0x0f11 c0x0000 (---------------)  + I shizukuishi
	0x002a0a46, // n0x0f12 c0x0000 (---------------)  + I sumita
	0x00252c88, // n0x0f13 c0x0000 (---------------)  + I tanohata
	0x003895c4, // n0x0f14 c0x0000 (---------------)  + I tono
	0x00276f06, // n0x0f15 c0x0000 (---------------)  + I yahaba
	0x0027ce46, // n0x0f16 c0x0000 (---------------)  + I yamada
	0x002088c7, // n0x0f17 c0x0000 (---------------)  + I ayagawa
	0x002953cd, // n0x0f18 c0x0000 (---------------)  + I higashikagawa
	0x00322787, // n0x0f19 c0x0000 (---------------)  + I kanonji
	0x00339cc8, // n0x0f1a c0x0000 (---------------)  + I kotohira
	0x00366045, // n0x0f1b c0x0000 (---------------)  + I manno
	0x00297bc8, // n0x0f1c c0x0000 (---------------)  + I marugame
	0x002c0886, // n0x0f1d c0x0000 (---------------)  + I mitoyo
	0x002b4388, // n0x0f1e c0x0000 (---------------)  + I naoshima
	0x00213bc6, // n0x0f1f c0x0000 (---------------)  + I sanuki
	0x0032f6c7, // n0x0f20 c0x0000 (---------------)  + I tadotsu
	0x0021f709, // n0x0f21 c0x0000 (---------------)  + I takamatsu
	0x003895c7, // n0x0f22 c0x0000 (---------------)  + I tonosho
	0x00287508, // n0x0f23 c0x0000 (---------------)  + I uchinomi
	0x00273885, // n0x0f24 c0x0000 (---------------)  + I utazu
	0x0021c188, // n0x0f25 c0x0000 (---------------)  + I zentsuji
	0x00309245, // n0x0f26 c0x0000 (---------------)  + I akune
	0x00240f85, // n0x0f27 c0x0000 (---------------)  + I amami
	0x002e4bc5, // n0x0f28 c0x0000 (---------------)  + I hioki
	0x00223543, // n0x0f29 c0x0000 (---------------)  + I isa
	0x00282c44, // n0x0f2a c0x0000 (---------------)  + I isen
	0x002802c5, // n0x0f2b c0x0000 (---------------)  + I izumi
	0x00276189, // n0x0f2c c0x0000 (---------------)  + I kagoshima
	0x002b2786, // n0x0f2d c0x0000 (---------------)  + I kanoya
	0x002d2cc8, // n0x0f2e c0x0000 (---------------)  + I kawanabe
	0x002fe805, // n0x0f2f c0x0000 (---------------)  + I kinko
	0x0030b707, // n0x0f30 c0x0000 (---------------)  + I kouyama
	0x0032f9ca, // n0x0f31 c0x0000 (---------------)  + I makurazaki
	0x002bf509, // n0x0f32 c0x0000 (---------------)  + I matsumoto
	0x002b15ca, // n0x0f33 c0x0000 (---------------)  + I minamitane
	0x002cbe48, // n0x0f34 c0x0000 (---------------)  + I nakatane
	0x0021efcc, // n0x0f35 c0x0000 (---------------)  + I nishinoomote
	0x0028294d, // n0x0f36 c0x0000 (---------------)  + I satsumasendai
	0x00315283, // n0x0f37 c0x0000 (---------------)  + I soo
	0x002ea048, // n0x0f38 c0x0000 (---------------)  + I tarumizu
	0x00206685, // n0x0f39 c0x0000 (---------------)  + I yusui
	0x00354d46, // n0x0f3a c0x0000 (---------------)  + I aikawa
	0x00377dc6, // n0x0f3b c0x0000 (---------------)  + I atsugi
	0x0024d085, // n0x0f3c c0x0000 (---------------)  + I ayase
	0x0028cb89, // n0x0f3d c0x0000 (---------------)  + I chigasaki
	0x00325545, // n0x0f3e c0x0000 (---------------)  + I ebina
	0x0027a6c8, // n0x0f3f c0x0000 (---------------)  + I fujisawa
	0x0025ad86, // n0x0f40 c0x0000 (---------------)  + I hadano
	0x00339046, // n0x0f41 c0x0000 (---------------)  + I hakone
	0x002a01c9, // n0x0f42 c0x0000 (---------------)  + I hiratsuka
	0x00385e87, // n0x0f43 c0x0000 (---------------)  + I isehara
	0x002fdec6, // n0x0f44 c0x0000 (---------------)  + I kaisei
	0x0032f948, // n0x0f45 c0x0000 (---------------)  + I kamakura
	0x00206008, // n0x0f46 c0x0000 (---------------)  + I kiyokawa
	0x002d0bc7, // n0x0f47 c0x0000 (---------------)  + I matsuda
	0x0022840e, // n0x0f48 c0x0000 (---------------)  + I minamiashigara
	0x002c0ac5, // n0x0f49 c0x0000 (---------------)  + I miura
	0x00272185, // n0x0f4a c0x0000 (---------------)  + I nakai
	0x0020a4c8, // n0x0f4b c0x0000 (---------------)  + I ninomiya
	0x00384a47, // n0x0f4c c0x0000 (---------------)  + I odawara
	0x00207e42, // n0x0f4d c0x0000 (---------------)  + I oi
	0x002b8604, // n0x0f4e c0x0000 (---------------)  + I oiso
	0x003a68ca, // n0x0f4f c0x0000 (---------------)  + I sagamihara
	0x002b6d08, // n0x0f50 c0x0000 (---------------)  + I samukawa
	0x00283806, // n0x0f51 c0x0000 (---------------)  + I tsukui
	0x002982c8, // n0x0f52 c0x0000 (---------------)  + I yamakita
	0x0028f086, // n0x0f53 c0x0000 (---------------)  + I yamato
	0x00327d48, // n0x0f54 c0x0000 (---------------)  + I yokosuka
	0x002abfc8, // n0x0f55 c0x0000 (---------------)  + I yugawara
	0x00240f44, // n0x0f56 c0x0000 (---------------)  + I zama
	0x0032a845, // n0x0f57 c0x0000 (---------------)  + I zushi
	0x00686744, // n0x0f58 c0x0001 (---------------)  ! I city
	0x00686744, // n0x0f59 c0x0001 (---------------)  ! I city
	0x00686744, // n0x0f5a c0x0001 (---------------)  ! I city
	0x00201dc3, // n0x0f5b c0x0000 (---------------)  + I aki
	0x00239606, // n0x0f5c c0x0000 (---------------)  + I geisei
	0x0027ab86, // n0x0f5d c0x0000 (---------------)  + I hidaka
	0x0029cc4c, // n0x0f5e c0x0000 (---------------)  + I higashitsuno
	0x00207303, // n0x0f5f c0x0000 (---------------)  + I ino
	0x00281286, // n0x0f60 c0x0000 (---------------)  + I kagami
	0x00216544, // n0x0f61 c0x0000 (---------------)  + I kami
	0x002c1c08, // n0x0f62 c0x0000 (---------------)  + I kitagawa
	0x002cb145, // n0x0f63 c0x0000 (---------------)  + I kochi
	0x003a69c6, // n0x0f64 c0x0000 (---------------)  + I mihara
	0x002b3848, // n0x0f65 c0x0000 (---------------)  + I motoyama
	0x002ce6c6, // n0x0f66 c0x0000 (---------------)  + I muroto
	0x00205b06, // n0x0f67 c0x0000 (---------------)  + I nahari
	0x00365cc8, // n0x0f68 c0x0000 (---------------)  + I nakamura
	0x002a0cc7, // n0x0f69 c0x0000 (---------------)  + I nankoku
	0x00227f89, // n0x0f6a c0x0000 (---------------)  + I nishitosa
	0x0036be4a, // n0x0f6b c0x0000 (---------------)  + I niyodogawa
	0x00248784, // n0x0f6c c0x0000 (---------------)  + I ochi
	0x002060c5, // n0x0f6d c0x0000 (---------------)  + I okawa
	0x0025bb45, // n0x0f6e c0x0000 (---------------)  + I otoyo
	0x0021f306, // n0x0f6f c0x0000 (---------------)  + I otsuki
	0x00248a46, // n0x0f70 c0x0000 (---------------)  + I sakawa
	0x002a66c6, // n0x0f71 c0x0000 (---------------)  + I sukumo
	0x002e9346, // n0x0f72 c0x0000 (---------------)  + I susaki
	0x002280c4, // n0x0f73 c0x0000 (---------------)  + I tosa
	0x002280cb, // n0x0f74 c0x0000 (---------------)  + I tosashimizu
	0x00247dc4, // n0x0f75 c0x0000 (---------------)  + I toyo
	0x0020d485, // n0x0f76 c0x0000 (---------------)  + I tsuno
	0x002ab485, // n0x0f77 c0x0000 (---------------)  + I umaji
	0x00280646, // n0x0f78 c0x0000 (---------------)  + I yasuda
	0x00202348, // n0x0f79 c0x0000 (---------------)  + I yusuhara
	0x00282807, // n0x0f7a c0x0000 (---------------)  + I amakusa
	0x0030be84, // n0x0f7b c0x0000 (---------------)  + I arao
	0x00264783, // n0x0f7c c0x0000 (---------------)  + I aso
	0x00371005, // n0x0f7d c0x0000 (---------------)  + I choyo
	0x0024ad87, // n0x0f7e c0x0000 (---------------)  + I gyokuto
	0x002a41c9, // n0x0f7f c0x0000 (---------------)  + I hitoyoshi
	0x0028270b, // n0x0f80 c0x0000 (---------------)  + I kamiamakusa
	0x002a8a87, // n0x0f81 c0x0000 (---------------)  + I kashima
	0x0022c9c7, // n0x0f82 c0x0000 (---------------)  + I kikuchi
	0x002d8744, // n0x0f83 c0x0000 (---------------)  + I kosa
	0x002b3748, // n0x0f84 c0x0000 (---------------)  + I kumamoto
	0x002aa987, // n0x0f85 c0x0000 (---------------)  + I mashiki
	0x002a4406, // n0x0f86 c0x0000 (---------------)  + I mifune
	0x0024e648, // n0x0f87 c0x0000 (---------------)  + I minamata
	0x002a68cb, // n0x0f88 c0x0000 (---------------)  + I minamioguni
	0x003608c6, // n0x0f89 c0x0000 (---------------)  + I nagasu
	0x00212149, // n0x0f8a c0x0000 (---------------)  + I nishihara
	0x002a6a45, // n0x0f8b c0x0000 (---------------)  + I oguni
	0x00300a43, // n0x0f8c c0x0000 (---------------)  + I ozu
	0x002bf5c6, // n0x0f8d c0x0000 (---------------)  + I sumoto
	0x0022a948, // n0x0f8e c0x0000 (---------------)  + I takamori
	0x00212703, // n0x0f8f c0x0000 (---------------)  + I uki
	0x0024ae83, // n0x0f90 c0x0000 (---------------)  + I uto
	0x00223bc6, // n0x0f91 c0x0000 (---------------)  + I yamaga
	0x0028f086, // n0x0f92 c0x0000 (---------------)  + I yamato
	0x00382d0a, // n0x0f93 c0x0000 (---------------)  + I yatsushiro
	0x0027c5c5, // n0x0f94 c0x0000 (---------------)  + I ayabe
	0x0027cc8b, // n0x0f95 c0x0000 (---------------)  + I fukuchiyama
	0x0029d84b, // n0x0f96 c0x0000 (---------------)  + I higashiyama
	0x00229943, // n0x0f97 c0x0000 (---------------)  + I ide
	0x0021cc03, // n0x0f98 c0x0000 (---------------)  + I ine
	0x002adb84, // n0x0f99 c0x0000 (---------------)  + I joyo
	0x0022ad47, // n0x0f9a c0x0000 (---------------)  + I kameoka
	0x0022a9c4, // n0x0f9b c0x0000 (---------------)  + I kamo
	0x00201e04, // n0x0f9c c0x0000 (---------------)  + I kita
	0x00342404, // n0x0f9d c0x0000 (---------------)  + I kizu
	0x002f62c8, // n0x0f9e c0x0000 (---------------)  + I kumiyama
	0x002ce048, // n0x0f9f c0x0000 (---------------)  + I kyotamba
	0x0031f2c9, // n0x0fa0 c0x0000 (---------------)  + I kyotanabe
	0x00341c88, // n0x0fa1 c0x0000 (---------------)  + I kyotango
	0x002d1847, // n0x0fa2 c0x0000 (---------------)  + I maizuru
	0x00228406, // n0x0fa3 c0x0000 (---------------)  + I minami
	0x002d290f, // n0x0fa4 c0x0000 (---------------)  + I minamiyamashiro
	0x002c0c06, // n0x0fa5 c0x0000 (---------------)  + I miyazu
	0x002cb0c4, // n0x0fa6 c0x0000 (---------------)  + I muko
	0x002cde8a, // n0x0fa7 c0x0000 (---------------)  + I nagaokakyo
	0x0024ac87, // n0x0fa8 c0x0000 (---------------)  + I nakagyo
	0x00206c06, // n0x0fa9 c0x0000 (---------------)  + I nantan
	0x0028ea09, // n0x0faa c0x0000 (---------------)  + I oyamazaki
	0x0031f245, // n0x0fab c0x0000 (---------------)  + I sakyo
	0x0022cc05, // n0x0fac c0x0000 (---------------)  + I seika
	0x0031f386, // n0x0fad c0x0000 (---------------)  + I tanabe
	0x0021c2c3, // n0x0fae c0x0000 (---------------)  + I uji
	0x00371549, // n0x0faf c0x0000 (---------------)  + I ujitawara
	0x0021a646, // n0x0fb0 c0x0000 (---------------)  + I wazuka
	0x0022af89, // n0x0fb1 c0x0000 (---------------)  + I yamashina
	0x0038f146, // n0x0fb2 c0x0000 (---------------)  + I yawata
	0x002bf185, // n0x0fb3 c0x0000 (---------------)  + I asahi
	0x002236c5, // n0x0fb4 c0x0000 (---------------)  + I inabe
	0x00204683, // n0x0fb5 c0x0000 (---------------)  + I ise
	0x0022ae88, // n0x0fb6 c0x0000 (---------------)  + I kameyama
	0x0039f7c7, // n0x0fb7 c0x0000 (---------------)  + I kawagoe
	0x002f5c84, // n0x0fb8 c0x0000 (---------------)  + I kiho
	0x0021f408, // n0x0fb9 c0x0000 (---------------)  + I kisosaki
	0x002da084, // n0x0fba c0x0000 (---------------)  + I kiwa
	0x002b9886, // n0x0fbb c0x0000 (---------------)  + I komono
	0x00383786, // n0x0fbc c0x0000 (---------------)  + I kumano
	0x00243e46, // n0x0fbd c0x0000 (---------------)  + I kuwana
	0x002c6249, // n0x0fbe c0x0000 (---------------)  + I matsusaka
	0x002be885, // n0x0fbf c0x0000 (---------------)  + I meiwa
	0x002da306, // n0x0fc0 c0x0000 (---------------)  + I mihama
	0x0025b189, // n0x0fc1 c0x0000 (---------------)  + I minamiise
	0x002bfd46, // n0x0fc2 c0x0000 (---------------)  + I misugi
	0x002d2a06, // n0x0fc3 c0x0000 (---------------)  + I miyama
	0x0037fcc6, // n0x0fc4 c0x0000 (---------------)  + I nabari
	0x0020ef45, // n0x0fc5 c0x0000 (---------------)  + I shima
	0x002eeb46, // n0x0fc6 c0x0000 (---------------)  + I suzuka
	0x0032f6c4, // n0x0fc7 c0x0000 (---------------)  + I tado
	0x00289e05, // n0x0fc8 c0x0000 (---------------)  + I taiki
	0x002b8f84, // n0x0fc9 c0x0000 (---------------)  + I taki
	0x003037c6, // n0x0fca c0x0000 (---------------)  + I tamaki
	0x00395ec4, // n0x0fcb c0x0000 (---------------)  + I toba
	0x00208c83, // n0x0fcc c0x0000 (---------------)  + I tsu
	0x00286185, // n0x0fcd c0x0000 (---------------)  + I udono
	0x0023b908, // n0x0fce c0x0000 (---------------)  + I ureshino
	0x00351b87, // n0x0fcf c0x0000 (---------------)  + I watarai
	0x002b1f89, // n0x0fd0 c0x0000 (---------------)  + I yokkaichi
	0x002863c8, // n0x0fd1 c0x0000 (---------------)  + I furukawa
	0x00297811, // n0x0fd2 c0x0000 (---------------)  + I higashimatsushima
	0x0022c7ca, // n0x0fd3 c0x0000 (---------------)  + I ishinomaki
	0x0022f147, // n0x0fd4 c0x0000 (---------------)  + I iwanuma
	0x0039fd06, // n0x0fd5 c0x0000 (---------------)  + I kakuda
	0x00216544, // n0x0fd6 c0x0000 (---------------)  + I kami
	0x002b9088, // n0x0fd7 c0x0000 (---------------)  + I kawasaki
	0x002935c9, // n0x0fd8 c0x0000 (---------------)  + I kesennuma
	0x002a8bc8, // n0x0fd9 c0x0000 (---------------)  + I marumori
	0x002979ca, // n0x0fda c0x0000 (---------------)  + I matsushima
	0x002a740d, // n0x0fdb c0x0000 (---------------)  + I minamisanriku
	0x0022f486, // n0x0fdc c0x0000 (---------------)  + I misato
	0x00365dc6, // n0x0fdd c0x0000 (---------------)  + I murata
	0x002db306, // n0x0fde c0x0000 (---------------)  + I natori
	0x0037e6c7, // n0x0fdf c0x0000 (---------------)  + I ogawara
	0x0029ef85, // n0x0fe0 c0x0000 (---------------)  + I ohira
	0x003508c7, // n0x0fe1 c0x0000 (---------------)  + I onagawa
	0x0021f4c5, // n0x0fe2 c0x0000 (---------------)  + I osaki
	0x002a5784, // n0x0fe3 c0x0000 (---------------)  + I rifu
	0x002a9286, // n0x0fe4 c0x0000 (---------------)  + I semine
	0x00321bc7, // n0x0fe5 c0x0000 (---------------)  + I shibata
	0x0037124d, // n0x0fe6 c0x0000 (---------------)  + I shichikashuku
	0x0028d7c7, // n0x0fe7 c0x0000 (---------------)  + I shikama
	0x0026ebc8, // n0x0fe8 c0x0000 (---------------)  + I shiogama
	0x0027a9c9, // n0x0fe9 c0x0000 (---------------)  + I shiroishi
	0x00224606, // n0x0fea c0x0000 (---------------)  + I tagajo
	0x0023b045, // n0x0feb c0x0000 (---------------)  + I taiwa
	0x00216044, // n0x0fec c0x0000 (---------------)  + I tome
	0x00266086, // n0x0fed c0x0000 (---------------)  + I tomiya
	0x00350a06, // n0x0fee c0x0000 (---------------)  + I wakuya
	0x002b6e86, // n0x0fef c0x0000 (---------------)  + I watari
	0x0029ae08, // n0x0ff0 c0x0000 (---------------)  + I yamamoto
	0x00212d43, // n0x0ff1 c0x0000 (---------------)  + I zao
	0x002088c3, // n0x0ff2 c0x0000 (---------------)  + I aya
	0x00328105, // n0x0ff3 c0x0000 (---------------)  + I ebino
	0x00337286, // n0x0ff4 c0x0000 (---------------)  + I gokase
	0x002abf85, // n0x0ff5 c0x0000 (---------------)  + I hyuga
	0x00245948, // n0x0ff6 c0x0000 (---------------)  + I kadogawa
	0x0029c60a, // n0x0ff7 c0x0000 (---------------)  + I kawaminami
	0x002ddbc4, // n0x0ff8 c0x0000 (---------------)  + I kijo
	0x002c1c08, // n0x0ff9 c0x0000 (---------------)  + I kitagawa
	0x00295fc8, // n0x0ffa c0x0000 (---------------)  + I kitakata
	0x00280487, // n0x0ffb c0x0000 (---------------)  + I kitaura
	0x002fe8c9, // n0x0ffc c0x0000 (---------------)  + I kobayashi
	0x002b3448, // n0x0ffd c0x0000 (---------------)  + I kunitomi
	0x0029a047, // n0x0ffe c0x0000 (---------------)  + I kushima
	0x00294c06, // n0x0fff c0x0000 (---------------)  + I mimata
	0x0020a5ca, // n0x1000 c0x0000 (---------------)  + I miyakonojo
	0x00266108, // n0x1001 c0x0000 (---------------)  + I miyazaki
	0x002bd509, // n0x1002 c0x0000 (---------------)  + I morotsuka
	0x002869c8, // n0x1003 c0x0000 (---------------)  + I nichinan
	0x0021c809, // n0x1004 c0x0000 (---------------)  + I nishimera
	0x002bd987, // n0x1005 c0x0000 (---------------)  + I nobeoka
	0x00341b45, // n0x1006 c0x0000 (---------------)  + I saito
	0x002a1746, // n0x1007 c0x0000 (---------------)  + I shiiba
	0x0029b188, // n0x1008 c0x0000 (---------------)  + I shintomi
	0x00252e08, // n0x1009 c0x0000 (---------------)  + I takaharu
	0x0022b388, // n0x100a c0x0000 (---------------)  + I takanabe
	0x00216a48, // n0x100b c0x0000 (---------------)  + I takazaki
	0x0020d485, // n0x100c c0x0000 (---------------)  + I tsuno
	0x00201544, // n0x100d c0x0000 (---------------)  + I achi
	0x0039f4c8, // n0x100e c0x0000 (---------------)  + I agematsu
	0x00206d04, // n0x100f c0x0000 (---------------)  + I anan
	0x00395b04, // n0x1010 c0x0000 (---------------)  + I aoki
	0x002bf185, // n0x1011 c0x0000 (---------------)  + I asahi
	0x0028ffc7, // n0x1012 c0x0000 (---------------)  + I azumino
	0x00201a09, // n0x1013 c0x0000 (---------------)  + I chikuhoku
	0x002086c7, // n0x1014 c0x0000 (---------------)  + I chikuma
	0x0020db85, // n0x1015 c0x0000 (---------------)  + I chino
	0x00278286, // n0x1016 c0x0000 (---------------)  + I fujimi
	0x0033bb06, // n0x1017 c0x0000 (---------------)  + I hakuba
	0x00202444, // n0x1018 c0x0000 (---------------)  + I hara
	0x002a0506, // n0x1019 c0x0000 (---------------)  + I hiraya
	0x00214a84, // n0x101a c0x0000 (---------------)  + I iida
	0x0025cc86, // n0x101b c0x0000 (---------------)  + I iijima
	0x0039e786, // n0x101c c0x0000 (---------------)  + I iiyama
	0x00212546, // n0x101d c0x0000 (---------------)  + I iizuna
	0x00202585, // n0x101e c0x0000 (---------------)  + I ikeda
	0x00245807, // n0x101f c0x0000 (---------------)  + I ikusaka
	0x002013c3, // n0x1020 c0x0000 (---------------)  + I ina
	0x00249f89, // n0x1021 c0x0000 (---------------)  + I karuizawa
	0x002fdbc8, // n0x1022 c0x0000 (---------------)  + I kawakami
	0x0021f404, // n0x1023 c0x0000 (---------------)  + I kiso
	0x0032fbcd, // n0x1024 c0x0000 (---------------)  + I kisofukushima
	0x00295e48, // n0x1025 c0x0000 (---------------)  + I kitaaiki
	0x0028e748, // n0x1026 c0x0000 (---------------)  + I komagane
	0x002bd486, // n0x1027 c0x0000 (---------------)  + I komoro
	0x0021f809, // n0x1028 c0x0000 (---------------)  + I matsukawa
	0x002bf509, // n0x1029 c0x0000 (---------------)  + I matsumoto
	0x002b6685, // n0x102a c0x0000 (---------------)  + I miasa
	0x0029c70a, // n0x102b c0x0000 (---------------)  + I minamiaiki
	0x0027f80a, // n0x102c c0x0000 (---------------)  + I minamimaki
	0x0028850c, // n0x102d c0x0000 (---------------)  + I minamiminowa
	0x00288686, // n0x102e c0x0000 (---------------)  + I minowa
	0x00278b46, // n0x102f c0x0000 (---------------)  + I miyada
	0x002c0d86, // n0x1030 c0x0000 (---------------)  + I miyota
	0x00257009, // n0x1031 c0x0000 (---------------)  + I mochizuki
	0x00354f86, // n0x1032 c0x0000 (---------------)  + I nagano
	0x00291bc6, // n0x1033 c0x0000 (---------------)  + I nagawa
	0x00325606, // n0x1034 c0x0000 (---------------)  + I nagiso
	0x002ac8c8, // n0x1035 c0x0000 (---------------)  + I nakagawa
	0x002546c6, // n0x1036 c0x0000 (---------------)  + I nakano
	0x002c658b, // n0x1037 c0x0000 (---------------)  + I nozawaonsen
	0x00290145, // n0x1038 c0x0000 (---------------)  + I obuse
	0x00245a05, // n0x1039 c0x0000 (---------------)  + I ogawa
	0x00278dc5, // n0x103a c0x0000 (---------------)  + I okaya
	0x002014c6, // n0x103b c0x0000 (---------------)  + I omachi
	0x0020a583, // n0x103c c0x0000 (---------------)  + I omi
	0x00243dc6, // n0x103d c0x0000 (---------------)  + I ookuwa
	0x0028d747, // n0x103e c0x0000 (---------------)  + I ooshika
	0x002b8f45, // n0x103f c0x0000 (---------------)  + I otaki
	0x0025bc45, // n0x1040 c0x0000 (---------------)  + I otari
	0x002dd385, // n0x1041 c0x0000 (---------------)  + I sakae
	0x00318606, // n0x1042 c0x0000 (---------------)  + I sakaki
	0x002b6744, // n0x1043 c0x0000 (---------------)  + I saku
	0x00369d86, // n0x1044 c0x0000 (---------------)  + I sakuho
	0x0027b309, // n0x1045 c0x0000 (---------------)  + I shimosuwa
	0x0020134c, // n0x1046 c0x0000 (---------------)  + I shinanomachi
	0x002a54c8, // n0x1047 c0x0000 (---------------)  + I shiojiri
	0x0027b444, // n0x1048 c0x0000 (---------------)  + I suwa
	0x002ee7c6, // n0x1049 c0x0000 (---------------)  + I suzaka
	0x002a0b46, // n0x104a c0x0000 (---------------)  + I takagi
	0x0022a948, // n0x104b c0x0000 (---------------)  + I takamori
	0x002c0148, // n0x104c c0x0000 (---------------)  + I takayama
	0x00201249, // n0x104d c0x0000 (---------------)  + I tateshina
	0x0020d407, // n0x104e c0x0000 (---------------)  + I tatsuno
	0x002ae7c9, // n0x104f c0x0000 (---------------)  + I togakushi
	0x0026fa46, // n0x1050 c0x0000 (---------------)  + I togura
	0x0022f404, // n0x1051 c0x0000 (---------------)  + I tomi
	0x0020e184, // n0x1052 c0x0000 (---------------)  + I ueda
	0x0024a344, // n0x1053 c0x0000 (---------------)  + I wada
	0x002808c8, // n0x1054 c0x0000 (---------------)  + I yamagata
	0x0020184a, // n0x1055 c0x0000 (---------------)  + I yamanouchi
	0x0034c986, // n0x1056 c0x0000 (---------------)  + I yasaka
	0x00353407, // n0x1057 c0x0000 (---------------)  + I yasuoka
	0x00311d87, // n0x1058 c0x0000 (---------------)  + I chijiwa
	0x0036b785, // n0x1059 c0x0000 (---------------)  + I futsu
	0x0028de84, // n0x105a c0x0000 (---------------)  + I goto
	0x0028bb06, // n0x105b c0x0000 (---------------)  + I hasami
	0x00339dc6, // n0x105c c0x0000 (---------------)  + I hirado
	0x0023be03, // n0x105d c0x0000 (---------------)  + I iki
	0x002fda07, // n0x105e c0x0000 (---------------)  + I isahaya
	0x00330e48, // n0x105f c0x0000 (---------------)  + I kawatana
	0x002b67ca, // n0x1060 c0x0000 (---------------)  + I kuchinotsu
	0x002c9f88, // n0x1061 c0x0000 (---------------)  + I matsuura
	0x002dda48, // n0x1062 c0x0000 (---------------)  + I nagasaki
	0x00395f05, // n0x1063 c0x0000 (---------------)  + I obama
	0x0037ed85, // n0x1064 c0x0000 (---------------)  + I omura
	0x002ae705, // n0x1065 c0x0000 (---------------)  + I oseto
	0x0036bb46, // n0x1066 c0x0000 (---------------)  + I saikai
	0x003a3f06, // n0x1067 c0x0000 (---------------)  + I sasebo
	0x00218945, // n0x1068 c0x0000 (---------------)  + I seihi
	0x002ec949, // n0x1069 c0x0000 (---------------)  + I shimabara
	0x0028dc8c, // n0x106a c0x0000 (---------------)  + I shinkamigoto
	0x00240187, // n0x106b c0x0000 (---------------)  + I togitsu
	0x00297a48, // n0x106c c0x0000 (---------------)  + I tsushima
	0x0028c145, // n0x106d c0x0000 (---------------)  + I unzen
	0x00686744, // n0x106e c0x0001 (---------------)  ! I city
	0x00259644, // n0x106f c0x0000 (---------------)  + I ando
	0x002b13c4, // n0x1070 c0x0000 (---------------)  + I gose
	0x0020dcc6, // n0x1071 c0x0000 (---------------)  + I heguri
	0x0029e3ce, // n0x1072 c0x0000 (---------------)  + I higashiyoshino
	0x0022cc87, // n0x1073 c0x0000 (---------------)  + I ikaruga
	0x00296ec5, // n0x1074 c0x0000 (---------------)  + I ikoma
	0x0028ee8c, // n0x1075 c0x0000 (---------------)  + I kamikitayama
	0x002d9f47, // n0x1076 c0x0000 (---------------)  + I kanmaki
	0x00321b47, // n0x1077 c0x0000 (---------------)  + I kashiba
	0x00398f89, // n0x1078 c0x0000 (---------------)  + I kashihara
	0x00219349, // n0x1079 c0x0000 (---------------)  + I katsuragi
	0x002864c5, // n0x107a c0x0000 (---------------)  + I kawai
	0x002fdbc8, // n0x107b c0x0000 (---------------)  + I kawakami
	0x002bdc49, // n0x107c c0x0000 (---------------)  + I kawanishi
	0x002d6e45, // n0x107d c0x0000 (---------------)  + I koryo
	0x002b8e88, // n0x107e c0x0000 (---------------)  + I kurotaki
	0x002c6b46, // n0x107f c0x0000 (---------------)  + I mitsue
	0x002d2306, // n0x1080 c0x0000 (---------------)  + I miyake
	0x002c8a04, // n0x1081 c0x0000 (---------------)  + I nara
	0x003281c8, // n0x1082 c0x0000 (---------------)  + I nosegawa
	0x002247c3, // n0x1083 c0x0000 (---------------)  + I oji
	0x00209204, // n0x1084 c0x0000 (---------------)  + I ouda
	0x00371085, // n0x1085 c0x0000 (---------------)  + I oyodo
	0x00307fc7, // n0x1086 c0x0000 (---------------)  + I sakurai
	0x00202c85, // n0x1087 c0x0000 (---------------)  + I sango
	0x00281f89, // n0x1088 c0x0000 (---------------)  + I shimoichi
	0x0026784d, // n0x1089 c0x0000 (---------------)  + I shimokitayama
	0x0033bd46, // n0x108a c0x0000 (---------------)  + I shinjo
	0x002647c4, // n0x108b c0x0000 (---------------)  + I soni
	0x00294d08, // n0x108c c0x0000 (---------------)  + I takatori
	0x002784ca, // n0x108d c0x0000 (---------------)  + I tawaramoto
	0x002177c7, // n0x108e c0x0000 (---------------)  + I tenkawa
	0x003460c5, // n0x108f c0x0000 (---------------)  + I tenri
	0x00209243, // n0x1090 c0x0000 (---------------)  + I uda
	0x0029da0e, // n0x1091 c0x0000 (---------------)  + I yamatokoriyama
	0x0028f08c, // n0x1092 c0x0000 (---------------)  + I yamatotakada
	0x002fa407, // n0x1093 c0x0000 (---------------)  + I yamazoe
	0x0029e587, // n0x1094 c0x0000 (---------------)  + I yoshino
	0x00201003, // n0x1095 c0x0000 (---------------)  + I aga
	0x00354fc5, // n0x1096 c0x0000 (---------------)  + I agano
	0x002b13c5, // n0x1097 c0x0000 (---------------)  + I gosen
	0x00298688, // n0x1098 c0x0000 (---------------)  + I itoigawa
	0x00294149, // n0x1099 c0x0000 (---------------)  + I izumozaki
	0x00292e46, // n0x109a c0x0000 (---------------)  + I joetsu
	0x0022a9c4, // n0x109b c0x0000 (---------------)  + I kamo
	0x0022f086, // n0x109c c0x0000 (---------------)  + I kariwa
	0x00205dcb, // n0x109d c0x0000 (---------------)  + I kashiwazaki
	0x002c598c, // n0x109e c0x0000 (---------------)  + I minamiuonuma
	0x002ebdc7, // n0x109f c0x0000 (---------------)  + I mitsuke
	0x002cae05, // n0x10a0 c0x0000 (---------------)  + I muika
	0x00383248, // n0x10a1 c0x0000 (---------------)  + I murakami
	0x002d0985, // n0x10a2 c0x0000 (---------------)  + I myoko
	0x002cde87, // n0x10a3 c0x0000 (---------------)  + I nagaoka
	0x0023ff87, // n0x10a4 c0x0000 (---------------)  + I niigata
	0x0024f385, // n0x10a5 c0x0000 (---------------)  + I ojiya
	0x0020a583, // n0x10a6 c0x0000 (---------------)  + I omi
	0x00360584, // n0x10a7 c0x0000 (---------------)  + I sado
	0x00203f85, // n0x10a8 c0x0000 (---------------)  + I sanjo
	0x002e6c05, // n0x10a9 c0x0000 (---------------)  + I seiro
	0x002e6c06, // n0x10aa c0x0000 (---------------)  + I seirou
	0x0026c588, // n0x10ab c0x0000 (---------------)  + I sekikawa
	0x00321bc7, // n0x10ac c0x0000 (---------------)  + I shibata
	0x003780c6, // n0x10ad c0x0000 (---------------)  + I tagami
	0x00354c46, // n0x10ae c0x0000 (---------------)  + I tainai
	0x002e4b06, // n0x10af c0x0000 (---------------)  + I tochio
	0x00297189, // n0x10b0 c0x0000 (---------------)  + I tokamachi
	0x00208c87, // n0x10b1 c0x0000 (---------------)  + I tsubame
	0x00292cc6, // n0x10b2 c0x0000 (---------------)  + I tsunan
	0x002c5b06, // n0x10b3 c0x0000 (---------------)  + I uonuma
	0x0024f446, // n0x10b4 c0x0000 (---------------)  + I yahiko
	0x002a8945, // n0x10b5 c0x0000 (---------------)  + I yoita
	0x00217246, // n0x10b6 c0x0000 (---------------)  + I yuzawa
	0x0038de05, // n0x10b7 c0x0000 (---------------)  + I beppu
	0x002d1f48, // n0x10b8 c0x0000 (---------------)  + I bungoono
	0x00292a0b, // n0x10b9 c0x0000 (---------------)  + I bungotakada
	0x0028b906, // n0x10ba c0x0000 (---------------)  + I hasama
	0x00311dc4, // n0x10bb c0x0000 (---------------)  + I hiji
	0x002fe3c9, // n0x10bc c0x0000 (---------------)  + I himeshima
	0x002a27c4, // n0x10bd c0x0000 (---------------)  + I hita
	0x002c6ac8, // n0x10be c0x0000 (---------------)  + I kamitsue
	0x0028adc7, // n0x10bf c0x0000 (---------------)  + I kokonoe
	0x00283fc4, // n0x10c0 c0x0000 (---------------)  + I kuju
	0x002b2a08, // n0x10c1 c0x0000 (---------------)  + I kunisaki
	0x002ba1c4, // n0x10c2 c0x0000 (---------------)  + I kusu
	0x002a8984, // n0x10c3 c0x0000 (---------------)  + I oita
	0x00286f45, // n0x10c4 c0x0000 (---------------)  + I saiki
	0x00305a86, // n0x10c5 c0x0000 (---------------)  + I taketa
	0x002f6207, // n0x10c6 c0x0000 (---------------)  + I tsukumi
	0x0022b983, // n0x10c7 c0x0000 (---------------)  + I usa
	0x0029d4c5, // n0x10c8 c0x0000 (---------------)  + I usuki
	0x002bc144, // n0x10c9 c0x0000 (---------------)  + I yufu
	0x002721c6, // n0x10ca c0x0000 (---------------)  + I akaiwa
	0x002b6708, // n0x10cb c0x0000 (---------------)  + I asakuchi
	0x00330b85, // n0x10cc c0x0000 (---------------)  + I bizen
	0x0028fa49, // n0x10cd c0x0000 (---------------)  + I hayashima
	0x0020c145, // n0x10ce c0x0000 (---------------)  + I ibara
	0x002bbb48, // n0x10cf c0x0000 (---------------)  + I kagamino
	0x00320d87, // n0x10d0 c0x0000 (---------------)  + I kasaoka
	0x003809c8, // n0x10d1 c0x0000 (---------------)  + I kibichuo
	0x002b1dc7, // n0x10d2 c0x0000 (---------------)  + I kumenan
	0x0037e0c9, // n0x10d3 c0x0000 (---------------)  + I kurashiki
	0x0031d046, // n0x10d4 c0x0000 (---------------)  + I maniwa
	0x00347a06, // n0x10d5 c0x0000 (---------------)  + I misaki
	0x00269404, // n0x10d6 c0x0000 (---------------)  + I nagi
	0x00294b45, // n0x10d7 c0x0000 (---------------)  + I niimi
	0x002f48cc, // n0x10d8 c0x0000 (---------------)  + I nishiawakura
	0x00278dc7, // n0x10d9 c0x0000 (---------------)  + I okayama
	0x002791c7, // n0x10da c0x0000 (---------------)  + I satosho
	0x00311c48, // n0x10db c0x0000 (---------------)  + I setouchi
	0x0033bd46, // n0x10dc c0x0000 (---------------)  + I shinjo
	0x0029eec4, // n0x10dd c0x0000 (---------------)  + I shoo
	0x00323cc4, // n0x10de c0x0000 (---------------)  + I soja
	0x00280a49, // n0x10df c0x0000 (---------------)  + I takahashi
	0x002c0e86, // n0x10e0 c0x0000 (---------------)  + I tamano
	0x0021ec47, // n0x10e1 c0x0000 (---------------)  + I tsuyama
	0x00208504, // n0x10e2 c0x0000 (---------------)  + I wake
	0x002b2886, // n0x10e3 c0x0000 (---------------)  + I yakage
	0x00320985, // n0x10e4 c0x0000 (---------------)  + I aguni
	0x002a2ac7, // n0x10e5 c0x0000 (---------------)  + I ginowan
	0x002c6506, // n0x10e6 c0x0000 (---------------)  + I ginoza
	0x0025c649, // n0x10e7 c0x0000 (---------------)  + I gushikami
	0x0027f647, // n0x10e8 c0x0000 (---------------)  + I haebaru
	0x00268047, // n0x10e9 c0x0000 (---------------)  + I higashi
	0x002a0046, // n0x10ea c0x0000 (---------------)  + I hirara
	0x002452c5, // n0x10eb c0x0000 (---------------)  + I iheya
	0x0027e248, // n0x10ec c0x0000 (---------------)  + I ishigaki
	0x0021a4c8, // n0x10ed c0x0000 (---------------)  + I ishikawa
	0x00242b46, // n0x10ee c0x0000 (---------------)  + I itoman
	0x00330bc5, // n0x10ef c0x0000 (---------------)  + I izena
	0x00331c86, // n0x10f0 c0x0000 (---------------)  + I kadena
	0x002154c3, // n0x10f1 c0x0000 (---------------)  + I kin
	0x00298509, // n0x10f2 c0x0000 (---------------)  + I kitadaito
	0x002a644e, // n0x10f3 c0x0000 (---------------)  + I kitanakagusuku
	0x002b1ac8, // n0x10f4 c0x0000 (---------------)  + I kumejima
	0x002da188, // n0x10f5 c0x0000 (---------------)  + I kunigami
	0x0024294b, // n0x10f6 c0x0000 (---------------)  + I minamidaito
	0x0028fc86, // n0x10f7 c0x0000 (---------------)  + I motobu
	0x002486c4, // n0x10f8 c0x0000 (---------------)  + I nago
	0x00205b04, // n0x10f9 c0x0000 (---------------)  + I naha
	0x002a654a, // n0x10fa c0x0000 (---------------)  + I nakagusuku
	0x00217e07, // n0x10fb c0x0000 (---------------)  + I nakijin
	0x00292d85, // n0x10fc c0x0000 (---------------)  + I nanjo
	0x00212149, // n0x10fd c0x0000 (---------------)  + I nishihara
	0x002b8285, // n0x10fe c0x0000 (---------------)  + I ogimi
	0x00395b47, // n0x10ff c0x0000 (---------------)  + I okinawa
	0x00301304, // n0x1100 c0x0000 (---------------)  + I onna
	0x00383e87, // n0x1101 c0x0000 (---------------)  + I shimoji
	0x0022f308, // n0x1102 c0x0000 (---------------)  + I taketomi
	0x002b0046, // n0x1103 c0x0000 (---------------)  + I tarama
	0x00342249, // n0x1104 c0x0000 (---------------)  + I tokashiki
	0x002b354a, // n0x1105 c0x0000 (---------------)  + I tomigusuku
	0x00217d86, // n0x1106 c0x0000 (---------------)  + I tonaki
	0x00295986, // n0x1107 c0x0000 (---------------)  + I urasoe
	0x002ab405, // n0x1108 c0x0000 (---------------)  + I uruma
	0x00373d05, // n0x1109 c0x0000 (---------------)  + I yaese
	0x00229a47, // n0x110a c0x0000 (---------------)  + I yomitan
	0x00249888, // n0x110b c0x0000 (---------------)  + I yonabaru
	0x003208c8, // n0x110c c0x0000 (---------------)  + I yonaguni
	0x00240f46, // n0x110d c0x0000 (---------------)  + I zamami
	0x00223745, // n0x110e c0x0000 (---------------)  + I abeno
	0x002487ce, // n0x110f c0x0000 (---------------)  + I chihayaakasaka
	0x0030ba84, // n0x1110 c0x0000 (---------------)  + I chuo
	0x00242ac5, // n0x1111 c0x0000 (---------------)  + I daito
	0x00277c09, // n0x1112 c0x0000 (---------------)  + I fujiidera
	0x0026b5c8, // n0x1113 c0x0000 (---------------)  + I habikino
	0x003a1c46, // n0x1114 c0x0000 (---------------)  + I hannan
	0x0029aa8c, // n0x1115 c0x0000 (---------------)  + I higashiosaka
	0x0029c210, // n0x1116 c0x0000 (---------------)  + I higashisumiyoshi
	0x0029e00f, // n0x1117 c0x0000 (---------------)  + I higashiyodogawa
	0x0029efc8, // n0x1118 c0x0000 (---------------)  + I hirakata
	0x002c1ac7, // n0x1119 c0x0000 (---------------)  + I ibaraki
	0x00202585, // n0x111a c0x0000 (---------------)  + I ikeda
	0x002802c5, // n0x111b c0x0000 (---------------)  + I izumi
	0x002f6089, // n0x111c c0x0000 (---------------)  + I izumiotsu
	0x00294509, // n0x111d c0x0000 (---------------)  + I izumisano
	0x0021e5c6, // n0x111e c0x0000 (---------------)  + I kadoma
	0x002fa147, // n0x111f c0x0000 (---------------)  + I kaizuka
	0x0038ad85, // n0x1120 c0x0000 (---------------)  + I kanan
	0x002037c9, // n0x1121 c0x0000 (---------------)  + I kashiwara
	0x0032c486, // n0x1122 c0x0000 (---------------)  + I katano
	0x00354dcd, // n0x1123 c0x0000 (---------------)  + I kawachinagano
	0x00287009, // n0x1124 c0x0000 (---------------)  + I kishiwada
	0x00201e04, // n0x1125 c0x0000 (---------------)  + I kita
	0x002b1848, // n0x1126 c0x0000 (---------------)  + I kumatori
	0x0039f589, // n0x1127 c0x0000 (---------------)  + I matsubara
	0x0034cb46, // n0x1128 c0x0000 (---------------)  + I minato
	0x00278385, // n0x1129 c0x0000 (---------------)  + I minoh
	0x00347a06, // n0x112a c0x0000 (---------------)  + I misaki
	0x0030bf89, // n0x112b c0x0000 (---------------)  + I moriguchi
	0x00320008, // n0x112c c0x0000 (---------------)  + I neyagawa
	0x00211805, // n0x112d c0x0000 (---------------)  + I nishi
	0x0026c504, // n0x112e c0x0000 (---------------)  + I nose
	0x0029ac4b, // n0x112f c0x0000 (---------------)  + I osakasayama
	0x0034ca05, // n0x1130 c0x0000 (---------------)  + I sakai
	0x0029ad86, // n0x1131 c0x0000 (---------------)  + I sayama
	0x00282c86, // n0x1132 c0x0000 (---------------)  + I sennan
	0x0024c046, // n0x1133 c0x0000 (---------------)  + I settsu
	0x0038428b, // n0x1134 c0x0000 (---------------)  + I shijonawate
	0x0028fb49, // n0x1135 c0x0000 (---------------)  + I shimamoto
	0x00218c85, // n0x1136 c0x0000 (---------------)  + I suita
	0x00380787, // n0x1137 c0x0000 (---------------)  + I tadaoka
	0x0022c746, // n0x1138 c0x0000 (---------------)  + I taishi
	0x00238746, // n0x1139 c0x0000 (---------------)  + I tajiri
	0x00281e48, // n0x113a c0x0000 (---------------)  + I takaishi
	0x00305b89, // n0x113b c0x0000 (---------------)  + I takatsuki
	0x0026e98c, // n0x113c c0x0000 (---------------)  + I tondabayashi
	0x0024ab88, // n0x113d c0x0000 (---------------)  + I toyonaka
	0x0037b006, // n0x113e c0x0000 (---------------)  + I toyono
	0x00341743, // n0x113f c0x0000 (---------------)  + I yao
	0x00249246, // n0x1140 c0x0000 (---------------)  + I ariake
	0x0027ff85, // n0x1141 c0x0000 (---------------)  + I arita
	0x0027cfc8, // n0x1142 c0x0000 (---------------)  + I fukudomi
	0x00223146, // n0x1143 c0x0000 (---------------)  + I genkai
	0x002a2d08, // n0x1144 c0x0000 (---------------)  + I hamatama
	0x0024ba45, // n0x1145 c0x0000 (---------------)  + I hizen
	0x0027bc05, // n0x1146 c0x0000 (---------------)  + I imari
	0x00321008, // n0x1147 c0x0000 (---------------)  + I kamimine
	0x002eec47, // n0x1148 c0x0000 (---------------)  + I kanzaki
	0x00377d07, // n0x1149 c0x0000 (---------------)  + I karatsu
	0x002a8a87, // n0x114a c0x0000 (---------------)  + I kashima
	0x0021f588, // n0x114b c0x0000 (---------------)  + I kitagata
	0x0028ebc8, // n0x114c c0x0000 (---------------)  + I kitahata
	0x0024edc6, // n0x114d c0x0000 (---------------)  + I kiyama
	0x00303607, // n0x114e c0x0000 (---------------)  + I kouhoku
	0x0036ad87, // n0x114f c0x0000 (---------------)  + I kyuragi
	0x0027fe4a, // n0x1150 c0x0000 (---------------)  + I nishiarita
	0x00213483, // n0x1151 c0x0000 (---------------)  + I ogi
	0x002014c6, // n0x1152 c0x0000 (---------------)  + I omachi
	0x00201985, // n0x1153 c0x0000 (---------------)  + I ouchi
	0x00238904, // n0x1154 c0x0000 (---------------)  + I saga
	0x0027a9c9, // n0x1155 c0x0000 (---------------)  + I shiroishi
	0x0037e044, // n0x1156 c0x0000 (---------------)  + I taku
	0x002a1204, // n0x1157 c0x0000 (---------------)  + I tara
	0x002a09c4, // n0x1158 c0x0000 (---------------)  + I tosu
	0x0029e58b, // n0x1159 c0x0000 (---------------)  + I yoshinogari
	0x0039f707, // n0x115a c0x0000 (---------------)  + I arakawa
	0x00248a05, // n0x115b c0x0000 (---------------)  + I asaka
	0x00292888, // n0x115c c0x0000 (---------------)  + I chichibu
	0x00278286, // n0x115d c0x0000 (---------------)  + I fujimi
	0x00278288, // n0x115e c0x0000 (---------------)  + I fujimino
	0x0027c506, // n0x115f c0x0000 (---------------)  + I fukaya
	0x00289385, // n0x1160 c0x0000 (---------------)  + I hanno
	0x0028a805, // n0x1161 c0x0000 (---------------)  + I hanyu
	0x0028c486, // n0x1162 c0x0000 (---------------)  + I hasuda
	0x0028d4c8, // n0x1163 c0x0000 (---------------)  + I hatogaya
	0x0028e948, // n0x1164 c0x0000 (---------------)  + I hatoyama
	0x0027ab86, // n0x1165 c0x0000 (---------------)  + I hidaka
	0x002926cf, // n0x1166 c0x0000 (---------------)  + I higashichichibu
	0x00297fd0, // n0x1167 c0x0000 (---------------)  + I higashimatsuyama
	0x0038e545, // n0x1168 c0x0000 (---------------)  + I honjo
	0x002013c3, // n0x1169 c0x0000 (---------------)  + I ina
	0x00251c85, // n0x116a c0x0000 (---------------)  + I iruma
	0x002ff488, // n0x116b c0x0000 (---------------)  + I iwatsuki
	0x00294409, // n0x116c c0x0000 (---------------)  + I kamiizumi
	0x002e8008, // n0x116d c0x0000 (---------------)  + I kamikawa
	0x0034cdc8, // n0x116e c0x0000 (---------------)  + I kamisato
	0x00207888, // n0x116f c0x0000 (---------------)  + I kasukabe
	0x0039f7c7, // n0x1170 c0x0000 (---------------)  + I kawagoe
	0x00277f49, // n0x1171 c0x0000 (---------------)  + I kawaguchi
	0x002a2f08, // n0x1172 c0x0000 (---------------)  + I kawajima
	0x002b7444, // n0x1173 c0x0000 (---------------)  + I kazo
	0x002a0848, // n0x1174 c0x0000 (---------------)  + I kitamoto
	0x00289b89, // n0x1175 c0x0000 (---------------)  + I koshigaya
	0x0030a447, // n0x1176 c0x0000 (---------------)  + I kounosu
	0x002a63c4, // n0x1177 c0x0000 (---------------)  + I kuki
	0x00208788, // n0x1178 c0x0000 (---------------)  + I kumagaya
	0x002455ca, // n0x1179 c0x0000 (---------------)  + I matsubushi
	0x002d8c06, // n0x117a c0x0000 (---------------)  + I minano
	0x0022f486, // n0x117b c0x0000 (---------------)  + I misato
	0x0021d389, // n0x117c c0x0000 (---------------)  + I miyashiro
	0x0029c447, // n0x117d c0x0000 (---------------)  + I miyoshi
	0x002c6ec8, // n0x117e c0x0000 (---------------)  + I moroyama
	0x0038e088, // n0x117f c0x0000 (---------------)  + I nagatoro
	0x00208388, // n0x1180 c0x0000 (---------------)  + I namegawa
	0x00352f45, // n0x1181 c0x0000 (---------------)  + I niiza
	0x00374cc5, // n0x1182 c0x0000 (---------------)  + I ogano
	0x00245a05, // n0x1183 c0x0000 (---------------)  + I ogawa
	0x002b1385, // n0x1184 c0x0000 (---------------)  + I ogose
	0x0035ce07, // n0x1185 c0x0000 (---------------)  + I okegawa
	0x0020a585, // n0x1186 c0x0000 (---------------)  + I omiya
	0x002b8f45, // n0x1187 c0x0000 (---------------)  + I otaki
	0x0033f406, // n0x1188 c0x0000 (---------------)  + I ranzan
	0x002e7f47, // n0x1189 c0x0000 (---------------)  + I ryokami
	0x002d9247, // n0x118a c0x0000 (---------------)  + I saitama
	0x002458c6, // n0x118b c0x0000 (---------------)  + I sakado
	0x002cc385, // n0x118c c0x0000 (---------------)  + I satte
	0x0029ad86, // n0x118d c0x0000 (---------------)  + I sayama
	0x002aaa05, // n0x118e c0x0000 (---------------)  + I shiki
	0x00306048, // n0x118f c0x0000 (---------------)  + I shiraoka
	0x002e22c4, // n0x1190 c0x0000 (---------------)  + I soka
	0x002bfdc6, // n0x1191 c0x0000 (---------------)  + I sugito
	0x00265904, // n0x1192 c0x0000 (---------------)  + I toda
	0x00222908, // n0x1193 c0x0000 (---------------)  + I tokigawa
	0x0038584a, // n0x1194 c0x0000 (---------------)  + I tokorozawa
	0x0027b9cc, // n0x1195 c0x0000 (---------------)  + I tsurugashima
	0x0020b6c5, // n0x1196 c0x0000 (---------------)  + I urawa
	0x00203906, // n0x1197 c0x0000 (---------------)  + I warabi
	0x0026eb46, // n0x1198 c0x0000 (---------------)  + I yashio
	0x002296c6, // n0x1199 c0x0000 (---------------)  + I yokoze
	0x002ff684, // n0x119a c0x0000 (---------------)  + I yono
	0x00320c45, // n0x119b c0x0000 (---------------)  + I yorii
	0x0027c347, // n0x119c c0x0000 (---------------)  + I yoshida
	0x0029c4c9, // n0x119d c0x0000 (---------------)  + I yoshikawa
	0x002a42c7, // n0x119e c0x0000 (---------------)  + I yoshimi
	0x00686744, // n0x119f c0x0001 (---------------)  ! I city
	0x00686744, // n0x11a0 c0x0001 (---------------)  ! I city
	0x0030bd05, // n0x11a1 c0x0000 (---------------)  + I aisho
	0x00228e04, // n0x11a2 c0x0000 (---------------)  + I gamo
	0x0029a44a, // n0x11a3 c0x0000 (---------------)  + I higashiomi
	0x00278106, // n0x11a4 c0x0000 (---------------)  + I hikone
	0x0034cd44, // n0x11a5 c0x0000 (---------------)  + I koka
	0x00206b85, // n0x11a6 c0x0000 (---------------)  + I konan
	0x002fb505, // n0x11a7 c0x0000 (---------------)  + I kosei
	0x00301bc4, // n0x11a8 c0x0000 (---------------)  + I koto
	0x002828c7, // n0x11a9 c0x0000 (---------------)  + I kusatsu
	0x0020c0c7, // n0x11aa c0x0000 (---------------)  + I maibara
	0x002c60c8, // n0x11ab c0x0000 (---------------)  + I moriyama
	0x0025e648, // n0x11ac c0x0000 (---------------)  + I nagahama
	0x00211809, // n0x11ad c0x0000 (---------------)  + I nishiazai
	0x0025ae88, // n0x11ae c0x0000 (---------------)  + I notogawa
	0x0029a60b, // n0x11af c0x0000 (---------------)  + I omihachiman
	0x0021f304, // n0x11b0 c0x0000 (---------------)  + I otsu
	0x00337145, // n0x11b1 c0x0000 (---------------)  + I ritto
	0x0027f545, // n0x11b2 c0x0000 (---------------)  + I ryuoh
	0x002a8a09, // n0x11b3 c0x0000 (---------------)  + I takashima
	0x00305b89, // n0x11b4 c0x0000 (---------------)  + I takatsuki
	0x002fe2c8, // n0x11b5 c0x0000 (---------------)  + I torahime
	0x0025b488, // n0x11b6 c0x0000 (---------------)  + I toyosato
	0x00280644, // n0x11b7 c0x0000 (---------------)  + I yasu
	0x002a0b85, // n0x11b8 c0x0000 (---------------)  + I akagi
	0x00201883, // n0x11b9 c0x0000 (---------------)  + I ama
	0x0021f2c5, // n0x11ba c0x0000 (---------------)  + I gotsu
	0x002da386, // n0x11bb c0x0000 (---------------)  + I hamada
	0x00293f8c, // n0x11bc c0x0000 (---------------)  + I higashiizumo
	0x0021a546, // n0x11bd c0x0000 (---------------)  + I hikawa
	0x002d7a86, // n0x11be c0x0000 (---------------)  + I hikimi
	0x00294145, // n0x11bf c0x0000 (---------------)  + I izumo
	0x00318688, // n0x11c0 c0x0000 (---------------)  + I kakinoki
	0x002b1c46, // n0x11c1 c0x0000 (---------------)  + I masuda
	0x0039fe86, // n0x11c2 c0x0000 (---------------)  + I matsue
	0x0022f486, // n0x11c3 c0x0000 (---------------)  + I misato
	0x0022058c, // n0x11c4 c0x0000 (---------------)  + I nishinoshima
	0x002b7044, // n0x11c5 c0x0000 (---------------)  + I ohda
	0x002e4c4a, // n0x11c6 c0x0000 (---------------)  + I okinoshima
	0x003a1e08, // n0x11c7 c0x0000 (---------------)  + I okuizumo
	0x00293dc7, // n0x11c8 c0x0000 (---------------)  + I shimane
	0x0024e7c6, // n0x11c9 c0x0000 (---------------)  + I tamayu
	0x00292f07, // n0x11ca c0x0000 (---------------)  + I tsuwano
	0x002e0845, // n0x11cb c0x0000 (---------------)  + I unnan
	0x00325346, // n0x11cc c0x0000 (---------------)  + I yakumo
	0x0034fa06, // n0x11cd c0x0000 (---------------)  + I yasugi
	0x00377bc7, // n0x11ce c0x0000 (---------------)  + I yatsuka
	0x002b3244, // n0x11cf c0x0000 (---------------)  + I arai
	0x002305c5, // n0x11d0 c0x0000 (---------------)  + I atami
	0x00277c04, // n0x11d1 c0x0000 (---------------)  + I fuji
	0x002a5807, // n0x11d2 c0x0000 (---------------)  + I fujieda
	0x00277e48, // n0x11d3 c0x0000 (---------------)  + I fujikawa
	0x002789ca, // n0x11d4 c0x0000 (---------------)  + I fujinomiya
	0x0027ed47, // n0x11d5 c0x0000 (---------------)  + I fukuroi
	0x00242cc7, // n0x11d6 c0x0000 (---------------)  + I gotemba
	0x002c1a47, // n0x11d7 c0x0000 (---------------)  + I haibara
	0x002d0ac9, // n0x11d8 c0x0000 (---------------)  + I hamamatsu
	0x00293f8a, // n0x11d9 c0x0000 (---------------)  + I higashiizu
	0x00228083, // n0x11da c0x0000 (---------------)  + I ito
	0x00351b45, // n0x11db c0x0000 (---------------)  + I iwata
	0x00212583, // n0x11dc c0x0000 (---------------)  + I izu
	0x00342449, // n0x11dd c0x0000 (---------------)  + I izunokuni
	0x002b9588, // n0x11de c0x0000 (---------------)  + I kakegawa
	0x003061c7, // n0x11df c0x0000 (---------------)  + I kannami
	0x002e8109, // n0x11e0 c0x0000 (---------------)  + I kawanehon
	0x0021a5c6, // n0x11e1 c0x0000 (---------------)  + I kawazu
	0x003a3c08, // n0x11e2 c0x0000 (---------------)  + I kikugawa
	0x002d8745, // n0x11e3 c0x0000 (---------------)  + I kosai
	0x0035674a, // n0x11e4 c0x0000 (---------------)  + I makinohara
	0x002cf149, // n0x11e5 c0x0000 (---------------)  + I matsuzaki
	0x0026e649, // n0x11e6 c0x0000 (---------------)  + I minamiizu
	0x002bf3c7, // n0x11e7 c0x0000 (---------------)  + I mishima
	0x002a8cc9, // n0x11e8 c0x0000 (---------------)  + I morimachi
	0x00212448, // n0x11e9 c0x0000 (---------------)  + I nishiizu
	0x002ee946, // n0x11ea c0x0000 (---------------)  + I numazu
	0x0037e948, // n0x11eb c0x0000 (---------------)  + I omaezaki
	0x00212e87, // n0x11ec c0x0000 (---------------)  + I shimada
	0x002281c7, // n0x11ed c0x0000 (---------------)  + I shimizu
	0x002c5e87, // n0x11ee c0x0000 (---------------)  + I shimoda
	0x002b2608, // n0x11ef c0x0000 (---------------)  + I shizuoka
	0x002ee646, // n0x11f0 c0x0000 (---------------)  + I susono
	0x00245385, // n0x11f1 c0x0000 (---------------)  + I yaizu
	0x0027c347, // n0x11f2 c0x0000 (---------------)  + I yoshida
	0x00295488, // n0x11f3 c0x0000 (---------------)  + I ashikaga
	0x00344d84, // n0x11f4 c0x0000 (---------------)  + I bato
	0x0034ac04, // n0x11f5 c0x0000 (---------------)  + I haga
	0x002fddc7, // n0x11f6 c0x0000 (---------------)  + I ichikai
	0x002ac347, // n0x11f7 c0x0000 (---------------)  + I iwafune
	0x002bdaca, // n0x11f8 c0x0000 (---------------)  + I kaminokawa
	0x002ee8c6, // n0x11f9 c0x0000 (---------------)  + I kanuma
	0x002fa28a, // n0x11fa c0x0000 (---------------)  + I karasuyama
	0x002b8547, // n0x11fb c0x0000 (---------------)  + I kuroiso
	0x0030b847, // n0x11fc c0x0000 (---------------)  + I mashiko
	0x00241044, // n0x11fd c0x0000 (---------------)  + I mibu
	0x00263904, // n0x11fe c0x0000 (---------------)  + I moka
	0x00226bc6, // n0x11ff c0x0000 (---------------)  + I motegi
	0x002ec144, // n0x1200 c0x0000 (---------------)  + I nasu
	0x002ec14c, // n0x1201 c0x0000 (---------------)  + I nasushiobara
	0x00203185, // n0x1202 c0x0000 (---------------)  + I nikko
	0x00216889, // n0x1203 c0x0000 (---------------)  + I nishikata
	0x00279884, // n0x1204 c0x0000 (---------------)  + I nogi
	0x0029ef85, // n0x1205 c0x0000 (---------------)  + I ohira
	0x00278448, // n0x1206 c0x0000 (---------------)  + I ohtawara
	0x00250045, // n0x1207 c0x0000 (---------------)  + I oyama
	0x00307fc6, // n0x1208 c0x0000 (---------------)  + I sakura
	0x0020f744, // n0x1209 c0x0000 (---------------)  + I sano
	0x0027e58a, // n0x120a c0x0000 (---------------)  + I shimotsuke
	0x002a7c86, // n0x120b c0x0000 (---------------)  + I shioya
	0x002579ca, // n0x120c c0x0000 (---------------)  + I takanezawa
	0x00344e07, // n0x120d c0x0000 (---------------)  + I tochigi
	0x00297645, // n0x120e c0x0000 (---------------)  + I tsuga
	0x0021c2c5, // n0x120f c0x0000 (---------------)  + I ujiie
	0x0036b7ca, // n0x1210 c0x0000 (---------------)  + I utsunomiya
	0x002a0605, // n0x1211 c0x0000 (---------------)  + I yaita
	0x0029eb86, // n0x1212 c0x0000 (---------------)  + I aizumi
	0x00206d04, // n0x1213 c0x0000 (---------------)  + I anan
	0x002add06, // n0x1214 c0x0000 (---------------)  + I ichiba
	0x00229b05, // n0x1215 c0x0000 (---------------)  + I itano
	0x00223206, // n0x1216 c0x0000 (---------------)  + I kainan
	0x002aa70c, // n0x1217 c0x0000 (---------------)  + I komatsushima
	0x002c704a, // n0x1218 c0x0000 (---------------)  + I matsushige
	0x0027f904, // n0x1219 c0x0000 (---------------)  + I mima
	0x00228406, // n0x121a c0x0000 (---------------)  + I minami
	0x0029c447, // n0x121b c0x0000 (---------------)  + I miyoshi
	0x002ca384, // n0x121c c0x0000 (---------------)  + I mugi
	0x002ac8c8, // n0x121d c0x0000 (---------------)  + I nakagawa
	0x00385746, // n0x121e c0x0000 (---------------)  + I naruto
	0x00248649, // n0x121f c0x0000 (---------------)  + I sanagochi
	0x002ad349, // n0x1220 c0x0000 (---------------)  + I shishikui
	0x00299fc9, // n0x1221 c0x0000 (---------------)  + I tokushima
	0x0036aa46, // n0x1222 c0x0000 (---------------)  + I wajiki
	0x00212f86, // n0x1223 c0x0000 (---------------)  + I adachi
	0x0037ea87, // n0x1224 c0x0000 (---------------)  + I akiruno
	0x002ec888, // n0x1225 c0x0000 (---------------)  + I akishima
	0x00212d89, // n0x1226 c0x0000 (---------------)  + I aogashima
	0x0039f707, // n0x1227 c0x0000 (---------------)  + I arakawa
	0x002b4186, // n0x1228 c0x0000 (---------------)  + I bunkyo
	0x003005c7, // n0x1229 c0x0000 (---------------)  + I chiyoda
	0x002db1c5, // n0x122a c0x0000 (---------------)  + I chofu
	0x0030ba84, // n0x122b c0x0000 (---------------)  + I chuo
	0x0037e647, // n0x122c c0x0000 (---------------)  + I edogawa
	0x002bc1c5, // n0x122d c0x0000 (---------------)  + I fuchu
	0x00286e85, // n0x122e c0x0000 (---------------)  + I fussa
	0x002fc5c7, // n0x122f c0x0000 (---------------)  + I hachijo
	0x0024f248, // n0x1230 c0x0000 (---------------)  + I hachioji
	0x003831c6, // n0x1231 c0x0000 (---------------)  + I hamura
	0x0029680d, // n0x1232 c0x0000 (---------------)  + I higashikurume
	0x0029888f, // n0x1233 c0x0000 (---------------)  + I higashimurayama
	0x0029d84d, // n0x1234 c0x0000 (---------------)  + I higashiyamato
	0x0020dbc4, // n0x1235 c0x0000 (---------------)  + I hino
	0x0023ba06, // n0x1236 c0x0000 (---------------)  + I hinode
	0x002cfa08, // n0x1237 c0x0000 (---------------)  + I hinohara
	0x003255c5, // n0x1238 c0x0000 (---------------)  + I inagi
	0x00280008, // n0x1239 c0x0000 (---------------)  + I itabashi
	0x0021ae8a, // n0x123a c0x0000 (---------------)  + I katsushika
	0x00201e04, // n0x123b c0x0000 (---------------)  + I kita
	0x002aaac6, // n0x123c c0x0000 (---------------)  + I kiyose
	0x0039c647, // n0x123d c0x0000 (---------------)  + I kodaira
	0x00226307, // n0x123e c0x0000 (---------------)  + I koganei
	0x002a0d89, // n0x123f c0x0000 (---------------)  + I kokubunji
	0x0037e905, // n0x1240 c0x0000 (---------------)  + I komae
	0x00301bc4, // n0x1241 c0x0000 (---------------)  + I koto
	0x0032a78a, // n0x1242 c0x0000 (---------------)  + I kouzushima
	0x002b3009, // n0x1243 c0x0000 (---------------)  + I kunitachi
	0x002a8dc7, // n0x1244 c0x0000 (---------------)  + I machida
	0x00296ac6, // n0x1245 c0x0000 (---------------)  + I meguro
	0x0034cb46, // n0x1246 c0x0000 (---------------)  + I minato
	0x002a0ac6, // n0x1247 c0x0000 (---------------)  + I mitaka
	0x0035e106, // n0x1248 c0x0000 (---------------)  + I mizuho
	0x002cee0f, // n0x1249 c0x0000 (---------------)  + I musashimurayama
	0x002cf8c9, // n0x124a c0x0000 (---------------)  + I musashino
	0x002546c6, // n0x124b c0x0000 (---------------)  + I nakano
	0x00256d06, // n0x124c c0x0000 (---------------)  + I nerima
	0x00355a09, // n0x124d c0x0000 (---------------)  + I ogasawara
	0x00303707, // n0x124e c0x0000 (---------------)  + I okutama
	0x00213a83, // n0x124f c0x0000 (---------------)  + I ome
	0x0020ef06, // n0x1250 c0x0000 (---------------)  + I oshima
	0x00204083, // n0x1251 c0x0000 (---------------)  + I ota
	0x0024cf48, // n0x1252 c0x0000 (---------------)  + I setagaya
	0x00300407, // n0x1253 c0x0000 (---------------)  + I shibuya
	0x0029f1c9, // n0x1254 c0x0000 (---------------)  + I shinagawa
	0x00383608, // n0x1255 c0x0000 (---------------)  + I shinjuku
	0x00377e48, // n0x1256 c0x0000 (---------------)  + I suginami
	0x0036e146, // n0x1257 c0x0000 (---------------)  + I sumida
	0x00223909, // n0x1258 c0x0000 (---------------)  + I tachikawa
	0x002400c5, // n0x1259 c0x0000 (---------------)  + I taito
	0x0024e7c4, // n0x125a c0x0000 (---------------)  + I tama
	0x0024aec7, // n0x125b c0x0000 (---------------)  + I toshima
	0x00257085, // n0x125c c0x0000 (---------------)  + I chizu
	0x0020dbc4, // n0x125d c0x0000 (---------------)  + I hino
	0x00248ac8, // n0x125e c0x0000 (---------------)  + I kawahara
	0x002180c4, // n0x125f c0x0000 (---------------)  + I koge
	0x00301bc7, // n0x1260 c0x0000 (---------------)  + I kotoura
	0x0036fc86, // n0x1261 c0x0000 (---------------)  + I misasa
	0x002e5a85, // n0x1262 c0x0000 (---------------)  + I nanbu
	0x002869c8, // n0x1263 c0x0000 (---------------)  + I nichinan
	0x0034ca0b, // n0x1264 c0x0000 (---------------)  + I sakaiminato
	0x002f8b87, // n0x1265 c0x0000 (---------------)  + I tottori
	0x0036ba46, // n0x1266 c0x0000 (---------------)  + I wakasa
	0x002c0c84, // n0x1267 c0x0000 (---------------)  + I yazu
	0x0030f5c6, // n0x1268 c0x0000 (---------------)  + I yonago
	0x002bf185, // n0x1269 c0x0000 (---------------)  + I asahi
	0x002bc1c5, // n0x126a c0x0000 (---------------)  + I fuchu
	0x0027dfc9, // n0x126b c0x0000 (---------------)  + I fukumitsu
	0x002824c9, // n0x126c c0x0000 (---------------)  + I funahashi
	0x00228204, // n0x126d c0x0000 (---------------)  + I himi
	0x00228245, // n0x126e c0x0000 (---------------)  + I imizu
	0x00228445, // n0x126f c0x0000 (---------------)  + I inami
	0x003565c6, // n0x1270 c0x0000 (---------------)  + I johana
	0x002fdcc8, // n0x1271 c0x0000 (---------------)  + I kamiichi
	0x002b7bc6, // n0x1272 c0x0000 (---------------)  + I kurobe
	0x00330c8b, // n0x1273 c0x0000 (---------------)  + I nakaniikawa
	0x0030138a, // n0x1274 c0x0000 (---------------)  + I namerikawa
	0x00342185, // n0x1275 c0x0000 (---------------)  + I nanto
	0x0028a886, // n0x1276 c0x0000 (---------------)  + I nyuzen
	0x002f5985, // n0x1277 c0x0000 (---------------)  + I oyabe
	0x00218d45, // n0x1278 c0x0000 (---------------)  + I taira
	0x0028ed47, // n0x1279 c0x0000 (---------------)  + I takaoka
	0x002040c8, // n0x127a c0x0000 (---------------)  + I tateyama
	0x0025af04, // n0x127b c0x0000 (---------------)  + I toga
	0x002b6586, // n0x127c c0x0000 (---------------)  + I tonami
	0x0028e9c6, // n0x127d c0x0000 (---------------)  + I toyama
	0x00212607, // n0x127e c0x0000 (---------------)  + I unazuki
	0x00300a04, // n0x127f c0x0000 (---------------)  + I uozu
	0x0027ce46, // n0x1280 c0x0000 (---------------)  + I yamada
	0x0023ec85, // n0x1281 c0x0000 (---------------)  + I arida
	0x0023ec89, // n0x1282 c0x0000 (---------------)  + I aridagawa
	0x00213184, // n0x1283 c0x0000 (---------------)  + I gobo
	0x0028e009, // n0x1284 c0x0000 (---------------)  + I hashimoto
	0x0027ab86, // n0x1285 c0x0000 (---------------)  + I hidaka
	0x002b9ac8, // n0x1286 c0x0000 (---------------)  + I hirogawa
	0x00228445, // n0x1287 c0x0000 (---------------)  + I inami
	0x00311e85, // n0x1288 c0x0000 (---------------)  + I iwade
	0x00223206, // n0x1289 c0x0000 (---------------)  + I kainan
	0x0026e889, // n0x128a c0x0000 (---------------)  + I kamitonda
	0x00219349, // n0x128b c0x0000 (---------------)  + I katsuragi
	0x002d7b06, // n0x128c c0x0000 (---------------)  + I kimino
	0x0026b6c8, // n0x128d c0x0000 (---------------)  + I kinokawa
	0x00267988, // n0x128e c0x0000 (---------------)  + I kitayama
	0x002f5944, // n0x128f c0x0000 (---------------)  + I koya
	0x0032dcc4, // n0x1290 c0x0000 (---------------)  + I koza
	0x0032dcc8, // n0x1291 c0x0000 (---------------)  + I kozagawa
	0x00316788, // n0x1292 c0x0000 (---------------)  + I kudoyama
	0x002ae8c9, // n0x1293 c0x0000 (---------------)  + I kushimoto
	0x002da306, // n0x1294 c0x0000 (---------------)  + I mihama
	0x0022f486, // n0x1295 c0x0000 (---------------)  + I misato
	0x0031408d, // n0x1296 c0x0000 (---------------)  + I nachikatsuura
	0x00266d06, // n0x1297 c0x0000 (---------------)  + I shingu
	0x002a9a49, // n0x1298 c0x0000 (---------------)  + I shirahama
	0x00201685, // n0x1299 c0x0000 (---------------)  + I taiji
	0x0031f386, // n0x129a c0x0000 (---------------)  + I tanabe
	0x00223ac8, // n0x129b c0x0000 (---------------)  + I wakayama
	0x00310745, // n0x129c c0x0000 (---------------)  + I yuasa
	0x0036adc4, // n0x129d c0x0000 (---------------)  + I yura
	0x002bf185, // n0x129e c0x0000 (---------------)  + I asahi
	0x00281b48, // n0x129f c0x0000 (---------------)  + I funagata
	0x0029a209, // n0x12a0 c0x0000 (---------------)  + I higashine
	0x00277cc4, // n0x12a1 c0x0000 (---------------)  + I iide
	0x0033d046, // n0x12a2 c0x0000 (---------------)  + I kahoku
	0x0024ff0a, // n0x12a3 c0x0000 (---------------)  + I kaminoyama
	0x002c7848, // n0x12a4 c0x0000 (---------------)  + I kaneyama
	0x002bdc49, // n0x12a5 c0x0000 (---------------)  + I kawanishi
	0x0029378a, // n0x12a6 c0x0000 (---------------)  + I mamurogawa
	0x002e8086, // n0x12a7 c0x0000 (---------------)  + I mikawa
	0x00298a48, // n0x12a8 c0x0000 (---------------)  + I murayama
	0x002cdc45, // n0x12a9 c0x0000 (---------------)  + I nagai
	0x002c9e08, // n0x12aa c0x0000 (---------------)  + I nakayama
	0x002b1ec5, // n0x12ab c0x0000 (---------------)  + I nanyo
	0x0021a489, // n0x12ac c0x0000 (---------------)  + I nishikawa
	0x00361849, // n0x12ad c0x0000 (---------------)  + I obanazawa
	0x00203282, // n0x12ae c0x0000 (---------------)  + I oe
	0x002a6a45, // n0x12af c0x0000 (---------------)  + I oguni
	0x0026f6c6, // n0x12b0 c0x0000 (---------------)  + I ohkura
	0x0027aac7, // n0x12b1 c0x0000 (---------------)  + I oishida
	0x00238905, // n0x12b2 c0x0000 (---------------)  + I sagae
	0x002f8486, // n0x12b3 c0x0000 (---------------)  + I sakata
	0x00310808, // n0x12b4 c0x0000 (---------------)  + I sakegawa
	0x0033bd46, // n0x12b5 c0x0000 (---------------)  + I shinjo
	0x00347f09, // n0x12b6 c0x0000 (---------------)  + I shirataka
	0x002792c6, // n0x12b7 c0x0000 (---------------)  + I shonai
	0x00281cc8, // n0x12b8 c0x0000 (---------------)  + I takahata
	0x002a94c5, // n0x12b9 c0x0000 (---------------)  + I tendo
	0x0026de86, // n0x12ba c0x0000 (---------------)  + I tozawa
	0x0032f7c8, // n0x12bb c0x0000 (---------------)  + I tsuruoka
	0x002808c8, // n0x12bc c0x0000 (---------------)  + I yamagata
	0x0039e808, // n0x12bd c0x0000 (---------------)  + I yamanobe
	0x00366688, // n0x12be c0x0000 (---------------)  + I yonezawa
	0x00217244, // n0x12bf c0x0000 (---------------)  + I yuza
	0x0022d843, // n0x12c0 c0x0000 (---------------)  + I abu
	0x00348144, // n0x12c1 c0x0000 (---------------)  + I hagi
	0x0022f006, // n0x12c2 c0x0000 (---------------)  + I hikari
	0x002db204, // n0x12c3 c0x0000 (---------------)  + I hofu
	0x002da0c7, // n0x12c4 c0x0000 (---------------)  + I iwakuni
	0x0039fd89, // n0x12c5 c0x0000 (---------------)  + I kudamatsu
	0x002c0485, // n0x12c6 c0x0000 (---------------)  + I mitou
	0x0038e086, // n0x12c7 c0x0000 (---------------)  + I nagato
	0x0020ef06, // n0x12c8 c0x0000 (---------------)  + I oshima
	0x0026c3cb, // n0x12c9 c0x0000 (---------------)  + I shimonoseki
	0x003420c6, // n0x12ca c0x0000 (---------------)  + I shunan
	0x00316a86, // n0x12cb c0x0000 (---------------)  + I tabuse
	0x0022f588, // n0x12cc c0x0000 (---------------)  + I tokuyama
	0x0025bb86, // n0x12cd c0x0000 (---------------)  + I toyota
	0x00297443, // n0x12ce c0x0000 (---------------)  + I ube
	0x0020f9c3, // n0x12cf c0x0000 (---------------)  + I yuu
	0x0030ba84, // n0x12d0 c0x0000 (---------------)  + I chuo
	0x00236305, // n0x12d1 c0x0000 (---------------)  + I doshi
	0x0036af47, // n0x12d2 c0x0000 (---------------)  + I fuefuki
	0x00277e48, // n0x12d3 c0x0000 (---------------)  + I fujikawa
	0x00277e4f, // n0x12d4 c0x0000 (---------------)  + I fujikawaguchiko
	0x0027c24b, // n0x12d5 c0x0000 (---------------)  + I fujiyoshida
	0x002fdac8, // n0x12d6 c0x0000 (---------------)  + I hayakawa
	0x0033d0c6, // n0x12d7 c0x0000 (---------------)  + I hokuto
	0x0026560e, // n0x12d8 c0x0000 (---------------)  + I ichikawamisato
	0x00223203, // n0x12d9 c0x0000 (---------------)  + I kai
	0x00240c84, // n0x12da c0x0000 (---------------)  + I kofu
	0x00342045, // n0x12db c0x0000 (---------------)  + I koshu
	0x00300146, // n0x12dc c0x0000 (---------------)  + I kosuge
	0x0028bc0b, // n0x12dd c0x0000 (---------------)  + I minami-alps
	0x00290086, // n0x12de c0x0000 (---------------)  + I minobu
	0x002164c9, // n0x12df c0x0000 (---------------)  + I nakamichi
	0x002e5a85, // n0x12e0 c0x0000 (---------------)  + I nanbu
	0x00381e08, // n0x12e1 c0x0000 (---------------)  + I narusawa
	0x0020c388, // n0x12e2 c0x0000 (---------------)  + I nirasaki
	0x0021920c, // n0x12e3 c0x0000 (---------------)  + I nishikatsura
	0x0029e5c6, // n0x12e4 c0x0000 (---------------)  + I oshino
	0x0021f306, // n0x12e5 c0x0000 (---------------)  + I otsuki
	0x00319905, // n0x12e6 c0x0000 (---------------)  + I showa
	0x002872c8, // n0x12e7 c0x0000 (---------------)  + I tabayama
	0x0027b9c5, // n0x12e8 c0x0000 (---------------)  + I tsuru
	0x00387308, // n0x12e9 c0x0000 (---------------)  + I uenohara
	0x0029dc8a, // n0x12ea c0x0000 (---------------)  + I yamanakako
	0x002a15c9, // n0x12eb c0x0000 (---------------)  + I yamanashi
	0x00686744, // n0x12ec c0x0001 (---------------)  ! I city
	0x2e200742, // n0x12ed c0x00b8 (n0x12ee-n0x12ef)  o I co
	0x000ffa08, // n0x12ee c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x12ef c0x0000 (---------------)  + I com
	0x0023a783, // n0x12f0 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x12f1 c0x0000 (---------------)  + I gov
	0x00209003, // n0x12f2 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x12f3 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x12f4 c0x0000 (---------------)  + I org
	0x00330b83, // n0x12f5 c0x0000 (---------------)  + I biz
	0x00233503, // n0x12f6 c0x0000 (---------------)  + I com
	0x0023a783, // n0x12f7 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x12f8 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x12f9 c0x0000 (---------------)  + I info
	0x0021fe03, // n0x12fa c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x12fb c0x0000 (---------------)  + I org
	0x0023f743, // n0x12fc c0x0000 (---------------)  + I ass
	0x002d4884, // n0x12fd c0x0000 (---------------)  + I asso
	0x00233503, // n0x12fe c0x0000 (---------------)  + I com
	0x0023d684, // n0x12ff c0x0000 (---------------)  + I coop
	0x0023a783, // n0x1300 c0x0000 (---------------)  + I edu
	0x0033d7c4, // n0x1301 c0x0000 (---------------)  + I gouv
	0x0026cc83, // n0x1302 c0x0000 (---------------)  + I gov
	0x00238bc7, // n0x1303 c0x0000 (---------------)  + I medecin
	0x00209003, // n0x1304 c0x0000 (---------------)  + I mil
	0x00201483, // n0x1305 c0x0000 (---------------)  + I nom
	0x0025c988, // n0x1306 c0x0000 (---------------)  + I notaires
	0x0022d1c3, // n0x1307 c0x0000 (---------------)  + I org
	0x0034d60b, // n0x1308 c0x0000 (---------------)  + I pharmaciens
	0x002e1043, // n0x1309 c0x0000 (---------------)  + I prd
	0x00247506, // n0x130a c0x0000 (---------------)  + I presse
	0x00200142, // n0x130b c0x0000 (---------------)  + I tm
	0x002d1c8b, // n0x130c c0x0000 (---------------)  + I veterinaire
	0x0023a783, // n0x130d c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x130e c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x130f c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1310 c0x0000 (---------------)  + I org
	0x00233503, // n0x1311 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1312 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1313 c0x0000 (---------------)  + I gov
	0x0022d1c3, // n0x1314 c0x0000 (---------------)  + I org
	0x0022b7c3, // n0x1315 c0x0000 (---------------)  + I rep
	0x00203003, // n0x1316 c0x0000 (---------------)  + I tra
	0x00201542, // n0x1317 c0x0000 (---------------)  + I ac
	0x000ffa08, // n0x1318 c0x0000 (---------------)  +   blogspot
	0x0022b945, // n0x1319 c0x0000 (---------------)  + I busan
	0x003051c8, // n0x131a c0x0000 (---------------)  + I chungbuk
	0x003113c8, // n0x131b c0x0000 (---------------)  + I chungnam
	0x00200742, // n0x131c c0x0000 (---------------)  + I co
	0x0024a3c5, // n0x131d c0x0000 (---------------)  + I daegu
	0x00325007, // n0x131e c0x0000 (---------------)  + I daejeon
	0x00200482, // n0x131f c0x0000 (---------------)  + I es
	0x00216707, // n0x1320 c0x0000 (---------------)  + I gangwon
	0x00202d42, // n0x1321 c0x0000 (---------------)  + I go
	0x00242707, // n0x1322 c0x0000 (---------------)  + I gwangju
	0x0030b509, // n0x1323 c0x0000 (---------------)  + I gyeongbuk
	0x002cd808, // n0x1324 c0x0000 (---------------)  + I gyeonggi
	0x00208209, // n0x1325 c0x0000 (---------------)  + I gyeongnam
	0x0023f382, // n0x1326 c0x0000 (---------------)  + I hs
	0x00268e07, // n0x1327 c0x0000 (---------------)  + I incheon
	0x002d7884, // n0x1328 c0x0000 (---------------)  + I jeju
	0x003250c7, // n0x1329 c0x0000 (---------------)  + I jeonbuk
	0x00301287, // n0x132a c0x0000 (---------------)  + I jeonnam
	0x002b5502, // n0x132b c0x0000 (---------------)  + I kg
	0x00209003, // n0x132c c0x0000 (---------------)  + I mil
	0x0020f702, // n0x132d c0x0000 (---------------)  + I ms
	0x00202c02, // n0x132e c0x0000 (---------------)  + I ne
	0x00200282, // n0x132f c0x0000 (---------------)  + I or
	0x00207782, // n0x1330 c0x0000 (---------------)  + I pe
	0x00207002, // n0x1331 c0x0000 (---------------)  + I re
	0x00200702, // n0x1332 c0x0000 (---------------)  + I sc
	0x00344345, // n0x1333 c0x0000 (---------------)  + I seoul
	0x00259585, // n0x1334 c0x0000 (---------------)  + I ulsan
	0x00233503, // n0x1335 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1336 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1337 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1338 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1339 c0x0000 (---------------)  + I org
	0x00233503, // n0x133a c0x0000 (---------------)  + I com
	0x0023a783, // n0x133b c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x133c c0x0000 (---------------)  + I gov
	0x00209003, // n0x133d c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x133e c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x133f c0x0000 (---------------)  + I org
	0x00000301, // n0x1340 c0x0000 (---------------)  +   c
	0x00233503, // n0x1341 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1342 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1343 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x1344 c0x0000 (---------------)  + I info
	0x00201603, // n0x1345 c0x0000 (---------------)  + I int
	0x0021fe03, // n0x1346 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1347 c0x0000 (---------------)  + I org
	0x00220f03, // n0x1348 c0x0000 (---------------)  + I per
	0x00233503, // n0x1349 c0x0000 (---------------)  + I com
	0x0023a783, // n0x134a c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x134b c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x134c c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x134d c0x0000 (---------------)  + I org
	0x00200742, // n0x134e c0x0000 (---------------)  + I co
	0x00233503, // n0x134f c0x0000 (---------------)  + I com
	0x0023a783, // n0x1350 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1351 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1352 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1353 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x1354 c0x0000 (---------------)  +   blogspot
	0x00201542, // n0x1355 c0x0000 (---------------)  + I ac
	0x002bad84, // n0x1356 c0x0000 (---------------)  + I assn
	0x00233503, // n0x1357 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1358 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1359 c0x0000 (---------------)  + I gov
	0x00379ec3, // n0x135a c0x0000 (---------------)  + I grp
	0x00234dc5, // n0x135b c0x0000 (---------------)  + I hotel
	0x00201603, // n0x135c c0x0000 (---------------)  + I int
	0x00322cc3, // n0x135d c0x0000 (---------------)  + I ltd
	0x0021fe03, // n0x135e c0x0000 (---------------)  + I net
	0x00202d03, // n0x135f c0x0000 (---------------)  + I ngo
	0x0022d1c3, // n0x1360 c0x0000 (---------------)  + I org
	0x00217443, // n0x1361 c0x0000 (---------------)  + I sch
	0x00274803, // n0x1362 c0x0000 (---------------)  + I soc
	0x00221a03, // n0x1363 c0x0000 (---------------)  + I web
	0x00233503, // n0x1364 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1365 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1366 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1367 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1368 c0x0000 (---------------)  + I org
	0x00200742, // n0x1369 c0x0000 (---------------)  + I co
	0x0022d1c3, // n0x136a c0x0000 (---------------)  + I org
	0x000ffa08, // n0x136b c0x0000 (---------------)  +   blogspot
	0x0026cc83, // n0x136c c0x0000 (---------------)  + I gov
	0x000ffa08, // n0x136d c0x0000 (---------------)  +   blogspot
	0x002afc83, // n0x136e c0x0000 (---------------)  + I asn
	0x00233503, // n0x136f c0x0000 (---------------)  + I com
	0x00236cc4, // n0x1370 c0x0000 (---------------)  + I conf
	0x0023a783, // n0x1371 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1372 c0x0000 (---------------)  + I gov
	0x0020c782, // n0x1373 c0x0000 (---------------)  + I id
	0x00209003, // n0x1374 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1375 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1376 c0x0000 (---------------)  + I org
	0x00233503, // n0x1377 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1378 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1379 c0x0000 (---------------)  + I gov
	0x0020c782, // n0x137a c0x0000 (---------------)  + I id
	0x00213ac3, // n0x137b c0x0000 (---------------)  + I med
	0x0021fe03, // n0x137c c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x137d c0x0000 (---------------)  + I org
	0x002db143, // n0x137e c0x0000 (---------------)  + I plc
	0x00217443, // n0x137f c0x0000 (---------------)  + I sch
	0x00201542, // n0x1380 c0x0000 (---------------)  + I ac
	0x00200742, // n0x1381 c0x0000 (---------------)  + I co
	0x0026cc83, // n0x1382 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1383 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1384 c0x0000 (---------------)  + I org
	0x00247505, // n0x1385 c0x0000 (---------------)  + I press
	0x002d4884, // n0x1386 c0x0000 (---------------)  + I asso
	0x00200142, // n0x1387 c0x0000 (---------------)  + I tm
	0x000ffa08, // n0x1388 c0x0000 (---------------)  +   blogspot
	0x00201542, // n0x1389 c0x0000 (---------------)  + I ac
	0x00200742, // n0x138a c0x0000 (---------------)  + I co
	0x00054d8b, // n0x138b c0x0000 (---------------)  +   diskstation
	0x00009107, // n0x138c c0x0000 (---------------)  +   dscloud
	0x0023a783, // n0x138d c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x138e c0x0000 (---------------)  + I gov
	0x00157b84, // n0x138f c0x0000 (---------------)  +   i234
	0x00230483, // n0x1390 c0x0000 (---------------)  + I its
	0x00156bc4, // n0x1391 c0x0000 (---------------)  +   myds
	0x0021fe03, // n0x1392 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1393 c0x0000 (---------------)  + I org
	0x002e1c44, // n0x1394 c0x0000 (---------------)  + I priv
	0x0010b388, // n0x1395 c0x0000 (---------------)  +   synology
	0x00200742, // n0x1396 c0x0000 (---------------)  + I co
	0x00233503, // n0x1397 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1398 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1399 c0x0000 (---------------)  + I gov
	0x00209003, // n0x139a c0x0000 (---------------)  + I mil
	0x00201483, // n0x139b c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x139c c0x0000 (---------------)  + I org
	0x002e1043, // n0x139d c0x0000 (---------------)  + I prd
	0x00200142, // n0x139e c0x0000 (---------------)  + I tm
	0x000ffa08, // n0x139f c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x13a0 c0x0000 (---------------)  + I com
	0x0023a783, // n0x13a1 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x13a2 c0x0000 (---------------)  + I gov
	0x003a1083, // n0x13a3 c0x0000 (---------------)  + I inf
	0x00205284, // n0x13a4 c0x0000 (---------------)  + I name
	0x0021fe03, // n0x13a5 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x13a6 c0x0000 (---------------)  + I org
	0x00233503, // n0x13a7 c0x0000 (---------------)  + I com
	0x0023a783, // n0x13a8 c0x0000 (---------------)  + I edu
	0x0033d7c4, // n0x13a9 c0x0000 (---------------)  + I gouv
	0x0026cc83, // n0x13aa c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x13ab c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x13ac c0x0000 (---------------)  + I org
	0x00247506, // n0x13ad c0x0000 (---------------)  + I presse
	0x0023a783, // n0x13ae c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x13af c0x0000 (---------------)  + I gov
	0x0016ef83, // n0x13b0 c0x0000 (---------------)  +   nyc
	0x0022d1c3, // n0x13b1 c0x0000 (---------------)  + I org
	0x00233503, // n0x13b2 c0x0000 (---------------)  + I com
	0x0023a783, // n0x13b3 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x13b4 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x13b5 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x13b6 c0x0000 (---------------)  + I org
	0x00009107, // n0x13b7 c0x0000 (---------------)  +   dscloud
	0x000ffa08, // n0x13b8 c0x0000 (---------------)  +   blogspot
	0x0026cc83, // n0x13b9 c0x0000 (---------------)  + I gov
	0x00233503, // n0x13ba c0x0000 (---------------)  + I com
	0x0023a783, // n0x13bb c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x13bc c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x13bd c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x13be c0x0000 (---------------)  + I org
	0x36633503, // n0x13bf c0x00d9 (n0x13c3-n0x13c4)  + I com
	0x0023a783, // n0x13c0 c0x0000 (---------------)  + I edu
	0x0021fe03, // n0x13c1 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x13c2 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x13c3 c0x0000 (---------------)  +   blogspot
	0x00201542, // n0x13c4 c0x0000 (---------------)  + I ac
	0x00200742, // n0x13c5 c0x0000 (---------------)  + I co
	0x00233503, // n0x13c6 c0x0000 (---------------)  + I com
	0x0026cc83, // n0x13c7 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x13c8 c0x0000 (---------------)  + I net
	0x00200282, // n0x13c9 c0x0000 (---------------)  + I or
	0x0022d1c3, // n0x13ca c0x0000 (---------------)  + I org
	0x0030aec7, // n0x13cb c0x0000 (---------------)  + I academy
	0x00209c8b, // n0x13cc c0x0000 (---------------)  + I agriculture
	0x00204903, // n0x13cd c0x0000 (---------------)  + I air
	0x0023b1c8, // n0x13ce c0x0000 (---------------)  + I airguard
	0x002ec607, // n0x13cf c0x0000 (---------------)  + I alabama
	0x00279bc6, // n0x13d0 c0x0000 (---------------)  + I alaska
	0x00367645, // n0x13d1 c0x0000 (---------------)  + I amber
	0x002c8609, // n0x13d2 c0x0000 (---------------)  + I ambulance
	0x00208d88, // n0x13d3 c0x0000 (---------------)  + I american
	0x002729c9, // n0x13d4 c0x0000 (---------------)  + I americana
	0x002729d0, // n0x13d5 c0x0000 (---------------)  + I americanantiques
	0x0035994b, // n0x13d6 c0x0000 (---------------)  + I americanart
	0x002c8449, // n0x13d7 c0x0000 (---------------)  + I amsterdam
	0x00200843, // n0x13d8 c0x0000 (---------------)  + I and
	0x00357549, // n0x13d9 c0x0000 (---------------)  + I annefrank
	0x00237a06, // n0x13da c0x0000 (---------------)  + I anthro
	0x00237a0c, // n0x13db c0x0000 (---------------)  + I anthropology
	0x0022ba08, // n0x13dc c0x0000 (---------------)  + I antiques
	0x003a2308, // n0x13dd c0x0000 (---------------)  + I aquarium
	0x00258249, // n0x13de c0x0000 (---------------)  + I arboretum
	0x0029fb0e, // n0x13df c0x0000 (---------------)  + I archaeological
	0x0037228b, // n0x13e0 c0x0000 (---------------)  + I archaeology
	0x0031fa0c, // n0x13e1 c0x0000 (---------------)  + I architecture
	0x002011c3, // n0x13e2 c0x0000 (---------------)  + I art
	0x003284cc, // n0x13e3 c0x0000 (---------------)  + I artanddesign
	0x002043c9, // n0x13e4 c0x0000 (---------------)  + I artcenter
	0x0020b107, // n0x13e5 c0x0000 (---------------)  + I artdeco
	0x0023a6cc, // n0x13e6 c0x0000 (---------------)  + I arteducation
	0x0039208a, // n0x13e7 c0x0000 (---------------)  + I artgallery
	0x0024bf84, // n0x13e8 c0x0000 (---------------)  + I arts
	0x0039eacd, // n0x13e9 c0x0000 (---------------)  + I artsandcrafts
	0x00328388, // n0x13ea c0x0000 (---------------)  + I asmatart
	0x0039efcd, // n0x13eb c0x0000 (---------------)  + I assassination
	0x00252046, // n0x13ec c0x0000 (---------------)  + I assisi
	0x002d488b, // n0x13ed c0x0000 (---------------)  + I association
	0x00356a09, // n0x13ee c0x0000 (---------------)  + I astronomy
	0x002244c7, // n0x13ef c0x0000 (---------------)  + I atlanta
	0x002ea306, // n0x13f0 c0x0000 (---------------)  + I austin
	0x003082c9, // n0x13f1 c0x0000 (---------------)  + I australia
	0x00322f8a, // n0x13f2 c0x0000 (---------------)  + I automotive
	0x0035b848, // n0x13f3 c0x0000 (---------------)  + I aviation
	0x002e0b84, // n0x13f4 c0x0000 (---------------)  + I axis
	0x00277007, // n0x13f5 c0x0000 (---------------)  + I badajoz
	0x002a1847, // n0x13f6 c0x0000 (---------------)  + I baghdad
	0x002ec084, // n0x13f7 c0x0000 (---------------)  + I bahn
	0x00228a84, // n0x13f8 c0x0000 (---------------)  + I bale
	0x0025d289, // n0x13f9 c0x0000 (---------------)  + I baltimore
	0x002dd889, // n0x13fa c0x0000 (---------------)  + I barcelona
	0x0022f9c8, // n0x13fb c0x0000 (---------------)  + I baseball
	0x00210685, // n0x13fc c0x0000 (---------------)  + I basel
	0x00389345, // n0x13fd c0x0000 (---------------)  + I baths
	0x0020d246, // n0x13fe c0x0000 (---------------)  + I bauern
	0x0039e989, // n0x13ff c0x0000 (---------------)  + I beauxarts
	0x0021b10d, // n0x1400 c0x0000 (---------------)  + I beeldengeluid
	0x0031f488, // n0x1401 c0x0000 (---------------)  + I bellevue
	0x0020d147, // n0x1402 c0x0000 (---------------)  + I bergbau
	0x003676c8, // n0x1403 c0x0000 (---------------)  + I berkeley
	0x0022e6c6, // n0x1404 c0x0000 (---------------)  + I berlin
	0x00390744, // n0x1405 c0x0000 (---------------)  + I bern
	0x0037bf45, // n0x1406 c0x0000 (---------------)  + I bible
	0x002028c6, // n0x1407 c0x0000 (---------------)  + I bilbao
	0x00202e84, // n0x1408 c0x0000 (---------------)  + I bill
	0x002042c7, // n0x1409 c0x0000 (---------------)  + I birdart
	0x0020628a, // n0x140a c0x0000 (---------------)  + I birthplace
	0x00212384, // n0x140b c0x0000 (---------------)  + I bonn
	0x00217cc6, // n0x140c c0x0000 (---------------)  + I boston
	0x00218e89, // n0x140d c0x0000 (---------------)  + I botanical
	0x00218e8f, // n0x140e c0x0000 (---------------)  + I botanicalgarden
	0x0021a18d, // n0x140f c0x0000 (---------------)  + I botanicgarden
	0x0021a946, // n0x1410 c0x0000 (---------------)  + I botany
	0x0021ca50, // n0x1411 c0x0000 (---------------)  + I brandywinevalley
	0x0021ce46, // n0x1412 c0x0000 (---------------)  + I brasil
	0x0021db87, // n0x1413 c0x0000 (---------------)  + I bristol
	0x0021df07, // n0x1414 c0x0000 (---------------)  + I british
	0x0021df0f, // n0x1415 c0x0000 (---------------)  + I britishcolumbia
	0x0021fa49, // n0x1416 c0x0000 (---------------)  + I broadcast
	0x00222b06, // n0x1417 c0x0000 (---------------)  + I brunel
	0x00225e87, // n0x1418 c0x0000 (---------------)  + I brussel
	0x00225e88, // n0x1419 c0x0000 (---------------)  + I brussels
	0x00227049, // n0x141a c0x0000 (---------------)  + I bruxelles
	0x0028fd88, // n0x141b c0x0000 (---------------)  + I building
	0x002d7647, // n0x141c c0x0000 (---------------)  + I burghof
	0x0020ca03, // n0x141d c0x0000 (---------------)  + I bus
	0x00233386, // n0x141e c0x0000 (---------------)  + I bushey
	0x00200308, // n0x141f c0x0000 (---------------)  + I cadaques
	0x0029fdca, // n0x1420 c0x0000 (---------------)  + I california
	0x00221ac9, // n0x1421 c0x0000 (---------------)  + I cambridge
	0x00208ec3, // n0x1422 c0x0000 (---------------)  + I can
	0x00324f06, // n0x1423 c0x0000 (---------------)  + I canada
	0x002b63ca, // n0x1424 c0x0000 (---------------)  + I capebreton
	0x00365247, // n0x1425 c0x0000 (---------------)  + I carrier
	0x0020af4a, // n0x1426 c0x0000 (---------------)  + I cartoonart
	0x0021460e, // n0x1427 c0x0000 (---------------)  + I casadelamoneda
	0x0021fb86, // n0x1428 c0x0000 (---------------)  + I castle
	0x002a6c47, // n0x1429 c0x0000 (---------------)  + I castres
	0x00211b46, // n0x142a c0x0000 (---------------)  + I celtic
	0x00204486, // n0x142b c0x0000 (---------------)  + I center
	0x00374acb, // n0x142c c0x0000 (---------------)  + I chattanooga
	0x002648ca, // n0x142d c0x0000 (---------------)  + I cheltenham
	0x0035150d, // n0x142e c0x0000 (---------------)  + I chesapeakebay
	0x00213047, // n0x142f c0x0000 (---------------)  + I chicago
	0x00274888, // n0x1430 c0x0000 (---------------)  + I children
	0x00274889, // n0x1431 c0x0000 (---------------)  + I childrens
	0x0027488f, // n0x1432 c0x0000 (---------------)  + I childrensgarden
	0x0023984c, // n0x1433 c0x0000 (---------------)  + I chiropractic
	0x002b5a89, // n0x1434 c0x0000 (---------------)  + I chocolate
	0x00379b8e, // n0x1435 c0x0000 (---------------)  + I christiansburg
	0x00238cca, // n0x1436 c0x0000 (---------------)  + I cincinnati
	0x002ce4c6, // n0x1437 c0x0000 (---------------)  + I cinema
	0x00337c86, // n0x1438 c0x0000 (---------------)  + I circus
	0x00363b8c, // n0x1439 c0x0000 (---------------)  + I civilisation
	0x00367b8c, // n0x143a c0x0000 (---------------)  + I civilization
	0x0036f008, // n0x143b c0x0000 (---------------)  + I civilwar
	0x003894c7, // n0x143c c0x0000 (---------------)  + I clinton
	0x002acc45, // n0x143d c0x0000 (---------------)  + I clock
	0x00355244, // n0x143e c0x0000 (---------------)  + I coal
	0x00386b8e, // n0x143f c0x0000 (---------------)  + I coastaldefence
	0x00323204, // n0x1440 c0x0000 (---------------)  + I cody
	0x00231d87, // n0x1441 c0x0000 (---------------)  + I coldwar
	0x00265b8a, // n0x1442 c0x0000 (---------------)  + I collection
	0x00232454, // n0x1443 c0x0000 (---------------)  + I colonialwilliamsburg
	0x00232dcf, // n0x1444 c0x0000 (---------------)  + I coloradoplateau
	0x0021e0c8, // n0x1445 c0x0000 (---------------)  + I columbia
	0x00233248, // n0x1446 c0x0000 (---------------)  + I columbus
	0x0036018d, // n0x1447 c0x0000 (---------------)  + I communication
	0x0036018e, // n0x1448 c0x0000 (---------------)  + I communications
	0x00233509, // n0x1449 c0x0000 (---------------)  + I community
	0x00235488, // n0x144a c0x0000 (---------------)  + I computer
	0x0023548f, // n0x144b c0x0000 (---------------)  + I computerhistory
	0x0023a3cc, // n0x144c c0x0000 (---------------)  + I contemporary
	0x0023a3cf, // n0x144d c0x0000 (---------------)  + I contemporaryart
	0x0023b747, // n0x144e c0x0000 (---------------)  + I convent
	0x0023de0a, // n0x144f c0x0000 (---------------)  + I copenhagen
	0x0021c58b, // n0x1450 c0x0000 (---------------)  + I corporation
	0x0023f888, // n0x1451 c0x0000 (---------------)  + I corvette
	0x00241807, // n0x1452 c0x0000 (---------------)  + I costume
	0x0033658d, // n0x1453 c0x0000 (---------------)  + I countryestate
	0x0031ab06, // n0x1454 c0x0000 (---------------)  + I county
	0x0039ec86, // n0x1455 c0x0000 (---------------)  + I crafts
	0x00243c49, // n0x1456 c0x0000 (---------------)  + I cranbrook
	0x00336b48, // n0x1457 c0x0000 (---------------)  + I creation
	0x00247888, // n0x1458 c0x0000 (---------------)  + I cultural
	0x0024788e, // n0x1459 c0x0000 (---------------)  + I culturalcenter
	0x00209d87, // n0x145a c0x0000 (---------------)  + I culture
	0x00322345, // n0x145b c0x0000 (---------------)  + I cyber
	0x0024a985, // n0x145c c0x0000 (---------------)  + I cymru
	0x00210284, // n0x145d c0x0000 (---------------)  + I dali
	0x00279e86, // n0x145e c0x0000 (---------------)  + I dallas
	0x0022f8c8, // n0x145f c0x0000 (---------------)  + I database
	0x002edd03, // n0x1460 c0x0000 (---------------)  + I ddr
	0x0025fa0e, // n0x1461 c0x0000 (---------------)  + I decorativearts
	0x00336948, // n0x1462 c0x0000 (---------------)  + I delaware
	0x0027af0b, // n0x1463 c0x0000 (---------------)  + I delmenhorst
	0x003312c7, // n0x1464 c0x0000 (---------------)  + I denmark
	0x00274145, // n0x1465 c0x0000 (---------------)  + I depot
	0x0022dcc6, // n0x1466 c0x0000 (---------------)  + I design
	0x002aa507, // n0x1467 c0x0000 (---------------)  + I detroit
	0x002fac88, // n0x1468 c0x0000 (---------------)  + I dinosaur
	0x00330409, // n0x1469 c0x0000 (---------------)  + I discovery
	0x00237405, // n0x146a c0x0000 (---------------)  + I dolls
	0x002861c8, // n0x146b c0x0000 (---------------)  + I donostia
	0x0020cc06, // n0x146c c0x0000 (---------------)  + I durham
	0x0037574a, // n0x146d c0x0000 (---------------)  + I eastafrica
	0x00386a89, // n0x146e c0x0000 (---------------)  + I eastcoast
	0x0023a789, // n0x146f c0x0000 (---------------)  + I education
	0x0023a78b, // n0x1470 c0x0000 (---------------)  + I educational
	0x0028c908, // n0x1471 c0x0000 (---------------)  + I egyptian
	0x002ebf49, // n0x1472 c0x0000 (---------------)  + I eisenbahn
	0x00210746, // n0x1473 c0x0000 (---------------)  + I elburg
	0x002e4f4a, // n0x1474 c0x0000 (---------------)  + I elvendrell
	0x0022980a, // n0x1475 c0x0000 (---------------)  + I embroidery
	0x0023e00c, // n0x1476 c0x0000 (---------------)  + I encyclopedic
	0x00213707, // n0x1477 c0x0000 (---------------)  + I england
	0x002cd60a, // n0x1478 c0x0000 (---------------)  + I entomology
	0x00326d8b, // n0x1479 c0x0000 (---------------)  + I environment
	0x00326d99, // n0x147a c0x0000 (---------------)  + I environmentalconservation
	0x00329a48, // n0x147b c0x0000 (---------------)  + I epilepsy
	0x00247585, // n0x147c c0x0000 (---------------)  + I essex
	0x002c2486, // n0x147d c0x0000 (---------------)  + I estate
	0x0030cf09, // n0x147e c0x0000 (---------------)  + I ethnology
	0x00205346, // n0x147f c0x0000 (---------------)  + I exeter
	0x002115ca, // n0x1480 c0x0000 (---------------)  + I exhibition
	0x00208f86, // n0x1481 c0x0000 (---------------)  + I family
	0x00271d04, // n0x1482 c0x0000 (---------------)  + I farm
	0x002c260d, // n0x1483 c0x0000 (---------------)  + I farmequipment
	0x002ece87, // n0x1484 c0x0000 (---------------)  + I farmers
	0x00271d09, // n0x1485 c0x0000 (---------------)  + I farmstead
	0x00366b05, // n0x1486 c0x0000 (---------------)  + I field
	0x0037ac88, // n0x1487 c0x0000 (---------------)  + I figueres
	0x0024b549, // n0x1488 c0x0000 (---------------)  + I filatelia
	0x0024b784, // n0x1489 c0x0000 (---------------)  + I film
	0x0024be87, // n0x148a c0x0000 (---------------)  + I fineart
	0x0024be88, // n0x148b c0x0000 (---------------)  + I finearts
	0x0024c387, // n0x148c c0x0000 (---------------)  + I finland
	0x00267688, // n0x148d c0x0000 (---------------)  + I flanders
	0x00252947, // n0x148e c0x0000 (---------------)  + I florida
	0x00338705, // n0x148f c0x0000 (---------------)  + I force
	0x00259fcc, // n0x1490 c0x0000 (---------------)  + I fortmissoula
	0x0025ab89, // n0x1491 c0x0000 (---------------)  + I fortworth
	0x002b9f4a, // n0x1492 c0x0000 (---------------)  + I foundation
	0x00385d09, // n0x1493 c0x0000 (---------------)  + I francaise
	0x00357649, // n0x1494 c0x0000 (---------------)  + I frankfurt
	0x00256acc, // n0x1495 c0x0000 (---------------)  + I franziskaner
	0x002e7d0b, // n0x1496 c0x0000 (---------------)  + I freemasonry
	0x0025c488, // n0x1497 c0x0000 (---------------)  + I freiburg
	0x00260048, // n0x1498 c0x0000 (---------------)  + I fribourg
	0x002636c4, // n0x1499 c0x0000 (---------------)  + I frog
	0x00283c88, // n0x149a c0x0000 (---------------)  + I fundacio
	0x00285349, // n0x149b c0x0000 (---------------)  + I furniture
	0x00392147, // n0x149c c0x0000 (---------------)  + I gallery
	0x002190c6, // n0x149d c0x0000 (---------------)  + I garden
	0x00246347, // n0x149e c0x0000 (---------------)  + I gateway
	0x00330689, // n0x149f c0x0000 (---------------)  + I geelvinck
	0x0021334b, // n0x14a0 c0x0000 (---------------)  + I gemological
	0x00396387, // n0x14a1 c0x0000 (---------------)  + I geology
	0x00324c47, // n0x14a2 c0x0000 (---------------)  + I georgia
	0x00279907, // n0x14a3 c0x0000 (---------------)  + I giessen
	0x0039ef44, // n0x14a4 c0x0000 (---------------)  + I glas
	0x0039ef45, // n0x14a5 c0x0000 (---------------)  + I glass
	0x002a8705, // n0x14a6 c0x0000 (---------------)  + I gorge
	0x0033454b, // n0x14a7 c0x0000 (---------------)  + I grandrapids
	0x0038f9c4, // n0x14a8 c0x0000 (---------------)  + I graz
	0x00266e08, // n0x14a9 c0x0000 (---------------)  + I guernsey
	0x0029168a, // n0x14aa c0x0000 (---------------)  + I halloffame
	0x0020ccc7, // n0x14ab c0x0000 (---------------)  + I hamburg
	0x0031bbc7, // n0x14ac c0x0000 (---------------)  + I handson
	0x0028b492, // n0x14ad c0x0000 (---------------)  + I harvestcelebration
	0x0025cb86, // n0x14ae c0x0000 (---------------)  + I hawaii
	0x0036b386, // n0x14af c0x0000 (---------------)  + I health
	0x0030f8ce, // n0x14b0 c0x0000 (---------------)  + I heimatunduhren
	0x0025fd86, // n0x14b1 c0x0000 (---------------)  + I hellas
	0x0020ebc8, // n0x14b2 c0x0000 (---------------)  + I helsinki
	0x00290d0f, // n0x14b3 c0x0000 (---------------)  + I hembygdsforbund
	0x0039f388, // n0x14b4 c0x0000 (---------------)  + I heritage
	0x0036d908, // n0x14b5 c0x0000 (---------------)  + I histoire
	0x002fb8ca, // n0x14b6 c0x0000 (---------------)  + I historical
	0x002fb8d1, // n0x14b7 c0x0000 (---------------)  + I historicalsociety
	0x002a1f0e, // n0x14b8 c0x0000 (---------------)  + I historichouses
	0x002567ca, // n0x14b9 c0x0000 (---------------)  + I historisch
	0x002567cc, // n0x14ba c0x0000 (---------------)  + I historisches
	0x00235687, // n0x14bb c0x0000 (---------------)  + I history
	0x00235690, // n0x14bc c0x0000 (---------------)  + I historyofscience
	0x00202188, // n0x14bd c0x0000 (---------------)  + I horology
	0x002a2105, // n0x14be c0x0000 (---------------)  + I house
	0x002aad4a, // n0x14bf c0x0000 (---------------)  + I humanities
	0x00202ecc, // n0x14c0 c0x0000 (---------------)  + I illustration
	0x002b44cd, // n0x14c1 c0x0000 (---------------)  + I imageandsound
	0x002a3c46, // n0x14c2 c0x0000 (---------------)  + I indian
	0x002a3c47, // n0x14c3 c0x0000 (---------------)  + I indiana
	0x002a3c4c, // n0x14c4 c0x0000 (---------------)  + I indianapolis
	0x002f120c, // n0x14c5 c0x0000 (---------------)  + I indianmarket
	0x0024dd4c, // n0x14c6 c0x0000 (---------------)  + I intelligence
	0x0028a0cb, // n0x14c7 c0x0000 (---------------)  + I interactive
	0x002859c4, // n0x14c8 c0x0000 (---------------)  + I iraq
	0x0021d504, // n0x14c9 c0x0000 (---------------)  + I iron
	0x0034fb49, // n0x14ca c0x0000 (---------------)  + I isleofman
	0x002c8ec7, // n0x14cb c0x0000 (---------------)  + I jamison
	0x00266a49, // n0x14cc c0x0000 (---------------)  + I jefferson
	0x00283549, // n0x14cd c0x0000 (---------------)  + I jerusalem
	0x00360f47, // n0x14ce c0x0000 (---------------)  + I jewelry
	0x00391f06, // n0x14cf c0x0000 (---------------)  + I jewish
	0x00391f09, // n0x14d0 c0x0000 (---------------)  + I jewishart
	0x00399f83, // n0x14d1 c0x0000 (---------------)  + I jfk
	0x0033be4a, // n0x14d2 c0x0000 (---------------)  + I journalism
	0x00355487, // n0x14d3 c0x0000 (---------------)  + I judaica
	0x0027744b, // n0x14d4 c0x0000 (---------------)  + I judygarland
	0x0035138a, // n0x14d5 c0x0000 (---------------)  + I juedisches
	0x00242844, // n0x14d6 c0x0000 (---------------)  + I juif
	0x00353546, // n0x14d7 c0x0000 (---------------)  + I karate
	0x0027efc9, // n0x14d8 c0x0000 (---------------)  + I karikatur
	0x0028cd44, // n0x14d9 c0x0000 (---------------)  + I kids
	0x0020324a, // n0x14da c0x0000 (---------------)  + I koebenhavn
	0x0036bd45, // n0x14db c0x0000 (---------------)  + I koeln
	0x002b4d85, // n0x14dc c0x0000 (---------------)  + I kunst
	0x002b4d8d, // n0x14dd c0x0000 (---------------)  + I kunstsammlung
	0x002b50ce, // n0x14de c0x0000 (---------------)  + I kunstunddesign
	0x00315585, // n0x14df c0x0000 (---------------)  + I labor
	0x0038b2c6, // n0x14e0 c0x0000 (---------------)  + I labour
	0x00247107, // n0x14e1 c0x0000 (---------------)  + I lajolla
	0x002c990a, // n0x14e2 c0x0000 (---------------)  + I lancashire
	0x00323506, // n0x14e3 c0x0000 (---------------)  + I landes
	0x00359c44, // n0x14e4 c0x0000 (---------------)  + I lans
	0x00359f87, // n0x14e5 c0x0000 (---------------)  + I larsson
	0x002def0b, // n0x14e6 c0x0000 (---------------)  + I lewismiller
	0x0022e787, // n0x14e7 c0x0000 (---------------)  + I lincoln
	0x003a0f44, // n0x14e8 c0x0000 (---------------)  + I linz
	0x002414c6, // n0x14e9 c0x0000 (---------------)  + I living
	0x002414cd, // n0x14ea c0x0000 (---------------)  + I livinghistory
	0x003571cc, // n0x14eb c0x0000 (---------------)  + I localhistory
	0x00321906, // n0x14ec c0x0000 (---------------)  + I london
	0x0031f68a, // n0x14ed c0x0000 (---------------)  + I losangeles
	0x0022b6c6, // n0x14ee c0x0000 (---------------)  + I louvre
	0x002a7e88, // n0x14ef c0x0000 (---------------)  + I loyalist
	0x002e6147, // n0x14f0 c0x0000 (---------------)  + I lucerne
	0x0023ca4a, // n0x14f1 c0x0000 (---------------)  + I luxembourg
	0x0023dc86, // n0x14f2 c0x0000 (---------------)  + I luzern
	0x00212f43, // n0x14f3 c0x0000 (---------------)  + I mad
	0x00317146, // n0x14f4 c0x0000 (---------------)  + I madrid
	0x00200188, // n0x14f5 c0x0000 (---------------)  + I mallorca
	0x0029a80a, // n0x14f6 c0x0000 (---------------)  + I manchester
	0x00251d47, // n0x14f7 c0x0000 (---------------)  + I mansion
	0x00251d48, // n0x14f8 c0x0000 (---------------)  + I mansions
	0x0026a704, // n0x14f9 c0x0000 (---------------)  + I manx
	0x00278f07, // n0x14fa c0x0000 (---------------)  + I marburg
	0x00269708, // n0x14fb c0x0000 (---------------)  + I maritime
	0x002a3088, // n0x14fc c0x0000 (---------------)  + I maritimo
	0x0025cd88, // n0x14fd c0x0000 (---------------)  + I maryland
	0x002831ca, // n0x14fe c0x0000 (---------------)  + I marylhurst
	0x003025c5, // n0x14ff c0x0000 (---------------)  + I media
	0x0023ac87, // n0x1500 c0x0000 (---------------)  + I medical
	0x00256613, // n0x1501 c0x0000 (---------------)  + I medizinhistorisches
	0x00259146, // n0x1502 c0x0000 (---------------)  + I meeres
	0x0026cf88, // n0x1503 c0x0000 (---------------)  + I memorial
	0x002221c9, // n0x1504 c0x0000 (---------------)  + I mesaverde
	0x002165c8, // n0x1505 c0x0000 (---------------)  + I michigan
	0x0036e1cb, // n0x1506 c0x0000 (---------------)  + I midatlantic
	0x002b8348, // n0x1507 c0x0000 (---------------)  + I military
	0x00285244, // n0x1508 c0x0000 (---------------)  + I mill
	0x00321106, // n0x1509 c0x0000 (---------------)  + I miners
	0x003a5c46, // n0x150a c0x0000 (---------------)  + I mining
	0x003058c9, // n0x150b c0x0000 (---------------)  + I minnesota
	0x002bf847, // n0x150c c0x0000 (---------------)  + I missile
	0x0025a0c8, // n0x150d c0x0000 (---------------)  + I missoula
	0x003a1f86, // n0x150e c0x0000 (---------------)  + I modern
	0x0037a084, // n0x150f c0x0000 (---------------)  + I moma
	0x002c6d85, // n0x1510 c0x0000 (---------------)  + I money
	0x002c1888, // n0x1511 c0x0000 (---------------)  + I monmouth
	0x002c1fca, // n0x1512 c0x0000 (---------------)  + I monticello
	0x002c2288, // n0x1513 c0x0000 (---------------)  + I montreal
	0x002c74c6, // n0x1514 c0x0000 (---------------)  + I moscow
	0x0029af0a, // n0x1515 c0x0000 (---------------)  + I motorcycle
	0x002e6d88, // n0x1516 c0x0000 (---------------)  + I muenchen
	0x002ca188, // n0x1517 c0x0000 (---------------)  + I muenster
	0x002cb648, // n0x1518 c0x0000 (---------------)  + I mulhouse
	0x002cc046, // n0x1519 c0x0000 (---------------)  + I muncie
	0x002cfc06, // n0x151a c0x0000 (---------------)  + I museet
	0x002ea80c, // n0x151b c0x0000 (---------------)  + I museumcenter
	0x002d0110, // n0x151c c0x0000 (---------------)  + I museumvereniging
	0x00283a85, // n0x151d c0x0000 (---------------)  + I music
	0x00319548, // n0x151e c0x0000 (---------------)  + I national
	0x00319550, // n0x151f c0x0000 (---------------)  + I nationalfirearms
	0x0039f190, // n0x1520 c0x0000 (---------------)  + I nationalheritage
	0x0027284e, // n0x1521 c0x0000 (---------------)  + I nativeamerican
	0x002ea48e, // n0x1522 c0x0000 (---------------)  + I naturalhistory
	0x002ea494, // n0x1523 c0x0000 (---------------)  + I naturalhistorymuseum
	0x0031ad4f, // n0x1524 c0x0000 (---------------)  + I naturalsciences
	0x0031b106, // n0x1525 c0x0000 (---------------)  + I nature
	0x00325e11, // n0x1526 c0x0000 (---------------)  + I naturhistorisches
	0x00327393, // n0x1527 c0x0000 (---------------)  + I natuurwetenschappen
	0x00327808, // n0x1528 c0x0000 (---------------)  + I naumburg
	0x0030f105, // n0x1529 c0x0000 (---------------)  + I naval
	0x002d7f48, // n0x152a c0x0000 (---------------)  + I nebraska
	0x002de045, // n0x152b c0x0000 (---------------)  + I neues
	0x0022a34c, // n0x152c c0x0000 (---------------)  + I newhampshire
	0x002aeb89, // n0x152d c0x0000 (---------------)  + I newjersey
	0x00231bc9, // n0x152e c0x0000 (---------------)  + I newmexico
	0x002460c7, // n0x152f c0x0000 (---------------)  + I newport
	0x00221dc9, // n0x1530 c0x0000 (---------------)  + I newspaper
	0x002ed0c7, // n0x1531 c0x0000 (---------------)  + I newyork
	0x002a2646, // n0x1532 c0x0000 (---------------)  + I niepce
	0x0037bd47, // n0x1533 c0x0000 (---------------)  + I norfolk
	0x00239c45, // n0x1534 c0x0000 (---------------)  + I north
	0x002b5e83, // n0x1535 c0x0000 (---------------)  + I nrw
	0x002edec9, // n0x1536 c0x0000 (---------------)  + I nuernberg
	0x003518c9, // n0x1537 c0x0000 (---------------)  + I nuremberg
	0x0036ef83, // n0x1538 c0x0000 (---------------)  + I nyc
	0x00215844, // n0x1539 c0x0000 (---------------)  + I nyny
	0x0032154d, // n0x153a c0x0000 (---------------)  + I oceanographic
	0x00200b0f, // n0x153b c0x0000 (---------------)  + I oceanographique
	0x002fc505, // n0x153c c0x0000 (---------------)  + I omaha
	0x003175c6, // n0x153d c0x0000 (---------------)  + I online
	0x00200987, // n0x153e c0x0000 (---------------)  + I ontario
	0x00358c87, // n0x153f c0x0000 (---------------)  + I openair
	0x00287ec6, // n0x1540 c0x0000 (---------------)  + I oregon
	0x00287ecb, // n0x1541 c0x0000 (---------------)  + I oregontrail
	0x002a3605, // n0x1542 c0x0000 (---------------)  + I otago
	0x0039bec6, // n0x1543 c0x0000 (---------------)  + I oxford
	0x003909c7, // n0x1544 c0x0000 (---------------)  + I pacific
	0x0026fec9, // n0x1545 c0x0000 (---------------)  + I paderborn
	0x00322046, // n0x1546 c0x0000 (---------------)  + I palace
	0x0020ac45, // n0x1547 c0x0000 (---------------)  + I paleo
	0x0023a00b, // n0x1548 c0x0000 (---------------)  + I palmsprings
	0x0025b986, // n0x1549 c0x0000 (---------------)  + I panama
	0x00277905, // n0x154a c0x0000 (---------------)  + I paris
	0x002b5648, // n0x154b c0x0000 (---------------)  + I pasadena
	0x00375008, // n0x154c c0x0000 (---------------)  + I pharmacy
	0x002d30cc, // n0x154d c0x0000 (---------------)  + I philadelphia
	0x002d30d0, // n0x154e c0x0000 (---------------)  + I philadelphiaarea
	0x002d3789, // n0x154f c0x0000 (---------------)  + I philately
	0x002d3bc7, // n0x1550 c0x0000 (---------------)  + I phoenix
	0x002d404b, // n0x1551 c0x0000 (---------------)  + I photography
	0x002d6506, // n0x1552 c0x0000 (---------------)  + I pilots
	0x002d750a, // n0x1553 c0x0000 (---------------)  + I pittsburgh
	0x002d898b, // n0x1554 c0x0000 (---------------)  + I planetarium
	0x002d8d8a, // n0x1555 c0x0000 (---------------)  + I plantation
	0x002d9006, // n0x1556 c0x0000 (---------------)  + I plants
	0x002db005, // n0x1557 c0x0000 (---------------)  + I plaza
	0x002ec506, // n0x1558 c0x0000 (---------------)  + I portal
	0x00279488, // n0x1559 c0x0000 (---------------)  + I portland
	0x0024618a, // n0x155a c0x0000 (---------------)  + I portlligat
	0x0035fe1c, // n0x155b c0x0000 (---------------)  + I posts-and-telecommunications
	0x002e110c, // n0x155c c0x0000 (---------------)  + I preservation
	0x002e1408, // n0x155d c0x0000 (---------------)  + I presidio
	0x00247505, // n0x155e c0x0000 (---------------)  + I press
	0x002e3107, // n0x155f c0x0000 (---------------)  + I project
	0x0029f746, // n0x1560 c0x0000 (---------------)  + I public
	0x0038dec5, // n0x1561 c0x0000 (---------------)  + I pubol
	0x0021b906, // n0x1562 c0x0000 (---------------)  + I quebec
	0x00288088, // n0x1563 c0x0000 (---------------)  + I railroad
	0x002b3287, // n0x1564 c0x0000 (---------------)  + I railway
	0x0029fa08, // n0x1565 c0x0000 (---------------)  + I research
	0x002a6d4a, // n0x1566 c0x0000 (---------------)  + I resistance
	0x0030864c, // n0x1567 c0x0000 (---------------)  + I riodejaneiro
	0x003088c9, // n0x1568 c0x0000 (---------------)  + I rochester
	0x0038e207, // n0x1569 c0x0000 (---------------)  + I rockart
	0x00254584, // n0x156a c0x0000 (---------------)  + I roma
	0x00252f86, // n0x156b c0x0000 (---------------)  + I russia
	0x0036d48a, // n0x156c c0x0000 (---------------)  + I saintlouis
	0x00283645, // n0x156d c0x0000 (---------------)  + I salem
	0x0034504c, // n0x156e c0x0000 (---------------)  + I salvadordali
	0x00345cc8, // n0x156f c0x0000 (---------------)  + I salzburg
	0x0034a848, // n0x1570 c0x0000 (---------------)  + I sandiego
	0x002004cc, // n0x1571 c0x0000 (---------------)  + I sanfrancisco
	0x00210c8c, // n0x1572 c0x0000 (---------------)  + I santabarbara
	0x00211189, // n0x1573 c0x0000 (---------------)  + I santacruz
	0x002113c7, // n0x1574 c0x0000 (---------------)  + I santafe
	0x0033d48c, // n0x1575 c0x0000 (---------------)  + I saskatchewan
	0x003897c4, // n0x1576 c0x0000 (---------------)  + I satx
	0x00232b4a, // n0x1577 c0x0000 (---------------)  + I savannahga
	0x0028d04c, // n0x1578 c0x0000 (---------------)  + I schlesisches
	0x0027104b, // n0x1579 c0x0000 (---------------)  + I schoenbrunn
	0x0023758b, // n0x157a c0x0000 (---------------)  + I schokoladen
	0x0023d0c6, // n0x157b c0x0000 (---------------)  + I school
	0x00243147, // n0x157c c0x0000 (---------------)  + I schweiz
	0x002358c7, // n0x157d c0x0000 (---------------)  + I science
	0x002358cf, // n0x157e c0x0000 (---------------)  + I science-fiction
	0x002f1b51, // n0x157f c0x0000 (---------------)  + I scienceandhistory
	0x0039e252, // n0x1580 c0x0000 (---------------)  + I scienceandindustry
	0x0024410d, // n0x1581 c0x0000 (---------------)  + I sciencecenter
	0x0024410e, // n0x1582 c0x0000 (---------------)  + I sciencecenters
	0x0024444e, // n0x1583 c0x0000 (---------------)  + I sciencehistory
	0x0031af08, // n0x1584 c0x0000 (---------------)  + I sciences
	0x0031af12, // n0x1585 c0x0000 (---------------)  + I sciencesnaturelles
	0x00200708, // n0x1586 c0x0000 (---------------)  + I scotland
	0x002fa9c7, // n0x1587 c0x0000 (---------------)  + I seaport
	0x0024f98a, // n0x1588 c0x0000 (---------------)  + I settlement
	0x00219c08, // n0x1589 c0x0000 (---------------)  + I settlers
	0x0025fd45, // n0x158a c0x0000 (---------------)  + I shell
	0x0035cc4a, // n0x158b c0x0000 (---------------)  + I sherbrooke
	0x0021d987, // n0x158c c0x0000 (---------------)  + I sibenik
	0x00341f84, // n0x158d c0x0000 (---------------)  + I silk
	0x00209743, // n0x158e c0x0000 (---------------)  + I ski
	0x00296cc5, // n0x158f c0x0000 (---------------)  + I skole
	0x002fbb47, // n0x1590 c0x0000 (---------------)  + I society
	0x002f9607, // n0x1591 c0x0000 (---------------)  + I sologne
	0x002b46ce, // n0x1592 c0x0000 (---------------)  + I soundandvision
	0x0032bd4d, // n0x1593 c0x0000 (---------------)  + I southcarolina
	0x0032e849, // n0x1594 c0x0000 (---------------)  + I southwest
	0x0020bb45, // n0x1595 c0x0000 (---------------)  + I space
	0x003347c3, // n0x1596 c0x0000 (---------------)  + I spy
	0x0027a346, // n0x1597 c0x0000 (---------------)  + I square
	0x003643c5, // n0x1598 c0x0000 (---------------)  + I stadt
	0x0027b148, // n0x1599 c0x0000 (---------------)  + I stalbans
	0x00323f89, // n0x159a c0x0000 (---------------)  + I starnberg
	0x0020f205, // n0x159b c0x0000 (---------------)  + I state
	0x0033678f, // n0x159c c0x0000 (---------------)  + I stateofdelaware
	0x00254e87, // n0x159d c0x0000 (---------------)  + I station
	0x003674c5, // n0x159e c0x0000 (---------------)  + I steam
	0x00227c0a, // n0x159f c0x0000 (---------------)  + I steiermark
	0x00303b86, // n0x15a0 c0x0000 (---------------)  + I stjohn
	0x002a8009, // n0x15a1 c0x0000 (---------------)  + I stockholm
	0x002e71cc, // n0x15a2 c0x0000 (---------------)  + I stpetersburg
	0x002e8989, // n0x15a3 c0x0000 (---------------)  + I stuttgart
	0x00206706, // n0x15a4 c0x0000 (---------------)  + I suisse
	0x0029148c, // n0x15a5 c0x0000 (---------------)  + I surgeonshall
	0x002e91c6, // n0x15a6 c0x0000 (---------------)  + I surrey
	0x002f0688, // n0x15a7 c0x0000 (---------------)  + I svizzera
	0x002f0886, // n0x15a8 c0x0000 (---------------)  + I sweden
	0x00329bc6, // n0x15a9 c0x0000 (---------------)  + I sydney
	0x002294c4, // n0x15aa c0x0000 (---------------)  + I tank
	0x0025d103, // n0x15ab c0x0000 (---------------)  + I tcm
	0x002d608a, // n0x15ac c0x0000 (---------------)  + I technology
	0x0031d2d1, // n0x15ad c0x0000 (---------------)  + I telekommunikation
	0x002b5c4a, // n0x15ae c0x0000 (---------------)  + I television
	0x0034d1c5, // n0x15af c0x0000 (---------------)  + I texas
	0x003844c7, // n0x15b0 c0x0000 (---------------)  + I textile
	0x002573c7, // n0x15b1 c0x0000 (---------------)  + I theater
	0x00269804, // n0x15b2 c0x0000 (---------------)  + I time
	0x0026980b, // n0x15b3 c0x0000 (---------------)  + I timekeeping
	0x00208088, // n0x15b4 c0x0000 (---------------)  + I topology
	0x002b1946, // n0x15b5 c0x0000 (---------------)  + I torino
	0x00311cc5, // n0x15b6 c0x0000 (---------------)  + I touch
	0x002dc244, // n0x15b7 c0x0000 (---------------)  + I town
	0x00294809, // n0x15b8 c0x0000 (---------------)  + I transport
	0x00355f84, // n0x15b9 c0x0000 (---------------)  + I tree
	0x00359147, // n0x15ba c0x0000 (---------------)  + I trolley
	0x00329245, // n0x15bb c0x0000 (---------------)  + I trust
	0x00329247, // n0x15bc c0x0000 (---------------)  + I trustee
	0x0030fb05, // n0x15bd c0x0000 (---------------)  + I uhren
	0x00253643, // n0x15be c0x0000 (---------------)  + I ulm
	0x002fa888, // n0x15bf c0x0000 (---------------)  + I undersea
	0x00320a0a, // n0x15c0 c0x0000 (---------------)  + I university
	0x0022b983, // n0x15c1 c0x0000 (---------------)  + I usa
	0x0022b98a, // n0x15c2 c0x0000 (---------------)  + I usantiques
	0x0028db46, // n0x15c3 c0x0000 (---------------)  + I usarts
	0x0033650f, // n0x15c4 c0x0000 (---------------)  + I uscountryestate
	0x00337d89, // n0x15c5 c0x0000 (---------------)  + I usculture
	0x0025f990, // n0x15c6 c0x0000 (---------------)  + I usdecorativearts
	0x0026d6c8, // n0x15c7 c0x0000 (---------------)  + I usgarden
	0x002c7d49, // n0x15c8 c0x0000 (---------------)  + I ushistory
	0x0029ca87, // n0x15c9 c0x0000 (---------------)  + I ushuaia
	0x0024144f, // n0x15ca c0x0000 (---------------)  + I uslivinghistory
	0x002e84c4, // n0x15cb c0x0000 (---------------)  + I utah
	0x0033d844, // n0x15cc c0x0000 (---------------)  + I uvic
	0x00217106, // n0x15cd c0x0000 (---------------)  + I valley
	0x00236b46, // n0x15ce c0x0000 (---------------)  + I vantaa
	0x0031504a, // n0x15cf c0x0000 (---------------)  + I versailles
	0x00311a06, // n0x15d0 c0x0000 (---------------)  + I viking
	0x002f8f47, // n0x15d1 c0x0000 (---------------)  + I village
	0x002f7e88, // n0x15d2 c0x0000 (---------------)  + I virginia
	0x002f8087, // n0x15d3 c0x0000 (---------------)  + I virtual
	0x002f8247, // n0x15d4 c0x0000 (---------------)  + I virtuel
	0x0034710a, // n0x15d5 c0x0000 (---------------)  + I vlaanderen
	0x002fa6cb, // n0x15d6 c0x0000 (---------------)  + I volkenkunde
	0x00320685, // n0x15d7 c0x0000 (---------------)  + I wales
	0x0039de88, // n0x15d8 c0x0000 (---------------)  + I wallonie
	0x00203903, // n0x15d9 c0x0000 (---------------)  + I war
	0x0023efcc, // n0x15da c0x0000 (---------------)  + I washingtondc
	0x00376c4f, // n0x15db c0x0000 (---------------)  + I watch-and-clock
	0x002aca4d, // n0x15dc c0x0000 (---------------)  + I watchandclock
	0x0023d987, // n0x15dd c0x0000 (---------------)  + I western
	0x0032e989, // n0x15de c0x0000 (---------------)  + I westfalen
	0x002b5f07, // n0x15df c0x0000 (---------------)  + I whaling
	0x00253bc8, // n0x15e0 c0x0000 (---------------)  + I wildlife
	0x0023264c, // n0x15e1 c0x0000 (---------------)  + I williamsburg
	0x00285148, // n0x15e2 c0x0000 (---------------)  + I windmill
	0x00351f08, // n0x15e3 c0x0000 (---------------)  + I workshop
	0x0030cb8e, // n0x15e4 c0x0000 (---------------)  + I xn--9dbhblg6di
	0x0031d714, // n0x15e5 c0x0000 (---------------)  + I xn--comunicaes-v6a2o
	0x0031dc24, // n0x15e6 c0x0000 (---------------)  + I xn--correios-e-telecomunicaes-ghc29a
	0x0033b8ca, // n0x15e7 c0x0000 (---------------)  + I xn--h1aegh
	0x0035a14b, // n0x15e8 c0x0000 (---------------)  + I xn--lns-qla
	0x002ed184, // n0x15e9 c0x0000 (---------------)  + I york
	0x002ed189, // n0x15ea c0x0000 (---------------)  + I yorkshire
	0x002aab48, // n0x15eb c0x0000 (---------------)  + I yosemite
	0x0024b0c5, // n0x15ec c0x0000 (---------------)  + I youth
	0x002ed80a, // n0x15ed c0x0000 (---------------)  + I zoological
	0x0027a507, // n0x15ee c0x0000 (---------------)  + I zoology
	0x002389c4, // n0x15ef c0x0000 (---------------)  + I aero
	0x00330b83, // n0x15f0 c0x0000 (---------------)  + I biz
	0x00233503, // n0x15f1 c0x0000 (---------------)  + I com
	0x0023d684, // n0x15f2 c0x0000 (---------------)  + I coop
	0x0023a783, // n0x15f3 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x15f4 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x15f5 c0x0000 (---------------)  + I info
	0x00201603, // n0x15f6 c0x0000 (---------------)  + I int
	0x00209003, // n0x15f7 c0x0000 (---------------)  + I mil
	0x002d0106, // n0x15f8 c0x0000 (---------------)  + I museum
	0x00205284, // n0x15f9 c0x0000 (---------------)  + I name
	0x0021fe03, // n0x15fa c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x15fb c0x0000 (---------------)  + I org
	0x00220e43, // n0x15fc c0x0000 (---------------)  + I pro
	0x00201542, // n0x15fd c0x0000 (---------------)  + I ac
	0x00330b83, // n0x15fe c0x0000 (---------------)  + I biz
	0x00200742, // n0x15ff c0x0000 (---------------)  + I co
	0x00233503, // n0x1600 c0x0000 (---------------)  + I com
	0x0023d684, // n0x1601 c0x0000 (---------------)  + I coop
	0x0023a783, // n0x1602 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1603 c0x0000 (---------------)  + I gov
	0x00201603, // n0x1604 c0x0000 (---------------)  + I int
	0x002d0106, // n0x1605 c0x0000 (---------------)  + I museum
	0x0021fe03, // n0x1606 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1607 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x1608 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1609 c0x0000 (---------------)  + I com
	0x0023a783, // n0x160a c0x0000 (---------------)  + I edu
	0x00213183, // n0x160b c0x0000 (---------------)  + I gob
	0x0021fe03, // n0x160c c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x160d c0x0000 (---------------)  + I org
	0x000ffa08, // n0x160e c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x160f c0x0000 (---------------)  + I com
	0x0023a783, // n0x1610 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1611 c0x0000 (---------------)  + I gov
	0x00209003, // n0x1612 c0x0000 (---------------)  + I mil
	0x00205284, // n0x1613 c0x0000 (---------------)  + I name
	0x0021fe03, // n0x1614 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1615 c0x0000 (---------------)  + I org
	0x0062f7c8, // n0x1616 c0x0001 (---------------)  ! I teledata
	0x00200302, // n0x1617 c0x0000 (---------------)  + I ca
	0x0022e182, // n0x1618 c0x0000 (---------------)  + I cc
	0x00200742, // n0x1619 c0x0000 (---------------)  + I co
	0x00233503, // n0x161a c0x0000 (---------------)  + I com
	0x0022bf42, // n0x161b c0x0000 (---------------)  + I dr
	0x002013c2, // n0x161c c0x0000 (---------------)  + I in
	0x003a1244, // n0x161d c0x0000 (---------------)  + I info
	0x00207104, // n0x161e c0x0000 (---------------)  + I mobi
	0x0021bb02, // n0x161f c0x0000 (---------------)  + I mx
	0x00205284, // n0x1620 c0x0000 (---------------)  + I name
	0x00200282, // n0x1621 c0x0000 (---------------)  + I or
	0x0022d1c3, // n0x1622 c0x0000 (---------------)  + I org
	0x00220e43, // n0x1623 c0x0000 (---------------)  + I pro
	0x0023d0c6, // n0x1624 c0x0000 (---------------)  + I school
	0x00224e42, // n0x1625 c0x0000 (---------------)  + I tv
	0x00202382, // n0x1626 c0x0000 (---------------)  + I us
	0x0020b942, // n0x1627 c0x0000 (---------------)  + I ws
	0x38e22103, // n0x1628 c0x00e3 (n0x162a-n0x162b)  o I her
	0x39218ac3, // n0x1629 c0x00e4 (n0x162b-n0x162c)  o I his
	0x00057c46, // n0x162a c0x0000 (---------------)  +   forgot
	0x00057c46, // n0x162b c0x0000 (---------------)  +   forgot
	0x002d4884, // n0x162c c0x0000 (---------------)  + I asso
	0x00116c0c, // n0x162d c0x0000 (---------------)  +   at-band-camp
	0x0001be0c, // n0x162e c0x0000 (---------------)  +   azure-mobile
	0x00080ecd, // n0x162f c0x0000 (---------------)  +   azurewebsites
	0x000fb147, // n0x1630 c0x0000 (---------------)  +   blogdns
	0x00020208, // n0x1631 c0x0000 (---------------)  +   broke-it
	0x0019898a, // n0x1632 c0x0000 (---------------)  +   buyshouses
	0x39e3e2c5, // n0x1633 c0x00e7 (n0x1663-n0x1664)  o I cdn77
	0x0003e2c9, // n0x1634 c0x0000 (---------------)  +   cdn77-ssl
	0x00009188, // n0x1635 c0x0000 (---------------)  +   cloudapp
	0x0019d4ca, // n0x1636 c0x0000 (---------------)  +   cloudfront
	0x0003118e, // n0x1637 c0x0000 (---------------)  +   cloudfunctions
	0x0014c048, // n0x1638 c0x0000 (---------------)  +   dnsalias
	0x0007c9c7, // n0x1639 c0x0000 (---------------)  +   dnsdojo
	0x00160607, // n0x163a c0x0000 (---------------)  +   does-it
	0x0016a009, // n0x163b c0x0000 (---------------)  +   dontexist
	0x0008cdc7, // n0x163c c0x0000 (---------------)  +   dsmynas
	0x00197b48, // n0x163d c0x0000 (---------------)  +   dynalias
	0x000e9d09, // n0x163e c0x0000 (---------------)  +   dynathome
	0x001a46c5, // n0x163f c0x0000 (---------------)  +   dynv6
	0x000a950d, // n0x1640 c0x0000 (---------------)  +   endofinternet
	0x00008f88, // n0x1641 c0x0000 (---------------)  +   familyds
	0x3a24c206, // n0x1642 c0x00e8 (n0x1664-n0x1666)  o I fastly
	0x00064447, // n0x1643 c0x0000 (---------------)  +   from-az
	0x00065a47, // n0x1644 c0x0000 (---------------)  +   from-co
	0x0006a1c7, // n0x1645 c0x0000 (---------------)  +   from-la
	0x0006f3c7, // n0x1646 c0x0000 (---------------)  +   from-ny
	0x0000d202, // n0x1647 c0x0000 (---------------)  +   gb
	0x00157907, // n0x1648 c0x0000 (---------------)  +   gets-it
	0x00064a8c, // n0x1649 c0x0000 (---------------)  +   ham-radio-op
	0x00146347, // n0x164a c0x0000 (---------------)  +   homeftp
	0x000a51c6, // n0x164b c0x0000 (---------------)  +   homeip
	0x000a59c9, // n0x164c c0x0000 (---------------)  +   homelinux
	0x000a6fc8, // n0x164d c0x0000 (---------------)  +   homeunix
	0x000195c2, // n0x164e c0x0000 (---------------)  +   hu
	0x000013c2, // n0x164f c0x0000 (---------------)  +   in
	0x00007b0b, // n0x1650 c0x0000 (---------------)  +   in-the-band
	0x00012789, // n0x1651 c0x0000 (---------------)  +   is-a-chef
	0x0004e989, // n0x1652 c0x0000 (---------------)  +   is-a-geek
	0x0008e588, // n0x1653 c0x0000 (---------------)  +   isa-geek
	0x000ae3c2, // n0x1654 c0x0000 (---------------)  +   jp
	0x00150c09, // n0x1655 c0x0000 (---------------)  +   kicks-ass
	0x0002168d, // n0x1656 c0x0000 (---------------)  +   office-on-the
	0x000dcd47, // n0x1657 c0x0000 (---------------)  +   podzone
	0x000ecb08, // n0x1658 c0x0000 (---------------)  +   rackmaze
	0x001376cd, // n0x1659 c0x0000 (---------------)  +   scrapper-site
	0x000046c2, // n0x165a c0x0000 (---------------)  +   se
	0x0006ba86, // n0x165b c0x0000 (---------------)  +   selfip
	0x00090208, // n0x165c c0x0000 (---------------)  +   sells-it
	0x000cb7c8, // n0x165d c0x0000 (---------------)  +   servebbs
	0x000895c8, // n0x165e c0x0000 (---------------)  +   serveftp
	0x00054088, // n0x165f c0x0000 (---------------)  +   thruhere
	0x00000f82, // n0x1660 c0x0000 (---------------)  +   uk
	0x000eadc6, // n0x1661 c0x0000 (---------------)  +   webhop
	0x00005f82, // n0x1662 c0x0000 (---------------)  +   za
	0x000002c1, // n0x1663 c0x0000 (---------------)  +   r
	0x3a6e2044, // n0x1664 c0x00e9 (n0x1666-n0x1668)  o I prod
	0x3aa3e443, // n0x1665 c0x00ea (n0x1668-n0x166b)  o I ssl
	0x00000101, // n0x1666 c0x0000 (---------------)  +   a
	0x0000d846, // n0x1667 c0x0000 (---------------)  +   global
	0x00000101, // n0x1668 c0x0000 (---------------)  +   a
	0x00000001, // n0x1669 c0x0000 (---------------)  +   b
	0x0000d846, // n0x166a c0x0000 (---------------)  +   global
	0x0024bf84, // n0x166b c0x0000 (---------------)  + I arts
	0x00233503, // n0x166c c0x0000 (---------------)  + I com
	0x0024d9c4, // n0x166d c0x0000 (---------------)  + I firm
	0x003a1244, // n0x166e c0x0000 (---------------)  + I info
	0x0021fe03, // n0x166f c0x0000 (---------------)  + I net
	0x00222085, // n0x1670 c0x0000 (---------------)  + I other
	0x00220f03, // n0x1671 c0x0000 (---------------)  + I per
	0x0022a5c3, // n0x1672 c0x0000 (---------------)  + I rec
	0x00391185, // n0x1673 c0x0000 (---------------)  + I store
	0x00221a03, // n0x1674 c0x0000 (---------------)  + I web
	0x3b633503, // n0x1675 c0x00ed (n0x167f-n0x1680)  + I com
	0x0023a783, // n0x1676 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1677 c0x0000 (---------------)  + I gov
	0x00200041, // n0x1678 c0x0000 (---------------)  + I i
	0x00209003, // n0x1679 c0x0000 (---------------)  + I mil
	0x00207104, // n0x167a c0x0000 (---------------)  + I mobi
	0x00205284, // n0x167b c0x0000 (---------------)  + I name
	0x0021fe03, // n0x167c c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x167d c0x0000 (---------------)  + I org
	0x00217443, // n0x167e c0x0000 (---------------)  + I sch
	0x000ffa08, // n0x167f c0x0000 (---------------)  +   blogspot
	0x00201542, // n0x1680 c0x0000 (---------------)  + I ac
	0x00330b83, // n0x1681 c0x0000 (---------------)  + I biz
	0x00200742, // n0x1682 c0x0000 (---------------)  + I co
	0x00233503, // n0x1683 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1684 c0x0000 (---------------)  + I edu
	0x00213183, // n0x1685 c0x0000 (---------------)  + I gob
	0x002013c2, // n0x1686 c0x0000 (---------------)  + I in
	0x003a1244, // n0x1687 c0x0000 (---------------)  + I info
	0x00201603, // n0x1688 c0x0000 (---------------)  + I int
	0x00209003, // n0x1689 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x168a c0x0000 (---------------)  + I net
	0x00201483, // n0x168b c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x168c c0x0000 (---------------)  + I org
	0x00221a03, // n0x168d c0x0000 (---------------)  + I web
	0x000ffa08, // n0x168e c0x0000 (---------------)  +   blogspot
	0x00365782, // n0x168f c0x0000 (---------------)  + I bv
	0x00000742, // n0x1690 c0x0000 (---------------)  +   co
	0x3c622f02, // n0x1691 c0x00f1 (n0x1967-n0x1968)  + I aa
	0x00355648, // n0x1692 c0x0000 (---------------)  + I aarborte
	0x00223386, // n0x1693 c0x0000 (---------------)  + I aejrie
	0x002bb486, // n0x1694 c0x0000 (---------------)  + I afjord
	0x00222d07, // n0x1695 c0x0000 (---------------)  + I agdenes
	0x3ca04f02, // n0x1696 c0x00f2 (n0x1968-n0x1969)  + I ah
	0x3cf7c888, // n0x1697 c0x00f3 (n0x1969-n0x196a)  o I akershus
	0x00354a4a, // n0x1698 c0x0000 (---------------)  + I aknoluokta
	0x00263ec8, // n0x1699 c0x0000 (---------------)  + I akrehamn
	0x002001c2, // n0x169a c0x0000 (---------------)  + I al
	0x003552c9, // n0x169b c0x0000 (---------------)  + I alaheadju
	0x003206c7, // n0x169c c0x0000 (---------------)  + I alesund
	0x00219046, // n0x169d c0x0000 (---------------)  + I algard
	0x00204e09, // n0x169e c0x0000 (---------------)  + I alstahaug
	0x0023adc4, // n0x169f c0x0000 (---------------)  + I alta
	0x002bbf06, // n0x16a0 c0x0000 (---------------)  + I alvdal
	0x002bb884, // n0x16a1 c0x0000 (---------------)  + I amli
	0x00278604, // n0x16a2 c0x0000 (---------------)  + I amot
	0x00259c09, // n0x16a3 c0x0000 (---------------)  + I andasuolo
	0x0022c086, // n0x16a4 c0x0000 (---------------)  + I andebu
	0x00259645, // n0x16a5 c0x0000 (---------------)  + I andoy
	0x00267dc5, // n0x16a6 c0x0000 (---------------)  + I ardal
	0x00234b07, // n0x16a7 c0x0000 (---------------)  + I aremark
	0x002b87c7, // n0x16a8 c0x0000 (---------------)  + I arendal
	0x0032fec4, // n0x16a9 c0x0000 (---------------)  + I arna
	0x00222f46, // n0x16aa c0x0000 (---------------)  + I aseral
	0x002e2b85, // n0x16ab c0x0000 (---------------)  + I asker
	0x00230345, // n0x16ac c0x0000 (---------------)  + I askim
	0x002f58c5, // n0x16ad c0x0000 (---------------)  + I askoy
	0x00389107, // n0x16ae c0x0000 (---------------)  + I askvoll
	0x00331105, // n0x16af c0x0000 (---------------)  + I asnes
	0x00309f89, // n0x16b0 c0x0000 (---------------)  + I audnedaln
	0x00255485, // n0x16b1 c0x0000 (---------------)  + I aukra
	0x002fadc4, // n0x16b2 c0x0000 (---------------)  + I aure
	0x00323447, // n0x16b3 c0x0000 (---------------)  + I aurland
	0x0025de0e, // n0x16b4 c0x0000 (---------------)  + I aurskog-holand
	0x00272489, // n0x16b5 c0x0000 (---------------)  + I austevoll
	0x0030f789, // n0x16b6 c0x0000 (---------------)  + I austrheim
	0x00326bc6, // n0x16b7 c0x0000 (---------------)  + I averoy
	0x002f2388, // n0x16b8 c0x0000 (---------------)  + I badaddja
	0x002ade0b, // n0x16b9 c0x0000 (---------------)  + I bahcavuotna
	0x002d13cc, // n0x16ba c0x0000 (---------------)  + I bahccavuotna
	0x0026a446, // n0x16bb c0x0000 (---------------)  + I baidar
	0x00372147, // n0x16bc c0x0000 (---------------)  + I bajddar
	0x0025ef05, // n0x16bd c0x0000 (---------------)  + I balat
	0x00228a8a, // n0x16be c0x0000 (---------------)  + I balestrand
	0x00306f89, // n0x16bf c0x0000 (---------------)  + I ballangen
	0x00254b89, // n0x16c0 c0x0000 (---------------)  + I balsfjord
	0x00271906, // n0x16c1 c0x0000 (---------------)  + I bamble
	0x002ef785, // n0x16c2 c0x0000 (---------------)  + I bardu
	0x0027f705, // n0x16c3 c0x0000 (---------------)  + I barum
	0x00354549, // n0x16c4 c0x0000 (---------------)  + I batsfjord
	0x002f5a4b, // n0x16c5 c0x0000 (---------------)  + I bearalvahki
	0x0027c686, // n0x16c6 c0x0000 (---------------)  + I beardu
	0x0032e046, // n0x16c7 c0x0000 (---------------)  + I beiarn
	0x0020d144, // n0x16c8 c0x0000 (---------------)  + I berg
	0x0028b146, // n0x16c9 c0x0000 (---------------)  + I bergen
	0x003223c8, // n0x16ca c0x0000 (---------------)  + I berlevag
	0x00200006, // n0x16cb c0x0000 (---------------)  + I bievat
	0x00398d86, // n0x16cc c0x0000 (---------------)  + I bindal
	0x002054c8, // n0x16cd c0x0000 (---------------)  + I birkenes
	0x00206507, // n0x16ce c0x0000 (---------------)  + I bjarkoy
	0x00206ec9, // n0x16cf c0x0000 (---------------)  + I bjerkreim
	0x0020c285, // n0x16d0 c0x0000 (---------------)  + I bjugn
	0x000ffa08, // n0x16d1 c0x0000 (---------------)  +   blogspot
	0x00213204, // n0x16d2 c0x0000 (---------------)  + I bodo
	0x003a4004, // n0x16d3 c0x0000 (---------------)  + I bokn
	0x00210ac5, // n0x16d4 c0x0000 (---------------)  + I bomlo
	0x0038c589, // n0x16d5 c0x0000 (---------------)  + I bremanger
	0x00221247, // n0x16d6 c0x0000 (---------------)  + I bronnoy
	0x0022124b, // n0x16d7 c0x0000 (---------------)  + I bronnoysund
	0x0022260a, // n0x16d8 c0x0000 (---------------)  + I brumunddal
	0x00228785, // n0x16d9 c0x0000 (---------------)  + I bryne
	0x3d208642, // n0x16da c0x00f4 (n0x196a-n0x196b)  + I bu
	0x00351247, // n0x16db c0x0000 (---------------)  + I budejju
	0x3d62a108, // n0x16dc c0x00f5 (n0x196b-n0x196c)  o I buskerud
	0x002b8007, // n0x16dd c0x0000 (---------------)  + I bygland
	0x0022c3c5, // n0x16de c0x0000 (---------------)  + I bykle
	0x00356fca, // n0x16df c0x0000 (---------------)  + I cahcesuolo
	0x00000742, // n0x16e0 c0x0000 (---------------)  +   co
	0x002b70cb, // n0x16e1 c0x0000 (---------------)  + I davvenjarga
	0x0021490a, // n0x16e2 c0x0000 (---------------)  + I davvesiida
	0x0039c006, // n0x16e3 c0x0000 (---------------)  + I deatnu
	0x00274143, // n0x16e4 c0x0000 (---------------)  + I dep
	0x002381cd, // n0x16e5 c0x0000 (---------------)  + I dielddanuorri
	0x00271f0c, // n0x16e6 c0x0000 (---------------)  + I divtasvuodna
	0x003079cd, // n0x16e7 c0x0000 (---------------)  + I divttasvuotna
	0x00365c05, // n0x16e8 c0x0000 (---------------)  + I donna
	0x00243885, // n0x16e9 c0x0000 (---------------)  + I dovre
	0x002edd47, // n0x16ea c0x0000 (---------------)  + I drammen
	0x003458c9, // n0x16eb c0x0000 (---------------)  + I drangedal
	0x00354946, // n0x16ec c0x0000 (---------------)  + I drobak
	0x00311885, // n0x16ed c0x0000 (---------------)  + I dyroy
	0x0022e2c8, // n0x16ee c0x0000 (---------------)  + I egersund
	0x0028b043, // n0x16ef c0x0000 (---------------)  + I eid
	0x003116c8, // n0x16f0 c0x0000 (---------------)  + I eidfjord
	0x0028b048, // n0x16f1 c0x0000 (---------------)  + I eidsberg
	0x002bce07, // n0x16f2 c0x0000 (---------------)  + I eidskog
	0x002d8248, // n0x16f3 c0x0000 (---------------)  + I eidsvoll
	0x003a6609, // n0x16f4 c0x0000 (---------------)  + I eigersund
	0x0023c547, // n0x16f5 c0x0000 (---------------)  + I elverum
	0x00209807, // n0x16f6 c0x0000 (---------------)  + I enebakk
	0x00279a48, // n0x16f7 c0x0000 (---------------)  + I engerdal
	0x002fecc4, // n0x16f8 c0x0000 (---------------)  + I etne
	0x002fecc7, // n0x16f9 c0x0000 (---------------)  + I etnedal
	0x00251f48, // n0x16fa c0x0000 (---------------)  + I evenassi
	0x00202b46, // n0x16fb c0x0000 (---------------)  + I evenes
	0x003a03cf, // n0x16fc c0x0000 (---------------)  + I evje-og-hornnes
	0x00212987, // n0x16fd c0x0000 (---------------)  + I farsund
	0x0024cc06, // n0x16fe c0x0000 (---------------)  + I fauske
	0x002d77c5, // n0x16ff c0x0000 (---------------)  + I fedje
	0x002159c3, // n0x1700 c0x0000 (---------------)  + I fet
	0x0034b7c7, // n0x1701 c0x0000 (---------------)  + I fetsund
	0x0023f343, // n0x1702 c0x0000 (---------------)  + I fhs
	0x0024c546, // n0x1703 c0x0000 (---------------)  + I finnoy
	0x0024f086, // n0x1704 c0x0000 (---------------)  + I fitjar
	0x00250506, // n0x1705 c0x0000 (---------------)  + I fjaler
	0x0028f845, // n0x1706 c0x0000 (---------------)  + I fjell
	0x00267683, // n0x1707 c0x0000 (---------------)  + I fla
	0x00380648, // n0x1708 c0x0000 (---------------)  + I flakstad
	0x0036ce89, // n0x1709 c0x0000 (---------------)  + I flatanger
	0x00364c8b, // n0x170a c0x0000 (---------------)  + I flekkefjord
	0x00377308, // n0x170b c0x0000 (---------------)  + I flesberg
	0x00252605, // n0x170c c0x0000 (---------------)  + I flora
	0x00253105, // n0x170d c0x0000 (---------------)  + I floro
	0x3da42902, // n0x170e c0x00f6 (n0x196c-n0x196d)  + I fm
	0x0037be09, // n0x170f c0x0000 (---------------)  + I folkebibl
	0x002558c7, // n0x1710 c0x0000 (---------------)  + I folldal
	0x0039bf45, // n0x1711 c0x0000 (---------------)  + I forde
	0x00259b07, // n0x1712 c0x0000 (---------------)  + I forsand
	0x0025b746, // n0x1713 c0x0000 (---------------)  + I fosnes
	0x0035dfc5, // n0x1714 c0x0000 (---------------)  + I frana
	0x0036420b, // n0x1715 c0x0000 (---------------)  + I fredrikstad
	0x0025c484, // n0x1716 c0x0000 (---------------)  + I frei
	0x00263a85, // n0x1717 c0x0000 (---------------)  + I frogn
	0x00263bc7, // n0x1718 c0x0000 (---------------)  + I froland
	0x00276a06, // n0x1719 c0x0000 (---------------)  + I frosta
	0x00276e45, // n0x171a c0x0000 (---------------)  + I froya
	0x00283e87, // n0x171b c0x0000 (---------------)  + I fuoisku
	0x00284ec7, // n0x171c c0x0000 (---------------)  + I fuossko
	0x0028db04, // n0x171d c0x0000 (---------------)  + I fusa
	0x00288cca, // n0x171e c0x0000 (---------------)  + I fylkesbibl
	0x00289188, // n0x171f c0x0000 (---------------)  + I fyresdal
	0x002cdcc9, // n0x1720 c0x0000 (---------------)  + I gaivuotna
	0x0021dd45, // n0x1721 c0x0000 (---------------)  + I galsa
	0x002b7306, // n0x1722 c0x0000 (---------------)  + I gamvik
	0x0032258a, // n0x1723 c0x0000 (---------------)  + I gangaviika
	0x00267cc6, // n0x1724 c0x0000 (---------------)  + I gaular
	0x002b6187, // n0x1725 c0x0000 (---------------)  + I gausdal
	0x002cd98d, // n0x1726 c0x0000 (---------------)  + I giehtavuoatna
	0x00226cc9, // n0x1727 c0x0000 (---------------)  + I gildeskal
	0x00328b05, // n0x1728 c0x0000 (---------------)  + I giske
	0x00310047, // n0x1729 c0x0000 (---------------)  + I gjemnes
	0x003279c8, // n0x172a c0x0000 (---------------)  + I gjerdrum
	0x0032f588, // n0x172b c0x0000 (---------------)  + I gjerstad
	0x00249607, // n0x172c c0x0000 (---------------)  + I gjesdal
	0x00249e46, // n0x172d c0x0000 (---------------)  + I gjovik
	0x00212b87, // n0x172e c0x0000 (---------------)  + I gloppen
	0x0024dbc3, // n0x172f c0x0000 (---------------)  + I gol
	0x00334544, // n0x1730 c0x0000 (---------------)  + I gran
	0x0035bc85, // n0x1731 c0x0000 (---------------)  + I grane
	0x00384e47, // n0x1732 c0x0000 (---------------)  + I granvin
	0x00388b09, // n0x1733 c0x0000 (---------------)  + I gratangen
	0x0022d248, // n0x1734 c0x0000 (---------------)  + I grimstad
	0x002b6085, // n0x1735 c0x0000 (---------------)  + I grong
	0x0039a744, // n0x1736 c0x0000 (---------------)  + I grue
	0x0035d2c5, // n0x1737 c0x0000 (---------------)  + I gulen
	0x0025334d, // n0x1738 c0x0000 (---------------)  + I guovdageaidnu
	0x00202442, // n0x1739 c0x0000 (---------------)  + I ha
	0x002c9b86, // n0x173a c0x0000 (---------------)  + I habmer
	0x0026b9c6, // n0x173b c0x0000 (---------------)  + I hadsel
	0x002a5e4a, // n0x173c c0x0000 (---------------)  + I hagebostad
	0x0035f386, // n0x173d c0x0000 (---------------)  + I halden
	0x0036d3c5, // n0x173e c0x0000 (---------------)  + I halsa
	0x0025e745, // n0x173f c0x0000 (---------------)  + I hamar
	0x0025e747, // n0x1740 c0x0000 (---------------)  + I hamaroy
	0x0037558c, // n0x1741 c0x0000 (---------------)  + I hammarfeasta
	0x0033c28a, // n0x1742 c0x0000 (---------------)  + I hammerfest
	0x0028aa06, // n0x1743 c0x0000 (---------------)  + I hapmir
	0x002cfb05, // n0x1744 c0x0000 (---------------)  + I haram
	0x0028af86, // n0x1745 c0x0000 (---------------)  + I hareid
	0x0028b2c7, // n0x1746 c0x0000 (---------------)  + I harstad
	0x0028c606, // n0x1747 c0x0000 (---------------)  + I hasvik
	0x0028f74c, // n0x1748 c0x0000 (---------------)  + I hattfjelldal
	0x00204f49, // n0x1749 c0x0000 (---------------)  + I haugesund
	0x3de36587, // n0x174a c0x00f7 (n0x196d-n0x1970)  o I hedmark
	0x002910c5, // n0x174b c0x0000 (---------------)  + I hemne
	0x002910c6, // n0x174c c0x0000 (---------------)  + I hemnes
	0x00291d48, // n0x174d c0x0000 (---------------)  + I hemsedal
	0x00232305, // n0x174e c0x0000 (---------------)  + I herad
	0x002a4585, // n0x174f c0x0000 (---------------)  + I hitra
	0x002a47c8, // n0x1750 c0x0000 (---------------)  + I hjartdal
	0x002a49ca, // n0x1751 c0x0000 (---------------)  + I hjelmeland
	0x3e248fc2, // n0x1752 c0x00f8 (n0x1970-n0x1971)  + I hl
	0x3e60e942, // n0x1753 c0x00f9 (n0x1971-n0x1972)  + I hm
	0x00378245, // n0x1754 c0x0000 (---------------)  + I hobol
	0x002d7743, // n0x1755 c0x0000 (---------------)  + I hof
	0x003a4508, // n0x1756 c0x0000 (---------------)  + I hokksund
	0x0023ce83, // n0x1757 c0x0000 (---------------)  + I hol
	0x002a4c44, // n0x1758 c0x0000 (---------------)  + I hole
	0x002a814b, // n0x1759 c0x0000 (---------------)  + I holmestrand
	0x002ae1c8, // n0x175a c0x0000 (---------------)  + I holtalen
	0x002a7ac8, // n0x175b c0x0000 (---------------)  + I honefoss
	0x3eb1a749, // n0x175c c0x00fa (n0x1972-n0x1973)  o I hordaland
	0x002a8f89, // n0x175d c0x0000 (---------------)  + I hornindal
	0x002a9406, // n0x175e c0x0000 (---------------)  + I horten
	0x002aa188, // n0x175f c0x0000 (---------------)  + I hoyanger
	0x002aa389, // n0x1760 c0x0000 (---------------)  + I hoylandet
	0x002ab246, // n0x1761 c0x0000 (---------------)  + I hurdal
	0x002ab3c5, // n0x1762 c0x0000 (---------------)  + I hurum
	0x00363586, // n0x1763 c0x0000 (---------------)  + I hvaler
	0x002ab849, // n0x1764 c0x0000 (---------------)  + I hyllestad
	0x00229187, // n0x1765 c0x0000 (---------------)  + I ibestad
	0x0026dd46, // n0x1766 c0x0000 (---------------)  + I idrett
	0x002e7747, // n0x1767 c0x0000 (---------------)  + I inderoy
	0x003547c7, // n0x1768 c0x0000 (---------------)  + I iveland
	0x0023fcc4, // n0x1769 c0x0000 (---------------)  + I ivgu
	0x3ee1cfc9, // n0x176a c0x00fb (n0x1973-n0x1974)  + I jan-mayen
	0x002c57c8, // n0x176b c0x0000 (---------------)  + I jessheim
	0x00358388, // n0x176c c0x0000 (---------------)  + I jevnaker
	0x00343c87, // n0x176d c0x0000 (---------------)  + I jolster
	0x002c1046, // n0x176e c0x0000 (---------------)  + I jondal
	0x002fc709, // n0x176f c0x0000 (---------------)  + I jorpeland
	0x002bc3c7, // n0x1770 c0x0000 (---------------)  + I kafjord
	0x0024fd0a, // n0x1771 c0x0000 (---------------)  + I karasjohka
	0x0037dbc8, // n0x1772 c0x0000 (---------------)  + I karasjok
	0x00330887, // n0x1773 c0x0000 (---------------)  + I karlsoy
	0x00229586, // n0x1774 c0x0000 (---------------)  + I karmoy
	0x002650ca, // n0x1775 c0x0000 (---------------)  + I kautokeino
	0x0027e3c8, // n0x1776 c0x0000 (---------------)  + I kirkenes
	0x0026b445, // n0x1777 c0x0000 (---------------)  + I klabu
	0x00374f05, // n0x1778 c0x0000 (---------------)  + I klepp
	0x00387dc7, // n0x1779 c0x0000 (---------------)  + I kommune
	0x002bfb09, // n0x177a c0x0000 (---------------)  + I kongsberg
	0x002c478b, // n0x177b c0x0000 (---------------)  + I kongsvinger
	0x002d6808, // n0x177c c0x0000 (---------------)  + I kopervik
	0x00255509, // n0x177d c0x0000 (---------------)  + I kraanghke
	0x00250787, // n0x177e c0x0000 (---------------)  + I kragero
	0x002af50c, // n0x177f c0x0000 (---------------)  + I kristiansand
	0x002b01cc, // n0x1780 c0x0000 (---------------)  + I kristiansund
	0x002b04ca, // n0x1781 c0x0000 (---------------)  + I krodsherad
	0x002b074c, // n0x1782 c0x0000 (---------------)  + I krokstadelva
	0x002bb408, // n0x1783 c0x0000 (---------------)  + I kvafjord
	0x002bb608, // n0x1784 c0x0000 (---------------)  + I kvalsund
	0x002bb804, // n0x1785 c0x0000 (---------------)  + I kvam
	0x002bc589, // n0x1786 c0x0000 (---------------)  + I kvanangen
	0x002bc7c9, // n0x1787 c0x0000 (---------------)  + I kvinesdal
	0x002bca0a, // n0x1788 c0x0000 (---------------)  + I kvinnherad
	0x002bcc89, // n0x1789 c0x0000 (---------------)  + I kviteseid
	0x002bcfc7, // n0x178a c0x0000 (---------------)  + I kvitsoy
	0x003a4dcc, // n0x178b c0x0000 (---------------)  + I laakesvuemie
	0x00338186, // n0x178c c0x0000 (---------------)  + I lahppi
	0x00258008, // n0x178d c0x0000 (---------------)  + I langevag
	0x00267d86, // n0x178e c0x0000 (---------------)  + I lardal
	0x0037f706, // n0x178f c0x0000 (---------------)  + I larvik
	0x00328a07, // n0x1790 c0x0000 (---------------)  + I lavagis
	0x00272688, // n0x1791 c0x0000 (---------------)  + I lavangen
	0x00331a4b, // n0x1792 c0x0000 (---------------)  + I leangaviika
	0x002b7ec7, // n0x1793 c0x0000 (---------------)  + I lebesby
	0x002598c9, // n0x1794 c0x0000 (---------------)  + I leikanger
	0x0035e489, // n0x1795 c0x0000 (---------------)  + I leirfjord
	0x00296d87, // n0x1796 c0x0000 (---------------)  + I leirvik
	0x002bbac4, // n0x1797 c0x0000 (---------------)  + I leka
	0x002bf987, // n0x1798 c0x0000 (---------------)  + I leksvik
	0x003562c6, // n0x1799 c0x0000 (---------------)  + I lenvik
	0x00217606, // n0x179a c0x0000 (---------------)  + I lerdal
	0x0031f845, // n0x179b c0x0000 (---------------)  + I lesja
	0x00219f88, // n0x179c c0x0000 (---------------)  + I levanger
	0x002ddf44, // n0x179d c0x0000 (---------------)  + I lier
	0x002ddf46, // n0x179e c0x0000 (---------------)  + I lierne
	0x0033c14b, // n0x179f c0x0000 (---------------)  + I lillehammer
	0x00330089, // n0x17a0 c0x0000 (---------------)  + I lillesand
	0x00322dc6, // n0x17a1 c0x0000 (---------------)  + I lindas
	0x00345ac9, // n0x17a2 c0x0000 (---------------)  + I lindesnes
	0x00389286, // n0x17a3 c0x0000 (---------------)  + I loabat
	0x00259dc8, // n0x17a4 c0x0000 (---------------)  + I lodingen
	0x00214303, // n0x17a5 c0x0000 (---------------)  + I lom
	0x00390905, // n0x17a6 c0x0000 (---------------)  + I loppa
	0x00216209, // n0x17a7 c0x0000 (---------------)  + I lorenskog
	0x00217745, // n0x17a8 c0x0000 (---------------)  + I loten
	0x002fb344, // n0x17a9 c0x0000 (---------------)  + I lund
	0x00275306, // n0x17aa c0x0000 (---------------)  + I lunner
	0x00378ec5, // n0x17ab c0x0000 (---------------)  + I luroy
	0x002dcb06, // n0x17ac c0x0000 (---------------)  + I luster
	0x002fccc7, // n0x17ad c0x0000 (---------------)  + I lyngdal
	0x00213606, // n0x17ae c0x0000 (---------------)  + I lyngen
	0x00298bcb, // n0x17af c0x0000 (---------------)  + I malatvuopmi
	0x002e4e47, // n0x17b0 c0x0000 (---------------)  + I malselv
	0x00205c86, // n0x17b1 c0x0000 (---------------)  + I malvik
	0x0034fcc6, // n0x17b2 c0x0000 (---------------)  + I mandal
	0x00234bc6, // n0x17b3 c0x0000 (---------------)  + I marker
	0x0032fe89, // n0x17b4 c0x0000 (---------------)  + I marnardal
	0x0021ed8a, // n0x17b5 c0x0000 (---------------)  + I masfjorden
	0x0032a985, // n0x17b6 c0x0000 (---------------)  + I masoy
	0x0022080d, // n0x17b7 c0x0000 (---------------)  + I matta-varjjat
	0x002a4ac6, // n0x17b8 c0x0000 (---------------)  + I meland
	0x002160c6, // n0x17b9 c0x0000 (---------------)  + I meldal
	0x00291886, // n0x17ba c0x0000 (---------------)  + I melhus
	0x002a7e05, // n0x17bb c0x0000 (---------------)  + I meloy
	0x0037c7c7, // n0x17bc c0x0000 (---------------)  + I meraker
	0x0029d687, // n0x17bd c0x0000 (---------------)  + I midsund
	0x002e5e0e, // n0x17be c0x0000 (---------------)  + I midtre-gauldal
	0x00209003, // n0x17bf c0x0000 (---------------)  + I mil
	0x002c1009, // n0x17c0 c0x0000 (---------------)  + I mjondalen
	0x00239209, // n0x17c1 c0x0000 (---------------)  + I mo-i-rana
	0x00228e87, // n0x17c2 c0x0000 (---------------)  + I moareke
	0x0026c087, // n0x17c3 c0x0000 (---------------)  + I modalen
	0x002a67c5, // n0x17c4 c0x0000 (---------------)  + I modum
	0x00325445, // n0x17c5 c0x0000 (---------------)  + I molde
	0x3f25d3cf, // n0x17c6 c0x00fc (n0x1974-n0x1976)  o I more-og-romsdal
	0x002c7f87, // n0x17c7 c0x0000 (---------------)  + I mosjoen
	0x002c8148, // n0x17c8 c0x0000 (---------------)  + I moskenes
	0x002c8884, // n0x17c9 c0x0000 (---------------)  + I moss
	0x002c8c46, // n0x17ca c0x0000 (---------------)  + I mosvik
	0x3f64aa02, // n0x17cb c0x00fd (n0x1976-n0x1977)  + I mr
	0x002cc2c6, // n0x17cc c0x0000 (---------------)  + I muosat
	0x002d0106, // n0x17cd c0x0000 (---------------)  + I museum
	0x00331d8e, // n0x17ce c0x0000 (---------------)  + I naamesjevuemie
	0x0031150a, // n0x17cf c0x0000 (---------------)  + I namdalseid
	0x002b57c6, // n0x17d0 c0x0000 (---------------)  + I namsos
	0x002261ca, // n0x17d1 c0x0000 (---------------)  + I namsskogan
	0x002c3349, // n0x17d2 c0x0000 (---------------)  + I nannestad
	0x00315d45, // n0x17d3 c0x0000 (---------------)  + I naroy
	0x0038ac08, // n0x17d4 c0x0000 (---------------)  + I narviika
	0x003a29c6, // n0x17d5 c0x0000 (---------------)  + I narvik
	0x00255008, // n0x17d6 c0x0000 (---------------)  + I naustdal
	0x0031a1c8, // n0x17d7 c0x0000 (---------------)  + I navuotna
	0x0030930b, // n0x17d8 c0x0000 (---------------)  + I nedre-eiker
	0x00222e05, // n0x17d9 c0x0000 (---------------)  + I nesna
	0x00331188, // n0x17da c0x0000 (---------------)  + I nesodden
	0x0020560c, // n0x17db c0x0000 (---------------)  + I nesoddtangen
	0x0022c287, // n0x17dc c0x0000 (---------------)  + I nesseby
	0x0024f8c6, // n0x17dd c0x0000 (---------------)  + I nesset
	0x00230048, // n0x17de c0x0000 (---------------)  + I nissedal
	0x00279d48, // n0x17df c0x0000 (---------------)  + I nittedal
	0x3fa47802, // n0x17e0 c0x00fe (n0x1977-n0x1978)  + I nl
	0x002bbccb, // n0x17e1 c0x0000 (---------------)  + I nord-aurdal
	0x00397f89, // n0x17e2 c0x0000 (---------------)  + I nord-fron
	0x0034c449, // n0x17e3 c0x0000 (---------------)  + I nord-odal
	0x00328887, // n0x17e4 c0x0000 (---------------)  + I norddal
	0x00249408, // n0x17e5 c0x0000 (---------------)  + I nordkapp
	0x3ff45708, // n0x17e6 c0x00ff (n0x1978-n0x197c)  o I nordland
	0x0025f08b, // n0x17e7 c0x0000 (---------------)  + I nordre-land
	0x0028e409, // n0x17e8 c0x0000 (---------------)  + I nordreisa
	0x0021000d, // n0x17e9 c0x0000 (---------------)  + I nore-og-uvdal
	0x002547c8, // n0x17ea c0x0000 (---------------)  + I notodden
	0x0032c588, // n0x17eb c0x0000 (---------------)  + I notteroy
	0x402009c2, // n0x17ec c0x0100 (n0x197c-n0x197d)  + I nt
	0x00202d84, // n0x17ed c0x0000 (---------------)  + I odda
	0x4060b282, // n0x17ee c0x0101 (n0x197d-n0x197e)  + I of
	0x0037dd46, // n0x17ef c0x0000 (---------------)  + I oksnes
	0x40a02242, // n0x17f0 c0x0102 (n0x197e-n0x197f)  + I ol
	0x0037a0ca, // n0x17f1 c0x0000 (---------------)  + I omasvuotna
	0x00352086, // n0x17f2 c0x0000 (---------------)  + I oppdal
	0x00225388, // n0x17f3 c0x0000 (---------------)  + I oppegard
	0x00255c88, // n0x17f4 c0x0000 (---------------)  + I orkanger
	0x002f2686, // n0x17f5 c0x0000 (---------------)  + I orkdal
	0x00338a46, // n0x17f6 c0x0000 (---------------)  + I orland
	0x002e5306, // n0x17f7 c0x0000 (---------------)  + I orskog
	0x0027b0c5, // n0x17f8 c0x0000 (---------------)  + I orsta
	0x00240e44, // n0x17f9 c0x0000 (---------------)  + I osen
	0x40ec40c4, // n0x17fa c0x0103 (n0x197f-n0x1980)  + I oslo
	0x00334ec6, // n0x17fb c0x0000 (---------------)  + I osoyro
	0x002510c7, // n0x17fc c0x0000 (---------------)  + I osteroy
	0x4139f9c7, // n0x17fd c0x0104 (n0x1980-n0x1981)  o I ostfold
	0x002d968b, // n0x17fe c0x0000 (---------------)  + I ostre-toten
	0x0025e1c9, // n0x17ff c0x0000 (---------------)  + I overhalla
	0x002438ca, // n0x1800 c0x0000 (---------------)  + I ovre-eiker
	0x003173c4, // n0x1801 c0x0000 (---------------)  + I oyer
	0x0025e888, // n0x1802 c0x0000 (---------------)  + I oygarden
	0x0026db0d, // n0x1803 c0x0000 (---------------)  + I oystre-slidre
	0x002e0209, // n0x1804 c0x0000 (---------------)  + I porsanger
	0x002e0448, // n0x1805 c0x0000 (---------------)  + I porsangu
	0x002e06c9, // n0x1806 c0x0000 (---------------)  + I porsgrunn
	0x002e1c44, // n0x1807 c0x0000 (---------------)  + I priv
	0x00204d04, // n0x1808 c0x0000 (---------------)  + I rade
	0x0027ec05, // n0x1809 c0x0000 (---------------)  + I radoy
	0x0027720b, // n0x180a c0x0000 (---------------)  + I rahkkeravju
	0x002ae146, // n0x180b c0x0000 (---------------)  + I raholt
	0x00334d05, // n0x180c c0x0000 (---------------)  + I raisa
	0x0037c0c9, // n0x180d c0x0000 (---------------)  + I rakkestad
	0x00223008, // n0x180e c0x0000 (---------------)  + I ralingen
	0x00239344, // n0x180f c0x0000 (---------------)  + I rana
	0x00228c09, // n0x1810 c0x0000 (---------------)  + I randaberg
	0x00248c45, // n0x1811 c0x0000 (---------------)  + I rauma
	0x002b8808, // n0x1812 c0x0000 (---------------)  + I rendalen
	0x00209ec7, // n0x1813 c0x0000 (---------------)  + I rennebu
	0x0030fb88, // n0x1814 c0x0000 (---------------)  + I rennesoy
	0x0027f1c6, // n0x1815 c0x0000 (---------------)  + I rindal
	0x00351107, // n0x1816 c0x0000 (---------------)  + I ringebu
	0x0020e509, // n0x1817 c0x0000 (---------------)  + I ringerike
	0x0023a189, // n0x1818 c0x0000 (---------------)  + I ringsaker
	0x00277985, // n0x1819 c0x0000 (---------------)  + I risor
	0x00238845, // n0x181a c0x0000 (---------------)  + I rissa
	0x4162b682, // n0x181b c0x0105 (n0x1981-n0x1982)  + I rl
	0x002fab84, // n0x181c c0x0000 (---------------)  + I roan
	0x0029d105, // n0x181d c0x0000 (---------------)  + I rodoy
	0x002cd3c6, // n0x181e c0x0000 (---------------)  + I rollag
	0x00318545, // n0x181f c0x0000 (---------------)  + I romsa
	0x002531c7, // n0x1820 c0x0000 (---------------)  + I romskog
	0x00296bc5, // n0x1821 c0x0000 (---------------)  + I roros
	0x00276a44, // n0x1822 c0x0000 (---------------)  + I rost
	0x00326c86, // n0x1823 c0x0000 (---------------)  + I royken
	0x00311907, // n0x1824 c0x0000 (---------------)  + I royrvik
	0x0024aa46, // n0x1825 c0x0000 (---------------)  + I ruovat
	0x003305c5, // n0x1826 c0x0000 (---------------)  + I rygge
	0x00321248, // n0x1827 c0x0000 (---------------)  + I salangen
	0x00223585, // n0x1828 c0x0000 (---------------)  + I salat
	0x00322c47, // n0x1829 c0x0000 (---------------)  + I saltdal
	0x0038ec09, // n0x182a c0x0000 (---------------)  + I samnanger
	0x003301ca, // n0x182b c0x0000 (---------------)  + I sandefjord
	0x0022e9c7, // n0x182c c0x0000 (---------------)  + I sandnes
	0x0022e9cc, // n0x182d c0x0000 (---------------)  + I sandnessjoen
	0x00259606, // n0x182e c0x0000 (---------------)  + I sandoy
	0x0022d049, // n0x182f c0x0000 (---------------)  + I sarpsborg
	0x002314c5, // n0x1830 c0x0000 (---------------)  + I sauda
	0x00232248, // n0x1831 c0x0000 (---------------)  + I sauherad
	0x00210703, // n0x1832 c0x0000 (---------------)  + I sel
	0x00210705, // n0x1833 c0x0000 (---------------)  + I selbu
	0x00329905, // n0x1834 c0x0000 (---------------)  + I selje
	0x0024d147, // n0x1835 c0x0000 (---------------)  + I seljord
	0x41a11cc2, // n0x1836 c0x0106 (n0x1982-n0x1983)  + I sf
	0x002434c7, // n0x1837 c0x0000 (---------------)  + I siellak
	0x002cb986, // n0x1838 c0x0000 (---------------)  + I sigdal
	0x0021cf06, // n0x1839 c0x0000 (---------------)  + I siljan
	0x0034d886, // n0x183a c0x0000 (---------------)  + I sirdal
	0x00279c86, // n0x183b c0x0000 (---------------)  + I skanit
	0x00307808, // n0x183c c0x0000 (---------------)  + I skanland
	0x002d8085, // n0x183d c0x0000 (---------------)  + I skaun
	0x0024ccc7, // n0x183e c0x0000 (---------------)  + I skedsmo
	0x0024cccd, // n0x183f c0x0000 (---------------)  + I skedsmokorset
	0x00209743, // n0x1840 c0x0000 (---------------)  + I ski
	0x00209745, // n0x1841 c0x0000 (---------------)  + I skien
	0x002279c7, // n0x1842 c0x0000 (---------------)  + I skierva
	0x002d1b48, // n0x1843 c0x0000 (---------------)  + I skiptvet
	0x00227585, // n0x1844 c0x0000 (---------------)  + I skjak
	0x00230ec8, // n0x1845 c0x0000 (---------------)  + I skjervoy
	0x00266946, // n0x1846 c0x0000 (---------------)  + I skodje
	0x0023e487, // n0x1847 c0x0000 (---------------)  + I slattum
	0x002c0645, // n0x1848 c0x0000 (---------------)  + I smola
	0x00222e86, // n0x1849 c0x0000 (---------------)  + I snaase
	0x003604c5, // n0x184a c0x0000 (---------------)  + I snasa
	0x002bae0a, // n0x184b c0x0000 (---------------)  + I snillfjord
	0x002d9146, // n0x184c c0x0000 (---------------)  + I snoasa
	0x0023c8c7, // n0x184d c0x0000 (---------------)  + I sogndal
	0x002af145, // n0x184e c0x0000 (---------------)  + I sogne
	0x002e2f47, // n0x184f c0x0000 (---------------)  + I sokndal
	0x00359f04, // n0x1850 c0x0000 (---------------)  + I sola
	0x002fb2c6, // n0x1851 c0x0000 (---------------)  + I solund
	0x0037de85, // n0x1852 c0x0000 (---------------)  + I somna
	0x0022be8b, // n0x1853 c0x0000 (---------------)  + I sondre-land
	0x00356149, // n0x1854 c0x0000 (---------------)  + I songdalen
	0x00378c8a, // n0x1855 c0x0000 (---------------)  + I sor-aurdal
	0x00277a08, // n0x1856 c0x0000 (---------------)  + I sor-fron
	0x002f43c8, // n0x1857 c0x0000 (---------------)  + I sor-odal
	0x002f69cc, // n0x1858 c0x0000 (---------------)  + I sor-varanger
	0x002fbfc7, // n0x1859 c0x0000 (---------------)  + I sorfold
	0x002fd8c8, // n0x185a c0x0000 (---------------)  + I sorreisa
	0x00301f88, // n0x185b c0x0000 (---------------)  + I sortland
	0x003057c5, // n0x185c c0x0000 (---------------)  + I sorum
	0x002bd24a, // n0x185d c0x0000 (---------------)  + I spjelkavik
	0x003347c9, // n0x185e c0x0000 (---------------)  + I spydeberg
	0x41e02742, // n0x185f c0x0107 (n0x1983-n0x1984)  + I st
	0x00202746, // n0x1860 c0x0000 (---------------)  + I stange
	0x0020f204, // n0x1861 c0x0000 (---------------)  + I stat
	0x002ded49, // n0x1862 c0x0000 (---------------)  + I stathelle
	0x002f35c9, // n0x1863 c0x0000 (---------------)  + I stavanger
	0x00225047, // n0x1864 c0x0000 (---------------)  + I stavern
	0x00251a47, // n0x1865 c0x0000 (---------------)  + I steigen
	0x002833c9, // n0x1866 c0x0000 (---------------)  + I steinkjer
	0x0038e808, // n0x1867 c0x0000 (---------------)  + I stjordal
	0x0038e80f, // n0x1868 c0x0000 (---------------)  + I stjordalshalsen
	0x00275e46, // n0x1869 c0x0000 (---------------)  + I stokke
	0x0024688b, // n0x186a c0x0000 (---------------)  + I stor-elvdal
	0x0037d0c5, // n0x186b c0x0000 (---------------)  + I stord
	0x0037d0c7, // n0x186c c0x0000 (---------------)  + I stordal
	0x002e6f89, // n0x186d c0x0000 (---------------)  + I storfjord
	0x00228b86, // n0x186e c0x0000 (---------------)  + I strand
	0x00228b87, // n0x186f c0x0000 (---------------)  + I stranda
	0x0039e5c5, // n0x1870 c0x0000 (---------------)  + I stryn
	0x00237304, // n0x1871 c0x0000 (---------------)  + I sula
	0x002402c6, // n0x1872 c0x0000 (---------------)  + I suldal
	0x00205084, // n0x1873 c0x0000 (---------------)  + I sund
	0x0030a587, // n0x1874 c0x0000 (---------------)  + I sunndal
	0x002e8fc8, // n0x1875 c0x0000 (---------------)  + I surnadal
	0x422ef688, // n0x1876 c0x0108 (n0x1984-n0x1985)  + I svalbard
	0x002efc85, // n0x1877 c0x0000 (---------------)  + I sveio
	0x002efdc7, // n0x1878 c0x0000 (---------------)  + I svelvik
	0x00375cc9, // n0x1879 c0x0000 (---------------)  + I sykkylven
	0x00206cc4, // n0x187a c0x0000 (---------------)  + I tana
	0x00206cc8, // n0x187b c0x0000 (---------------)  + I tananger
	0x42664f08, // n0x187c c0x0109 (n0x1985-n0x1987)  o I telemark
	0x00269804, // n0x187d c0x0000 (---------------)  + I time
	0x00237e88, // n0x187e c0x0000 (---------------)  + I tingvoll
	0x002ea3c4, // n0x187f c0x0000 (---------------)  + I tinn
	0x00226789, // n0x1880 c0x0000 (---------------)  + I tjeldsund
	0x0026cec5, // n0x1881 c0x0000 (---------------)  + I tjome
	0x42a00142, // n0x1882 c0x010a (n0x1987-n0x1988)  + I tm
	0x00275e85, // n0x1883 c0x0000 (---------------)  + I tokke
	0x0021dc85, // n0x1884 c0x0000 (---------------)  + I tolga
	0x003661c8, // n0x1885 c0x0000 (---------------)  + I tonsberg
	0x0023b587, // n0x1886 c0x0000 (---------------)  + I torsken
	0x42e03002, // n0x1887 c0x010b (n0x1988-n0x1989)  + I tr
	0x002c9d45, // n0x1888 c0x0000 (---------------)  + I trana
	0x00274dc6, // n0x1889 c0x0000 (---------------)  + I tranby
	0x00292546, // n0x188a c0x0000 (---------------)  + I tranoy
	0x002fab48, // n0x188b c0x0000 (---------------)  + I troandin
	0x002ffbc8, // n0x188c c0x0000 (---------------)  + I trogstad
	0x00318506, // n0x188d c0x0000 (---------------)  + I tromsa
	0x00323bc6, // n0x188e c0x0000 (---------------)  + I tromso
	0x00352589, // n0x188f c0x0000 (---------------)  + I trondheim
	0x00341ec6, // n0x1890 c0x0000 (---------------)  + I trysil
	0x00356ccb, // n0x1891 c0x0000 (---------------)  + I tvedestrand
	0x0024f6c5, // n0x1892 c0x0000 (---------------)  + I tydal
	0x00219b46, // n0x1893 c0x0000 (---------------)  + I tynset
	0x00215a48, // n0x1894 c0x0000 (---------------)  + I tysfjord
	0x002336c6, // n0x1895 c0x0000 (---------------)  + I tysnes
	0x00235ec6, // n0x1896 c0x0000 (---------------)  + I tysvar
	0x0021518a, // n0x1897 c0x0000 (---------------)  + I ullensaker
	0x0034440a, // n0x1898 c0x0000 (---------------)  + I ullensvang
	0x0028acc5, // n0x1899 c0x0000 (---------------)  + I ulvik
	0x002c7a87, // n0x189a c0x0000 (---------------)  + I unjarga
	0x00341946, // n0x189b c0x0000 (---------------)  + I utsira
	0x432000c2, // n0x189c c0x010c (n0x1989-n0x198a)  + I va
	0x00227b07, // n0x189d c0x0000 (---------------)  + I vaapste
	0x00274745, // n0x189e c0x0000 (---------------)  + I vadso
	0x00322504, // n0x189f c0x0000 (---------------)  + I vaga
	0x00322505, // n0x18a0 c0x0000 (---------------)  + I vagan
	0x003172c6, // n0x18a1 c0x0000 (---------------)  + I vagsoy
	0x0032cec7, // n0x18a2 c0x0000 (---------------)  + I vaksdal
	0x00217105, // n0x18a3 c0x0000 (---------------)  + I valle
	0x0021a004, // n0x18a4 c0x0000 (---------------)  + I vang
	0x0026f108, // n0x18a5 c0x0000 (---------------)  + I vanylven
	0x00235f85, // n0x18a6 c0x0000 (---------------)  + I vardo
	0x002923c7, // n0x18a7 c0x0000 (---------------)  + I varggat
	0x002f0545, // n0x18a8 c0x0000 (---------------)  + I varoy
	0x002140c5, // n0x18a9 c0x0000 (---------------)  + I vefsn
	0x00230284, // n0x18aa c0x0000 (---------------)  + I vega
	0x0028a309, // n0x18ab c0x0000 (---------------)  + I vegarshei
	0x002e29c8, // n0x18ac c0x0000 (---------------)  + I vennesla
	0x00374106, // n0x18ad c0x0000 (---------------)  + I verdal
	0x0033f346, // n0x18ae c0x0000 (---------------)  + I verran
	0x00269506, // n0x18af c0x0000 (---------------)  + I vestby
	0x4379aa48, // n0x18b0 c0x010d (n0x198a-n0x198b)  o I vestfold
	0x002f3807, // n0x18b1 c0x0000 (---------------)  + I vestnes
	0x002f3e8d, // n0x18b2 c0x0000 (---------------)  + I vestre-slidre
	0x002f45cc, // n0x18b3 c0x0000 (---------------)  + I vestre-toten
	0x002f4bc9, // n0x18b4 c0x0000 (---------------)  + I vestvagoy
	0x002f4e09, // n0x18b5 c0x0000 (---------------)  + I vevelstad
	0x43b4f482, // n0x18b6 c0x010e (n0x198b-n0x198c)  + I vf
	0x00399d43, // n0x18b7 c0x0000 (---------------)  + I vgs
	0x00205d43, // n0x18b8 c0x0000 (---------------)  + I vik
	0x00356385, // n0x18b9 c0x0000 (---------------)  + I vikna
	0x00384f4a, // n0x18ba c0x0000 (---------------)  + I vindafjord
	0x003183c6, // n0x18bb c0x0000 (---------------)  + I voagat
	0x002f9845, // n0x18bc c0x0000 (---------------)  + I volda
	0x002fd204, // n0x18bd c0x0000 (---------------)  + I voss
	0x002fd20b, // n0x18be c0x0000 (---------------)  + I vossevangen
	0x0030d90c, // n0x18bf c0x0000 (---------------)  + I xn--andy-ira
	0x0030e14c, // n0x18c0 c0x0000 (---------------)  + I xn--asky-ira
	0x0030e455, // n0x18c1 c0x0000 (---------------)  + I xn--aurskog-hland-jnb
	0x003104cd, // n0x18c2 c0x0000 (---------------)  + I xn--avery-yua
	0x003128cf, // n0x18c3 c0x0000 (---------------)  + I xn--bdddj-mrabd
	0x00312c92, // n0x18c4 c0x0000 (---------------)  + I xn--bearalvhki-y4a
	0x0031310f, // n0x18c5 c0x0000 (---------------)  + I xn--berlevg-jxa
	0x003134d2, // n0x18c6 c0x0000 (---------------)  + I xn--bhcavuotna-s4a
	0x00313953, // n0x18c7 c0x0000 (---------------)  + I xn--bhccavuotna-k7a
	0x00313e0d, // n0x18c8 c0x0000 (---------------)  + I xn--bidr-5nac
	0x003143cd, // n0x18c9 c0x0000 (---------------)  + I xn--bievt-0qa
	0x0031474e, // n0x18ca c0x0000 (---------------)  + I xn--bjarky-fya
	0x00314c0e, // n0x18cb c0x0000 (---------------)  + I xn--bjddar-pta
	0x0031534c, // n0x18cc c0x0000 (---------------)  + I xn--blt-elab
	0x003156cc, // n0x18cd c0x0000 (---------------)  + I xn--bmlo-gra
	0x00315b0b, // n0x18ce c0x0000 (---------------)  + I xn--bod-2na
	0x00315e8e, // n0x18cf c0x0000 (---------------)  + I xn--brnny-wuac
	0x003178d2, // n0x18d0 c0x0000 (---------------)  + I xn--brnnysund-m8ac
	0x0031818c, // n0x18d1 c0x0000 (---------------)  + I xn--brum-voa
	0x003188d0, // n0x18d2 c0x0000 (---------------)  + I xn--btsfjord-9za
	0x00329d52, // n0x18d3 c0x0000 (---------------)  + I xn--davvenjrga-y4a
	0x0032aacc, // n0x18d4 c0x0000 (---------------)  + I xn--dnna-gra
	0x0032b18d, // n0x18d5 c0x0000 (---------------)  + I xn--drbak-wua
	0x0032b4cc, // n0x18d6 c0x0000 (---------------)  + I xn--dyry-ira
	0x0032d351, // n0x18d7 c0x0000 (---------------)  + I xn--eveni-0qa01ga
	0x0032e1cd, // n0x18d8 c0x0000 (---------------)  + I xn--finny-yua
	0x0033318d, // n0x18d9 c0x0000 (---------------)  + I xn--fjord-lra
	0x0033378a, // n0x18da c0x0000 (---------------)  + I xn--fl-zia
	0x00333a0c, // n0x18db c0x0000 (---------------)  + I xn--flor-jra
	0x0033430c, // n0x18dc c0x0000 (---------------)  + I xn--frde-gra
	0x00334a0c, // n0x18dd c0x0000 (---------------)  + I xn--frna-woa
	0x0033528c, // n0x18de c0x0000 (---------------)  + I xn--frya-hra
	0x00338bd3, // n0x18df c0x0000 (---------------)  + I xn--ggaviika-8ya47h
	0x003391d0, // n0x18e0 c0x0000 (---------------)  + I xn--gildeskl-g0a
	0x003395d0, // n0x18e1 c0x0000 (---------------)  + I xn--givuotna-8ya
	0x0033a24d, // n0x18e2 c0x0000 (---------------)  + I xn--gjvik-wua
	0x0033a84c, // n0x18e3 c0x0000 (---------------)  + I xn--gls-elac
	0x0033b449, // n0x18e4 c0x0000 (---------------)  + I xn--h-2fa
	0x0033da4d, // n0x18e5 c0x0000 (---------------)  + I xn--hbmer-xqa
	0x0033dd93, // n0x18e6 c0x0000 (---------------)  + I xn--hcesuolo-7ya35b
	0x0033e991, // n0x18e7 c0x0000 (---------------)  + I xn--hgebostad-g3a
	0x0033edd3, // n0x18e8 c0x0000 (---------------)  + I xn--hmmrfeasta-s4ac
	0x0033f58f, // n0x18e9 c0x0000 (---------------)  + I xn--hnefoss-q1a
	0x0033f94c, // n0x18ea c0x0000 (---------------)  + I xn--hobl-ira
	0x0033fc4f, // n0x18eb c0x0000 (---------------)  + I xn--holtlen-hxa
	0x0034000d, // n0x18ec c0x0000 (---------------)  + I xn--hpmir-xqa
	0x0034060f, // n0x18ed c0x0000 (---------------)  + I xn--hyanger-q1a
	0x003409d0, // n0x18ee c0x0000 (---------------)  + I xn--hylandet-54a
	0x0034144e, // n0x18ef c0x0000 (---------------)  + I xn--indery-fya
	0x00346c4e, // n0x18f0 c0x0000 (---------------)  + I xn--jlster-bya
	0x00347390, // n0x18f1 c0x0000 (---------------)  + I xn--jrpeland-54a
	0x0034860d, // n0x18f2 c0x0000 (---------------)  + I xn--karmy-yua
	0x00348f8e, // n0x18f3 c0x0000 (---------------)  + I xn--kfjord-iua
	0x0034930c, // n0x18f4 c0x0000 (---------------)  + I xn--klbu-woa
	0x0034a2d3, // n0x18f5 c0x0000 (---------------)  + I xn--koluokta-7ya57h
	0x0034c68e, // n0x18f6 c0x0000 (---------------)  + I xn--krager-gya
	0x0034da10, // n0x18f7 c0x0000 (---------------)  + I xn--kranghke-b0a
	0x0034de11, // n0x18f8 c0x0000 (---------------)  + I xn--krdsherad-m8a
	0x0034e24f, // n0x18f9 c0x0000 (---------------)  + I xn--krehamn-dxa
	0x0034e613, // n0x18fa c0x0000 (---------------)  + I xn--krjohka-hwab49j
	0x0034f00d, // n0x18fb c0x0000 (---------------)  + I xn--ksnes-uua
	0x0034f34f, // n0x18fc c0x0000 (---------------)  + I xn--kvfjord-nxa
	0x0034f70e, // n0x18fd c0x0000 (---------------)  + I xn--kvitsy-fya
	0x0034fe50, // n0x18fe c0x0000 (---------------)  + I xn--kvnangen-k0a
	0x00350249, // n0x18ff c0x0000 (---------------)  + I xn--l-1fa
	0x00353090, // n0x1900 c0x0000 (---------------)  + I xn--laheadju-7ya
	0x003536cf, // n0x1901 c0x0000 (---------------)  + I xn--langevg-jxa
	0x00353d4f, // n0x1902 c0x0000 (---------------)  + I xn--ldingen-q1a
	0x00354112, // n0x1903 c0x0000 (---------------)  + I xn--leagaviika-52b
	0x00357c8e, // n0x1904 c0x0000 (---------------)  + I xn--lesund-hua
	0x0035858d, // n0x1905 c0x0000 (---------------)  + I xn--lgrd-poac
	0x0035930d, // n0x1906 c0x0000 (---------------)  + I xn--lhppi-xqa
	0x0035964d, // n0x1907 c0x0000 (---------------)  + I xn--linds-pra
	0x0035aa0d, // n0x1908 c0x0000 (---------------)  + I xn--loabt-0qa
	0x0035ad4d, // n0x1909 c0x0000 (---------------)  + I xn--lrdal-sra
	0x0035b090, // n0x190a c0x0000 (---------------)  + I xn--lrenskog-54a
	0x0035b48b, // n0x190b c0x0000 (---------------)  + I xn--lt-liac
	0x0035ba4c, // n0x190c c0x0000 (---------------)  + I xn--lten-gra
	0x0035bdcc, // n0x190d c0x0000 (---------------)  + I xn--lury-ira
	0x0035c0cc, // n0x190e c0x0000 (---------------)  + I xn--mely-ira
	0x0035c3ce, // n0x190f c0x0000 (---------------)  + I xn--merker-kua
	0x00366c50, // n0x1910 c0x0000 (---------------)  + I xn--mjndalen-64a
	0x00368512, // n0x1911 c0x0000 (---------------)  + I xn--mlatvuopmi-s4a
	0x0036898b, // n0x1912 c0x0000 (---------------)  + I xn--mli-tla
	0x0036940e, // n0x1913 c0x0000 (---------------)  + I xn--mlselv-iua
	0x0036978e, // n0x1914 c0x0000 (---------------)  + I xn--moreke-jua
	0x0036a48e, // n0x1915 c0x0000 (---------------)  + I xn--mosjen-eya
	0x0036c0cb, // n0x1916 c0x0000 (---------------)  + I xn--mot-tla
	0x43f6c696, // n0x1917 c0x010f (n0x198c-n0x198e)  o I xn--mre-og-romsdal-qqb
	0x0036d0cd, // n0x1918 c0x0000 (---------------)  + I xn--msy-ula0h
	0x0036e814, // n0x1919 c0x0000 (---------------)  + I xn--mtta-vrjjat-k7af
	0x0036f70d, // n0x191a c0x0000 (---------------)  + I xn--muost-0qa
	0x00371c95, // n0x191b c0x0000 (---------------)  + I xn--nmesjevuemie-tcba
	0x0037308d, // n0x191c c0x0000 (---------------)  + I xn--nry-yla5g
	0x00373a0f, // n0x191d c0x0000 (---------------)  + I xn--nttery-byae
	0x0037428f, // n0x191e c0x0000 (---------------)  + I xn--nvuotna-hwa
	0x0037750f, // n0x191f c0x0000 (---------------)  + I xn--oppegrd-ixa
	0x003778ce, // n0x1920 c0x0000 (---------------)  + I xn--ostery-fya
	0x0037900d, // n0x1921 c0x0000 (---------------)  + I xn--osyro-wua
	0x0037a891, // n0x1922 c0x0000 (---------------)  + I xn--porsgu-sta26f
	0x0037eecc, // n0x1923 c0x0000 (---------------)  + I xn--rady-ira
	0x0037f1cc, // n0x1924 c0x0000 (---------------)  + I xn--rdal-poa
	0x0037f4cb, // n0x1925 c0x0000 (---------------)  + I xn--rde-ula
	0x0037fa8c, // n0x1926 c0x0000 (---------------)  + I xn--rdy-0nab
	0x0037fe4f, // n0x1927 c0x0000 (---------------)  + I xn--rennesy-v1a
	0x00380212, // n0x1928 c0x0000 (---------------)  + I xn--rhkkervju-01af
	0x00380bcd, // n0x1929 c0x0000 (---------------)  + I xn--rholt-mra
	0x00381b8c, // n0x192a c0x0000 (---------------)  + I xn--risa-5na
	0x0038200c, // n0x192b c0x0000 (---------------)  + I xn--risr-ira
	0x0038230d, // n0x192c c0x0000 (---------------)  + I xn--rland-uua
	0x0038264f, // n0x192d c0x0000 (---------------)  + I xn--rlingen-mxa
	0x00382a0e, // n0x192e c0x0000 (---------------)  + I xn--rmskog-bya
	0x00384c0c, // n0x192f c0x0000 (---------------)  + I xn--rros-gra
	0x003851cd, // n0x1930 c0x0000 (---------------)  + I xn--rskog-uua
	0x0038550b, // n0x1931 c0x0000 (---------------)  + I xn--rst-0na
	0x00385acc, // n0x1932 c0x0000 (---------------)  + I xn--rsta-fra
	0x0038604d, // n0x1933 c0x0000 (---------------)  + I xn--ryken-vua
	0x0038638e, // n0x1934 c0x0000 (---------------)  + I xn--ryrvik-bya
	0x00386809, // n0x1935 c0x0000 (---------------)  + I xn--s-1fa
	0x00387513, // n0x1936 c0x0000 (---------------)  + I xn--sandnessjen-ogb
	0x00387f8d, // n0x1937 c0x0000 (---------------)  + I xn--sandy-yua
	0x003882cd, // n0x1938 c0x0000 (---------------)  + I xn--seral-lra
	0x003888cc, // n0x1939 c0x0000 (---------------)  + I xn--sgne-gra
	0x00388d4e, // n0x193a c0x0000 (---------------)  + I xn--skierv-uta
	0x00389bcf, // n0x193b c0x0000 (---------------)  + I xn--skjervy-v1a
	0x00389f8c, // n0x193c c0x0000 (---------------)  + I xn--skjk-soa
	0x0038a28d, // n0x193d c0x0000 (---------------)  + I xn--sknit-yqa
	0x0038a5cf, // n0x193e c0x0000 (---------------)  + I xn--sknland-fxa
	0x0038a98c, // n0x193f c0x0000 (---------------)  + I xn--slat-5na
	0x0038b08c, // n0x1940 c0x0000 (---------------)  + I xn--slt-elab
	0x0038b44c, // n0x1941 c0x0000 (---------------)  + I xn--smla-hra
	0x0038b74c, // n0x1942 c0x0000 (---------------)  + I xn--smna-gra
	0x0038be0d, // n0x1943 c0x0000 (---------------)  + I xn--snase-nra
	0x0038c152, // n0x1944 c0x0000 (---------------)  + I xn--sndre-land-0cb
	0x0038c7cc, // n0x1945 c0x0000 (---------------)  + I xn--snes-poa
	0x0038cacc, // n0x1946 c0x0000 (---------------)  + I xn--snsa-roa
	0x0038cdd1, // n0x1947 c0x0000 (---------------)  + I xn--sr-aurdal-l8a
	0x0038d20f, // n0x1948 c0x0000 (---------------)  + I xn--sr-fron-q1a
	0x0038d5cf, // n0x1949 c0x0000 (---------------)  + I xn--sr-odal-q1a
	0x0038d993, // n0x194a c0x0000 (---------------)  + I xn--sr-varanger-ggb
	0x0038ee4e, // n0x194b c0x0000 (---------------)  + I xn--srfold-bya
	0x0038f3cf, // n0x194c c0x0000 (---------------)  + I xn--srreisa-q1a
	0x0038f78c, // n0x194d c0x0000 (---------------)  + I xn--srum-gra
	0x4438face, // n0x194e c0x0110 (n0x198e-n0x198f)  o I xn--stfold-9xa
	0x0038fe4f, // n0x194f c0x0000 (---------------)  + I xn--stjrdal-s1a
	0x00390216, // n0x1950 c0x0000 (---------------)  + I xn--stjrdalshalsen-sqb
	0x00390d12, // n0x1951 c0x0000 (---------------)  + I xn--stre-toten-zcb
	0x0039230c, // n0x1952 c0x0000 (---------------)  + I xn--tjme-hra
	0x00392acf, // n0x1953 c0x0000 (---------------)  + I xn--tnsberg-q1a
	0x0039314d, // n0x1954 c0x0000 (---------------)  + I xn--trany-yua
	0x0039348f, // n0x1955 c0x0000 (---------------)  + I xn--trgstad-r1a
	0x0039384c, // n0x1956 c0x0000 (---------------)  + I xn--trna-woa
	0x00393b4d, // n0x1957 c0x0000 (---------------)  + I xn--troms-zua
	0x00393e8d, // n0x1958 c0x0000 (---------------)  + I xn--tysvr-vra
	0x0039570e, // n0x1959 c0x0000 (---------------)  + I xn--unjrga-rta
	0x00396a8c, // n0x195a c0x0000 (---------------)  + I xn--vads-jra
	0x00396d8c, // n0x195b c0x0000 (---------------)  + I xn--vard-jra
	0x00397090, // n0x195c c0x0000 (---------------)  + I xn--vegrshei-c0a
	0x003991d1, // n0x195d c0x0000 (---------------)  + I xn--vestvgy-ixa6o
	0x0039960b, // n0x195e c0x0000 (---------------)  + I xn--vg-yiab
	0x0039994c, // n0x195f c0x0000 (---------------)  + I xn--vgan-qoa
	0x00399c4e, // n0x1960 c0x0000 (---------------)  + I xn--vgsy-qoa0j
	0x0039af51, // n0x1961 c0x0000 (---------------)  + I xn--vre-eiker-k8a
	0x0039b38e, // n0x1962 c0x0000 (---------------)  + I xn--vrggt-xqad
	0x0039b70d, // n0x1963 c0x0000 (---------------)  + I xn--vry-yla5g
	0x003a278b, // n0x1964 c0x0000 (---------------)  + I xn--yer-zna
	0x003a308f, // n0x1965 c0x0000 (---------------)  + I xn--ygarden-p1a
	0x003a4814, // n0x1966 c0x0000 (---------------)  + I xn--ystre-slidre-ujb
	0x0023a242, // n0x1967 c0x0000 (---------------)  + I gs
	0x0023a242, // n0x1968 c0x0000 (---------------)  + I gs
	0x00202c03, // n0x1969 c0x0000 (---------------)  + I nes
	0x0023a242, // n0x196a c0x0000 (---------------)  + I gs
	0x00202c03, // n0x196b c0x0000 (---------------)  + I nes
	0x0023a242, // n0x196c c0x0000 (---------------)  + I gs
	0x0020a802, // n0x196d c0x0000 (---------------)  + I os
	0x003635c5, // n0x196e c0x0000 (---------------)  + I valer
	0x0039ac4c, // n0x196f c0x0000 (---------------)  + I xn--vler-qoa
	0x0023a242, // n0x1970 c0x0000 (---------------)  + I gs
	0x0023a242, // n0x1971 c0x0000 (---------------)  + I gs
	0x0020a802, // n0x1972 c0x0000 (---------------)  + I os
	0x0023a242, // n0x1973 c0x0000 (---------------)  + I gs
	0x002921c5, // n0x1974 c0x0000 (---------------)  + I heroy
	0x003301c5, // n0x1975 c0x0000 (---------------)  + I sande
	0x0023a242, // n0x1976 c0x0000 (---------------)  + I gs
	0x0023a242, // n0x1977 c0x0000 (---------------)  + I gs
	0x0020e402, // n0x1978 c0x0000 (---------------)  + I bo
	0x002921c5, // n0x1979 c0x0000 (---------------)  + I heroy
	0x00310a09, // n0x197a c0x0000 (---------------)  + I xn--b-5ga
	0x0033e68c, // n0x197b c0x0000 (---------------)  + I xn--hery-ira
	0x0023a242, // n0x197c c0x0000 (---------------)  + I gs
	0x0023a242, // n0x197d c0x0000 (---------------)  + I gs
	0x0023a242, // n0x197e c0x0000 (---------------)  + I gs
	0x0023a242, // n0x197f c0x0000 (---------------)  + I gs
	0x003635c5, // n0x1980 c0x0000 (---------------)  + I valer
	0x0023a242, // n0x1981 c0x0000 (---------------)  + I gs
	0x0023a242, // n0x1982 c0x0000 (---------------)  + I gs
	0x0023a242, // n0x1983 c0x0000 (---------------)  + I gs
	0x0023a242, // n0x1984 c0x0000 (---------------)  + I gs
	0x0020e402, // n0x1985 c0x0000 (---------------)  + I bo
	0x00310a09, // n0x1986 c0x0000 (---------------)  + I xn--b-5ga
	0x0023a242, // n0x1987 c0x0000 (---------------)  + I gs
	0x0023a242, // n0x1988 c0x0000 (---------------)  + I gs
	0x0023a242, // n0x1989 c0x0000 (---------------)  + I gs
	0x003301c5, // n0x198a c0x0000 (---------------)  + I sande
	0x0023a242, // n0x198b c0x0000 (---------------)  + I gs
	0x003301c5, // n0x198c c0x0000 (---------------)  + I sande
	0x0033e68c, // n0x198d c0x0000 (---------------)  + I xn--hery-ira
	0x0039ac4c, // n0x198e c0x0000 (---------------)  + I xn--vler-qoa
	0x00330b83, // n0x198f c0x0000 (---------------)  + I biz
	0x00233503, // n0x1990 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1991 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1992 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x1993 c0x0000 (---------------)  + I info
	0x0021fe03, // n0x1994 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1995 c0x0000 (---------------)  + I org
	0x000ecf48, // n0x1996 c0x0000 (---------------)  +   merseine
	0x000a9304, // n0x1997 c0x0000 (---------------)  +   mine
	0x000feb48, // n0x1998 c0x0000 (---------------)  +   shacknet
	0x00201542, // n0x1999 c0x0000 (---------------)  + I ac
	0x45200742, // n0x199a c0x0114 (n0x19a9-n0x19aa)  + I co
	0x00245b43, // n0x199b c0x0000 (---------------)  + I cri
	0x0024eac4, // n0x199c c0x0000 (---------------)  + I geek
	0x00205843, // n0x199d c0x0000 (---------------)  + I gen
	0x00341e04, // n0x199e c0x0000 (---------------)  + I govt
	0x0036b386, // n0x199f c0x0000 (---------------)  + I health
	0x0020cec3, // n0x19a0 c0x0000 (---------------)  + I iwi
	0x002eed84, // n0x19a1 c0x0000 (---------------)  + I kiwi
	0x002703c5, // n0x19a2 c0x0000 (---------------)  + I maori
	0x00209003, // n0x19a3 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x19a4 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x19a5 c0x0000 (---------------)  + I org
	0x0028440a, // n0x19a6 c0x0000 (---------------)  + I parliament
	0x0023d0c6, // n0x19a7 c0x0000 (---------------)  + I school
	0x00369b0c, // n0x19a8 c0x0000 (---------------)  + I xn--mori-qsa
	0x000ffa08, // n0x19a9 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x19aa c0x0000 (---------------)  + I co
	0x00233503, // n0x19ab c0x0000 (---------------)  + I com
	0x0023a783, // n0x19ac c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x19ad c0x0000 (---------------)  + I gov
	0x00213ac3, // n0x19ae c0x0000 (---------------)  + I med
	0x002d0106, // n0x19af c0x0000 (---------------)  + I museum
	0x0021fe03, // n0x19b0 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x19b1 c0x0000 (---------------)  + I org
	0x00220e43, // n0x19b2 c0x0000 (---------------)  + I pro
	0x000035c2, // n0x19b3 c0x0000 (---------------)  +   ae
	0x000fb147, // n0x19b4 c0x0000 (---------------)  +   blogdns
	0x000d3588, // n0x19b5 c0x0000 (---------------)  +   blogsite
	0x0000e74e, // n0x19b6 c0x0000 (---------------)  +   bmoattachments
	0x000878d2, // n0x19b7 c0x0000 (---------------)  +   boldlygoingnowhere
	0x45e3e2c5, // n0x19b8 c0x0117 (n0x19f0-n0x19f2)  o I cdn77
	0x4631c4cc, // n0x19b9 c0x0118 (n0x19f2-n0x19f3)  o I cdn77-secure
	0x0014c048, // n0x19ba c0x0000 (---------------)  +   dnsalias
	0x0007c9c7, // n0x19bb c0x0000 (---------------)  +   dnsdojo
	0x00014e0b, // n0x19bc c0x0000 (---------------)  +   doesntexist
	0x0016a009, // n0x19bd c0x0000 (---------------)  +   dontexist
	0x0014bf47, // n0x19be c0x0000 (---------------)  +   doomdns
	0x0008cdc7, // n0x19bf c0x0000 (---------------)  +   dsmynas
	0x0007c8c7, // n0x19c0 c0x0000 (---------------)  +   duckdns
	0x00011046, // n0x19c1 c0x0000 (---------------)  +   dvrdns
	0x00197b48, // n0x19c2 c0x0000 (---------------)  +   dynalias
	0x46813886, // n0x19c3 c0x011a (n0x19f4-n0x19f6)  +   dyndns
	0x000a950d, // n0x19c4 c0x0000 (---------------)  +   endofinternet
	0x0005ea10, // n0x19c5 c0x0000 (---------------)  +   endoftheinternet
	0x46c04b82, // n0x19c6 c0x011b (n0x19f6-n0x1a2d)  +   eu
	0x00008f88, // n0x19c7 c0x0000 (---------------)  +   familyds
	0x0006ac47, // n0x19c8 c0x0000 (---------------)  +   from-me
	0x00097cc9, // n0x19c9 c0x0000 (---------------)  +   game-host
	0x00057d06, // n0x19ca c0x0000 (---------------)  +   gotdns
	0x0000a882, // n0x19cb c0x0000 (---------------)  +   hk
	0x0014cfca, // n0x19cc c0x0000 (---------------)  +   hobby-site
	0x00013a47, // n0x19cd c0x0000 (---------------)  +   homedns
	0x00146347, // n0x19ce c0x0000 (---------------)  +   homeftp
	0x000a59c9, // n0x19cf c0x0000 (---------------)  +   homelinux
	0x000a6fc8, // n0x19d0 c0x0000 (---------------)  +   homeunix
	0x000e0c0e, // n0x19d1 c0x0000 (---------------)  +   is-a-bruinsfan
	0x0000c54e, // n0x19d2 c0x0000 (---------------)  +   is-a-candidate
	0x00011a0f, // n0x19d3 c0x0000 (---------------)  +   is-a-celticsfan
	0x00012789, // n0x19d4 c0x0000 (---------------)  +   is-a-chef
	0x0004e989, // n0x19d5 c0x0000 (---------------)  +   is-a-geek
	0x000704cb, // n0x19d6 c0x0000 (---------------)  +   is-a-knight
	0x0007fa4f, // n0x19d7 c0x0000 (---------------)  +   is-a-linux-user
	0x0008a50c, // n0x19d8 c0x0000 (---------------)  +   is-a-patsfan
	0x000ab58b, // n0x19d9 c0x0000 (---------------)  +   is-a-soxfan
	0x000b9e88, // n0x19da c0x0000 (---------------)  +   is-found
	0x000d9587, // n0x19db c0x0000 (---------------)  +   is-lost
	0x000fe008, // n0x19dc c0x0000 (---------------)  +   is-saved
	0x000f218b, // n0x19dd c0x0000 (---------------)  +   is-very-bad
	0x000f8d0c, // n0x19de c0x0000 (---------------)  +   is-very-evil
	0x0011b8cc, // n0x19df c0x0000 (---------------)  +   is-very-good
	0x0013aecc, // n0x19e0 c0x0000 (---------------)  +   is-very-nice
	0x00142a4d, // n0x19e1 c0x0000 (---------------)  +   is-very-sweet
	0x0008e588, // n0x19e2 c0x0000 (---------------)  +   isa-geek
	0x00150c09, // n0x19e3 c0x0000 (---------------)  +   kicks-ass
	0x001a24cb, // n0x19e4 c0x0000 (---------------)  +   misconfused
	0x000dcd47, // n0x19e5 c0x0000 (---------------)  +   podzone
	0x000d340a, // n0x19e6 c0x0000 (---------------)  +   readmyblog
	0x0006ba86, // n0x19e7 c0x0000 (---------------)  +   selfip
	0x00099a8d, // n0x19e8 c0x0000 (---------------)  +   sellsyourhome
	0x000cb7c8, // n0x19e9 c0x0000 (---------------)  +   servebbs
	0x000895c8, // n0x19ea c0x0000 (---------------)  +   serveftp
	0x00173dc9, // n0x19eb c0x0000 (---------------)  +   servegame
	0x000e868c, // n0x19ec c0x0000 (---------------)  +   stuff-4-sale
	0x00002382, // n0x19ed c0x0000 (---------------)  +   us
	0x000eadc6, // n0x19ee c0x0000 (---------------)  +   webhop
	0x00005f82, // n0x19ef c0x0000 (---------------)  +   za
	0x00000301, // n0x19f0 c0x0000 (---------------)  +   c
	0x0003cdc3, // n0x19f1 c0x0000 (---------------)  +   rsc
	0x46783486, // n0x19f2 c0x0119 (n0x19f3-n0x19f4)  o I origin
	0x0003e443, // n0x19f3 c0x0000 (---------------)  +   ssl
	0x00002d42, // n0x19f4 c0x0000 (---------------)  +   go
	0x00013a44, // n0x19f5 c0x0000 (---------------)  +   home
	0x000001c2, // n0x19f6 c0x0000 (---------------)  +   al
	0x000d4884, // n0x19f7 c0x0000 (---------------)  +   asso
	0x00000102, // n0x19f8 c0x0000 (---------------)  +   at
	0x00004f82, // n0x19f9 c0x0000 (---------------)  +   au
	0x00003302, // n0x19fa c0x0000 (---------------)  +   be
	0x000ee482, // n0x19fb c0x0000 (---------------)  +   bg
	0x00000302, // n0x19fc c0x0000 (---------------)  +   ca
	0x0003e2c2, // n0x19fd c0x0000 (---------------)  +   cd
	0x00001582, // n0x19fe c0x0000 (---------------)  +   ch
	0x0001ba42, // n0x19ff c0x0000 (---------------)  +   cn
	0x0003e082, // n0x1a00 c0x0000 (---------------)  +   cy
	0x00029ec2, // n0x1a01 c0x0000 (---------------)  +   cz
	0x00004d82, // n0x1a02 c0x0000 (---------------)  +   de
	0x000494c2, // n0x1a03 c0x0000 (---------------)  +   dk
	0x0003a783, // n0x1a04 c0x0000 (---------------)  +   edu
	0x0000b342, // n0x1a05 c0x0000 (---------------)  +   ee
	0x00000482, // n0x1a06 c0x0000 (---------------)  +   es
	0x00007502, // n0x1a07 c0x0000 (---------------)  +   fi
	0x00000582, // n0x1a08 c0x0000 (---------------)  +   fr
	0x00000c82, // n0x1a09 c0x0000 (---------------)  +   gr
	0x0000e4c2, // n0x1a0a c0x0000 (---------------)  +   hr
	0x000195c2, // n0x1a0b c0x0000 (---------------)  +   hu
	0x00000042, // n0x1a0c c0x0000 (---------------)  +   ie
	0x00002902, // n0x1a0d c0x0000 (---------------)  +   il
	0x000013c2, // n0x1a0e c0x0000 (---------------)  +   in
	0x00001603, // n0x1a0f c0x0000 (---------------)  +   int
	0x000006c2, // n0x1a10 c0x0000 (---------------)  +   is
	0x00001e42, // n0x1a11 c0x0000 (---------------)  +   it
	0x000ae3c2, // n0x1a12 c0x0000 (---------------)  +   jp
	0x00006fc2, // n0x1a13 c0x0000 (---------------)  +   kr
	0x00009e02, // n0x1a14 c0x0000 (---------------)  +   lt
	0x00002f42, // n0x1a15 c0x0000 (---------------)  +   lu
	0x00005d02, // n0x1a16 c0x0000 (---------------)  +   lv
	0x0002ac02, // n0x1a17 c0x0000 (---------------)  +   mc
	0x00003e82, // n0x1a18 c0x0000 (---------------)  +   me
	0x00167142, // n0x1a19 c0x0000 (---------------)  +   mk
	0x00004c02, // n0x1a1a c0x0000 (---------------)  +   mt
	0x00026f02, // n0x1a1b c0x0000 (---------------)  +   my
	0x0001fe03, // n0x1a1c c0x0000 (---------------)  +   net
	0x00002802, // n0x1a1d c0x0000 (---------------)  +   ng
	0x00047802, // n0x1a1e c0x0000 (---------------)  +   nl
	0x00000c02, // n0x1a1f c0x0000 (---------------)  +   no
	0x000094c2, // n0x1a20 c0x0000 (---------------)  +   nz
	0x00077905, // n0x1a21 c0x0000 (---------------)  +   paris
	0x000063c2, // n0x1a22 c0x0000 (---------------)  +   pl
	0x0008c9c2, // n0x1a23 c0x0000 (---------------)  +   pt
	0x00043b83, // n0x1a24 c0x0000 (---------------)  +   q-a
	0x00002202, // n0x1a25 c0x0000 (---------------)  +   ro
	0x00011302, // n0x1a26 c0x0000 (---------------)  +   ru
	0x000046c2, // n0x1a27 c0x0000 (---------------)  +   se
	0x0000a402, // n0x1a28 c0x0000 (---------------)  +   si
	0x00007842, // n0x1a29 c0x0000 (---------------)  +   sk
	0x00003002, // n0x1a2a c0x0000 (---------------)  +   tr
	0x00000f82, // n0x1a2b c0x0000 (---------------)  +   uk
	0x00002382, // n0x1a2c c0x0000 (---------------)  +   us
	0x00210f43, // n0x1a2d c0x0000 (---------------)  + I abo
	0x00201542, // n0x1a2e c0x0000 (---------------)  + I ac
	0x00233503, // n0x1a2f c0x0000 (---------------)  + I com
	0x0023a783, // n0x1a30 c0x0000 (---------------)  + I edu
	0x00213183, // n0x1a31 c0x0000 (---------------)  + I gob
	0x0020e2c3, // n0x1a32 c0x0000 (---------------)  + I ing
	0x00213ac3, // n0x1a33 c0x0000 (---------------)  + I med
	0x0021fe03, // n0x1a34 c0x0000 (---------------)  + I net
	0x00201483, // n0x1a35 c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x1a36 c0x0000 (---------------)  + I org
	0x00292103, // n0x1a37 c0x0000 (---------------)  + I sld
	0x000ffa08, // n0x1a38 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1a39 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1a3a c0x0000 (---------------)  + I edu
	0x00213183, // n0x1a3b c0x0000 (---------------)  + I gob
	0x00209003, // n0x1a3c c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1a3d c0x0000 (---------------)  + I net
	0x00201483, // n0x1a3e c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x1a3f c0x0000 (---------------)  + I org
	0x00233503, // n0x1a40 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1a41 c0x0000 (---------------)  + I edu
	0x0022d1c3, // n0x1a42 c0x0000 (---------------)  + I org
	0x00233503, // n0x1a43 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1a44 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1a45 c0x0000 (---------------)  + I gov
	0x00200041, // n0x1a46 c0x0000 (---------------)  + I i
	0x00209003, // n0x1a47 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1a48 c0x0000 (---------------)  + I net
	0x00202d03, // n0x1a49 c0x0000 (---------------)  + I ngo
	0x0022d1c3, // n0x1a4a c0x0000 (---------------)  + I org
	0x00330b83, // n0x1a4b c0x0000 (---------------)  + I biz
	0x00233503, // n0x1a4c c0x0000 (---------------)  + I com
	0x0023a783, // n0x1a4d c0x0000 (---------------)  + I edu
	0x00208f83, // n0x1a4e c0x0000 (---------------)  + I fam
	0x00213183, // n0x1a4f c0x0000 (---------------)  + I gob
	0x00337283, // n0x1a50 c0x0000 (---------------)  + I gok
	0x00282e03, // n0x1a51 c0x0000 (---------------)  + I gon
	0x002a36c3, // n0x1a52 c0x0000 (---------------)  + I gop
	0x00276203, // n0x1a53 c0x0000 (---------------)  + I gos
	0x0026cc83, // n0x1a54 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x1a55 c0x0000 (---------------)  + I info
	0x0021fe03, // n0x1a56 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1a57 c0x0000 (---------------)  + I org
	0x00221a03, // n0x1a58 c0x0000 (---------------)  + I web
	0x002ebac4, // n0x1a59 c0x0000 (---------------)  + I agro
	0x00253543, // n0x1a5a c0x0000 (---------------)  + I aid
	0x000011c3, // n0x1a5b c0x0000 (---------------)  +   art
	0x00200103, // n0x1a5c c0x0000 (---------------)  + I atm
	0x0024a188, // n0x1a5d c0x0000 (---------------)  + I augustow
	0x00265104, // n0x1a5e c0x0000 (---------------)  + I auto
	0x0022404a, // n0x1a5f c0x0000 (---------------)  + I babia-gora
	0x00207a06, // n0x1a60 c0x0000 (---------------)  + I bedzin
	0x00397a07, // n0x1a61 c0x0000 (---------------)  + I beskidy
	0x0021e20a, // n0x1a62 c0x0000 (---------------)  + I bialowieza
	0x00275d09, // n0x1a63 c0x0000 (---------------)  + I bialystok
	0x0039dd47, // n0x1a64 c0x0000 (---------------)  + I bielawa
	0x003a604a, // n0x1a65 c0x0000 (---------------)  + I bieszczady
	0x00330b83, // n0x1a66 c0x0000 (---------------)  + I biz
	0x003782cb, // n0x1a67 c0x0000 (---------------)  + I boleslawiec
	0x002ce249, // n0x1a68 c0x0000 (---------------)  + I bydgoszcz
	0x00269605, // n0x1a69 c0x0000 (---------------)  + I bytom
	0x002cc107, // n0x1a6a c0x0000 (---------------)  + I cieszyn
	0x00000742, // n0x1a6b c0x0000 (---------------)  +   co
	0x00233503, // n0x1a6c c0x0000 (---------------)  + I com
	0x00229ec7, // n0x1a6d c0x0000 (---------------)  + I czeladz
	0x003522c5, // n0x1a6e c0x0000 (---------------)  + I czest
	0x002bb989, // n0x1a6f c0x0000 (---------------)  + I dlugoleka
	0x0023a783, // n0x1a70 c0x0000 (---------------)  + I edu
	0x00222c06, // n0x1a71 c0x0000 (---------------)  + I elblag
	0x002baac3, // n0x1a72 c0x0000 (---------------)  + I elk
	0x000cba03, // n0x1a73 c0x0000 (---------------)  +   gda
	0x000fc286, // n0x1a74 c0x0000 (---------------)  +   gdansk
	0x000ee0c6, // n0x1a75 c0x0000 (---------------)  +   gdynia
	0x0000ce47, // n0x1a76 c0x0000 (---------------)  +   gliwice
	0x00210886, // n0x1a77 c0x0000 (---------------)  + I glogow
	0x00216405, // n0x1a78 c0x0000 (---------------)  + I gmina
	0x00328747, // n0x1a79 c0x0000 (---------------)  + I gniezno
	0x003350c7, // n0x1a7a c0x0000 (---------------)  + I gorlice
	0x48a6cc83, // n0x1a7b c0x0122 (n0x1afe-n0x1b2d)  + I gov
	0x0032ad07, // n0x1a7c c0x0000 (---------------)  + I grajewo
	0x0035e383, // n0x1a7d c0x0000 (---------------)  + I gsm
	0x003205c5, // n0x1a7e c0x0000 (---------------)  + I ilawa
	0x003a1244, // n0x1a7f c0x0000 (---------------)  + I info
	0x0036f508, // n0x1a80 c0x0000 (---------------)  + I jaworzno
	0x002ad88c, // n0x1a81 c0x0000 (---------------)  + I jelenia-gora
	0x002ac505, // n0x1a82 c0x0000 (---------------)  + I jgora
	0x00345486, // n0x1a83 c0x0000 (---------------)  + I kalisz
	0x00229d87, // n0x1a84 c0x0000 (---------------)  + I karpacz
	0x0038e2c7, // n0x1a85 c0x0000 (---------------)  + I kartuzy
	0x0020f847, // n0x1a86 c0x0000 (---------------)  + I kaszuby
	0x00217ac8, // n0x1a87 c0x0000 (---------------)  + I katowice
	0x002acd4f, // n0x1a88 c0x0000 (---------------)  + I kazimierz-dolny
	0x00249345, // n0x1a89 c0x0000 (---------------)  + I kepno
	0x00245c47, // n0x1a8a c0x0000 (---------------)  + I ketrzyn
	0x0039c507, // n0x1a8b c0x0000 (---------------)  + I klodzko
	0x002a4d8a, // n0x1a8c c0x0000 (---------------)  + I kobierzyce
	0x0028c749, // n0x1a8d c0x0000 (---------------)  + I kolobrzeg
	0x002c8d85, // n0x1a8e c0x0000 (---------------)  + I konin
	0x002c970a, // n0x1a8f c0x0000 (---------------)  + I konskowola
	0x000eac86, // n0x1a90 c0x0000 (---------------)  +   krakow
	0x002bab45, // n0x1a91 c0x0000 (---------------)  + I kutno
	0x00368bc4, // n0x1a92 c0x0000 (---------------)  + I lapy
	0x00271a06, // n0x1a93 c0x0000 (---------------)  + I lebork
	0x0037c607, // n0x1a94 c0x0000 (---------------)  + I legnica
	0x00251647, // n0x1a95 c0x0000 (---------------)  + I lezajsk
	0x002551c8, // n0x1a96 c0x0000 (---------------)  + I limanowa
	0x00214305, // n0x1a97 c0x0000 (---------------)  + I lomza
	0x003521c6, // n0x1a98 c0x0000 (---------------)  + I lowicz
	0x00398d05, // n0x1a99 c0x0000 (---------------)  + I lubin
	0x003a42c5, // n0x1a9a c0x0000 (---------------)  + I lukow
	0x0021b5c4, // n0x1a9b c0x0000 (---------------)  + I mail
	0x002f2587, // n0x1a9c c0x0000 (---------------)  + I malbork
	0x0030764a, // n0x1a9d c0x0000 (---------------)  + I malopolska
	0x0020b848, // n0x1a9e c0x0000 (---------------)  + I mazowsze
	0x002ee9c6, // n0x1a9f c0x0000 (---------------)  + I mazury
	0x00013ac3, // n0x1aa0 c0x0000 (---------------)  +   med
	0x003025c5, // n0x1aa1 c0x0000 (---------------)  + I media
	0x00232006, // n0x1aa2 c0x0000 (---------------)  + I miasta
	0x003a5006, // n0x1aa3 c0x0000 (---------------)  + I mielec
	0x00332046, // n0x1aa4 c0x0000 (---------------)  + I mielno
	0x00209003, // n0x1aa5 c0x0000 (---------------)  + I mil
	0x00380e47, // n0x1aa6 c0x0000 (---------------)  + I mragowo
	0x0039c485, // n0x1aa7 c0x0000 (---------------)  + I naklo
	0x0021fe03, // n0x1aa8 c0x0000 (---------------)  + I net
	0x0039dfcd, // n0x1aa9 c0x0000 (---------------)  + I nieruchomosci
	0x00201483, // n0x1aaa c0x0000 (---------------)  + I nom
	0x002552c8, // n0x1aab c0x0000 (---------------)  + I nowaruda
	0x002158c4, // n0x1aac c0x0000 (---------------)  + I nysa
	0x00276d05, // n0x1aad c0x0000 (---------------)  + I olawa
	0x002a4c86, // n0x1aae c0x0000 (---------------)  + I olecko
	0x0023d406, // n0x1aaf c0x0000 (---------------)  + I olkusz
	0x00219a47, // n0x1ab0 c0x0000 (---------------)  + I olsztyn
	0x0023d707, // n0x1ab1 c0x0000 (---------------)  + I opoczno
	0x00251585, // n0x1ab2 c0x0000 (---------------)  + I opole
	0x0022d1c3, // n0x1ab3 c0x0000 (---------------)  + I org
	0x00384947, // n0x1ab4 c0x0000 (---------------)  + I ostroda
	0x002c7689, // n0x1ab5 c0x0000 (---------------)  + I ostroleka
	0x0020ad49, // n0x1ab6 c0x0000 (---------------)  + I ostrowiec
	0x0020d58a, // n0x1ab7 c0x0000 (---------------)  + I ostrowwlkp
	0x00248182, // n0x1ab8 c0x0000 (---------------)  + I pc
	0x00320584, // n0x1ab9 c0x0000 (---------------)  + I pila
	0x002d7404, // n0x1aba c0x0000 (---------------)  + I pisz
	0x00219e47, // n0x1abb c0x0000 (---------------)  + I podhale
	0x00243388, // n0x1abc c0x0000 (---------------)  + I podlasie
	0x002de7c9, // n0x1abd c0x0000 (---------------)  + I polkowice
	0x00209609, // n0x1abe c0x0000 (---------------)  + I pomorskie
	0x002df1c7, // n0x1abf c0x0000 (---------------)  + I pomorze
	0x00248e46, // n0x1ac0 c0x0000 (---------------)  + I powiat
	0x000e0986, // n0x1ac1 c0x0000 (---------------)  +   poznan
	0x002e1c44, // n0x1ac2 c0x0000 (---------------)  + I priv
	0x002e1dca, // n0x1ac3 c0x0000 (---------------)  + I prochowice
	0x002e4548, // n0x1ac4 c0x0000 (---------------)  + I pruszkow
	0x002e51c9, // n0x1ac5 c0x0000 (---------------)  + I przeworsk
	0x00296686, // n0x1ac6 c0x0000 (---------------)  + I pulawy
	0x00339e45, // n0x1ac7 c0x0000 (---------------)  + I radom
	0x0020b708, // n0x1ac8 c0x0000 (---------------)  + I rawa-maz
	0x002c238a, // n0x1ac9 c0x0000 (---------------)  + I realestate
	0x00285b43, // n0x1aca c0x0000 (---------------)  + I rel
	0x0033cf06, // n0x1acb c0x0000 (---------------)  + I rybnik
	0x002df2c7, // n0x1acc c0x0000 (---------------)  + I rzeszow
	0x0020f745, // n0x1acd c0x0000 (---------------)  + I sanok
	0x002224c5, // n0x1ace c0x0000 (---------------)  + I sejny
	0x00247603, // n0x1acf c0x0000 (---------------)  + I sex
	0x00352004, // n0x1ad0 c0x0000 (---------------)  + I shop
	0x00374ec5, // n0x1ad1 c0x0000 (---------------)  + I sklep
	0x00284fc7, // n0x1ad2 c0x0000 (---------------)  + I skoczow
	0x002e2b05, // n0x1ad3 c0x0000 (---------------)  + I slask
	0x002d51c6, // n0x1ad4 c0x0000 (---------------)  + I slupsk
	0x000f3985, // n0x1ad5 c0x0000 (---------------)  +   sopot
	0x0021f483, // n0x1ad6 c0x0000 (---------------)  + I sos
	0x002b5889, // n0x1ad7 c0x0000 (---------------)  + I sosnowiec
	0x00276acc, // n0x1ad8 c0x0000 (---------------)  + I stalowa-wola
	0x002a11cc, // n0x1ad9 c0x0000 (---------------)  + I starachowice
	0x002c92c8, // n0x1ada c0x0000 (---------------)  + I stargard
	0x0027b447, // n0x1adb c0x0000 (---------------)  + I suwalki
	0x002f0a08, // n0x1adc c0x0000 (---------------)  + I swidnica
	0x002f100a, // n0x1add c0x0000 (---------------)  + I swiebodzin
	0x002f198b, // n0x1ade c0x0000 (---------------)  + I swinoujscie
	0x002ce388, // n0x1adf c0x0000 (---------------)  + I szczecin
	0x00345588, // n0x1ae0 c0x0000 (---------------)  + I szczytno
	0x00293346, // n0x1ae1 c0x0000 (---------------)  + I szkola
	0x00357a85, // n0x1ae2 c0x0000 (---------------)  + I targi
	0x00249c0a, // n0x1ae3 c0x0000 (---------------)  + I tarnobrzeg
	0x00220b05, // n0x1ae4 c0x0000 (---------------)  + I tgory
	0x00200142, // n0x1ae5 c0x0000 (---------------)  + I tm
	0x002c0507, // n0x1ae6 c0x0000 (---------------)  + I tourism
	0x0029bec6, // n0x1ae7 c0x0000 (---------------)  + I travel
	0x00352bc5, // n0x1ae8 c0x0000 (---------------)  + I turek
	0x0037da09, // n0x1ae9 c0x0000 (---------------)  + I turystyka
	0x0031fd85, // n0x1aea c0x0000 (---------------)  + I tychy
	0x00291985, // n0x1aeb c0x0000 (---------------)  + I ustka
	0x00320189, // n0x1aec c0x0000 (---------------)  + I walbrzych
	0x00231e86, // n0x1aed c0x0000 (---------------)  + I warmia
	0x0023ee48, // n0x1aee c0x0000 (---------------)  + I warszawa
	0x0025a843, // n0x1aef c0x0000 (---------------)  + I waw
	0x0020fcc6, // n0x1af0 c0x0000 (---------------)  + I wegrow
	0x00275246, // n0x1af1 c0x0000 (---------------)  + I wielun
	0x002fff45, // n0x1af2 c0x0000 (---------------)  + I wlocl
	0x002fff49, // n0x1af3 c0x0000 (---------------)  + I wloclawek
	0x002b0d09, // n0x1af4 c0x0000 (---------------)  + I wodzislaw
	0x0024e547, // n0x1af5 c0x0000 (---------------)  + I wolomin
	0x000ffdc4, // n0x1af6 c0x0000 (---------------)  +   wroc
	0x002ffdc7, // n0x1af7 c0x0000 (---------------)  + I wroclaw
	0x00209509, // n0x1af8 c0x0000 (---------------)  + I zachpomor
	0x0021e405, // n0x1af9 c0x0000 (---------------)  + I zagan
	0x00138408, // n0x1afa c0x0000 (---------------)  +   zakopane
	0x0032f305, // n0x1afb c0x0000 (---------------)  + I zarow
	0x0021fec5, // n0x1afc c0x0000 (---------------)  + I zgora
	0x0022df89, // n0x1afd c0x0000 (---------------)  + I zgorzelec
	0x00200d02, // n0x1afe c0x0000 (---------------)  + I ap
	0x00351ac4, // n0x1aff c0x0000 (---------------)  + I griw
	0x00206902, // n0x1b00 c0x0000 (---------------)  + I ic
	0x002006c2, // n0x1b01 c0x0000 (---------------)  + I is
	0x002717c5, // n0x1b02 c0x0000 (---------------)  + I kmpsp
	0x002cc908, // n0x1b03 c0x0000 (---------------)  + I konsulat
	0x00371a05, // n0x1b04 c0x0000 (---------------)  + I kppsp
	0x002bd183, // n0x1b05 c0x0000 (---------------)  + I kwp
	0x002bd185, // n0x1b06 c0x0000 (---------------)  + I kwpsp
	0x002cc4c3, // n0x1b07 c0x0000 (---------------)  + I mup
	0x0020fc82, // n0x1b08 c0x0000 (---------------)  + I mw
	0x00268444, // n0x1b09 c0x0000 (---------------)  + I oirm
	0x002e6d03, // n0x1b0a c0x0000 (---------------)  + I oum
	0x0020ac42, // n0x1b0b c0x0000 (---------------)  + I pa
	0x002dd7c4, // n0x1b0c c0x0000 (---------------)  + I pinb
	0x002d8443, // n0x1b0d c0x0000 (---------------)  + I piw
	0x00200942, // n0x1b0e c0x0000 (---------------)  + I po
	0x00209343, // n0x1b0f c0x0000 (---------------)  + I psp
	0x0028be44, // n0x1b10 c0x0000 (---------------)  + I psse
	0x002b4bc3, // n0x1b11 c0x0000 (---------------)  + I pup
	0x00242684, // n0x1b12 c0x0000 (---------------)  + I rzgw
	0x002004c2, // n0x1b13 c0x0000 (---------------)  + I sa
	0x00271443, // n0x1b14 c0x0000 (---------------)  + I sdn
	0x00216343, // n0x1b15 c0x0000 (---------------)  + I sko
	0x00205682, // n0x1b16 c0x0000 (---------------)  + I so
	0x0033b802, // n0x1b17 c0x0000 (---------------)  + I sr
	0x002b0b49, // n0x1b18 c0x0000 (---------------)  + I starostwo
	0x00201cc2, // n0x1b19 c0x0000 (---------------)  + I ug
	0x00288444, // n0x1b1a c0x0000 (---------------)  + I ugim
	0x00204bc2, // n0x1b1b c0x0000 (---------------)  + I um
	0x0020b584, // n0x1b1c c0x0000 (---------------)  + I umig
	0x00248e04, // n0x1b1d c0x0000 (---------------)  + I upow
	0x002e3944, // n0x1b1e c0x0000 (---------------)  + I uppo
	0x00202382, // n0x1b1f c0x0000 (---------------)  + I us
	0x00243e82, // n0x1b20 c0x0000 (---------------)  + I uw
	0x00211343, // n0x1b21 c0x0000 (---------------)  + I uzs
	0x002f1603, // n0x1b22 c0x0000 (---------------)  + I wif
	0x00245244, // n0x1b23 c0x0000 (---------------)  + I wiih
	0x0025d1c4, // n0x1b24 c0x0000 (---------------)  + I winb
	0x002c7604, // n0x1b25 c0x0000 (---------------)  + I wios
	0x002c9604, // n0x1b26 c0x0000 (---------------)  + I witd
	0x002ff443, // n0x1b27 c0x0000 (---------------)  + I wiw
	0x002f65c3, // n0x1b28 c0x0000 (---------------)  + I wsa
	0x002eac04, // n0x1b29 c0x0000 (---------------)  + I wskr
	0x003009c4, // n0x1b2a c0x0000 (---------------)  + I wuoz
	0x00300cc6, // n0x1b2b c0x0000 (---------------)  + I wzmiuw
	0x00264682, // n0x1b2c c0x0000 (---------------)  + I zp
	0x00200742, // n0x1b2d c0x0000 (---------------)  + I co
	0x0023a783, // n0x1b2e c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1b2f c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1b30 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1b31 c0x0000 (---------------)  + I org
	0x00201542, // n0x1b32 c0x0000 (---------------)  + I ac
	0x00330b83, // n0x1b33 c0x0000 (---------------)  + I biz
	0x00233503, // n0x1b34 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1b35 c0x0000 (---------------)  + I edu
	0x00202703, // n0x1b36 c0x0000 (---------------)  + I est
	0x0026cc83, // n0x1b37 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x1b38 c0x0000 (---------------)  + I info
	0x002b0e04, // n0x1b39 c0x0000 (---------------)  + I isla
	0x00205284, // n0x1b3a c0x0000 (---------------)  + I name
	0x0021fe03, // n0x1b3b c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1b3c c0x0000 (---------------)  + I org
	0x00220e43, // n0x1b3d c0x0000 (---------------)  + I pro
	0x002e2484, // n0x1b3e c0x0000 (---------------)  + I prof
	0x00355603, // n0x1b3f c0x0000 (---------------)  + I aaa
	0x002b3e43, // n0x1b40 c0x0000 (---------------)  + I aca
	0x0033f204, // n0x1b41 c0x0000 (---------------)  + I acct
	0x0032f106, // n0x1b42 c0x0000 (---------------)  + I avocat
	0x00202003, // n0x1b43 c0x0000 (---------------)  + I bar
	0x00216d43, // n0x1b44 c0x0000 (---------------)  + I cpa
	0x00213703, // n0x1b45 c0x0000 (---------------)  + I eng
	0x002af443, // n0x1b46 c0x0000 (---------------)  + I jur
	0x00274483, // n0x1b47 c0x0000 (---------------)  + I law
	0x00213ac3, // n0x1b48 c0x0000 (---------------)  + I med
	0x0022a5c5, // n0x1b49 c0x0000 (---------------)  + I recht
	0x00233503, // n0x1b4a c0x0000 (---------------)  + I com
	0x0023a783, // n0x1b4b c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1b4c c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1b4d c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1b4e c0x0000 (---------------)  + I org
	0x002db8c3, // n0x1b4f c0x0000 (---------------)  + I plo
	0x00235d43, // n0x1b50 c0x0000 (---------------)  + I sec
	0x000ffa08, // n0x1b51 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1b52 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1b53 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1b54 c0x0000 (---------------)  + I gov
	0x00201603, // n0x1b55 c0x0000 (---------------)  + I int
	0x0021fe03, // n0x1b56 c0x0000 (---------------)  + I net
	0x00242044, // n0x1b57 c0x0000 (---------------)  + I nome
	0x0022d1c3, // n0x1b58 c0x0000 (---------------)  + I org
	0x0029f744, // n0x1b59 c0x0000 (---------------)  + I publ
	0x002b7cc5, // n0x1b5a c0x0000 (---------------)  + I belau
	0x00200742, // n0x1b5b c0x0000 (---------------)  + I co
	0x00202602, // n0x1b5c c0x0000 (---------------)  + I ed
	0x00202d42, // n0x1b5d c0x0000 (---------------)  + I go
	0x00202c02, // n0x1b5e c0x0000 (---------------)  + I ne
	0x00200282, // n0x1b5f c0x0000 (---------------)  + I or
	0x00233503, // n0x1b60 c0x0000 (---------------)  + I com
	0x0023d684, // n0x1b61 c0x0000 (---------------)  + I coop
	0x0023a783, // n0x1b62 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1b63 c0x0000 (---------------)  + I gov
	0x00209003, // n0x1b64 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1b65 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1b66 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x1b67 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1b68 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1b69 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1b6a c0x0000 (---------------)  + I gov
	0x00209003, // n0x1b6b c0x0000 (---------------)  + I mil
	0x00205284, // n0x1b6c c0x0000 (---------------)  + I name
	0x0021fe03, // n0x1b6d c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1b6e c0x0000 (---------------)  + I org
	0x00217443, // n0x1b6f c0x0000 (---------------)  + I sch
	0x002d4884, // n0x1b70 c0x0000 (---------------)  + I asso
	0x000ffa08, // n0x1b71 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1b72 c0x0000 (---------------)  + I com
	0x00201483, // n0x1b73 c0x0000 (---------------)  + I nom
	0x0024bf84, // n0x1b74 c0x0000 (---------------)  + I arts
	0x000ffa08, // n0x1b75 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1b76 c0x0000 (---------------)  + I com
	0x0024d9c4, // n0x1b77 c0x0000 (---------------)  + I firm
	0x003a1244, // n0x1b78 c0x0000 (---------------)  + I info
	0x00201483, // n0x1b79 c0x0000 (---------------)  + I nom
	0x002009c2, // n0x1b7a c0x0000 (---------------)  + I nt
	0x0022d1c3, // n0x1b7b c0x0000 (---------------)  + I org
	0x0022a5c3, // n0x1b7c c0x0000 (---------------)  + I rec
	0x00391185, // n0x1b7d c0x0000 (---------------)  + I store
	0x00200142, // n0x1b7e c0x0000 (---------------)  + I tm
	0x00300b03, // n0x1b7f c0x0000 (---------------)  + I www
	0x00201542, // n0x1b80 c0x0000 (---------------)  + I ac
	0x000ffa08, // n0x1b81 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x1b82 c0x0000 (---------------)  + I co
	0x0023a783, // n0x1b83 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1b84 c0x0000 (---------------)  + I gov
	0x002013c2, // n0x1b85 c0x0000 (---------------)  + I in
	0x0022d1c3, // n0x1b86 c0x0000 (---------------)  + I org
	0x00201542, // n0x1b87 c0x0000 (---------------)  + I ac
	0x003a6207, // n0x1b88 c0x0000 (---------------)  + I adygeya
	0x00289d85, // n0x1b89 c0x0000 (---------------)  + I altai
	0x002937c4, // n0x1b8a c0x0000 (---------------)  + I amur
	0x002e75c6, // n0x1b8b c0x0000 (---------------)  + I amursk
	0x0023668b, // n0x1b8c c0x0000 (---------------)  + I arkhangelsk
	0x0025a5c9, // n0x1b8d c0x0000 (---------------)  + I astrakhan
	0x003453c6, // n0x1b8e c0x0000 (---------------)  + I baikal
	0x003269c9, // n0x1b8f c0x0000 (---------------)  + I bashkiria
	0x002d2e48, // n0x1b90 c0x0000 (---------------)  + I belgorod
	0x002042c3, // n0x1b91 c0x0000 (---------------)  + I bir
	0x000ffa08, // n0x1b92 c0x0000 (---------------)  +   blogspot
	0x00227447, // n0x1b93 c0x0000 (---------------)  + I bryansk
	0x0034d388, // n0x1b94 c0x0000 (---------------)  + I buryatia
	0x002ee443, // n0x1b95 c0x0000 (---------------)  + I cbg
	0x002648c4, // n0x1b96 c0x0000 (---------------)  + I chel
	0x0026670b, // n0x1b97 c0x0000 (---------------)  + I chelyabinsk
	0x002ac6c5, // n0x1b98 c0x0000 (---------------)  + I chita
	0x002bc248, // n0x1b99 c0x0000 (---------------)  + I chukotka
	0x00335889, // n0x1b9a c0x0000 (---------------)  + I chuvashia
	0x0025d143, // n0x1b9b c0x0000 (---------------)  + I cmw
	0x00233503, // n0x1b9c c0x0000 (---------------)  + I com
	0x00202648, // n0x1b9d c0x0000 (---------------)  + I dagestan
	0x002ef847, // n0x1b9e c0x0000 (---------------)  + I dudinka
	0x002eccc6, // n0x1b9f c0x0000 (---------------)  + I e-burg
	0x0023a783, // n0x1ba0 c0x0000 (---------------)  + I edu
	0x003869c7, // n0x1ba1 c0x0000 (---------------)  + I fareast
	0x0026cc83, // n0x1ba2 c0x0000 (---------------)  + I gov
	0x00312746, // n0x1ba3 c0x0000 (---------------)  + I grozny
	0x00201603, // n0x1ba4 c0x0000 (---------------)  + I int
	0x00230d87, // n0x1ba5 c0x0000 (---------------)  + I irkutsk
	0x0027d407, // n0x1ba6 c0x0000 (---------------)  + I ivanovo
	0x003879c7, // n0x1ba7 c0x0000 (---------------)  + I izhevsk
	0x002f2505, // n0x1ba8 c0x0000 (---------------)  + I jamal
	0x00206543, // n0x1ba9 c0x0000 (---------------)  + I jar
	0x0020a7cb, // n0x1baa c0x0000 (---------------)  + I joshkar-ola
	0x00309908, // n0x1bab c0x0000 (---------------)  + I k-uralsk
	0x00226e48, // n0x1bac c0x0000 (---------------)  + I kalmykia
	0x002509c6, // n0x1bad c0x0000 (---------------)  + I kaluga
	0x0022ab89, // n0x1bae c0x0000 (---------------)  + I kamchatka
	0x00327ec7, // n0x1baf c0x0000 (---------------)  + I karelia
	0x002f9b85, // n0x1bb0 c0x0000 (---------------)  + I kazan
	0x00379b44, // n0x1bb1 c0x0000 (---------------)  + I kchr
	0x00275f48, // n0x1bb2 c0x0000 (---------------)  + I kemerovo
	0x0023f40a, // n0x1bb3 c0x0000 (---------------)  + I khabarovsk
	0x0023f649, // n0x1bb4 c0x0000 (---------------)  + I khakassia
	0x002517c3, // n0x1bb5 c0x0000 (---------------)  + I khv
	0x0027ea45, // n0x1bb6 c0x0000 (---------------)  + I kirov
	0x0033bcc3, // n0x1bb7 c0x0000 (---------------)  + I kms
	0x002ab0c6, // n0x1bb8 c0x0000 (---------------)  + I koenig
	0x0039a004, // n0x1bb9 c0x0000 (---------------)  + I komi
	0x002fc3c8, // n0x1bba c0x0000 (---------------)  + I kostroma
	0x00387b4b, // n0x1bbb c0x0000 (---------------)  + I krasnoyarsk
	0x0033bb85, // n0x1bbc c0x0000 (---------------)  + I kuban
	0x002b7a46, // n0x1bbd c0x0000 (---------------)  + I kurgan
	0x002b9785, // n0x1bbe c0x0000 (---------------)  + I kursk
	0x002b9cc8, // n0x1bbf c0x0000 (---------------)  + I kustanai
	0x002bac87, // n0x1bc0 c0x0000 (---------------)  + I kuzbass
	0x00207707, // n0x1bc1 c0x0000 (---------------)  + I lipetsk
	0x00223c47, // n0x1bc2 c0x0000 (---------------)  + I magadan
	0x0021e6c4, // n0x1bc3 c0x0000 (---------------)  + I mari
	0x0021e6c7, // n0x1bc4 c0x0000 (---------------)  + I mari-el
	0x0027bc46, // n0x1bc5 c0x0000 (---------------)  + I marine
	0x00209003, // n0x1bc6 c0x0000 (---------------)  + I mil
	0x002c55c8, // n0x1bc7 c0x0000 (---------------)  + I mordovia
	0x00253243, // n0x1bc8 c0x0000 (---------------)  + I msk
	0x002ccc88, // n0x1bc9 c0x0000 (---------------)  + I murmansk
	0x002d2485, // n0x1bca c0x0000 (---------------)  + I mytis
	0x0031a348, // n0x1bcb c0x0000 (---------------)  + I nakhodka
	0x0023a987, // n0x1bcc c0x0000 (---------------)  + I nalchik
	0x0021fe03, // n0x1bcd c0x0000 (---------------)  + I net
	0x00392a03, // n0x1bce c0x0000 (---------------)  + I nkz
	0x00289404, // n0x1bcf c0x0000 (---------------)  + I nnov
	0x00374d87, // n0x1bd0 c0x0000 (---------------)  + I norilsk
	0x002058c3, // n0x1bd1 c0x0000 (---------------)  + I nov
	0x0027d4cb, // n0x1bd2 c0x0000 (---------------)  + I novosibirsk
	0x00216303, // n0x1bd3 c0x0000 (---------------)  + I nsk
	0x00253204, // n0x1bd4 c0x0000 (---------------)  + I omsk
	0x00391208, // n0x1bd5 c0x0000 (---------------)  + I orenburg
	0x0022d1c3, // n0x1bd6 c0x0000 (---------------)  + I org
	0x002d6e85, // n0x1bd7 c0x0000 (---------------)  + I oryol
	0x00296c85, // n0x1bd8 c0x0000 (---------------)  + I oskol
	0x0039c386, // n0x1bd9 c0x0000 (---------------)  + I palana
	0x00212c85, // n0x1bda c0x0000 (---------------)  + I penza
	0x002d2844, // n0x1bdb c0x0000 (---------------)  + I perm
	0x00209302, // n0x1bdc c0x0000 (---------------)  + I pp
	0x002e5483, // n0x1bdd c0x0000 (---------------)  + I ptz
	0x00368c4a, // n0x1bde c0x0000 (---------------)  + I pyatigorsk
	0x003907c3, // n0x1bdf c0x0000 (---------------)  + I rnd
	0x002d1989, // n0x1be0 c0x0000 (---------------)  + I rubtsovsk
	0x00357446, // n0x1be1 c0x0000 (---------------)  + I ryazan
	0x0021ac48, // n0x1be2 c0x0000 (---------------)  + I sakhalin
	0x0028b986, // n0x1be3 c0x0000 (---------------)  + I samara
	0x002257c7, // n0x1be4 c0x0000 (---------------)  + I saratov
	0x002cc748, // n0x1be5 c0x0000 (---------------)  + I simbirsk
	0x002d6648, // n0x1be6 c0x0000 (---------------)  + I smolensk
	0x002e0f83, // n0x1be7 c0x0000 (---------------)  + I snz
	0x00271883, // n0x1be8 c0x0000 (---------------)  + I spb
	0x00225b89, // n0x1be9 c0x0000 (---------------)  + I stavropol
	0x002f4c43, // n0x1bea c0x0000 (---------------)  + I stv
	0x00341846, // n0x1beb c0x0000 (---------------)  + I surgut
	0x00289a06, // n0x1bec c0x0000 (---------------)  + I syzran
	0x00314f06, // n0x1bed c0x0000 (---------------)  + I tambov
	0x0036cc49, // n0x1bee c0x0000 (---------------)  + I tatarstan
	0x002ff844, // n0x1bef c0x0000 (---------------)  + I test
	0x0020bf43, // n0x1bf0 c0x0000 (---------------)  + I tom
	0x00309805, // n0x1bf1 c0x0000 (---------------)  + I tomsk
	0x0030b209, // n0x1bf2 c0x0000 (---------------)  + I tsaritsyn
	0x00207803, // n0x1bf3 c0x0000 (---------------)  + I tsk
	0x00359bc4, // n0x1bf4 c0x0000 (---------------)  + I tula
	0x002f3304, // n0x1bf5 c0x0000 (---------------)  + I tuva
	0x00360784, // n0x1bf6 c0x0000 (---------------)  + I tver
	0x0031ac06, // n0x1bf7 c0x0000 (---------------)  + I tyumen
	0x0020fa43, // n0x1bf8 c0x0000 (---------------)  + I udm
	0x0020fa48, // n0x1bf9 c0x0000 (---------------)  + I udmurtia
	0x0025a208, // n0x1bfa c0x0000 (---------------)  + I ulan-ude
	0x0035ca86, // n0x1bfb c0x0000 (---------------)  + I vdonsk
	0x002f998b, // n0x1bfc c0x0000 (---------------)  + I vladikavkaz
	0x002f9cc8, // n0x1bfd c0x0000 (---------------)  + I vladimir
	0x002f9ecb, // n0x1bfe c0x0000 (---------------)  + I vladivostok
	0x002fca09, // n0x1bff c0x0000 (---------------)  + I volgograd
	0x002fc187, // n0x1c00 c0x0000 (---------------)  + I vologda
	0x002fce88, // n0x1c01 c0x0000 (---------------)  + I voronezh
	0x002fee83, // n0x1c02 c0x0000 (---------------)  + I vrn
	0x0039fc06, // n0x1c03 c0x0000 (---------------)  + I vyatka
	0x0020f507, // n0x1c04 c0x0000 (---------------)  + I yakutia
	0x00298b45, // n0x1c05 c0x0000 (---------------)  + I yamal
	0x00346f49, // n0x1c06 c0x0000 (---------------)  + I yaroslavl
	0x0030fd4d, // n0x1c07 c0x0000 (---------------)  + I yekaterinburg
	0x0021aa91, // n0x1c08 c0x0000 (---------------)  + I yuzhno-sakhalinsk
	0x0023d545, // n0x1c09 c0x0000 (---------------)  + I zgrad
	0x00201542, // n0x1c0a c0x0000 (---------------)  + I ac
	0x00200742, // n0x1c0b c0x0000 (---------------)  + I co
	0x00233503, // n0x1c0c c0x0000 (---------------)  + I com
	0x0023a783, // n0x1c0d c0x0000 (---------------)  + I edu
	0x0033d7c4, // n0x1c0e c0x0000 (---------------)  + I gouv
	0x0026cc83, // n0x1c0f c0x0000 (---------------)  + I gov
	0x00201603, // n0x1c10 c0x0000 (---------------)  + I int
	0x00209003, // n0x1c11 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1c12 c0x0000 (---------------)  + I net
	0x00233503, // n0x1c13 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1c14 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1c15 c0x0000 (---------------)  + I gov
	0x00213ac3, // n0x1c16 c0x0000 (---------------)  + I med
	0x0021fe03, // n0x1c17 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c18 c0x0000 (---------------)  + I org
	0x00297403, // n0x1c19 c0x0000 (---------------)  + I pub
	0x00217443, // n0x1c1a c0x0000 (---------------)  + I sch
	0x00233503, // n0x1c1b c0x0000 (---------------)  + I com
	0x0023a783, // n0x1c1c c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1c1d c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1c1e c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c1f c0x0000 (---------------)  + I org
	0x00233503, // n0x1c20 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1c21 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1c22 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1c23 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c24 c0x0000 (---------------)  + I org
	0x00233503, // n0x1c25 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1c26 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1c27 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x1c28 c0x0000 (---------------)  + I info
	0x00213ac3, // n0x1c29 c0x0000 (---------------)  + I med
	0x0021fe03, // n0x1c2a c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c2b c0x0000 (---------------)  + I org
	0x00224e42, // n0x1c2c c0x0000 (---------------)  + I tv
	0x00200101, // n0x1c2d c0x0000 (---------------)  + I a
	0x00201542, // n0x1c2e c0x0000 (---------------)  + I ac
	0x00200001, // n0x1c2f c0x0000 (---------------)  + I b
	0x003129c2, // n0x1c30 c0x0000 (---------------)  + I bd
	0x000ffa08, // n0x1c31 c0x0000 (---------------)  +   blogspot
	0x0021ca45, // n0x1c32 c0x0000 (---------------)  + I brand
	0x00200301, // n0x1c33 c0x0000 (---------------)  + I c
	0x00033503, // n0x1c34 c0x0000 (---------------)  +   com
	0x00200381, // n0x1c35 c0x0000 (---------------)  + I d
	0x00200081, // n0x1c36 c0x0000 (---------------)  + I e
	0x00200581, // n0x1c37 c0x0000 (---------------)  + I f
	0x0023f342, // n0x1c38 c0x0000 (---------------)  + I fh
	0x0023f344, // n0x1c39 c0x0000 (---------------)  + I fhsk
	0x00363543, // n0x1c3a c0x0000 (---------------)  + I fhv
	0x00200c81, // n0x1c3b c0x0000 (---------------)  + I g
	0x00200d81, // n0x1c3c c0x0000 (---------------)  + I h
	0x00200041, // n0x1c3d c0x0000 (---------------)  + I i
	0x00200fc1, // n0x1c3e c0x0000 (---------------)  + I k
	0x002e9647, // n0x1c3f c0x0000 (---------------)  + I komforb
	0x002d69cf, // n0x1c40 c0x0000 (---------------)  + I kommunalforbund
	0x002da946, // n0x1c41 c0x0000 (---------------)  + I komvux
	0x00200201, // n0x1c42 c0x0000 (---------------)  + I l
	0x0026a306, // n0x1c43 c0x0000 (---------------)  + I lanbib
	0x00200181, // n0x1c44 c0x0000 (---------------)  + I m
	0x00200541, // n0x1c45 c0x0000 (---------------)  + I n
	0x00325ace, // n0x1c46 c0x0000 (---------------)  + I naturbruksgymn
	0x00200281, // n0x1c47 c0x0000 (---------------)  + I o
	0x0022d1c3, // n0x1c48 c0x0000 (---------------)  + I org
	0x00200941, // n0x1c49 c0x0000 (---------------)  + I p
	0x002a3745, // n0x1c4a c0x0000 (---------------)  + I parti
	0x00209302, // n0x1c4b c0x0000 (---------------)  + I pp
	0x00247505, // n0x1c4c c0x0000 (---------------)  + I press
	0x002002c1, // n0x1c4d c0x0000 (---------------)  + I r
	0x002004c1, // n0x1c4e c0x0000 (---------------)  + I s
	0x00200141, // n0x1c4f c0x0000 (---------------)  + I t
	0x00200142, // n0x1c50 c0x0000 (---------------)  + I tm
	0x00200441, // n0x1c51 c0x0000 (---------------)  + I u
	0x002010c1, // n0x1c52 c0x0000 (---------------)  + I w
	0x00205381, // n0x1c53 c0x0000 (---------------)  + I x
	0x00201841, // n0x1c54 c0x0000 (---------------)  + I y
	0x00205f81, // n0x1c55 c0x0000 (---------------)  + I z
	0x000ffa08, // n0x1c56 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1c57 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1c58 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1c59 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1c5a c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c5b c0x0000 (---------------)  + I org
	0x00220f03, // n0x1c5c c0x0000 (---------------)  + I per
	0x00233503, // n0x1c5d c0x0000 (---------------)  + I com
	0x0026cc83, // n0x1c5e c0x0000 (---------------)  + I gov
	0x0008c288, // n0x1c5f c0x0000 (---------------)  +   hashbang
	0x00209003, // n0x1c60 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1c61 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c62 c0x0000 (---------------)  + I org
	0x014da508, // n0x1c63 c0x0005 (---------------)* o   platform
	0x000ffa08, // n0x1c64 c0x0000 (---------------)  +   blogspot
	0x000ffa08, // n0x1c65 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1c66 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1c67 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1c68 c0x0000 (---------------)  + I gov
	0x0021fe03, // n0x1c69 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c6a c0x0000 (---------------)  + I org
	0x002011c3, // n0x1c6b c0x0000 (---------------)  + I art
	0x000ffa08, // n0x1c6c c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1c6d c0x0000 (---------------)  + I com
	0x0023a783, // n0x1c6e c0x0000 (---------------)  + I edu
	0x0033d7c4, // n0x1c6f c0x0000 (---------------)  + I gouv
	0x0022d1c3, // n0x1c70 c0x0000 (---------------)  + I org
	0x00295005, // n0x1c71 c0x0000 (---------------)  + I perso
	0x00320a04, // n0x1c72 c0x0000 (---------------)  + I univ
	0x00233503, // n0x1c73 c0x0000 (---------------)  + I com
	0x0021fe03, // n0x1c74 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c75 c0x0000 (---------------)  + I org
	0x00200742, // n0x1c76 c0x0000 (---------------)  + I co
	0x00233503, // n0x1c77 c0x0000 (---------------)  + I com
	0x00237249, // n0x1c78 c0x0000 (---------------)  + I consulado
	0x0023a783, // n0x1c79 c0x0000 (---------------)  + I edu
	0x00242d89, // n0x1c7a c0x0000 (---------------)  + I embaixada
	0x0026cc83, // n0x1c7b c0x0000 (---------------)  + I gov
	0x00209003, // n0x1c7c c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1c7d c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1c7e c0x0000 (---------------)  + I org
	0x002e1a48, // n0x1c7f c0x0000 (---------------)  + I principe
	0x00215f87, // n0x1c80 c0x0000 (---------------)  + I saotome
	0x00391185, // n0x1c81 c0x0000 (---------------)  + I store
	0x003a6207, // n0x1c82 c0x0000 (---------------)  + I adygeya
	0x0023668b, // n0x1c83 c0x0000 (---------------)  + I arkhangelsk
	0x0020d908, // n0x1c84 c0x0000 (---------------)  + I balashov
	0x003269c9, // n0x1c85 c0x0000 (---------------)  + I bashkiria
	0x00227447, // n0x1c86 c0x0000 (---------------)  + I bryansk
	0x00202648, // n0x1c87 c0x0000 (---------------)  + I dagestan
	0x00312746, // n0x1c88 c0x0000 (---------------)  + I grozny
	0x0027d407, // n0x1c89 c0x0000 (---------------)  + I ivanovo
	0x00226e48, // n0x1c8a c0x0000 (---------------)  + I kalmykia
	0x002509c6, // n0x1c8b c0x0000 (---------------)  + I kaluga
	0x00327ec7, // n0x1c8c c0x0000 (---------------)  + I karelia
	0x0023f649, // n0x1c8d c0x0000 (---------------)  + I khakassia
	0x0037f849, // n0x1c8e c0x0000 (---------------)  + I krasnodar
	0x002b7a46, // n0x1c8f c0x0000 (---------------)  + I kurgan
	0x002b8945, // n0x1c90 c0x0000 (---------------)  + I lenug
	0x002c55c8, // n0x1c91 c0x0000 (---------------)  + I mordovia
	0x00253243, // n0x1c92 c0x0000 (---------------)  + I msk
	0x002ccc88, // n0x1c93 c0x0000 (---------------)  + I murmansk
	0x0023a987, // n0x1c94 c0x0000 (---------------)  + I nalchik
	0x002058c3, // n0x1c95 c0x0000 (---------------)  + I nov
	0x00229c07, // n0x1c96 c0x0000 (---------------)  + I obninsk
	0x00212c85, // n0x1c97 c0x0000 (---------------)  + I penza
	0x002dd148, // n0x1c98 c0x0000 (---------------)  + I pokrovsk
	0x00274805, // n0x1c99 c0x0000 (---------------)  + I sochi
	0x00271883, // n0x1c9a c0x0000 (---------------)  + I spb
	0x0033d1c9, // n0x1c9b c0x0000 (---------------)  + I togliatti
	0x002aa587, // n0x1c9c c0x0000 (---------------)  + I troitsk
	0x00359bc4, // n0x1c9d c0x0000 (---------------)  + I tula
	0x002f3304, // n0x1c9e c0x0000 (---------------)  + I tuva
	0x002f998b, // n0x1c9f c0x0000 (---------------)  + I vladikavkaz
	0x002f9cc8, // n0x1ca0 c0x0000 (---------------)  + I vladimir
	0x002fc187, // n0x1ca1 c0x0000 (---------------)  + I vologda
	0x00233503, // n0x1ca2 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1ca3 c0x0000 (---------------)  + I edu
	0x00213183, // n0x1ca4 c0x0000 (---------------)  + I gob
	0x0022d1c3, // n0x1ca5 c0x0000 (---------------)  + I org
	0x00244803, // n0x1ca6 c0x0000 (---------------)  + I red
	0x0026cc83, // n0x1ca7 c0x0000 (---------------)  + I gov
	0x00233503, // n0x1ca8 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1ca9 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1caa c0x0000 (---------------)  + I gov
	0x00209003, // n0x1cab c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1cac c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1cad c0x0000 (---------------)  + I org
	0x00201542, // n0x1cae c0x0000 (---------------)  + I ac
	0x00200742, // n0x1caf c0x0000 (---------------)  + I co
	0x0022d1c3, // n0x1cb0 c0x0000 (---------------)  + I org
	0x000ffa08, // n0x1cb1 c0x0000 (---------------)  +   blogspot
	0x00201542, // n0x1cb2 c0x0000 (---------------)  + I ac
	0x00200742, // n0x1cb3 c0x0000 (---------------)  + I co
	0x00202d42, // n0x1cb4 c0x0000 (---------------)  + I go
	0x002013c2, // n0x1cb5 c0x0000 (---------------)  + I in
	0x00209002, // n0x1cb6 c0x0000 (---------------)  + I mi
	0x0021fe03, // n0x1cb7 c0x0000 (---------------)  + I net
	0x00200282, // n0x1cb8 c0x0000 (---------------)  + I or
	0x00201542, // n0x1cb9 c0x0000 (---------------)  + I ac
	0x00330b83, // n0x1cba c0x0000 (---------------)  + I biz
	0x00200742, // n0x1cbb c0x0000 (---------------)  + I co
	0x00233503, // n0x1cbc c0x0000 (---------------)  + I com
	0x0023a783, // n0x1cbd c0x0000 (---------------)  + I edu
	0x00202d42, // n0x1cbe c0x0000 (---------------)  + I go
	0x0026cc83, // n0x1cbf c0x0000 (---------------)  + I gov
	0x00201603, // n0x1cc0 c0x0000 (---------------)  + I int
	0x00209003, // n0x1cc1 c0x0000 (---------------)  + I mil
	0x00205284, // n0x1cc2 c0x0000 (---------------)  + I name
	0x0021fe03, // n0x1cc3 c0x0000 (---------------)  + I net
	0x00218f83, // n0x1cc4 c0x0000 (---------------)  + I nic
	0x0022d1c3, // n0x1cc5 c0x0000 (---------------)  + I org
	0x002ff844, // n0x1cc6 c0x0000 (---------------)  + I test
	0x00221a03, // n0x1cc7 c0x0000 (---------------)  + I web
	0x0026cc83, // n0x1cc8 c0x0000 (---------------)  + I gov
	0x00200742, // n0x1cc9 c0x0000 (---------------)  + I co
	0x00233503, // n0x1cca c0x0000 (---------------)  + I com
	0x0023a783, // n0x1ccb c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1ccc c0x0000 (---------------)  + I gov
	0x00209003, // n0x1ccd c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1cce c0x0000 (---------------)  + I net
	0x00201483, // n0x1ccf c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x1cd0 c0x0000 (---------------)  + I org
	0x003927c7, // n0x1cd1 c0x0000 (---------------)  + I agrinet
	0x00233503, // n0x1cd2 c0x0000 (---------------)  + I com
	0x00222387, // n0x1cd3 c0x0000 (---------------)  + I defense
	0x0025d886, // n0x1cd4 c0x0000 (---------------)  + I edunet
	0x00215243, // n0x1cd5 c0x0000 (---------------)  + I ens
	0x00207503, // n0x1cd6 c0x0000 (---------------)  + I fin
	0x0026cc83, // n0x1cd7 c0x0000 (---------------)  + I gov
	0x0021d883, // n0x1cd8 c0x0000 (---------------)  + I ind
	0x003a1244, // n0x1cd9 c0x0000 (---------------)  + I info
	0x0036d504, // n0x1cda c0x0000 (---------------)  + I intl
	0x002da6c6, // n0x1cdb c0x0000 (---------------)  + I mincom
	0x0022b143, // n0x1cdc c0x0000 (---------------)  + I nat
	0x0021fe03, // n0x1cdd c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1cde c0x0000 (---------------)  + I org
	0x00295005, // n0x1cdf c0x0000 (---------------)  + I perso
	0x0020d344, // n0x1ce0 c0x0000 (---------------)  + I rnrt
	0x00266ec3, // n0x1ce1 c0x0000 (---------------)  + I rns
	0x00351883, // n0x1ce2 c0x0000 (---------------)  + I rnu
	0x002c0507, // n0x1ce3 c0x0000 (---------------)  + I tourism
	0x00209e45, // n0x1ce4 c0x0000 (---------------)  + I turen
	0x00233503, // n0x1ce5 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1ce6 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1ce7 c0x0000 (---------------)  + I gov
	0x00209003, // n0x1ce8 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1ce9 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1cea c0x0000 (---------------)  + I org
	0x00203402, // n0x1ceb c0x0000 (---------------)  + I av
	0x002cb903, // n0x1cec c0x0000 (---------------)  + I bbs
	0x0028e2c3, // n0x1ced c0x0000 (---------------)  + I bel
	0x00330b83, // n0x1cee c0x0000 (---------------)  + I biz
	0x52a33503, // n0x1cef c0x014a (n0x1d00-n0x1d01)  + I com
	0x0022bf42, // n0x1cf0 c0x0000 (---------------)  + I dr
	0x0023a783, // n0x1cf1 c0x0000 (---------------)  + I edu
	0x00205843, // n0x1cf2 c0x0000 (---------------)  + I gen
	0x0026cc83, // n0x1cf3 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x1cf4 c0x0000 (---------------)  + I info
	0x00309ac3, // n0x1cf5 c0x0000 (---------------)  + I k12
	0x00249343, // n0x1cf6 c0x0000 (---------------)  + I kep
	0x00209003, // n0x1cf7 c0x0000 (---------------)  + I mil
	0x00205284, // n0x1cf8 c0x0000 (---------------)  + I name
	0x52e00642, // n0x1cf9 c0x014b (n0x1d01-n0x1d02)  + I nc
	0x0021fe03, // n0x1cfa c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1cfb c0x0000 (---------------)  + I org
	0x00208103, // n0x1cfc c0x0000 (---------------)  + I pol
	0x0022f7c3, // n0x1cfd c0x0000 (---------------)  + I tel
	0x00224e42, // n0x1cfe c0x0000 (---------------)  + I tv
	0x00221a03, // n0x1cff c0x0000 (---------------)  + I web
	0x000ffa08, // n0x1d00 c0x0000 (---------------)  +   blogspot
	0x0026cc83, // n0x1d01 c0x0000 (---------------)  + I gov
	0x002389c4, // n0x1d02 c0x0000 (---------------)  + I aero
	0x00330b83, // n0x1d03 c0x0000 (---------------)  + I biz
	0x00200742, // n0x1d04 c0x0000 (---------------)  + I co
	0x00233503, // n0x1d05 c0x0000 (---------------)  + I com
	0x0023d684, // n0x1d06 c0x0000 (---------------)  + I coop
	0x0023a783, // n0x1d07 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1d08 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x1d09 c0x0000 (---------------)  + I info
	0x00201603, // n0x1d0a c0x0000 (---------------)  + I int
	0x002ddc44, // n0x1d0b c0x0000 (---------------)  + I jobs
	0x00207104, // n0x1d0c c0x0000 (---------------)  + I mobi
	0x002d0106, // n0x1d0d c0x0000 (---------------)  + I museum
	0x00205284, // n0x1d0e c0x0000 (---------------)  + I name
	0x0021fe03, // n0x1d0f c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1d10 c0x0000 (---------------)  + I org
	0x00220e43, // n0x1d11 c0x0000 (---------------)  + I pro
	0x0029bec6, // n0x1d12 c0x0000 (---------------)  + I travel
	0x00055f8b, // n0x1d13 c0x0000 (---------------)  +   better-than
	0x00013886, // n0x1d14 c0x0000 (---------------)  +   dyndns
	0x0002184a, // n0x1d15 c0x0000 (---------------)  +   on-the-web
	0x000fef4a, // n0x1d16 c0x0000 (---------------)  +   worse-than
	0x000ffa08, // n0x1d17 c0x0000 (---------------)  +   blogspot
	0x00238ac4, // n0x1d18 c0x0000 (---------------)  + I club
	0x00233503, // n0x1d19 c0x0000 (---------------)  + I com
	0x00330b44, // n0x1d1a c0x0000 (---------------)  + I ebiz
	0x0023a783, // n0x1d1b c0x0000 (---------------)  + I edu
	0x00297cc4, // n0x1d1c c0x0000 (---------------)  + I game
	0x0026cc83, // n0x1d1d c0x0000 (---------------)  + I gov
	0x00317243, // n0x1d1e c0x0000 (---------------)  + I idv
	0x00209003, // n0x1d1f c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1d20 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1d21 c0x0000 (---------------)  + I org
	0x0032444b, // n0x1d22 c0x0000 (---------------)  + I xn--czrw28b
	0x003941ca, // n0x1d23 c0x0000 (---------------)  + I xn--uc0atv
	0x003a54cc, // n0x1d24 c0x0000 (---------------)  + I xn--zf0ao64a
	0x00201542, // n0x1d25 c0x0000 (---------------)  + I ac
	0x00200742, // n0x1d26 c0x0000 (---------------)  + I co
	0x00202d42, // n0x1d27 c0x0000 (---------------)  + I go
	0x00234dc5, // n0x1d28 c0x0000 (---------------)  + I hotel
	0x003a1244, // n0x1d29 c0x0000 (---------------)  + I info
	0x00203e82, // n0x1d2a c0x0000 (---------------)  + I me
	0x00209003, // n0x1d2b c0x0000 (---------------)  + I mil
	0x00207104, // n0x1d2c c0x0000 (---------------)  + I mobi
	0x00202c02, // n0x1d2d c0x0000 (---------------)  + I ne
	0x00200282, // n0x1d2e c0x0000 (---------------)  + I or
	0x00200702, // n0x1d2f c0x0000 (---------------)  + I sc
	0x00224e42, // n0x1d30 c0x0000 (---------------)  + I tv
	0x00130b83, // n0x1d31 c0x0000 (---------------)  +   biz
	0x002d5d89, // n0x1d32 c0x0000 (---------------)  + I cherkassy
	0x00289888, // n0x1d33 c0x0000 (---------------)  + I cherkasy
	0x0026cb09, // n0x1d34 c0x0000 (---------------)  + I chernigov
	0x0027d249, // n0x1d35 c0x0000 (---------------)  + I chernihiv
	0x0036e44a, // n0x1d36 c0x0000 (---------------)  + I chernivtsi
	0x00375aca, // n0x1d37 c0x0000 (---------------)  + I chernovtsy
	0x0020b482, // n0x1d38 c0x0000 (---------------)  + I ck
	0x0021ba42, // n0x1d39 c0x0000 (---------------)  + I cn
	0x00000742, // n0x1d3a c0x0000 (---------------)  +   co
	0x00233503, // n0x1d3b c0x0000 (---------------)  + I com
	0x002049c2, // n0x1d3c c0x0000 (---------------)  + I cr
	0x00245e06, // n0x1d3d c0x0000 (---------------)  + I crimea
	0x00353bc2, // n0x1d3e c0x0000 (---------------)  + I cv
	0x00211102, // n0x1d3f c0x0000 (---------------)  + I dn
	0x002276ce, // n0x1d40 c0x0000 (---------------)  + I dnepropetrovsk
	0x0027148e, // n0x1d41 c0x0000 (---------------)  + I dnipropetrovsk
	0x0027d0c7, // n0x1d42 c0x0000 (---------------)  + I dominic
	0x003219c7, // n0x1d43 c0x0000 (---------------)  + I donetsk
	0x0024dc82, // n0x1d44 c0x0000 (---------------)  + I dp
	0x0023a783, // n0x1d45 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1d46 c0x0000 (---------------)  + I gov
	0x00200f02, // n0x1d47 c0x0000 (---------------)  + I if
	0x002013c2, // n0x1d48 c0x0000 (---------------)  + I in
	0x0024048f, // n0x1d49 c0x0000 (---------------)  + I ivano-frankivsk
	0x0021acc2, // n0x1d4a c0x0000 (---------------)  + I kh
	0x0023fb87, // n0x1d4b c0x0000 (---------------)  + I kharkiv
	0x00240807, // n0x1d4c c0x0000 (---------------)  + I kharkov
	0x0024b387, // n0x1d4d c0x0000 (---------------)  + I kherson
	0x0024eb8c, // n0x1d4e c0x0000 (---------------)  + I khmelnitskiy
	0x00250bcc, // n0x1d4f c0x0000 (---------------)  + I khmelnytskyi
	0x00202ac4, // n0x1d50 c0x0000 (---------------)  + I kiev
	0x0027ea4a, // n0x1d51 c0x0000 (---------------)  + I kirovograd
	0x002316c2, // n0x1d52 c0x0000 (---------------)  + I km
	0x00206fc2, // n0x1d53 c0x0000 (---------------)  + I kr
	0x002b1504, // n0x1d54 c0x0000 (---------------)  + I krym
	0x00254e42, // n0x1d55 c0x0000 (---------------)  + I ks
	0x002bb402, // n0x1d56 c0x0000 (---------------)  + I kv
	0x00250e04, // n0x1d57 c0x0000 (---------------)  + I kyiv
	0x00219082, // n0x1d58 c0x0000 (---------------)  + I lg
	0x00209e02, // n0x1d59 c0x0000 (---------------)  + I lt
	0x00250a47, // n0x1d5a c0x0000 (---------------)  + I lugansk
	0x00238045, // n0x1d5b c0x0000 (---------------)  + I lutsk
	0x00205d02, // n0x1d5c c0x0000 (---------------)  + I lv
	0x00240404, // n0x1d5d c0x0000 (---------------)  + I lviv
	0x00367142, // n0x1d5e c0x0000 (---------------)  + I mk
	0x002f0388, // n0x1d5f c0x0000 (---------------)  + I mykolaiv
	0x0021fe03, // n0x1d60 c0x0000 (---------------)  + I net
	0x00203488, // n0x1d61 c0x0000 (---------------)  + I nikolaev
	0x00202d82, // n0x1d62 c0x0000 (---------------)  + I od
	0x0023bac5, // n0x1d63 c0x0000 (---------------)  + I odesa
	0x00372946, // n0x1d64 c0x0000 (---------------)  + I odessa
	0x0022d1c3, // n0x1d65 c0x0000 (---------------)  + I org
	0x002063c2, // n0x1d66 c0x0000 (---------------)  + I pl
	0x002dea07, // n0x1d67 c0x0000 (---------------)  + I poltava
	0x00009302, // n0x1d68 c0x0000 (---------------)  +   pp
	0x002e1c85, // n0x1d69 c0x0000 (---------------)  + I rivne
	0x0038af45, // n0x1d6a c0x0000 (---------------)  + I rovno
	0x00206882, // n0x1d6b c0x0000 (---------------)  + I rv
	0x0022d142, // n0x1d6c c0x0000 (---------------)  + I sb
	0x00207f4a, // n0x1d6d c0x0000 (---------------)  + I sebastopol
	0x0025140a, // n0x1d6e c0x0000 (---------------)  + I sevastopol
	0x0024cdc2, // n0x1d6f c0x0000 (---------------)  + I sm
	0x002f0304, // n0x1d70 c0x0000 (---------------)  + I sumy
	0x002012c2, // n0x1d71 c0x0000 (---------------)  + I te
	0x00320448, // n0x1d72 c0x0000 (---------------)  + I ternopil
	0x00211342, // n0x1d73 c0x0000 (---------------)  + I uz
	0x0029cfc8, // n0x1d74 c0x0000 (---------------)  + I uzhgorod
	0x002f6cc7, // n0x1d75 c0x0000 (---------------)  + I vinnica
	0x002f7889, // n0x1d76 c0x0000 (---------------)  + I vinnytsia
	0x00203442, // n0x1d77 c0x0000 (---------------)  + I vn
	0x002fcc45, // n0x1d78 c0x0000 (---------------)  + I volyn
	0x00289d45, // n0x1d79 c0x0000 (---------------)  + I yalta
	0x002c300b, // n0x1d7a c0x0000 (---------------)  + I zaporizhzhe
	0x002c3a4c, // n0x1d7b c0x0000 (---------------)  + I zaporizhzhia
	0x00230c08, // n0x1d7c c0x0000 (---------------)  + I zhitomir
	0x002fd008, // n0x1d7d c0x0000 (---------------)  + I zhytomyr
	0x00264682, // n0x1d7e c0x0000 (---------------)  + I zp
	0x00219b02, // n0x1d7f c0x0000 (---------------)  + I zt
	0x00201542, // n0x1d80 c0x0000 (---------------)  + I ac
	0x000ffa08, // n0x1d81 c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x1d82 c0x0000 (---------------)  + I co
	0x00233503, // n0x1d83 c0x0000 (---------------)  + I com
	0x00202d42, // n0x1d84 c0x0000 (---------------)  + I go
	0x00202c02, // n0x1d85 c0x0000 (---------------)  + I ne
	0x00200282, // n0x1d86 c0x0000 (---------------)  + I or
	0x0022d1c3, // n0x1d87 c0x0000 (---------------)  + I org
	0x00200702, // n0x1d88 c0x0000 (---------------)  + I sc
	0x00201542, // n0x1d89 c0x0000 (---------------)  + I ac
	0x54e00742, // n0x1d8a c0x0153 (n0x1d94-n0x1d95)  + I co
	0x5526cc83, // n0x1d8b c0x0154 (n0x1d95-n0x1d96)  + I gov
	0x00322cc3, // n0x1d8c c0x0000 (---------------)  + I ltd
	0x00203e82, // n0x1d8d c0x0000 (---------------)  + I me
	0x0021fe03, // n0x1d8e c0x0000 (---------------)  + I net
	0x0038eb83, // n0x1d8f c0x0000 (---------------)  + I nhs
	0x0022d1c3, // n0x1d90 c0x0000 (---------------)  + I org
	0x002db143, // n0x1d91 c0x0000 (---------------)  + I plc
	0x00225d06, // n0x1d92 c0x0000 (---------------)  + I police
	0x01617443, // n0x1d93 c0x0005 (---------------)* o I sch
	0x000ffa08, // n0x1d94 c0x0000 (---------------)  +   blogspot
	0x00006807, // n0x1d95 c0x0000 (---------------)  +   service
	0x55a01dc2, // n0x1d96 c0x0156 (n0x1dd5-n0x1dd8)  + I ak
	0x55e001c2, // n0x1d97 c0x0157 (n0x1dd8-n0x1ddb)  + I al
	0x56200a42, // n0x1d98 c0x0158 (n0x1ddb-n0x1dde)  + I ar
	0x56601d42, // n0x1d99 c0x0159 (n0x1dde-n0x1de1)  + I as
	0x56a05f42, // n0x1d9a c0x015a (n0x1de1-n0x1de4)  + I az
	0x56e00302, // n0x1d9b c0x015b (n0x1de4-n0x1de7)  + I ca
	0x57200742, // n0x1d9c c0x015c (n0x1de7-n0x1dea)  + I co
	0x57631382, // n0x1d9d c0x015d (n0x1dea-n0x1ded)  + I ct
	0x57a1fb42, // n0x1d9e c0x015e (n0x1ded-n0x1df0)  + I dc
	0x57e04d82, // n0x1d9f c0x015f (n0x1df0-n0x1df3)  + I de
	0x00271483, // n0x1da0 c0x0000 (---------------)  + I dni
	0x00211503, // n0x1da1 c0x0000 (---------------)  + I fed
	0x582175c2, // n0x1da2 c0x0160 (n0x1df3-n0x1df6)  + I fl
	0x58601042, // n0x1da3 c0x0161 (n0x1df6-n0x1df9)  + I ga
	0x58a0dd42, // n0x1da4 c0x0162 (n0x1df9-n0x1dfc)  + I gu
	0x58e00d82, // n0x1da5 c0x0163 (n0x1dfc-n0x1dfe)  + I hi
	0x59207682, // n0x1da6 c0x0164 (n0x1dfe-n0x1e01)  + I ia
	0x5960c782, // n0x1da7 c0x0165 (n0x1e01-n0x1e04)  + I id
	0x59a02902, // n0x1da8 c0x0166 (n0x1e04-n0x1e07)  + I il
	0x59e013c2, // n0x1da9 c0x0167 (n0x1e07-n0x1e0a)  + I in
	0x000b8d45, // n0x1daa c0x0000 (---------------)  +   is-by
	0x00223543, // n0x1dab c0x0000 (---------------)  + I isa
	0x0028cd44, // n0x1dac c0x0000 (---------------)  + I kids
	0x5a254e42, // n0x1dad c0x0168 (n0x1e0a-n0x1e0d)  + I ks
	0x5a636902, // n0x1dae c0x0169 (n0x1e0d-n0x1e10)  + I ky
	0x5aa00802, // n0x1daf c0x016a (n0x1e10-n0x1e13)  + I la
	0x0007958b, // n0x1db0 c0x0000 (---------------)  +   land-4-sale
	0x5ae00182, // n0x1db1 c0x016b (n0x1e13-n0x1e16)  + I ma
	0x5b64da82, // n0x1db2 c0x016d (n0x1e19-n0x1e1c)  + I md
	0x5ba03e82, // n0x1db3 c0x016e (n0x1e1c-n0x1e1f)  + I me
	0x5be09002, // n0x1db4 c0x016f (n0x1e1f-n0x1e22)  + I mi
	0x5c21fdc2, // n0x1db5 c0x0170 (n0x1e22-n0x1e25)  + I mn
	0x5c607102, // n0x1db6 c0x0171 (n0x1e25-n0x1e28)  + I mo
	0x5ca0f702, // n0x1db7 c0x0172 (n0x1e28-n0x1e2b)  + I ms
	0x5ce04c02, // n0x1db8 c0x0173 (n0x1e2b-n0x1e2e)  + I mt
	0x5d200642, // n0x1db9 c0x0174 (n0x1e2e-n0x1e31)  + I nc
	0x5d600882, // n0x1dba c0x0175 (n0x1e31-n0x1e33)  + I nd
	0x5da02c02, // n0x1dbb c0x0176 (n0x1e33-n0x1e36)  + I ne
	0x5de03382, // n0x1dbc c0x0177 (n0x1e36-n0x1e39)  + I nh
	0x5e204002, // n0x1dbd c0x0178 (n0x1e39-n0x1e3c)  + I nj
	0x5e63db02, // n0x1dbe c0x0179 (n0x1e3c-n0x1e3f)  + I nm
	0x002e0f43, // n0x1dbf c0x0000 (---------------)  + I nsn
	0x5ea03d42, // n0x1dc0 c0x017a (n0x1e3f-n0x1e42)  + I nv
	0x5ee15842, // n0x1dc1 c0x017b (n0x1e42-n0x1e45)  + I ny
	0x5f207382, // n0x1dc2 c0x017c (n0x1e45-n0x1e48)  + I oh
	0x5f601b82, // n0x1dc3 c0x017d (n0x1e48-n0x1e4b)  + I ok
	0x5fa00282, // n0x1dc4 c0x017e (n0x1e4b-n0x1e4e)  + I or
	0x5fe0ac42, // n0x1dc5 c0x017f (n0x1e4e-n0x1e51)  + I pa
	0x60204602, // n0x1dc6 c0x0180 (n0x1e51-n0x1e54)  + I pr
	0x60600a82, // n0x1dc7 c0x0181 (n0x1e54-n0x1e57)  + I ri
	0x60a00702, // n0x1dc8 c0x0182 (n0x1e57-n0x1e5a)  + I sc
	0x60e496c2, // n0x1dc9 c0x0183 (n0x1e5a-n0x1e5c)  + I sd
	0x000e868c, // n0x1dca c0x0000 (---------------)  +   stuff-4-sale
	0x6124f882, // n0x1dcb c0x0184 (n0x1e5c-n0x1e5f)  + I tn
	0x61673442, // n0x1dcc c0x0185 (n0x1e5f-n0x1e62)  + I tx
	0x61a03b02, // n0x1dcd c0x0186 (n0x1e62-n0x1e65)  + I ut
	0x61e000c2, // n0x1dce c0x0187 (n0x1e65-n0x1e68)  + I va
	0x62205d42, // n0x1dcf c0x0188 (n0x1e68-n0x1e6b)  + I vi
	0x62671f82, // n0x1dd0 c0x0189 (n0x1e6b-n0x1e6e)  + I vt
	0x62a010c2, // n0x1dd1 c0x018a (n0x1e6e-n0x1e71)  + I wa
	0x62e0ae82, // n0x1dd2 c0x018b (n0x1e71-n0x1e74)  + I wi
	0x632755c2, // n0x1dd3 c0x018c (n0x1e74-n0x1e75)  + I wv
	0x63674502, // n0x1dd4 c0x018d (n0x1e75-n0x1e78)  + I wy
	0x0022e182, // n0x1dd5 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1dd6 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1dd7 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1dd8 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1dd9 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1dda c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1ddb c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1ddc c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1ddd c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1dde c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1ddf c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1de0 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1de1 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1de2 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1de3 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1de4 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1de5 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1de6 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1de7 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1de8 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1de9 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1dea c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1deb c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1dec c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1ded c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1dee c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1def c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1df0 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1df1 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1df2 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1df3 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1df4 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1df5 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1df6 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1df7 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1df8 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1df9 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1dfa c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1dfb c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1dfc c0x0000 (---------------)  + I cc
	0x0027b703, // n0x1dfd c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1dfe c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1dff c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e00 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e01 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e02 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e03 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e04 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e05 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e06 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e07 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e08 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e09 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e0a c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e0b c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e0c c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e0d c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e0e c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e0f c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e10 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e11 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e12 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e13 c0x0000 (---------------)  + I cc
	0x5b309ac3, // n0x1e14 c0x016c (n0x1e16-n0x1e19)  + I k12
	0x0027b703, // n0x1e15 c0x0000 (---------------)  + I lib
	0x0022a644, // n0x1e16 c0x0000 (---------------)  + I chtr
	0x00289786, // n0x1e17 c0x0000 (---------------)  + I paroch
	0x002e5543, // n0x1e18 c0x0000 (---------------)  + I pvt
	0x0022e182, // n0x1e19 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e1a c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e1b c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e1c c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e1d c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e1e c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e1f c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e20 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e21 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e22 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e23 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e24 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e25 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e26 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e27 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e28 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e29 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e2a c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e2b c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e2c c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e2d c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e2e c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e2f c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e30 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e31 c0x0000 (---------------)  + I cc
	0x0027b703, // n0x1e32 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e33 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e34 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e35 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e36 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e37 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e38 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e39 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e3a c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e3b c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e3c c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e3d c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e3e c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e3f c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e40 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e41 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e42 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e43 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e44 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e45 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e46 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e47 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e48 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e49 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e4a c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e4b c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e4c c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e4d c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e4e c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e4f c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e50 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e51 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e52 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e53 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e54 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e55 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e56 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e57 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e58 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e59 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e5a c0x0000 (---------------)  + I cc
	0x0027b703, // n0x1e5b c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e5c c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e5d c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e5e c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e5f c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e60 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e61 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e62 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e63 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e64 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e65 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e66 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e67 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e68 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e69 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e6a c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e6b c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e6c c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e6d c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e6e c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e6f c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e70 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e71 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e72 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e73 c0x0000 (---------------)  + I lib
	0x0022e182, // n0x1e74 c0x0000 (---------------)  + I cc
	0x0022e182, // n0x1e75 c0x0000 (---------------)  + I cc
	0x00309ac3, // n0x1e76 c0x0000 (---------------)  + I k12
	0x0027b703, // n0x1e77 c0x0000 (---------------)  + I lib
	0x63e33503, // n0x1e78 c0x018f (n0x1e7e-n0x1e7f)  + I com
	0x0023a783, // n0x1e79 c0x0000 (---------------)  + I edu
	0x0024a483, // n0x1e7a c0x0000 (---------------)  + I gub
	0x00209003, // n0x1e7b c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1e7c c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1e7d c0x0000 (---------------)  + I org
	0x000ffa08, // n0x1e7e c0x0000 (---------------)  +   blogspot
	0x00200742, // n0x1e7f c0x0000 (---------------)  + I co
	0x00233503, // n0x1e80 c0x0000 (---------------)  + I com
	0x0021fe03, // n0x1e81 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1e82 c0x0000 (---------------)  + I org
	0x00233503, // n0x1e83 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1e84 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1e85 c0x0000 (---------------)  + I gov
	0x00209003, // n0x1e86 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1e87 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1e88 c0x0000 (---------------)  + I org
	0x0024bf84, // n0x1e89 c0x0000 (---------------)  + I arts
	0x00200742, // n0x1e8a c0x0000 (---------------)  + I co
	0x00233503, // n0x1e8b c0x0000 (---------------)  + I com
	0x00328c03, // n0x1e8c c0x0000 (---------------)  + I e12
	0x0023a783, // n0x1e8d c0x0000 (---------------)  + I edu
	0x0024d9c4, // n0x1e8e c0x0000 (---------------)  + I firm
	0x00213183, // n0x1e8f c0x0000 (---------------)  + I gob
	0x0026cc83, // n0x1e90 c0x0000 (---------------)  + I gov
	0x003a1244, // n0x1e91 c0x0000 (---------------)  + I info
	0x00201603, // n0x1e92 c0x0000 (---------------)  + I int
	0x00209003, // n0x1e93 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1e94 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1e95 c0x0000 (---------------)  + I org
	0x0022a5c3, // n0x1e96 c0x0000 (---------------)  + I rec
	0x00391185, // n0x1e97 c0x0000 (---------------)  + I store
	0x002d59c3, // n0x1e98 c0x0000 (---------------)  + I tec
	0x00221a03, // n0x1e99 c0x0000 (---------------)  + I web
	0x00200742, // n0x1e9a c0x0000 (---------------)  + I co
	0x00233503, // n0x1e9b c0x0000 (---------------)  + I com
	0x00309ac3, // n0x1e9c c0x0000 (---------------)  + I k12
	0x0021fe03, // n0x1e9d c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1e9e c0x0000 (---------------)  + I org
	0x00201542, // n0x1e9f c0x0000 (---------------)  + I ac
	0x00330b83, // n0x1ea0 c0x0000 (---------------)  + I biz
	0x000ffa08, // n0x1ea1 c0x0000 (---------------)  +   blogspot
	0x00233503, // n0x1ea2 c0x0000 (---------------)  + I com
	0x0023a783, // n0x1ea3 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1ea4 c0x0000 (---------------)  + I gov
	0x0036b386, // n0x1ea5 c0x0000 (---------------)  + I health
	0x003a1244, // n0x1ea6 c0x0000 (---------------)  + I info
	0x00201603, // n0x1ea7 c0x0000 (---------------)  + I int
	0x00205284, // n0x1ea8 c0x0000 (---------------)  + I name
	0x0021fe03, // n0x1ea9 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1eaa c0x0000 (---------------)  + I org
	0x00220e43, // n0x1eab c0x0000 (---------------)  + I pro
	0x00233503, // n0x1eac c0x0000 (---------------)  + I com
	0x0023a783, // n0x1ead c0x0000 (---------------)  + I edu
	0x0021fe03, // n0x1eae c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1eaf c0x0000 (---------------)  + I org
	0x00233503, // n0x1eb0 c0x0000 (---------------)  + I com
	0x00013886, // n0x1eb1 c0x0000 (---------------)  +   dyndns
	0x0023a783, // n0x1eb2 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1eb3 c0x0000 (---------------)  + I gov
	0x000d0d86, // n0x1eb4 c0x0000 (---------------)  +   mypets
	0x0021fe03, // n0x1eb5 c0x0000 (---------------)  + I net
	0x0022d1c3, // n0x1eb6 c0x0000 (---------------)  + I org
	0x00309e08, // n0x1eb7 c0x0000 (---------------)  + I xn--80au
	0x0030c549, // n0x1eb8 c0x0000 (---------------)  + I xn--90azh
	0x00318cc9, // n0x1eb9 c0x0000 (---------------)  + I xn--c1avg
	0x00329088, // n0x1eba c0x0000 (---------------)  + I xn--d1at
	0x00374908, // n0x1ebb c0x0000 (---------------)  + I xn--o1ac
	0x00374909, // n0x1ebc c0x0000 (---------------)  + I xn--o1ach
	0x00201542, // n0x1ebd c0x0000 (---------------)  + I ac
	0x00209c85, // n0x1ebe c0x0000 (---------------)  + I agric
	0x0023adc3, // n0x1ebf c0x0000 (---------------)  + I alt
	0x66600742, // n0x1ec0 c0x0199 (n0x1ece-n0x1ecf)  + I co
	0x0023a783, // n0x1ec1 c0x0000 (---------------)  + I edu
	0x0026cc83, // n0x1ec2 c0x0000 (---------------)  + I gov
	0x0027d907, // n0x1ec3 c0x0000 (---------------)  + I grondar
	0x00274483, // n0x1ec4 c0x0000 (---------------)  + I law
	0x00209003, // n0x1ec5 c0x0000 (---------------)  + I mil
	0x0021fe03, // n0x1ec6 c0x0000 (---------------)  + I net
	0x00202d03, // n0x1ec7 c0x0000 (---------------)  + I ngo
	0x00211803, // n0x1ec8 c0x0000 (---------------)  + I nis
	0x00201483, // n0x1ec9 c0x0000 (---------------)  + I nom
	0x0022d1c3, // n0x1eca c0x0000 (---------------)  + I org
	0x0023d0c6, // n0x1ecb c0x0000 (---------------)  + I school
	0x00200142, // n0x1ecc c0x0000 (---------------)  + I tm
	0x00221a03, // n0x1ecd c0x0000 (---------------)  + I web
	0x000ffa08, // n0x1ece c0x0000 (---------------)  +   blogspot
}

// children is the list of nodes' children, the parent's wildcard bit and the
// parent's node type. If a node has no children then their children index
// will be in the range [0, 6), depending on the wildcard bit and node type.
//
// The layout within the uint32, from MSB to LSB, is:
//	[ 1 bits] unused
//	[ 1 bits] wildcard bit
//	[ 2 bits] node type
//	[14 bits] high nodes index (exclusive) of children
//	[14 bits] low nodes index (inclusive) of children
var children = [...]uint32{
	0x00000000, // c0x0000 (---------------)  +
	0x10000000, // c0x0001 (---------------)  !
	0x20000000, // c0x0002 (---------------)  o
	0x40000000, // c0x0003 (---------------)* +
	0x50000000, // c0x0004 (---------------)* !
	0x60000000, // c0x0005 (---------------)* o
	0x0183c609, // c0x0006 (n0x0609-n0x060f)  +
	0x0184060f, // c0x0007 (n0x060f-n0x0610)  +
	0x01860610, // c0x0008 (n0x0610-n0x0618)  +
	0x019bc618, // c0x0009 (n0x0618-n0x066f)  +
	0x019d066f, // c0x000a (n0x066f-n0x0674)  +
	0x019e4674, // c0x000b (n0x0674-n0x0679)  +
	0x019f4679, // c0x000c (n0x0679-n0x067d)  +
	0x01a1067d, // c0x000d (n0x067d-n0x0684)  +
	0x01a14684, // c0x000e (n0x0684-n0x0685)  +
	0x01a2c685, // c0x000f (n0x0685-n0x068b)  +
	0x01a5068b, // c0x0010 (n0x068b-n0x0694)  +
	0x01a54694, // c0x0011 (n0x0694-n0x0695)  +
	0x01a6c695, // c0x0012 (n0x0695-n0x069b)  +
	0x01a7069b, // c0x0013 (n0x069b-n0x069c)  +
	0x01a8c69c, // c0x0014 (n0x069c-n0x06a3)  +
	0x01a906a3, // c0x0015 (n0x06a3-n0x06a4)  +
	0x01ad86a4, // c0x0016 (n0x06a4-n0x06b6)  +
	0x01adc6b6, // c0x0017 (n0x06b6-n0x06b7)  +
	0x01afc6b7, // c0x0018 (n0x06b7-n0x06bf)  +
	0x01b106bf, // c0x0019 (n0x06bf-n0x06c4)  +
	0x01b146c4, // c0x001a (n0x06c4-n0x06c5)  +
	0x01b446c5, // c0x001b (n0x06c5-n0x06d1)  +
	0x01b706d1, // c0x001c (n0x06d1-n0x06dc)  +
	0x01b986dc, // c0x001d (n0x06dc-n0x06e6)  +
	0x01ba06e6, // c0x001e (n0x06e6-n0x06e8)  +
	0x01ba46e8, // c0x001f (n0x06e8-n0x06e9)  +
	0x01c386e9, // c0x0020 (n0x06e9-n0x070e)  +
	0x01c4c70e, // c0x0021 (n0x070e-n0x0713)  +
	0x01c60713, // c0x0022 (n0x0713-n0x0718)  +
	0x01c80718, // c0x0023 (n0x0718-n0x0720)  +
	0x01c90720, // c0x0024 (n0x0720-n0x0724)  +
	0x01ca4724, // c0x0025 (n0x0724-n0x0729)  +
	0x01cc8729, // c0x0026 (n0x0729-n0x0732)  +
	0x01de0732, // c0x0027 (n0x0732-n0x0778)  +
	0x01de4778, // c0x0028 (n0x0778-n0x0779)  +
	0x01df8779, // c0x0029 (n0x0779-n0x077e)  +
	0x01e0c77e, // c0x002a (n0x077e-n0x0783)  +
	0x01e14783, // c0x002b (n0x0783-n0x0785)  +
	0x01e24785, // c0x002c (n0x0785-n0x0789)  +
	0x01e28789, // c0x002d (n0x0789-n0x078a)  +
	0x01e4078a, // c0x002e (n0x078a-n0x0790)  +
	0x01e84790, // c0x002f (n0x0790-n0x07a1)  +
	0x01e947a1, // c0x0030 (n0x07a1-n0x07a5)  +
	0x01e987a5, // c0x0031 (n0x07a5-n0x07a6)  +
	0x01e9c7a6, // c0x0032 (n0x07a6-n0x07a7)  +
	0x01ea07a7, // c0x0033 (n0x07a7-n0x07a8)  +
	0x01edc7a8, // c0x0034 (n0x07a8-n0x07b7)  +
	0x61ee07b7, // c0x0035 (n0x07b7-n0x07b8)* o
	0x01ef47b8, // c0x0036 (n0x07b8-n0x07bd)  +
	0x01f047bd, // c0x0037 (n0x07bd-n0x07c1)  +
	0x01fb87c1, // c0x0038 (n0x07c1-n0x07ee)  +
	0x21fbc7ee, // c0x0039 (n0x07ee-n0x07ef)  o
	0x01fc07ef, // c0x003a (n0x07ef-n0x07f0)  +
	0x01fc47f0, // c0x003b (n0x07f0-n0x07f1)  +
	0x21fc87f1, // c0x003c (n0x07f1-n0x07f2)  o
	0x21fcc7f2, // c0x003d (n0x07f2-n0x07f3)  o
	0x020007f3, // c0x003e (n0x07f3-n0x0800)  +
	0x02004800, // c0x003f (n0x0800-n0x0801)  +
	0x0235c801, // c0x0040 (n0x0801-n0x08d7)  +
	0x223ac8d7, // c0x0041 (n0x08d7-n0x08eb)  o
	0x223b08eb, // c0x0042 (n0x08eb-n0x08ec)  o
	0x023d88ec, // c0x0043 (n0x08ec-n0x08f6)  +
	0x023e08f6, // c0x0044 (n0x08f6-n0x08f8)  +
	0x223e48f8, // c0x0045 (n0x08f8-n0x08f9)  o
	0x223e88f9, // c0x0046 (n0x08f9-n0x08fa)  o
	0x023f48fa, // c0x0047 (n0x08fa-n0x08fd)  +
	0x223f88fd, // c0x0048 (n0x08fd-n0x08fe)  o
	0x024148fe, // c0x0049 (n0x08fe-n0x0905)  +
	0x0242c905, // c0x004a (n0x0905-n0x090b)  +
	0x0243090b, // c0x004b (n0x090b-n0x090c)  +
	0x0244090c, // c0x004c (n0x090c-n0x0910)  +
	0x02448910, // c0x004d (n0x0910-n0x0912)  +
	0x2247c912, // c0x004e (n0x0912-n0x091f)  o
	0x0248091f, // c0x004f (n0x091f-n0x0920)  +
	0x02488920, // c0x0050 (n0x0920-n0x0922)  +
	0x024a8922, // c0x0051 (n0x0922-n0x092a)  +
	0x024ac92a, // c0x0052 (n0x092a-n0x092b)  +
	0x024c092b, // c0x0053 (n0x092b-n0x0930)  +
	0x024e8930, // c0x0054 (n0x0930-n0x093a)  +
	0x0250893a, // c0x0055 (n0x093a-n0x0942)  +
	0x02538942, // c0x0056 (n0x0942-n0x094e)  +
	0x0256094e, // c0x0057 (n0x094e-n0x0958)  +
	0x02564958, // c0x0058 (n0x0958-n0x0959)  +
	0x02588959, // c0x0059 (n0x0959-n0x0962)  +
	0x0258c962, // c0x005a (n0x0962-n0x0963)  +
	0x025a0963, // c0x005b (n0x0963-n0x0968)  +
	0x025a4968, // c0x005c (n0x0968-n0x0969)  +
	0x025c4969, // c0x005d (n0x0969-n0x0971)  +
	0x025d0971, // c0x005e (n0x0971-n0x0974)  +
	0x02630974, // c0x005f (n0x0974-n0x098c)  +
	0x0264c98c, // c0x0060 (n0x098c-n0x0993)  +
	0x02658993, // c0x0061 (n0x0993-n0x0996)  +
	0x0266c996, // c0x0062 (n0x0996-n0x099b)  +
	0x0268499b, // c0x0063 (n0x099b-n0x09a1)  +
	0x026989a1, // c0x0064 (n0x09a1-n0x09a6)  +
	0x026b09a6, // c0x0065 (n0x09a6-n0x09ac)  +
	0x026c89ac, // c0x0066 (n0x09ac-n0x09b2)  +
	0x026e09b2, // c0x0067 (n0x09b2-n0x09b8)  +
	0x026fc9b8, // c0x0068 (n0x09b8-n0x09bf)  +
	0x027149bf, // c0x0069 (n0x09bf-n0x09c5)  +
	0x027749c5, // c0x006a (n0x09c5-n0x09dd)  +
	0x0278c9dd, // c0x006b (n0x09dd-n0x09e3)  +
	0x027a09e3, // c0x006c (n0x09e3-n0x09e8)  +
	0x027e49e8, // c0x006d (n0x09e8-n0x09f9)  +
	0x028649f9, // c0x006e (n0x09f9-n0x0a19)  +
	0x02890a19, // c0x006f (n0x0a19-n0x0a24)  +
	0x02894a24, // c0x0070 (n0x0a24-n0x0a25)  +
	0x0289ca25, // c0x0071 (n0x0a25-n0x0a27)  +
	0x028bca27, // c0x0072 (n0x0a27-n0x0a2f)  +
	0x028c0a2f, // c0x0073 (n0x0a2f-n0x0a30)  +
	0x028dca30, // c0x0074 (n0x0a30-n0x0a37)  +
	0x028e4a37, // c0x0075 (n0x0a37-n0x0a39)  +
	0x02918a39, // c0x0076 (n0x0a39-n0x0a46)  +
	0x02940a46, // c0x0077 (n0x0a46-n0x0a50)  +
	0x02944a50, // c0x0078 (n0x0a50-n0x0a51)  +
	0x0295ca51, // c0x0079 (n0x0a51-n0x0a57)  +
	0x02974a57, // c0x007a (n0x0a57-n0x0a5d)  +
	0x02998a5d, // c0x007b (n0x0a5d-n0x0a66)  +
	0x029b8a66, // c0x007c (n0x0a66-n0x0a6e)  +
	0x02f7ca6e, // c0x007d (n0x0a6e-n0x0bdf)  +
	0x02f88bdf, // c0x007e (n0x0bdf-n0x0be2)  +
	0x02fa8be2, // c0x007f (n0x0be2-n0x0bea)  +
	0x03164bea, // c0x0080 (n0x0bea-n0x0c59)  +
	0x03234c59, // c0x0081 (n0x0c59-n0x0c8d)  +
	0x032a4c8d, // c0x0082 (n0x0c8d-n0x0ca9)  +
	0x032fcca9, // c0x0083 (n0x0ca9-n0x0cbf)  +
	0x033e4cbf, // c0x0084 (n0x0cbf-n0x0cf9)  +
	0x0343ccf9, // c0x0085 (n0x0cf9-n0x0d0f)  +
	0x03478d0f, // c0x0086 (n0x0d0f-n0x0d1e)  +
	0x03574d1e, // c0x0087 (n0x0d1e-n0x0d5d)  +
	0x03640d5d, // c0x0088 (n0x0d5d-n0x0d90)  +
	0x036d8d90, // c0x0089 (n0x0d90-n0x0db6)  +
	0x03768db6, // c0x008a (n0x0db6-n0x0dda)  +
	0x037ccdda, // c0x008b (n0x0dda-n0x0df3)  +
	0x03a04df3, // c0x008c (n0x0df3-n0x0e81)  +
	0x03abce81, // c0x008d (n0x0e81-n0x0eaf)  +
	0x03b88eaf, // c0x008e (n0x0eaf-n0x0ee2)  +
	0x03bd4ee2, // c0x008f (n0x0ee2-n0x0ef5)  +
	0x03c5cef5, // c0x0090 (n0x0ef5-n0x0f17)  +
	0x03c98f17, // c0x0091 (n0x0f17-n0x0f26)  +
	0x03ce8f26, // c0x0092 (n0x0f26-n0x0f3a)  +
	0x03d60f3a, // c0x0093 (n0x0f3a-n0x0f58)  +
	0x63d64f58, // c0x0094 (n0x0f58-n0x0f59)* o
	0x63d68f59, // c0x0095 (n0x0f59-n0x0f5a)* o
	0x63d6cf5a, // c0x0096 (n0x0f5a-n0x0f5b)* o
	0x03de8f5b, // c0x0097 (n0x0f5b-n0x0f7a)  +
	0x03e50f7a, // c0x0098 (n0x0f7a-n0x0f94)  +
	0x03eccf94, // c0x0099 (n0x0f94-n0x0fb3)  +
	0x03f44fb3, // c0x009a (n0x0fb3-n0x0fd1)  +
	0x03fc8fd1, // c0x009b (n0x0fd1-n0x0ff2)  +
	0x04034ff2, // c0x009c (n0x0ff2-n0x100d)  +
	0x0416100d, // c0x009d (n0x100d-n0x1058)  +
	0x041b9058, // c0x009e (n0x1058-n0x106e)  +
	0x641bd06e, // c0x009f (n0x106e-n0x106f)* o
	0x0425506f, // c0x00a0 (n0x106f-n0x1095)  +
	0x042dd095, // c0x00a1 (n0x1095-n0x10b7)  +
	0x043290b7, // c0x00a2 (n0x10b7-n0x10ca)  +
	0x043910ca, // c0x00a3 (n0x10ca-n0x10e4)  +
	0x044390e4, // c0x00a4 (n0x10e4-n0x110e)  +
	0x0450110e, // c0x00a5 (n0x110e-n0x1140)  +
	0x04569140, // c0x00a6 (n0x1140-n0x115a)  +
	0x0467d15a, // c0x00a7 (n0x115a-n0x119f)  +
	0x6468119f, // c0x00a8 (n0x119f-n0x11a0)* o
	0x646851a0, // c0x00a9 (n0x11a0-n0x11a1)* o
	0x046e11a1, // c0x00aa (n0x11a1-n0x11b8)  +
	0x0473d1b8, // c0x00ab (n0x11b8-n0x11cf)  +
	0x047cd1cf, // c0x00ac (n0x11cf-n0x11f3)  +
	0x048491f3, // c0x00ad (n0x11f3-n0x1212)  +
	0x0488d212, // c0x00ae (n0x1212-n0x1223)  +
	0x04971223, // c0x00af (n0x1223-n0x125c)  +
	0x049a525c, // c0x00b0 (n0x125c-n0x1269)  +
	0x04a05269, // c0x00b1 (n0x1269-n0x1281)  +
	0x04a79281, // c0x00b2 (n0x1281-n0x129e)  +
	0x04b0129e, // c0x00b3 (n0x129e-n0x12c0)  +
	0x04b412c0, // c0x00b4 (n0x12c0-n0x12d0)  +
	0x04bb12d0, // c0x00b5 (n0x12d0-n0x12ec)  +
	0x64bb52ec, // c0x00b6 (n0x12ec-n0x12ed)* o
	0x64bb92ed, // c0x00b7 (n0x12ed-n0x12ee)* o
	0x24bbd2ee, // c0x00b8 (n0x12ee-n0x12ef)  o
	0x04bd52ef, // c0x00b9 (n0x12ef-n0x12f5)  +
	0x04bf12f5, // c0x00ba (n0x12f5-n0x12fc)  +
	0x04c352fc, // c0x00bb (n0x12fc-n0x130d)  +
	0x04c4530d, // c0x00bc (n0x130d-n0x1311)  +
	0x04c5d311, // c0x00bd (n0x1311-n0x1317)  +
	0x04cd5317, // c0x00be (n0x1317-n0x1335)  +
	0x04ce9335, // c0x00bf (n0x1335-n0x133a)  +
	0x04d0133a, // c0x00c0 (n0x133a-n0x1340)  +
	0x04d25340, // c0x00c1 (n0x1340-n0x1349)  +
	0x04d39349, // c0x00c2 (n0x1349-n0x134e)  +
	0x04d5134e, // c0x00c3 (n0x134e-n0x1354)  +
	0x04d55354, // c0x00c4 (n0x1354-n0x1355)  +
	0x04d91355, // c0x00c5 (n0x1355-n0x1364)  +
	0x04da5364, // c0x00c6 (n0x1364-n0x1369)  +
	0x04dad369, // c0x00c7 (n0x1369-n0x136b)  +
	0x04db536b, // c0x00c8 (n0x136b-n0x136d)  +
	0x04db936d, // c0x00c9 (n0x136d-n0x136e)  +
	0x04ddd36e, // c0x00ca (n0x136e-n0x1377)  +
	0x04e01377, // c0x00cb (n0x1377-n0x1380)  +
	0x04e19380, // c0x00cc (n0x1380-n0x1386)  +
	0x04e21386, // c0x00cd (n0x1386-n0x1388)  +
	0x04e25388, // c0x00ce (n0x1388-n0x1389)  +
	0x04e59389, // c0x00cf (n0x1389-n0x1396)  +
	0x04e7d396, // c0x00d0 (n0x1396-n0x139f)  +
	0x04e9d39f, // c0x00d1 (n0x139f-n0x13a7)  +
	0x04eb93a7, // c0x00d2 (n0x13a7-n0x13ae)  +
	0x04ec93ae, // c0x00d3 (n0x13ae-n0x13b2)  +
	0x04edd3b2, // c0x00d4 (n0x13b2-n0x13b7)  +
	0x04ee13b7, // c0x00d5 (n0x13b7-n0x13b8)  +
	0x04ee93b8, // c0x00d6 (n0x13b8-n0x13ba)  +
	0x04efd3ba, // c0x00d7 (n0x13ba-n0x13bf)  +
	0x04f0d3bf, // c0x00d8 (n0x13bf-n0x13c3)  +
	0x04f113c3, // c0x00d9 (n0x13c3-n0x13c4)  +
	0x04f2d3c4, // c0x00da (n0x13c4-n0x13cb)  +
	0x057bd3cb, // c0x00db (n0x13cb-n0x15ef)  +
	0x057f55ef, // c0x00dc (n0x15ef-n0x15fd)  +
	0x058215fd, // c0x00dd (n0x15fd-n0x1608)  +
	0x05839608, // c0x00de (n0x1608-n0x160e)  +
	0x0585960e, // c0x00df (n0x160e-n0x1616)  +
	0x6585d616, // c0x00e0 (n0x1616-n0x1617)* o
	0x058a1617, // c0x00e1 (n0x1617-n0x1628)  +
	0x058a9628, // c0x00e2 (n0x1628-n0x162a)  +
	0x258ad62a, // c0x00e3 (n0x162a-n0x162b)  o
	0x258b162b, // c0x00e4 (n0x162b-n0x162c)  o
	0x058b562c, // c0x00e5 (n0x162c-n0x162d)  +
	0x0598d62d, // c0x00e6 (n0x162d-n0x1663)  +
	0x25991663, // c0x00e7 (n0x1663-n0x1664)  o
	0x25999664, // c0x00e8 (n0x1664-n0x1666)  o
	0x259a1666, // c0x00e9 (n0x1666-n0x1668)  o
	0x259ad668, // c0x00ea (n0x1668-n0x166b)  o
	0x059d566b, // c0x00eb (n0x166b-n0x1675)  +
	0x059fd675, // c0x00ec (n0x1675-n0x167f)  +
	0x05a0167f, // c0x00ed (n0x167f-n0x1680)  +
	0x25a39680, // c0x00ee (n0x1680-n0x168e)  o
	0x05a4568e, // c0x00ef (n0x168e-n0x1691)  +
	0x0659d691, // c0x00f0 (n0x1691-n0x1967)  +
	0x065a1967, // c0x00f1 (n0x1967-n0x1968)  +
	0x065a5968, // c0x00f2 (n0x1968-n0x1969)  +
	0x265a9969, // c0x00f3 (n0x1969-n0x196a)  o
	0x065ad96a, // c0x00f4 (n0x196a-n0x196b)  +
	0x265b196b, // c0x00f5 (n0x196b-n0x196c)  o
	0x065b596c, // c0x00f6 (n0x196c-n0x196d)  +
	0x265c196d, // c0x00f7 (n0x196d-n0x1970)  o
	0x065c5970, // c0x00f8 (n0x1970-n0x1971)  +
	0x065c9971, // c0x00f9 (n0x1971-n0x1972)  +
	0x265cd972, // c0x00fa (n0x1972-n0x1973)  o
	0x065d1973, // c0x00fb (n0x1973-n0x1974)  +
	0x265d9974, // c0x00fc (n0x1974-n0x1976)  o
	0x065dd976, // c0x00fd (n0x1976-n0x1977)  +
	0x065e1977, // c0x00fe (n0x1977-n0x1978)  +
	0x265f1978, // c0x00ff (n0x1978-n0x197c)  o
	0x065f597c, // c0x0100 (n0x197c-n0x197d)  +
	0x065f997d, // c0x0101 (n0x197d-n0x197e)  +
	0x065fd97e, // c0x0102 (n0x197e-n0x197f)  +
	0x0660197f, // c0x0103 (n0x197f-n0x1980)  +
	0x26605980, // c0x0104 (n0x1980-n0x1981)  o
	0x06609981, // c0x0105 (n0x1981-n0x1982)  +
	0x0660d982, // c0x0106 (n0x1982-n0x1983)  +
	0x06611983, // c0x0107 (n0x1983-n0x1984)  +
	0x06615984, // c0x0108 (n0x1984-n0x1985)  +
	0x2661d985, // c0x0109 (n0x1985-n0x1987)  o
	0x06621987, // c0x010a (n0x1987-n0x1988)  +
	0x06625988, // c0x010b (n0x1988-n0x1989)  +
	0x06629989, // c0x010c (n0x1989-n0x198a)  +
	0x2662d98a, // c0x010d (n0x198a-n0x198b)  o
	0x0663198b, // c0x010e (n0x198b-n0x198c)  +
	0x2663998c, // c0x010f (n0x198c-n0x198e)  o
	0x2663d98e, // c0x0110 (n0x198e-n0x198f)  o
	0x0665998f, // c0x0111 (n0x198f-n0x1996)  +
	0x06665996, // c0x0112 (n0x1996-n0x1999)  +
	0x066a5999, // c0x0113 (n0x1999-n0x19a9)  +
	0x066a99a9, // c0x0114 (n0x19a9-n0x19aa)  +
	0x066cd9aa, // c0x0115 (n0x19aa-n0x19b3)  +
	0x067c19b3, // c0x0116 (n0x19b3-n0x19f0)  +
	0x267c99f0, // c0x0117 (n0x19f0-n0x19f2)  o
	0x267cd9f2, // c0x0118 (n0x19f2-n0x19f3)  o
	0x267d19f3, // c0x0119 (n0x19f3-n0x19f4)  o
	0x067d99f4, // c0x011a (n0x19f4-n0x19f6)  +
	0x068b59f6, // c0x011b (n0x19f6-n0x1a2d)  +
	0x068e1a2d, // c0x011c (n0x1a2d-n0x1a38)  +
	0x06901a38, // c0x011d (n0x1a38-n0x1a40)  +
	0x0690da40, // c0x011e (n0x1a40-n0x1a43)  +
	0x0692da43, // c0x011f (n0x1a43-n0x1a4b)  +
	0x06965a4b, // c0x0120 (n0x1a4b-n0x1a59)  +
	0x06bf9a59, // c0x0121 (n0x1a59-n0x1afe)  +
	0x06cb5afe, // c0x0122 (n0x1afe-n0x1b2d)  +
	0x06cc9b2d, // c0x0123 (n0x1b2d-n0x1b32)  +
	0x06cfdb32, // c0x0124 (n0x1b32-n0x1b3f)  +
	0x06d29b3f, // c0x0125 (n0x1b3f-n0x1b4a)  +
	0x06d45b4a, // c0x0126 (n0x1b4a-n0x1b51)  +
	0x06d69b51, // c0x0127 (n0x1b51-n0x1b5a)  +
	0x06d81b5a, // c0x0128 (n0x1b5a-n0x1b60)  +
	0x06d9db60, // c0x0129 (n0x1b60-n0x1b67)  +
	0x06dc1b67, // c0x012a (n0x1b67-n0x1b70)  +
	0x06dd1b70, // c0x012b (n0x1b70-n0x1b74)  +
	0x06e01b74, // c0x012c (n0x1b74-n0x1b80)  +
	0x06e1db80, // c0x012d (n0x1b80-n0x1b87)  +
	0x07029b87, // c0x012e (n0x1b87-n0x1c0a)  +
	0x0704dc0a, // c0x012f (n0x1c0a-n0x1c13)  +
	0x0706dc13, // c0x0130 (n0x1c13-n0x1c1b)  +
	0x07081c1b, // c0x0131 (n0x1c1b-n0x1c20)  +
	0x07095c20, // c0x0132 (n0x1c20-n0x1c25)  +
	0x070b5c25, // c0x0133 (n0x1c25-n0x1c2d)  +
	0x07159c2d, // c0x0134 (n0x1c2d-n0x1c56)  +
	0x07175c56, // c0x0135 (n0x1c56-n0x1c5d)  +
	0x07191c5d, // c0x0136 (n0x1c5d-n0x1c64)  +
	0x07195c64, // c0x0137 (n0x1c64-n0x1c65)  +
	0x07199c65, // c0x0138 (n0x1c65-n0x1c66)  +
	0x071adc66, // c0x0139 (n0x1c66-n0x1c6b)  +
	0x071cdc6b, // c0x013a (n0x1c6b-n0x1c73)  +
	0x071d9c73, // c0x013b (n0x1c73-n0x1c76)  +
	0x07209c76, // c0x013c (n0x1c76-n0x1c82)  +
	0x07289c82, // c0x013d (n0x1c82-n0x1ca2)  +
	0x0729dca2, // c0x013e (n0x1ca2-n0x1ca7)  +
	0x072a1ca7, // c0x013f (n0x1ca7-n0x1ca8)  +
	0x072b9ca8, // c0x0140 (n0x1ca8-n0x1cae)  +
	0x072c5cae, // c0x0141 (n0x1cae-n0x1cb1)  +
	0x072c9cb1, // c0x0142 (n0x1cb1-n0x1cb2)  +
	0x072e5cb2, // c0x0143 (n0x1cb2-n0x1cb9)  +
	0x07321cb9, // c0x0144 (n0x1cb9-n0x1cc8)  +
	0x07325cc8, // c0x0145 (n0x1cc8-n0x1cc9)  +
	0x07345cc9, // c0x0146 (n0x1cc9-n0x1cd1)  +
	0x07395cd1, // c0x0147 (n0x1cd1-n0x1ce5)  +
	0x073adce5, // c0x0148 (n0x1ce5-n0x1ceb)  +
	0x07401ceb, // c0x0149 (n0x1ceb-n0x1d00)  +
	0x07405d00, // c0x014a (n0x1d00-n0x1d01)  +
	0x07409d01, // c0x014b (n0x1d01-n0x1d02)  +
	0x0744dd02, // c0x014c (n0x1d02-n0x1d13)  +
	0x0745dd13, // c0x014d (n0x1d13-n0x1d17)  +
	0x07495d17, // c0x014e (n0x1d17-n0x1d25)  +
	0x074c5d25, // c0x014f (n0x1d25-n0x1d31)  +
	0x07601d31, // c0x0150 (n0x1d31-n0x1d80)  +
	0x07625d80, // c0x0151 (n0x1d80-n0x1d89)  +
	0x07651d89, // c0x0152 (n0x1d89-n0x1d94)  +
	0x07655d94, // c0x0153 (n0x1d94-n0x1d95)  +
	0x07659d95, // c0x0154 (n0x1d95-n0x1d96)  +
	0x07755d96, // c0x0155 (n0x1d96-n0x1dd5)  +
	0x07761dd5, // c0x0156 (n0x1dd5-n0x1dd8)  +
	0x0776ddd8, // c0x0157 (n0x1dd8-n0x1ddb)  +
	0x07779ddb, // c0x0158 (n0x1ddb-n0x1dde)  +
	0x07785dde, // c0x0159 (n0x1dde-n0x1de1)  +
	0x07791de1, // c0x015a (n0x1de1-n0x1de4)  +
	0x0779dde4, // c0x015b (n0x1de4-n0x1de7)  +
	0x077a9de7, // c0x015c (n0x1de7-n0x1dea)  +
	0x077b5dea, // c0x015d (n0x1dea-n0x1ded)  +
	0x077c1ded, // c0x015e (n0x1ded-n0x1df0)  +
	0x077cddf0, // c0x015f (n0x1df0-n0x1df3)  +
	0x077d9df3, // c0x0160 (n0x1df3-n0x1df6)  +
	0x077e5df6, // c0x0161 (n0x1df6-n0x1df9)  +
	0x077f1df9, // c0x0162 (n0x1df9-n0x1dfc)  +
	0x077f9dfc, // c0x0163 (n0x1dfc-n0x1dfe)  +
	0x07805dfe, // c0x0164 (n0x1dfe-n0x1e01)  +
	0x07811e01, // c0x0165 (n0x1e01-n0x1e04)  +
	0x0781de04, // c0x0166 (n0x1e04-n0x1e07)  +
	0x07829e07, // c0x0167 (n0x1e07-n0x1e0a)  +
	0x07835e0a, // c0x0168 (n0x1e0a-n0x1e0d)  +
	0x07841e0d, // c0x0169 (n0x1e0d-n0x1e10)  +
	0x0784de10, // c0x016a (n0x1e10-n0x1e13)  +
	0x07859e13, // c0x016b (n0x1e13-n0x1e16)  +
	0x07865e16, // c0x016c (n0x1e16-n0x1e19)  +
	0x07871e19, // c0x016d (n0x1e19-n0x1e1c)  +
	0x0787de1c, // c0x016e (n0x1e1c-n0x1e1f)  +
	0x07889e1f, // c0x016f (n0x1e1f-n0x1e22)  +
	0x07895e22, // c0x0170 (n0x1e22-n0x1e25)  +
	0x078a1e25, // c0x0171 (n0x1e25-n0x1e28)  +
	0x078ade28, // c0x0172 (n0x1e28-n0x1e2b)  +
	0x078b9e2b, // c0x0173 (n0x1e2b-n0x1e2e)  +
	0x078c5e2e, // c0x0174 (n0x1e2e-n0x1e31)  +
	0x078cde31, // c0x0175 (n0x1e31-n0x1e33)  +
	0x078d9e33, // c0x0176 (n0x1e33-n0x1e36)  +
	0x078e5e36, // c0x0177 (n0x1e36-n0x1e39)  +
	0x078f1e39, // c0x0178 (n0x1e39-n0x1e3c)  +
	0x078fde3c, // c0x0179 (n0x1e3c-n0x1e3f)  +
	0x07909e3f, // c0x017a (n0x1e3f-n0x1e42)  +
	0x07915e42, // c0x017b (n0x1e42-n0x1e45)  +
	0x07921e45, // c0x017c (n0x1e45-n0x1e48)  +
	0x0792de48, // c0x017d (n0x1e48-n0x1e4b)  +
	0x07939e4b, // c0x017e (n0x1e4b-n0x1e4e)  +
	0x07945e4e, // c0x017f (n0x1e4e-n0x1e51)  +
	0x07951e51, // c0x0180 (n0x1e51-n0x1e54)  +
	0x0795de54, // c0x0181 (n0x1e54-n0x1e57)  +
	0x07969e57, // c0x0182 (n0x1e57-n0x1e5a)  +
	0x07971e5a, // c0x0183 (n0x1e5a-n0x1e5c)  +
	0x0797de5c, // c0x0184 (n0x1e5c-n0x1e5f)  +
	0x07989e5f, // c0x0185 (n0x1e5f-n0x1e62)  +
	0x07995e62, // c0x0186 (n0x1e62-n0x1e65)  +
	0x079a1e65, // c0x0187 (n0x1e65-n0x1e68)  +
	0x079ade68, // c0x0188 (n0x1e68-n0x1e6b)  +
	0x079b9e6b, // c0x0189 (n0x1e6b-n0x1e6e)  +
	0x079c5e6e, // c0x018a (n0x1e6e-n0x1e71)  +
	0x079d1e71, // c0x018b (n0x1e71-n0x1e74)  +
	0x079d5e74, // c0x018c (n0x1e74-n0x1e75)  +
	0x079e1e75, // c0x018d (n0x1e75-n0x1e78)  +
	0x079f9e78, // c0x018e (n0x1e78-n0x1e7e)  +
	0x079fde7e, // c0x018f (n0x1e7e-n0x1e7f)  +
	0x07a0de7f, // c0x0190 (n0x1e7f-n0x1e83)  +
	0x07a25e83, // c0x0191 (n0x1e83-n0x1e89)  +
	0x07a69e89, // c0x0192 (n0x1e89-n0x1e9a)  +
	0x07a7de9a, // c0x0193 (n0x1e9a-n0x1e9f)  +
	0x07ab1e9f, // c0x0194 (n0x1e9f-n0x1eac)  +
	0x07ac1eac, // c0x0195 (n0x1eac-n0x1eb0)  +
	0x07addeb0, // c0x0196 (n0x1eb0-n0x1eb7)  +
	0x07af5eb7, // c0x0197 (n0x1eb7-n0x1ebd)  +
	0x27b39ebd, // c0x0198 (n0x1ebd-n0x1ece)  o
	0x07b3dece, // c0x0199 (n0x1ece-n0x1ecf)  +
}

// max children 409 (capacity 511)
// max text offset 27059 (capacity 32767)
// max text length 36 (capacity 63)
// max hi 7887 (capacity 16383)
// max lo 7886 (capacity 16383)
