/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class EscapeURI
extends SystemFunction {
    private static String allHexDigits = "0123456789abcdefABCDEF";
    private static final String hex = "0123456789ABCDEF";

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return new StringValue(this.asString(xPathContext));
    }

    private String asString(XPathContext xPathContext) throws XPathException {
        String string = this.argument[0].evaluateItem(xPathContext).getStringValue();
        AtomicValue atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        boolean bl = ((BooleanValue)atomicValue.getPrimitiveValue()).getValue();
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                stringBuffer.append(c);
            } else if (c <= ' ' || c >= '\u007f') {
                this.escape(c, n + 1 < string.length() ? string.charAt(n + 1) : (char)' ', stringBuffer);
            } else if (c == '%') {
                if (n + 2 < string.length() && allHexDigits.indexOf(string.charAt(n + 1)) >= 0 && allHexDigits.indexOf(string.charAt(n + 2)) >= 0) {
                    stringBuffer.append(c);
                } else {
                    this.escape(c, ' ', stringBuffer);
                }
            } else if (bl) {
                if ("-_.!~*'()".indexOf(c) >= 0) {
                    stringBuffer.append(c);
                } else {
                    this.escape(c, ' ', stringBuffer);
                }
            } else if ("-_.!~*'();/?:@&=+$,#[]".indexOf(c) >= 0) {
                stringBuffer.append(c);
            } else {
                this.escape(c, ' ', stringBuffer);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void escape(char c, char c2, StringBuffer stringBuffer) {
        byte[] byArray = new byte[4];
        int n = UnicodeCharacterSet.getUTF8Encoding(c, c2, byArray);
        int n2 = 0;
        while (n2 < n) {
            int n3 = byArray[n2] >= 0 ? byArray[n2] : 256 + byArray[n2];
            stringBuffer.append('%');
            stringBuffer.append(hex.charAt(n3 / 16));
            stringBuffer.append(hex.charAt(n3 % 16));
            ++n2;
        }
    }
}

