# Copyright (c) 2012 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'conditions': [
      ['(OS=="android" or chromeos==1) and target_arch=="arm"', {
        'use_opus_fixed_point%': 1,
        'use_opus_arm_optimization%': 1,
      }, {
        'use_opus_fixed_point%': 0,
        'use_opus_arm_optimization%': 0,
      }],
    ],
  },
  'targets': [
    {
      'target_name': 'opus',
      'type': 'static_library',
      'defines': [
        'OPUS_BUILD',
        'OPUS_EXPORT=',
      ],
      'include_dirs': [
        'src/celt',
        'src/include',
        'src/silk',
      ],
      'direct_dependent_settings': {
        'include_dirs': [
          'src/include',
        ],
      },
      'includes': ['opus_srcs.gypi', ],
      'conditions': [
        ['OS!="win"', {
          'defines': [
            'HAVE_LRINT',
            'HAVE_LRINTF',
            'VAR_ARRAYS',
          ],
        }, {
          'defines': [
            'USE_ALLOCA',
            'inline=__inline',
          ],
          'msvs_disabled_warnings': [
            4305,  # Disable truncation warning in celt/pitch.c .
            4334,  # Disable 32-bit shift warning in src/opus_encoder.c .
          ],
        }],
        [ 'os_posix==1 and OS!="android"', {
          'cflags': [
            # Suppress a warning given by opus_decoder.c that tells us
            # optimizations are turned off.
            '-Wno-#pragma-messages',
          ],
        }],
        ['use_opus_fixed_point==0', {
          'include_dirs': [
            'src/silk/float',
          ],
          'sources/': [
            ['exclude', '/fixed/[^/]*_FIX.(h|c)$'],
          ],
        }, {
          'defines': [
            'FIXED_POINT',
          ],
          'include_dirs': [
            'src/silk/fixed',
          ],
          'sources/': [
            ['exclude', '/float/[^/]*_FLP.(h|c)$'],
          ],
          'conditions': [
            ['use_opus_arm_optimization==1', {
              'defines': [
                'OPUS_ARM_ASM',
                'OPUS_ARM_INLINE_ASM',
                'OPUS_ARM_INLINE_EDSP',
                'OPUS_ARM_MAY_HAVE_EDSP',
                'OPUS_ARM_MAY_HAVE_MEDIA',
                'OPUS_ARM_MAY_HAVE_NEON',
                'OPUS_HAVE_RTCD',
              ],
              'includes': [
                'opus_srcs_arm.gypi',
              ],
            }],
          ],
        }],
      ],
    },  # target opus
    {
      'target_name': 'opus_demo',
      'type': 'executable',
      'dependencies': [
        'opus'
      ],
      'conditions': [
        ['OS == "win"', {
          'defines': [
            'inline=__inline',
          ],
        }],
        ['OS=="android"', {
          'link_settings': {
            'libraries': [
              '-llog',
            ],
          },
        }]
      ],
      'sources': [
        'src/src/opus_demo.c',
      ],
      'include_dirs': [
        'src/celt',
        'src/silk',
      ],
    },  # target opus_demo
  ]
}
