/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.App;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class OpacityBox
extends JP2Box {
    public OpacityBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof ComposLayerHdrBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        ArrayList<Property> arrayList = new ArrayList<Property>(4);
        App app = this._module.getApp();
        int n = ModuleBase.readUnsignedByte(this._dstrm, this._module);
        arrayList.add(this._module.addIntegerProperty("Type", n, JP2Strings.opacityTypeStr));
        if (n > 2) {
            this._repInfo.setMessage(new ErrorMessage("Invalid OTyp field in Opacity Box", this._module.getFilePos()));
            this._repInfo.setValid(false);
            return false;
        }
        int n2 = (int)this._boxHeader.getDataLength() - 1;
        if (n2 > 0) {
            int n3 = ModuleBase.readUnsignedByte(this._dstrm, this._module);
            int[] nArray = new int[n3];
            int n4 = (n2 - 1) / n3;
            for (int i = 0; i < n3; ++i) {
                int n5 = 0;
                for (int j = 0; j < n4; ++j) {
                    n5 = (n5 << 8) + ModuleBase.readUnsignedByte(this._dstrm, this._module);
                }
                nArray[i] = n5;
            }
            arrayList.add(new Property("ChromaKeyValues", PropertyType.INTEGER, PropertyArity.ARRAY, nArray));
        }
        ((ComposLayerHdrBox)this._parentBox).addOpacity(new Property("Opacity", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Opacity Box";
    }
}

