/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultKernelBounds;
import com.nvidia.viper.analysis.KernelMemoryResultGraphicFactory;
import com.nvidia.viper.analysis.PCIeCalculator;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;

public class AnalysisResultKernelMemory
extends AnalysisResult {
    private final TimelineIntervalKernel kernel;
    private final PCIeCalculator pcie;
    private AnalysisResultKernelBounds.MemBound memBound;
    private final double BAD_ECC_OVERHEAD = 30.0;
    private final double ECC_OVERHEAD_LIMIT = 10.0;
    private double eccRatio = -1.0;
    private final Number dramReadTransactions;
    private final Number dramWriteTransactions;
    private final Number sramReadTransactions;
    private final Number sramWriteTransactions;
    private final Number l2ReadTransactions;
    private final Number l2WriteTransactions;
    private final Number l2L1ReadTransactions;
    private final Number l2L1WriteTransactions;
    private final Number l2TexReadTransactions;
    private final Number l2TexWriteTransactions;
    private final Number l2AtomicTransactions;
    private final Number ncL2ReadTransactions;
    private final Number sharedReadTransactions;
    private final Number sharedWriteTransactions;
    private final Number localReadTransactions;
    private final Number localWriteTransactions;
    private final Number globalReadTransactions;
    private final Number globalWriteTransactions;
    private final Number texTransactions;
    private final Number atomicTransactions;
    private final Number eccTransactions;
    private final Number dramReadThroughput;
    private final Number dramWriteThroughput;
    private final Number sramReadThroughput;
    private final Number sramWriteThroughput;
    private final Number l2ReadThroughput;
    private final Number l2WriteThroughput;
    private final Number l2L1ReadThroughput;
    private final Number l2L1WriteThroughput;
    private final Number l2TexReadThroughput;
    private final Number l2TexWriteThroughput;
    private final Number l2AtomicThroughput;
    private final Number ncL2ReadThroughput;
    private final Number sharedReadThroughput;
    private final Number sharedWriteThroughput;
    private final Number localReadThroughput;
    private final Number localWriteThroughput;
    private final Number globalReadThroughput;
    private final Number globalWriteThroughput;
    private final Number texThroughput;
    private final Number atomicThroughput;
    private final Number eccThroughput;
    private final Number sysmemReadUtilization;
    private final Number sysmemWriteUtilization;
    private final Map<MemoryUnit, CuptiMetricValueUtilizationLevel> memoryUnitUtil;
    private double sysMemUtilizationBi = -1.0;
    private double sysMemUtilizationUni = -1.0;

    public AnalysisResultKernelMemory(TimelineIntervalKernel kernel, PCIeCalculator pcie, Number dramReadTransactions, Number dramWriteTransactions, Number sramReadTransactions, Number sramWriteTransactions, Number l2ReadTransactions, Number l2WriteTransactions, Number l2L1ReadTransactions, Number l2L1WriteTransactions, Number l2TexReadTransactions, Number l2TexWriteTransactions, Number l2AtomicTransactions, Number ncL2ReadTransactions, Number sharedReadTransactions, Number sharedWriteTransactions, Number localReadTransactions, Number localWriteTransactions, Number globalReadTransactions, Number globalWriteTransactions, Number texTransactions, Number atomicTransactions, Number eccTransactions, Number dramReadThroughput, Number dramWriteThroughput, Number sramReadThroughput, Number sramWriteThroughput, Number l2ReadThroughput, Number l2WriteThroughput, Number l2L1ReadThroughput, Number l2L1WriteThroughput, Number l2TexReadThroughput, Number l2TexWriteThroughput, Number l2AtomicThroughput, Number ncL2ReadThroughput, Number sharedReadThroughput, Number sharedWriteThroughput, Number localReadThroughput, Number localWriteThroughput, Number globalReadThroughput, Number globalWriteThroughput, Number texThroughput, Number atomicThroughput, Number eccThroughput, Number sysmemReadUtilization, Number sysmemWriteUtilization) {
        super(AnalysisDescriptor.KERNEL_MEMORY);
        this.kernel = kernel;
        this.pcie = pcie;
        this.memBound = null;
        this.dramReadTransactions = dramReadTransactions;
        this.dramWriteTransactions = dramWriteTransactions;
        this.sramReadTransactions = sramReadTransactions;
        this.sramWriteTransactions = sramWriteTransactions;
        this.l2ReadTransactions = l2ReadTransactions;
        this.l2WriteTransactions = l2WriteTransactions;
        this.l2L1ReadTransactions = l2L1ReadTransactions;
        this.l2L1WriteTransactions = l2L1WriteTransactions;
        this.l2TexReadTransactions = l2TexReadTransactions;
        this.l2TexWriteTransactions = l2TexWriteTransactions;
        this.l2AtomicTransactions = l2AtomicTransactions;
        this.ncL2ReadTransactions = ncL2ReadTransactions;
        this.sharedReadTransactions = sharedReadTransactions;
        this.sharedWriteTransactions = sharedWriteTransactions;
        this.localReadTransactions = localReadTransactions;
        this.localWriteTransactions = localWriteTransactions;
        this.globalReadTransactions = globalReadTransactions;
        this.globalWriteTransactions = globalWriteTransactions;
        this.texTransactions = texTransactions;
        this.atomicTransactions = atomicTransactions;
        this.eccTransactions = eccTransactions;
        this.dramReadThroughput = dramReadThroughput;
        this.dramWriteThroughput = dramWriteThroughput;
        this.sramReadThroughput = sramReadThroughput;
        this.sramWriteThroughput = sramWriteThroughput;
        this.l2ReadThroughput = l2ReadThroughput;
        this.l2WriteThroughput = l2WriteThroughput;
        this.l2L1ReadThroughput = l2L1ReadThroughput;
        this.l2L1WriteThroughput = l2L1WriteThroughput;
        this.l2TexReadThroughput = l2TexReadThroughput;
        this.l2TexWriteThroughput = l2TexWriteThroughput;
        this.l2AtomicThroughput = l2AtomicThroughput;
        this.ncL2ReadThroughput = ncL2ReadThroughput;
        this.sharedReadThroughput = sharedReadThroughput;
        this.sharedWriteThroughput = sharedWriteThroughput;
        this.localReadThroughput = localReadThroughput;
        this.localWriteThroughput = localWriteThroughput;
        this.globalReadThroughput = globalReadThroughput;
        this.globalWriteThroughput = globalWriteThroughput;
        this.texThroughput = texThroughput;
        this.atomicThroughput = atomicTransactions;
        this.eccThroughput = eccThroughput;
        this.sysmemReadUtilization = sysmemReadUtilization;
        this.sysmemWriteUtilization = sysmemWriteUtilization;
        this.memoryUnitUtil = new HashMap<MemoryUnit, CuptiMetricValueUtilizationLevel>();
    }

    public List<MemoryUnit> getMemoryUnits() {
        LinkedList<MemoryUnit> mus = new LinkedList<MemoryUnit>();
        MemoryUnit[] memoryUnitArray = MemoryUnit.getOrderedMemoryUnits();
        int n = memoryUnitArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryUnit mu = memoryUnitArray[n2];
            if (this.memoryUnitUtil.containsKey((Object)mu)) {
                mus.add(mu);
            }
            ++n2;
        }
        return mus;
    }

    public Set<MemoryUnit> getMaxUtilizedMemoryUnits() {
        int maxCode = 0;
        for (MemoryUnit mu : this.getMemoryUnits()) {
            maxCode = Math.max(maxCode, this.memoryUnitUtil.get((Object)mu).getCode());
        }
        HashSet<MemoryUnit> max = new HashSet<MemoryUnit>();
        for (MemoryUnit mu : this.getMemoryUnits()) {
            int code = this.memoryUnitUtil.get((Object)mu).getCode();
            if (code < maxCode) continue;
            max.add(mu);
        }
        return max;
    }

    public void setMemoryUnitUtilization(MemoryUnit mu, CuptiMetricValueUtilizationLevel util) {
        this.memoryUnitUtil.put(mu, util);
    }

    public void SetIsPerformanceLimiter(AnalysisResultKernelBounds.MemBound memBound) {
        this.desc = memBound.isFuUnitBound() ? AnalysisDescriptor.KERNEL_MEMORY_FU_LIMITER : AnalysisDescriptor.KERNEL_MEMORY_BANDWIDTH_LIMITER;
        this.memBound = memBound;
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public Number getDramReadTransactions() {
        return this.dramReadTransactions;
    }

    public Number getDramWriteTransactions() {
        return this.dramWriteTransactions;
    }

    public Number getSystemMemoryReadTransactions() {
        return this.sramReadTransactions;
    }

    public Number getSystemMemoryWriteTransactions() {
        return this.sramWriteTransactions;
    }

    public Number getL2ReadTransactions() {
        return this.l2ReadTransactions;
    }

    public Number getL2WriteTransactions() {
        return this.l2WriteTransactions;
    }

    public Number getL2L1ReadTransactions() {
        return this.l2L1ReadTransactions;
    }

    public Number getL2L1WriteTransactions() {
        return this.l2L1WriteTransactions;
    }

    public Number getL2TexReadTransactions() {
        return this.l2TexReadTransactions;
    }

    public Number getL2TexWriteTransactions() {
        return this.l2TexWriteTransactions;
    }

    public Number getL2AtomicTransactions() {
        return this.l2AtomicTransactions;
    }

    public Number getNcL2ReadTransactions() {
        return this.ncL2ReadTransactions;
    }

    public Number getSharedMemoryReadTransactions() {
        return this.sharedReadTransactions;
    }

    public Number getSharedMemoryWriteTransactions() {
        return this.sharedWriteTransactions;
    }

    public Number getLocalMemoryReadTransactions() {
        return this.localReadTransactions;
    }

    public Number getLocalMemoryWriteTransactions() {
        return this.localWriteTransactions;
    }

    public Number getGlobalMemoryReadTransactions() {
        return this.globalReadTransactions;
    }

    public Number getGlobalMemoryWriteTransactions() {
        return this.globalWriteTransactions;
    }

    public Number getTexureCacheReadTransactions() {
        return this.texTransactions;
    }

    public Number getAtomicTransactions() {
        return this.atomicTransactions;
    }

    public Number getEccTransactions() {
        return this.eccTransactions;
    }

    public Number getDramReadThroughput() {
        return this.dramReadThroughput;
    }

    public Number getDramWriteThroughput() {
        return this.dramWriteThroughput;
    }

    public Number getSystemMemoryReadThroughput() {
        return this.sramReadThroughput;
    }

    public Number getSystemMemoryWriteThroughput() {
        return this.sramWriteThroughput;
    }

    public Number getL2ReadThroughput() {
        return this.l2ReadThroughput;
    }

    public Number getL2WriteThroughput() {
        return this.l2WriteThroughput;
    }

    public Number getL2L1ReadThroughput() {
        return this.l2L1ReadThroughput;
    }

    public Number getL2L1WriteThroughput() {
        return this.l2L1WriteThroughput;
    }

    public Number getL2TexReadThroughput() {
        return this.l2TexReadThroughput;
    }

    public Number getL2TexWriteThroughput() {
        return this.l2TexWriteThroughput;
    }

    public Number getL2AtomicThroughput() {
        return this.l2AtomicThroughput;
    }

    public Number getNcL2ReadThroughput() {
        return this.ncL2ReadThroughput;
    }

    public Number getSharedMemoryReadThroughput() {
        return this.sharedReadThroughput;
    }

    public Number getSharedMemoryWriteThroughput() {
        return this.sharedWriteThroughput;
    }

    public Number getLocalMemoryReadThroughput() {
        return this.localReadThroughput;
    }

    public Number getLocalMemoryWriteThroughput() {
        return this.localWriteThroughput;
    }

    public Number getGlobalMemoryReadThroughput() {
        return this.globalReadThroughput;
    }

    public Number getGlobalMemoryWriteThroughput() {
        return this.globalWriteThroughput;
    }

    public Number getTexureCacheReadThroughput() {
        return this.texThroughput;
    }

    public Number getAtomicThroughput() {
        return this.atomicThroughput;
    }

    public Number getEccThroughput() {
        return this.eccThroughput;
    }

    public CuptiMetricValueUtilizationLevel getMemoryUnitUtilization(MemoryUnit mu) {
        CuptiMetricValueUtilizationLevel util = this.memoryUnitUtil.get((Object)mu);
        return util == null ? CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_IDLE : util;
    }

    public CuptiMetricValueUtilizationLevel getSysMemReadUtilization() {
        if (this.sysmemReadUtilization != null) {
            return CuptiMetricValueUtilizationLevel.valueOf(this.sysmemReadUtilization.intValue());
        }
        long peak = 0L;
        peak = this.isBidirectional() ? PCIeCalculator.getBidirectionalPeak(this.pcie.getPCIeGeneration(), this.pcie.getDefaultPCIeLinkWidth(), this.pcie.getDefaultPCIeLinkRate()).longValue() : PCIeCalculator.getUnidirectionalPeak(this.pcie.getPCIeGeneration(), this.pcie.getDefaultPCIeLinkWidth(), this.pcie.getDefaultPCIeLinkRate()).longValue();
        double levelPercent = this.getSystemMemoryReadThroughput().doubleValue() / (double)peak;
        return CuptiMetricValueUtilizationLevel.valueForPercent(levelPercent);
    }

    public CuptiMetricValueUtilizationLevel getSysMemWriteUtilization() {
        if (this.sysmemWriteUtilization != null) {
            return CuptiMetricValueUtilizationLevel.valueOf(this.sysmemWriteUtilization.intValue());
        }
        long peak = 0L;
        peak = this.isBidirectional() ? PCIeCalculator.getBidirectionalPeak(this.pcie.getPCIeGeneration(), this.pcie.getDefaultPCIeLinkWidth(), this.pcie.getDefaultPCIeLinkRate()).longValue() : PCIeCalculator.getUnidirectionalPeak(this.pcie.getPCIeGeneration(), this.pcie.getDefaultPCIeLinkWidth(), this.pcie.getDefaultPCIeLinkRate()).longValue();
        double levelPercent = this.getSystemMemoryWriteThroughput().doubleValue() / (double)peak;
        return CuptiMetricValueUtilizationLevel.valueForPercent(levelPercent);
    }

    private boolean isBidirectional() {
        if (this.sysMemUtilizationBi == -1.0 || this.sysMemUtilizationUni == -1.0) {
            long achievedBi = this.getSystemMemoryReadThroughput().longValue() + this.getSystemMemoryWriteThroughput().longValue();
            long peakBi = PCIeCalculator.getBidirectionalPeak(this.pcie.getPCIeGeneration(), this.pcie.getDefaultPCIeLinkWidth(), this.pcie.getDefaultPCIeLinkRate());
            long clmapedAchievedBi = Math.min(achievedBi, peakBi);
            this.sysMemUtilizationBi = (double)clmapedAchievedBi / (double)peakBi;
            long achievedUni = Math.max(this.getSystemMemoryReadThroughput().longValue(), this.getSystemMemoryWriteThroughput().longValue());
            long peakUni = PCIeCalculator.getUnidirectionalPeak(this.pcie.getPCIeGeneration(), this.pcie.getDefaultPCIeLinkWidth(), this.pcie.getDefaultPCIeLinkRate());
            long clmapedAchievedUni = Math.min(achievedUni, peakUni);
            this.sysMemUtilizationUni = (double)clmapedAchievedUni / (double)peakUni;
        }
        return this.sysMemUtilizationBi > this.sysMemUtilizationUni;
    }

    public boolean isMemoryUnitLimited(MemoryUnit mu) {
        CuptiMetricValueUtilizationLevel util;
        Set<MemoryUnit> max = this.getMaxUtilizedMemoryUnits();
        if (max.contains((Object)mu) && (util = this.memoryUnitUtil.get((Object)mu)) != null) {
            return util.getCode() > CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_MID.getCode();
        }
        return false;
    }

    public boolean isECCLimited() {
        return this.getEccRatio() >= 30.0;
    }

    public boolean isEccOverhead() {
        return this.getEccRatio() >= 10.0;
    }

    private double getEccRatio() {
        if (this.eccRatio == -1.0) {
            long dramReadThroughput = this.getDramReadThroughput() != null ? this.getDramReadThroughput().longValue() : 0L;
            long dramWriteThroughput = this.getDramWriteThroughput() != null ? this.getDramWriteThroughput().longValue() : 0L;
            long totalDramThroughput = dramReadThroughput + dramWriteThroughput;
            long eccThroughput = this.getEccThroughput() != null ? this.getEccThroughput().longValue() : 0L;
            this.eccRatio = totalDramThroughput > 0L ? (double)eccThroughput / (double)totalDramThroughput * 100.0 : 0.0;
        }
        return this.eccRatio;
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        if (this.memBound == null) {
            return super.getDescription(otpt);
        }
        if (AnalysisDescriptor.KERNEL_MEMORY_BANDWIDTH_LIMITER.equals((Object)this.desc)) {
            return String.valueOf(AnalysisDescriptor.KERNEL_MEMORY.getDescription(otpt)) + " " + super.getDescription(otpt);
        }
        String desc = super.getDescription(otpt);
        desc = desc.replace("%UNIT%", String.valueOf(this.memBound.toString().toLowerCase()) + "s");
        return desc;
    }

    @Override
    public String getActionDescription(ResultOutput otpt) {
        String desc = super.getActionDescription(otpt);
        if (desc != null) {
            Set<MemoryUnit> maxMems = this.getMaxUtilizedMemoryUnits();
            desc = desc.replace("%MEM%", maxMems.size() == 1 ? "memory" : "memories");
            if (this.memBound != null && this.memBound.isFuUnitBound()) {
                desc = desc.replace("%UNIT%", String.valueOf(this.memBound.toString().toLowerCase()) + "s");
            } else {
                for (MemoryUnit mu : this.getMemoryUnits()) {
                    desc = String.valueOf(desc) + "\n\t" + mu.getDescription();
                    if (!mu.equals((Object)MemoryUnit.DRAM) || !this.isECCLimited()) continue;
                    desc = String.valueOf(desc) + ViperMessages.KernelMemory_BandwidthLimiter_EccDesc;
                }
            }
        }
        return desc;
    }

    public String getSystemMemoryLabel() {
        if (this.pcie != null) {
            return "[ PCIe configuration: Gen" + this.pcie.getPCIeGeneration() + " x" + this.pcie.getPCIeLinkWidth() + ", " + new BandwidthFormatter(ByteSizeFormatter.Base.KILOBIT).format(this.pcie.getPCIeLinkRate() * 1000L * 1000L) + " ]";
        }
        return null;
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelMemoryResultGraphicFactory();
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public Action getMoreAction() {
        return new Action(){

            public void run() {
                ViperHelp.displayHelp(ViperHelp.MEMORY_SPACES);
            }
        };
    }

    public static enum MemoryUnit {
        DRAM("Device", ViperMessages.KernelMemory_BandwidthLimiter_DramDesc, "dram_utilization", Arrays.asList("dram_read_throughput", "dram_write_throughput", "dram_read_transactions", "dram_write_transactions"), AnalysisResultKernelBounds.MemBound.DRAM),
        SYSMEM("System", ViperMessages.KernelMemory_BandwidthLimiter_SysMemDesc, "sysmem_utilization", Arrays.asList("sysmem_read_throughput", "sysmem_write_throughput", "sysmem_read_transactions", "sysmem_write_transactions", "sysmem_read_utilization", "sysmem_write_utilization"), AnalysisResultKernelBounds.MemBound.SYSMEM),
        L2("L2", ViperMessages.KernelMemory_BandwidthLimiter_L2Desc, "l2_utilization", Arrays.asList("l2_read_throughput", "l2_write_throughput", "gld_throughput", "gst_throughput", "l2_read_transactions", "l2_write_transactions", "gld_transactions", "gst_transactions"), AnalysisResultKernelBounds.MemBound.L2),
        L1SHARED("L1/Shared", ViperMessages.KernelMemory_BandwidthLimiter_L1SharedMemoryDesc, "l1_shared_utilization", Arrays.asList("shared_load_throughput", "shared_store_throughput", "shared_load_transactions", "shared_store_transactions"), AnalysisResultKernelBounds.MemBound.L1SHARED),
        TEX("Texture", ViperMessages.KernelMemory_BandwidthLimiter_TextureDesc, "tex_utilization", Arrays.asList("tex_cache_throughput", "tex_cache_transactions"), AnalysisResultKernelBounds.MemBound.TEX),
        SHARED("Shared", ViperMessages.KernelMemory_BandwidthLimiter_SharedMemoryDesc, "shared_utilization", Arrays.asList("shared_load_throughput", "shared_store_throughput", "shared_load_transactions", "shared_store_transactions"), AnalysisResultKernelBounds.MemBound.SHARED),
        UNIFIED("Unified", ViperMessages.KernelMemory_BandwidthLimiter_UnifiedDesc, "tex_utilization", Arrays.asList("tex_cache_throughput", "tex_cache_transactions"), AnalysisResultKernelBounds.MemBound.TEX);

        private final String name;
        private final String desc;
        private final String utilMetricName;
        private final List<String> metricNames;
        private final AnalysisResultKernelBounds.MemBound bound;

        private MemoryUnit(String name, String desc, String utilMetricName, List<String> metricNames, AnalysisResultKernelBounds.MemBound bound) {
            this.name = name;
            this.desc = desc;
            this.utilMetricName = utilMetricName;
            this.metricNames = metricNames;
            this.bound = bound;
        }

        public String getUtilizationMetricName() {
            return this.utilMetricName;
        }

        public List<String> getMetricNames() {
            return this.metricNames;
        }

        public String getMemoryTableName() {
            switch (this) {
                case L2: 
                case TEX: 
                case UNIFIED: {
                    return String.valueOf(this.name) + " Cache";
                }
            }
            return String.valueOf(this.name) + " Memory";
        }

        public String toString() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public AnalysisResultKernelBounds.MemBound getMemoryBound() {
            return this.bound;
        }

        public static MemoryUnit[] getMemoryUnits(int major, int minor) {
            if (major == 7 && minor == 2) {
                return new MemoryUnit[]{SHARED, L2, UNIFIED};
            }
            if (major == 6 && minor == 2) {
                return new MemoryUnit[]{SHARED, L2, UNIFIED};
            }
            if (major == 5 && minor == 3) {
                return new MemoryUnit[]{SHARED, L2, UNIFIED};
            }
            if (major >= 5) {
                return new MemoryUnit[]{SHARED, L2, UNIFIED, DRAM, SYSMEM};
            }
            if (major == 3 && minor == 2) {
                return new MemoryUnit[]{L2, TEX};
            }
            return new MemoryUnit[]{L1SHARED, L2, TEX, DRAM, SYSMEM};
        }

        public static MemoryUnit[] getOrderedMemoryUnits() {
            return new MemoryUnit[]{L1SHARED, SHARED, L2, TEX, UNIFIED, DRAM, SYSMEM};
        }

        public static boolean isLocalMemoryAnalysisAvailable(int major, int minor) {
            return major != 3 || minor != 2;
        }
    }
}

