/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.parts;

import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Cursor;

public class KeylessPanningSelectionTool
extends SelectionTool {
    private Point viewLocation;
    protected static final int STATE_PAN_IN_PROGRESS = 128;
    protected static final int STATE_DONT_PAN = 256;
    protected static final int MAX_STATE = 256;
    private boolean keyDown = false;

    protected String getDebugName() {
        return "Keyless Panning Tool";
    }

    protected String getDebugNameForState(int state) {
        if (state == 128) {
            return "Pan In Progress";
        }
        if (state == 256) {
            return "Don't pan";
        }
        return super.getDebugNameForState(state);
    }

    protected Cursor getDefaultCursor() {
        if (this.isInState(128)) {
            return SharedCursors.HAND;
        }
        return super.getDefaultCursor();
    }

    protected boolean handleKeyDown(KeyEvent e) {
        this.keyDown = true;
        return super.handleKeyDown(e);
    }

    protected boolean handleKeyUp(KeyEvent e) {
        this.keyDown = false;
        return super.handleKeyUp(e);
    }

    protected boolean handleButtonUp(int which) {
        if (which == 1 && this.stateTransition(128, 1)) {
            this.viewLocation = null;
            this.refreshCursor();
            return true;
        }
        this.stateTransition(256, 1);
        return super.handleButtonUp(which);
    }

    protected boolean handleDrag() {
        if (this.keyDown) {
            this.stateTransition(2, 256);
            return true;
        }
        if (this.movedPastThreshold() && this.stateTransition(2, 128)) {
            this.setDragTracker(null);
            this.updateTargetUnderMouse();
            this.unlockTargetEditPart();
            this.viewLocation = ((FigureCanvas)this.getCurrentViewer().getControl()).getViewport().getViewLocation();
            this.refreshCursor();
        }
        if (this.isInState(128) && this.getCurrentViewer().getControl() instanceof FigureCanvas) {
            this.refreshCursor();
            FigureCanvas canvas = (FigureCanvas)this.getCurrentViewer().getControl();
            canvas.scrollTo(this.viewLocation.x - this.getDragMoveDelta().width, this.viewLocation.y - this.getDragMoveDelta().height);
            return true;
        }
        return super.handleDrag();
    }

    protected boolean handleFocusLost() {
        if (this.isInState(128)) {
            this.setState(1);
            this.refreshCursor();
            return true;
        }
        return super.handleFocusLost();
    }
}

