/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.birt.report.ReportTableData;
import com.nvidia.viper.report.util.SwingGraphicsObject;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.IAnalysisResultSVG;
import com.nvidia.viper.ui.analysis.SVGGraphics2DUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DataGridAndLabelSVG
implements IAnalysisResultSVG {
    protected final List<Object> components = new ArrayList<Object>();
    public static final int COMPONENTSPACE = 5;

    protected abstract void initTables(SVGGraphics2D var1);

    @Override
    public boolean createSVG(String filePath, int width, int height, GC gc) {
        return this.drawSVG(filePath, width, height, gc);
    }

    protected boolean drawSVG(String filePath, int width, int height, GC gc) {
        String svgNS;
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        Document document = domImpl.createDocument(svgNS = "http://www.w3.org/2000/svg", "svg", null);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        boolean drawn = this.paint(svgGenerator, gc, width, height);
        if (!drawn) {
            return false;
        }
        String chartName = filePath;
        Element svgElement = svgGenerator.getRoot();
        Attr widthAttr = document.createAttribute("width");
        widthAttr.setValue("100%");
        Attr heightAttr = document.createAttribute("height");
        heightAttr.setValue("100%");
        Attr viewBoxAttr = document.createAttribute("viewBox");
        viewBoxAttr.setValue("0 0 " + width + " " + height);
        svgElement.setAttributeNode(widthAttr);
        svgElement.setAttributeNode(heightAttr);
        svgElement.setAttributeNode(viewBoxAttr);
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(chartName), "UTF-8");
            svgGenerator.stream(svgElement, (Writer)out);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return false;
        }
        return true;
    }

    protected boolean paint(SVGGraphics2D svg2d, GC gc, int width, int height) {
        int currentX = 0;
        int currentY = 0;
        this.initTables(svg2d);
        final SwingGraphicsObject wtgo = new SwingGraphicsObject((Graphics2D)svg2d, gc);
        int avgFontHeight = wtgo.getFontHeight();
        for (Object c : this.components) {
            if (c instanceof String) {
                String str = (String)c;
                wtgo.setForeground(SwingGraphicsObject.SwingToSWTColor(Color.BLACK, gc));
                wtgo.drawString(str, currentX, currentY, true);
                currentY += avgFontHeight;
            } else if (c instanceof DataGrid) {
                final DataGrid dg = (DataGrid)c;
                height = dg.computeHeight(wtgo);
                final Rectangle rect = new Rectangle(currentX, currentY, width, height);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        dg.paintDataGrid(wtgo, rect);
                    }
                });
                wtgo.drawRectangle(currentX, currentY, width, height + 4);
                currentY += height;
            }
            currentY += 5;
        }
        return true;
    }

    @Override
    public int getPreferredSVGHieght(GC gc) {
        SVGGraphics2D svg2d = SVGGraphics2DUtils.getGenericSVGGraphics2D();
        int height = 0;
        this.initTables(svg2d);
        int avgFontHeight = svg2d.getFontMetrics().getHeight();
        SwingGraphicsObject wtgo = new SwingGraphicsObject((Graphics2D)svg2d, gc);
        for (Object c : this.components) {
            if (c instanceof String) {
                height += avgFontHeight;
            } else if (c instanceof DataGrid) {
                DataGrid dg = (DataGrid)c;
                height += dg.computeHeight(wtgo) + 4;
            }
            height += 5;
        }
        return height;
    }

    @Override
    public ReportTableData[] getTableElements() {
        return null;
    }
}

