/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.state;

import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.model.query.ElementQuery;
import com.nvidia.cuda.ide.debug.model.query.HardwareVerticalCondition;
import com.nvidia.cuda.ide.debug.model.query.IElementQuery;
import com.nvidia.cuda.ide.debug.model.state.HardwareStateManager;
import com.nvidia.cuda.ide.debug.model.state.ThreadsStateManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class QueryProcessor {
    private final ICudaApplication application;
    private final ThreadsStateManager threads;
    private final HardwareStateManager hw;
    private final Map<IElementQuery, IElementQuery> swQueries = new HashMap<IElementQuery, IElementQuery>();
    private final Map<IElementQuery, IElementQuery> hwQueries = new HashMap<IElementQuery, IElementQuery>();

    public QueryProcessor(ICudaApplication application, ThreadsStateManager threads, HardwareStateManager hw) {
        this.application = application;
        this.threads = threads;
        this.hw = hw;
    }

    public void prepareQuery(final IElementQuery query, boolean logicalElements, final DataRequestMonitor<IElementQuery> rm) {
        if (logicalElements && query.hasHardwareFilters()) {
            if (this.swQueries.containsKey(query)) {
                rm.setData((Object)this.swQueries.get(query));
                rm.done();
            } else {
                IElementQuery hwQuery = query.getHardwareQuery();
                this.processDevices(hwQuery, new DataRequestMonitor<IElementQuery>(this.getExecutor(), rm){

                    protected void handleSuccess() {
                        IElementQuery q = ElementQuery.and(query.getLogicalQuery(), (IElementQuery)this.getData());
                        QueryProcessor.this.swQueries.put(query, q);
                        rm.setData((Object)q);
                        rm.done();
                    }
                });
            }
        } else if (!logicalElements && query.hasLogicalFilters()) {
            if (this.hwQueries.containsKey(query)) {
                rm.setData((Object)this.hwQueries.get(query));
                rm.done();
            }
            IElementQuery logicalQuery = query.getLogicalQuery();
            this.processKernels(logicalQuery, new DataRequestMonitor<IElementQuery>(this.getExecutor(), rm){

                protected void handleSuccess() {
                    IElementQuery q = ElementQuery.and(query.getHardwareQuery(), (IElementQuery)this.getData());
                    QueryProcessor.this.hwQueries.put(query, q);
                    rm.setData((Object)q);
                    rm.done();
                }
            });
        } else {
            rm.setData((Object)query);
            rm.done();
        }
    }

    private void processKernels(final IElementQuery logicalQuery, final DataRequestMonitor<IElementQuery> rm) {
        this.application.getKernels((DataRequestMonitor<? super Kernel[]>)new DataRequestMonitor<Kernel[]>(this.getExecutor(), rm){

            protected void handleSuccess() {
                if (((Kernel[])this.getData()).length == 0) {
                    rm.setData((Object)ElementQuery.NONE);
                    rm.done();
                } else {
                    IElementQuery[] queries = new IElementQuery[((Kernel[])this.getData()).length];
                    CountingRequestMonitor crm = QueryProcessor.this.gatherChildQueries(((Kernel[])this.getData()).length, (DataRequestMonitor<IElementQuery>)rm, queries);
                    int i = 0;
                    while (i < ((Kernel[])this.getData()).length) {
                        Kernel kernel = ((Kernel[])this.getData())[i];
                        if (logicalQuery.match(kernel)) {
                            QueryProcessor.this.processKernel(kernel, logicalQuery, new QueryRequestMonitor(queries, i, QueryProcessor.this.getExecutor(), (RequestMonitor)crm));
                        } else {
                            queries[i] = ElementQuery.NONE;
                            crm.done();
                        }
                        ++i;
                    }
                }
            }
        });
    }

    protected void processKernel(Kernel kernel, final IElementQuery query, final QueryRequestMonitor rm) {
        CudaCoord[] filteredBlocks = query.filterBlocks(kernel);
        if (filteredBlocks != null) {
            IElementQuery[] queries = new IElementQuery[filteredBlocks.length];
            CountingRequestMonitor crm = this.gatherChildQueries(filteredBlocks.length, rm, queries);
            int i = 0;
            CudaCoord[] cudaCoordArray = filteredBlocks;
            int n = filteredBlocks.length;
            int n2 = 0;
            while (n2 < n) {
                CudaCoord coord = cudaCoordArray[n2];
                try {
                    this.prepareQueries(kernel.getBlock(coord), query, new QueryRequestMonitor(queries, i++, this.getExecutor(), (RequestMonitor)crm));
                }
                catch (CudaException e) {
                    crm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                    crm.done();
                }
                ++n2;
            }
        } else {
            this.application.getActiveBlocks(kernel, false, ICoordSorter.HARDWARE, new DataRequestMonitor<IDMContext[]>(this.getExecutor(), (RequestMonitor)rm){

                protected void handleSuccess() {
                    if (((IDMContext[])this.getData()).length == 0) {
                        rm.setData(ElementQuery.NONE);
                        rm.done();
                    } else {
                        IElementQuery[] queries = new IElementQuery[((IDMContext[])this.getData()).length];
                        CountingRequestMonitor crm = QueryProcessor.this.gatherChildQueries(((IDMContext[])this.getData()).length, (DataRequestMonitor<IElementQuery>)rm, queries);
                        int i = 0;
                        IDMContext[] iDMContextArray = (IDMContext[])this.getData();
                        int n = iDMContextArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IDMContext ctx = iDMContextArray[n2];
                            QueryProcessor.this.prepareQueries((Block)ctx, query, new QueryRequestMonitor(queries, i++, QueryProcessor.this.getExecutor(), (RequestMonitor)crm));
                            ++n2;
                        }
                    }
                }
            });
        }
    }

    private void prepareQueries(Block block, IElementQuery query, final QueryRequestMonitor rm) {
        CudaCoord[] threads = query.filterThreads(block);
        if (threads != null) {
            IElementQuery[] queries = new IElementQuery[threads.length];
            CountingRequestMonitor crm = this.gatherChildQueries(threads.length, rm, queries);
            int i = 0;
            CudaCoord[] cudaCoordArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                CudaCoord coord = cudaCoordArray[n2];
                try {
                    this.getQuery(block.getThread(coord), true, new QueryRequestMonitor(queries, i++, this.getExecutor(), (RequestMonitor)crm));
                }
                catch (CudaException e) {
                    crm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                    crm.done();
                }
                ++n2;
            }
        } else {
            this.application.getActiveThreads(block, false, ICoordSorter.HARDWARE, new DataRequestMonitor<IDMContext[]>(this.getExecutor(), (RequestMonitor)rm){

                protected void handleSuccess() {
                    int count = ((IDMContext[])this.getData()).length >> 5;
                    IElementQuery[] queries = new IElementQuery[count];
                    CountingRequestMonitor crm = QueryProcessor.this.gatherChildQueries(count, (DataRequestMonitor<IElementQuery>)rm, queries);
                    int i = 0;
                    while (i < count) {
                        QueryProcessor.this.getQuery((DeviceThread)((IDMContext[])this.getData())[i << 5], false, new QueryRequestMonitor(queries, i, QueryProcessor.this.getExecutor(), (RequestMonitor)crm));
                        ++i;
                    }
                }
            });
        }
    }

    private void getQuery(DeviceThread thread, final boolean includeLane, final QueryRequestMonitor rm) {
        thread.getState(new DataRequestMonitor<CudaRuntimeInformation>(this.getExecutor(), (RequestMonitor)rm){

            protected void handleSuccess() {
                CudaRuntimeInformation info = (CudaRuntimeInformation)this.getData();
                HardwareVerticalCondition condition = includeLane ? new HardwareVerticalCondition(info.getDeviceId(), info.getSm(), info.getWarpId(), info.getLane()) : new HardwareVerticalCondition(info.getDeviceId(), info.getSm(), info.getWarpId());
                rm.setData(new ElementQuery(condition));
                rm.done();
            }
        });
    }

    private Executor getExecutor() {
        return this.application.getExecutor();
    }

    private void processDevices(final IElementQuery q, final DataRequestMonitor<IElementQuery> rm) {
        this.application.getDevices(new DataRequestMonitor<Device[]>(this.getExecutor(), rm){

            protected void handleSuccess() {
                IElementQuery[] queries = new IElementQuery[((Device[])this.getData()).length];
                CountingRequestMonitor crm = QueryProcessor.this.gatherChildQueries(((Device[])this.getData()).length, (DataRequestMonitor<IElementQuery>)rm, queries);
                int i = 0;
                while (i < ((Device[])this.getData()).length) {
                    Device device = ((Device[])this.getData())[i];
                    if (!q.match(device)) {
                        queries[i] = ElementQuery.NONE;
                        crm.done();
                    } else {
                        QueryProcessor.this.getSMFilters(device, q, (DataRequestMonitor<IElementQuery>)new QueryRequestMonitor(queries, i, QueryProcessor.this.getExecutor(), (RequestMonitor)crm));
                    }
                    i = (short)(i + 1);
                }
            }
        });
    }

    private void getSMFilters(final Device device, final IElementQuery hwQuery, final DataRequestMonitor<IElementQuery> rm) {
        this.hw.getWarpMasks(device, new DataRequestMonitor<long[]>(this.getExecutor(), rm){

            protected void handleSuccess() {
                long[] warpMasks = (long[])this.getData();
                IElementQuery[] queries = new IElementQuery[device.getSmCount()];
                CountingRequestMonitor monitor = QueryProcessor.this.gatherChildQueries(device.getSmCount(), (DataRequestMonitor<IElementQuery>)rm, queries);
                short i = 0;
                while (i < device.getSmCount()) {
                    try {
                        StreamingMultiprocessor sm = device.getSm(i);
                        if (warpMasks[i] == 0L || !hwQuery.match(sm)) {
                            queries[i] = ElementQuery.NONE;
                            monitor.done();
                        } else {
                            QueryProcessor.this.getWarpFilters(warpMasks[i], hwQuery, sm, (DataRequestMonitor<IElementQuery>)new QueryRequestMonitor(queries, i, QueryProcessor.this.getExecutor(), (RequestMonitor)monitor));
                        }
                    }
                    catch (CudaException e) {
                        monitor.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                        monitor.done();
                    }
                    i = (short)(i + 1);
                }
            }
        });
    }

    private void getWarpFilters(long mask, IElementQuery query, StreamingMultiprocessor sm, DataRequestMonitor<IElementQuery> rm) {
        short warps = ((Device)DMContexts.getAncestorOfType((IDMContext)sm, Device.class)).getWarpCount();
        IElementQuery[] queries = new IElementQuery[warps];
        CountingRequestMonitor crm = this.gatherChildQueries(warps, rm, queries);
        short i = 0;
        while (i < warps) {
            try {
                if ((mask & 1L) == 0L || !query.match(sm.getWarp(i))) {
                    queries[i] = ElementQuery.NONE;
                    crm.done();
                } else {
                    this.getWarpFilter(sm.getWarp(i), query, new QueryRequestMonitor(queries, i, this.getExecutor(), (RequestMonitor)crm));
                }
            }
            catch (CudaException e) {
                crm.setStatus((IStatus)new Status(4, "com.nvidia.cuda.ide.debug", null, (Throwable)e));
                crm.done();
            }
            mask >>= 1;
            i = (short)(i + 1);
        }
    }

    private void getWarpFilter(Warp warp, IElementQuery query, QueryRequestMonitor rm) {
        this.threads.buildWarpQuery(warp, query, rm);
    }

    private CountingRequestMonitor gatherChildQueries(int count, DataRequestMonitor<IElementQuery> rm, IElementQuery[] queries) {
        CountingRequestMonitor crm = new CountingRequestMonitor(this.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, queries){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ IElementQuery[] val$queries;
            {
                this.val$rm = dataRequestMonitor;
                this.val$queries = iElementQueryArray;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$rm.setData((Object)ElementQuery.or(this.val$queries));
                this.val$rm.done();
            }
        };
        crm.setDoneCount(count);
        return crm;
    }

    protected void filter(Device[] devices, IElementQuery query, DataRequestMonitor<Device[]> rm) {
        ArrayList<Device> result = new ArrayList<Device>(devices.length);
        Device[] deviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            Device device = deviceArray[n2];
            if (query.match(device)) {
                result.add(device);
            }
            ++n2;
        }
        rm.setData((Object)result.toArray(new Device[result.size()]));
        rm.done();
    }

    protected void filter(Kernel[] kernels, IElementQuery query, DataRequestMonitor<Kernel[]> rm) {
        ArrayList<Kernel> result = new ArrayList<Kernel>(kernels.length);
        Kernel[] kernelArray = kernels;
        int n = kernels.length;
        int n2 = 0;
        while (n2 < n) {
            Kernel kernel = kernelArray[n2];
            if (query.match(kernel)) {
                result.add(kernel);
            }
            ++n2;
        }
        rm.setData((Object)result.toArray(new Kernel[result.size()]));
        rm.done();
    }

    public void invalidate() {
        this.swQueries.clear();
        this.hwQueries.clear();
    }

    private final class QueryRequestMonitor
    extends DataRequestMonitor<IElementQuery> {
        private final IElementQuery[] array;
        private final int ind;

        private QueryRequestMonitor(IElementQuery[] array, int ind, Executor executor, RequestMonitor rm) {
            super(executor, rm);
            this.array = array;
            this.ind = ind;
        }

        protected void handleSuccess() {
            this.array[this.ind] = (IElementQuery)this.getData();
            super.handleSuccess();
        }
    }
}

