/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitModelTree
extends GitModelObjectContainer {
    private final int kind;
    protected final IPath path;
    private GitModelObject[] children;

    public GitModelTree(GitModelObjectContainer parent, IPath fullPath, int kind) {
        super(parent);
        this.kind = kind;
        this.path = fullPath;
    }

    @Override
    public String getName() {
        return this.path.lastSegment();
    }

    @Override
    public IPath getLocation() {
        return this.path;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public int repositoryHashCode() {
        return this.getParent().repositoryHashCode();
    }

    @Override
    public GitModelObject[] getChildren() {
        return this.children;
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            GitModelObject[] gitModelObjectArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                GitModelObject object = gitModelObjectArray[n2];
                object.dispose();
                ++n2;
            }
            this.children = null;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getParent() == null ? 0 : ((Object)((Object)this.getParent())).hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GitModelTree other = (GitModelTree)((Object)obj);
        if (this.getParent() == null ? other.getParent() != null : !((Object)((Object)this.getParent())).equals((Object)other.getParent())) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    public String toString() {
        return "ModelTree[location=" + this.getLocation() + "]";
    }

    void setChildren(List<GitModelObject> children) {
        this.children = children.toArray(new GitModelObject[children.size()]);
    }
}

