/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseTransform;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;

public class QueryDefinitionUtil {
    private QueryDefinitionUtil() {
    }

    public static Map<String, IBinding> getAccessibleBindings(IBaseQueryDefinition qd) throws DataException {
        if (qd == null) {
            return null;
        }
        HashMap<String, IBinding> result = new HashMap<String, IBinding>(qd.getBindings());
        IBaseQueryDefinition parent = null;
        if (qd instanceof SubqueryDefinition) {
            parent = qd.getParentQuery();
        }
        while (parent != null) {
            Map parentBindings = parent.getBindings();
            Map<String, Boolean> aggrInfo = QueryDefinitionUtil.parseAggregations(parentBindings);
            for (String name : parentBindings.keySet()) {
                if (aggrInfo.get(name).booleanValue()) continue;
                IBinding b = (IBinding)parentBindings.get(name);
                if (result.containsKey(name)) continue;
                result.put(name, b);
            }
            if (!(parent instanceof SubqueryDefinition)) break;
            parent = parent.getParentQuery();
        }
        return result;
    }

    public static Map<String, Boolean> parseAggregations(Map<String, IBinding> input) throws DataException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Map.Entry<String, IBinding> entry : input.entrySet()) {
            IBinding binding = entry.getValue();
            HashSet<String> transitions = new HashSet<String>();
            transitions.add(binding.getBindingName());
            QueryDefinitionUtil.parseAggregation(binding, input, result, transitions);
        }
        return result;
    }

    private static boolean parseAggregation(IBinding binding, Map<String, IBinding> allBindings, Map<String, Boolean> checked, Set<String> transitions) throws DataException {
        String name = binding.getBindingName();
        if (checked.containsKey(name)) {
            return checked.get(name);
        }
        IBaseExpression expr = binding.getExpression();
        if (expr instanceof IScriptExpression && ExpressionUtil.hasAggregation((String)((IScriptExpression)expr).getText())) {
            checked.put(name, true);
            return true;
        }
        if (binding.getAggrFunction() != null) {
            checked.put(name, true);
            return true;
        }
        List referencedBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "row");
        for (String reference : referencedBindings) {
            if (transitions.contains(reference)) {
                throw new DataException("data.engine.ColumnBindingCycle", reference);
            }
            IBinding b = allBindings.get(reference);
            if (b == null) continue;
            HashSet<String> newTransitions = new HashSet<String>(transitions);
            newTransitions.add(reference);
            boolean isAggr = QueryDefinitionUtil.parseAggregation(b, allBindings, checked, newTransitions);
            if (!isAggr) continue;
            checked.put(name, true);
            return true;
        }
        checked.put(name, false);
        return false;
    }

    public static ISubqueryDefinition findSubQueryDefinition(String subQueryName, IBaseQueryDefinition queryDefn) throws DataException {
        if (queryDefn == null) {
            return null;
        }
        Collection subQueries = queryDefn.getSubqueries();
        ISubqueryDefinition subQueryDefn = null;
        if (subQueries != null && !subQueries.isEmpty()) {
            for (ISubqueryDefinition qd : subQueries) {
                if (qd.getName().equals(subQueryName)) {
                    return qd;
                }
                subQueryDefn = QueryDefinitionUtil.findSubQueryDefinition(subQueryName, qd);
            }
        }
        if (subQueryDefn == null && queryDefn.getGroups() != null) {
            List group = queryDefn.getGroups();
            int i = 0;
            while (i < group.size()) {
                Collection groupSubQueries = ((IBaseTransform)group.get(i)).getSubqueries();
                if (groupSubQueries != null && !groupSubQueries.isEmpty()) {
                    for (ISubqueryDefinition qd : groupSubQueries) {
                        if (qd.getName().equals(subQueryName)) {
                            return qd;
                        }
                        subQueryDefn = QueryDefinitionUtil.findSubQueryDefinition(subQueryName, qd);
                        if (subQueryDefn == null) continue;
                        return subQueryDefn;
                    }
                }
                ++i;
            }
        }
        return subQueryDefn;
    }
}

