/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.connection;

import com.nvidia.cuda.ide.remote.internal.connection.ShellOutputFilter;
import com.nvidia.cuda.ide.remote.internal.connection.StreamMonitor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;

public final class StdoutListener
extends ShellOutputFilter {
    private static final Pattern OUTPUT_END_PATTERN = Pattern.compile("<<<<< NSIGHT: (-?\\d*) >>>>>");
    private static final int SHELL_CONNECTION_LOST_TIMEOUT = 100;
    private Integer errorCode = null;
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private Long shellConnectionLostTimestamp = null;
    private final StreamMonitor streamMonitor = new StreamMonitor();

    public StdoutListener(IHostShell shell) {
        super(shell);
    }

    public StdoutListener(IShellService shellService, IProgressMonitor monitor) throws SystemMessageException {
        super(shellService, monitor);
    }

    private String extractReturnValue(String string) {
        Matcher matcher = OUTPUT_END_PATTERN.matcher(string);
        if (matcher.find()) {
            this.errorCode = Integer.valueOf(matcher.group(1));
            String s = "";
            if (matcher.start() > 0) {
                int start = matcher.start();
                s = String.valueOf(s) + string.substring(0, start);
            }
            if (matcher.end() < s.length()) {
                s = String.valueOf(s) + string.substring(matcher.end());
            }
            if (s.length() > 0) {
                return s;
            }
            return null;
        }
        return string;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public IStreamMonitor getStreamMonitor() {
        return this.streamMonitor;
    }

    @Override
    protected void inputEnd() {
        this.isDone.set(true);
    }

    public boolean isActive() {
        return !this.isDone.get() && this.isShellConnected();
    }

    @Override
    protected boolean isLastLine(String string) {
        return false;
    }

    private synchronized boolean isShellConnected() {
        if (this.getShell().isActive()) {
            return true;
        }
        if (this.errorCode != null) {
            return false;
        }
        if (this.shellConnectionLostTimestamp == null) {
            this.shellConnectionLostTimestamp = System.currentTimeMillis();
            return true;
        }
        long lastEventTimestamp = Math.max(this.lastMessageTimestamp.get(), this.shellConnectionLostTimestamp);
        return System.currentTimeMillis() - lastEventTimestamp < 100L;
    }

    @Override
    protected String postRunCommands(boolean rmMyself) {
        return "echo \"<<<<<\" NSIGHT: $? \">>>>>\";" + (rmMyself ? "rm -- $0" : "exit");
    }

    @Override
    protected void stringReceived(String string) {
        String output = this.extractReturnValue(string);
        if (output != null) {
            this.streamMonitor.append(String.valueOf(output) + "\n");
        }
    }
}

