/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.Activator;
import com.nvidia.viper.FileUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import java.io.File;
import org.eclipse.core.runtime.IPath;

public enum TemporaryDirs {
    launches("launch"),
    modules("module"),
    reports("report"),
    temp("temp"),
    execs("exec");

    private String dir;
    private int subfolders = 0;

    static {
        TemporaryDirs[] temporaryDirsArray = TemporaryDirs.values();
        int n = temporaryDirsArray.length;
        int n2 = 0;
        while (n2 < n) {
            TemporaryDirs location = temporaryDirsArray[n2];
            location.remove();
            ++n2;
        }
    }

    private TemporaryDirs(String dir) {
        this.dir = dir;
    }

    public synchronized IPath newSubfolder() throws ViperException {
        IPath loc;
        IPath launchState = Activator.getDefault().getStateLocation(this.dir);
        while ((loc = launchState.append(String.valueOf(this.subfolders++))).toFile().exists()) {
        }
        File dir = loc.toFile();
        dir.mkdirs();
        if (dir == null || !dir.exists()) {
            throw new ViperException("unable to create temporary store for launch");
        }
        return loc;
    }

    private void remove() {
        IPath ipath = Activator.getDefault().getStateLocation(this.dir);
        File dir = ipath.toFile();
        if (dir.exists()) {
            try {
                FileUtils.rmDir(dir);
            }
            catch (Exception e) {
                String error;
                String absDir = dir.getAbsolutePath();
                switch (this) {
                    case launches: {
                        error = "Unable to clean up launch directory (%s)";
                        break;
                    }
                    case modules: {
                        error = "Unable to clean up module directory (%s)";
                        break;
                    }
                    case reports: {
                        error = "Unable to clean up report generation directory (%s)";
                        break;
                    }
                    case temp: {
                        error = "Unable to clean up temp pdm directory (%s)";
                        break;
                    }
                    case execs: {
                        error = "Unable to clean up temp executable directory (%s)";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(this.name());
                    }
                }
                ViperExceptionHandler.logError(String.format(error, absDir), e);
            }
        }
    }
}

