/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.gdb.internal.eventbkpts;

import java.util.HashMap;
import java.util.Map;

public class GdbCatchpoints {
    private static final Map<String, String> sIdToKeyword = new HashMap<String, String>();

    static {
        sIdToKeyword.put("org.eclipse.cdt.debug.gdb.catch", "catch");
        sIdToKeyword.put("org.eclipse.cdt.debug.gdb.throw", "throw");
        sIdToKeyword.put("org.eclipse.cdt.debug.gdb.catch_exec", "exec");
        sIdToKeyword.put("org.eclipse.cdt.debug.gdb.catch_fork", "fork");
        sIdToKeyword.put("org.eclipse.cdt.debug.gdb.catch_vfork", "vfork");
        sIdToKeyword.put("org.eclipse.cdt.debug.gdb.catch_syscall", "syscall");
    }

    public static String eventToGdbCatchpointKeyword(String event) {
        String keyword = sIdToKeyword.get(event);
        assert (keyword != null) : "unexpected catchpoint event id";
        return keyword;
    }

    public static String gdbCatchpointKeywordToEvent(String keyword) {
        for (String eventId : sIdToKeyword.keySet()) {
            String thisKeyword = sIdToKeyword.get(eventId);
            if (!thisKeyword.equals(keyword)) continue;
            return eventId;
        }
        return null;
    }
}

