/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.core.RemoteServices;
import org.eclipse.remote.internal.ui.RemoteUIPlugin;
import org.eclipse.remote.internal.ui.RemoteUIServicesDescriptor;
import org.eclipse.remote.internal.ui.messages.Messages;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.ui.PlatformUI;

public class RemoteUIServices {
    private static final String EXTENSION_POINT_ID = "remoteUIServices";
    private static Map<String, RemoteUIServicesDescriptor> fRemoteUIServices = null;
    private static Map<String, IRemoteServices> fRemoteServices = new HashMap<String, IRemoteServices>();

    public static IRemoteServices getRemoteServices(final String id, IRunnableContext context) {
        IRemoteServices service = fRemoteServices.get(id);
        if (service == null) {
            final IRemoteServices[] remoteService = new IRemoteServices[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.RemoteUIServices_Configuring_remote_services, 10);
                    remoteService[0] = RemoteServices.getRemoteServices((String)id, (IProgressMonitor)monitor);
                }
            };
            try {
                if (context != null) {
                    context.run(true, false, runnable);
                } else {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
            service = remoteService[0];
            if (service != null) {
                fRemoteServices.put(id, service);
            }
        }
        return service;
    }

    public static IRemoteUIServices getRemoteUIServices(IRemoteServices services) {
        RemoteUIServicesDescriptor descriptor;
        if (fRemoteUIServices == null) {
            fRemoteUIServices = RemoteUIServices.retrieveRemoteUIServices();
        }
        if ((descriptor = fRemoteUIServices.get(services.getId())) != null) {
            return descriptor.getUIServices(services);
        }
        return null;
    }

    private static Map<String, RemoteUIServicesDescriptor> retrieveRemoteUIServices() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(RemoteUIPlugin.getUniqueIdentifier(), EXTENSION_POINT_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        HashMap<String, RemoteUIServicesDescriptor> services = new HashMap<String, RemoteUIServicesDescriptor>(5);
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = ext.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                RemoteUIServicesDescriptor descriptor = new RemoteUIServicesDescriptor(ce);
                services.put(descriptor.getId(), descriptor);
                ++n4;
            }
            ++n2;
        }
        return services;
    }
}

