/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.language.settings.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.AbstractExecutableExtensionBase;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsStorage;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.internal.core.settings.model.SettingsModelMessages;
import org.eclipse.core.resources.IResource;

public class LanguageSettingsBaseProvider
extends AbstractExecutableExtensionBase
implements ILanguageSettingsProvider {
    protected List<String> languageScope = null;
    protected Map<String, String> properties = new HashMap<String, String>();
    private List<ICLanguageSettingEntry> entries = null;

    public LanguageSettingsBaseProvider() {
    }

    public LanguageSettingsBaseProvider(String id, String name) {
        super(id, name);
    }

    public LanguageSettingsBaseProvider(String id, String name, List<String> languages, List<ICLanguageSettingEntry> entries) {
        super(id, name);
        this.languageScope = languages != null ? new ArrayList<String>(languages) : null;
        this.entries = this.getPooledList(entries);
    }

    public LanguageSettingsBaseProvider(String id, String name, List<String> languages, List<ICLanguageSettingEntry> entries, Map<String, String> properties) {
        super(id, name);
        this.languageScope = languages != null ? new ArrayList<String>(languages) : null;
        this.entries = this.getPooledList(entries);
        if (properties != null) {
            this.properties = new HashMap<String, String>(properties);
        }
    }

    public void configureProvider(String id, String name, List<String> languages, List<ICLanguageSettingEntry> entries, Map<String, String> properties) {
        if (this.entries != null || !this.properties.isEmpty()) {
            throw new UnsupportedOperationException(SettingsModelMessages.getString("LanguageSettingsBaseProvider.CanBeConfiguredOnlyOnce"));
        }
        this.setId(id);
        this.setName(name);
        this.languageScope = languages != null ? new ArrayList<String>(languages) : null;
        this.entries = this.getPooledList(entries);
        if (properties != null) {
            this.properties = new HashMap<String, String>(properties);
        }
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public boolean getPropertyBool(String key) {
        return Boolean.parseBoolean(this.properties.get(key));
    }

    private List<ICLanguageSettingEntry> getPooledList(List<ICLanguageSettingEntry> entries) {
        if (entries != null) {
            return LanguageSettingsStorage.getPooledList(entries);
        }
        return null;
    }

    @Override
    public List<ICLanguageSettingEntry> getSettingEntries(ICConfigurationDescription cfgDescription, IResource rc, String languageId) {
        if (this.languageScope == null) {
            return this.entries;
        }
        for (String lang : this.languageScope) {
            if (!lang.equals(languageId)) continue;
            return this.entries;
        }
        return null;
    }

    public List<String> getLanguageScope() {
        if (this.languageScope == null) {
            return null;
        }
        return Collections.unmodifiableList(this.languageScope);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        result = 31 * result + (this.languageScope == null ? 0 : this.languageScope.hashCode());
        result = 31 * result + this.getClass().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageSettingsBaseProvider other = (LanguageSettingsBaseProvider)obj;
        String id = this.getId();
        String otherId = other.getId();
        if (id == null ? otherId != null : !id.equals(otherId)) {
            return false;
        }
        String name = this.getName();
        String otherName = other.getName();
        if (name == null ? otherName != null : !name.equals(otherName)) {
            return false;
        }
        if (this.entries == null ? other.entries != null : !this.entries.equals(other.entries)) {
            return false;
        }
        if (this.languageScope == null ? other.languageScope != null : !this.languageScope.equals(other.languageScope)) {
            return false;
        }
        if (this.properties == null) {
            if (other.properties != null) {
                return false;
            }
        } else {
            if (other.properties == null) {
                return false;
            }
            HashSet<String> keys = new HashSet<String>(this.properties.keySet());
            keys.addAll(other.properties.keySet());
            for (String key : keys) {
                String otherValue;
                String value = this.properties.get(key);
                if (value == null || value.equals(Boolean.FALSE.toString())) {
                    value = "";
                }
                if ((otherValue = other.properties.get(key)) == null || otherValue.equals(Boolean.FALSE.toString())) {
                    otherValue = "";
                }
                if (value.equals(otherValue)) continue;
                return false;
            }
        }
        return true;
    }
}

